'''
finhack trader run --strategy=MyIndexStrategy --cash=30000000
'''
import datetime
import os
import random
from finhack.factor.default.factorManager import factorManager
from finhack.market.astock.astock import AStock
## 初始化函数，设定要操作的股票、基准等等
def initialize(context):
    # 设定沪深300作为基准
    set_benchmark('000001.SH')
    # True为开启动态复权模式，使用真实价格交易
    set_option('use_real_price', True) 
    # 设定成交量比例
    set_option('order_volume_ratio', 1)
    # # 股票类交易手续费是：买入时佣金万分之三，卖出时佣金万分之三加千分之一印花税, 每笔交易佣金最低扣5块钱
    set_order_cost(OrderCost(open_tax=0, close_tax=0.001, \
                             open_commission=0.0003, close_commission=0.0003,\
                             close_today_commission=0, min_commission=5), type='stock')
    
    # 为股票设定滑点为百分比滑点                       
    set_slippage(PriceRelatedSlippage(0.00246),type='stock')

    run_daily(trade, time="09:30")
    # run_daily(trade, time="8:05")
    log.info('get code list')

## 交易函数
def trade(context):
    
    
    
    
    
    my_list=['300787.SZ', '002136.SZ', '688310.SH', '003030.SZ', '688168.SH', '002539.SZ', '002399.SZ', '002686.SZ', '600611.SH', '688056.SH', '300370.SZ', '300258.SZ', '839680.BJ', '688299.SH', '002037.SZ', '688555.SH', '300389.SZ', '833346.BJ', '836270.BJ', '832023.BJ', '600695.SH', '836149.BJ', '300508.SZ', '600691.SH', '836717.BJ', '603569.SH', '300138.SZ', '688309.SH', '601233.SH', '000739.SZ', '300108.SZ', '600743.SH', '300935.SZ', '835185.BJ', '830839.BJ', '831768.BJ', '430510.BJ', '300971.SZ', '300038.SZ', '871396.BJ', '688105.SH', '000023.SZ', '002006.SZ', '873223.BJ', '300441.SZ', '600847.SH', '002462.SZ', '688588.SH', '002115.SZ', '300242.SZ', '300384.SZ', '002342.SZ', '688300.SH', '002274.SZ', '300226.SZ', '835508.BJ', '688511.SH', '836942.BJ', '688385.SH', '688199.SH', '873833.BJ', '831087.BJ', '600205.SH', '002452.SZ', '603096.SH', '688287.SH', '600501.SH', '430017.BJ', '831445.BJ', '000034.SZ', '300023.SZ', '300290.SZ', '688380.SH', '000975.SZ', '300599.SZ', '688728.SH', '603229.SH', '301073.SZ', '688298.SH', '300347.SZ', '300360.SZ', '835640.BJ', '002388.SZ', '300809.SZ', '688596.SH', '300059.SZ', '688100.SH', '833819.BJ', '002903.SZ', '300587.SZ', '300340.SZ', '688112.SH', '837046.BJ', '000971.SZ', '832145.BJ', '000906.SZ', '832089.BJ', '601838.SH', '430300.BJ', '688597.SH', '000701.SZ', '300554.SZ', '836260.BJ', '000301.SZ', '688225.SH', '831627.BJ', '603603.SH', '300177.SZ', '300372.SZ', '300884.SZ', '300950.SZ', '300016.SZ', '600851.SH', '688051.SH', '002210.SZ', '688010.SH', '603626.SH', '300871.SZ', '300270.SZ', '688700.SH', '301055.SZ', '300639.SZ', '600830.SH', '300217.SZ', '002249.SZ', '688018.SH', '838701.BJ', '603025.SH', '300099.SZ', '830799.BJ', '688179.SH', '300889.SZ', '688308.SH', '688669.SH', '838030.BJ', '834058.BJ', '300621.SZ', '603319.SH', '688282.SH', '300936.SZ', '688079.SH', '688317.SH', '870866.BJ', '430476.BJ', '600962.SH', '002365.SZ', '836422.BJ', '000860.SZ', '688001.SH', '831834.BJ', '603195.SH', '835179.BJ', '688459.SH', '000403.SZ', '688103.SH', '836957.BJ', '600331.SH', '002680.SZ', '835368.BJ', '300021.SZ', '600613.SH', '832978.BJ', '300518.SZ', '688137.SH', '688305.SH', '688096.SH', '835892.BJ', '000606.SZ', '300236.SZ', '688665.SH', '688093.SH', '300157.SZ', '872190.BJ', '835985.BJ', '836871.BJ', '833454.BJ', '001872.SZ', '600208.SH', '688337.SH', '688312.SH', '600075.SH', '830832.BJ', '300390.SZ', '688301.SH', '002567.SZ', '600237.SH', '002613.SZ', '600388.SH', '688505.SH', '688381.SH', '600560.SH', '300165.SZ', '000672.SZ', '831039.BJ', '688129.SH', '600751.SH', '601299.SH', '838670.BJ', '300494.SZ', '688655.SH', '872953.BJ', '601339.SH', '837663.BJ', '873703.BJ', '300240.SZ', '688399.SH', '688178.SH', '000778.SZ', '833914.BJ', '688215.SH', '301252.SZ', '002066.SZ', '300635.SZ', '300677.SZ', '688314.SH', '300329.SZ', '688479.SH', '300139.SZ', '002406.SZ', '688660.SH', '301439.SZ', '834261.BJ', '688033.SH', '831370.BJ', '688020.SH', '870726.BJ', '688075.SH', '833781.BJ', '688233.SH', '000736.SZ', '301042.SZ', '600361.SH', '688533.SH', '688067.SH', '430198.BJ', '601882.SH', '300513.SZ', '600750.SH', '835305.BJ', '688367.SH', '830809.BJ', '000541.SZ', '300421.SZ', '688126.SH', '873167.BJ', '300426.SZ', '300552.SZ', '688778.SH', '300293.SZ', '300235.SZ', '300202.SZ', '832735.BJ', '300984.SZ', '688696.SH', '300848.SZ', '600439.SH', '836414.BJ', '832110.BJ', '000782.SZ', '300036.SZ', '003013.SZ', '838171.BJ', '688143.SH', '603698.SH', '300158.SZ', '300003.SZ', '688138.SH', '000501.SZ', '300758.SZ', '833171.BJ', '600817.SH', '300145.SZ', '688522.SH', '834599.BJ', '870204.BJ', '688039.SH', '688005.SH', '688551.SH', '601558.SH', '300420.SZ', '300245.SZ', '688139.SH', '600387.SH', '838262.BJ', '300106.SZ', '833284.BJ', '300573.SZ', '872351.BJ', '600309.SH', '300423.SZ', '300753.SZ', '688078.SH', '300625.SZ', '831726.BJ', '832471.BJ', '832885.BJ', '430418.BJ', '300375.SZ', '002473.SZ', '002464.SZ']
    
    
    for code in my_list:
        if not code in list(context.portfolio.positions.keys()):
            order_value(code, 100000)
