"""
    Firefly III API Client

    This is the Python client for Firefly III API  # noqa: E501

    The version of the OpenAPI document: 1.5.6
    Contact: james@firefly-iii.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from firefly_iii_client.api_client import ApiClient, Endpoint as _Endpoint
from firefly_iii_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from firefly_iii_client.model.insight_group import InsightGroup
from firefly_iii_client.model.insight_total import InsightTotal
from firefly_iii_client.model.insight_transfer import InsightTransfer


class InsightApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.insight_expense_asset_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/expense/asset',
                'operation_id': 'insight_expense_asset',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_expense_bill_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/expense/bill',
                'operation_id': 'insight_expense_bill',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'bills',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'bills':
                        ([int],),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'bills': 'bills[]',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'bills': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'bills': 'multi',
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_expense_budget_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/expense/budget',
                'operation_id': 'insight_expense_budget',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'budgets',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'budgets':
                        ([int],),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'budgets': 'budgets[]',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'budgets': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'budgets': 'multi',
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_expense_category_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/expense/category',
                'operation_id': 'insight_expense_category',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'categories',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'categories':
                        ([int],),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'categories': 'categories[]',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'categories': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'categories': 'multi',
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_expense_expense_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/expense/expense',
                'operation_id': 'insight_expense_expense',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_expense_no_bill_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTotal,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/expense/no-bill',
                'operation_id': 'insight_expense_no_bill',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_expense_no_budget_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTotal,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/expense/no-budget',
                'operation_id': 'insight_expense_no_budget',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_expense_no_category_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTotal,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/expense/no-category',
                'operation_id': 'insight_expense_no_category',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_expense_no_tag_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTotal,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/expense/no-tag',
                'operation_id': 'insight_expense_no_tag',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_expense_tag_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/expense/tag',
                'operation_id': 'insight_expense_tag',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'tags',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'tags':
                        ([int],),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'tags': 'tags[]',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'tags': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'tags': 'multi',
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_expense_total_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTotal,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/expense/total',
                'operation_id': 'insight_expense_total',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_income_asset_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/income/asset',
                'operation_id': 'insight_income_asset',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_income_category_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/income/category',
                'operation_id': 'insight_income_category',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'categories',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'categories':
                        ([int],),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'categories': 'categories[]',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'categories': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'categories': 'multi',
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_income_no_category_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTotal,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/income/no-category',
                'operation_id': 'insight_income_no_category',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_income_no_tag_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTotal,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/income/no-tag',
                'operation_id': 'insight_income_no_tag',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_income_revenue_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/income/revenue',
                'operation_id': 'insight_income_revenue',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_income_tag_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/income/tag',
                'operation_id': 'insight_income_tag',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'tags',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'tags':
                        ([int],),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'tags': 'tags[]',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'tags': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'tags': 'multi',
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_income_total_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTotal,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/income/total',
                'operation_id': 'insight_income_total',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_transfer_category_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/transfer/category',
                'operation_id': 'insight_transfer_category',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'categories',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'categories':
                        ([int],),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'categories': 'categories[]',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'categories': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'categories': 'multi',
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_transfer_no_category_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTotal,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/transfer/no-category',
                'operation_id': 'insight_transfer_no_category',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_transfer_no_tag_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTotal,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/transfer/no-tag',
                'operation_id': 'insight_transfer_no_tag',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_transfer_tag_endpoint = _Endpoint(
            settings={
                'response_type': (InsightGroup,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/transfer/tag',
                'operation_id': 'insight_transfer_tag',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'tags',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'tags':
                        ([int],),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'tags': 'tags[]',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'tags': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'tags': 'multi',
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_transfer_total_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTotal,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/transfer/total',
                'operation_id': 'insight_transfer_total',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insight_transfers_endpoint = _Endpoint(
            settings={
                'response_type': (InsightTransfer,),
                'auth': [
                    'firefly_iii_auth'
                ],
                'endpoint_path': '/api/v1/insight/transfer/asset',
                'operation_id': 'insight_transfers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'accounts',
                ],
                'required': [
                    'start',
                    'end',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (date,),
                    'end':
                        (date,),
                    'accounts':
                        ([int],),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'accounts': 'accounts[]',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'accounts': 'query',
                },
                'collection_format_map': {
                    'accounts': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def insight_expense_asset(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into expenses, grouped by asset account.  # noqa: E501

        This endpoint gives a summary of the expenses made by the user, grouped by asset account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_expense_asset(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only withdrawals from those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_expense_asset_endpoint.call_with_http_info(**kwargs)

    def insight_expense_bill(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into expenses, grouped by bill.  # noqa: E501

        This endpoint gives a summary of the expenses made by the user, grouped by (any) bill.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_expense_bill(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            bills ([int]): The bills to be included in the results. . [optional]
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only withdrawals from those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_expense_bill_endpoint.call_with_http_info(**kwargs)

    def insight_expense_budget(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into expenses, grouped by budget.  # noqa: E501

        This endpoint gives a summary of the expenses made by the user, grouped by (any) budget.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_expense_budget(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            budgets ([int]): The budgets to be included in the results. . [optional]
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only withdrawals from those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_expense_budget_endpoint.call_with_http_info(**kwargs)

    def insight_expense_category(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into expenses, grouped by category.  # noqa: E501

        This endpoint gives a summary of the expenses made by the user, grouped by (any) category.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_expense_category(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            categories ([int]): The categories to be included in the results. . [optional]
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only withdrawals from those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_expense_category_endpoint.call_with_http_info(**kwargs)

    def insight_expense_expense(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into expenses, grouped by expense account.  # noqa: E501

        This endpoint gives a summary of the expenses made by the user, grouped by expense account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_expense_expense(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you add the accounts ID's of expense accounts, only those accounts are included in the results. If you include ID's of asset accounts or liabilities, only withdrawals from those asset accounts / liabilities will be included. You can combine both asset / liability and expense account ID's. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_expense_expense_endpoint.call_with_http_info(**kwargs)

    def insight_expense_no_bill(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into expenses, without bill.  # noqa: E501

        This endpoint gives a summary of the expenses made by the user, including only expenses with no bill.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_expense_no_bill(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only withdrawals from those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTotal
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_expense_no_bill_endpoint.call_with_http_info(**kwargs)

    def insight_expense_no_budget(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into expenses, without budget.  # noqa: E501

        This endpoint gives a summary of the expenses made by the user, including only expenses with no budget.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_expense_no_budget(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only withdrawals from those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTotal
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_expense_no_budget_endpoint.call_with_http_info(**kwargs)

    def insight_expense_no_category(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into expenses, without category.  # noqa: E501

        This endpoint gives a summary of the expenses made by the user, including only expenses with no category.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_expense_no_category(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only withdrawals from those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTotal
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_expense_no_category_endpoint.call_with_http_info(**kwargs)

    def insight_expense_no_tag(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into expenses, without tag.  # noqa: E501

        This endpoint gives a summary of the expenses made by the user, including only expenses with no tag.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_expense_no_tag(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only withdrawals from those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTotal
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_expense_no_tag_endpoint.call_with_http_info(**kwargs)

    def insight_expense_tag(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into expenses, grouped by tag.  # noqa: E501

        This endpoint gives a summary of the expenses made by the user, grouped by (any) tag.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_expense_tag(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            tags ([int]): The tags to be included in the results. . [optional]
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only withdrawals from those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_expense_tag_endpoint.call_with_http_info(**kwargs)

    def insight_expense_total(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into total expenses.  # noqa: E501

        This endpoint gives a sum of the total expenses made by the user.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_expense_total(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only withdrawals from those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTotal
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_expense_total_endpoint.call_with_http_info(**kwargs)

    def insight_income_asset(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into income, grouped by asset account.  # noqa: E501

        This endpoint gives a summary of the income received by the user, grouped by asset account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_income_asset(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only deposits to those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_income_asset_endpoint.call_with_http_info(**kwargs)

    def insight_income_category(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into income, grouped by category.  # noqa: E501

        This endpoint gives a summary of the income received by the user, grouped by (any) category.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_income_category(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            categories ([int]): The categories to be included in the results. . [optional]
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only deposits to those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_income_category_endpoint.call_with_http_info(**kwargs)

    def insight_income_no_category(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into income, without category.  # noqa: E501

        This endpoint gives a summary of the income received by the user, including only income with no category.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_income_no_category(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only deposits to those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTotal
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_income_no_category_endpoint.call_with_http_info(**kwargs)

    def insight_income_no_tag(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into income, without tag.  # noqa: E501

        This endpoint gives a summary of the income received by the user, including only income with no tag.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_income_no_tag(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only deposits to those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTotal
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_income_no_tag_endpoint.call_with_http_info(**kwargs)

    def insight_income_revenue(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into income, grouped by revenue account.  # noqa: E501

        This endpoint gives a summary of the income received by the user, grouped by revenue account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_income_revenue(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you add the accounts ID's of revenue accounts, only those accounts are included in the results. If you include ID's of asset accounts or liabilities, only deposits to those asset accounts / liabilities will be included. You can combine both asset / liability and deposit account ID's. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_income_revenue_endpoint.call_with_http_info(**kwargs)

    def insight_income_tag(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into income, grouped by tag.  # noqa: E501

        This endpoint gives a summary of the income received by the user, grouped by (any) tag.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_income_tag(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            tags ([int]): The tags to be included in the results. . [optional]
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only deposits to those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_income_tag_endpoint.call_with_http_info(**kwargs)

    def insight_income_total(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into total income.  # noqa: E501

        This endpoint gives a sum of the total income received by the user.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_income_total(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only deposits to those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTotal
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_income_total_endpoint.call_with_http_info(**kwargs)

    def insight_transfer_category(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into transfers, grouped by category.  # noqa: E501

        This endpoint gives a summary of the transfers made by the user, grouped by (any) category.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_transfer_category(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            categories ([int]): The categories to be included in the results. . [optional]
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only transfers between those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_transfer_category_endpoint.call_with_http_info(**kwargs)

    def insight_transfer_no_category(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into transfers, without category.  # noqa: E501

        This endpoint gives a summary of the transfers made by the user, including only transfers with no category.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_transfer_no_category(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only transfers between those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTotal
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_transfer_no_category_endpoint.call_with_http_info(**kwargs)

    def insight_transfer_no_tag(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into expenses, without tag.  # noqa: E501

        This endpoint gives a summary of the transfers made by the user, including only transfers with no tag.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_transfer_no_tag(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only transfers from those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTotal
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_transfer_no_tag_endpoint.call_with_http_info(**kwargs)

    def insight_transfer_tag(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into transfers, grouped by tag.  # noqa: E501

        This endpoint gives a summary of the transfers created by the user, grouped by (any) tag.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_transfer_tag(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            tags ([int]): The tags to be included in the results. . [optional]
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only transfers between those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_transfer_tag_endpoint.call_with_http_info(**kwargs)

    def insight_transfer_total(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into total transfers.  # noqa: E501

        This endpoint gives a sum of the total amount transfers made by the user.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_transfer_total(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only transfers between those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTotal
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_transfer_total_endpoint.call_with_http_info(**kwargs)

    def insight_transfers(
        self,
        start,
        end,
        **kwargs
    ):
        """Insight into transfers, grouped by account.  # noqa: E501

        This endpoint gives a summary of the transfers made by the user, grouped by asset account or lability.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insight_transfers(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (date): A date formatted YYYY-MM-DD. 
            end (date): A date formatted YYYY-MM-DD. 

        Keyword Args:
            accounts ([int]): The accounts to be included in the results. If you include ID's of asset accounts or liabilities, only transfers between those asset accounts / liabilities will be included. Other account ID's will be ignored. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InsightTransfer
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start'] = \
            start
        kwargs['end'] = \
            end
        return self.insight_transfers_endpoint.call_with_http_info(**kwargs)

