# -*- coding: utf-8 -*-

"""
firstlanguage_python

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import os
from firstlanguage_python.utilities.schema_validator_wrapper import SchemaValidatorWrapper
from jsonschema import ValidationError
from firstlanguage_python.api_helper import APIHelper


class Input16(object):

    """Implementation of the 'Input16' model.

    TODO: type model description here.

    Attributes:
        lang (string): Allowed language code. Refer Allowed languages
            section.
        content_type (string): Allowed values are:html,plaintext, pdf, docx If
            html is specified all html tags and special characters will be
            stripped before processing. For PDF and docx, all text will be
            read. Scanned documents will not work.
        url (string): Text from this URL will be read and a translation
            generated
        preserve_format (string): Accepted values are true, false.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "lang": 'lang',
        "content_type": 'contentType',
        "url": 'url',
        "preserve_format": 'preserveFormat'
    }

    def __init__(self,
                 lang=None,
                 content_type=None,
                 url=None,
                 preserve_format=None):
        """Constructor for the Input16 class"""

        # Initialize members of the class
        self.lang = lang
        self.content_type = content_type
        self.url = url
        self.preserve_format = preserve_format

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        lang = dictionary.get('lang')
        content_type = dictionary.get('contentType')
        url = dictionary.get('url')
        preserve_format = dictionary.get('preserveFormat')

        # Return an object of this model
        return cls(lang,
                   content_type,
                   url,
                   preserve_format)

    @classmethod
    def validate(cls, val):
        """Validates value against class schema

        Args:
            val: the value to be validated

        Returns:
            boolean : if value is valid against schema.

        """
        return SchemaValidatorWrapper.getValidator(APIHelper.get_schema_path(os.path.abspath(__file__))).is_valid(val)
