# -*- coding: utf-8 -*-

"""
firstlanguage_python

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import os
from firstlanguage_python.utilities.schema_validator_wrapper import SchemaValidatorWrapper
from jsonschema import ValidationError
from firstlanguage_python.api_helper import APIHelper


class Input1(object):

    """Implementation of the 'Input1' model.

    Text for processing will be read from the given URL. Only HTML pages or
    text pages will be processed at this time.

    Attributes:
        url (string): URL where the content is hosted.
        lang (string): Allowed language code. Refer Allowed languages
            section.
        content_type (string): Allowed values or html or text. If html is
            specified all html tags and special characters will be stripped
            before processing.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "url": 'url',
        "lang": 'lang',
        "content_type": 'contentType'
    }

    def __init__(self,
                 url=None,
                 lang=None,
                 content_type=None):
        """Constructor for the Input1 class"""

        # Initialize members of the class
        self.url = url
        self.lang = lang
        self.content_type = content_type

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        url = dictionary.get('url')
        lang = dictionary.get('lang')
        content_type = dictionary.get('contentType')

        # Return an object of this model
        return cls(url,
                   lang,
                   content_type)

    @classmethod
    def validate(cls, val):
        """Validates value against class schema

        Args:
            val: the value to be validated

        Returns:
            boolean : if value is valid against schema.

        """
        return SchemaValidatorWrapper.getValidator(APIHelper.get_schema_path(os.path.abspath(__file__))).is_valid(val)
