# -*- coding: utf-8 -*-

"""
firstlanguage_python

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import os
from firstlanguage_python.utilities.schema_validator_wrapper import SchemaValidatorWrapper
from jsonschema import ValidationError
from firstlanguage_python.api_helper import APIHelper


class Input6(object):

    """Implementation of the 'Input6' model.

    TODO: type model description here.

    Attributes:
        question (string): Question to be answered from the context given.
            Only One question can be asked at a time. Special characters will
            not be stripped.
        lang (string): Allowed language code. Refer Allowed languages
            section.
        content_type (string): Allowed values or html or text. If html is
            specified all html tags and special characters will be stripped
            before processing.
        url (string): URL where the context for the question is stored.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "question": 'question',
        "lang": 'lang',
        "content_type": 'contentType',
        "url": 'url'
    }

    def __init__(self,
                 question=None,
                 lang=None,
                 content_type=None,
                 url=None):
        """Constructor for the Input6 class"""

        # Initialize members of the class
        self.question = question
        self.lang = lang
        self.content_type = content_type
        self.url = url

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        question = dictionary.get('question')
        lang = dictionary.get('lang')
        content_type = dictionary.get('contentType')
        url = dictionary.get('url')

        # Return an object of this model
        return cls(question,
                   lang,
                   content_type,
                   url)

    @classmethod
    def validate(cls, val):
        """Validates value against class schema

        Args:
            val: the value to be validated

        Returns:
            boolean : if value is valid against schema.

        """
        return SchemaValidatorWrapper.getValidator(APIHelper.get_schema_path(os.path.abspath(__file__))).is_valid(val)
