from tests.util import BaseTest


class Test_CSM130(BaseTest):
    def error_code(self) -> str:
        return "CSM130"

    def test_pass_1(self):
        code = """
        class Foo:
            def bar(self):
                pass
            
            @staticmethod
            def baz():
                pass
        """
        result = self.run_flake8(code)
        assert result == []

    def test_fail_1(self):
        code = """
        class Foo:
            @classmethod
            def bar(cls):
                pass
        """
        result = self.run_flake8(code)
        self.assert_error_at(result, "CSM130", 4, 5)
