# Badge Patterns Reference

Common shields.io badge patterns organized by technology and use case.

## Badge Format

```
https://img.shields.io/badge/{LABEL}-{MESSAGE}-{COLOR}?style=flat
```

**Encoding rules:**
- Spaces → `%20` or `-`
- Dashes in message → `--` (double dash)
- Underscores remain as `_`

## Status Badges

```markdown
![Status](https://img.shields.io/badge/Status-Stable-brightgreen?style=flat)
![Status](https://img.shields.io/badge/Status-Beta-yellow?style=flat)
![Status](https://img.shields.io/badge/Status-Alpha-orange?style=flat)
![Status](https://img.shields.io/badge/Status-Preview-purple?style=flat)
![Status](https://img.shields.io/badge/Status-Experimental-red?style=flat)
![Status](https://img.shields.io/badge/Status-Deprecated-lightgrey?style=flat)
![Status](https://img.shields.io/badge/Status-Archived-inactive?style=flat)
```

## Minecraft Ecosystem

### Minecraft Versions

```markdown
![Minecraft](https://img.shields.io/badge/Minecraft-1.21.10-0ea5e9?style=flat)
![Minecraft](https://img.shields.io/badge/Minecraft-1.20.1-0ea5e9?style=flat)
![Minecraft](https://img.shields.io/badge/Minecraft-1.19.4-0ea5e9?style=flat)
```

### Fabric

```markdown
![Fabric Loader](https://img.shields.io/badge/Fabric%20Loader-0.17.3+-f59e0b?style=flat)
![Fabric API](https://img.shields.io/badge/Fabric%20API-0.100.0+-f59e0b?style=flat)
```

### Forge

```markdown
![Forge](https://img.shields.io/badge/Forge-47.0.0+-1976d2?style=flat)
```

### Minecraft Dependencies

```markdown
![Meteor Client](https://img.shields.io/badge/Meteor%20Client-1.21.10--32-ec4899?style=flat)
![Sodium](https://img.shields.io/badge/Sodium-0.5.0+-6366f1?style=flat)
![Iris](https://img.shields.io/badge/Iris-1.6.0+-5b21b6?style=flat)
```

## Programming Languages

### Java

```markdown
![Java](https://img.shields.io/badge/Java-21-orange?style=flat)
![Java](https://img.shields.io/badge/Java-17+-007396?style=flat)
![Java](https://img.shields.io/badge/Java-11-orange?style=flat)
```

### JavaScript/TypeScript

```markdown
![Node.js](https://img.shields.io/badge/Node.js-18+-339933?style=flat)
![Node.js](https://img.shields.io/badge/Node.js-20.0.0-339933?style=flat)
![TypeScript](https://img.shields.io/badge/TypeScript-5.0+-3178c6?style=flat)
![JavaScript](https://img.shields.io/badge/JavaScript-ES2020-f7df1e?style=flat)
```

### Python

```markdown
![Python](https://img.shields.io/badge/Python-3.11+-3776ab?style=flat)
![Python](https://img.shields.io/badge/Python-3.9%7C3.10%7C3.11-3776ab?style=flat)
```

### C/C++

```markdown
![C++](https://img.shields.io/badge/C++-17-00599c?style=flat)
![C](https://img.shields.io/badge/C-99-a8b9cc?style=flat)
```

### Rust

```markdown
![Rust](https://img.shields.io/badge/Rust-1.70+-ce422b?style=flat)
```

### Go

```markdown
![Go](https://img.shields.io/badge/Go-1.21+-00add8?style=flat)
```

### C#

```markdown
![C#](https://img.shields.io/badge/C%23-12-239120?style=flat)
![.NET](https://img.shields.io/badge/.NET-8.0-512bd4?style=flat)
```

## Frameworks & Libraries

### Frontend Frameworks

```markdown
![React](https://img.shields.io/badge/React-18.0+-61dafb?style=flat)
![Vue](https://img.shields.io/badge/Vue-3.0+-4fc08d?style=flat)
![Angular](https://img.shields.io/badge/Angular-17+-dd0031?style=flat)
![Svelte](https://img.shields.io/badge/Svelte-4.0+-ff3e00?style=flat)
```

### Build Tools

```markdown
![Vite](https://img.shields.io/badge/Vite-5.0+-646cff?style=flat)
![Webpack](https://img.shields.io/badge/Webpack-5.0+-8dd6f9?style=flat)
![Gradle](https://img.shields.io/badge/Gradle-8.0+-02303a?style=flat)
![Maven](https://img.shields.io/badge/Maven-3.9+-c71a36?style=flat)
```

### Backend Frameworks

```markdown
![Express](https://img.shields.io/badge/Express-4.18+-000000?style=flat)
![FastAPI](https://img.shields.io/badge/FastAPI-0.100+-009688?style=flat)
![Spring Boot](https://img.shields.io/badge/Spring%20Boot-3.0+-6db33f?style=flat)
```

### Electron

```markdown
![Electron](https://img.shields.io/badge/Electron-28.0+-47848f?style=flat)
```

## Databases

```markdown
![PostgreSQL](https://img.shields.io/badge/PostgreSQL-15+-336791?style=flat)
![MongoDB](https://img.shields.io/badge/MongoDB-7.0+-47a248?style=flat)
![Redis](https://img.shields.io/badge/Redis-7.0+-dc382d?style=flat)
![SQLite](https://img.shields.io/badge/SQLite-3.40+-003b57?style=flat)
```

## Platforms

### Operating Systems

```markdown
![Windows](https://img.shields.io/badge/Windows-10+-0078d4?style=flat)
![macOS](https://img.shields.io/badge/macOS-11+-000000?style=flat)
![Linux](https://img.shields.io/badge/Linux-Ubuntu%2020.04+-dd4814?style=flat)
```

### Cloud Platforms

```markdown
![AWS](https://img.shields.io/badge/AWS-Lambda-ff9900?style=flat)
![Google Cloud](https://img.shields.io/badge/Google%20Cloud-Run-4285f4?style=flat)
![Azure](https://img.shields.io/badge/Azure-Functions-0078d4?style=flat)
```

## Testing

```markdown
![Jest](https://img.shields.io/badge/Jest-29.0+-c21325?style=flat)
![Pytest](https://img.shields.io/badge/Pytest-7.0+-0a9edc?style=flat)
![JUnit](https://img.shields.io/badge/JUnit-5-25a162?style=flat)
![Vitest](https://img.shields.io/badge/Vitest-1.0+-6e9f18?style=flat)
```

## Licenses

```markdown
![License](https://img.shields.io/badge/License-MIT-blue?style=flat)
![License](https://img.shields.io/badge/License-Apache%202.0-blue?style=flat)
![License](https://img.shields.io/badge/License-GPL%203.0-blue?style=flat)
![License](https://img.shields.io/badge/License-BSD%203--Clause-blue?style=flat)
```

## Custom Badges

### Dependencies

```markdown
![Requires](https://img.shields.io/badge/Requires-ModName-color?style=flat)
![Uses](https://img.shields.io/badge/Uses-LibraryName-color?style=flat)
![Supports](https://img.shields.io/badge/Supports-PluginName-color?style=flat)
```

### Features

```markdown
![Real-time](https://img.shields.io/badge/Real--time-WebSocket-purple?style=flat)
![Async](https://img.shields.io/badge/Async-Enabled-brightgreen?style=flat)
![Type-Safe](https://img.shields.io/badge/Type--Safe-TypeScript-3178c6?style=flat)
```

### Compatibility

```markdown
![Cross-Platform](https://img.shields.io/badge/Cross--Platform-Win%7CMac%7CLinux-brightgreen?style=flat)
![Browser](https://img.shields.io/badge/Browser-Chrome%7CFirefox%7CSafari-orange?style=flat)
```

## Version Badge Patterns

When extracting versions from dependency files:

### package.json
```json
{
  "engines": {
    "node": ">=18.0.0"
  },
  "dependencies": {
    "react": "^18.2.0",
    "typescript": "~5.0.4"
  }
}
```
→ `![Node.js](https://img.shields.io/badge/Node.js-18+-339933?style=flat)`
→ `![React](https://img.shields.io/badge/React-18.2+-61dafb?style=flat)`
→ `![TypeScript](https://img.shields.io/badge/TypeScript-5.0+-3178c6?style=flat)`

### build.gradle.kts
```kotlin
java {
    toolchain {
        languageVersion.set(JavaLanguageVersion.of(21))
    }
}
```
→ `![Java](https://img.shields.io/badge/Java-21-orange?style=flat)`

### pyproject.toml
```toml
[project]
requires-python = ">=3.11"
```
→ `![Python](https://img.shields.io/badge/Python-3.11+-3776ab?style=flat)`

## Color Palette Guide

| Color Name | Hex Code | Best For |
| --- | --- | --- |
| `brightgreen` | `#44cc11` | Stable status, passing tests |
| `green` | `#97ca00` | Success, enabled features |
| `yellowgreen` | `#a4a61d` | Active development |
| `yellow` | `#dfb317` | Beta, warnings, in progress |
| `orange` | `#fe7d37` | Alpha, Java |
| `red` | `#e05d44` | Experimental, critical |
| `blue` | `#007ec6` | Licenses, info |
| `lightgrey` | `#9f9f9f` | Deprecated, inactive |
| `purple` | `#9b59b6` | Preview, custom features |

### Tech-Specific Colors

| Technology | Color Code | Badge Example |
| --- | --- | --- |
| Minecraft | `0ea5e9` | Light blue |
| Fabric | `f59e0b` | Amber/orange |
| Node.js | `339933` | Green |
| TypeScript | `3178c6` | Blue |
| Python | `3776ab` | Dark blue |
| React | `61dafb` | Cyan |
| Vue | `4fc08d` | Green |
| Java | `orange` or `007396` | Orange or blue |
