
#pragma once
#include <cstdint>

namespace nvinfer1 {
enum class DataType : int32_t {
  //! 32-bit floating point format.
  kFLOAT = 0,

  //! IEEE 16-bit floating-point format -- has a 5 bit exponent and 11 bit significand.
  kHALF = 1,

  //! Signed 8-bit integer representing a quantized floating-point value.
  kINT8 = 2,

  //! Signed 32-bit integer format.
  kINT32 = 3,

  //! 8-bit boolean. 0 = false, 1 = true, other values undefined.
  kBOOL = 4,

  //! Unsigned 8-bit integer format.
  //! Cannot be used to represent quantized floating-point values.
  //! Use the IdentityLayer to convert kUINT8 network-level inputs to {kFLOAT, kHALF} prior
  //! to use with other TensorRT layers, or to convert intermediate output
  //! before kUINT8 network-level outputs from {kFLOAT, kHALF} to kUINT8.
  //! kUINT8 conversions are only supported for {kFLOAT, kHALF}.
  //! kUINT8 to {kFLOAT, kHALF} conversion will convert the integer values
  //! to equivalent floating point values.
  //! {kFLOAT, kHALF} to kUINT8 conversion will convert the floating point values
  //! to integer values by truncating towards zero. This conversion has undefined behavior for
  //! floating point values outside the range [0.0F, 256.0F) after truncation.
  //! kUINT8 conversions are not supported for {kINT8, kINT32, kBOOL}.
  kUINT8 = 5,

  //! Signed 8-bit floating point with
  //! 1 sign bit, 4 exponent bits, 3 mantissa bits, and exponent-bias 7.
  kFP8 = 6,

  //! Brain float -- has an 8 bit exponent and 8 bit significand.
  kBF16 = 7,

  //! Signed 64-bit integer type.
  kINT64 = 8,

  //! Signed 4-bit integer type.
  kINT4 = 9,

  //! 4-bit floating point type
  //! 1 bit sign, 2 bit exponent, 1 bit mantissa
  kFP4 = 10,

};

}  // namespace nvinfer1
