/*
 * Copyright (c) 2025 by FlashInfer team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#pragma once

#include "cute/config.hpp"

namespace flat {

namespace detail {

template <typename T>
CUTE_HOST_DEVICE constexpr T ceil_log2(T n) {
  return n <= 1 ? 0 : 1 + ceil_log2((n + 1) / 2);
}

}  // namespace detail

template <typename T>
CUTE_HOST_DEVICE constexpr T next_power_of_two(T n) {
  return static_cast<T>(1) << detail::ceil_log2(n);
}

}  // namespace flat
