/*!-----------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.15.5(3d42593a5844407ab71d47b348ea3a8de5fec848)
 * Released under the MIT license
 * https://github.com/Microsoft/vscode/blob/master/LICENSE.txt
 *-----------------------------------------------------------*/

(function() {
var __m = ["require","exports","vs/base/common/lifecycle","vs/editor/common/core/range","vs/nls!vs/editor/editor.main","vs/nls","vs/base/common/event","vs/base/browser/dom","vs/base/common/strings","vs/css!vs/editor/editor.main","vs/editor/browser/editorExtensions","vs/base/common/errors","vs/editor/common/core/position","vs/platform/theme/common/themeService","vs/editor/common/modes","vs/platform/instantiation/common/instantiation","vs/base/common/async","vs/base/common/platform","vs/platform/contextkey/common/contextkey","vs/editor/common/editorContextKeys","vs/platform/theme/common/colorRegistry","vs/editor/common/core/selection","vs/base/common/arrays","vs/base/browser/fastDomNode","vs/base/common/cancellation","vs/base/common/uri","vs/editor/common/model/textModel","vs/base/common/objects","vs/base/common/color","vs/base/browser/browser","vs/editor/browser/services/codeEditorService","vs/platform/commands/common/commands","vs/base/common/types","vs/editor/browser/view/viewPart","vs/editor/common/view/editorColorRegistry","vs/platform/notification/common/notification","vs/base/common/keyCodes","vs/platform/actions/common/actions","vs/editor/common/controller/cursorCommon","vs/editor/common/modes/languageConfigurationRegistry","vs/base/browser/mouseEvent","vs/platform/registry/common/platform","vs/editor/common/services/modelService","vs/base/browser/ui/aria/aria","vs/editor/common/model","vs/platform/configuration/common/configuration","vs/base/browser/ui/widget","vs/platform/keybinding/common/keybinding","vs/editor/common/config/editorOptions","vs/editor/common/core/editOperation","vs/base/common/network","vs/editor/common/modes/nullMode","vs/base/browser/keyboardEvent","vs/base/common/winjs.base","vs/editor/common/editorCommon","vs/base/browser/ui/scrollbar/scrollableElement","vs/base/common/actions","vs/editor/browser/config/configuration","vs/base/common/paths","vs/editor/common/viewModel/viewModel","vs/platform/contextview/browser/contextView","vs/editor/browser/view/dynamicViewOverlay","vs/platform/opener/common/opener","vs/editor/common/services/modeService","vs/editor/common/services/editorWorkerService","vs/base/common/map","vs/editor/browser/core/editorState","vs/base/browser/ui/actionbar/actionbar","vs/base/common/htmlContent","vs/editor/common/view/viewEvents","vs/platform/telemetry/common/telemetry","vs/platform/storage/common/storage","vs/base/browser/event","vs/base/browser/globalMouseMoveMonitor","vs/editor/common/modes/languageConfiguration","vs/base/browser/touch","vs/platform/markers/common/markers","vs/editor/common/commands/replaceCommand","vs/editor/standalone/common/standaloneThemeService","vs/editor/common/viewModel/viewEventHandler","vs/editor/common/controller/wordCharacterClassifier","vs/editor/common/core/characterClassifier","vs/platform/configuration/common/configurationRegistry","vs/editor/common/view/renderingContext","vs/base/common/resources","vs/editor/contrib/suggest/suggest","vs/platform/theme/common/styler","vs/base/common/iterator","vs/base/parts/tree/browser/treeDefaults","vs/platform/progress/common/progress","vs/editor/common/model/wordHelper","vs/editor/common/core/token","vs/editor/common/services/resolverService","vs/editor/common/core/lineTokens","vs/editor/common/modes/supports","vs/platform/keybinding/common/keybindingsRegistry","vs/editor/common/modes/supports/richEditBrackets","vs/editor/common/config/editorZoom","vs/platform/instantiation/common/serviceCollection","vs/editor/browser/widget/codeEditorWidget","vs/base/common/filters","vs/editor/common/core/uint","vs/base/browser/ui/sash/sash","vs/editor/common/viewLayout/viewLineRenderer","vs/editor/common/modes/modesRegistry","vs/editor/browser/editorBrowser","vs/editor/common/services/resourceConfiguration","vs/editor/common/view/minimapCharRenderer","vs/editor/contrib/codeAction/codeActionTrigger","vs/editor/contrib/folding/foldingRanges","vs/base/common/idGenerator","vs/editor/contrib/snippet/snippetParser","vs/editor/common/model/textModelSearch","vs/base/browser/ui/scrollbar/scrollbarArrow","vs/base/common/severity","vs/base/common/range","vs/platform/log/common/log","vs/base/browser/ui/inputbox/inputBox","vs/base/browser/ui/iconLabel/iconLabel","vs/base/parts/quickopen/browser/quickOpenModel","vs/editor/contrib/markdown/markdownRenderer","vs/editor/common/core/stringBuilder","vs/editor/common/config/fontInfo","vs/editor/contrib/referenceSearch/referencesModel","vs/editor/common/standalone/standaloneEnums","vs/editor/common/config/commonEditorConfig","vs/editor/browser/services/bulkEditService","vs/editor/browser/view/viewLayer","vs/base/common/decorators","vs/editor/common/viewLayout/lineDecorations","vs/base/common/diff/diff","vs/editor/common/viewModel/prefixSumComputer","vs/editor/browser/controller/coreCommands","vs/base/browser/htmlContentRenderer","vs/editor/browser/editorDom","vs/base/common/assert","vs/editor/browser/viewParts/glyphMargin/glyphMargin","vs/editor/common/controller/cursorTypeOperations","vs/editor/common/controller/cursorWordOperations","vs/editor/browser/widget/embeddedCodeEditorWidget","vs/editor/contrib/find/findModel","vs/editor/contrib/message/messageController","vs/editor/contrib/referenceSearch/peekViewWidget","vs/editor/contrib/snippet/snippetController2","vs/editor/standalone/browser/quickOpen/editorQuickOpen","vs/platform/list/browser/listService","vs/editor/contrib/referenceSearch/referencesController","vs/editor/standalone/browser/simpleServices","vs/base/common/worker/simpleWorker","vs/base/browser/ui/scrollbar/scrollbarState","vs/editor/browser/controller/textAreaInput","vs/editor/standalone/browser/standaloneServices","vs/base/browser/ui/findinput/findInputCheckboxes","vs/editor/common/standalone/standaloneBase","vs/base/common/keybindingLabels","vs/platform/keybinding/common/keybindingResolver","vs/platform/label/common/label","vs/editor/common/view/overviewZoneManager","vs/base/common/labels","vs/base/browser/ui/highlightedlabel/highlightedLabel","vs/base/common/linkedList","vs/base/parts/tree/browser/treeImpl","vs/platform/files/common/files","vs/css!vs/editor/contrib/goToDefinition/goToDefinitionMouse","vs/base/browser/iframe","vs/editor/common/editorAction","vs/base/browser/ui/scrollbar/abstractScrollbar","vs/base/common/glob","vs/editor/browser/viewParts/margin/margin","vs/base/common/scrollable","vs/base/common/winjs.polyfill.promise","vs/editor/contrib/comment/blockCommentCommand","vs/editor/common/model/pieceTreeTextBuffer/pieceTreeBase","vs/editor/browser/controller/textAreaState","vs/editor/contrib/colorPicker/color","vs/editor/contrib/colorPicker/colorDetector","vs/editor/contrib/goToDefinition/goToDefinition","vs/editor/contrib/parameterHints/provideSignatureHelp","vs/editor/common/commands/shiftCommand","vs/editor/contrib/toggleTabFocusMode/toggleTabFocusMode","vs/editor/contrib/wordOperations/wordOperations","vs/editor/common/controller/cursorMoveOperations","vs/editor/common/controller/cursorDeleteOperations","vs/editor/contrib/goToDefinition/clickLinkGesture","vs/editor/browser/viewParts/lines/viewLine","vs/editor/browser/controller/mouseTarget","vs/editor/contrib/hover/hoverOperation","vs/editor/browser/viewParts/lineNumbers/lineNumbers","vs/editor/common/controller/cursorMoveCommands","vs/editor/browser/widget/diffEditorWidget","vs/editor/common/modes/textToHtmlTokenizer","vs/editor/contrib/hover/hoverWidgets","vs/editor/contrib/smartSelect/tokenTree","vs/editor/common/services/editorWorkerServiceImpl","vs/editor/browser/widget/diffNavigator","vs/editor/common/viewModel/splitLinesCollection","vs/editor/contrib/zoneWidget/zoneWidget","vs/editor/contrib/referenceSearch/referencesWidget","vs/editor/standalone/common/monarch/monarchCommon","vs/editor/contrib/goToDefinition/goToDefinitionCommands","vs/editor/contrib/find/findController","vs/platform/workspace/common/workspace","vs/platform/clipboard/common/clipboardService","vs/editor/contrib/folding/syntaxRangeProvider","vs/css!vs/base/browser/ui/iconLabel/iconlabel","vs/base/common/stopwatch","vs/css!vs/base/browser/ui/inputbox/inputBox","vs/editor/browser/viewParts/lines/rangeUtil","vs/editor/common/view/viewContext","vs/editor/common/view/viewEventDispatcher","vs/css!vs/base/browser/ui/keybindingLabel/keybindingLabel","vs/css!vs/base/browser/ui/list/list","vs/css!vs/base/browser/ui/menu/menu","vs/editor/common/viewLayout/viewLinesViewportData","vs/editor/common/viewLayout/whitespaceComputer","vs/editor/common/viewLayout/linesLayout","vs/css!vs/base/browser/ui/progressbar/progressbar","vs/editor/common/model/mirrorTextModel","vs/editor/common/services/editorSimpleWorker","vs/base/browser/ui/progressbar/progressbar","vs/css!vs/base/browser/ui/sash/sash","vs/editor/editor.api","vs/editor/browser/viewParts/contentWidgets/contentWidgets","vs/editor/browser/viewParts/decorations/decorations","vs/css!vs/base/browser/ui/scrollbar/media/scrollbars","vs/editor/browser/viewParts/linesDecorations/linesDecorations","vs/base/common/collections","vs/editor/browser/viewParts/marginDecorations/marginDecorations","vs/editor/browser/viewParts/overlayWidgets/overlayWidgets","vs/editor/browser/viewParts/overviewRuler/overviewRuler","vs/editor/browser/viewParts/viewZones/viewZones","vs/base/browser/ui/list/listView","vs/editor/common/viewLayout/viewLayout","vs/editor/common/viewModel/viewModelDecorations","vs/editor/contrib/caretOperations/moveCaretCommand","vs/base/parts/tree/browser/treeView","vs/editor/contrib/codeAction/codeActionWidget","vs/editor/contrib/colorPicker/colorPickerModel","vs/css!vs/base/parts/quickopen/browser/quickopen","vs/editor/contrib/comment/lineCommentCommand","vs/editor/contrib/dnd/dragAndDropCommand","vs/editor/contrib/find/findState","vs/editor/contrib/find/replaceAllCommand","vs/editor/contrib/find/replacePattern","vs/css!vs/base/parts/tree/browser/tree","vs/editor/contrib/folding/foldingModel","vs/editor/contrib/folding/hiddenRangeModel","vs/base/browser/ui/octiconLabel/octiconLabel","vs/editor/contrib/folding/intializingRangeProvider","vs/editor/contrib/format/formattingEdit","vs/css!vs/editor/browser/controller/textAreaHandler","vs/css!vs/editor/browser/viewParts/currentLineHighlight/currentLineHighlight","vs/css!vs/editor/browser/viewParts/currentLineMarginHighlight/currentLineMarginHighlight","vs/editor/contrib/hover/modesGlyphHover","vs/editor/contrib/inPlaceReplace/inPlaceReplaceCommand","vs/editor/contrib/indentation/indentUtils","vs/editor/contrib/linesOperations/copyLinesCommand","vs/editor/contrib/linesOperations/deleteLinesCommand","vs/editor/contrib/linesOperations/sortLinesCommand","vs/css!vs/editor/browser/viewParts/decorations/decorations","vs/css!vs/editor/browser/viewParts/glyphMargin/glyphMargin","vs/editor/contrib/suggest/wordDistance","vs/css!vs/editor/browser/viewParts/indentGuides/indentGuides","vs/editor/standalone/common/monarch/monarchCompile","vs/nls!vs/base/browser/ui/actionbar/actionbar","vs/css!vs/editor/browser/viewParts/lineNumbers/lineNumbers","vs/css!vs/editor/browser/viewParts/lines/viewLines","vs/css!vs/editor/browser/viewParts/linesDecorations/linesDecorations","vs/nls!vs/base/browser/ui/aria/aria","vs/css!vs/editor/browser/viewParts/marginDecorations/marginDecorations","vs/nls!vs/base/browser/ui/findinput/findInput","vs/nls!vs/base/browser/ui/findinput/findInputCheckboxes","vs/css!vs/editor/browser/viewParts/minimap/minimap","vs/nls!vs/base/browser/ui/inputbox/inputBox","vs/css!vs/editor/browser/viewParts/overlayWidgets/overlayWidgets","vs/base/browser/ui/findinput/findInput","vs/nls!vs/base/browser/ui/list/listWidget","vs/base/browser/ui/list/listWidget","vs/nls!vs/base/browser/ui/menu/menu","vs/base/browser/ui/menu/menu","vs/nls!vs/base/common/keybindingLabels","vs/css!vs/editor/browser/viewParts/rulers/rulers","vs/base/browser/ui/keybindingLabel/keybindingLabel","vs/nls!vs/base/common/severity","vs/css!vs/editor/browser/viewParts/scrollDecoration/scrollDecoration","vs/nls!vs/base/parts/quickopen/browser/quickOpenModel","vs/css!vs/editor/browser/viewParts/selections/selections","vs/nls!vs/base/parts/quickopen/browser/quickOpenWidget","vs/base/parts/quickopen/browser/quickOpenWidget","vs/nls!vs/editor/browser/controller/coreCommands","vs/nls!vs/editor/browser/widget/codeEditorWidget","vs/nls!vs/editor/browser/widget/diffEditorWidget","vs/nls!vs/editor/browser/widget/diffReview","vs/nls!vs/editor/common/config/commonEditorConfig","vs/nls!vs/editor/common/config/editorOptions","vs/css!vs/editor/browser/viewParts/viewCursors/viewCursors","vs/css!vs/editor/browser/widget/media/diffEditor","vs/nls!vs/editor/common/controller/cursor","vs/nls!vs/editor/common/modes/modesRegistry","vs/nls!vs/editor/common/services/modelServiceImpl","vs/nls!vs/editor/common/view/editorColorRegistry","vs/nls!vs/editor/contrib/bracketMatching/bracketMatching","vs/nls!vs/editor/contrib/caretOperations/caretOperations","vs/nls!vs/editor/contrib/caretOperations/transpose","vs/nls!vs/editor/contrib/clipboard/clipboard","vs/nls!vs/editor/contrib/codeAction/codeActionCommands","vs/nls!vs/editor/contrib/comment/comment","vs/nls!vs/editor/contrib/contextmenu/contextmenu","vs/nls!vs/editor/contrib/cursorUndo/cursorUndo","vs/nls!vs/editor/contrib/find/findController","vs/nls!vs/editor/contrib/find/findWidget","vs/nls!vs/editor/contrib/folding/folding","vs/nls!vs/editor/contrib/fontZoom/fontZoom","vs/nls!vs/editor/contrib/format/formatActions","vs/nls!vs/editor/contrib/goToDefinition/goToDefinitionCommands","vs/nls!vs/editor/contrib/goToDefinition/goToDefinitionMouse","vs/nls!vs/editor/contrib/gotoError/gotoError","vs/nls!vs/editor/contrib/gotoError/gotoErrorWidget","vs/nls!vs/editor/contrib/hover/hover","vs/nls!vs/editor/contrib/hover/modesContentHover","vs/nls!vs/editor/contrib/inPlaceReplace/inPlaceReplace","vs/nls!vs/editor/contrib/linesOperations/linesOperations","vs/nls!vs/editor/contrib/links/links","vs/nls!vs/editor/contrib/message/messageController","vs/nls!vs/editor/contrib/multicursor/multicursor","vs/nls!vs/editor/contrib/parameterHints/parameterHints","vs/nls!vs/editor/contrib/parameterHints/parameterHintsWidget","vs/nls!vs/editor/contrib/referenceSearch/peekViewWidget","vs/nls!vs/editor/contrib/referenceSearch/referenceSearch","vs/nls!vs/editor/contrib/referenceSearch/referencesController","vs/nls!vs/editor/contrib/referenceSearch/referencesModel","vs/css!vs/editor/browser/widget/media/diffReview","vs/nls!vs/editor/contrib/referenceSearch/referencesWidget","vs/nls!vs/editor/contrib/rename/rename","vs/nls!vs/editor/contrib/rename/renameInputField","vs/nls!vs/editor/contrib/smartSelect/smartSelect","vs/nls!vs/editor/contrib/snippet/snippetVariables","vs/editor/contrib/snippet/snippetVariables","vs/nls!vs/editor/contrib/suggest/suggestController","vs/nls!vs/editor/contrib/suggest/suggestWidget","vs/nls!vs/editor/contrib/toggleTabFocusMode/toggleTabFocusMode","vs/nls!vs/editor/contrib/wordHighlighter/wordHighlighter","vs/nls!vs/editor/standalone/browser/accessibilityHelp/accessibilityHelp","vs/nls!vs/editor/standalone/browser/inspectTokens/inspectTokens","vs/nls!vs/editor/standalone/browser/quickOpen/gotoLine","vs/nls!vs/editor/standalone/browser/quickOpen/quickCommand","vs/nls!vs/editor/standalone/browser/quickOpen/quickOutline","vs/nls!vs/editor/standalone/browser/simpleServices","vs/nls!vs/editor/standalone/browser/standaloneCodeEditor","vs/nls!vs/editor/standalone/browser/toggleHighContrast/toggleHighContrast","vs/nls!vs/platform/configuration/common/configurationRegistry","vs/nls!vs/platform/keybinding/common/abstractKeybindingService","vs/nls!vs/platform/list/browser/listService","vs/nls!vs/platform/markers/common/markers","vs/nls!vs/platform/theme/common/colorRegistry","vs/css!vs/editor/browser/widget/media/editor","vs/platform/instantiation/common/descriptors","vs/platform/instantiation/common/graph","vs/css!vs/editor/browser/widget/media/tokens","vs/css!vs/editor/contrib/bracketMatching/bracketMatching","vs/css!vs/editor/contrib/clipboard/clipboard","vs/css!vs/editor/contrib/codeAction/lightBulbWidget","vs/css!vs/editor/contrib/codelens/codelensWidget","vs/css!vs/editor/contrib/colorPicker/colorPicker","vs/editor/common/modes/languageFeatureRegistry","vs/css!vs/editor/contrib/dnd/dnd","vs/css!vs/editor/contrib/find/findWidget","vs/css!vs/editor/contrib/folding/folding","vs/editor/common/model/textModelTokens","vs/base/browser/ui/list/rowCache","vs/css!vs/editor/contrib/gotoError/gotoErrorWidget","vs/css!vs/editor/contrib/hover/hover","vs/editor/common/controller/cursorColumnSelection","vs/css!vs/editor/contrib/links/links","vs/css!vs/editor/contrib/message/messageController","vs/css!vs/editor/contrib/parameterHints/parameterHints","vs/css!vs/editor/contrib/referenceSearch/media/peekViewWidget","vs/css!vs/editor/contrib/referenceSearch/media/referencesWidget","vs/editor/common/controller/oneCursor","vs/editor/common/controller/cursorCollection","vs/editor/common/controller/cursor","vs/css!vs/editor/contrib/rename/renameInputField","vs/css!vs/editor/contrib/snippet/snippetSession","vs/css!vs/editor/contrib/suggest/media/suggest","vs/css!vs/editor/contrib/zoneWidget/zoneWidget","vs/editor/common/services/webWorker","vs/css!vs/editor/standalone/browser/accessibilityHelp/accessibilityHelp","vs/editor/common/view/runtimeMinimapCharRenderer","vs/css!vs/editor/standalone/browser/iPadShowKeyboard/iPadShowKeyboard","vs/editor/common/viewModel/characterHardWrappingLineMapper","vs/editor/common/viewModel/viewModelImpl","vs/editor/contrib/codeAction/lightBulbWidget","vs/editor/contrib/folding/foldingDecorations","vs/editor/contrib/folding/indentRangeProvider","vs/editor/contrib/linesOperations/moveLinesCommand","vs/editor/contrib/smartSelect/tokenSelectionSupport","vs/css!vs/editor/standalone/browser/inspectTokens/inspectTokens","vs/editor/standalone/browser/colorizer","vs/editor/standalone/common/monarch/monarchLexer","vs/css!vs/editor/standalone/browser/quickOpen/editorQuickOpen","vs/css!vs/editor/standalone/browser/quickOpen/gotoLine","vs/css!vs/editor/standalone/browser/quickOpen/quickOutline","vs/editor/contrib/links/getLinks","vs/css!vs/editor/standalone/browser/standalone-tokens","vs/css!vs/platform/contextview/browser/contextMenuHandler","vs/editor/contrib/suggest/suggestAlternatives","vs/editor/contrib/suggest/wordContextKey","vs/editor/browser/config/charWidthReader","vs/platform/actions/common/menu","vs/editor/browser/config/elementSizeObserver","vs/platform/dialogs/common/dialogs","vs/base/browser/ui/scrollbar/scrollbarVisibilityController","vs/platform/instantiation/common/instantiationService","vs/platform/keybinding/common/abstractKeybindingService","vs/base/common/functional","vs/editor/browser/services/abstractCodeEditorService","vs/platform/keybinding/common/resolvedKeybindingItem","vs/platform/keybinding/common/usLayoutResolvedKeybinding","vs/base/common/hash","vs/base/browser/ui/list/splice","vs/base/browser/ui/scrollbar/horizontalScrollbar","vs/platform/markers/common/markerService","vs/base/browser/ui/scrollbar/verticalScrollbar","vs/base/browser/dnd","vs/base/common/mime","vs/editor/common/commands/trimTrailingWhitespaceCommand","vs/editor/common/core/rgba","vs/base/common/numbers","vs/editor/common/services/getIconClasses","vs/platform/jsonschemas/common/jsonContributionRegistry","vs/base/common/marshalling","vs/base/common/diff/diffChange","vs/editor/common/commands/surroundSelectionCommand","vs/editor/browser/view/viewOverlays","vs/editor/browser/viewParts/viewCursors/viewCursor","vs/editor/common/services/languagesRegistry","vs/editor/common/services/modeServiceImpl","vs/base/parts/quickopen/browser/quickOpenViewer","vs/platform/configuration/common/configurationModels","vs/platform/contextkey/browser/contextKeyService","vs/base/parts/tree/browser/tree","vs/base/common/history","vs/editor/contrib/suggest/suggestMemory","vs/base/parts/tree/browser/treeDnd","vs/base/parts/tree/browser/treeModel","vs/base/parts/tree/browser/treeViewModel","vs/editor/browser/view/viewController","vs/editor/contrib/caretOperations/caretOperations","vs/editor/contrib/caretOperations/transpose","vs/editor/contrib/clipboard/clipboard","vs/editor/contrib/codeAction/codeAction","vs/editor/contrib/codeAction/codeActionModel","vs/editor/contrib/codelens/codelens","vs/editor/common/diff/diffComputer","vs/base/worker/defaultWorkerFactory","vs/editor/contrib/comment/comment","vs/editor/contrib/contextmenu/contextmenu","vs/editor/contrib/cursorUndo/cursorUndo","vs/editor/contrib/dnd/dnd","vs/editor/contrib/folding/folding","vs/editor/contrib/fontZoom/fontZoom","vs/editor/contrib/format/format","vs/editor/contrib/format/formatActions","vs/css!vs/base/browser/ui/actionbar/actionbar","vs/editor/contrib/hover/getHover","vs/editor/contrib/linesOperations/linesOperations","vs/base/browser/ui/list/rangeMap","vs/editor/contrib/quickOpen/quickOpen","vs/editor/contrib/smartSelect/smartSelect","vs/css!vs/base/browser/ui/aria/aria","vs/editor/contrib/suggest/completionModel","vs/editor/common/model/editStack","vs/editor/common/model/indentationGuesser","vs/editor/contrib/wordPartOperations/wordPartOperations","vs/editor/standalone/browser/iPadShowKeyboard/iPadShowKeyboard","vs/editor/standalone/browser/toggleHighContrast/toggleHighContrast","vs/platform/contextview/browser/contextViewService","vs/platform/telemetry/common/telemetryUtils","vs/editor/browser/services/openerService","vs/editor/common/model/intervalTree","vs/editor/common/model/pieceTreeTextBuffer/rbTreeBase","vs/editor/standalone/browser/quickOpen/quickOpenEditorWidget","vs/platform/contextview/browser/contextMenuHandler","vs/editor/common/model/textModelEvents","vs/editor/browser/services/codeEditorServiceImpl","vs/editor/browser/viewParts/editorScrollbar/editorScrollbar","vs/css!vs/base/browser/ui/checkbox/checkbox","vs/base/browser/ui/checkbox/checkbox","vs/editor/browser/controller/mouseHandler","vs/editor/browser/controller/pointerHandler","vs/editor/browser/view/viewOutgoingEvents","vs/editor/browser/viewParts/lines/viewLines","vs/editor/browser/viewParts/minimap/minimap","vs/editor/browser/viewParts/scrollDecoration/scrollDecoration","vs/editor/browser/viewParts/selections/selections","vs/editor/common/model/pieceTreeTextBuffer/pieceTreeTextBuffer","vs/editor/browser/viewParts/currentLineHighlight/currentLineHighlight","vs/editor/browser/viewParts/currentLineMarginHighlight/currentLineMarginHighlight","vs/editor/browser/viewParts/indentGuides/indentGuides","vs/editor/common/model/pieceTreeTextBuffer/pieceTreeTextBufferBuilder","vs/editor/browser/controller/textAreaHandler","vs/editor/browser/viewParts/overviewRuler/decorationsOverviewRuler","vs/editor/browser/viewParts/rulers/rulers","vs/editor/browser/viewParts/viewCursors/viewCursors","vs/editor/browser/view/viewImpl","vs/css!vs/base/browser/ui/contextview/contextview","vs/editor/browser/widget/diffReview","vs/editor/common/modes/abstractMode","vs/base/browser/ui/contextview/contextview","vs/editor/common/services/modelServiceImpl","vs/editor/contrib/bracketMatching/bracketMatching","vs/editor/contrib/codelens/codelensWidget","vs/editor/contrib/codelens/codelensController","vs/editor/contrib/colorPicker/colorPickerWidget","vs/editor/contrib/find/findDecorations","vs/editor/common/modes/languageSelector","vs/editor/contrib/find/findOptionsWidget","vs/editor/contrib/gotoError/gotoErrorWidget","vs/editor/contrib/gotoError/gotoError","vs/editor/contrib/hover/modesContentHover","vs/editor/contrib/hover/hover","vs/editor/contrib/inPlaceReplace/inPlaceReplace","vs/editor/contrib/links/links","vs/editor/common/modes/linkComputer","vs/editor/contrib/codeAction/codeActionCommands","vs/editor/contrib/codeAction/codeActionContributions","vs/editor/contrib/parameterHints/parameterHintsWidget","vs/editor/contrib/parameterHints/parameterHints","vs/css!vs/base/browser/ui/countBadge/countBadge","vs/editor/contrib/rename/renameInputField","vs/editor/contrib/rename/rename","vs/editor/contrib/snippet/snippetSession","vs/editor/common/modes/supports/characterPair","vs/editor/contrib/suggest/suggestModel","vs/editor/contrib/suggest/suggestWidget","vs/editor/contrib/suggest/suggestController","vs/editor/contrib/wordHighlighter/wordHighlighter","vs/editor/standalone/browser/accessibilityHelp/accessibilityHelp","vs/editor/standalone/browser/inspectTokens/inspectTokens","vs/editor/common/modes/supports/indentRules","vs/editor/standalone/browser/quickOpen/gotoLine","vs/editor/standalone/browser/quickOpen/quickCommand","vs/editor/standalone/browser/quickOpen/quickOutline","vs/editor/standalone/browser/standaloneCodeServiceImpl","vs/editor/standalone/common/themes","vs/editor/standalone/browser/standaloneThemeServiceImpl","vs/platform/contextview/browser/contextMenuService","vs/editor/common/modes/supports/inplaceReplaceSupport","vs/editor/common/modes/supports/onEnter","vs/base/browser/ui/countBadge/countBadge","vs/editor/common/modes/supports/electricCharacter","vs/editor/contrib/goToDefinition/goToDefinitionMouse","vs/editor/contrib/referenceSearch/referenceSearch","vs/editor/standalone/browser/referenceSearch/standaloneReferenceSearch","vs/platform/widget/common/contextScopedWidget","vs/platform/widget/browser/contextScopedHistoryWidget","vs/editor/contrib/find/findWidget","vs/css!vs/base/browser/ui/findinput/findInput","vs/editor/contrib/multicursor/multicursor","vs/editor/editor.all","vs/editor/common/modes/supports/tokenization","vs/editor/common/modes/tokenizationRegistry","vs/editor/standalone/browser/standaloneCodeEditor","vs/css!vs/base/browser/ui/findinput/findInputCheckboxes","vs/editor/standalone/browser/standaloneEditor","vs/editor/standalone/browser/standaloneLanguages","vs/base/common/marked/marked","vs/editor/edcore.main"];
var __M = function(deps) {
  var result = [];
  for (var i = 0, len = deps.length; i < len; i++) {
    result[i] = __m[deps[i]];
  }
  return result;
};
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 * Please make sure to make edits in the .ts file at https://github.com/Microsoft/vscode-loader/
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *--------------------------------------------------------------------------------------------*/
'use strict';
var CSSLoaderPlugin;
(function (CSSLoaderPlugin) {
    /**
     * Known issue:
     * - In IE there is no way to know if the CSS file loaded successfully or not.
     */
    var BrowserCSSLoader = /** @class */ (function () {
        function BrowserCSSLoader() {
            this._pendingLoads = 0;
        }
        BrowserCSSLoader.prototype.attachListeners = function (name, linkNode, callback, errorback) {
            var unbind = function () {
                linkNode.removeEventListener('load', loadEventListener);
                linkNode.removeEventListener('error', errorEventListener);
            };
            var loadEventListener = function (e) {
                unbind();
                callback();
            };
            var errorEventListener = function (e) {
                unbind();
                errorback(e);
            };
            linkNode.addEventListener('load', loadEventListener);
            linkNode.addEventListener('error', errorEventListener);
        };
        BrowserCSSLoader.prototype._onLoad = function (name, callback) {
            this._pendingLoads--;
            callback();
        };
        BrowserCSSLoader.prototype._onLoadError = function (name, errorback, err) {
            this._pendingLoads--;
            errorback(err);
        };
        BrowserCSSLoader.prototype._insertLinkNode = function (linkNode) {
            this._pendingLoads++;
            var head = document.head || document.getElementsByTagName('head')[0];
            var other = head.getElementsByTagName('link') || document.head.getElementsByTagName('script');
            if (other.length > 0) {
                head.insertBefore(linkNode, other[other.length - 1]);
            }
            else {
                head.appendChild(linkNode);
            }
        };
        BrowserCSSLoader.prototype.createLinkTag = function (name, cssUrl, externalCallback, externalErrorback) {
            var _this = this;
            var linkNode = document.createElement('link');
            linkNode.setAttribute('rel', 'stylesheet');
            linkNode.setAttribute('type', 'text/css');
            linkNode.setAttribute('data-name', name);
            var callback = function () { return _this._onLoad(name, externalCallback); };
            var errorback = function (err) { return _this._onLoadError(name, externalErrorback, err); };
            this.attachListeners(name, linkNode, callback, errorback);
            linkNode.setAttribute('href', cssUrl);
            return linkNode;
        };
        BrowserCSSLoader.prototype._linkTagExists = function (name, cssUrl) {
            var i, len, nameAttr, hrefAttr, links = document.getElementsByTagName('link');
            for (i = 0, len = links.length; i < len; i++) {
                nameAttr = links[i].getAttribute('data-name');
                hrefAttr = links[i].getAttribute('href');
                if (nameAttr === name || hrefAttr === cssUrl) {
                    return true;
                }
            }
            return false;
        };
        BrowserCSSLoader.prototype.load = function (name, cssUrl, externalCallback, externalErrorback) {
            if (this._linkTagExists(name, cssUrl)) {
                externalCallback();
                return;
            }
            var linkNode = this.createLinkTag(name, cssUrl, externalCallback, externalErrorback);
            this._insertLinkNode(linkNode);
        };
        return BrowserCSSLoader;
    }());
    // ------------------------------ Finally, the plugin
    var CSSPlugin = /** @class */ (function () {
        function CSSPlugin() {
            this._cssLoader = new BrowserCSSLoader();
        }
        CSSPlugin.prototype.load = function (name, req, load) {
            var cssUrl = req.toUrl(name + '.css');
            this._cssLoader.load(name, cssUrl, function (contents) {
                load({});
            }, function (err) {
                if (typeof load.error === 'function') {
                    load.error('Could not find ' + cssUrl + ' or it was empty');
                }
            });
        };
        return CSSPlugin;
    }());
    CSSLoaderPlugin.CSSPlugin = CSSPlugin;
    define('vs/css', new CSSPlugin());
})(CSSLoaderPlugin || (CSSLoaderPlugin = {}));

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 * Please make sure to make edits in the .ts file at https://github.com/Microsoft/vscode-loader/
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *---------------------------------------------------------------------------------------------
 *--------------------------------------------------------------------------------------------*/
'use strict';
var NLSLoaderPlugin;
(function (NLSLoaderPlugin) {
    var Environment = /** @class */ (function () {
        function Environment() {
            this._detected = false;
            this._isPseudo = false;
        }
        Object.defineProperty(Environment.prototype, "isPseudo", {
            get: function () {
                this._detect();
                return this._isPseudo;
            },
            enumerable: true,
            configurable: true
        });
        Environment.prototype._detect = function () {
            if (this._detected) {
                return;
            }
            this._detected = true;
            this._isPseudo = (typeof document !== 'undefined' && document.location && document.location.hash.indexOf('pseudo=true') >= 0);
        };
        return Environment;
    }());
    function _format(message, args, env) {
        var result;
        if (args.length === 0) {
            result = message;
        }
        else {
            result = message.replace(/\{(\d+)\}/g, function (match, rest) {
                var index = rest[0];
                var arg = args[index];
                var result = match;
                if (typeof arg === 'string') {
                    result = arg;
                }
                else if (typeof arg === 'number' || typeof arg === 'boolean' || arg === void 0 || arg === null) {
                    result = String(arg);
                }
                return result;
            });
        }
        if (env.isPseudo) {
            // FF3B and FF3D is the Unicode zenkaku representation for [ and ]
            result = '\uFF3B' + result.replace(/[aouei]/g, '$&$&') + '\uFF3D';
        }
        return result;
    }
    function findLanguageForModule(config, name) {
        var result = config[name];
        if (result)
            return result;
        result = config['*'];
        if (result)
            return result;
        return null;
    }
    function localize(env, data, message) {
        var args = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            args[_i - 3] = arguments[_i];
        }
        return _format(message, args, env);
    }
    function createScopedLocalize(scope, env) {
        return function (idx, defaultValue) {
            var restArgs = Array.prototype.slice.call(arguments, 2);
            return _format(scope[idx], restArgs, env);
        };
    }
    var NLSPlugin = /** @class */ (function () {
        function NLSPlugin(env) {
            var _this = this;
            this._env = env;
            this.localize = function (data, message) {
                var args = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    args[_i - 2] = arguments[_i];
                }
                return localize.apply(void 0, [_this._env, data, message].concat(args));
            };
        }
        NLSPlugin.prototype.setPseudoTranslation = function (value) {
            this._env._isPseudo = value;
        };
        NLSPlugin.prototype.create = function (key, data) {
            return {
                localize: createScopedLocalize(data[key], this._env)
            };
        };
        NLSPlugin.prototype.load = function (name, req, load, config) {
            var _this = this;
            config = config || {};
            if (!name || name.length === 0) {
                load({
                    localize: this.localize
                });
            }
            else {
                var pluginConfig = config['vs/nls'] || {};
                var language = pluginConfig.availableLanguages ? findLanguageForModule(pluginConfig.availableLanguages, name) : null;
                var suffix = '.nls';
                if (language !== null && language !== NLSPlugin.DEFAULT_TAG) {
                    suffix = suffix + '.' + language;
                }
                var messagesLoaded_1 = function (messages) {
                    if (Array.isArray(messages)) {
                        messages.localize = createScopedLocalize(messages, _this._env);
                    }
                    else {
                        messages.localize = createScopedLocalize(messages[name], _this._env);
                    }
                    load(messages);
                };
                if (typeof pluginConfig.loadBundle === 'function') {
                    pluginConfig.loadBundle(name, language, function (err, messages) {
                        // We have an error. Load the English default strings to not fail
                        if (err) {
                            req([name + '.nls'], messagesLoaded_1);
                        }
                        else {
                            messagesLoaded_1(messages);
                        }
                    });
                }
                else {
                    req([name + suffix], messagesLoaded_1);
                }
            }
        };
        NLSPlugin.DEFAULT_TAG = 'i-default';
        return NLSPlugin;
    }());
    NLSLoaderPlugin.NLSPlugin = NLSPlugin;
    define('vs/nls', new NLSPlugin(new Environment()));
})(NLSLoaderPlugin || (NLSLoaderPlugin = {}));

define(__m[423/*vs/base/browser/dnd*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    // Common data transfers
    exports.DataTransfers = {
        /**
         * Application specific resource transfer type
         */
        RESOURCES: 'ResourceURLs',
        /**
         * Browser specific transfer type to download
         */
        DOWNLOAD_URL: 'DownloadURL',
        /**
         * Browser specific transfer type for files
         */
        FILES: 'Files',
        /**
         * Typicaly transfer type for copy/paste transfers.
         */
        TEXT: 'text/plain'
    };
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[164/*vs/base/browser/iframe*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var hasDifferentOriginAncestorFlag = false;
    var sameOriginWindowChainCache = null;
    function getParentWindowIfSameOrigin(w) {
        if (!w.parent || w.parent === w) {
            return null;
        }
        // Cannot really tell if we have access to the parent window unless we try to access something in it
        try {
            var location_1 = w.location;
            var parentLocation = w.parent.location;
            if (location_1.protocol !== parentLocation.protocol || location_1.hostname !== parentLocation.hostname || location_1.port !== parentLocation.port) {
                hasDifferentOriginAncestorFlag = true;
                return null;
            }
        }
        catch (e) {
            hasDifferentOriginAncestorFlag = true;
            return null;
        }
        return w.parent;
    }
    function findIframeElementInParentWindow(parentWindow, childWindow) {
        var parentWindowIframes = parentWindow.document.getElementsByTagName('iframe');
        var iframe;
        for (var i = 0, len = parentWindowIframes.length; i < len; i++) {
            iframe = parentWindowIframes[i];
            if (iframe.contentWindow === childWindow) {
                return iframe;
            }
        }
        return null;
    }
    var IframeUtils = /** @class */ (function () {
        function IframeUtils() {
        }
        /**
         * Returns a chain of embedded windows with the same origin (which can be accessed programmatically).
         * Having a chain of length 1 might mean that the current execution environment is running outside of an iframe or inside an iframe embedded in a window with a different origin.
         * To distinguish if at one point the current execution environment is running inside a window with a different origin, see hasDifferentOriginAncestor()
         */
        IframeUtils.getSameOriginWindowChain = function () {
            if (!sameOriginWindowChainCache) {
                sameOriginWindowChainCache = [];
                var w = window;
                var parent_1;
                do {
                    parent_1 = getParentWindowIfSameOrigin(w);
                    if (parent_1) {
                        sameOriginWindowChainCache.push({
                            window: w,
                            iframeElement: findIframeElementInParentWindow(parent_1, w)
                        });
                    }
                    else {
                        sameOriginWindowChainCache.push({
                            window: w,
                            iframeElement: null
                        });
                    }
                    w = parent_1;
                } while (w);
            }
            return sameOriginWindowChainCache.slice(0);
        };
        /**
         * Returns true if the current execution environment is chained in a list of iframes which at one point ends in a window with a different origin.
         * Returns false if the current execution environment is not running inside an iframe or if the entire chain of iframes have the same origin.
         */
        IframeUtils.hasDifferentOriginAncestor = function () {
            if (!sameOriginWindowChainCache) {
                this.getSameOriginWindowChain();
            }
            return hasDifferentOriginAncestorFlag;
        };
        /**
         * Returns the position of `childWindow` relative to `ancestorWindow`
         */
        IframeUtils.getPositionOfChildWindowRelativeToAncestorWindow = function (childWindow, ancestorWindow) {
            if (!ancestorWindow || childWindow === ancestorWindow) {
                return {
                    top: 0,
                    left: 0
                };
            }
            var top = 0, left = 0;
            var windowChain = this.getSameOriginWindowChain();
            for (var i = 0; i < windowChain.length; i++) {
                var windowChainEl = windowChain[i];
                if (windowChainEl.window === ancestorWindow) {
                    break;
                }
                if (!windowChainEl.iframeElement) {
                    break;
                }
                var boundingRect = windowChainEl.iframeElement.getBoundingClientRect();
                top += boundingRect.top;
                left += boundingRect.left;
            }
            return {
                top: top,
                left: left
            };
        };
        return IframeUtils;
    }());
    exports.IframeUtils = IframeUtils;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[419/*vs/base/browser/ui/list/splice*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CombinedSpliceable = /** @class */ (function () {
        function CombinedSpliceable(spliceables) {
            this.spliceables = spliceables;
        }
        CombinedSpliceable.prototype.splice = function (start, deleteCount, elements) {
            this.spliceables.forEach(function (s) { return s.splice(start, deleteCount, elements); });
        };
        return CombinedSpliceable;
    }());
    exports.CombinedSpliceable = CombinedSpliceable;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[149/*vs/base/browser/ui/scrollbar/scrollbarState*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * The minimal size of the slider (such that it can still be clickable) -- it is artificially enlarged.
     */
    var MINIMUM_SLIDER_SIZE = 20;
    var ScrollbarState = /** @class */ (function () {
        function ScrollbarState(arrowSize, scrollbarSize, oppositeScrollbarSize) {
            this._scrollbarSize = Math.round(scrollbarSize);
            this._oppositeScrollbarSize = Math.round(oppositeScrollbarSize);
            this._arrowSize = Math.round(arrowSize);
            this._visibleSize = 0;
            this._scrollSize = 0;
            this._scrollPosition = 0;
            this._computedAvailableSize = 0;
            this._computedIsNeeded = false;
            this._computedSliderSize = 0;
            this._computedSliderRatio = 0;
            this._computedSliderPosition = 0;
            this._refreshComputedValues();
        }
        ScrollbarState.prototype.clone = function () {
            var r = new ScrollbarState(this._arrowSize, this._scrollbarSize, this._oppositeScrollbarSize);
            r.setVisibleSize(this._visibleSize);
            r.setScrollSize(this._scrollSize);
            r.setScrollPosition(this._scrollPosition);
            return r;
        };
        ScrollbarState.prototype.setVisibleSize = function (visibleSize) {
            var iVisibleSize = Math.round(visibleSize);
            if (this._visibleSize !== iVisibleSize) {
                this._visibleSize = iVisibleSize;
                this._refreshComputedValues();
                return true;
            }
            return false;
        };
        ScrollbarState.prototype.setScrollSize = function (scrollSize) {
            var iScrollSize = Math.round(scrollSize);
            if (this._scrollSize !== iScrollSize) {
                this._scrollSize = iScrollSize;
                this._refreshComputedValues();
                return true;
            }
            return false;
        };
        ScrollbarState.prototype.setScrollPosition = function (scrollPosition) {
            var iScrollPosition = Math.round(scrollPosition);
            if (this._scrollPosition !== iScrollPosition) {
                this._scrollPosition = iScrollPosition;
                this._refreshComputedValues();
                return true;
            }
            return false;
        };
        ScrollbarState._computeValues = function (oppositeScrollbarSize, arrowSize, visibleSize, scrollSize, scrollPosition) {
            var computedAvailableSize = Math.max(0, visibleSize - oppositeScrollbarSize);
            var computedRepresentableSize = Math.max(0, computedAvailableSize - 2 * arrowSize);
            var computedIsNeeded = (scrollSize > 0 && scrollSize > visibleSize);
            if (!computedIsNeeded) {
                // There is no need for a slider
                return {
                    computedAvailableSize: Math.round(computedAvailableSize),
                    computedIsNeeded: computedIsNeeded,
                    computedSliderSize: Math.round(computedRepresentableSize),
                    computedSliderRatio: 0,
                    computedSliderPosition: 0,
                };
            }
            // We must artificially increase the size of the slider if needed, since the slider would be too small to grab with the mouse otherwise
            var computedSliderSize = Math.round(Math.max(MINIMUM_SLIDER_SIZE, Math.floor(visibleSize * computedRepresentableSize / scrollSize)));
            // The slider can move from 0 to `computedRepresentableSize` - `computedSliderSize`
            // in the same way `scrollPosition` can move from 0 to `scrollSize` - `visibleSize`.
            var computedSliderRatio = (computedRepresentableSize - computedSliderSize) / (scrollSize - visibleSize);
            var computedSliderPosition = (scrollPosition * computedSliderRatio);
            return {
                computedAvailableSize: Math.round(computedAvailableSize),
                computedIsNeeded: computedIsNeeded,
                computedSliderSize: Math.round(computedSliderSize),
                computedSliderRatio: computedSliderRatio,
                computedSliderPosition: Math.round(computedSliderPosition),
            };
        };
        ScrollbarState.prototype._refreshComputedValues = function () {
            var r = ScrollbarState._computeValues(this._oppositeScrollbarSize, this._arrowSize, this._visibleSize, this._scrollSize, this._scrollPosition);
            this._computedAvailableSize = r.computedAvailableSize;
            this._computedIsNeeded = r.computedIsNeeded;
            this._computedSliderSize = r.computedSliderSize;
            this._computedSliderRatio = r.computedSliderRatio;
            this._computedSliderPosition = r.computedSliderPosition;
        };
        ScrollbarState.prototype.getArrowSize = function () {
            return this._arrowSize;
        };
        ScrollbarState.prototype.getScrollPosition = function () {
            return this._scrollPosition;
        };
        ScrollbarState.prototype.getRectangleLargeSize = function () {
            return this._computedAvailableSize;
        };
        ScrollbarState.prototype.getRectangleSmallSize = function () {
            return this._scrollbarSize;
        };
        ScrollbarState.prototype.isNeeded = function () {
            return this._computedIsNeeded;
        };
        ScrollbarState.prototype.getSliderSize = function () {
            return this._computedSliderSize;
        };
        ScrollbarState.prototype.getSliderPosition = function () {
            return this._computedSliderPosition;
        };
        /**
         * Compute a desired `scrollPosition` such that `offset` ends up in the center of the slider.
         * `offset` is based on the same coordinate system as the `sliderPosition`.
         */
        ScrollbarState.prototype.getDesiredScrollPositionFromOffset = function (offset) {
            if (!this._computedIsNeeded) {
                // no need for a slider
                return 0;
            }
            var desiredSliderPosition = offset - this._arrowSize - this._computedSliderSize / 2;
            return Math.round(desiredSliderPosition / this._computedSliderRatio);
        };
        /**
         * Compute a desired `scrollPosition` such that the slider moves by `delta`.
         */
        ScrollbarState.prototype.getDesiredScrollPositionFromDelta = function (delta) {
            if (!this._computedIsNeeded) {
                // no need for a slider
                return 0;
            }
            var desiredSliderPosition = this._computedSliderPosition + delta;
            return Math.round(desiredSliderPosition / this._computedSliderRatio);
        };
        return ScrollbarState;
    }());
    exports.ScrollbarState = ScrollbarState;
});

define(__m[22/*vs/base/common/arrays*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * Returns the last element of an array.
     * @param array The array.
     * @param n Which element from the end (default is zero).
     */
    function tail(array, n) {
        if (n === void 0) { n = 0; }
        return array[array.length - (1 + n)];
    }
    exports.tail = tail;
    function tail2(arr) {
        if (arr.length === 0) {
            throw new Error('Invalid tail call');
        }
        return [arr.slice(0, arr.length - 1), arr[arr.length - 1]];
    }
    exports.tail2 = tail2;
    function equals(one, other, itemEquals) {
        if (itemEquals === void 0) { itemEquals = function (a, b) { return a === b; }; }
        if (one === other) {
            return true;
        }
        if (!one || !other) {
            return false;
        }
        if (one.length !== other.length) {
            return false;
        }
        for (var i = 0, len = one.length; i < len; i++) {
            if (!itemEquals(one[i], other[i])) {
                return false;
            }
        }
        return true;
    }
    exports.equals = equals;
    function binarySearch(array, key, comparator) {
        var low = 0, high = array.length - 1;
        while (low <= high) {
            var mid = ((low + high) / 2) | 0;
            var comp = comparator(array[mid], key);
            if (comp < 0) {
                low = mid + 1;
            }
            else if (comp > 0) {
                high = mid - 1;
            }
            else {
                return mid;
            }
        }
        return -(low + 1);
    }
    exports.binarySearch = binarySearch;
    /**
     * Takes a sorted array and a function p. The array is sorted in such a way that all elements where p(x) is false
     * are located before all elements where p(x) is true.
     * @returns the least x for which p(x) is true or array.length if no element fullfills the given function.
     */
    function findFirstInSorted(array, p) {
        var low = 0, high = array.length;
        if (high === 0) {
            return 0; // no children
        }
        while (low < high) {
            var mid = Math.floor((low + high) / 2);
            if (p(array[mid])) {
                high = mid;
            }
            else {
                low = mid + 1;
            }
        }
        return low;
    }
    exports.findFirstInSorted = findFirstInSorted;
    /**
     * Like `Array#sort` but always stable. Usually runs a little slower `than Array#sort`
     * so only use this when actually needing stable sort.
     */
    function mergeSort(data, compare) {
        _sort(data, compare, 0, data.length - 1, []);
        return data;
    }
    exports.mergeSort = mergeSort;
    function _merge(a, compare, lo, mid, hi, aux) {
        var leftIdx = lo, rightIdx = mid + 1;
        for (var i = lo; i <= hi; i++) {
            aux[i] = a[i];
        }
        for (var i = lo; i <= hi; i++) {
            if (leftIdx > mid) {
                // left side consumed
                a[i] = aux[rightIdx++];
            }
            else if (rightIdx > hi) {
                // right side consumed
                a[i] = aux[leftIdx++];
            }
            else if (compare(aux[rightIdx], aux[leftIdx]) < 0) {
                // right element is less -> comes first
                a[i] = aux[rightIdx++];
            }
            else {
                // left element comes first (less or equal)
                a[i] = aux[leftIdx++];
            }
        }
    }
    function _sort(a, compare, lo, hi, aux) {
        if (hi <= lo) {
            return;
        }
        var mid = lo + ((hi - lo) / 2) | 0;
        _sort(a, compare, lo, mid, aux);
        _sort(a, compare, mid + 1, hi, aux);
        if (compare(a[mid], a[mid + 1]) <= 0) {
            // left and right are sorted and if the last-left element is less
            // or equals than the first-right element there is nothing else
            // to do
            return;
        }
        _merge(a, compare, lo, mid, hi, aux);
    }
    function groupBy(data, compare) {
        var result = [];
        var currentGroup = undefined;
        for (var _i = 0, _a = mergeSort(data.slice(0), compare); _i < _a.length; _i++) {
            var element = _a[_i];
            if (!currentGroup || compare(currentGroup[0], element) !== 0) {
                currentGroup = [element];
                result.push(currentGroup);
            }
            else {
                currentGroup.push(element);
            }
        }
        return result;
    }
    exports.groupBy = groupBy;
    /**
     * @returns a new array with all falsy values removed. The original array IS NOT modified.
     */
    function coalesce(array) {
        if (!array) {
            return array;
        }
        return array.filter(function (e) { return !!e; });
    }
    exports.coalesce = coalesce;
    /**
     * @returns {{false}} if the provided object is an array
     * 	and not empty.
     */
    function isFalsyOrEmpty(obj) {
        return !Array.isArray(obj) || obj.length === 0;
    }
    exports.isFalsyOrEmpty = isFalsyOrEmpty;
    /**
     * Removes duplicates from the given array. The optional keyFn allows to specify
     * how elements are checked for equalness by returning a unique string for each.
     */
    function distinct(array, keyFn) {
        if (!keyFn) {
            return array.filter(function (element, position) {
                return array.indexOf(element) === position;
            });
        }
        var seen = Object.create(null);
        return array.filter(function (elem) {
            var key = keyFn(elem);
            if (seen[key]) {
                return false;
            }
            seen[key] = true;
            return true;
        });
    }
    exports.distinct = distinct;
    function firstIndex(array, fn) {
        for (var i = 0; i < array.length; i++) {
            var element = array[i];
            if (fn(element)) {
                return i;
            }
        }
        return -1;
    }
    exports.firstIndex = firstIndex;
    function first(array, fn, notFoundValue) {
        if (notFoundValue === void 0) { notFoundValue = null; }
        var index = firstIndex(array, fn);
        return index < 0 ? notFoundValue : array[index];
    }
    exports.first = first;
    function flatten(arr) {
        var _a;
        return (_a = []).concat.apply(_a, arr);
    }
    exports.flatten = flatten;
    function range(arg, to) {
        var from = typeof to === 'number' ? arg : 0;
        if (typeof to === 'number') {
            from = arg;
        }
        else {
            from = 0;
            to = arg;
        }
        var result = [];
        if (from <= to) {
            for (var i = from; i < to; i++) {
                result.push(i);
            }
        }
        else {
            for (var i = from; i > to; i--) {
                result.push(i);
            }
        }
        return result;
    }
    exports.range = range;
    /**
     * Insert `insertArr` inside `target` at `insertIndex`.
     * Please don't touch unless you understand https://jsperf.com/inserting-an-array-within-an-array
     */
    function arrayInsert(target, insertIndex, insertArr) {
        var before = target.slice(0, insertIndex);
        var after = target.slice(insertIndex);
        return before.concat(insertArr, after);
    }
    exports.arrayInsert = arrayInsert;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[135/*vs/base/common/assert*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * Throws an error with the provided message if the provided value does not evaluate to a true Javascript value.
     */
    function ok(value, message) {
        if (!value || value === null) {
            throw new Error(message ? 'Assertion failed (' + message + ')' : 'Assertion Failed');
        }
    }
    exports.ok = ok;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[226/*vs/base/common/collections*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    /**
     * Iterates over each entry in the provided set. The iterator allows
     * to remove elements and will stop when the callback returns {{false}}.
     */
    function forEach(from, callback) {
        var _loop_1 = function (key) {
            if (hasOwnProperty.call(from, key)) {
                var result = callback({ key: key, value: from[key] }, function () {
                    delete from[key];
                });
                if (result === false) {
                    return { value: void 0 };
                }
            }
        };
        for (var key in from) {
            var state_1 = _loop_1(key);
            if (typeof state_1 === "object")
                return state_1.value;
        }
    }
    exports.forEach = forEach;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[28/*vs/base/common/color*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function roundFloat(number, decimalPoints) {
        var decimal = Math.pow(10, decimalPoints);
        return Math.round(number * decimal) / decimal;
    }
    var RGBA = /** @class */ (function () {
        function RGBA(r, g, b, a) {
            if (a === void 0) { a = 1; }
            this.r = Math.min(255, Math.max(0, r)) | 0;
            this.g = Math.min(255, Math.max(0, g)) | 0;
            this.b = Math.min(255, Math.max(0, b)) | 0;
            this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
        }
        RGBA.equals = function (a, b) {
            return a.r === b.r && a.g === b.g && a.b === b.b && a.a === b.a;
        };
        return RGBA;
    }());
    exports.RGBA = RGBA;
    var HSLA = /** @class */ (function () {
        function HSLA(h, s, l, a) {
            this.h = Math.max(Math.min(360, h), 0) | 0;
            this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
            this.l = roundFloat(Math.max(Math.min(1, l), 0), 3);
            this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
        }
        HSLA.equals = function (a, b) {
            return a.h === b.h && a.s === b.s && a.l === b.l && a.a === b.a;
        };
        /**
         * Converts an RGB color value to HSL. Conversion formula
         * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
         * Assumes r, g, and b are contained in the set [0, 255] and
         * returns h in the set [0, 360], s, and l in the set [0, 1].
         */
        HSLA.fromRGBA = function (rgba) {
            var r = rgba.r / 255;
            var g = rgba.g / 255;
            var b = rgba.b / 255;
            var a = rgba.a;
            var max = Math.max(r, g, b);
            var min = Math.min(r, g, b);
            var h = 0;
            var s = 0;
            var l = (min + max) / 2;
            var chroma = max - min;
            if (chroma > 0) {
                s = Math.min((l <= 0.5 ? chroma / (2 * l) : chroma / (2 - (2 * l))), 1);
                switch (max) {
                    case r:
                        h = (g - b) / chroma + (g < b ? 6 : 0);
                        break;
                    case g:
                        h = (b - r) / chroma + 2;
                        break;
                    case b:
                        h = (r - g) / chroma + 4;
                        break;
                }
                h *= 60;
                h = Math.round(h);
            }
            return new HSLA(h, s, l, a);
        };
        HSLA._hue2rgb = function (p, q, t) {
            if (t < 0) {
                t += 1;
            }
            if (t > 1) {
                t -= 1;
            }
            if (t < 1 / 6) {
                return p + (q - p) * 6 * t;
            }
            if (t < 1 / 2) {
                return q;
            }
            if (t < 2 / 3) {
                return p + (q - p) * (2 / 3 - t) * 6;
            }
            return p;
        };
        /**
         * Converts an HSL color value to RGB. Conversion formula
         * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
         * Assumes h in the set [0, 360] s, and l are contained in the set [0, 1] and
         * returns r, g, and b in the set [0, 255].
         */
        HSLA.toRGBA = function (hsla) {
            var h = hsla.h / 360;
            var s = hsla.s, l = hsla.l, a = hsla.a;
            var r, g, b;
            if (s === 0) {
                r = g = b = l; // achromatic
            }
            else {
                var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
                var p = 2 * l - q;
                r = HSLA._hue2rgb(p, q, h + 1 / 3);
                g = HSLA._hue2rgb(p, q, h);
                b = HSLA._hue2rgb(p, q, h - 1 / 3);
            }
            return new RGBA(Math.round(r * 255), Math.round(g * 255), Math.round(b * 255), a);
        };
        return HSLA;
    }());
    exports.HSLA = HSLA;
    var HSVA = /** @class */ (function () {
        function HSVA(h, s, v, a) {
            this.h = Math.max(Math.min(360, h), 0) | 0;
            this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
            this.v = roundFloat(Math.max(Math.min(1, v), 0), 3);
            this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
        }
        HSVA.equals = function (a, b) {
            return a.h === b.h && a.s === b.s && a.v === b.v && a.a === b.a;
        };
        // from http://www.rapidtables.com/convert/color/rgb-to-hsv.htm
        HSVA.fromRGBA = function (rgba) {
            var r = rgba.r / 255;
            var g = rgba.g / 255;
            var b = rgba.b / 255;
            var cmax = Math.max(r, g, b);
            var cmin = Math.min(r, g, b);
            var delta = cmax - cmin;
            var s = cmax === 0 ? 0 : (delta / cmax);
            var m;
            if (delta === 0) {
                m = 0;
            }
            else if (cmax === r) {
                m = ((((g - b) / delta) % 6) + 6) % 6;
            }
            else if (cmax === g) {
                m = ((b - r) / delta) + 2;
            }
            else {
                m = ((r - g) / delta) + 4;
            }
            return new HSVA(Math.round(m * 60), s, cmax, rgba.a);
        };
        // from http://www.rapidtables.com/convert/color/hsv-to-rgb.htm
        HSVA.toRGBA = function (hsva) {
            var h = hsva.h, s = hsva.s, v = hsva.v, a = hsva.a;
            var c = v * s;
            var x = c * (1 - Math.abs((h / 60) % 2 - 1));
            var m = v - c;
            var _a = [0, 0, 0], r = _a[0], g = _a[1], b = _a[2];
            if (h < 60) {
                r = c;
                g = x;
            }
            else if (h < 120) {
                r = x;
                g = c;
            }
            else if (h < 180) {
                g = c;
                b = x;
            }
            else if (h < 240) {
                g = x;
                b = c;
            }
            else if (h < 300) {
                r = x;
                b = c;
            }
            else if (h < 360) {
                r = c;
                b = x;
            }
            r = Math.round((r + m) * 255);
            g = Math.round((g + m) * 255);
            b = Math.round((b + m) * 255);
            return new RGBA(r, g, b, a);
        };
        return HSVA;
    }());
    exports.HSVA = HSVA;
    var Color = /** @class */ (function () {
        function Color(arg) {
            if (!arg) {
                throw new Error('Color needs a value');
            }
            else if (arg instanceof RGBA) {
                this.rgba = arg;
            }
            else if (arg instanceof HSLA) {
                this._hsla = arg;
                this.rgba = HSLA.toRGBA(arg);
            }
            else if (arg instanceof HSVA) {
                this._hsva = arg;
                this.rgba = HSVA.toRGBA(arg);
            }
            else {
                throw new Error('Invalid color ctor argument');
            }
        }
        Color.fromHex = function (hex) {
            return Color.Format.CSS.parseHex(hex) || Color.red;
        };
        Object.defineProperty(Color.prototype, "hsla", {
            get: function () {
                if (this._hsla) {
                    return this._hsla;
                }
                else {
                    return HSLA.fromRGBA(this.rgba);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Color.prototype, "hsva", {
            get: function () {
                if (this._hsva) {
                    return this._hsva;
                }
                return HSVA.fromRGBA(this.rgba);
            },
            enumerable: true,
            configurable: true
        });
        Color.prototype.equals = function (other) {
            return !!other && RGBA.equals(this.rgba, other.rgba) && HSLA.equals(this.hsla, other.hsla) && HSVA.equals(this.hsva, other.hsva);
        };
        /**
         * http://www.w3.org/TR/WCAG20/#relativeluminancedef
         * Returns the number in the set [0, 1]. O => Darkest Black. 1 => Lightest white.
         */
        Color.prototype.getRelativeLuminance = function () {
            var R = Color._relativeLuminanceForComponent(this.rgba.r);
            var G = Color._relativeLuminanceForComponent(this.rgba.g);
            var B = Color._relativeLuminanceForComponent(this.rgba.b);
            var luminance = 0.2126 * R + 0.7152 * G + 0.0722 * B;
            return roundFloat(luminance, 4);
        };
        Color._relativeLuminanceForComponent = function (color) {
            var c = color / 255;
            return (c <= 0.03928) ? c / 12.92 : Math.pow(((c + 0.055) / 1.055), 2.4);
        };
        /**
         *	http://24ways.org/2010/calculating-color-contrast
         *  Return 'true' if lighter color otherwise 'false'
         */
        Color.prototype.isLighter = function () {
            var yiq = (this.rgba.r * 299 + this.rgba.g * 587 + this.rgba.b * 114) / 1000;
            return yiq >= 128;
        };
        Color.prototype.isLighterThan = function (another) {
            var lum1 = this.getRelativeLuminance();
            var lum2 = another.getRelativeLuminance();
            return lum1 > lum2;
        };
        Color.prototype.isDarkerThan = function (another) {
            var lum1 = this.getRelativeLuminance();
            var lum2 = another.getRelativeLuminance();
            return lum1 < lum2;
        };
        Color.prototype.lighten = function (factor) {
            return new Color(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l + this.hsla.l * factor, this.hsla.a));
        };
        Color.prototype.darken = function (factor) {
            return new Color(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l - this.hsla.l * factor, this.hsla.a));
        };
        Color.prototype.transparent = function (factor) {
            var _a = this.rgba, r = _a.r, g = _a.g, b = _a.b, a = _a.a;
            return new Color(new RGBA(r, g, b, a * factor));
        };
        Color.prototype.isTransparent = function () {
            return this.rgba.a === 0;
        };
        Color.prototype.isOpaque = function () {
            return this.rgba.a === 1;
        };
        Color.prototype.opposite = function () {
            return new Color(new RGBA(255 - this.rgba.r, 255 - this.rgba.g, 255 - this.rgba.b, this.rgba.a));
        };
        Color.prototype.toString = function () {
            return '' + Color.Format.CSS.format(this);
        };
        Color.getLighterColor = function (of, relative, factor) {
            if (of.isLighterThan(relative)) {
                return of;
            }
            factor = factor ? factor : 0.5;
            var lum1 = of.getRelativeLuminance();
            var lum2 = relative.getRelativeLuminance();
            factor = factor * (lum2 - lum1) / lum2;
            return of.lighten(factor);
        };
        Color.getDarkerColor = function (of, relative, factor) {
            if (of.isDarkerThan(relative)) {
                return of;
            }
            factor = factor ? factor : 0.5;
            var lum1 = of.getRelativeLuminance();
            var lum2 = relative.getRelativeLuminance();
            factor = factor * (lum1 - lum2) / lum1;
            return of.darken(factor);
        };
        Color.white = new Color(new RGBA(255, 255, 255, 1));
        Color.black = new Color(new RGBA(0, 0, 0, 1));
        Color.red = new Color(new RGBA(255, 0, 0, 1));
        Color.blue = new Color(new RGBA(0, 0, 255, 1));
        Color.cyan = new Color(new RGBA(0, 255, 255, 1));
        Color.lightgrey = new Color(new RGBA(211, 211, 211, 1));
        Color.transparent = new Color(new RGBA(0, 0, 0, 0));
        return Color;
    }());
    exports.Color = Color;
    (function (Color) {
        var Format;
        (function (Format) {
            var CSS;
            (function (CSS) {
                function formatRGB(color) {
                    if (color.rgba.a === 1) {
                        return "rgb(" + color.rgba.r + ", " + color.rgba.g + ", " + color.rgba.b + ")";
                    }
                    return Color.Format.CSS.formatRGBA(color);
                }
                CSS.formatRGB = formatRGB;
                function formatRGBA(color) {
                    return "rgba(" + color.rgba.r + ", " + color.rgba.g + ", " + color.rgba.b + ", " + +(color.rgba.a).toFixed(2) + ")";
                }
                CSS.formatRGBA = formatRGBA;
                function formatHSL(color) {
                    if (color.hsla.a === 1) {
                        return "hsl(" + color.hsla.h + ", " + (color.hsla.s * 100).toFixed(2) + "%, " + (color.hsla.l * 100).toFixed(2) + "%)";
                    }
                    return Color.Format.CSS.formatHSLA(color);
                }
                CSS.formatHSL = formatHSL;
                function formatHSLA(color) {
                    return "hsla(" + color.hsla.h + ", " + (color.hsla.s * 100).toFixed(2) + "%, " + (color.hsla.l * 100).toFixed(2) + "%, " + color.hsla.a.toFixed(2) + ")";
                }
                CSS.formatHSLA = formatHSLA;
                function _toTwoDigitHex(n) {
                    var r = n.toString(16);
                    return r.length !== 2 ? '0' + r : r;
                }
                /**
                 * Formats the color as #RRGGBB
                 */
                function formatHex(color) {
                    return "#" + _toTwoDigitHex(color.rgba.r) + _toTwoDigitHex(color.rgba.g) + _toTwoDigitHex(color.rgba.b);
                }
                CSS.formatHex = formatHex;
                /**
                 * Formats the color as #RRGGBBAA
                 * If 'compact' is set, colors without transparancy will be printed as #RRGGBB
                 */
                function formatHexA(color, compact) {
                    if (compact === void 0) { compact = false; }
                    if (compact && color.rgba.a === 1) {
                        return Color.Format.CSS.formatHex(color);
                    }
                    return "#" + _toTwoDigitHex(color.rgba.r) + _toTwoDigitHex(color.rgba.g) + _toTwoDigitHex(color.rgba.b) + _toTwoDigitHex(Math.round(color.rgba.a * 255));
                }
                CSS.formatHexA = formatHexA;
                /**
                 * The default format will use HEX if opaque and RGBA otherwise.
                 */
                function format(color) {
                    if (!color) {
                        return null;
                    }
                    if (color.isOpaque()) {
                        return Color.Format.CSS.formatHex(color);
                    }
                    return Color.Format.CSS.formatRGBA(color);
                }
                CSS.format = format;
                /**
                 * Converts an Hex color value to a Color.
                 * returns r, g, and b are contained in the set [0, 255]
                 * @param hex string (#RGB, #RGBA, #RRGGBB or #RRGGBBAA).
                 */
                function parseHex(hex) {
                    if (!hex) {
                        // Invalid color
                        return null;
                    }
                    var length = hex.length;
                    if (length === 0) {
                        // Invalid color
                        return null;
                    }
                    if (hex.charCodeAt(0) !== 35 /* Hash */) {
                        // Does not begin with a #
                        return null;
                    }
                    if (length === 7) {
                        // #RRGGBB format
                        var r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
                        var g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
                        var b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
                        return new Color(new RGBA(r, g, b, 1));
                    }
                    if (length === 9) {
                        // #RRGGBBAA format
                        var r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
                        var g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
                        var b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
                        var a = 16 * _parseHexDigit(hex.charCodeAt(7)) + _parseHexDigit(hex.charCodeAt(8));
                        return new Color(new RGBA(r, g, b, a / 255));
                    }
                    if (length === 4) {
                        // #RGB format
                        var r = _parseHexDigit(hex.charCodeAt(1));
                        var g = _parseHexDigit(hex.charCodeAt(2));
                        var b = _parseHexDigit(hex.charCodeAt(3));
                        return new Color(new RGBA(16 * r + r, 16 * g + g, 16 * b + b));
                    }
                    if (length === 5) {
                        // #RGBA format
                        var r = _parseHexDigit(hex.charCodeAt(1));
                        var g = _parseHexDigit(hex.charCodeAt(2));
                        var b = _parseHexDigit(hex.charCodeAt(3));
                        var a = _parseHexDigit(hex.charCodeAt(4));
                        return new Color(new RGBA(16 * r + r, 16 * g + g, 16 * b + b, (16 * a + a) / 255));
                    }
                    // Invalid color
                    return null;
                }
                CSS.parseHex = parseHex;
                function _parseHexDigit(charCode) {
                    switch (charCode) {
                        case 48 /* Digit0 */: return 0;
                        case 49 /* Digit1 */: return 1;
                        case 50 /* Digit2 */: return 2;
                        case 51 /* Digit3 */: return 3;
                        case 52 /* Digit4 */: return 4;
                        case 53 /* Digit5 */: return 5;
                        case 54 /* Digit6 */: return 6;
                        case 55 /* Digit7 */: return 7;
                        case 56 /* Digit8 */: return 8;
                        case 57 /* Digit9 */: return 9;
                        case 97 /* a */: return 10;
                        case 65 /* A */: return 10;
                        case 98 /* b */: return 11;
                        case 66 /* B */: return 11;
                        case 99 /* c */: return 12;
                        case 67 /* C */: return 12;
                        case 100 /* d */: return 13;
                        case 68 /* D */: return 13;
                        case 101 /* e */: return 14;
                        case 69 /* E */: return 14;
                        case 102 /* f */: return 15;
                        case 70 /* F */: return 15;
                    }
                    return 0;
                }
            })(CSS = Format.CSS || (Format.CSS = {}));
        })(Format = Color.Format || (Color.Format = {}));
    })(Color = exports.Color || (exports.Color = {}));
    exports.Color = Color;
});

define(__m[128/*vs/base/common/decorators*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function memoize(target, key, descriptor) {
        var fnKey = null;
        var fn = null;
        if (typeof descriptor.value === 'function') {
            fnKey = 'value';
            fn = descriptor.value;
            if (fn.length !== 0) {
                console.warn('Memoize should only be used in functions with zero parameters');
            }
        }
        else if (typeof descriptor.get === 'function') {
            fnKey = 'get';
            fn = descriptor.get;
        }
        if (!fn) {
            throw new Error('not supported');
        }
        var memoizeKey = "$memoize$" + key;
        descriptor[fnKey] = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            if (!this.hasOwnProperty(memoizeKey)) {
                Object.defineProperty(this, memoizeKey, {
                    configurable: false,
                    enumerable: false,
                    writable: false,
                    value: fn.apply(this, args)
                });
            }
            return this[memoizeKey];
        };
    }
    exports.memoize = memoize;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[431/*vs/base/common/diff/diffChange*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * Represents information about a specific difference between two sequences.
     */
    var DiffChange = /** @class */ (function () {
        /**
         * Constructs a new DiffChange with the given sequence information
         * and content.
         */
        function DiffChange(originalStart, originalLength, modifiedStart, modifiedLength) {
            //Debug.Assert(originalLength > 0 || modifiedLength > 0, "originalLength and modifiedLength cannot both be <= 0");
            this.originalStart = originalStart;
            this.originalLength = originalLength;
            this.modifiedStart = modifiedStart;
            this.modifiedLength = modifiedLength;
        }
        /**
         * The end point (exclusive) of the change in the original sequence.
         */
        DiffChange.prototype.getOriginalEnd = function () {
            return this.originalStart + this.originalLength;
        };
        /**
         * The end point (exclusive) of the change in the modified sequence.
         */
        DiffChange.prototype.getModifiedEnd = function () {
            return this.modifiedStart + this.modifiedLength;
        };
        return DiffChange;
    }());
    exports.DiffChange = DiffChange;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[130/*vs/base/common/diff/diff*/], __M([0/*require*/,1/*exports*/,431/*vs/base/common/diff/diffChange*/]), function (require, exports, diffChange_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function createStringSequence(a) {
        return {
            getLength: function () { return a.length; },
            getElementAtIndex: function (pos) { return a.charCodeAt(pos); }
        };
    }
    function stringDiff(original, modified, pretty) {
        return new LcsDiff(createStringSequence(original), createStringSequence(modified)).ComputeDiff(pretty);
    }
    exports.stringDiff = stringDiff;
    //
    // The code below has been ported from a C# implementation in VS
    //
    var Debug = /** @class */ (function () {
        function Debug() {
        }
        Debug.Assert = function (condition, message) {
            if (!condition) {
                throw new Error(message);
            }
        };
        return Debug;
    }());
    exports.Debug = Debug;
    var MyArray = /** @class */ (function () {
        function MyArray() {
        }
        /**
         * Copies a range of elements from an Array starting at the specified source index and pastes
         * them to another Array starting at the specified destination index. The length and the indexes
         * are specified as 64-bit integers.
         * sourceArray:
         *		The Array that contains the data to copy.
         * sourceIndex:
         *		A 64-bit integer that represents the index in the sourceArray at which copying begins.
         * destinationArray:
         *		The Array that receives the data.
         * destinationIndex:
         *		A 64-bit integer that represents the index in the destinationArray at which storing begins.
         * length:
         *		A 64-bit integer that represents the number of elements to copy.
         */
        MyArray.Copy = function (sourceArray, sourceIndex, destinationArray, destinationIndex, length) {
            for (var i = 0; i < length; i++) {
                destinationArray[destinationIndex + i] = sourceArray[sourceIndex + i];
            }
        };
        return MyArray;
    }());
    exports.MyArray = MyArray;
    //*****************************************************************************
    // LcsDiff.cs
    //
    // An implementation of the difference algorithm described in
    // "An O(ND) Difference Algorithm and its variations" by Eugene W. Myers
    //
    // Copyright (C) 2008 Microsoft Corporation @minifier_do_not_preserve
    //*****************************************************************************
    // Our total memory usage for storing history is (worst-case):
    // 2 * [(MaxDifferencesHistory + 1) * (MaxDifferencesHistory + 1) - 1] * sizeof(int)
    // 2 * [1448*1448 - 1] * 4 = 16773624 = 16MB
    var MaxDifferencesHistory = 1447;
    //let MaxDifferencesHistory = 100;
    /**
     * A utility class which helps to create the set of DiffChanges from
     * a difference operation. This class accepts original DiffElements and
     * modified DiffElements that are involved in a particular change. The
     * MarktNextChange() method can be called to mark the separation between
     * distinct changes. At the end, the Changes property can be called to retrieve
     * the constructed changes.
     */
    var DiffChangeHelper = /** @class */ (function () {
        /**
         * Constructs a new DiffChangeHelper for the given DiffSequences.
         */
        function DiffChangeHelper() {
            this.m_changes = [];
            this.m_originalStart = Number.MAX_VALUE;
            this.m_modifiedStart = Number.MAX_VALUE;
            this.m_originalCount = 0;
            this.m_modifiedCount = 0;
        }
        /**
         * Marks the beginning of the next change in the set of differences.
         */
        DiffChangeHelper.prototype.MarkNextChange = function () {
            // Only add to the list if there is something to add
            if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
                // Add the new change to our list
                this.m_changes.push(new diffChange_1.DiffChange(this.m_originalStart, this.m_originalCount, this.m_modifiedStart, this.m_modifiedCount));
            }
            // Reset for the next change
            this.m_originalCount = 0;
            this.m_modifiedCount = 0;
            this.m_originalStart = Number.MAX_VALUE;
            this.m_modifiedStart = Number.MAX_VALUE;
        };
        /**
         * Adds the original element at the given position to the elements
         * affected by the current change. The modified index gives context
         * to the change position with respect to the original sequence.
         * @param originalIndex The index of the original element to add.
         * @param modifiedIndex The index of the modified element that provides corresponding position in the modified sequence.
         */
        DiffChangeHelper.prototype.AddOriginalElement = function (originalIndex, modifiedIndex) {
            // The 'true' start index is the smallest of the ones we've seen
            this.m_originalStart = Math.min(this.m_originalStart, originalIndex);
            this.m_modifiedStart = Math.min(this.m_modifiedStart, modifiedIndex);
            this.m_originalCount++;
        };
        /**
         * Adds the modified element at the given position to the elements
         * affected by the current change. The original index gives context
         * to the change position with respect to the modified sequence.
         * @param originalIndex The index of the original element that provides corresponding position in the original sequence.
         * @param modifiedIndex The index of the modified element to add.
         */
        DiffChangeHelper.prototype.AddModifiedElement = function (originalIndex, modifiedIndex) {
            // The 'true' start index is the smallest of the ones we've seen
            this.m_originalStart = Math.min(this.m_originalStart, originalIndex);
            this.m_modifiedStart = Math.min(this.m_modifiedStart, modifiedIndex);
            this.m_modifiedCount++;
        };
        /**
         * Retrieves all of the changes marked by the class.
         */
        DiffChangeHelper.prototype.getChanges = function () {
            if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
                // Finish up on whatever is left
                this.MarkNextChange();
            }
            return this.m_changes;
        };
        /**
         * Retrieves all of the changes marked by the class in the reverse order
         */
        DiffChangeHelper.prototype.getReverseChanges = function () {
            if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
                // Finish up on whatever is left
                this.MarkNextChange();
            }
            this.m_changes.reverse();
            return this.m_changes;
        };
        return DiffChangeHelper;
    }());
    /**
     * An implementation of the difference algorithm described in
     * "An O(ND) Difference Algorithm and its variations" by Eugene W. Myers
     */
    var LcsDiff = /** @class */ (function () {
        /**
         * Constructs the DiffFinder
         */
        function LcsDiff(originalSequence, newSequence, continueProcessingPredicate) {
            if (continueProcessingPredicate === void 0) { continueProcessingPredicate = null; }
            this.OriginalSequence = originalSequence;
            this.ModifiedSequence = newSequence;
            this.ContinueProcessingPredicate = continueProcessingPredicate;
            this.m_forwardHistory = [];
            this.m_reverseHistory = [];
        }
        LcsDiff.prototype.ElementsAreEqual = function (originalIndex, newIndex) {
            return (this.OriginalSequence.getElementAtIndex(originalIndex) === this.ModifiedSequence.getElementAtIndex(newIndex));
        };
        LcsDiff.prototype.OriginalElementsAreEqual = function (index1, index2) {
            return (this.OriginalSequence.getElementAtIndex(index1) === this.OriginalSequence.getElementAtIndex(index2));
        };
        LcsDiff.prototype.ModifiedElementsAreEqual = function (index1, index2) {
            return (this.ModifiedSequence.getElementAtIndex(index1) === this.ModifiedSequence.getElementAtIndex(index2));
        };
        LcsDiff.prototype.ComputeDiff = function (pretty) {
            return this._ComputeDiff(0, this.OriginalSequence.getLength() - 1, 0, this.ModifiedSequence.getLength() - 1, pretty);
        };
        /**
         * Computes the differences between the original and modified input
         * sequences on the bounded range.
         * @returns An array of the differences between the two input sequences.
         */
        LcsDiff.prototype._ComputeDiff = function (originalStart, originalEnd, modifiedStart, modifiedEnd, pretty) {
            var quitEarlyArr = [false];
            var changes = this.ComputeDiffRecursive(originalStart, originalEnd, modifiedStart, modifiedEnd, quitEarlyArr);
            if (pretty) {
                // We have to clean up the computed diff to be more intuitive
                // but it turns out this cannot be done correctly until the entire set
                // of diffs have been computed
                return this.PrettifyChanges(changes);
            }
            return changes;
        };
        /**
         * Private helper method which computes the differences on the bounded range
         * recursively.
         * @returns An array of the differences between the two input sequences.
         */
        LcsDiff.prototype.ComputeDiffRecursive = function (originalStart, originalEnd, modifiedStart, modifiedEnd, quitEarlyArr) {
            quitEarlyArr[0] = false;
            // Find the start of the differences
            while (originalStart <= originalEnd && modifiedStart <= modifiedEnd && this.ElementsAreEqual(originalStart, modifiedStart)) {
                originalStart++;
                modifiedStart++;
            }
            // Find the end of the differences
            while (originalEnd >= originalStart && modifiedEnd >= modifiedStart && this.ElementsAreEqual(originalEnd, modifiedEnd)) {
                originalEnd--;
                modifiedEnd--;
            }
            // In the special case where we either have all insertions or all deletions or the sequences are identical
            if (originalStart > originalEnd || modifiedStart > modifiedEnd) {
                var changes = void 0;
                if (modifiedStart <= modifiedEnd) {
                    Debug.Assert(originalStart === originalEnd + 1, 'originalStart should only be one more than originalEnd');
                    // All insertions
                    changes = [
                        new diffChange_1.DiffChange(originalStart, 0, modifiedStart, modifiedEnd - modifiedStart + 1)
                    ];
                }
                else if (originalStart <= originalEnd) {
                    Debug.Assert(modifiedStart === modifiedEnd + 1, 'modifiedStart should only be one more than modifiedEnd');
                    // All deletions
                    changes = [
                        new diffChange_1.DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, 0)
                    ];
                }
                else {
                    Debug.Assert(originalStart === originalEnd + 1, 'originalStart should only be one more than originalEnd');
                    Debug.Assert(modifiedStart === modifiedEnd + 1, 'modifiedStart should only be one more than modifiedEnd');
                    // Identical sequences - No differences
                    changes = [];
                }
                return changes;
            }
            // This problem can be solved using the Divide-And-Conquer technique.
            var midOriginalArr = [0], midModifiedArr = [0];
            var result = this.ComputeRecursionPoint(originalStart, originalEnd, modifiedStart, modifiedEnd, midOriginalArr, midModifiedArr, quitEarlyArr);
            var midOriginal = midOriginalArr[0];
            var midModified = midModifiedArr[0];
            if (result !== null) {
                // Result is not-null when there was enough memory to compute the changes while
                // searching for the recursion point
                return result;
            }
            else if (!quitEarlyArr[0]) {
                // We can break the problem down recursively by finding the changes in the
                // First Half:   (originalStart, modifiedStart) to (midOriginal, midModified)
                // Second Half:  (midOriginal + 1, minModified + 1) to (originalEnd, modifiedEnd)
                // NOTE: ComputeDiff() is inclusive, therefore the second range starts on the next point
                var leftChanges = this.ComputeDiffRecursive(originalStart, midOriginal, modifiedStart, midModified, quitEarlyArr);
                var rightChanges = [];
                if (!quitEarlyArr[0]) {
                    rightChanges = this.ComputeDiffRecursive(midOriginal + 1, originalEnd, midModified + 1, modifiedEnd, quitEarlyArr);
                }
                else {
                    // We did't have time to finish the first half, so we don't have time to compute this half.
                    // Consider the entire rest of the sequence different.
                    rightChanges = [
                        new diffChange_1.DiffChange(midOriginal + 1, originalEnd - (midOriginal + 1) + 1, midModified + 1, modifiedEnd - (midModified + 1) + 1)
                    ];
                }
                return this.ConcatenateChanges(leftChanges, rightChanges);
            }
            // If we hit here, we quit early, and so can't return anything meaningful
            return [
                new diffChange_1.DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, modifiedEnd - modifiedStart + 1)
            ];
        };
        LcsDiff.prototype.WALKTRACE = function (diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr) {
            var forwardChanges = null, reverseChanges = null;
            // First, walk backward through the forward diagonals history
            var changeHelper = new DiffChangeHelper();
            var diagonalMin = diagonalForwardStart;
            var diagonalMax = diagonalForwardEnd;
            var diagonalRelative = (midOriginalArr[0] - midModifiedArr[0]) - diagonalForwardOffset;
            var lastOriginalIndex = Number.MIN_VALUE;
            var historyIndex = this.m_forwardHistory.length - 1;
            var diagonal;
            do {
                // Get the diagonal index from the relative diagonal number
                diagonal = diagonalRelative + diagonalForwardBase;
                // Figure out where we came from
                if (diagonal === diagonalMin || (diagonal < diagonalMax && forwardPoints[diagonal - 1] < forwardPoints[diagonal + 1])) {
                    // Vertical line (the element is an insert)
                    originalIndex = forwardPoints[diagonal + 1];
                    modifiedIndex = originalIndex - diagonalRelative - diagonalForwardOffset;
                    if (originalIndex < lastOriginalIndex) {
                        changeHelper.MarkNextChange();
                    }
                    lastOriginalIndex = originalIndex;
                    changeHelper.AddModifiedElement(originalIndex + 1, modifiedIndex);
                    diagonalRelative = (diagonal + 1) - diagonalForwardBase; //Setup for the next iteration
                }
                else {
                    // Horizontal line (the element is a deletion)
                    originalIndex = forwardPoints[diagonal - 1] + 1;
                    modifiedIndex = originalIndex - diagonalRelative - diagonalForwardOffset;
                    if (originalIndex < lastOriginalIndex) {
                        changeHelper.MarkNextChange();
                    }
                    lastOriginalIndex = originalIndex - 1;
                    changeHelper.AddOriginalElement(originalIndex, modifiedIndex + 1);
                    diagonalRelative = (diagonal - 1) - diagonalForwardBase; //Setup for the next iteration
                }
                if (historyIndex >= 0) {
                    forwardPoints = this.m_forwardHistory[historyIndex];
                    diagonalForwardBase = forwardPoints[0]; //We stored this in the first spot
                    diagonalMin = 1;
                    diagonalMax = forwardPoints.length - 1;
                }
            } while (--historyIndex >= -1);
            // Ironically, we get the forward changes as the reverse of the
            // order we added them since we technically added them backwards
            forwardChanges = changeHelper.getReverseChanges();
            if (quitEarlyArr[0]) {
                // TODO: Calculate a partial from the reverse diagonals.
                //       For now, just assume everything after the midOriginal/midModified point is a diff
                var originalStartPoint = midOriginalArr[0] + 1;
                var modifiedStartPoint = midModifiedArr[0] + 1;
                if (forwardChanges !== null && forwardChanges.length > 0) {
                    var lastForwardChange = forwardChanges[forwardChanges.length - 1];
                    originalStartPoint = Math.max(originalStartPoint, lastForwardChange.getOriginalEnd());
                    modifiedStartPoint = Math.max(modifiedStartPoint, lastForwardChange.getModifiedEnd());
                }
                reverseChanges = [
                    new diffChange_1.DiffChange(originalStartPoint, originalEnd - originalStartPoint + 1, modifiedStartPoint, modifiedEnd - modifiedStartPoint + 1)
                ];
            }
            else {
                // Now walk backward through the reverse diagonals history
                changeHelper = new DiffChangeHelper();
                diagonalMin = diagonalReverseStart;
                diagonalMax = diagonalReverseEnd;
                diagonalRelative = (midOriginalArr[0] - midModifiedArr[0]) - diagonalReverseOffset;
                lastOriginalIndex = Number.MAX_VALUE;
                historyIndex = (deltaIsEven) ? this.m_reverseHistory.length - 1 : this.m_reverseHistory.length - 2;
                do {
                    // Get the diagonal index from the relative diagonal number
                    diagonal = diagonalRelative + diagonalReverseBase;
                    // Figure out where we came from
                    if (diagonal === diagonalMin || (diagonal < diagonalMax && reversePoints[diagonal - 1] >= reversePoints[diagonal + 1])) {
                        // Horizontal line (the element is a deletion))
                        originalIndex = reversePoints[diagonal + 1] - 1;
                        modifiedIndex = originalIndex - diagonalRelative - diagonalReverseOffset;
                        if (originalIndex > lastOriginalIndex) {
                            changeHelper.MarkNextChange();
                        }
                        lastOriginalIndex = originalIndex + 1;
                        changeHelper.AddOriginalElement(originalIndex + 1, modifiedIndex + 1);
                        diagonalRelative = (diagonal + 1) - diagonalReverseBase; //Setup for the next iteration
                    }
                    else {
                        // Vertical line (the element is an insertion)
                        originalIndex = reversePoints[diagonal - 1];
                        modifiedIndex = originalIndex - diagonalRelative - diagonalReverseOffset;
                        if (originalIndex > lastOriginalIndex) {
                            changeHelper.MarkNextChange();
                        }
                        lastOriginalIndex = originalIndex;
                        changeHelper.AddModifiedElement(originalIndex + 1, modifiedIndex + 1);
                        diagonalRelative = (diagonal - 1) - diagonalReverseBase; //Setup for the next iteration
                    }
                    if (historyIndex >= 0) {
                        reversePoints = this.m_reverseHistory[historyIndex];
                        diagonalReverseBase = reversePoints[0]; //We stored this in the first spot
                        diagonalMin = 1;
                        diagonalMax = reversePoints.length - 1;
                    }
                } while (--historyIndex >= -1);
                // There are cases where the reverse history will find diffs that
                // are correct, but not intuitive, so we need shift them.
                reverseChanges = changeHelper.getChanges();
            }
            return this.ConcatenateChanges(forwardChanges, reverseChanges);
        };
        /**
         * Given the range to compute the diff on, this method finds the point:
         * (midOriginal, midModified)
         * that exists in the middle of the LCS of the two sequences and
         * is the point at which the LCS problem may be broken down recursively.
         * This method will try to keep the LCS trace in memory. If the LCS recursion
         * point is calculated and the full trace is available in memory, then this method
         * will return the change list.
         * @param originalStart The start bound of the original sequence range
         * @param originalEnd The end bound of the original sequence range
         * @param modifiedStart The start bound of the modified sequence range
         * @param modifiedEnd The end bound of the modified sequence range
         * @param midOriginal The middle point of the original sequence range
         * @param midModified The middle point of the modified sequence range
         * @returns The diff changes, if available, otherwise null
         */
        LcsDiff.prototype.ComputeRecursionPoint = function (originalStart, originalEnd, modifiedStart, modifiedEnd, midOriginalArr, midModifiedArr, quitEarlyArr) {
            var originalIndex = 0, modifiedIndex = 0;
            var diagonalForwardStart = 0, diagonalForwardEnd = 0;
            var diagonalReverseStart = 0, diagonalReverseEnd = 0;
            var numDifferences;
            // To traverse the edit graph and produce the proper LCS, our actual
            // start position is just outside the given boundary
            originalStart--;
            modifiedStart--;
            // We set these up to make the compiler happy, but they will
            // be replaced before we return with the actual recursion point
            midOriginalArr[0] = 0;
            midModifiedArr[0] = 0;
            // Clear out the history
            this.m_forwardHistory = [];
            this.m_reverseHistory = [];
            // Each cell in the two arrays corresponds to a diagonal in the edit graph.
            // The integer value in the cell represents the originalIndex of the furthest
            // reaching point found so far that ends in that diagonal.
            // The modifiedIndex can be computed mathematically from the originalIndex and the diagonal number.
            var maxDifferences = (originalEnd - originalStart) + (modifiedEnd - modifiedStart);
            var numDiagonals = maxDifferences + 1;
            var forwardPoints = new Array(numDiagonals);
            var reversePoints = new Array(numDiagonals);
            // diagonalForwardBase: Index into forwardPoints of the diagonal which passes through (originalStart, modifiedStart)
            // diagonalReverseBase: Index into reversePoints of the diagonal which passes through (originalEnd, modifiedEnd)
            var diagonalForwardBase = (modifiedEnd - modifiedStart);
            var diagonalReverseBase = (originalEnd - originalStart);
            // diagonalForwardOffset: Geometric offset which allows modifiedIndex to be computed from originalIndex and the
            //    diagonal number (relative to diagonalForwardBase)
            // diagonalReverseOffset: Geometric offset which allows modifiedIndex to be computed from originalIndex and the
            //    diagonal number (relative to diagonalReverseBase)
            var diagonalForwardOffset = (originalStart - modifiedStart);
            var diagonalReverseOffset = (originalEnd - modifiedEnd);
            // delta: The difference between the end diagonal and the start diagonal. This is used to relate diagonal numbers
            //   relative to the start diagonal with diagonal numbers relative to the end diagonal.
            // The Even/Oddn-ness of this delta is important for determining when we should check for overlap
            var delta = diagonalReverseBase - diagonalForwardBase;
            var deltaIsEven = (delta % 2 === 0);
            // Here we set up the start and end points as the furthest points found so far
            // in both the forward and reverse directions, respectively
            forwardPoints[diagonalForwardBase] = originalStart;
            reversePoints[diagonalReverseBase] = originalEnd;
            // Remember if we quit early, and thus need to do a best-effort result instead of a real result.
            quitEarlyArr[0] = false;
            // A couple of points:
            // --With this method, we iterate on the number of differences between the two sequences.
            //   The more differences there actually are, the longer this will take.
            // --Also, as the number of differences increases, we have to search on diagonals further
            //   away from the reference diagonal (which is diagonalForwardBase for forward, diagonalReverseBase for reverse).
            // --We extend on even diagonals (relative to the reference diagonal) only when numDifferences
            //   is even and odd diagonals only when numDifferences is odd.
            var diagonal, tempOriginalIndex;
            for (numDifferences = 1; numDifferences <= (maxDifferences / 2) + 1; numDifferences++) {
                var furthestOriginalIndex = 0;
                var furthestModifiedIndex = 0;
                // Run the algorithm in the forward direction
                diagonalForwardStart = this.ClipDiagonalBound(diagonalForwardBase - numDifferences, numDifferences, diagonalForwardBase, numDiagonals);
                diagonalForwardEnd = this.ClipDiagonalBound(diagonalForwardBase + numDifferences, numDifferences, diagonalForwardBase, numDiagonals);
                for (diagonal = diagonalForwardStart; diagonal <= diagonalForwardEnd; diagonal += 2) {
                    // STEP 1: We extend the furthest reaching point in the present diagonal
                    // by looking at the diagonals above and below and picking the one whose point
                    // is further away from the start point (originalStart, modifiedStart)
                    if (diagonal === diagonalForwardStart || (diagonal < diagonalForwardEnd && forwardPoints[diagonal - 1] < forwardPoints[diagonal + 1])) {
                        originalIndex = forwardPoints[diagonal + 1];
                    }
                    else {
                        originalIndex = forwardPoints[diagonal - 1] + 1;
                    }
                    modifiedIndex = originalIndex - (diagonal - diagonalForwardBase) - diagonalForwardOffset;
                    // Save the current originalIndex so we can test for false overlap in step 3
                    tempOriginalIndex = originalIndex;
                    // STEP 2: We can continue to extend the furthest reaching point in the present diagonal
                    // so long as the elements are equal.
                    while (originalIndex < originalEnd && modifiedIndex < modifiedEnd && this.ElementsAreEqual(originalIndex + 1, modifiedIndex + 1)) {
                        originalIndex++;
                        modifiedIndex++;
                    }
                    forwardPoints[diagonal] = originalIndex;
                    if (originalIndex + modifiedIndex > furthestOriginalIndex + furthestModifiedIndex) {
                        furthestOriginalIndex = originalIndex;
                        furthestModifiedIndex = modifiedIndex;
                    }
                    // STEP 3: If delta is odd (overlap first happens on forward when delta is odd)
                    // and diagonal is in the range of reverse diagonals computed for numDifferences-1
                    // (the previous iteration; we haven't computed reverse diagonals for numDifferences yet)
                    // then check for overlap.
                    if (!deltaIsEven && Math.abs(diagonal - diagonalReverseBase) <= (numDifferences - 1)) {
                        if (originalIndex >= reversePoints[diagonal]) {
                            midOriginalArr[0] = originalIndex;
                            midModifiedArr[0] = modifiedIndex;
                            if (tempOriginalIndex <= reversePoints[diagonal] && MaxDifferencesHistory > 0 && numDifferences <= (MaxDifferencesHistory + 1)) {
                                // BINGO! We overlapped, and we have the full trace in memory!
                                return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
                            }
                            else {
                                // Either false overlap, or we didn't have enough memory for the full trace
                                // Just return the recursion point
                                return null;
                            }
                        }
                    }
                }
                // Check to see if we should be quitting early, before moving on to the next iteration.
                var matchLengthOfLongest = ((furthestOriginalIndex - originalStart) + (furthestModifiedIndex - modifiedStart) - numDifferences) / 2;
                if (this.ContinueProcessingPredicate !== null && !this.ContinueProcessingPredicate(furthestOriginalIndex, this.OriginalSequence, matchLengthOfLongest)) {
                    // We can't finish, so skip ahead to generating a result from what we have.
                    quitEarlyArr[0] = true;
                    // Use the furthest distance we got in the forward direction.
                    midOriginalArr[0] = furthestOriginalIndex;
                    midModifiedArr[0] = furthestModifiedIndex;
                    if (matchLengthOfLongest > 0 && MaxDifferencesHistory > 0 && numDifferences <= (MaxDifferencesHistory + 1)) {
                        // Enough of the history is in memory to walk it backwards
                        return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
                    }
                    else {
                        // We didn't actually remember enough of the history.
                        //Since we are quiting the diff early, we need to shift back the originalStart and modified start
                        //back into the boundary limits since we decremented their value above beyond the boundary limit.
                        originalStart++;
                        modifiedStart++;
                        return [
                            new diffChange_1.DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, modifiedEnd - modifiedStart + 1)
                        ];
                    }
                }
                // Run the algorithm in the reverse direction
                diagonalReverseStart = this.ClipDiagonalBound(diagonalReverseBase - numDifferences, numDifferences, diagonalReverseBase, numDiagonals);
                diagonalReverseEnd = this.ClipDiagonalBound(diagonalReverseBase + numDifferences, numDifferences, diagonalReverseBase, numDiagonals);
                for (diagonal = diagonalReverseStart; diagonal <= diagonalReverseEnd; diagonal += 2) {
                    // STEP 1: We extend the furthest reaching point in the present diagonal
                    // by looking at the diagonals above and below and picking the one whose point
                    // is further away from the start point (originalEnd, modifiedEnd)
                    if (diagonal === diagonalReverseStart || (diagonal < diagonalReverseEnd && reversePoints[diagonal - 1] >= reversePoints[diagonal + 1])) {
                        originalIndex = reversePoints[diagonal + 1] - 1;
                    }
                    else {
                        originalIndex = reversePoints[diagonal - 1];
                    }
                    modifiedIndex = originalIndex - (diagonal - diagonalReverseBase) - diagonalReverseOffset;
                    // Save the current originalIndex so we can test for false overlap
                    tempOriginalIndex = originalIndex;
                    // STEP 2: We can continue to extend the furthest reaching point in the present diagonal
                    // as long as the elements are equal.
                    while (originalIndex > originalStart && modifiedIndex > modifiedStart && this.ElementsAreEqual(originalIndex, modifiedIndex)) {
                        originalIndex--;
                        modifiedIndex--;
                    }
                    reversePoints[diagonal] = originalIndex;
                    // STEP 4: If delta is even (overlap first happens on reverse when delta is even)
                    // and diagonal is in the range of forward diagonals computed for numDifferences
                    // then check for overlap.
                    if (deltaIsEven && Math.abs(diagonal - diagonalForwardBase) <= numDifferences) {
                        if (originalIndex <= forwardPoints[diagonal]) {
                            midOriginalArr[0] = originalIndex;
                            midModifiedArr[0] = modifiedIndex;
                            if (tempOriginalIndex >= forwardPoints[diagonal] && MaxDifferencesHistory > 0 && numDifferences <= (MaxDifferencesHistory + 1)) {
                                // BINGO! We overlapped, and we have the full trace in memory!
                                return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
                            }
                            else {
                                // Either false overlap, or we didn't have enough memory for the full trace
                                // Just return the recursion point
                                return null;
                            }
                        }
                    }
                }
                // Save current vectors to history before the next iteration
                if (numDifferences <= MaxDifferencesHistory) {
                    // We are allocating space for one extra int, which we fill with
                    // the index of the diagonal base index
                    var temp = new Array(diagonalForwardEnd - diagonalForwardStart + 2);
                    temp[0] = diagonalForwardBase - diagonalForwardStart + 1;
                    MyArray.Copy(forwardPoints, diagonalForwardStart, temp, 1, diagonalForwardEnd - diagonalForwardStart + 1);
                    this.m_forwardHistory.push(temp);
                    temp = new Array(diagonalReverseEnd - diagonalReverseStart + 2);
                    temp[0] = diagonalReverseBase - diagonalReverseStart + 1;
                    MyArray.Copy(reversePoints, diagonalReverseStart, temp, 1, diagonalReverseEnd - diagonalReverseStart + 1);
                    this.m_reverseHistory.push(temp);
                }
            }
            // If we got here, then we have the full trace in history. We just have to convert it to a change list
            // NOTE: This part is a bit messy
            return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
        };
        /**
         * Shifts the given changes to provide a more intuitive diff.
         * While the first element in a diff matches the first element after the diff,
         * we shift the diff down.
         *
         * @param changes The list of changes to shift
         * @returns The shifted changes
         */
        LcsDiff.prototype.PrettifyChanges = function (changes) {
            // Shift all the changes down first
            for (var i = 0; i < changes.length; i++) {
                var change = changes[i];
                var originalStop = (i < changes.length - 1) ? changes[i + 1].originalStart : this.OriginalSequence.getLength();
                var modifiedStop = (i < changes.length - 1) ? changes[i + 1].modifiedStart : this.ModifiedSequence.getLength();
                var checkOriginal = change.originalLength > 0;
                var checkModified = change.modifiedLength > 0;
                while (change.originalStart + change.originalLength < originalStop &&
                    change.modifiedStart + change.modifiedLength < modifiedStop &&
                    (!checkOriginal || this.OriginalElementsAreEqual(change.originalStart, change.originalStart + change.originalLength)) &&
                    (!checkModified || this.ModifiedElementsAreEqual(change.modifiedStart, change.modifiedStart + change.modifiedLength))) {
                    change.originalStart++;
                    change.modifiedStart++;
                }
                var mergedChangeArr = [null];
                if (i < changes.length - 1 && this.ChangesOverlap(changes[i], changes[i + 1], mergedChangeArr)) {
                    changes[i] = mergedChangeArr[0];
                    changes.splice(i + 1, 1);
                    i--;
                    continue;
                }
            }
            // Shift changes back up until we hit empty or whitespace-only lines
            for (var i = changes.length - 1; i >= 0; i--) {
                var change = changes[i];
                var originalStop = 0;
                var modifiedStop = 0;
                if (i > 0) {
                    var prevChange = changes[i - 1];
                    if (prevChange.originalLength > 0) {
                        originalStop = prevChange.originalStart + prevChange.originalLength;
                    }
                    if (prevChange.modifiedLength > 0) {
                        modifiedStop = prevChange.modifiedStart + prevChange.modifiedLength;
                    }
                }
                var checkOriginal = change.originalLength > 0;
                var checkModified = change.modifiedLength > 0;
                var bestDelta = 0;
                var bestScore = this._boundaryScore(change.originalStart, change.originalLength, change.modifiedStart, change.modifiedLength);
                for (var delta = 1;; delta++) {
                    var originalStart = change.originalStart - delta;
                    var modifiedStart = change.modifiedStart - delta;
                    if (originalStart < originalStop || modifiedStart < modifiedStop) {
                        break;
                    }
                    if (checkOriginal && !this.OriginalElementsAreEqual(originalStart, originalStart + change.originalLength)) {
                        break;
                    }
                    if (checkModified && !this.ModifiedElementsAreEqual(modifiedStart, modifiedStart + change.modifiedLength)) {
                        break;
                    }
                    var score = this._boundaryScore(originalStart, change.originalLength, modifiedStart, change.modifiedLength);
                    if (score > bestScore) {
                        bestScore = score;
                        bestDelta = delta;
                    }
                }
                change.originalStart -= bestDelta;
                change.modifiedStart -= bestDelta;
            }
            return changes;
        };
        LcsDiff.prototype._OriginalIsBoundary = function (index) {
            if (index <= 0 || index >= this.OriginalSequence.getLength() - 1) {
                return true;
            }
            var element = this.OriginalSequence.getElementAtIndex(index);
            return (typeof element === 'string' && /^\s*$/.test(element));
        };
        LcsDiff.prototype._OriginalRegionIsBoundary = function (originalStart, originalLength) {
            if (this._OriginalIsBoundary(originalStart) || this._OriginalIsBoundary(originalStart - 1)) {
                return true;
            }
            if (originalLength > 0) {
                var originalEnd = originalStart + originalLength;
                if (this._OriginalIsBoundary(originalEnd - 1) || this._OriginalIsBoundary(originalEnd)) {
                    return true;
                }
            }
            return false;
        };
        LcsDiff.prototype._ModifiedIsBoundary = function (index) {
            if (index <= 0 || index >= this.ModifiedSequence.getLength() - 1) {
                return true;
            }
            var element = this.ModifiedSequence.getElementAtIndex(index);
            return (typeof element === 'string' && /^\s*$/.test(element));
        };
        LcsDiff.prototype._ModifiedRegionIsBoundary = function (modifiedStart, modifiedLength) {
            if (this._ModifiedIsBoundary(modifiedStart) || this._ModifiedIsBoundary(modifiedStart - 1)) {
                return true;
            }
            if (modifiedLength > 0) {
                var modifiedEnd = modifiedStart + modifiedLength;
                if (this._ModifiedIsBoundary(modifiedEnd - 1) || this._ModifiedIsBoundary(modifiedEnd)) {
                    return true;
                }
            }
            return false;
        };
        LcsDiff.prototype._boundaryScore = function (originalStart, originalLength, modifiedStart, modifiedLength) {
            var originalScore = (this._OriginalRegionIsBoundary(originalStart, originalLength) ? 1 : 0);
            var modifiedScore = (this._ModifiedRegionIsBoundary(modifiedStart, modifiedLength) ? 1 : 0);
            return (originalScore + modifiedScore);
        };
        /**
         * Concatenates the two input DiffChange lists and returns the resulting
         * list.
         * @param The left changes
         * @param The right changes
         * @returns The concatenated list
         */
        LcsDiff.prototype.ConcatenateChanges = function (left, right) {
            var mergedChangeArr = [];
            if (left.length === 0 || right.length === 0) {
                return (right.length > 0) ? right : left;
            }
            else if (this.ChangesOverlap(left[left.length - 1], right[0], mergedChangeArr)) {
                // Since we break the problem down recursively, it is possible that we
                // might recurse in the middle of a change thereby splitting it into
                // two changes. Here in the combining stage, we detect and fuse those
                // changes back together
                var result = new Array(left.length + right.length - 1);
                MyArray.Copy(left, 0, result, 0, left.length - 1);
                result[left.length - 1] = mergedChangeArr[0];
                MyArray.Copy(right, 1, result, left.length, right.length - 1);
                return result;
            }
            else {
                var result = new Array(left.length + right.length);
                MyArray.Copy(left, 0, result, 0, left.length);
                MyArray.Copy(right, 0, result, left.length, right.length);
                return result;
            }
        };
        /**
         * Returns true if the two changes overlap and can be merged into a single
         * change
         * @param left The left change
         * @param right The right change
         * @param mergedChange The merged change if the two overlap, null otherwise
         * @returns True if the two changes overlap
         */
        LcsDiff.prototype.ChangesOverlap = function (left, right, mergedChangeArr) {
            Debug.Assert(left.originalStart <= right.originalStart, 'Left change is not less than or equal to right change');
            Debug.Assert(left.modifiedStart <= right.modifiedStart, 'Left change is not less than or equal to right change');
            if (left.originalStart + left.originalLength >= right.originalStart || left.modifiedStart + left.modifiedLength >= right.modifiedStart) {
                var originalStart = left.originalStart;
                var originalLength = left.originalLength;
                var modifiedStart = left.modifiedStart;
                var modifiedLength = left.modifiedLength;
                if (left.originalStart + left.originalLength >= right.originalStart) {
                    originalLength = right.originalStart + right.originalLength - left.originalStart;
                }
                if (left.modifiedStart + left.modifiedLength >= right.modifiedStart) {
                    modifiedLength = right.modifiedStart + right.modifiedLength - left.modifiedStart;
                }
                mergedChangeArr[0] = new diffChange_1.DiffChange(originalStart, originalLength, modifiedStart, modifiedLength);
                return true;
            }
            else {
                mergedChangeArr[0] = null;
                return false;
            }
        };
        /**
         * Helper method used to clip a diagonal index to the range of valid
         * diagonals. This also decides whether or not the diagonal index,
         * if it exceeds the boundary, should be clipped to the boundary or clipped
         * one inside the boundary depending on the Even/Odd status of the boundary
         * and numDifferences.
         * @param diagonal The index of the diagonal to clip.
         * @param numDifferences The current number of differences being iterated upon.
         * @param diagonalBaseIndex The base reference diagonal.
         * @param numDiagonals The total number of diagonals.
         * @returns The clipped diagonal index.
         */
        LcsDiff.prototype.ClipDiagonalBound = function (diagonal, numDifferences, diagonalBaseIndex, numDiagonals) {
            if (diagonal >= 0 && diagonal < numDiagonals) {
                // Nothing to clip, its in range
                return diagonal;
            }
            // diagonalsBelow: The number of diagonals below the reference diagonal
            // diagonalsAbove: The number of diagonals above the reference diagonal
            var diagonalsBelow = diagonalBaseIndex;
            var diagonalsAbove = numDiagonals - diagonalBaseIndex - 1;
            var diffEven = (numDifferences % 2 === 0);
            if (diagonal < 0) {
                var lowerBoundEven = (diagonalsBelow % 2 === 0);
                return (diffEven === lowerBoundEven) ? 0 : 1;
            }
            else {
                var upperBoundEven = (diagonalsAbove % 2 === 0);
                return (diffEven === upperBoundEven) ? numDiagonals - 1 : numDiagonals - 2;
            }
        };
        return LcsDiff;
    }());
    exports.LcsDiff = LcsDiff;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[414/*vs/base/common/functional*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function once(fn) {
        var _this = this;
        var didCall = false;
        var result;
        return function () {
            if (didCall) {
                return result;
            }
            didCall = true;
            result = fn.apply(_this, arguments);
            return result;
        };
    }
    exports.once = once;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[418/*vs/base/common/hash*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * Return a hash value for an object.
     */
    function hash(obj, hashVal) {
        if (hashVal === void 0) { hashVal = 0; }
        switch (typeof obj) {
            case 'object':
                if (obj === null) {
                    return numberHash(349, hashVal);
                }
                else if (Array.isArray(obj)) {
                    return arrayHash(obj, hashVal);
                }
                return objectHash(obj, hashVal);
            case 'string':
                return stringHash(obj, hashVal);
            case 'boolean':
                return booleanHash(obj, hashVal);
            case 'number':
                return numberHash(obj, hashVal);
            case 'undefined':
                return numberHash(0, 937);
            default:
                return numberHash(0, 617);
        }
    }
    exports.hash = hash;
    function numberHash(val, initialHashVal) {
        return (((initialHashVal << 5) - initialHashVal) + val) | 0; // hashVal * 31 + ch, keep as int32
    }
    function booleanHash(b, initialHashVal) {
        return numberHash(b ? 433 : 863, initialHashVal);
    }
    function stringHash(s, hashVal) {
        hashVal = numberHash(149417, hashVal);
        for (var i = 0, length_1 = s.length; i < length_1; i++) {
            hashVal = numberHash(s.charCodeAt(i), hashVal);
        }
        return hashVal;
    }
    function arrayHash(arr, initialHashVal) {
        initialHashVal = numberHash(104579, initialHashVal);
        return arr.reduce(function (hashVal, item) { return hash(item, hashVal); }, initialHashVal);
    }
    function objectHash(obj, initialHashVal) {
        initialHashVal = numberHash(181387, initialHashVal);
        return Object.keys(obj).sort().reduce(function (hashVal, key) {
            hashVal = stringHash(key, hashVal);
            return hash(obj[key], hashVal);
        }, initialHashVal);
    }
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[68/*vs/base/common/htmlContent*/], __M([0/*require*/,1/*exports*/,22/*vs/base/common/arrays*/]), function (require, exports, arrays_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MarkdownString = /** @class */ (function () {
        function MarkdownString(value) {
            if (value === void 0) { value = ''; }
            this.value = value;
        }
        MarkdownString.prototype.appendText = function (value) {
            // escape markdown syntax tokens: http://daringfireball.net/projects/markdown/syntax#backslash
            this.value += value.replace(/[\\`*_{}[\]()#+\-.!]/g, '\\$&');
            return this;
        };
        MarkdownString.prototype.appendMarkdown = function (value) {
            this.value += value;
            return this;
        };
        MarkdownString.prototype.appendCodeblock = function (langId, code) {
            this.value += '\n```';
            this.value += langId;
            this.value += '\n';
            this.value += code;
            this.value += '\n```\n';
            return this;
        };
        return MarkdownString;
    }());
    exports.MarkdownString = MarkdownString;
    function isEmptyMarkdownString(oneOrMany) {
        if (isMarkdownString(oneOrMany)) {
            return !oneOrMany.value;
        }
        else if (Array.isArray(oneOrMany)) {
            return oneOrMany.every(isEmptyMarkdownString);
        }
        else {
            return true;
        }
    }
    exports.isEmptyMarkdownString = isEmptyMarkdownString;
    function isMarkdownString(thing) {
        if (thing instanceof MarkdownString) {
            return true;
        }
        else if (thing && typeof thing === 'object') {
            return typeof thing.value === 'string'
                && (typeof thing.isTrusted === 'boolean' || thing.isTrusted === void 0);
        }
        return false;
    }
    exports.isMarkdownString = isMarkdownString;
    function markedStringsEquals(a, b) {
        if (!a && !b) {
            return true;
        }
        else if (!a || !b) {
            return false;
        }
        else if (Array.isArray(a) && Array.isArray(b)) {
            return arrays_1.equals(a, b, markdownStringEqual);
        }
        else if (isMarkdownString(a) && isMarkdownString(b)) {
            return markdownStringEqual(a, b);
        }
        else {
            return false;
        }
    }
    exports.markedStringsEquals = markedStringsEquals;
    function markdownStringEqual(a, b) {
        if (a === b) {
            return true;
        }
        else if (!a || !b) {
            return false;
        }
        else {
            return a.value === b.value && a.isTrusted === b.isTrusted;
        }
    }
    function removeMarkdownEscapes(text) {
        if (!text) {
            return text;
        }
        return text.replace(/\\([\\`*_{}[\]()#+\-.!])/g, '$1');
    }
    exports.removeMarkdownEscapes = removeMarkdownEscapes;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[110/*vs/base/common/idGenerator*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var IdGenerator = /** @class */ (function () {
        function IdGenerator(prefix) {
            this._prefix = prefix;
            this._lastId = 0;
        }
        IdGenerator.prototype.nextId = function () {
            return this._prefix + (++this._lastId);
        };
        return IdGenerator;
    }());
    exports.IdGenerator = IdGenerator;
    exports.defaultGenerator = new IdGenerator('id#');
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
define(__m[87/*vs/base/common/iterator*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.FIN = { done: true, value: undefined };
    var Iterator;
    (function (Iterator) {
        var _empty = {
            next: function () {
                return exports.FIN;
            }
        };
        function empty() {
            return _empty;
        }
        Iterator.empty = empty;
        function fromArray(array, index, length) {
            if (index === void 0) { index = 0; }
            if (length === void 0) { length = array.length; }
            return {
                next: function () {
                    if (index >= length) {
                        return exports.FIN;
                    }
                    return { done: false, value: array[index++] };
                }
            };
        }
        Iterator.fromArray = fromArray;
        function from(elements) {
            if (!elements) {
                return Iterator.empty();
            }
            else if (Array.isArray(elements)) {
                return Iterator.fromArray(elements);
            }
            else {
                return elements;
            }
        }
        Iterator.from = from;
        function map(iterator, fn) {
            return {
                next: function () {
                    var element = iterator.next();
                    if (element.done) {
                        return exports.FIN;
                    }
                    else {
                        return { done: false, value: fn(element.value) };
                    }
                }
            };
        }
        Iterator.map = map;
        function filter(iterator, fn) {
            return {
                next: function () {
                    while (true) {
                        var element = iterator.next();
                        if (element.done) {
                            return exports.FIN;
                        }
                        if (fn(element.value)) {
                            return { done: false, value: element.value };
                        }
                    }
                }
            };
        }
        Iterator.filter = filter;
        function forEach(iterator, fn) {
            for (var next = iterator.next(); !next.done; next = iterator.next()) {
                fn(next.value);
            }
        }
        Iterator.forEach = forEach;
        function collect(iterator) {
            var result = [];
            forEach(iterator, function (value) { return result.push(value); });
            return result;
        }
        Iterator.collect = collect;
    })(Iterator = exports.Iterator || (exports.Iterator = {}));
    var ArrayIterator = /** @class */ (function () {
        function ArrayIterator(items, start, end, index) {
            if (start === void 0) { start = 0; }
            if (end === void 0) { end = items.length; }
            if (index === void 0) { index = start - 1; }
            this.items = items;
            this.start = start;
            this.end = end;
            this.index = index;
        }
        ArrayIterator.prototype.next = function () {
            this.index = Math.min(this.index + 1, this.end);
            return this.current();
        };
        ArrayIterator.prototype.current = function () {
            if (this.index === this.start - 1 || this.index === this.end) {
                return null;
            }
            return this.items[this.index];
        };
        return ArrayIterator;
    }());
    exports.ArrayIterator = ArrayIterator;
    var ArrayNavigator = /** @class */ (function (_super) {
        __extends(ArrayNavigator, _super);
        function ArrayNavigator(items, start, end, index) {
            if (start === void 0) { start = 0; }
            if (end === void 0) { end = items.length; }
            if (index === void 0) { index = start - 1; }
            return _super.call(this, items, start, end, index) || this;
        }
        ArrayNavigator.prototype.current = function () {
            return _super.prototype.current.call(this);
        };
        ArrayNavigator.prototype.previous = function () {
            this.index = Math.max(this.index - 1, this.start - 1);
            return this.current();
        };
        ArrayNavigator.prototype.first = function () {
            this.index = this.start;
            return this.current();
        };
        ArrayNavigator.prototype.last = function () {
            this.index = this.end - 1;
            return this.current();
        };
        ArrayNavigator.prototype.parent = function () {
            return null;
        };
        return ArrayNavigator;
    }(ArrayIterator));
    exports.ArrayNavigator = ArrayNavigator;
    var MappedIterator = /** @class */ (function () {
        function MappedIterator(iterator, fn) {
            this.iterator = iterator;
            this.fn = fn;
            // noop
        }
        MappedIterator.prototype.next = function () { return this.fn(this.iterator.next()); };
        return MappedIterator;
    }());
    exports.MappedIterator = MappedIterator;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[441/*vs/base/common/history*/], __M([0/*require*/,1/*exports*/,87/*vs/base/common/iterator*/]), function (require, exports, iterator_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var HistoryNavigator = /** @class */ (function () {
        function HistoryNavigator(history, limit) {
            if (history === void 0) { history = []; }
            if (limit === void 0) { limit = 10; }
            this._initialize(history);
            this._limit = limit;
            this._onChange();
        }
        HistoryNavigator.prototype.add = function (t) {
            this._history.delete(t);
            this._history.add(t);
            this._onChange();
        };
        HistoryNavigator.prototype.next = function () {
            return this._navigator.next();
        };
        HistoryNavigator.prototype.previous = function () {
            return this._navigator.previous();
        };
        HistoryNavigator.prototype.current = function () {
            return this._navigator.current();
        };
        HistoryNavigator.prototype.parent = function () {
            return null;
        };
        HistoryNavigator.prototype.first = function () {
            return this._navigator.first();
        };
        HistoryNavigator.prototype.last = function () {
            return this._navigator.last();
        };
        HistoryNavigator.prototype.has = function (t) {
            return this._history.has(t);
        };
        HistoryNavigator.prototype._onChange = function () {
            this._reduceToLimit();
            this._navigator = new iterator_1.ArrayNavigator(this._elements, 0, this._elements.length, this._elements.length);
        };
        HistoryNavigator.prototype._reduceToLimit = function () {
            var data = this._elements;
            if (data.length > this._limit) {
                this._initialize(data.slice(data.length - this._limit));
            }
        };
        HistoryNavigator.prototype._initialize = function (history) {
            this._history = new Set();
            for (var _i = 0, history_1 = history; _i < history_1.length; _i++) {
                var entry = history_1[_i];
                this._history.add(entry);
            }
        };
        Object.defineProperty(HistoryNavigator.prototype, "_elements", {
            get: function () {
                var elements = [];
                this._history.forEach(function (e) { return elements.push(e); });
                return elements;
            },
            enumerable: true,
            configurable: true
        });
        return HistoryNavigator;
    }());
    exports.HistoryNavigator = HistoryNavigator;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[36/*vs/base/common/keyCodes*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var KeyCodeStrMap = /** @class */ (function () {
        function KeyCodeStrMap() {
            this._keyCodeToStr = [];
            this._strToKeyCode = Object.create(null);
        }
        KeyCodeStrMap.prototype.define = function (keyCode, str) {
            this._keyCodeToStr[keyCode] = str;
            this._strToKeyCode[str.toLowerCase()] = keyCode;
        };
        KeyCodeStrMap.prototype.keyCodeToStr = function (keyCode) {
            return this._keyCodeToStr[keyCode];
        };
        KeyCodeStrMap.prototype.strToKeyCode = function (str) {
            return this._strToKeyCode[str.toLowerCase()] || 0 /* Unknown */;
        };
        return KeyCodeStrMap;
    }());
    var uiMap = new KeyCodeStrMap();
    var userSettingsUSMap = new KeyCodeStrMap();
    var userSettingsGeneralMap = new KeyCodeStrMap();
    (function () {
        function define(keyCode, uiLabel, usUserSettingsLabel, generalUserSettingsLabel) {
            if (usUserSettingsLabel === void 0) { usUserSettingsLabel = uiLabel; }
            if (generalUserSettingsLabel === void 0) { generalUserSettingsLabel = usUserSettingsLabel; }
            uiMap.define(keyCode, uiLabel);
            userSettingsUSMap.define(keyCode, usUserSettingsLabel);
            userSettingsGeneralMap.define(keyCode, generalUserSettingsLabel);
        }
        define(0 /* Unknown */, 'unknown');
        define(1 /* Backspace */, 'Backspace');
        define(2 /* Tab */, 'Tab');
        define(3 /* Enter */, 'Enter');
        define(4 /* Shift */, 'Shift');
        define(5 /* Ctrl */, 'Ctrl');
        define(6 /* Alt */, 'Alt');
        define(7 /* PauseBreak */, 'PauseBreak');
        define(8 /* CapsLock */, 'CapsLock');
        define(9 /* Escape */, 'Escape');
        define(10 /* Space */, 'Space');
        define(11 /* PageUp */, 'PageUp');
        define(12 /* PageDown */, 'PageDown');
        define(13 /* End */, 'End');
        define(14 /* Home */, 'Home');
        define(15 /* LeftArrow */, 'LeftArrow', 'Left');
        define(16 /* UpArrow */, 'UpArrow', 'Up');
        define(17 /* RightArrow */, 'RightArrow', 'Right');
        define(18 /* DownArrow */, 'DownArrow', 'Down');
        define(19 /* Insert */, 'Insert');
        define(20 /* Delete */, 'Delete');
        define(21 /* KEY_0 */, '0');
        define(22 /* KEY_1 */, '1');
        define(23 /* KEY_2 */, '2');
        define(24 /* KEY_3 */, '3');
        define(25 /* KEY_4 */, '4');
        define(26 /* KEY_5 */, '5');
        define(27 /* KEY_6 */, '6');
        define(28 /* KEY_7 */, '7');
        define(29 /* KEY_8 */, '8');
        define(30 /* KEY_9 */, '9');
        define(31 /* KEY_A */, 'A');
        define(32 /* KEY_B */, 'B');
        define(33 /* KEY_C */, 'C');
        define(34 /* KEY_D */, 'D');
        define(35 /* KEY_E */, 'E');
        define(36 /* KEY_F */, 'F');
        define(37 /* KEY_G */, 'G');
        define(38 /* KEY_H */, 'H');
        define(39 /* KEY_I */, 'I');
        define(40 /* KEY_J */, 'J');
        define(41 /* KEY_K */, 'K');
        define(42 /* KEY_L */, 'L');
        define(43 /* KEY_M */, 'M');
        define(44 /* KEY_N */, 'N');
        define(45 /* KEY_O */, 'O');
        define(46 /* KEY_P */, 'P');
        define(47 /* KEY_Q */, 'Q');
        define(48 /* KEY_R */, 'R');
        define(49 /* KEY_S */, 'S');
        define(50 /* KEY_T */, 'T');
        define(51 /* KEY_U */, 'U');
        define(52 /* KEY_V */, 'V');
        define(53 /* KEY_W */, 'W');
        define(54 /* KEY_X */, 'X');
        define(55 /* KEY_Y */, 'Y');
        define(56 /* KEY_Z */, 'Z');
        define(57 /* Meta */, 'Meta');
        define(58 /* ContextMenu */, 'ContextMenu');
        define(59 /* F1 */, 'F1');
        define(60 /* F2 */, 'F2');
        define(61 /* F3 */, 'F3');
        define(62 /* F4 */, 'F4');
        define(63 /* F5 */, 'F5');
        define(64 /* F6 */, 'F6');
        define(65 /* F7 */, 'F7');
        define(66 /* F8 */, 'F8');
        define(67 /* F9 */, 'F9');
        define(68 /* F10 */, 'F10');
        define(69 /* F11 */, 'F11');
        define(70 /* F12 */, 'F12');
        define(71 /* F13 */, 'F13');
        define(72 /* F14 */, 'F14');
        define(73 /* F15 */, 'F15');
        define(74 /* F16 */, 'F16');
        define(75 /* F17 */, 'F17');
        define(76 /* F18 */, 'F18');
        define(77 /* F19 */, 'F19');
        define(78 /* NumLock */, 'NumLock');
        define(79 /* ScrollLock */, 'ScrollLock');
        define(80 /* US_SEMICOLON */, ';', ';', 'OEM_1');
        define(81 /* US_EQUAL */, '=', '=', 'OEM_PLUS');
        define(82 /* US_COMMA */, ',', ',', 'OEM_COMMA');
        define(83 /* US_MINUS */, '-', '-', 'OEM_MINUS');
        define(84 /* US_DOT */, '.', '.', 'OEM_PERIOD');
        define(85 /* US_SLASH */, '/', '/', 'OEM_2');
        define(86 /* US_BACKTICK */, '`', '`', 'OEM_3');
        define(110 /* ABNT_C1 */, 'ABNT_C1');
        define(111 /* ABNT_C2 */, 'ABNT_C2');
        define(87 /* US_OPEN_SQUARE_BRACKET */, '[', '[', 'OEM_4');
        define(88 /* US_BACKSLASH */, '\\', '\\', 'OEM_5');
        define(89 /* US_CLOSE_SQUARE_BRACKET */, ']', ']', 'OEM_6');
        define(90 /* US_QUOTE */, '\'', '\'', 'OEM_7');
        define(91 /* OEM_8 */, 'OEM_8');
        define(92 /* OEM_102 */, 'OEM_102');
        define(93 /* NUMPAD_0 */, 'NumPad0');
        define(94 /* NUMPAD_1 */, 'NumPad1');
        define(95 /* NUMPAD_2 */, 'NumPad2');
        define(96 /* NUMPAD_3 */, 'NumPad3');
        define(97 /* NUMPAD_4 */, 'NumPad4');
        define(98 /* NUMPAD_5 */, 'NumPad5');
        define(99 /* NUMPAD_6 */, 'NumPad6');
        define(100 /* NUMPAD_7 */, 'NumPad7');
        define(101 /* NUMPAD_8 */, 'NumPad8');
        define(102 /* NUMPAD_9 */, 'NumPad9');
        define(103 /* NUMPAD_MULTIPLY */, 'NumPad_Multiply');
        define(104 /* NUMPAD_ADD */, 'NumPad_Add');
        define(105 /* NUMPAD_SEPARATOR */, 'NumPad_Separator');
        define(106 /* NUMPAD_SUBTRACT */, 'NumPad_Subtract');
        define(107 /* NUMPAD_DECIMAL */, 'NumPad_Decimal');
        define(108 /* NUMPAD_DIVIDE */, 'NumPad_Divide');
    })();
    var KeyCodeUtils;
    (function (KeyCodeUtils) {
        function toString(keyCode) {
            return uiMap.keyCodeToStr(keyCode);
        }
        KeyCodeUtils.toString = toString;
        function fromString(key) {
            return uiMap.strToKeyCode(key);
        }
        KeyCodeUtils.fromString = fromString;
        function toUserSettingsUS(keyCode) {
            return userSettingsUSMap.keyCodeToStr(keyCode);
        }
        KeyCodeUtils.toUserSettingsUS = toUserSettingsUS;
        function toUserSettingsGeneral(keyCode) {
            return userSettingsGeneralMap.keyCodeToStr(keyCode);
        }
        KeyCodeUtils.toUserSettingsGeneral = toUserSettingsGeneral;
        function fromUserSettings(key) {
            return userSettingsUSMap.strToKeyCode(key) || userSettingsGeneralMap.strToKeyCode(key);
        }
        KeyCodeUtils.fromUserSettings = fromUserSettings;
    })(KeyCodeUtils = exports.KeyCodeUtils || (exports.KeyCodeUtils = {}));
    function KeyChord(firstPart, secondPart) {
        var chordPart = ((secondPart & 0x0000ffff) << 16) >>> 0;
        return (firstPart | chordPart) >>> 0;
    }
    exports.KeyChord = KeyChord;
    function createKeybinding(keybinding, OS) {
        if (keybinding === 0) {
            return null;
        }
        var firstPart = (keybinding & 0x0000ffff) >>> 0;
        var chordPart = (keybinding & 0xffff0000) >>> 16;
        if (chordPart !== 0) {
            return new ChordKeybinding(createSimpleKeybinding(firstPart, OS), createSimpleKeybinding(chordPart, OS));
        }
        return createSimpleKeybinding(firstPart, OS);
    }
    exports.createKeybinding = createKeybinding;
    function createSimpleKeybinding(keybinding, OS) {
        var ctrlCmd = (keybinding & 2048 /* CtrlCmd */ ? true : false);
        var winCtrl = (keybinding & 256 /* WinCtrl */ ? true : false);
        var ctrlKey = (OS === 2 /* Macintosh */ ? winCtrl : ctrlCmd);
        var shiftKey = (keybinding & 1024 /* Shift */ ? true : false);
        var altKey = (keybinding & 512 /* Alt */ ? true : false);
        var metaKey = (OS === 2 /* Macintosh */ ? ctrlCmd : winCtrl);
        var keyCode = (keybinding & 255 /* KeyCode */);
        return new SimpleKeybinding(ctrlKey, shiftKey, altKey, metaKey, keyCode);
    }
    exports.createSimpleKeybinding = createSimpleKeybinding;
    var SimpleKeybinding = /** @class */ (function () {
        function SimpleKeybinding(ctrlKey, shiftKey, altKey, metaKey, keyCode) {
            this.type = 1 /* Simple */;
            this.ctrlKey = ctrlKey;
            this.shiftKey = shiftKey;
            this.altKey = altKey;
            this.metaKey = metaKey;
            this.keyCode = keyCode;
        }
        SimpleKeybinding.prototype.equals = function (other) {
            if (other.type !== 1 /* Simple */) {
                return false;
            }
            return (this.ctrlKey === other.ctrlKey
                && this.shiftKey === other.shiftKey
                && this.altKey === other.altKey
                && this.metaKey === other.metaKey
                && this.keyCode === other.keyCode);
        };
        SimpleKeybinding.prototype.isModifierKey = function () {
            return (this.keyCode === 0 /* Unknown */
                || this.keyCode === 5 /* Ctrl */
                || this.keyCode === 57 /* Meta */
                || this.keyCode === 6 /* Alt */
                || this.keyCode === 4 /* Shift */);
        };
        /**
         * Does this keybinding refer to the key code of a modifier and it also has the modifier flag?
         */
        SimpleKeybinding.prototype.isDuplicateModifierCase = function () {
            return ((this.ctrlKey && this.keyCode === 5 /* Ctrl */)
                || (this.shiftKey && this.keyCode === 4 /* Shift */)
                || (this.altKey && this.keyCode === 6 /* Alt */)
                || (this.metaKey && this.keyCode === 57 /* Meta */));
        };
        return SimpleKeybinding;
    }());
    exports.SimpleKeybinding = SimpleKeybinding;
    var ChordKeybinding = /** @class */ (function () {
        function ChordKeybinding(firstPart, chordPart) {
            this.type = 2 /* Chord */;
            this.firstPart = firstPart;
            this.chordPart = chordPart;
        }
        return ChordKeybinding;
    }());
    exports.ChordKeybinding = ChordKeybinding;
    var ResolvedKeybindingPart = /** @class */ (function () {
        function ResolvedKeybindingPart(ctrlKey, shiftKey, altKey, metaKey, kbLabel, kbAriaLabel) {
            this.ctrlKey = ctrlKey;
            this.shiftKey = shiftKey;
            this.altKey = altKey;
            this.metaKey = metaKey;
            this.keyLabel = kbLabel;
            this.keyAriaLabel = kbAriaLabel;
        }
        return ResolvedKeybindingPart;
    }());
    exports.ResolvedKeybindingPart = ResolvedKeybindingPart;
    /**
     * A resolved keybinding. Can be a simple keybinding or a chord keybinding.
     */
    var ResolvedKeybinding = /** @class */ (function () {
        function ResolvedKeybinding() {
        }
        return ResolvedKeybinding;
    }());
    exports.ResolvedKeybinding = ResolvedKeybinding;
});

define(__m[2/*vs/base/common/lifecycle*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function isDisposable(thing) {
        return typeof thing.dispose === 'function'
            && thing.dispose.length === 0;
    }
    exports.isDisposable = isDisposable;
    function dispose(first) {
        var rest = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            rest[_i - 1] = arguments[_i];
        }
        if (Array.isArray(first)) {
            first.forEach(function (d) { return d && d.dispose(); });
            return [];
        }
        else if (rest.length === 0) {
            if (first) {
                first.dispose();
                return first;
            }
            return undefined;
        }
        else {
            dispose(first);
            dispose(rest);
            return [];
        }
    }
    exports.dispose = dispose;
    function combinedDisposable(disposables) {
        return { dispose: function () { return dispose(disposables); } };
    }
    exports.combinedDisposable = combinedDisposable;
    function toDisposable(fn) {
        return { dispose: function () { fn(); } };
    }
    exports.toDisposable = toDisposable;
    var Disposable = /** @class */ (function () {
        function Disposable() {
            this._toDispose = [];
        }
        Disposable.prototype.dispose = function () {
            this._toDispose = dispose(this._toDispose);
        };
        Disposable.prototype._register = function (t) {
            this._toDispose.push(t);
            return t;
        };
        Disposable.None = Object.freeze({ dispose: function () { } });
        return Disposable;
    }());
    exports.Disposable = Disposable;
    var ImmortalReference = /** @class */ (function () {
        function ImmortalReference(object) {
            this.object = object;
        }
        ImmortalReference.prototype.dispose = function () { };
        return ImmortalReference;
    }());
    exports.ImmortalReference = ImmortalReference;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[160/*vs/base/common/linkedList*/], __M([0/*require*/,1/*exports*/,87/*vs/base/common/iterator*/]), function (require, exports, iterator_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Node = /** @class */ (function () {
        function Node(element) {
            this.element = element;
        }
        return Node;
    }());
    var LinkedList = /** @class */ (function () {
        function LinkedList() {
        }
        LinkedList.prototype.isEmpty = function () {
            return !this._first;
        };
        LinkedList.prototype.unshift = function (element) {
            return this.insert(element, false);
        };
        LinkedList.prototype.push = function (element) {
            return this.insert(element, true);
        };
        LinkedList.prototype.insert = function (element, atTheEnd) {
            var _this = this;
            var newNode = new Node(element);
            if (!this._first) {
                this._first = newNode;
                this._last = newNode;
            }
            else if (atTheEnd) {
                // push
                var oldLast = this._last;
                this._last = newNode;
                newNode.prev = oldLast;
                oldLast.next = newNode;
            }
            else {
                // unshift
                var oldFirst = this._first;
                this._first = newNode;
                newNode.next = oldFirst;
                oldFirst.prev = newNode;
            }
            return function () {
                var candidate = _this._first;
                while (candidate instanceof Node) {
                    if (candidate !== newNode) {
                        candidate = candidate.next;
                        continue;
                    }
                    if (candidate.prev && candidate.next) {
                        // middle
                        var anchor = candidate.prev;
                        anchor.next = candidate.next;
                        candidate.next.prev = anchor;
                    }
                    else if (!candidate.prev && !candidate.next) {
                        // only node
                        _this._first = undefined;
                        _this._last = undefined;
                    }
                    else if (!candidate.next) {
                        // last
                        _this._last = _this._last.prev;
                        _this._last.next = undefined;
                    }
                    else if (!candidate.prev) {
                        // first
                        _this._first = _this._first.next;
                        _this._first.prev = undefined;
                    }
                    // done
                    break;
                }
            };
        };
        LinkedList.prototype.iterator = function () {
            var element;
            var node = this._first;
            return {
                next: function () {
                    if (!node) {
                        return iterator_1.FIN;
                    }
                    if (!element) {
                        element = { done: false, value: node.element };
                    }
                    else {
                        element.value = node.element;
                    }
                    node = node.next;
                    return element;
                }
            };
        };
        return LinkedList;
    }());
    exports.LinkedList = LinkedList;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[65/*vs/base/common/map*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function values(forEachable) {
        var result = [];
        forEachable.forEach(function (value) { return result.push(value); });
        return result;
    }
    exports.values = values;
    function keys(map) {
        var result = [];
        map.forEach(function (value, key) { return result.push(key); });
        return result;
    }
    exports.keys = keys;
    var StringIterator = /** @class */ (function () {
        function StringIterator() {
            this._value = '';
            this._pos = 0;
        }
        StringIterator.prototype.reset = function (key) {
            this._value = key;
            this._pos = 0;
            return this;
        };
        StringIterator.prototype.next = function () {
            this._pos += 1;
            return this;
        };
        StringIterator.prototype.hasNext = function () {
            return this._pos < this._value.length - 1;
        };
        StringIterator.prototype.cmp = function (a) {
            var aCode = a.charCodeAt(0);
            var thisCode = this._value.charCodeAt(this._pos);
            return aCode - thisCode;
        };
        StringIterator.prototype.value = function () {
            return this._value[this._pos];
        };
        return StringIterator;
    }());
    exports.StringIterator = StringIterator;
    var PathIterator = /** @class */ (function () {
        function PathIterator() {
        }
        PathIterator.prototype.reset = function (key) {
            this._value = key.replace(/\\$|\/$/, '');
            this._from = 0;
            this._to = 0;
            return this.next();
        };
        PathIterator.prototype.hasNext = function () {
            return this._to < this._value.length;
        };
        PathIterator.prototype.next = function () {
            // this._data = key.split(/[\\/]/).filter(s => !!s);
            this._from = this._to;
            var justSeps = true;
            for (; this._to < this._value.length; this._to++) {
                var ch = this._value.charCodeAt(this._to);
                if (ch === 47 /* Slash */ || ch === 92 /* Backslash */) {
                    if (justSeps) {
                        this._from++;
                    }
                    else {
                        break;
                    }
                }
                else {
                    justSeps = false;
                }
            }
            return this;
        };
        PathIterator.prototype.cmp = function (a) {
            var aPos = 0;
            var aLen = a.length;
            var thisPos = this._from;
            while (aPos < aLen && thisPos < this._to) {
                var cmp = a.charCodeAt(aPos) - this._value.charCodeAt(thisPos);
                if (cmp !== 0) {
                    return cmp;
                }
                aPos += 1;
                thisPos += 1;
            }
            if (aLen === this._to - this._from) {
                return 0;
            }
            else if (aPos < aLen) {
                return -1;
            }
            else {
                return 1;
            }
        };
        PathIterator.prototype.value = function () {
            return this._value.substring(this._from, this._to);
        };
        return PathIterator;
    }());
    exports.PathIterator = PathIterator;
    var TernarySearchTreeNode = /** @class */ (function () {
        function TernarySearchTreeNode() {
        }
        return TernarySearchTreeNode;
    }());
    var TernarySearchTree = /** @class */ (function () {
        function TernarySearchTree(segments) {
            this._iter = segments;
        }
        TernarySearchTree.forPaths = function () {
            return new TernarySearchTree(new PathIterator());
        };
        TernarySearchTree.forStrings = function () {
            return new TernarySearchTree(new StringIterator());
        };
        TernarySearchTree.prototype.clear = function () {
            this._root = undefined;
        };
        TernarySearchTree.prototype.set = function (key, element) {
            var iter = this._iter.reset(key);
            var node;
            if (!this._root) {
                this._root = new TernarySearchTreeNode();
                this._root.segment = iter.value();
            }
            node = this._root;
            while (true) {
                var val = iter.cmp(node.segment);
                if (val > 0) {
                    // left
                    if (!node.left) {
                        node.left = new TernarySearchTreeNode();
                        node.left.segment = iter.value();
                    }
                    node = node.left;
                }
                else if (val < 0) {
                    // right
                    if (!node.right) {
                        node.right = new TernarySearchTreeNode();
                        node.right.segment = iter.value();
                    }
                    node = node.right;
                }
                else if (iter.hasNext()) {
                    // mid
                    iter.next();
                    if (!node.mid) {
                        node.mid = new TernarySearchTreeNode();
                        node.mid.segment = iter.value();
                    }
                    node = node.mid;
                }
                else {
                    break;
                }
            }
            var oldElement = node.value;
            node.value = element;
            node.key = key;
            return oldElement;
        };
        TernarySearchTree.prototype.get = function (key) {
            var iter = this._iter.reset(key);
            var node = this._root;
            while (node) {
                var val = iter.cmp(node.segment);
                if (val > 0) {
                    // left
                    node = node.left;
                }
                else if (val < 0) {
                    // right
                    node = node.right;
                }
                else if (iter.hasNext()) {
                    // mid
                    iter.next();
                    node = node.mid;
                }
                else {
                    break;
                }
            }
            return node ? node.value : undefined;
        };
        TernarySearchTree.prototype.findSubstr = function (key) {
            var iter = this._iter.reset(key);
            var node = this._root;
            var candidate = undefined;
            while (node) {
                var val = iter.cmp(node.segment);
                if (val > 0) {
                    // left
                    node = node.left;
                }
                else if (val < 0) {
                    // right
                    node = node.right;
                }
                else if (iter.hasNext()) {
                    // mid
                    iter.next();
                    candidate = node.value || candidate;
                    node = node.mid;
                }
                else {
                    break;
                }
            }
            return node && node.value || candidate;
        };
        TernarySearchTree.prototype.forEach = function (callback) {
            this._forEach(this._root, callback);
        };
        TernarySearchTree.prototype._forEach = function (node, callback) {
            if (node) {
                // left
                this._forEach(node.left, callback);
                // node
                if (node.value) {
                    // callback(node.value, this._iter.join(parts));
                    callback(node.value, node.key);
                }
                // mid
                this._forEach(node.mid, callback);
                // right
                this._forEach(node.right, callback);
            }
        };
        return TernarySearchTree;
    }());
    exports.TernarySearchTree = TernarySearchTree;
    var ResourceMap = /** @class */ (function () {
        function ResourceMap() {
            this.map = new Map();
            this.ignoreCase = false; // in the future this should be an uri-comparator
        }
        ResourceMap.prototype.set = function (resource, value) {
            this.map.set(this.toKey(resource), value);
        };
        ResourceMap.prototype.get = function (resource) {
            return this.map.get(this.toKey(resource));
        };
        ResourceMap.prototype.toKey = function (resource) {
            var key = resource.toString();
            if (this.ignoreCase) {
                key = key.toLowerCase();
            }
            return key;
        };
        return ResourceMap;
    }());
    exports.ResourceMap = ResourceMap;
    var LinkedMap = /** @class */ (function () {
        function LinkedMap() {
            this._map = new Map();
            this._head = undefined;
            this._tail = undefined;
            this._size = 0;
        }
        LinkedMap.prototype.clear = function () {
            this._map.clear();
            this._head = undefined;
            this._tail = undefined;
            this._size = 0;
        };
        Object.defineProperty(LinkedMap.prototype, "size", {
            get: function () {
                return this._size;
            },
            enumerable: true,
            configurable: true
        });
        LinkedMap.prototype.get = function (key, touch) {
            if (touch === void 0) { touch = 0 /* None */; }
            var item = this._map.get(key);
            if (!item) {
                return undefined;
            }
            if (touch !== 0 /* None */) {
                this.touch(item, touch);
            }
            return item.value;
        };
        LinkedMap.prototype.set = function (key, value, touch) {
            if (touch === void 0) { touch = 0 /* None */; }
            var item = this._map.get(key);
            if (item) {
                item.value = value;
                if (touch !== 0 /* None */) {
                    this.touch(item, touch);
                }
            }
            else {
                item = { key: key, value: value, next: undefined, previous: undefined };
                switch (touch) {
                    case 0 /* None */:
                        this.addItemLast(item);
                        break;
                    case 1 /* AsOld */:
                        this.addItemFirst(item);
                        break;
                    case 2 /* AsNew */:
                        this.addItemLast(item);
                        break;
                    default:
                        this.addItemLast(item);
                        break;
                }
                this._map.set(key, item);
                this._size++;
            }
        };
        LinkedMap.prototype.forEach = function (callbackfn, thisArg) {
            var current = this._head;
            while (current) {
                if (thisArg) {
                    callbackfn.bind(thisArg)(current.value, current.key, this);
                }
                else {
                    callbackfn(current.value, current.key, this);
                }
                current = current.next;
            }
        };
        /* VS Code / Monaco editor runs on es5 which has no Symbol.iterator
        public keys(): IterableIterator<K> {
            let current = this._head;
            let iterator: IterableIterator<K> = {
                [Symbol.iterator]() {
                    return iterator;
                },
                next():IteratorResult<K> {
                    if (current) {
                        let result = { value: current.key, done: false };
                        current = current.next;
                        return result;
                    } else {
                        return { value: undefined, done: true };
                    }
                }
            };
            return iterator;
        }
    
        public values(): IterableIterator<V> {
            let current = this._head;
            let iterator: IterableIterator<V> = {
                [Symbol.iterator]() {
                    return iterator;
                },
                next():IteratorResult<V> {
                    if (current) {
                        let result = { value: current.value, done: false };
                        current = current.next;
                        return result;
                    } else {
                        return { value: undefined, done: true };
                    }
                }
            };
            return iterator;
        }
        */
        LinkedMap.prototype.trimOld = function (newSize) {
            if (newSize >= this.size) {
                return;
            }
            if (newSize === 0) {
                this.clear();
                return;
            }
            var current = this._head;
            var currentSize = this.size;
            while (current && currentSize > newSize) {
                this._map.delete(current.key);
                current = current.next;
                currentSize--;
            }
            this._head = current;
            this._size = currentSize;
            if (current) {
                current.previous = void 0;
            }
        };
        LinkedMap.prototype.addItemFirst = function (item) {
            // First time Insert
            if (!this._head && !this._tail) {
                this._tail = item;
            }
            else if (!this._head) {
                throw new Error('Invalid list');
            }
            else {
                item.next = this._head;
                this._head.previous = item;
            }
            this._head = item;
        };
        LinkedMap.prototype.addItemLast = function (item) {
            // First time Insert
            if (!this._head && !this._tail) {
                this._head = item;
            }
            else if (!this._tail) {
                throw new Error('Invalid list');
            }
            else {
                item.previous = this._tail;
                this._tail.next = item;
            }
            this._tail = item;
        };
        LinkedMap.prototype.touch = function (item, touch) {
            if (!this._head || !this._tail) {
                throw new Error('Invalid list');
            }
            if ((touch !== 1 /* AsOld */ && touch !== 2 /* AsNew */)) {
                return;
            }
            if (touch === 1 /* AsOld */) {
                if (item === this._head) {
                    return;
                }
                var next = item.next;
                var previous = item.previous;
                // Unlink the item
                if (item === this._tail) {
                    // previous must be defined since item was not head but is tail
                    // So there are more than on item in the map
                    previous.next = void 0;
                    this._tail = previous;
                }
                else {
                    // Both next and previous are not undefined since item was neither head nor tail.
                    next.previous = previous;
                    previous.next = next;
                }
                // Insert the node at head
                item.previous = void 0;
                item.next = this._head;
                this._head.previous = item;
                this._head = item;
            }
            else if (touch === 2 /* AsNew */) {
                if (item === this._tail) {
                    return;
                }
                var next = item.next;
                var previous = item.previous;
                // Unlink the item.
                if (item === this._head) {
                    // next must be defined since item was not tail but is head
                    // So there are more than on item in the map
                    next.previous = void 0;
                    this._head = next;
                }
                else {
                    // Both next and previous are not undefined since item was neither head nor tail.
                    next.previous = previous;
                    previous.next = next;
                }
                item.next = void 0;
                item.previous = this._tail;
                this._tail.next = item;
                this._tail = item;
            }
        };
        LinkedMap.prototype.toJSON = function () {
            var data = [];
            this.forEach(function (value, key) {
                data.push([key, value]);
            });
            return data;
        };
        return LinkedMap;
    }());
    exports.LinkedMap = LinkedMap;
    var LRUCache = /** @class */ (function (_super) {
        __extends(LRUCache, _super);
        function LRUCache(limit, ratio) {
            if (ratio === void 0) { ratio = 1; }
            var _this = _super.call(this) || this;
            _this._limit = limit;
            _this._ratio = Math.min(Math.max(0, ratio), 1);
            return _this;
        }
        LRUCache.prototype.get = function (key) {
            return _super.prototype.get.call(this, key, 2 /* AsNew */);
        };
        LRUCache.prototype.set = function (key, value) {
            _super.prototype.set.call(this, key, value, 2 /* AsNew */);
            this.checkTrim();
        };
        LRUCache.prototype.checkTrim = function () {
            if (this.size > this._limit) {
                this.trimOld(Math.round(this._limit * this._ratio));
            }
        };
        return LRUCache;
    }(LinkedMap));
    exports.LRUCache = LRUCache;
});

/**
 * marked - a markdown parser
 * Copyright (c) 2011-2014, Christopher Jeffrey. (MIT Licensed)
 * https://github.com/markedjs/marked
 */

// BEGIN MONACOCHANGE
var __marked_exports;
// END MONACOCHANGE

;(function(root) {
'use strict';

/**
 * Block-Level Grammar
 */

var block = {
  newline: /^\n+/,
  code: /^( {4}[^\n]+\n*)+/,
  fences: noop,
  hr: /^ {0,3}((?:- *){3,}|(?:_ *){3,}|(?:\* *){3,})(?:\n+|$)/,
  heading: /^ *(#{1,6}) *([^\n]+?) *(?:#+ *)?(?:\n+|$)/,
  nptable: noop,
  blockquote: /^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/,
  list: /^( *)(bull) [\s\S]+?(?:hr|def|\n{2,}(?! )(?!\1bull )\n*|\s*$)/,
  html: '^ {0,3}(?:' // optional indentation
    + '<(script|pre|style)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)' // (1)
    + '|comment[^\\n]*(\\n+|$)' // (2)
    + '|<\\?[\\s\\S]*?\\?>\\n*' // (3)
    + '|<![A-Z][\\s\\S]*?>\\n*' // (4)
    + '|<!\\[CDATA\\[[\\s\\S]*?\\]\\]>\\n*' // (5)
    + '|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:\\n{2,}|$)' // (6)
    + '|<(?!script|pre|style)([a-z][\\w-]*)(?:attribute)*? */?>(?=\\h*\\n)[\\s\\S]*?(?:\\n{2,}|$)' // (7) open tag
    + '|</(?!script|pre|style)[a-z][\\w-]*\\s*>(?=\\h*\\n)[\\s\\S]*?(?:\\n{2,}|$)' // (7) closing tag
    + ')',
  def: /^ {0,3}\[(label)\]: *\n? *<?([^\s>]+)>?(?:(?: +\n? *| *\n *)(title))? *(?:\n+|$)/,
  table: noop,
  lheading: /^([^\n]+)\n *(=|-){2,} *(?:\n+|$)/,
  paragraph: /^([^\n]+(?:\n(?!hr|heading|lheading| {0,3}>|<\/?(?:tag)(?: +|\n|\/?>)|<(?:script|pre|style|!--))[^\n]+)*)/,
  text: /^[^\n]+/
};

block._label = /(?!\s*\])(?:\\[\[\]]|[^\[\]])+/;
block._title = /(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/;
block.def = edit(block.def)
  .replace('label', block._label)
  .replace('title', block._title)
  .getRegex();

block.bullet = /(?:[*+-]|\d+\.)/;
block.item = /^( *)(bull) [^\n]*(?:\n(?!\1bull )[^\n]*)*/;
block.item = edit(block.item, 'gm')
  .replace(/bull/g, block.bullet)
  .getRegex();

block.list = edit(block.list)
  .replace(/bull/g, block.bullet)
  .replace('hr', '\\n+(?=\\1?(?:(?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$))')
  .replace('def', '\\n+(?=' + block.def.source + ')')
  .getRegex();

block._tag = 'address|article|aside|base|basefont|blockquote|body|caption'
  + '|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption'
  + '|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe'
  + '|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option'
  + '|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr'
  + '|track|ul';
block._comment = /<!--(?!-?>)[\s\S]*?-->/;
block.html = edit(block.html, 'i')
  .replace('comment', block._comment)
  .replace('tag', block._tag)
  .replace('attribute', / +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/)
  .getRegex();

block.paragraph = edit(block.paragraph)
  .replace('hr', block.hr)
  .replace('heading', block.heading)
  .replace('lheading', block.lheading)
  .replace('tag', block._tag) // pars can be interrupted by type (6) html blocks
  .getRegex();

block.blockquote = edit(block.blockquote)
  .replace('paragraph', block.paragraph)
  .getRegex();

/**
 * Normal Block Grammar
 */

block.normal = merge({}, block);

/**
 * GFM Block Grammar
 */

block.gfm = merge({}, block.normal, {
  fences: /^ *(`{3,}|~{3,})[ \.]*(\S+)? *\n([\s\S]*?)\n? *\1 *(?:\n+|$)/,
  paragraph: /^/,
  heading: /^ *(#{1,6}) +([^\n]+?) *#* *(?:\n+|$)/
});

block.gfm.paragraph = edit(block.paragraph)
  .replace('(?!', '(?!'
    + block.gfm.fences.source.replace('\\1', '\\2') + '|'
    + block.list.source.replace('\\1', '\\3') + '|')
  .getRegex();

/**
 * GFM + Tables Block Grammar
 */

block.tables = merge({}, block.gfm, {
  nptable: /^ *([^|\n ].*\|.*)\n *([-:]+ *\|[-| :]*)(?:\n((?:.*[^>\n ].*(?:\n|$))*)\n*|$)/,
  table: /^ *\|(.+)\n *\|?( *[-:]+[-| :]*)(?:\n((?: *[^>\n ].*(?:\n|$))*)\n*|$)/
});

/**
 * Pedantic grammar
 */

block.pedantic = merge({}, block.normal, {
  html: edit(
    '^ *(?:comment *(?:\\n|\\s*$)'
    + '|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)' // closed tag
    + '|<tag(?:"[^"]*"|\'[^\']*\'|\\s[^\'"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))')
    .replace('comment', block._comment)
    .replace(/tag/g, '(?!(?:'
      + 'a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub'
      + '|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)'
      + '\\b)\\w+(?!:|[^\\w\\s@]*@)\\b')
    .getRegex(),
  def: /^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/
});

/**
 * Block Lexer
 */

function Lexer(options) {
  this.tokens = [];
  this.tokens.links = Object.create(null);
  this.options = options || marked.defaults;
  this.rules = block.normal;

  if (this.options.pedantic) {
    this.rules = block.pedantic;
  } else if (this.options.gfm) {
    if (this.options.tables) {
      this.rules = block.tables;
    } else {
      this.rules = block.gfm;
    }
  }
}

/**
 * Expose Block Rules
 */

Lexer.rules = block;

/**
 * Static Lex Method
 */

Lexer.lex = function(src, options) {
  var lexer = new Lexer(options);
  return lexer.lex(src);
};

/**
 * Preprocessing
 */

Lexer.prototype.lex = function(src) {
  src = src
    .replace(/\r\n|\r/g, '\n')
    .replace(/\t/g, '    ')
    .replace(/\u00a0/g, ' ')
    .replace(/\u2424/g, '\n');

  return this.token(src, true);
};

/**
 * Lexing
 */

Lexer.prototype.token = function(src, top) {
  src = src.replace(/^ +$/gm, '');
  var next,
      loose,
      cap,
      bull,
      b,
      item,
      listStart,
      listItems,
      t,
      space,
      i,
      tag,
      l,
      isordered,
      istask,
      ischecked;

  while (src) {
    // newline
    if (cap = this.rules.newline.exec(src)) {
      src = src.substring(cap[0].length);
      if (cap[0].length > 1) {
        this.tokens.push({
          type: 'space'
        });
      }
    }

    // code
    if (cap = this.rules.code.exec(src)) {
      src = src.substring(cap[0].length);
      cap = cap[0].replace(/^ {4}/gm, '');
      this.tokens.push({
        type: 'code',
        text: !this.options.pedantic
          ? rtrim(cap, '\n')
          : cap
      });
      continue;
    }

    // fences (gfm)
    if (cap = this.rules.fences.exec(src)) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'code',
        lang: cap[2],
        text: cap[3] || ''
      });
      continue;
    }

    // heading
    if (cap = this.rules.heading.exec(src)) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'heading',
        depth: cap[1].length,
        text: cap[2]
      });
      continue;
    }

    // table no leading pipe (gfm)
    if (top && (cap = this.rules.nptable.exec(src))) {
      item = {
        type: 'table',
        header: splitCells(cap[1].replace(/^ *| *\| *$/g, '')),
        align: cap[2].replace(/^ *|\| *$/g, '').split(/ *\| */),
        cells: cap[3] ? cap[3].replace(/\n$/, '').split('\n') : []
      };

      if (item.header.length === item.align.length) {
        src = src.substring(cap[0].length);

        for (i = 0; i < item.align.length; i++) {
          if (/^ *-+: *$/.test(item.align[i])) {
            item.align[i] = 'right';
          } else if (/^ *:-+: *$/.test(item.align[i])) {
            item.align[i] = 'center';
          } else if (/^ *:-+ *$/.test(item.align[i])) {
            item.align[i] = 'left';
          } else {
            item.align[i] = null;
          }
        }

        for (i = 0; i < item.cells.length; i++) {
          item.cells[i] = splitCells(item.cells[i], item.header.length);
        }

        this.tokens.push(item);

        continue;
      }
    }

    // hr
    if (cap = this.rules.hr.exec(src)) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'hr'
      });
      continue;
    }

    // blockquote
    if (cap = this.rules.blockquote.exec(src)) {
      src = src.substring(cap[0].length);

      this.tokens.push({
        type: 'blockquote_start'
      });

      cap = cap[0].replace(/^ *> ?/gm, '');

      // Pass `top` to keep the current
      // "toplevel" state. This is exactly
      // how markdown.pl works.
      this.token(cap, top);

      this.tokens.push({
        type: 'blockquote_end'
      });

      continue;
    }

    // list
    if (cap = this.rules.list.exec(src)) {
      src = src.substring(cap[0].length);
      bull = cap[2];
      isordered = bull.length > 1;

      listStart = {
        type: 'list_start',
        ordered: isordered,
        start: isordered ? +bull : '',
        loose: false
      };

      this.tokens.push(listStart);

      // Get each top-level item.
      cap = cap[0].match(this.rules.item);

      listItems = [];
      next = false;
      l = cap.length;
      i = 0;

      for (; i < l; i++) {
        item = cap[i];

        // Remove the list item's bullet
        // so it is seen as the next token.
        space = item.length;
        item = item.replace(/^ *([*+-]|\d+\.) +/, '');

        // Outdent whatever the
        // list item contains. Hacky.
        if (~item.indexOf('\n ')) {
          space -= item.length;
          item = !this.options.pedantic
            ? item.replace(new RegExp('^ {1,' + space + '}', 'gm'), '')
            : item.replace(/^ {1,4}/gm, '');
        }

        // Determine whether the next list item belongs here.
        // Backpedal if it does not belong in this list.
        if (this.options.smartLists && i !== l - 1) {
          b = block.bullet.exec(cap[i + 1])[0];
          if (bull !== b && !(bull.length > 1 && b.length > 1)) {
            src = cap.slice(i + 1).join('\n') + src;
            i = l - 1;
          }
        }

        // Determine whether item is loose or not.
        // Use: /(^|\n)(?! )[^\n]+\n\n(?!\s*$)/
        // for discount behavior.
        loose = next || /\n\n(?!\s*$)/.test(item);
        if (i !== l - 1) {
          next = item.charAt(item.length - 1) === '\n';
          if (!loose) loose = next;
        }

        if (loose) {
          listStart.loose = true;
        }

        // Check for task list items
        istask = /^\[[ xX]\] /.test(item);
        ischecked = undefined;
        if (istask) {
          ischecked = item[1] !== ' ';
          item = item.replace(/^\[[ xX]\] +/, '');
        }

        t = {
          type: 'list_item_start',
          task: istask,
          checked: ischecked,
          loose: loose
        };

        listItems.push(t);
        this.tokens.push(t);

        // Recurse.
        this.token(item, false);

        this.tokens.push({
          type: 'list_item_end'
        });
      }

      if (listStart.loose) {
        l = listItems.length;
        i = 0;
        for (; i < l; i++) {
          listItems[i].loose = true;
        }
      }

      this.tokens.push({
        type: 'list_end'
      });

      continue;
    }

    // html
    if (cap = this.rules.html.exec(src)) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: this.options.sanitize
          ? 'paragraph'
          : 'html',
        pre: !this.options.sanitizer
          && (cap[1] === 'pre' || cap[1] === 'script' || cap[1] === 'style'),
        text: cap[0]
      });
      continue;
    }

    // def
    if (top && (cap = this.rules.def.exec(src))) {
      src = src.substring(cap[0].length);
      if (cap[3]) cap[3] = cap[3].substring(1, cap[3].length - 1);
      tag = cap[1].toLowerCase().replace(/\s+/g, ' ');
      if (!this.tokens.links[tag]) {
        this.tokens.links[tag] = {
          href: cap[2],
          title: cap[3]
        };
      }
      continue;
    }

    // table (gfm)
    if (top && (cap = this.rules.table.exec(src))) {
      item = {
        type: 'table',
        header: splitCells(cap[1].replace(/^ *| *\| *$/g, '')),
        align: cap[2].replace(/^ *|\| *$/g, '').split(/ *\| */),
        cells: cap[3] ? cap[3].replace(/(?: *\| *)?\n$/, '').split('\n') : []
      };

      if (item.header.length === item.align.length) {
        src = src.substring(cap[0].length);

        for (i = 0; i < item.align.length; i++) {
          if (/^ *-+: *$/.test(item.align[i])) {
            item.align[i] = 'right';
          } else if (/^ *:-+: *$/.test(item.align[i])) {
            item.align[i] = 'center';
          } else if (/^ *:-+ *$/.test(item.align[i])) {
            item.align[i] = 'left';
          } else {
            item.align[i] = null;
          }
        }

        for (i = 0; i < item.cells.length; i++) {
          item.cells[i] = splitCells(
            item.cells[i].replace(/^ *\| *| *\| *$/g, ''),
            item.header.length);
        }

        this.tokens.push(item);

        continue;
      }
    }

    // lheading
    if (cap = this.rules.lheading.exec(src)) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'heading',
        depth: cap[2] === '=' ? 1 : 2,
        text: cap[1]
      });
      continue;
    }

    // top-level paragraph
    if (top && (cap = this.rules.paragraph.exec(src))) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'paragraph',
        text: cap[1].charAt(cap[1].length - 1) === '\n'
          ? cap[1].slice(0, -1)
          : cap[1]
      });
      continue;
    }

    // text
    if (cap = this.rules.text.exec(src)) {
      // Top-level should never reach here.
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'text',
        text: cap[0]
      });
      continue;
    }

    if (src) {
      throw new Error('Infinite loop on byte: ' + src.charCodeAt(0));
    }
  }

  return this.tokens;
};

/**
 * Inline-Level Grammar
 */

var inline = {
  escape: /^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/,
  autolink: /^<(scheme:[^\s\x00-\x1f<>]*|email)>/,
  url: noop,
  tag: '^comment'
    + '|^</[a-zA-Z][\\w:-]*\\s*>' // self-closing tag
    + '|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>' // open tag
    + '|^<\\?[\\s\\S]*?\\?>' // processing instruction, e.g. <?php ?>
    + '|^<![a-zA-Z]+\\s[\\s\\S]*?>' // declaration, e.g. <!DOCTYPE html>
    + '|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>', // CDATA section
  link: /^!?\[(label)\]\(href(?:\s+(title))?\s*\)/,
  reflink: /^!?\[(label)\]\[(?!\s*\])((?:\\[\[\]]?|[^\[\]\\])+)\]/,
  nolink: /^!?\[(?!\s*\])((?:\[[^\[\]]*\]|\\[\[\]]|[^\[\]])*)\](?:\[\])?/,
  strong: /^__([^\s])__(?!_)|^\*\*([^\s])\*\*(?!\*)|^__([^\s][\s\S]*?[^\s])__(?!_)|^\*\*([^\s][\s\S]*?[^\s])\*\*(?!\*)/,
  em: /^_([^\s_])_(?!_)|^\*([^\s*"<\[])\*(?!\*)|^_([^\s][\s\S]*?[^\s_])_(?!_)|^_([^\s_][\s\S]*?[^\s])_(?!_)|^\*([^\s"<\[][\s\S]*?[^\s*])\*(?!\*)|^\*([^\s*"<\[][\s\S]*?[^\s])\*(?!\*)/,
  code: /^(`+)\s*([\s\S]*?[^`]?)\s*\1(?!`)/,
  br: /^( {2,}|\\)\n(?!\s*$)/,
  del: noop,
  text: /^[\s\S]+?(?=[\\<!\[`*]|\b_| {2,}\n|$)/
};

inline._escapes = /\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/g;

inline._scheme = /[a-zA-Z][a-zA-Z0-9+.-]{1,31}/;
inline._email = /[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/;
inline.autolink = edit(inline.autolink)
  .replace('scheme', inline._scheme)
  .replace('email', inline._email)
  .getRegex();

inline._attribute = /\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/;

inline.tag = edit(inline.tag)
  .replace('comment', block._comment)
  .replace('attribute', inline._attribute)
  .getRegex();

inline._label = /(?:\[[^\[\]]*\]|\\[\[\]]?|`[^`]*`|[^\[\]\\])*?/;
inline._href = /\s*(<(?:\\[<>]?|[^\s<>\\])*>|(?:\\[()]?|\([^\s\x00-\x1f\\]*\)|[^\s\x00-\x1f()\\])*?)/;
inline._title = /"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/;

inline.link = edit(inline.link)
  .replace('label', inline._label)
  .replace('href', inline._href)
  .replace('title', inline._title)
  .getRegex();

inline.reflink = edit(inline.reflink)
  .replace('label', inline._label)
  .getRegex();

/**
 * Normal Inline Grammar
 */

inline.normal = merge({}, inline);

/**
 * Pedantic Inline Grammar
 */

inline.pedantic = merge({}, inline.normal, {
  strong: /^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,
  em: /^_(?=\S)([\s\S]*?\S)_(?!_)|^\*(?=\S)([\s\S]*?\S)\*(?!\*)/,
  link: edit(/^!?\[(label)\]\((.*?)\)/)
    .replace('label', inline._label)
    .getRegex(),
  reflink: edit(/^!?\[(label)\]\s*\[([^\]]*)\]/)
    .replace('label', inline._label)
    .getRegex()
});

/**
 * GFM Inline Grammar
 */

inline.gfm = merge({}, inline.normal, {
  escape: edit(inline.escape).replace('])', '~|])').getRegex(),
  url: edit(/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/)
    .replace('email', inline._email)
    .getRegex(),
  _backpedal: /(?:[^?!.,:;*_~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_~)]+(?!$))+/,
  del: /^~+(?=\S)([\s\S]*?\S)~+/,
  text: edit(inline.text)
    .replace(']|', '~]|')
    .replace('|', '|https?://|ftp://|www\\.|[a-zA-Z0-9.!#$%&\'*+/=?^_`{\\|}~-]+@|')
    .getRegex()
});

/**
 * GFM + Line Breaks Inline Grammar
 */

inline.breaks = merge({}, inline.gfm, {
  br: edit(inline.br).replace('{2,}', '*').getRegex(),
  text: edit(inline.gfm.text).replace('{2,}', '*').getRegex()
});

/**
 * Inline Lexer & Compiler
 */

function InlineLexer(links, options) {
  this.options = options || marked.defaults;
  this.links = links;
  this.rules = inline.normal;
  this.renderer = this.options.renderer || new Renderer();
  this.renderer.options = this.options;

  if (!this.links) {
    throw new Error('Tokens array requires a `links` property.');
  }

  if (this.options.pedantic) {
    this.rules = inline.pedantic;
  } else if (this.options.gfm) {
    if (this.options.breaks) {
      this.rules = inline.breaks;
    } else {
      this.rules = inline.gfm;
    }
  }
}

/**
 * Expose Inline Rules
 */

InlineLexer.rules = inline;

/**
 * Static Lexing/Compiling Method
 */

InlineLexer.output = function(src, links, options) {
  var inline = new InlineLexer(links, options);
  return inline.output(src);
};

/**
 * Lexing/Compiling
 */

InlineLexer.prototype.output = function(src) {
  var out = '',
      link,
      text,
      href,
      title,
      cap,
      prevCapZero;

  while (src) {
    // escape
    if (cap = this.rules.escape.exec(src)) {
      src = src.substring(cap[0].length);
      out += cap[1];
      continue;
    }

    // autolink
    if (cap = this.rules.autolink.exec(src)) {
      src = src.substring(cap[0].length);
      if (cap[2] === '@') {
        text = escape(this.mangle(cap[1]));
        href = 'mailto:' + text;
      } else {
        text = escape(cap[1]);
        href = text;
      }
      out += this.renderer.link(href, null, text);
      continue;
    }

    // url (gfm)
    if (!this.inLink && (cap = this.rules.url.exec(src))) {
      do {
        prevCapZero = cap[0];
        cap[0] = this.rules._backpedal.exec(cap[0])[0];
      } while (prevCapZero !== cap[0]);
      src = src.substring(cap[0].length);
      if (cap[2] === '@') {
        text = escape(cap[0]);
        href = 'mailto:' + text;
      } else {
        text = escape(cap[0]);
        if (cap[1] === 'www.') {
          href = 'http://' + text;
        } else {
          href = text;
        }
      }
      out += this.renderer.link(href, null, text);
      continue;
    }

    // tag
    if (cap = this.rules.tag.exec(src)) {
      if (!this.inLink && /^<a /i.test(cap[0])) {
        this.inLink = true;
      } else if (this.inLink && /^<\/a>/i.test(cap[0])) {
        this.inLink = false;
      }
      src = src.substring(cap[0].length);
      out += this.options.sanitize
        ? this.options.sanitizer
          ? this.options.sanitizer(cap[0])
          : escape(cap[0])
        : cap[0]
      continue;
    }

    // link
    if (cap = this.rules.link.exec(src)) {
      src = src.substring(cap[0].length);
      this.inLink = true;
      href = cap[2];
      if (this.options.pedantic) {
        link = /^([^'"]*[^\s])\s+(['"])(.*)\2/.exec(href);

        if (link) {
          href = link[1];
          title = link[3];
        } else {
          title = '';
        }
      } else {
        title = cap[3] ? cap[3].slice(1, -1) : '';
      }
      href = href.trim().replace(/^<([\s\S]*)>$/, '$1');
      out += this.outputLink(cap, {
        href: InlineLexer.escapes(href),
        title: InlineLexer.escapes(title)
      });
      this.inLink = false;
      continue;
    }

    // reflink, nolink
    if ((cap = this.rules.reflink.exec(src))
        || (cap = this.rules.nolink.exec(src))) {
      src = src.substring(cap[0].length);
      link = (cap[2] || cap[1]).replace(/\s+/g, ' ');
      link = this.links[link.toLowerCase()];
      if (!link || !link.href) {
        out += cap[0].charAt(0);
        src = cap[0].substring(1) + src;
        continue;
      }
      this.inLink = true;
      out += this.outputLink(cap, link);
      this.inLink = false;
      continue;
    }

    // strong
    if (cap = this.rules.strong.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.strong(this.output(cap[4] || cap[3] || cap[2] || cap[1]));
      continue;
    }

    // em
    if (cap = this.rules.em.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.em(this.output(cap[6] || cap[5] || cap[4] || cap[3] || cap[2] || cap[1]));
      continue;
    }

    // code
    if (cap = this.rules.code.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.codespan(escape(cap[2].trim(), true));
      continue;
    }

    // br
    if (cap = this.rules.br.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.br();
      continue;
    }

    // del (gfm)
    if (cap = this.rules.del.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.del(this.output(cap[1]));
      continue;
    }

    // text
    if (cap = this.rules.text.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.text(escape(this.smartypants(cap[0])));
      continue;
    }

    if (src) {
      throw new Error('Infinite loop on byte: ' + src.charCodeAt(0));
    }
  }

  return out;
};

InlineLexer.escapes = function(text) {
  return text ? text.replace(InlineLexer.rules._escapes, '$1') : text;
}

/**
 * Compile Link
 */

InlineLexer.prototype.outputLink = function(cap, link) {
  var href = link.href,
      title = link.title ? escape(link.title) : null;

  return cap[0].charAt(0) !== '!'
    ? this.renderer.link(href, title, this.output(cap[1]))
    : this.renderer.image(href, title, escape(cap[1]));
};

/**
 * Smartypants Transformations
 */

InlineLexer.prototype.smartypants = function(text) {
  if (!this.options.smartypants) return text;
  return text
    // em-dashes
    .replace(/---/g, '\u2014')
    // en-dashes
    .replace(/--/g, '\u2013')
    // opening singles
    .replace(/(^|[-\u2014/(\[{"\s])'/g, '$1\u2018')
    // closing singles & apostrophes
    .replace(/'/g, '\u2019')
    // opening doubles
    .replace(/(^|[-\u2014/(\[{\u2018\s])"/g, '$1\u201c')
    // closing doubles
    .replace(/"/g, '\u201d')
    // ellipses
    .replace(/\.{3}/g, '\u2026');
};

/**
 * Mangle Links
 */

InlineLexer.prototype.mangle = function(text) {
  if (!this.options.mangle) return text;
  var out = '',
      l = text.length,
      i = 0,
      ch;

  for (; i < l; i++) {
    ch = text.charCodeAt(i);
    if (Math.random() > 0.5) {
      ch = 'x' + ch.toString(16);
    }
    out += '&#' + ch + ';';
  }

  return out;
};

/**
 * Renderer
 */

function Renderer(options) {
  this.options = options || marked.defaults;
}

Renderer.prototype.code = function(code, lang, escaped) {
  if (this.options.highlight) {
    var out = this.options.highlight(code, lang);
    if (out != null && out !== code) {
      escaped = true;
      code = out;
    }
  }

  if (!lang) {
    return '<pre><code>'
      + (escaped ? code : escape(code, true))
      + '</code></pre>';
  }

  return '<pre><code class="'
    + this.options.langPrefix
    + escape(lang, true)
    + '">'
    + (escaped ? code : escape(code, true))
    + '</code></pre>\n';
};

Renderer.prototype.blockquote = function(quote) {
  return '<blockquote>\n' + quote + '</blockquote>\n';
};

Renderer.prototype.html = function(html) {
  return html;
};

Renderer.prototype.heading = function(text, level, raw) {
  if (this.options.headerIds) {
    return '<h'
      + level
      + ' id="'
      + this.options.headerPrefix
      + raw.toLowerCase().replace(/[^\w]+/g, '-')
      + '">'
      + text
      + '</h'
      + level
      + '>\n';
  }
  // ignore IDs
  return '<h' + level + '>' + text + '</h' + level + '>\n';
};

Renderer.prototype.hr = function() {
  return this.options.xhtml ? '<hr/>\n' : '<hr>\n';
};

Renderer.prototype.list = function(body, ordered, start) {
  var type = ordered ? 'ol' : 'ul',
      startatt = (ordered && start !== 1) ? (' start="' + start + '"') : '';
  return '<' + type + startatt + '>\n' + body + '</' + type + '>\n';
};

Renderer.prototype.listitem = function(text) {
  return '<li>' + text + '</li>\n';
};

Renderer.prototype.checkbox = function(checked) {
  return '<input '
    + (checked ? 'checked="" ' : '')
    + 'disabled="" type="checkbox"'
    + (this.options.xhtml ? ' /' : '')
    + '> ';
}

Renderer.prototype.paragraph = function(text) {
  return '<p>' + text + '</p>\n';
};

Renderer.prototype.table = function(header, body) {
  if (body) body = '<tbody>' + body + '</tbody>';

  return '<table>\n'
    + '<thead>\n'
    + header
    + '</thead>\n'
    + body
    + '</table>\n';
};

Renderer.prototype.tablerow = function(content) {
  return '<tr>\n' + content + '</tr>\n';
};

Renderer.prototype.tablecell = function(content, flags) {
  var type = flags.header ? 'th' : 'td';
  var tag = flags.align
    ? '<' + type + ' align="' + flags.align + '">'
    : '<' + type + '>';
  return tag + content + '</' + type + '>\n';
};

// span level renderer
Renderer.prototype.strong = function(text) {
  return '<strong>' + text + '</strong>';
};

Renderer.prototype.em = function(text) {
  return '<em>' + text + '</em>';
};

Renderer.prototype.codespan = function(text) {
  return '<code>' + text + '</code>';
};

Renderer.prototype.br = function() {
  return this.options.xhtml ? '<br/>' : '<br>';
};

Renderer.prototype.del = function(text) {
  return '<del>' + text + '</del>';
};

Renderer.prototype.link = function(href, title, text) {
  if (this.options.sanitize) {
    try {
      var prot = decodeURIComponent(unescape(href))
        .replace(/[^\w:]/g, '')
        .toLowerCase();
    } catch (e) {
      return text;
    }
    if (prot.indexOf('javascript:') === 0 || prot.indexOf('vbscript:') === 0 || prot.indexOf('data:') === 0) {
      return text;
    }
  }
  if (this.options.baseUrl && !originIndependentUrl.test(href)) {
    href = resolveUrl(this.options.baseUrl, href);
  }
  try {
    href = encodeURI(href).replace(/%25/g, '%');
  } catch (e) {
    return text;
  }
  var out = '<a href="' + escape(href) + '"';
  if (title) {
    out += ' title="' + title + '"';
  }
  out += '>' + text + '</a>';
  return out;
};

Renderer.prototype.image = function(href, title, text) {
  if (this.options.baseUrl && !originIndependentUrl.test(href)) {
    href = resolveUrl(this.options.baseUrl, href);
  }
  var out = '<img src="' + href + '" alt="' + text + '"';
  if (title) {
    out += ' title="' + title + '"';
  }
  out += this.options.xhtml ? '/>' : '>';
  return out;
};

Renderer.prototype.text = function(text) {
  return text;
};

/**
 * TextRenderer
 * returns only the textual part of the token
 */

function TextRenderer() {}

// no need for block level renderers

TextRenderer.prototype.strong =
TextRenderer.prototype.em =
TextRenderer.prototype.codespan =
TextRenderer.prototype.del =
TextRenderer.prototype.text = function (text) {
  return text;
}

TextRenderer.prototype.link =
TextRenderer.prototype.image = function(href, title, text) {
  return '' + text;
}

TextRenderer.prototype.br = function() {
  return '';
}

/**
 * Parsing & Compiling
 */

function Parser(options) {
  this.tokens = [];
  this.token = null;
  this.options = options || marked.defaults;
  this.options.renderer = this.options.renderer || new Renderer();
  this.renderer = this.options.renderer;
  this.renderer.options = this.options;
}

/**
 * Static Parse Method
 */

Parser.parse = function(src, options) {
  var parser = new Parser(options);
  return parser.parse(src);
};

/**
 * Parse Loop
 */

Parser.prototype.parse = function(src) {
  this.inline = new InlineLexer(src.links, this.options);
  // use an InlineLexer with a TextRenderer to extract pure text
  this.inlineText = new InlineLexer(
    src.links,
    merge({}, this.options, {renderer: new TextRenderer()})
  );
  this.tokens = src.reverse();

  var out = '';
  while (this.next()) {
    out += this.tok();
  }

  return out;
};

/**
 * Next Token
 */

Parser.prototype.next = function() {
  return this.token = this.tokens.pop();
};

/**
 * Preview Next Token
 */

Parser.prototype.peek = function() {
  return this.tokens[this.tokens.length - 1] || 0;
};

/**
 * Parse Text Tokens
 */

Parser.prototype.parseText = function() {
  var body = this.token.text;

  while (this.peek().type === 'text') {
    body += '\n' + this.next().text;
  }

  return this.inline.output(body);
};

/**
 * Parse Current Token
 */

Parser.prototype.tok = function() {
  switch (this.token.type) {
    case 'space': {
      return '';
    }
    case 'hr': {
      return this.renderer.hr();
    }
    case 'heading': {
      return this.renderer.heading(
        this.inline.output(this.token.text),
        this.token.depth,
        unescape(this.inlineText.output(this.token.text)));
    }
    case 'code': {
      return this.renderer.code(this.token.text,
        this.token.lang,
        this.token.escaped);
    }
    case 'table': {
      var header = '',
          body = '',
          i,
          row,
          cell,
          j;

      // header
      cell = '';
      for (i = 0; i < this.token.header.length; i++) {
        cell += this.renderer.tablecell(
          this.inline.output(this.token.header[i]),
          { header: true, align: this.token.align[i] }
        );
      }
      header += this.renderer.tablerow(cell);

      for (i = 0; i < this.token.cells.length; i++) {
        row = this.token.cells[i];

        cell = '';
        for (j = 0; j < row.length; j++) {
          cell += this.renderer.tablecell(
            this.inline.output(row[j]),
            { header: false, align: this.token.align[j] }
          );
        }

        body += this.renderer.tablerow(cell);
      }
      return this.renderer.table(header, body);
    }
    case 'blockquote_start': {
      body = '';

      while (this.next().type !== 'blockquote_end') {
        body += this.tok();
      }

      return this.renderer.blockquote(body);
    }
    case 'list_start': {
      body = '';
      var ordered = this.token.ordered,
          start = this.token.start;

      while (this.next().type !== 'list_end') {
        body += this.tok();
      }

      return this.renderer.list(body, ordered, start);
    }
    case 'list_item_start': {
      body = '';
      var loose = this.token.loose;

      if (this.token.task) {
        body += this.renderer.checkbox(this.token.checked);
      }

      while (this.next().type !== 'list_item_end') {
        body += !loose && this.token.type === 'text'
          ? this.parseText()
          : this.tok();
      }

      return this.renderer.listitem(body);
    }
    case 'html': {
      // TODO parse inline content if parameter markdown=1
      return this.renderer.html(this.token.text);
    }
    case 'paragraph': {
      return this.renderer.paragraph(this.inline.output(this.token.text));
    }
    case 'text': {
      return this.renderer.paragraph(this.parseText());
    }
  }
};

/**
 * Helpers
 */

function escape(html, encode) {
  return html
    .replace(!encode ? /&(?!#?\w+;)/g : /&/g, '&amp;')
    .replace(/</g, '&lt;')
    .replace(/>/g, '&gt;')
    .replace(/"/g, '&quot;')
    .replace(/'/g, '&#39;');
}

function unescape(html) {
  // explicitly match decimal, hex, and named HTML entities
  return html.replace(/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/ig, function(_, n) {
    n = n.toLowerCase();
    if (n === 'colon') return ':';
    if (n.charAt(0) === '#') {
      return n.charAt(1) === 'x'
        ? String.fromCharCode(parseInt(n.substring(2), 16))
        : String.fromCharCode(+n.substring(1));
    }
    return '';
  });
}

function edit(regex, opt) {
  regex = regex.source || regex;
  opt = opt || '';
  return {
    replace: function(name, val) {
      val = val.source || val;
      val = val.replace(/(^|[^\[])\^/g, '$1');
      regex = regex.replace(name, val);
      return this;
    },
    getRegex: function() {
      return new RegExp(regex, opt);
    }
  };
}

function resolveUrl(base, href) {
  if (!baseUrls[' ' + base]) {
    // we can ignore everything in base after the last slash of its path component,
    // but we might need to add _that_
    // https://tools.ietf.org/html/rfc3986#section-3
    if (/^[^:]+:\/*[^/]*$/.test(base)) {
      baseUrls[' ' + base] = base + '/';
    } else {
      baseUrls[' ' + base] = rtrim(base, '/', true);
    }
  }
  base = baseUrls[' ' + base];

  if (href.slice(0, 2) === '//') {
    return base.replace(/:[\s\S]*/, ':') + href;
  } else if (href.charAt(0) === '/') {
    return base.replace(/(:\/*[^/]*)[\s\S]*/, '$1') + href;
  } else {
    return base + href;
  }
}
var baseUrls = {};
var originIndependentUrl = /^$|^[a-z][a-z0-9+.-]*:|^[?#]/i;

function noop() {}
noop.exec = noop;

function merge(obj) {
  var i = 1,
      target,
      key;

  for (; i < arguments.length; i++) {
    target = arguments[i];
    for (key in target) {
      if (Object.prototype.hasOwnProperty.call(target, key)) {
        obj[key] = target[key];
      }
    }
  }

  return obj;
}

function splitCells(tableRow, count) {
  // ensure that every cell-delimiting pipe has a space
  // before it to distinguish it from an escaped pipe
  var row = tableRow.replace(/\|/g, function (match, offset, str) {
        var escaped = false,
            curr = offset;
        while (--curr >= 0 && str[curr] === '\\') escaped = !escaped;
        if (escaped) {
          // odd number of slashes means | is escaped
          // so we leave it alone
          return '|';
        } else {
          // add space before unescaped |
          return ' |';
        }
      }),
      cells = row.split(/ \|/),
      i = 0;

  if (cells.length > count) {
    cells.splice(count);
  } else {
    while (cells.length < count) cells.push('');
  }

  for (; i < cells.length; i++) {
    // leading or trailing whitespace is ignored per the gfm spec
    cells[i] = cells[i].trim().replace(/\\\|/g, '|');
  }
  return cells;
}

// Remove trailing 'c's. Equivalent to str.replace(/c*$/, '').
// /c*$/ is vulnerable to REDOS.
// invert: Remove suffix of non-c chars instead. Default falsey.
function rtrim(str, c, invert) {
  if (str.length === 0) {
    return '';
  }

  // Length of suffix matching the invert condition.
  var suffLen = 0;

  // Step left until we fail to match the invert condition.
  while (suffLen < str.length) {
    var currChar = str.charAt(str.length - suffLen - 1);
    if (currChar === c && !invert) {
      suffLen++;
    } else if (currChar !== c && invert) {
      suffLen++;
    } else {
      break;
    }
  }

  return str.substr(0, str.length - suffLen);
}

/**
 * Marked
 */

function marked(src, opt, callback) {
  // throw error in case of non string input
  if (typeof src === 'undefined' || src === null) {
    throw new Error('marked(): input parameter is undefined or null');
  }
  if (typeof src !== 'string') {
    throw new Error('marked(): input parameter is of type '
      + Object.prototype.toString.call(src) + ', string expected');
  }

  if (callback || typeof opt === 'function') {
    if (!callback) {
      callback = opt;
      opt = null;
    }

    opt = merge({}, marked.defaults, opt || {});

    var highlight = opt.highlight,
        tokens,
        pending,
        i = 0;

    try {
      tokens = Lexer.lex(src, opt)
    } catch (e) {
      return callback(e);
    }

    pending = tokens.length;

    var done = function(err) {
      if (err) {
        opt.highlight = highlight;
        return callback(err);
      }

      var out;

      try {
        out = Parser.parse(tokens, opt);
      } catch (e) {
        err = e;
      }

      opt.highlight = highlight;

      return err
        ? callback(err)
        : callback(null, out);
    };

    if (!highlight || highlight.length < 3) {
      return done();
    }

    delete opt.highlight;

    if (!pending) return done();

    for (; i < tokens.length; i++) {
      (function(token) {
        if (token.type !== 'code') {
          return --pending || done();
        }
        return highlight(token.text, token.lang, function(err, code) {
          if (err) return done(err);
          if (code == null || code === token.text) {
            return --pending || done();
          }
          token.text = code;
          token.escaped = true;
          --pending || done();
        });
      })(tokens[i]);
    }

    return;
  }
  try {
    if (opt) opt = merge({}, marked.defaults, opt);
    return Parser.parse(Lexer.lex(src, opt), opt);
  } catch (e) {
    e.message += '\nPlease report this to https://github.com/markedjs/marked.';
    if ((opt || marked.defaults).silent) {
      return '<p>An error occurred:</p><pre>'
        + escape(e.message + '', true)
        + '</pre>';
    }
    throw e;
  }
}

/**
 * Options
 */

marked.options =
marked.setOptions = function(opt) {
  merge(marked.defaults, opt);
  return marked;
};

marked.getDefaults = function () {
  return {
    baseUrl: null,
    breaks: false,
    gfm: true,
    headerIds: true,
    headerPrefix: '',
    highlight: null,
    langPrefix: 'language-',
    mangle: true,
    pedantic: false,
    renderer: new Renderer(),
    sanitize: false,
    sanitizer: null,
    silent: false,
    smartLists: false,
    smartypants: false,
    tables: true,
    xhtml: false
  };
}

marked.defaults = marked.getDefaults();

/**
 * Expose
 */

marked.Parser = Parser;
marked.parser = Parser.parse;

marked.Renderer = Renderer;
marked.TextRenderer = TextRenderer;

marked.Lexer = Lexer;
marked.lexer = Lexer.lex;

marked.InlineLexer = InlineLexer;
marked.inlineLexer = InlineLexer.output;

marked.parse = marked;

// BEGIN MONACOCHANGE
// if (typeof module !== 'undefined' && typeof exports === 'object') {
//   module.exports = marked;
// } else if (typeof define === 'function' && define.amd) {
//   define(function() { return marked; });
// } else {
//   root.marked = marked;
// }
// })(this || (typeof window !== 'undefined' ? window : global));
__marked_exports = marked;
}).call(this);

// ESM-comment-begin
define("vs/base/common/marked/marked", function() { return __marked_exports; });
// ESM-comment-end
 
// ESM-uncomment-begin
// export var marked = __marked_exports;
// export var Parser = __marked_exports.Parser;
// export var parser = __marked_exports.parser;
// export var Renderer = __marked_exports.Renderer;
// export var TextRenderer = __marked_exports.TextRenderer;
// export var Lexer = __marked_exports.Lexer;
// export var lexer = __marked_exports.lexer;
// export var InlineLexer = __marked_exports.InlineLexer;
// export var inlineLexer = __marked_exports.inlineLexer;
// export var parse = __marked_exports.parse;
// ESM-uncomment-end
// END MONACOCHANGE

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[50/*vs/base/common/network*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Schemas;
    (function (Schemas) {
        /**
         * A schema that is used for models that exist in memory
         * only and that have no correspondence on a server or such.
         */
        Schemas.inMemory = 'inmemory';
        /**
         * A schema that is used for setting files
         */
        Schemas.vscode = 'vscode';
        /**
         * A schema that is used for internal private files
         */
        Schemas.internal = 'private';
        /**
         * A walk-through document.
         */
        Schemas.walkThrough = 'walkThrough';
        /**
         * An embedded code snippet.
         */
        Schemas.walkThroughSnippet = 'walkThroughSnippet';
        Schemas.http = 'http';
        Schemas.https = 'https';
        Schemas.file = 'file';
        Schemas.mailto = 'mailto';
        Schemas.untitled = 'untitled';
        Schemas.data = 'data';
    })(Schemas = exports.Schemas || (exports.Schemas = {}));
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[427/*vs/base/common/numbers*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function clamp(value, min, max) {
        return Math.min(Math.max(value, min), max);
    }
    exports.clamp = clamp;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[17/*vs/base/common/platform*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var _isWindows = false;
    var _isMacintosh = false;
    var _isLinux = false;
    var _isNative = false;
    var _isWeb = false;
    var _locale = undefined;
    var _language = undefined;
    var _translationsConfigFile = undefined;
    exports.LANGUAGE_DEFAULT = 'en';
    var isElectronRenderer = (typeof process !== 'undefined' && typeof process.versions !== 'undefined' && typeof process.versions.electron !== 'undefined' && process.type === 'renderer');
    // OS detection
    if (typeof navigator === 'object' && !isElectronRenderer) {
        var userAgent = navigator.userAgent;
        _isWindows = userAgent.indexOf('Windows') >= 0;
        _isMacintosh = userAgent.indexOf('Macintosh') >= 0;
        _isLinux = userAgent.indexOf('Linux') >= 0;
        _isWeb = true;
        _locale = navigator.language;
        _language = _locale;
    }
    else if (typeof process === 'object') {
        _isWindows = (process.platform === 'win32');
        _isMacintosh = (process.platform === 'darwin');
        _isLinux = (process.platform === 'linux');
        _locale = exports.LANGUAGE_DEFAULT;
        _language = exports.LANGUAGE_DEFAULT;
        var rawNlsConfig = process.env['VSCODE_NLS_CONFIG'];
        if (rawNlsConfig) {
            try {
                var nlsConfig = JSON.parse(rawNlsConfig);
                var resolved = nlsConfig.availableLanguages['*'];
                _locale = nlsConfig.locale;
                // VSCode's default language is 'en'
                _language = resolved ? resolved : exports.LANGUAGE_DEFAULT;
                _translationsConfigFile = nlsConfig._translationsConfigFile;
            }
            catch (e) {
            }
        }
        _isNative = true;
    }
    var _platform = 0 /* Web */;
    if (_isNative) {
        if (_isMacintosh) {
            _platform = 1 /* Mac */;
        }
        else if (_isWindows) {
            _platform = 3 /* Windows */;
        }
        else if (_isLinux) {
            _platform = 2 /* Linux */;
        }
    }
    exports.isWindows = _isWindows;
    exports.isMacintosh = _isMacintosh;
    exports.isLinux = _isLinux;
    exports.isNative = _isNative;
    exports.isWeb = _isWeb;
    var _globals = (typeof self === 'object' ? self : typeof global === 'object' ? global : {});
    exports.globals = _globals;
    var _setImmediate = null;
    function setImmediate(callback) {
        if (_setImmediate === null) {
            if (exports.globals.setImmediate) {
                _setImmediate = exports.globals.setImmediate.bind(exports.globals);
            }
            else if (typeof process !== 'undefined' && typeof process.nextTick === 'function') {
                _setImmediate = process.nextTick.bind(process);
            }
            else {
                _setImmediate = exports.globals.setTimeout.bind(exports.globals);
            }
        }
        return _setImmediate(callback);
    }
    exports.setImmediate = setImmediate;
    exports.OS = (_isMacintosh ? 2 /* Macintosh */ : (_isWindows ? 1 /* Windows */ : 3 /* Linux */));
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[115/*vs/base/common/range*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Range;
    (function (Range) {
        /**
         * Returns the intersection between two ranges as a range itself.
         * Returns `{ start: 0, end: 0 }` if the intersection is empty.
         */
        function intersect(one, other) {
            if (one.start >= other.end || other.start >= one.end) {
                return { start: 0, end: 0 };
            }
            var start = Math.max(one.start, other.start);
            var end = Math.min(one.end, other.end);
            if (end - start <= 0) {
                return { start: 0, end: 0 };
            }
            return { start: start, end: end };
        }
        Range.intersect = intersect;
        function isEmpty(range) {
            return range.end - range.start <= 0;
        }
        Range.isEmpty = isEmpty;
        function intersects(one, other) {
            return !isEmpty(intersect(one, other));
        }
        Range.intersects = intersects;
        function relativeComplement(one, other) {
            var result = [];
            var first = { start: one.start, end: Math.min(other.start, one.end) };
            var second = { start: Math.max(other.end, one.start), end: one.end };
            if (!isEmpty(first)) {
                result.push(first);
            }
            if (!isEmpty(second)) {
                result.push(second);
            }
            return result;
        }
        Range.relativeComplement = relativeComplement;
    })(Range = exports.Range || (exports.Range = {}));
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[466/*vs/base/browser/ui/list/rangeMap*/], __M([0/*require*/,1/*exports*/,115/*vs/base/common/range*/]), function (require, exports, range_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * Returns the intersection between a ranged group and a range.
     * Returns `[]` if the intersection is empty.
     */
    function groupIntersect(range, groups) {
        var result = [];
        for (var _i = 0, groups_1 = groups; _i < groups_1.length; _i++) {
            var r = groups_1[_i];
            if (range.start >= r.range.end) {
                continue;
            }
            if (range.end < r.range.start) {
                break;
            }
            var intersection = range_1.Range.intersect(range, r.range);
            if (range_1.Range.isEmpty(intersection)) {
                continue;
            }
            result.push({
                range: intersection,
                size: r.size
            });
        }
        return result;
    }
    exports.groupIntersect = groupIntersect;
    /**
     * Shifts a range by that `much`.
     */
    function shift(_a, much) {
        var start = _a.start, end = _a.end;
        return { start: start + much, end: end + much };
    }
    exports.shift = shift;
    /**
     * Consolidates a collection of ranged groups.
     *
     * Consolidation is the process of merging consecutive ranged groups
     * that share the same `size`.
     */
    function consolidate(groups) {
        var result = [];
        var previousGroup = null;
        for (var _i = 0, groups_2 = groups; _i < groups_2.length; _i++) {
            var group = groups_2[_i];
            var start = group.range.start;
            var end = group.range.end;
            var size = group.size;
            if (previousGroup && size === previousGroup.size) {
                previousGroup.range.end = end;
                continue;
            }
            previousGroup = { range: { start: start, end: end }, size: size };
            result.push(previousGroup);
        }
        return result;
    }
    exports.consolidate = consolidate;
    /**
     * Concatenates several collections of ranged groups into a single
     * collection.
     */
    function concat() {
        var groups = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            groups[_i] = arguments[_i];
        }
        return consolidate(groups.reduce(function (r, g) { return r.concat(g); }, []));
    }
    var RangeMap = /** @class */ (function () {
        function RangeMap() {
            this.groups = [];
            this._size = 0;
        }
        RangeMap.prototype.splice = function (index, deleteCount, items) {
            if (items === void 0) { items = []; }
            var diff = items.length - deleteCount;
            var before = groupIntersect({ start: 0, end: index }, this.groups);
            var after = groupIntersect({ start: index + deleteCount, end: Number.POSITIVE_INFINITY }, this.groups)
                .map(function (g) { return ({ range: shift(g.range, diff), size: g.size }); });
            var middle = items.map(function (item, i) { return ({
                range: { start: index + i, end: index + i + 1 },
                size: item.size
            }); });
            this.groups = concat(before, middle, after);
            this._size = this.groups.reduce(function (t, g) { return t + (g.size * (g.range.end - g.range.start)); }, 0);
        };
        Object.defineProperty(RangeMap.prototype, "count", {
            /**
             * Returns the number of items in the range map.
             */
            get: function () {
                var len = this.groups.length;
                if (!len) {
                    return 0;
                }
                return this.groups[len - 1].range.end;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(RangeMap.prototype, "size", {
            /**
             * Returns the sum of the sizes of all items in the range map.
             */
            get: function () {
                return this._size;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Returns the index of the item at the given position.
         */
        RangeMap.prototype.indexAt = function (position) {
            if (position < 0) {
                return -1;
            }
            var index = 0;
            var size = 0;
            for (var _i = 0, _a = this.groups; _i < _a.length; _i++) {
                var group = _a[_i];
                var count = group.range.end - group.range.start;
                var newSize = size + (count * group.size);
                if (position < newSize) {
                    return index + Math.floor((position - size) / group.size);
                }
                index += count;
                size = newSize;
            }
            return index;
        };
        /**
         * Returns the index of the item right after the item at the
         * index of the given position.
         */
        RangeMap.prototype.indexAfter = function (position) {
            return Math.min(this.indexAt(position) + 1, this.count);
        };
        /**
         * Returns the start position of the item at the given index.
         */
        RangeMap.prototype.positionAt = function (index) {
            if (index < 0) {
                return -1;
            }
            var position = 0;
            var count = 0;
            for (var _i = 0, _a = this.groups; _i < _a.length; _i++) {
                var group = _a[_i];
                var groupCount = group.range.end - group.range.start;
                var newCount = count + groupCount;
                if (index < newCount) {
                    return position + ((index - count) * group.size);
                }
                position += groupCount * group.size;
                count = newCount;
            }
            return -1;
        };
        RangeMap.prototype.dispose = function () {
            this.groups = null; // StrictNullOverride: nulling out ok in dispose
        };
        return RangeMap;
    }());
    exports.RangeMap = RangeMap;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[205/*vs/base/common/stopwatch*/], __M([0/*require*/,1/*exports*/,17/*vs/base/common/platform*/]), function (require, exports, platform_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var hasPerformanceNow = (platform_1.globals.performance && typeof platform_1.globals.performance.now === 'function');
    var StopWatch = /** @class */ (function () {
        function StopWatch(highResolution) {
            this._highResolution = hasPerformanceNow && highResolution;
            this._startTime = this._now();
            this._stopTime = -1;
        }
        StopWatch.create = function (highResolution) {
            if (highResolution === void 0) { highResolution = true; }
            return new StopWatch(highResolution);
        };
        StopWatch.prototype.elapsed = function () {
            if (this._stopTime !== -1) {
                return this._stopTime - this._startTime;
            }
            return this._now() - this._startTime;
        };
        StopWatch.prototype._now = function () {
            return this._highResolution ? platform_1.globals.performance.now() : new Date().getTime();
        };
        return StopWatch;
    }());
    exports.StopWatch = StopWatch;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[8/*vs/base/common/strings*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * The empty string.
     */
    exports.empty = '';
    function isFalsyOrWhitespace(str) {
        if (!str || typeof str !== 'string') {
            return true;
        }
        return str.trim().length === 0;
    }
    exports.isFalsyOrWhitespace = isFalsyOrWhitespace;
    /**
     * @returns the provided number with the given number of preceding zeros.
     */
    function pad(n, l, char) {
        if (char === void 0) { char = '0'; }
        var str = '' + n;
        var r = [str];
        for (var i = str.length; i < l; i++) {
            r.push(char);
        }
        return r.reverse().join('');
    }
    exports.pad = pad;
    var _formatRegexp = /{(\d+)}/g;
    /**
     * Helper to produce a string with a variable number of arguments. Insert variable segments
     * into the string using the {n} notation where N is the index of the argument following the string.
     * @param value string to which formatting is applied
     * @param args replacements for {n}-entries
     */
    function format(value) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (args.length === 0) {
            return value;
        }
        return value.replace(_formatRegexp, function (match, group) {
            var idx = parseInt(group, 10);
            return isNaN(idx) || idx < 0 || idx >= args.length ?
                match :
                args[idx];
        });
    }
    exports.format = format;
    /**
     * Converts HTML characters inside the string to use entities instead. Makes the string safe from
     * being used e.g. in HTMLElement.innerHTML.
     */
    function escape(html) {
        return html.replace(/[<|>|&]/g, function (match) {
            switch (match) {
                case '<': return '&lt;';
                case '>': return '&gt;';
                case '&': return '&amp;';
                default: return match;
            }
        });
    }
    exports.escape = escape;
    /**
     * Escapes regular expression characters in a given string
     */
    function escapeRegExpCharacters(value) {
        return value.replace(/[\-\\\{\}\*\+\?\|\^\$\.\[\]\(\)\#]/g, '\\$&');
    }
    exports.escapeRegExpCharacters = escapeRegExpCharacters;
    /**
     * Removes all occurrences of needle from the beginning and end of haystack.
     * @param haystack string to trim
     * @param needle the thing to trim (default is a blank)
     */
    function trim(haystack, needle) {
        if (needle === void 0) { needle = ' '; }
        var trimmed = ltrim(haystack, needle);
        return rtrim(trimmed, needle);
    }
    exports.trim = trim;
    /**
     * Removes all occurrences of needle from the beginning of haystack.
     * @param haystack string to trim
     * @param needle the thing to trim
     */
    function ltrim(haystack, needle) {
        if (!haystack || !needle) {
            return haystack;
        }
        var needleLen = needle.length;
        if (needleLen === 0 || haystack.length === 0) {
            return haystack;
        }
        var offset = 0;
        while (haystack.indexOf(needle, offset) === offset) {
            offset = offset + needleLen;
        }
        return haystack.substring(offset);
    }
    exports.ltrim = ltrim;
    /**
     * Removes all occurrences of needle from the end of haystack.
     * @param haystack string to trim
     * @param needle the thing to trim
     */
    function rtrim(haystack, needle) {
        if (!haystack || !needle) {
            return haystack;
        }
        var needleLen = needle.length, haystackLen = haystack.length;
        if (needleLen === 0 || haystackLen === 0) {
            return haystack;
        }
        var offset = haystackLen, idx = -1;
        while (true) {
            idx = haystack.lastIndexOf(needle, offset - 1);
            if (idx === -1 || idx + needleLen !== offset) {
                break;
            }
            if (idx === 0) {
                return '';
            }
            offset = idx;
        }
        return haystack.substring(0, offset);
    }
    exports.rtrim = rtrim;
    function convertSimple2RegExpPattern(pattern) {
        return pattern.replace(/[\-\\\{\}\+\?\|\^\$\.\,\[\]\(\)\#\s]/g, '\\$&').replace(/[\*]/g, '.*');
    }
    exports.convertSimple2RegExpPattern = convertSimple2RegExpPattern;
    /**
     * Determines if haystack starts with needle.
     */
    function startsWith(haystack, needle) {
        if (haystack.length < needle.length) {
            return false;
        }
        if (haystack === needle) {
            return true;
        }
        for (var i = 0; i < needle.length; i++) {
            if (haystack[i] !== needle[i]) {
                return false;
            }
        }
        return true;
    }
    exports.startsWith = startsWith;
    /**
     * Determines if haystack ends with needle.
     */
    function endsWith(haystack, needle) {
        var diff = haystack.length - needle.length;
        if (diff > 0) {
            return haystack.indexOf(needle, diff) === diff;
        }
        else if (diff === 0) {
            return haystack === needle;
        }
        else {
            return false;
        }
    }
    exports.endsWith = endsWith;
    function createRegExp(searchString, isRegex, options) {
        if (options === void 0) { options = {}; }
        if (!searchString) {
            throw new Error('Cannot create regex from empty string');
        }
        if (!isRegex) {
            searchString = escapeRegExpCharacters(searchString);
        }
        if (options.wholeWord) {
            if (!/\B/.test(searchString.charAt(0))) {
                searchString = '\\b' + searchString;
            }
            if (!/\B/.test(searchString.charAt(searchString.length - 1))) {
                searchString = searchString + '\\b';
            }
        }
        var modifiers = '';
        if (options.global) {
            modifiers += 'g';
        }
        if (!options.matchCase) {
            modifiers += 'i';
        }
        if (options.multiline) {
            modifiers += 'm';
        }
        return new RegExp(searchString, modifiers);
    }
    exports.createRegExp = createRegExp;
    function regExpLeadsToEndlessLoop(regexp) {
        // Exit early if it's one of these special cases which are meant to match
        // against an empty string
        if (regexp.source === '^' || regexp.source === '^$' || regexp.source === '$' || regexp.source === '^\\s*$') {
            return false;
        }
        // We check against an empty string. If the regular expression doesn't advance
        // (e.g. ends in an endless loop) it will match an empty string.
        var match = regexp.exec('');
        return !!(match && regexp.lastIndex === 0);
    }
    exports.regExpLeadsToEndlessLoop = regExpLeadsToEndlessLoop;
    /**
     * Returns first index of the string that is not whitespace.
     * If string is empty or contains only whitespaces, returns -1
     */
    function firstNonWhitespaceIndex(str) {
        for (var i = 0, len = str.length; i < len; i++) {
            var chCode = str.charCodeAt(i);
            if (chCode !== 32 /* Space */ && chCode !== 9 /* Tab */) {
                return i;
            }
        }
        return -1;
    }
    exports.firstNonWhitespaceIndex = firstNonWhitespaceIndex;
    /**
     * Returns the leading whitespace of the string.
     * If the string contains only whitespaces, returns entire string
     */
    function getLeadingWhitespace(str, start, end) {
        if (start === void 0) { start = 0; }
        if (end === void 0) { end = str.length; }
        for (var i = start; i < end; i++) {
            var chCode = str.charCodeAt(i);
            if (chCode !== 32 /* Space */ && chCode !== 9 /* Tab */) {
                return str.substring(start, i);
            }
        }
        return str.substring(start, end);
    }
    exports.getLeadingWhitespace = getLeadingWhitespace;
    /**
     * Returns last index of the string that is not whitespace.
     * If string is empty or contains only whitespaces, returns -1
     */
    function lastNonWhitespaceIndex(str, startIndex) {
        if (startIndex === void 0) { startIndex = str.length - 1; }
        for (var i = startIndex; i >= 0; i--) {
            var chCode = str.charCodeAt(i);
            if (chCode !== 32 /* Space */ && chCode !== 9 /* Tab */) {
                return i;
            }
        }
        return -1;
    }
    exports.lastNonWhitespaceIndex = lastNonWhitespaceIndex;
    function compare(a, b) {
        if (a < b) {
            return -1;
        }
        else if (a > b) {
            return 1;
        }
        else {
            return 0;
        }
    }
    exports.compare = compare;
    function isLowerAsciiLetter(code) {
        return code >= 97 /* a */ && code <= 122 /* z */;
    }
    exports.isLowerAsciiLetter = isLowerAsciiLetter;
    function isUpperAsciiLetter(code) {
        return code >= 65 /* A */ && code <= 90 /* Z */;
    }
    exports.isUpperAsciiLetter = isUpperAsciiLetter;
    function isAsciiLetter(code) {
        return isLowerAsciiLetter(code) || isUpperAsciiLetter(code);
    }
    function equalsIgnoreCase(a, b) {
        var len1 = a ? a.length : 0;
        var len2 = b ? b.length : 0;
        if (len1 !== len2) {
            return false;
        }
        return doEqualsIgnoreCase(a, b);
    }
    exports.equalsIgnoreCase = equalsIgnoreCase;
    function doEqualsIgnoreCase(a, b, stopAt) {
        if (stopAt === void 0) { stopAt = a.length; }
        if (typeof a !== 'string' || typeof b !== 'string') {
            return false;
        }
        for (var i = 0; i < stopAt; i++) {
            var codeA = a.charCodeAt(i);
            var codeB = b.charCodeAt(i);
            if (codeA === codeB) {
                continue;
            }
            // a-z A-Z
            if (isAsciiLetter(codeA) && isAsciiLetter(codeB)) {
                var diff = Math.abs(codeA - codeB);
                if (diff !== 0 && diff !== 32) {
                    return false;
                }
            }
            // Any other charcode
            else {
                if (String.fromCharCode(codeA).toLowerCase() !== String.fromCharCode(codeB).toLowerCase()) {
                    return false;
                }
            }
        }
        return true;
    }
    function startsWithIgnoreCase(str, candidate) {
        var candidateLength = candidate.length;
        if (candidate.length > str.length) {
            return false;
        }
        return doEqualsIgnoreCase(str, candidate, candidateLength);
    }
    exports.startsWithIgnoreCase = startsWithIgnoreCase;
    /**
     * @returns the length of the common prefix of the two strings.
     */
    function commonPrefixLength(a, b) {
        var i, len = Math.min(a.length, b.length);
        for (i = 0; i < len; i++) {
            if (a.charCodeAt(i) !== b.charCodeAt(i)) {
                return i;
            }
        }
        return len;
    }
    exports.commonPrefixLength = commonPrefixLength;
    /**
     * @returns the length of the common suffix of the two strings.
     */
    function commonSuffixLength(a, b) {
        var i, len = Math.min(a.length, b.length);
        var aLastIndex = a.length - 1;
        var bLastIndex = b.length - 1;
        for (i = 0; i < len; i++) {
            if (a.charCodeAt(aLastIndex - i) !== b.charCodeAt(bLastIndex - i)) {
                return i;
            }
        }
        return len;
    }
    exports.commonSuffixLength = commonSuffixLength;
    // --- unicode
    // http://en.wikipedia.org/wiki/Surrogate_pair
    // Returns the code point starting at a specified index in a string
    // Code points U+0000 to U+D7FF and U+E000 to U+FFFF are represented on a single character
    // Code points U+10000 to U+10FFFF are represented on two consecutive characters
    //export function getUnicodePoint(str:string, index:number, len:number):number {
    //	let chrCode = str.charCodeAt(index);
    //	if (0xD800 <= chrCode && chrCode <= 0xDBFF && index + 1 < len) {
    //		let nextChrCode = str.charCodeAt(index + 1);
    //		if (0xDC00 <= nextChrCode && nextChrCode <= 0xDFFF) {
    //			return (chrCode - 0xD800) << 10 + (nextChrCode - 0xDC00) + 0x10000;
    //		}
    //	}
    //	return chrCode;
    //}
    function isHighSurrogate(charCode) {
        return (0xD800 <= charCode && charCode <= 0xDBFF);
    }
    exports.isHighSurrogate = isHighSurrogate;
    function isLowSurrogate(charCode) {
        return (0xDC00 <= charCode && charCode <= 0xDFFF);
    }
    exports.isLowSurrogate = isLowSurrogate;
    /**
     * Generated using https://github.com/alexandrudima/unicode-utils/blob/master/generate-rtl-test.js
     */
    var CONTAINS_RTL = /(?:[\u05BE\u05C0\u05C3\u05C6\u05D0-\u05F4\u0608\u060B\u060D\u061B-\u064A\u066D-\u066F\u0671-\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u0710\u0712-\u072F\u074D-\u07A5\u07B1-\u07EA\u07F4\u07F5\u07FA-\u0815\u081A\u0824\u0828\u0830-\u0858\u085E-\u08BD\u200F\uFB1D\uFB1F-\uFB28\uFB2A-\uFD3D\uFD50-\uFDFC\uFE70-\uFEFC]|\uD802[\uDC00-\uDD1B\uDD20-\uDE00\uDE10-\uDE33\uDE40-\uDEE4\uDEEB-\uDF35\uDF40-\uDFFF]|\uD803[\uDC00-\uDCFF]|\uD83A[\uDC00-\uDCCF\uDD00-\uDD43\uDD50-\uDFFF]|\uD83B[\uDC00-\uDEBB])/;
    /**
     * Returns true if `str` contains any Unicode character that is classified as "R" or "AL".
     */
    function containsRTL(str) {
        return CONTAINS_RTL.test(str);
    }
    exports.containsRTL = containsRTL;
    /**
     * Generated using https://github.com/alexandrudima/unicode-utils/blob/master/generate-emoji-test.js
     */
    var CONTAINS_EMOJI = /(?:[\u231A\u231B\u23F0\u23F3\u2600-\u27BF\u2B50\u2B55]|\uD83C[\uDDE6-\uDDFF\uDF00-\uDFFF]|\uD83D[\uDC00-\uDE4F\uDE80-\uDEF8]|\uD83E[\uDD00-\uDDE6])/;
    function containsEmoji(str) {
        return CONTAINS_EMOJI.test(str);
    }
    exports.containsEmoji = containsEmoji;
    var IS_BASIC_ASCII = /^[\t\n\r\x20-\x7E]*$/;
    /**
     * Returns true if `str` contains only basic ASCII characters in the range 32 - 126 (including 32 and 126) or \n, \r, \t
     */
    function isBasicASCII(str) {
        return IS_BASIC_ASCII.test(str);
    }
    exports.isBasicASCII = isBasicASCII;
    function containsFullWidthCharacter(str) {
        for (var i = 0, len = str.length; i < len; i++) {
            if (isFullWidthCharacter(str.charCodeAt(i))) {
                return true;
            }
        }
        return false;
    }
    exports.containsFullWidthCharacter = containsFullWidthCharacter;
    function isFullWidthCharacter(charCode) {
        // Do a cheap trick to better support wrapping of wide characters, treat them as 2 columns
        // http://jrgraphix.net/research/unicode_blocks.php
        //          2E80 — 2EFF   CJK Radicals Supplement
        //          2F00 — 2FDF   Kangxi Radicals
        //          2FF0 — 2FFF   Ideographic Description Characters
        //          3000 — 303F   CJK Symbols and Punctuation
        //          3040 — 309F   Hiragana
        //          30A0 — 30FF   Katakana
        //          3100 — 312F   Bopomofo
        //          3130 — 318F   Hangul Compatibility Jamo
        //          3190 — 319F   Kanbun
        //          31A0 — 31BF   Bopomofo Extended
        //          31F0 — 31FF   Katakana Phonetic Extensions
        //          3200 — 32FF   Enclosed CJK Letters and Months
        //          3300 — 33FF   CJK Compatibility
        //          3400 — 4DBF   CJK Unified Ideographs Extension A
        //          4DC0 — 4DFF   Yijing Hexagram Symbols
        //          4E00 — 9FFF   CJK Unified Ideographs
        //          A000 — A48F   Yi Syllables
        //          A490 — A4CF   Yi Radicals
        //          AC00 — D7AF   Hangul Syllables
        // [IGNORE] D800 — DB7F   High Surrogates
        // [IGNORE] DB80 — DBFF   High Private Use Surrogates
        // [IGNORE] DC00 — DFFF   Low Surrogates
        // [IGNORE] E000 — F8FF   Private Use Area
        //          F900 — FAFF   CJK Compatibility Ideographs
        // [IGNORE] FB00 — FB4F   Alphabetic Presentation Forms
        // [IGNORE] FB50 — FDFF   Arabic Presentation Forms-A
        // [IGNORE] FE00 — FE0F   Variation Selectors
        // [IGNORE] FE20 — FE2F   Combining Half Marks
        // [IGNORE] FE30 — FE4F   CJK Compatibility Forms
        // [IGNORE] FE50 — FE6F   Small Form Variants
        // [IGNORE] FE70 — FEFF   Arabic Presentation Forms-B
        //          FF00 — FFEF   Halfwidth and Fullwidth Forms
        //               [https://en.wikipedia.org/wiki/Halfwidth_and_fullwidth_forms]
        //               of which FF01 - FF5E fullwidth ASCII of 21 to 7E
        // [IGNORE]    and FF65 - FFDC halfwidth of Katakana and Hangul
        // [IGNORE] FFF0 — FFFF   Specials
        charCode = +charCode; // @perf
        return ((charCode >= 0x2E80 && charCode <= 0xD7AF)
            || (charCode >= 0xF900 && charCode <= 0xFAFF)
            || (charCode >= 0xFF01 && charCode <= 0xFF5E));
    }
    exports.isFullWidthCharacter = isFullWidthCharacter;
    // -- UTF-8 BOM
    exports.UTF8_BOM_CHARACTER = String.fromCharCode(65279 /* UTF8_BOM */);
    function startsWithUTF8BOM(str) {
        return !!(str && str.length > 0 && str.charCodeAt(0) === 65279 /* UTF8_BOM */);
    }
    exports.startsWithUTF8BOM = startsWithUTF8BOM;
    function safeBtoa(str) {
        return btoa(encodeURIComponent(str)); // we use encodeURIComponent because btoa fails for non Latin 1 values
    }
    exports.safeBtoa = safeBtoa;
    function repeat(s, count) {
        var result = '';
        for (var i = 0; i < count; i++) {
            result += s;
        }
        return result;
    }
    exports.repeat = repeat;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[247/*vs/base/browser/ui/octiconLabel/octiconLabel*/], __M([0/*require*/,1/*exports*/,8/*vs/base/common/strings*/]), function (require, exports, strings_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function renderOcticons(text) {
        return strings_1.escape(text);
    }
    exports.renderOcticons = renderOcticons;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[100/*vs/base/common/filters*/], __M([0/*require*/,1/*exports*/,65/*vs/base/common/map*/,8/*vs/base/common/strings*/]), function (require, exports, map_1, strings) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    // Combined filters
    /**
     * @returns A filter which combines the provided set
     * of filters with an or. The *first* filters that
     * matches defined the return value of the returned
     * filter.
     */
    function or() {
        var filter = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            filter[_i] = arguments[_i];
        }
        return function (word, wordToMatchAgainst) {
            for (var i = 0, len = filter.length; i < len; i++) {
                var match = filter[i](word, wordToMatchAgainst);
                if (match) {
                    return match;
                }
            }
            return null;
        };
    }
    exports.or = or;
    exports.matchesPrefix = _matchesPrefix.bind(undefined, true);
    function _matchesPrefix(ignoreCase, word, wordToMatchAgainst) {
        if (!wordToMatchAgainst || wordToMatchAgainst.length < word.length) {
            return null;
        }
        var matches;
        if (ignoreCase) {
            matches = strings.startsWithIgnoreCase(wordToMatchAgainst, word);
        }
        else {
            matches = wordToMatchAgainst.indexOf(word) === 0;
        }
        if (!matches) {
            return null;
        }
        return word.length > 0 ? [{ start: 0, end: word.length }] : [];
    }
    // Contiguous Substring
    function matchesContiguousSubString(word, wordToMatchAgainst) {
        var index = wordToMatchAgainst.toLowerCase().indexOf(word.toLowerCase());
        if (index === -1) {
            return null;
        }
        return [{ start: index, end: index + word.length }];
    }
    exports.matchesContiguousSubString = matchesContiguousSubString;
    // Substring
    function matchesSubString(word, wordToMatchAgainst) {
        return _matchesSubString(word.toLowerCase(), wordToMatchAgainst.toLowerCase(), 0, 0);
    }
    exports.matchesSubString = matchesSubString;
    function _matchesSubString(word, wordToMatchAgainst, i, j) {
        if (i === word.length) {
            return [];
        }
        else if (j === wordToMatchAgainst.length) {
            return null;
        }
        else {
            if (word[i] === wordToMatchAgainst[j]) {
                var result = null;
                if (result = _matchesSubString(word, wordToMatchAgainst, i + 1, j + 1)) {
                    return join({ start: j, end: j + 1 }, result);
                }
                return null;
            }
            return _matchesSubString(word, wordToMatchAgainst, i, j + 1);
        }
    }
    // CamelCase
    function isLower(code) {
        return 97 /* a */ <= code && code <= 122 /* z */;
    }
    function isUpper(code) {
        return 65 /* A */ <= code && code <= 90 /* Z */;
    }
    exports.isUpper = isUpper;
    function isNumber(code) {
        return 48 /* Digit0 */ <= code && code <= 57 /* Digit9 */;
    }
    function isWhitespace(code) {
        return (code === 32 /* Space */
            || code === 9 /* Tab */
            || code === 10 /* LineFeed */
            || code === 13 /* CarriageReturn */);
    }
    function isAlphanumeric(code) {
        return isLower(code) || isUpper(code) || isNumber(code);
    }
    function join(head, tail) {
        if (tail.length === 0) {
            tail = [head];
        }
        else if (head.end === tail[0].start) {
            tail[0].start = head.start;
        }
        else {
            tail.unshift(head);
        }
        return tail;
    }
    function nextAnchor(camelCaseWord, start) {
        for (var i = start; i < camelCaseWord.length; i++) {
            var c = camelCaseWord.charCodeAt(i);
            if (isUpper(c) || isNumber(c) || (i > 0 && !isAlphanumeric(camelCaseWord.charCodeAt(i - 1)))) {
                return i;
            }
        }
        return camelCaseWord.length;
    }
    function _matchesCamelCase(word, camelCaseWord, i, j) {
        if (i === word.length) {
            return [];
        }
        else if (j === camelCaseWord.length) {
            return null;
        }
        else if (word[i] !== camelCaseWord[j].toLowerCase()) {
            return null;
        }
        else {
            var result = null;
            var nextUpperIndex = j + 1;
            result = _matchesCamelCase(word, camelCaseWord, i + 1, j + 1);
            while (!result && (nextUpperIndex = nextAnchor(camelCaseWord, nextUpperIndex)) < camelCaseWord.length) {
                result = _matchesCamelCase(word, camelCaseWord, i + 1, nextUpperIndex);
                nextUpperIndex++;
            }
            return result === null ? null : join({ start: j, end: j + 1 }, result);
        }
    }
    // Heuristic to avoid computing camel case matcher for words that don't
    // look like camelCaseWords.
    function analyzeCamelCaseWord(word) {
        var upper = 0, lower = 0, alpha = 0, numeric = 0, code = 0;
        for (var i = 0; i < word.length; i++) {
            code = word.charCodeAt(i);
            if (isUpper(code)) {
                upper++;
            }
            if (isLower(code)) {
                lower++;
            }
            if (isAlphanumeric(code)) {
                alpha++;
            }
            if (isNumber(code)) {
                numeric++;
            }
        }
        var upperPercent = upper / word.length;
        var lowerPercent = lower / word.length;
        var alphaPercent = alpha / word.length;
        var numericPercent = numeric / word.length;
        return { upperPercent: upperPercent, lowerPercent: lowerPercent, alphaPercent: alphaPercent, numericPercent: numericPercent };
    }
    function isUpperCaseWord(analysis) {
        var upperPercent = analysis.upperPercent, lowerPercent = analysis.lowerPercent;
        return lowerPercent === 0 && upperPercent > 0.6;
    }
    function isCamelCaseWord(analysis) {
        var upperPercent = analysis.upperPercent, lowerPercent = analysis.lowerPercent, alphaPercent = analysis.alphaPercent, numericPercent = analysis.numericPercent;
        return lowerPercent > 0.2 && upperPercent < 0.8 && alphaPercent > 0.6 && numericPercent < 0.2;
    }
    // Heuristic to avoid computing camel case matcher for words that don't
    // look like camel case patterns.
    function isCamelCasePattern(word) {
        var upper = 0, lower = 0, code = 0, whitespace = 0;
        for (var i = 0; i < word.length; i++) {
            code = word.charCodeAt(i);
            if (isUpper(code)) {
                upper++;
            }
            if (isLower(code)) {
                lower++;
            }
            if (isWhitespace(code)) {
                whitespace++;
            }
        }
        if ((upper === 0 || lower === 0) && whitespace === 0) {
            return word.length <= 30;
        }
        else {
            return upper <= 5;
        }
    }
    function matchesCamelCase(word, camelCaseWord) {
        if (!camelCaseWord) {
            return null;
        }
        camelCaseWord = camelCaseWord.trim();
        if (camelCaseWord.length === 0) {
            return null;
        }
        if (!isCamelCasePattern(word)) {
            return null;
        }
        if (camelCaseWord.length > 60) {
            return null;
        }
        var analysis = analyzeCamelCaseWord(camelCaseWord);
        if (!isCamelCaseWord(analysis)) {
            if (!isUpperCaseWord(analysis)) {
                return null;
            }
            camelCaseWord = camelCaseWord.toLowerCase();
        }
        var result = null;
        var i = 0;
        word = word.toLowerCase();
        while (i < camelCaseWord.length && (result = _matchesCamelCase(word, camelCaseWord, 0, i)) === null) {
            i = nextAnchor(camelCaseWord, i + 1);
        }
        return result;
    }
    exports.matchesCamelCase = matchesCamelCase;
    // Fuzzy
    exports.fuzzyContiguousFilter = or(exports.matchesPrefix, matchesCamelCase, matchesContiguousSubString);
    var fuzzySeparateFilter = or(exports.matchesPrefix, matchesCamelCase, matchesSubString);
    var fuzzyRegExpCache = new map_1.LRUCache(10000); // bounded to 10000 elements
    function matchesFuzzy(word, wordToMatchAgainst, enableSeparateSubstringMatching) {
        if (enableSeparateSubstringMatching === void 0) { enableSeparateSubstringMatching = false; }
        if (typeof word !== 'string' || typeof wordToMatchAgainst !== 'string') {
            return null; // return early for invalid input
        }
        // Form RegExp for wildcard matches
        var regexp = fuzzyRegExpCache.get(word);
        if (!regexp) {
            regexp = new RegExp(strings.convertSimple2RegExpPattern(word), 'i');
            fuzzyRegExpCache.set(word, regexp);
        }
        // RegExp Filter
        var match = regexp.exec(wordToMatchAgainst);
        if (match) {
            return [{ start: match.index, end: match.index + match[0].length }];
        }
        // Default Filter
        return enableSeparateSubstringMatching ? fuzzySeparateFilter(word, wordToMatchAgainst) : exports.fuzzyContiguousFilter(word, wordToMatchAgainst);
    }
    exports.matchesFuzzy = matchesFuzzy;
    function anyScore(pattern, word, patternMaxWhitespaceIgnore) {
        pattern = pattern.toLowerCase();
        word = word.toLowerCase();
        var matches = [];
        var idx = 0;
        for (var pos = 0; pos < pattern.length; ++pos) {
            var thisIdx = word.indexOf(pattern.charAt(pos), idx);
            if (thisIdx >= 0) {
                matches.push(thisIdx);
                idx = thisIdx + 1;
            }
        }
        return [matches.length, matches];
    }
    exports.anyScore = anyScore;
    //#region --- fuzzyScore ---
    function createMatches(offsetOrScore) {
        var ret = [];
        if (!offsetOrScore) {
            return ret;
        }
        var offsets;
        if (Array.isArray(offsetOrScore[1])) {
            offsets = offsetOrScore[1];
        }
        else {
            offsets = offsetOrScore;
        }
        var last;
        for (var _i = 0, offsets_1 = offsets; _i < offsets_1.length; _i++) {
            var pos = offsets_1[_i];
            if (last && last.end === pos) {
                last.end += 1;
            }
            else {
                last = { start: pos, end: pos + 1 };
                ret.push(last);
            }
        }
        return ret;
    }
    exports.createMatches = createMatches;
    function initTable() {
        var table = [];
        var row = [0];
        for (var i = 1; i <= 100; i++) {
            row.push(-i);
        }
        for (var i = 0; i <= 100; i++) {
            var thisRow = row.slice(0);
            thisRow[0] = -i;
            table.push(thisRow);
        }
        return table;
    }
    var _table = initTable();
    var _scores = initTable();
    var _arrows = initTable();
    var _debug = false;
    function printTable(table, pattern, patternLen, word, wordLen) {
        function pad(s, n, pad) {
            if (pad === void 0) { pad = ' '; }
            while (s.length < n) {
                s = pad + s;
            }
            return s;
        }
        var ret = " |   |" + word.split('').map(function (c) { return pad(c, 3); }).join('|') + "\n";
        for (var i = 0; i <= patternLen; i++) {
            if (i === 0) {
                ret += ' |';
            }
            else {
                ret += pattern[i - 1] + "|";
            }
            ret += table[i].slice(0, wordLen + 1).map(function (n) { return pad(n.toString(), 3); }).join('|') + '\n';
        }
        return ret;
    }
    function isSeparatorAtPos(value, index) {
        if (index < 0 || index >= value.length) {
            return false;
        }
        var code = value.charCodeAt(index);
        switch (code) {
            case 95 /* Underline */:
            case 45 /* Dash */:
            case 46 /* Period */:
            case 32 /* Space */:
            case 47 /* Slash */:
            case 92 /* Backslash */:
            case 39 /* SingleQuote */:
            case 34 /* DoubleQuote */:
            case 58 /* Colon */:
                return true;
            default:
                return false;
        }
    }
    function isWhitespaceAtPos(value, index) {
        if (index < 0 || index >= value.length) {
            return false;
        }
        var code = value.charCodeAt(index);
        switch (code) {
            case 32 /* Space */:
            case 9 /* Tab */:
                return true;
            default:
                return false;
        }
    }
    function fuzzyScore(pattern, lowPattern, patternPos, word, lowWord, wordPos, firstMatchCanBeWeak) {
        var patternLen = pattern.length > 100 ? 100 : pattern.length;
        var wordLen = word.length > 100 ? 100 : word.length;
        if (patternPos >= patternLen || wordPos >= wordLen || patternLen > wordLen) {
            return undefined;
        }
        // Run a simple check if the characters of pattern occur
        // (in order) at all in word. If that isn't the case we
        // stop because no match will be possible
        var patternStartPos = patternPos;
        var wordStartPos = wordPos;
        while (patternPos < patternLen && wordPos < wordLen) {
            if (lowPattern[patternPos] === lowWord[wordPos]) {
                patternPos += 1;
            }
            wordPos += 1;
        }
        if (patternPos !== patternLen) {
            return undefined;
        }
        patternPos = patternStartPos;
        wordPos = wordStartPos;
        // There will be a mach, fill in tables
        for (patternPos = patternStartPos + 1; patternPos <= patternLen; patternPos++) {
            for (wordPos = 1; wordPos <= wordLen; wordPos++) {
                var score = -1;
                var lowWordChar = lowWord[wordPos - 1];
                if (lowPattern[patternPos - 1] === lowWordChar) {
                    if (wordPos === (patternPos - patternStartPos)) {
                        // common prefix: `foobar <-> foobaz`
                        if (pattern[patternPos - 1] === word[wordPos - 1]) {
                            score = 7;
                        }
                        else {
                            score = 5;
                        }
                    }
                    else if (lowWordChar !== word[wordPos - 1] && (wordPos === 1 || lowWord[wordPos - 2] === word[wordPos - 2])) {
                        // hitting upper-case: `foo <-> forOthers`
                        if (pattern[patternPos - 1] === word[wordPos - 1]) {
                            score = 7;
                        }
                        else {
                            score = 5;
                        }
                    }
                    else if (isSeparatorAtPos(lowWord, wordPos - 2) || isWhitespaceAtPos(lowWord, wordPos - 2)) {
                        // post separator: `foo <-> bar_foo`
                        score = 5;
                    }
                    else {
                        score = 1;
                    }
                }
                _scores[patternPos][wordPos] = score;
                var diag = _table[patternPos - 1][wordPos - 1] + (score > 1 ? 1 : score);
                var top_1 = _table[patternPos - 1][wordPos] + -1;
                var left = _table[patternPos][wordPos - 1] + -1;
                if (left >= top_1) {
                    // left or diag
                    if (left > diag) {
                        _table[patternPos][wordPos] = left;
                        _arrows[patternPos][wordPos] = 4 /* Left */;
                    }
                    else if (left === diag) {
                        _table[patternPos][wordPos] = left;
                        _arrows[patternPos][wordPos] = 4 /* Left */ | 2 /* Diag */;
                    }
                    else {
                        _table[patternPos][wordPos] = diag;
                        _arrows[patternPos][wordPos] = 2 /* Diag */;
                    }
                }
                else {
                    // top or diag
                    if (top_1 > diag) {
                        _table[patternPos][wordPos] = top_1;
                        _arrows[patternPos][wordPos] = 1 /* Top */;
                    }
                    else if (top_1 === diag) {
                        _table[patternPos][wordPos] = top_1;
                        _arrows[patternPos][wordPos] = 1 /* Top */ | 2 /* Diag */;
                    }
                    else {
                        _table[patternPos][wordPos] = diag;
                        _arrows[patternPos][wordPos] = 2 /* Diag */;
                    }
                }
            }
        }
        if (_debug) {
            console.log(printTable(_table, pattern, patternLen, word, wordLen));
            console.log(printTable(_arrows, pattern, patternLen, word, wordLen));
            console.log(printTable(_scores, pattern, patternLen, word, wordLen));
        }
        // _bucket is an array of [PrefixArray] we use to keep
        // track of scores and matches. After calling `_findAllMatches`
        // the best match (if available) is the first item in the array
        _matchesCount = 0;
        _topScore = -100;
        _patternStartPos = patternStartPos;
        _firstMatchCanBeWeak = firstMatchCanBeWeak;
        _findAllMatches(patternLen, wordLen, patternLen === wordLen ? 1 : 0, new LazyArray(), false);
        if (_matchesCount === 0) {
            return undefined;
        }
        return [_topScore, _topMatch.toArray()];
    }
    exports.fuzzyScore = fuzzyScore;
    var _matchesCount = 0;
    var _topMatch;
    var _topScore = 0;
    var _patternStartPos = 0;
    var _firstMatchCanBeWeak = false;
    function _findAllMatches(patternPos, wordPos, total, matches, lastMatched) {
        if (_matchesCount >= 10 || total < -25) {
            // stop when having already 10 results, or
            // when a potential alignment as already 5 gaps
            return;
        }
        var simpleMatchCount = 0;
        while (patternPos > _patternStartPos && wordPos > 0) {
            var score = _scores[patternPos][wordPos];
            var arrow = _arrows[patternPos][wordPos];
            if (arrow === 4 /* Left */) {
                // left
                wordPos -= 1;
                if (lastMatched) {
                    total -= 5; // new gap penalty
                }
                else if (!matches.isEmpty()) {
                    total -= 1; // gap penalty after first match
                }
                lastMatched = false;
                simpleMatchCount = 0;
            }
            else if (arrow & 2 /* Diag */) {
                if (arrow & 4 /* Left */) {
                    // left
                    _findAllMatches(patternPos, wordPos - 1, !matches.isEmpty() ? total - 1 : total, // gap penalty after first match
                    matches.slice(), lastMatched);
                }
                // diag
                total += score;
                patternPos -= 1;
                wordPos -= 1;
                matches.unshift(wordPos);
                lastMatched = true;
                // count simple matches and boost a row of
                // simple matches when they yield in a
                // strong match.
                if (score === 1) {
                    simpleMatchCount += 1;
                    if (patternPos === _patternStartPos && !_firstMatchCanBeWeak) {
                        // when the first match is a weak
                        // match we discard it
                        return undefined;
                    }
                }
                else {
                    // boost
                    total += 1 + (simpleMatchCount * (score - 1));
                    simpleMatchCount = 0;
                }
            }
            else {
                return undefined;
            }
        }
        total -= wordPos >= 3 ? 9 : wordPos * 3; // late start penalty
        // dynamically keep track of the current top score
        // and insert the current best score at head, the rest at tail
        _matchesCount += 1;
        if (total > _topScore) {
            _topScore = total;
            _topMatch = matches;
        }
    }
    var LazyArray = /** @class */ (function () {
        function LazyArray() {
        }
        LazyArray.prototype.isEmpty = function () {
            return !this._data && (!this._parent || this._parent.isEmpty());
        };
        LazyArray.prototype.unshift = function (n) {
            if (!this._data) {
                this._data = [n];
            }
            else {
                this._data.unshift(n);
            }
        };
        LazyArray.prototype.slice = function () {
            var ret = new LazyArray();
            ret._parent = this;
            ret._parentLen = this._data ? this._data.length : 0;
            return ret;
        };
        LazyArray.prototype.toArray = function () {
            if (!this._data) {
                return this._parent.toArray();
            }
            var bucket = [];
            var element = this;
            while (element) {
                if (element._parent && element._parent._data) {
                    bucket.push(element._parent._data.slice(element._parent._data.length - element._parentLen));
                }
                element = element._parent;
            }
            return Array.prototype.concat.apply(this._data, bucket);
        };
        return LazyArray;
    }());
    //#endregion
    //#region --- graceful ---
    function fuzzyScoreGracefulAggressive(pattern, lowPattern, patternPos, word, lowWord, wordPos, firstMatchCanBeWeak) {
        return fuzzyScoreWithPermutations(pattern, lowPattern, patternPos, word, lowWord, wordPos, true, firstMatchCanBeWeak);
    }
    exports.fuzzyScoreGracefulAggressive = fuzzyScoreGracefulAggressive;
    function fuzzyScoreWithPermutations(pattern, lowPattern, patternPos, word, lowWord, wordPos, aggressive, firstMatchCanBeWeak) {
        var top = fuzzyScore(pattern, lowPattern, patternPos, word, lowWord, wordPos, firstMatchCanBeWeak);
        if (top && !aggressive) {
            // when using the original pattern yield a result we`
            // return it unless we are aggressive and try to find
            // a better alignment, e.g. `cno` -> `^co^ns^ole` or `^c^o^nsole`.
            return top;
        }
        if (pattern.length >= 3) {
            // When the pattern is long enough then try a few (max 7)
            // permutations of the pattern to find a better match. The
            // permutations only swap neighbouring characters, e.g
            // `cnoso` becomes `conso`, `cnsoo`, `cnoos`.
            var tries = Math.min(7, pattern.length - 1);
            for (var movingPatternPos = patternPos + 1; movingPatternPos < tries; movingPatternPos++) {
                var newPattern = nextTypoPermutation(pattern, movingPatternPos);
                if (newPattern) {
                    var candidate = fuzzyScore(newPattern, newPattern.toLowerCase(), patternPos, word, lowWord, wordPos, firstMatchCanBeWeak);
                    if (candidate) {
                        candidate[0] -= 3; // permutation penalty
                        if (!top || candidate[0] > top[0]) {
                            top = candidate;
                        }
                    }
                }
            }
        }
        return top;
    }
    function nextTypoPermutation(pattern, patternPos) {
        if (patternPos + 1 >= pattern.length) {
            return undefined;
        }
        var swap1 = pattern[patternPos];
        var swap2 = pattern[patternPos + 1];
        if (swap1 === swap2) {
            return undefined;
        }
        return pattern.slice(0, patternPos)
            + swap2
            + swap1
            + pattern.slice(patternPos + 2);
    }
});
//#endregion

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[58/*vs/base/common/paths*/], __M([0/*require*/,1/*exports*/,17/*vs/base/common/platform*/,8/*vs/base/common/strings*/]), function (require, exports, platform_1, strings_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * The forward slash path separator.
     */
    exports.sep = '/';
    /**
     * The native path separator depending on the OS.
     */
    exports.nativeSep = platform_1.isWindows ? '\\' : '/';
    /**
     * @param path the path to get the dirname from
     * @param separator the separator to use
     * @returns the directory name of a path.
     *
     */
    function dirname(path, separator) {
        if (separator === void 0) { separator = exports.nativeSep; }
        var idx = ~path.lastIndexOf('/') || ~path.lastIndexOf('\\');
        if (idx === 0) {
            return '.';
        }
        else if (~idx === 0) {
            return path[0];
        }
        else if (~idx === path.length - 1) {
            return dirname(path.substring(0, path.length - 1));
        }
        else {
            var res = path.substring(0, ~idx);
            if (platform_1.isWindows && res[res.length - 1] === ':') {
                res += separator; // make sure drive letters end with backslash
            }
            return res;
        }
    }
    exports.dirname = dirname;
    /**
     * @returns the base name of a path.
     */
    function basename(path) {
        var idx = ~path.lastIndexOf('/') || ~path.lastIndexOf('\\');
        if (idx === 0) {
            return path;
        }
        else if (~idx === path.length - 1) {
            return basename(path.substring(0, path.length - 1));
        }
        else {
            return path.substr(~idx + 1);
        }
    }
    exports.basename = basename;
    /**
     * @returns `.far` from `boo.far` or the empty string.
     */
    function extname(path) {
        path = basename(path);
        var idx = ~path.lastIndexOf('.');
        return idx ? path.substring(~idx) : '';
    }
    exports.extname = extname;
    var _posixBadPath = /(\/\.\.?\/)|(\/\.\.?)$|^(\.\.?\/)|(\/\/+)|(\\)/;
    var _winBadPath = /(\\\.\.?\\)|(\\\.\.?)$|^(\.\.?\\)|(\\\\+)|(\/)/;
    function _isNormal(path, win) {
        return win
            ? !_winBadPath.test(path)
            : !_posixBadPath.test(path);
    }
    function normalize(path, toOSPath) {
        if (path === null || path === void 0) {
            return path;
        }
        var len = path.length;
        if (len === 0) {
            return '.';
        }
        var wantsBackslash = !!(platform_1.isWindows && toOSPath);
        if (_isNormal(path, wantsBackslash)) {
            return path;
        }
        var sep = wantsBackslash ? '\\' : '/';
        var root = getRoot(path, sep);
        // skip the root-portion of the path
        var start = root.length;
        var skip = false;
        var res = '';
        for (var end = root.length; end <= len; end++) {
            // either at the end or at a path-separator character
            if (end === len || path.charCodeAt(end) === 47 /* Slash */ || path.charCodeAt(end) === 92 /* Backslash */) {
                if (streql(path, start, end, '..')) {
                    // skip current and remove parent (if there is already something)
                    var prev_start = res.lastIndexOf(sep);
                    var prev_part = res.slice(prev_start + 1);
                    if ((root || prev_part.length > 0) && prev_part !== '..') {
                        res = prev_start === -1 ? '' : res.slice(0, prev_start);
                        skip = true;
                    }
                }
                else if (streql(path, start, end, '.') && (root || res || end < len - 1)) {
                    // skip current (if there is already something or if there is more to come)
                    skip = true;
                }
                if (!skip) {
                    var part = path.slice(start, end);
                    if (res !== '' && res[res.length - 1] !== sep) {
                        res += sep;
                    }
                    res += part;
                }
                start = end + 1;
                skip = false;
            }
        }
        return root + res;
    }
    exports.normalize = normalize;
    function streql(value, start, end, other) {
        return start + other.length === end && value.indexOf(other, start) === start;
    }
    /**
     * Computes the _root_ this path, like `getRoot('c:\files') === c:\`,
     * `getRoot('files:///files/path') === files:///`,
     * or `getRoot('\\server\shares\path') === \\server\shares\`
     */
    function getRoot(path, sep) {
        if (sep === void 0) { sep = '/'; }
        if (!path) {
            return '';
        }
        var len = path.length;
        var code = path.charCodeAt(0);
        if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
            code = path.charCodeAt(1);
            if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
                // UNC candidate \\localhost\shares\ddd
                //               ^^^^^^^^^^^^^^^^^^^
                code = path.charCodeAt(2);
                if (code !== 47 /* Slash */ && code !== 92 /* Backslash */) {
                    var pos_1 = 3;
                    var start = pos_1;
                    for (; pos_1 < len; pos_1++) {
                        code = path.charCodeAt(pos_1);
                        if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
                            break;
                        }
                    }
                    code = path.charCodeAt(pos_1 + 1);
                    if (start !== pos_1 && code !== 47 /* Slash */ && code !== 92 /* Backslash */) {
                        pos_1 += 1;
                        for (; pos_1 < len; pos_1++) {
                            code = path.charCodeAt(pos_1);
                            if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
                                return path.slice(0, pos_1 + 1) // consume this separator
                                    .replace(/[\\/]/g, sep);
                            }
                        }
                    }
                }
            }
            // /user/far
            // ^
            return sep;
        }
        else if ((code >= 65 /* A */ && code <= 90 /* Z */) || (code >= 97 /* a */ && code <= 122 /* z */)) {
            // check for windows drive letter c:\ or c:
            if (path.charCodeAt(1) === 58 /* Colon */) {
                code = path.charCodeAt(2);
                if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
                    // C:\fff
                    // ^^^
                    return path.slice(0, 2) + sep;
                }
                else {
                    // C:
                    // ^^
                    return path.slice(0, 2);
                }
            }
        }
        // check for URI
        // scheme://authority/path
        // ^^^^^^^^^^^^^^^^^^^
        var pos = path.indexOf('://');
        if (pos !== -1) {
            pos += 3; // 3 -> "://".length
            for (; pos < len; pos++) {
                code = path.charCodeAt(pos);
                if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
                    return path.slice(0, pos + 1); // consume this separator
                }
            }
        }
        return '';
    }
    exports.getRoot = getRoot;
    exports.join = function () {
        // Not using a function with var-args because of how TS compiles
        // them to JS - it would result in 2*n runtime cost instead
        // of 1*n, where n is parts.length.
        var value = '';
        for (var i = 0; i < arguments.length; i++) {
            var part = arguments[i];
            if (i > 0) {
                // add the separater between two parts unless
                // there already is one
                var last = value.charCodeAt(value.length - 1);
                if (last !== 47 /* Slash */ && last !== 92 /* Backslash */) {
                    var next = part.charCodeAt(0);
                    if (next !== 47 /* Slash */ && next !== 92 /* Backslash */) {
                        value += exports.sep;
                    }
                }
            }
            value += part;
        }
        return normalize(value);
    };
    function isEqualOrParent(path, candidate, ignoreCase, separator) {
        if (separator === void 0) { separator = exports.nativeSep; }
        if (path === candidate) {
            return true;
        }
        if (!path || !candidate) {
            return false;
        }
        if (candidate.length > path.length) {
            return false;
        }
        if (ignoreCase) {
            var beginsWith = strings_1.startsWithIgnoreCase(path, candidate);
            if (!beginsWith) {
                return false;
            }
            if (candidate.length === path.length) {
                return true; // same path, different casing
            }
            var sepOffset = candidate.length;
            if (candidate.charAt(candidate.length - 1) === separator) {
                sepOffset--; // adjust the expected sep offset in case our candidate already ends in separator character
            }
            return path.charAt(sepOffset) === separator;
        }
        if (candidate.charAt(candidate.length - 1) !== separator) {
            candidate += separator;
        }
        return path.indexOf(candidate) === 0;
    }
    exports.isEqualOrParent = isEqualOrParent;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[32/*vs/base/common/types*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var _typeof = {
        number: 'number',
        string: 'string',
        undefined: 'undefined',
        object: 'object',
        function: 'function'
    };
    /**
     * @returns whether the provided parameter is a JavaScript Array or not.
     */
    function isArray(array) {
        if (Array.isArray) {
            return Array.isArray(array);
        }
        if (array && typeof (array.length) === _typeof.number && array.constructor === Array) {
            return true;
        }
        return false;
    }
    exports.isArray = isArray;
    /**
     * @returns whether the provided parameter is a JavaScript String or not.
     */
    function isString(str) {
        if (typeof (str) === _typeof.string || str instanceof String) {
            return true;
        }
        return false;
    }
    exports.isString = isString;
    /**
     *
     * @returns whether the provided parameter is of type `object` but **not**
     *	`null`, an `array`, a `regexp`, nor a `date`.
     */
    function isObject(obj) {
        // The method can't do a type cast since there are type (like strings) which
        // are subclasses of any put not positvely matched by the function. Hence type
        // narrowing results in wrong results.
        return typeof obj === _typeof.object
            && obj !== null
            && !Array.isArray(obj)
            && !(obj instanceof RegExp)
            && !(obj instanceof Date);
    }
    exports.isObject = isObject;
    /**
     * In **contrast** to just checking `typeof` this will return `false` for `NaN`.
     * @returns whether the provided parameter is a JavaScript Number or not.
     */
    function isNumber(obj) {
        if ((typeof (obj) === _typeof.number || obj instanceof Number) && !isNaN(obj)) {
            return true;
        }
        return false;
    }
    exports.isNumber = isNumber;
    /**
     * @returns whether the provided parameter is a JavaScript Boolean or not.
     */
    function isBoolean(obj) {
        return obj === true || obj === false;
    }
    exports.isBoolean = isBoolean;
    /**
     * @returns whether the provided parameter is undefined.
     */
    function isUndefined(obj) {
        return typeof (obj) === _typeof.undefined;
    }
    exports.isUndefined = isUndefined;
    /**
     * @returns whether the provided parameter is undefined or null.
     */
    function isUndefinedOrNull(obj) {
        return isUndefined(obj) || obj === null;
    }
    exports.isUndefinedOrNull = isUndefinedOrNull;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    /**
     * @returns whether the provided parameter is an empty JavaScript Object or not.
     */
    function isEmptyObject(obj) {
        if (!isObject(obj)) {
            return false;
        }
        for (var key in obj) {
            if (hasOwnProperty.call(obj, key)) {
                return false;
            }
        }
        return true;
    }
    exports.isEmptyObject = isEmptyObject;
    /**
     * @returns whether the provided parameter is a JavaScript Function or not.
     */
    function isFunction(obj) {
        return typeof obj === _typeof.function;
    }
    exports.isFunction = isFunction;
    function validateConstraints(args, constraints) {
        var len = Math.min(args.length, constraints.length);
        for (var i = 0; i < len; i++) {
            validateConstraint(args[i], constraints[i]);
        }
    }
    exports.validateConstraints = validateConstraints;
    function validateConstraint(arg, constraint) {
        if (isString(constraint)) {
            if (typeof arg !== constraint) {
                throw new Error("argument does not match constraint: typeof " + constraint);
            }
        }
        else if (isFunction(constraint)) {
            if (arg instanceof constraint) {
                return;
            }
            if (!isUndefinedOrNull(arg) && arg.constructor === constraint) {
                return;
            }
            if (constraint.length === 1 && constraint.call(undefined, arg) === true) {
                return;
            }
            throw new Error("argument does not match one of these constraints: arg instanceof constraint, arg.constructor === constraint, nor constraint(arg) === true");
        }
    }
    exports.validateConstraint = validateConstraint;
    /**
     * Creates a new object of the provided class and will call the constructor with
     * any additional argument supplied.
     */
    function create(ctor) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var obj = Object.create(ctor.prototype);
        ctor.apply(obj, args);
        return obj;
    }
    exports.create = create;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[27/*vs/base/common/objects*/], __M([0/*require*/,1/*exports*/,32/*vs/base/common/types*/]), function (require, exports, types_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function deepClone(obj) {
        if (!obj || typeof obj !== 'object') {
            return obj;
        }
        if (obj instanceof RegExp) {
            // See https://github.com/Microsoft/TypeScript/issues/10990
            return obj;
        }
        var result = Array.isArray(obj) ? [] : {};
        Object.keys(obj).forEach(function (key) {
            if (obj[key] && typeof obj[key] === 'object') {
                result[key] = deepClone(obj[key]);
            }
            else {
                result[key] = obj[key];
            }
        });
        return result;
    }
    exports.deepClone = deepClone;
    function deepFreeze(obj) {
        if (!obj || typeof obj !== 'object') {
            return obj;
        }
        var stack = [obj];
        while (stack.length > 0) {
            var obj_1 = stack.shift();
            Object.freeze(obj_1);
            for (var key in obj_1) {
                if (_hasOwnProperty.call(obj_1, key)) {
                    var prop = obj_1[key];
                    if (typeof prop === 'object' && !Object.isFrozen(prop)) {
                        stack.push(prop);
                    }
                }
            }
        }
        return obj;
    }
    exports.deepFreeze = deepFreeze;
    var _hasOwnProperty = Object.prototype.hasOwnProperty;
    /**
     * Copies all properties of source into destination. The optional parameter "overwrite" allows to control
     * if existing properties on the destination should be overwritten or not. Defaults to true (overwrite).
     */
    function mixin(destination, source, overwrite) {
        if (overwrite === void 0) { overwrite = true; }
        if (!types_1.isObject(destination)) {
            return source;
        }
        if (types_1.isObject(source)) {
            Object.keys(source).forEach(function (key) {
                if (key in destination) {
                    if (overwrite) {
                        if (types_1.isObject(destination[key]) && types_1.isObject(source[key])) {
                            mixin(destination[key], source[key], overwrite);
                        }
                        else {
                            destination[key] = source[key];
                        }
                    }
                }
                else {
                    destination[key] = source[key];
                }
            });
        }
        return destination;
    }
    exports.mixin = mixin;
    function assign(destination) {
        var sources = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            sources[_i - 1] = arguments[_i];
        }
        sources.forEach(function (source) { return Object.keys(source).forEach(function (key) { return destination[key] = source[key]; }); });
        return destination;
    }
    exports.assign = assign;
    function equals(one, other) {
        if (one === other) {
            return true;
        }
        if (one === null || one === undefined || other === null || other === undefined) {
            return false;
        }
        if (typeof one !== typeof other) {
            return false;
        }
        if (typeof one !== 'object') {
            return false;
        }
        if ((Array.isArray(one)) !== (Array.isArray(other))) {
            return false;
        }
        var i;
        var key;
        if (Array.isArray(one)) {
            if (one.length !== other.length) {
                return false;
            }
            for (i = 0; i < one.length; i++) {
                if (!equals(one[i], other[i])) {
                    return false;
                }
            }
        }
        else {
            var oneKeys = [];
            for (key in one) {
                oneKeys.push(key);
            }
            oneKeys.sort();
            var otherKeys = [];
            for (key in other) {
                otherKeys.push(key);
            }
            otherKeys.sort();
            if (!equals(oneKeys, otherKeys)) {
                return false;
            }
            for (i = 0; i < oneKeys.length; i++) {
                if (!equals(one[oneKeys[i]], other[oneKeys[i]])) {
                    return false;
                }
            }
        }
        return true;
    }
    exports.equals = equals;
    function arrayToHash(array) {
        var result = {};
        for (var i = 0; i < array.length; ++i) {
            result[array[i]] = true;
        }
        return result;
    }
    exports.arrayToHash = arrayToHash;
    /**
     * Given an array of strings, returns a function which, given a string
     * returns true or false whether the string is in that array.
     */
    function createKeywordMatcher(arr, caseInsensitive) {
        if (caseInsensitive === void 0) { caseInsensitive = false; }
        if (caseInsensitive) {
            arr = arr.map(function (x) { return x.toLowerCase(); });
        }
        var hash = arrayToHash(arr);
        if (caseInsensitive) {
            return function (word) {
                return hash[word.toLowerCase()] !== undefined && hash.hasOwnProperty(word.toLowerCase());
            };
        }
        else {
            return function (word) {
                return hash[word] !== undefined && hash.hasOwnProperty(word);
            };
        }
    }
    exports.createKeywordMatcher = createKeywordMatcher;
    function getOrDefault(obj, fn, defaultValue) {
        if (defaultValue === void 0) { defaultValue = null; }
        var result = fn(obj);
        return typeof result === 'undefined' ? defaultValue : result;
    }
    exports.getOrDefault = getOrDefault;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[25/*vs/base/common/uri*/], __M([0/*require*/,1/*exports*/,17/*vs/base/common/platform*/]), function (require, exports, platform_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var _a;
    var _schemePattern = /^\w[\w\d+.-]*$/;
    var _singleSlashStart = /^\//;
    var _doubleSlashStart = /^\/\//;
    var _throwOnMissingSchema = true;
    function _validateUri(ret) {
        // scheme, must be set
        if (!ret.scheme) {
            if (_throwOnMissingSchema) {
                throw new Error("[UriError]: Scheme is missing: {scheme: \"\", authority: \"" + ret.authority + "\", path: \"" + ret.path + "\", query: \"" + ret.query + "\", fragment: \"" + ret.fragment + "\"}");
            }
            else {
                console.warn("[UriError]: Scheme is missing: {scheme: \"\", authority: \"" + ret.authority + "\", path: \"" + ret.path + "\", query: \"" + ret.query + "\", fragment: \"" + ret.fragment + "\"}");
            }
        }
        // scheme, https://tools.ietf.org/html/rfc3986#section-3.1
        // ALPHA *( ALPHA / DIGIT / "+" / "-" / "." )
        if (ret.scheme && !_schemePattern.test(ret.scheme)) {
            throw new Error('[UriError]: Scheme contains illegal characters.');
        }
        // path, http://tools.ietf.org/html/rfc3986#section-3.3
        // If a URI contains an authority component, then the path component
        // must either be empty or begin with a slash ("/") character.  If a URI
        // does not contain an authority component, then the path cannot begin
        // with two slash characters ("//").
        if (ret.path) {
            if (ret.authority) {
                if (!_singleSlashStart.test(ret.path)) {
                    throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
                }
            }
            else {
                if (_doubleSlashStart.test(ret.path)) {
                    throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
                }
            }
        }
    }
    // implements a bit of https://tools.ietf.org/html/rfc3986#section-5
    function _referenceResolution(scheme, path) {
        // the slash-character is our 'default base' as we don't
        // support constructing URIs relative to other URIs. This
        // also means that we alter and potentially break paths.
        // see https://tools.ietf.org/html/rfc3986#section-5.1.4
        switch (scheme) {
            case 'https':
            case 'http':
            case 'file':
                if (!path) {
                    path = _slash;
                }
                else if (path[0] !== _slash) {
                    path = _slash + path;
                }
                break;
        }
        return path;
    }
    var _empty = '';
    var _slash = '/';
    var _regexp = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
    /**
     * Uniform Resource Identifier (URI) http://tools.ietf.org/html/rfc3986.
     * This class is a simple parser which creates the basic component parts
     * (http://tools.ietf.org/html/rfc3986#section-3) with minimal validation
     * and encoding.
     *
     *       foo://example.com:8042/over/there?name=ferret#nose
     *       \_/   \______________/\_________/ \_________/ \__/
     *        |           |            |            |        |
     *     scheme     authority       path        query   fragment
     *        |   _____________________|__
     *       / \ /                        \
     *       urn:example:animal:ferret:nose
     */
    var URI = /** @class */ (function () {
        /**
         * @internal
         */
        function URI(schemeOrData, authority, path, query, fragment) {
            if (typeof schemeOrData === 'object') {
                this.scheme = schemeOrData.scheme || _empty;
                this.authority = schemeOrData.authority || _empty;
                this.path = schemeOrData.path || _empty;
                this.query = schemeOrData.query || _empty;
                this.fragment = schemeOrData.fragment || _empty;
                // no validation because it's this URI
                // that creates uri components.
                // _validateUri(this);
            }
            else {
                this.scheme = schemeOrData || _empty;
                this.authority = authority || _empty;
                this.path = _referenceResolution(this.scheme, path || _empty);
                this.query = query || _empty;
                this.fragment = fragment || _empty;
                _validateUri(this);
            }
        }
        URI.isUri = function (thing) {
            if (thing instanceof URI) {
                return true;
            }
            if (!thing) {
                return false;
            }
            return typeof thing.authority === 'string'
                && typeof thing.fragment === 'string'
                && typeof thing.path === 'string'
                && typeof thing.query === 'string'
                && typeof thing.scheme === 'string';
        };
        Object.defineProperty(URI.prototype, "fsPath", {
            // ---- filesystem path -----------------------
            /**
             * Returns a string representing the corresponding file system path of this URI.
             * Will handle UNC paths, normalizes windows drive letters to lower-case, and uses the
             * platform specific path separator.
             *
             * * Will *not* validate the path for invalid characters and semantics.
             * * Will *not* look at the scheme of this URI.
             * * The result shall *not* be used for display purposes but for accessing a file on disk.
             *
             *
             * The *difference* to `URI#path` is the use of the platform specific separator and the handling
             * of UNC paths. See the below sample of a file-uri with an authority (UNC path).
             *
             * ```ts
                const u = URI.parse('file://server/c$/folder/file.txt')
                u.authority === 'server'
                u.path === '/shares/c$/file.txt'
                u.fsPath === '\\server\c$\folder\file.txt'
            ```
             *
             * Using `URI#path` to read a file (using fs-apis) would not be enough because parts of the path,
             * namely the server name, would be missing. Therefore `URI#fsPath` exists - it's sugar to ease working
             * with URIs that represent files on disk (`file` scheme).
             */
            get: function () {
                // if (this.scheme !== 'file') {
                // 	console.warn(`[UriError] calling fsPath with scheme ${this.scheme}`);
                // }
                return _makeFsPath(this);
            },
            enumerable: true,
            configurable: true
        });
        // ---- modify to new -------------------------
        URI.prototype.with = function (change) {
            if (!change) {
                return this;
            }
            var scheme = change.scheme, authority = change.authority, path = change.path, query = change.query, fragment = change.fragment;
            if (scheme === void 0) {
                scheme = this.scheme;
            }
            else if (scheme === null) {
                scheme = _empty;
            }
            if (authority === void 0) {
                authority = this.authority;
            }
            else if (authority === null) {
                authority = _empty;
            }
            if (path === void 0) {
                path = this.path;
            }
            else if (path === null) {
                path = _empty;
            }
            if (query === void 0) {
                query = this.query;
            }
            else if (query === null) {
                query = _empty;
            }
            if (fragment === void 0) {
                fragment = this.fragment;
            }
            else if (fragment === null) {
                fragment = _empty;
            }
            if (scheme === this.scheme
                && authority === this.authority
                && path === this.path
                && query === this.query
                && fragment === this.fragment) {
                return this;
            }
            return new _URI(scheme, authority, path, query, fragment);
        };
        // ---- parse & validate ------------------------
        /**
         * Creates a new URI from a string, e.g. `http://www.msft.com/some/path`,
         * `file:///usr/home`, or `scheme:with/path`.
         *
         * @param value A string which represents an URI (see `URI#toString`).
         */
        URI.parse = function (value) {
            var match = _regexp.exec(value);
            if (!match) {
                return new _URI(_empty, _empty, _empty, _empty, _empty);
            }
            return new _URI(match[2] || _empty, decodeURIComponent(match[4] || _empty), decodeURIComponent(match[5] || _empty), decodeURIComponent(match[7] || _empty), decodeURIComponent(match[9] || _empty));
        };
        /**
         * Creates a new URI from a file system path, e.g. `c:\my\files`,
         * `/usr/home`, or `\\server\share\some\path`.
         *
         * The *difference* between `URI#parse` and `URI#file` is that the latter treats the argument
         * as path, not as stringified-uri. E.g. `URI.file(path)` is **not the same as**
         * `URI.parse('file://' + path)` because the path might contain characters that are
         * interpreted (# and ?). See the following sample:
         * ```ts
        const good = URI.file('/coding/c#/project1');
        good.scheme === 'file';
        good.path === '/coding/c#/project1';
        good.fragment === '';
        const bad = URI.parse('file://' + '/coding/c#/project1');
        bad.scheme === 'file';
        bad.path === '/coding/c'; // path is now broken
        bad.fragment === '/project1';
        ```
         *
         * @param path A file system path (see `URI#fsPath`)
         */
        URI.file = function (path) {
            var authority = _empty;
            // normalize to fwd-slashes on windows,
            // on other systems bwd-slashes are valid
            // filename character, eg /f\oo/ba\r.txt
            if (platform_1.isWindows) {
                path = path.replace(/\\/g, _slash);
            }
            // check for authority as used in UNC shares
            // or use the path as given
            if (path[0] === _slash && path[1] === _slash) {
                var idx = path.indexOf(_slash, 2);
                if (idx === -1) {
                    authority = path.substring(2);
                    path = _slash;
                }
                else {
                    authority = path.substring(2, idx);
                    path = path.substring(idx) || _slash;
                }
            }
            return new _URI('file', authority, path, _empty, _empty);
        };
        URI.from = function (components) {
            return new _URI(components.scheme, components.authority, components.path, components.query, components.fragment);
        };
        // ---- printing/externalize ---------------------------
        /**
         * Creates a string presentation for this URI. It's guaranteed that calling
         * `URI.parse` with the result of this function creates an URI which is equal
         * to this URI.
         *
         * * The result shall *not* be used for display purposes but for externalization or transport.
         * * The result will be encoded using the percentage encoding and encoding happens mostly
         * ignore the scheme-specific encoding rules.
         *
         * @param skipEncoding Do not encode the result, default is `false`
         */
        URI.prototype.toString = function (skipEncoding) {
            if (skipEncoding === void 0) { skipEncoding = false; }
            return _asFormatted(this, skipEncoding);
        };
        URI.prototype.toJSON = function () {
            return this;
        };
        URI.revive = function (data) {
            if (!data) {
                return data;
            }
            else if (data instanceof URI) {
                return data;
            }
            else {
                var result = new _URI(data);
                result._fsPath = data.fsPath;
                result._formatted = data.external;
                return result;
            }
        };
        return URI;
    }());
    exports.URI = URI;
    // tslint:disable-next-line:class-name
    var _URI = /** @class */ (function (_super) {
        __extends(_URI, _super);
        function _URI() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._formatted = null;
            _this._fsPath = null;
            return _this;
        }
        Object.defineProperty(_URI.prototype, "fsPath", {
            get: function () {
                if (!this._fsPath) {
                    this._fsPath = _makeFsPath(this);
                }
                return this._fsPath;
            },
            enumerable: true,
            configurable: true
        });
        _URI.prototype.toString = function (skipEncoding) {
            if (skipEncoding === void 0) { skipEncoding = false; }
            if (!skipEncoding) {
                if (!this._formatted) {
                    this._formatted = _asFormatted(this, false);
                }
                return this._formatted;
            }
            else {
                // we don't cache that
                return _asFormatted(this, true);
            }
        };
        _URI.prototype.toJSON = function () {
            var res = {
                $mid: 1
            };
            // cached state
            if (this._fsPath) {
                res.fsPath = this._fsPath;
            }
            if (this._formatted) {
                res.external = this._formatted;
            }
            // uri components
            if (this.path) {
                res.path = this.path;
            }
            if (this.scheme) {
                res.scheme = this.scheme;
            }
            if (this.authority) {
                res.authority = this.authority;
            }
            if (this.query) {
                res.query = this.query;
            }
            if (this.fragment) {
                res.fragment = this.fragment;
            }
            return res;
        };
        return _URI;
    }(URI));
    // reserved characters: https://tools.ietf.org/html/rfc3986#section-2.2
    var encodeTable = (_a = {},
        _a[58 /* Colon */] = '%3A',
        _a[47 /* Slash */] = '%2F',
        _a[63 /* QuestionMark */] = '%3F',
        _a[35 /* Hash */] = '%23',
        _a[91 /* OpenSquareBracket */] = '%5B',
        _a[93 /* CloseSquareBracket */] = '%5D',
        _a[64 /* AtSign */] = '%40',
        _a[33 /* ExclamationMark */] = '%21',
        _a[36 /* DollarSign */] = '%24',
        _a[38 /* Ampersand */] = '%26',
        _a[39 /* SingleQuote */] = '%27',
        _a[40 /* OpenParen */] = '%28',
        _a[41 /* CloseParen */] = '%29',
        _a[42 /* Asterisk */] = '%2A',
        _a[43 /* Plus */] = '%2B',
        _a[44 /* Comma */] = '%2C',
        _a[59 /* Semicolon */] = '%3B',
        _a[61 /* Equals */] = '%3D',
        _a[32 /* Space */] = '%20',
        _a);
    function encodeURIComponentFast(uriComponent, allowSlash) {
        var res = undefined;
        var nativeEncodePos = -1;
        for (var pos = 0; pos < uriComponent.length; pos++) {
            var code = uriComponent.charCodeAt(pos);
            // unreserved characters: https://tools.ietf.org/html/rfc3986#section-2.3
            if ((code >= 97 /* a */ && code <= 122 /* z */)
                || (code >= 65 /* A */ && code <= 90 /* Z */)
                || (code >= 48 /* Digit0 */ && code <= 57 /* Digit9 */)
                || code === 45 /* Dash */
                || code === 46 /* Period */
                || code === 95 /* Underline */
                || code === 126 /* Tilde */
                || (allowSlash && code === 47 /* Slash */)) {
                // check if we are delaying native encode
                if (nativeEncodePos !== -1) {
                    res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
                    nativeEncodePos = -1;
                }
                // check if we write into a new string (by default we try to return the param)
                if (res !== undefined) {
                    res += uriComponent.charAt(pos);
                }
            }
            else {
                // encoding needed, we need to allocate a new string
                if (res === undefined) {
                    res = uriComponent.substr(0, pos);
                }
                // check with default table first
                var escaped = encodeTable[code];
                if (escaped !== undefined) {
                    // check if we are delaying native encode
                    if (nativeEncodePos !== -1) {
                        res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
                        nativeEncodePos = -1;
                    }
                    // append escaped variant to result
                    res += escaped;
                }
                else if (nativeEncodePos === -1) {
                    // use native encode only when needed
                    nativeEncodePos = pos;
                }
            }
        }
        if (nativeEncodePos !== -1) {
            res += encodeURIComponent(uriComponent.substring(nativeEncodePos));
        }
        return res !== undefined ? res : uriComponent;
    }
    function encodeURIComponentMinimal(path) {
        var res = undefined;
        for (var pos = 0; pos < path.length; pos++) {
            var code = path.charCodeAt(pos);
            if (code === 35 /* Hash */ || code === 63 /* QuestionMark */) {
                if (res === undefined) {
                    res = path.substr(0, pos);
                }
                res += encodeTable[code];
            }
            else {
                if (res !== undefined) {
                    res += path[pos];
                }
            }
        }
        return res !== undefined ? res : path;
    }
    /**
     * Compute `fsPath` for the given uri
     * @param uri
     */
    function _makeFsPath(uri) {
        var value;
        if (uri.authority && uri.path.length > 1 && uri.scheme === 'file') {
            // unc path: file://shares/c$/far/boo
            value = "//" + uri.authority + uri.path;
        }
        else if (uri.path.charCodeAt(0) === 47 /* Slash */
            && (uri.path.charCodeAt(1) >= 65 /* A */ && uri.path.charCodeAt(1) <= 90 /* Z */ || uri.path.charCodeAt(1) >= 97 /* a */ && uri.path.charCodeAt(1) <= 122 /* z */)
            && uri.path.charCodeAt(2) === 58 /* Colon */) {
            // windows drive letter: file:///c:/far/boo
            value = uri.path[1].toLowerCase() + uri.path.substr(2);
        }
        else {
            // other path
            value = uri.path;
        }
        if (platform_1.isWindows) {
            value = value.replace(/\//g, '\\');
        }
        return value;
    }
    /**
     * Create the external version of a uri
     */
    function _asFormatted(uri, skipEncoding) {
        var encoder = !skipEncoding
            ? encodeURIComponentFast
            : encodeURIComponentMinimal;
        var res = '';
        var scheme = uri.scheme, authority = uri.authority, path = uri.path, query = uri.query, fragment = uri.fragment;
        if (scheme) {
            res += scheme;
            res += ':';
        }
        if (authority || scheme === 'file') {
            res += _slash;
            res += _slash;
        }
        if (authority) {
            var idx = authority.indexOf('@');
            if (idx !== -1) {
                // <user>@<auth>
                var userinfo = authority.substr(0, idx);
                authority = authority.substr(idx + 1);
                idx = userinfo.indexOf(':');
                if (idx === -1) {
                    res += encoder(userinfo, false);
                }
                else {
                    // <user>:<pass>@<auth>
                    res += encoder(userinfo.substr(0, idx), false);
                    res += ':';
                    res += encoder(userinfo.substr(idx + 1), false);
                }
                res += '@';
            }
            authority = authority.toLowerCase();
            idx = authority.indexOf(':');
            if (idx === -1) {
                res += encoder(authority, false);
            }
            else {
                // <auth>:<port>
                res += encoder(authority.substr(0, idx), false);
                res += authority.substr(idx);
            }
        }
        if (path) {
            // lower-case windows drive letters in /C:/fff or C:/fff
            if (path.length >= 3 && path.charCodeAt(0) === 47 /* Slash */ && path.charCodeAt(2) === 58 /* Colon */) {
                var code = path.charCodeAt(1);
                if (code >= 65 /* A */ && code <= 90 /* Z */) {
                    path = "/" + String.fromCharCode(code + 32) + ":" + path.substr(3); // "/c:".length === 3
                }
            }
            else if (path.length >= 2 && path.charCodeAt(1) === 58 /* Colon */) {
                var code = path.charCodeAt(0);
                if (code >= 65 /* A */ && code <= 90 /* Z */) {
                    path = String.fromCharCode(code + 32) + ":" + path.substr(2); // "/c:".length === 3
                }
            }
            // encode the rest of the path
            res += encoder(path, true);
        }
        if (query) {
            res += '?';
            res += encoder(query, false);
        }
        if (fragment) {
            res += '#';
            res += !skipEncoding ? encodeURIComponentFast(fragment, false) : fragment;
        }
        return res;
    }
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[430/*vs/base/common/marshalling*/], __M([0/*require*/,1/*exports*/,25/*vs/base/common/uri*/]), function (require, exports, uri_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function parse(text) {
        var data = JSON.parse(text);
        data = revive(data, 0);
        return data;
    }
    exports.parse = parse;
    function revive(obj, depth) {
        if (!obj || depth > 200) {
            return obj;
        }
        if (typeof obj === 'object') {
            switch (obj.$mid) {
                case 1: return uri_1.URI.revive(obj);
                case 2: return new RegExp(obj.source, obj.flags);
            }
            // walk object (or array)
            for (var key in obj) {
                if (Object.hasOwnProperty.call(obj, key)) {
                    obj[key] = revive(obj[key], depth + 1);
                }
            }
        }
        return obj;
    }
    exports.revive = revive;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[84/*vs/base/common/resources*/], __M([0/*require*/,1/*exports*/,58/*vs/base/common/paths*/,25/*vs/base/common/uri*/,8/*vs/base/common/strings*/,50/*vs/base/common/network*/,17/*vs/base/common/platform*/]), function (require, exports, paths, uri_1, strings_1, network_1, platform_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function hasToIgnoreCase(resource) {
        // A file scheme resource is in the same platform as code, so ignore case for non linux platforms
        // Resource can be from another platform. Lowering the case as an hack. Should come from File system provider
        return resource && resource.scheme === network_1.Schemas.file ? !platform_1.isLinux : true;
    }
    exports.hasToIgnoreCase = hasToIgnoreCase;
    function basenameOrAuthority(resource) {
        return basename(resource) || resource.authority;
    }
    exports.basenameOrAuthority = basenameOrAuthority;
    function isEqual(first, second, ignoreCase) {
        if (ignoreCase === void 0) { ignoreCase = hasToIgnoreCase(first); }
        var identityEquals = (first === second);
        if (identityEquals) {
            return true;
        }
        if (!first || !second) {
            return false;
        }
        if (ignoreCase) {
            return strings_1.equalsIgnoreCase(first.toString(), second.toString());
        }
        return first.toString() === second.toString();
    }
    exports.isEqual = isEqual;
    function basename(resource) {
        return paths.basename(resource.path);
    }
    exports.basename = basename;
    /**
     * Return a URI representing the directory of a URI path.
     *
     * @param resource The input URI.
     * @returns The URI representing the directory of the input URI.
     */
    function dirname(resource) {
        if (resource.scheme === network_1.Schemas.file) {
            return uri_1.URI.file(paths.dirname(fsPath(resource)));
        }
        var dirname = paths.dirname(resource.path, '/');
        if (resource.authority && dirname.length && dirname.charCodeAt(0) !== 47 /* Slash */) {
            return null; // If a URI contains an authority component, then the path component must either be empty or begin with a CharCode.Slash ("/") character
        }
        return resource.with({
            path: dirname
        });
    }
    exports.dirname = dirname;
    /**
     * Join a URI path with a path fragment and normalizes the resulting path.
     *
     * @param resource The input URI.
     * @param pathFragment The path fragment to add to the URI path.
     * @returns The resulting URI.
     */
    function joinPath(resource, pathFragment) {
        var joinedPath;
        if (resource.scheme === network_1.Schemas.file) {
            joinedPath = uri_1.URI.file(paths.join(fsPath(resource), pathFragment)).path;
        }
        else {
            joinedPath = paths.join(resource.path, pathFragment);
        }
        return resource.with({
            path: joinedPath
        });
    }
    exports.joinPath = joinPath;
    /**
     * Normalizes the path part of a URI: Resolves `.` and `..` elements with directory names.
     *
     * @param resource The URI to normalize the path.
     * @returns The URI with the normalized path.
     */
    function normalizePath(resource) {
        var normalizedPath;
        if (resource.scheme === network_1.Schemas.file) {
            normalizedPath = uri_1.URI.file(paths.normalize(fsPath(resource))).path;
        }
        else {
            normalizedPath = paths.normalize(resource.path);
        }
        return resource.with({
            path: normalizedPath
        });
    }
    exports.normalizePath = normalizePath;
    /**
     * Returns the fsPath of an URI where the drive letter is not normalized.
     * See #56403.
     */
    function fsPath(uri) {
        var value;
        if (uri.authority && uri.path.length > 1 && uri.scheme === 'file') {
            // unc path: file://shares/c$/far/boo
            value = "//" + uri.authority + uri.path;
        }
        else if (platform_1.isWindows
            && uri.path.charCodeAt(0) === 47 /* Slash */
            && (uri.path.charCodeAt(1) >= 65 /* A */ && uri.path.charCodeAt(1) <= 90 /* Z */ || uri.path.charCodeAt(1) >= 97 /* a */ && uri.path.charCodeAt(1) <= 122 /* z */)
            && uri.path.charCodeAt(2) === 58 /* Colon */) {
            value = uri.path.substr(1);
        }
        else {
            // other path
            value = uri.path;
        }
        if (platform_1.isWindows) {
            value = value.replace(/\//g, '\\');
        }
        return value;
    }
    exports.fsPath = fsPath;
    /**
     * Data URI related helpers.
     */
    var DataUri;
    (function (DataUri) {
        DataUri.META_DATA_LABEL = 'label';
        DataUri.META_DATA_DESCRIPTION = 'description';
        DataUri.META_DATA_SIZE = 'size';
        DataUri.META_DATA_MIME = 'mime';
        function parseMetaData(dataUri) {
            var metadata = new Map();
            // Given a URI of:  data:image/png;size:2313;label:SomeLabel;description:SomeDescription;base64,77+9UE5...
            // the metadata is: size:2313;label:SomeLabel;description:SomeDescription
            var meta = dataUri.path.substring(dataUri.path.indexOf(';') + 1, dataUri.path.lastIndexOf(';'));
            meta.split(';').forEach(function (property) {
                var _a = property.split(':'), key = _a[0], value = _a[1];
                if (key && value) {
                    metadata.set(key, value);
                }
            });
            // Given a URI of:  data:image/png;size:2313;label:SomeLabel;description:SomeDescription;base64,77+9UE5...
            // the mime is: image/png
            var mime = dataUri.path.substring(0, dataUri.path.indexOf(';'));
            if (mime) {
                metadata.set(DataUri.META_DATA_MIME, mime);
            }
            return metadata;
        }
        DataUri.parseMetaData = parseMetaData;
    })(DataUri = exports.DataUri || (exports.DataUri = {}));
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[158/*vs/base/common/labels*/], __M([0/*require*/,1/*exports*/,25/*vs/base/common/uri*/,58/*vs/base/common/paths*/,8/*vs/base/common/strings*/,50/*vs/base/common/network*/,17/*vs/base/common/platform*/,84/*vs/base/common/resources*/]), function (require, exports, uri_1, paths_1, strings_1, network_1, platform_1, resources_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * @deprecated use LabelService instead
     */
    function getPathLabel(resource, userHomeProvider, rootProvider) {
        if (typeof resource === 'string') {
            resource = uri_1.URI.file(resource);
        }
        // return early if we can resolve a relative path label from the root
        if (rootProvider) {
            var baseResource = rootProvider.getWorkspaceFolder(resource);
            if (baseResource) {
                var hasMultipleRoots = rootProvider.getWorkspace().folders.length > 1;
                var pathLabel = void 0;
                if (resources_1.isEqual(baseResource.uri, resource, !platform_1.isLinux)) {
                    pathLabel = ''; // no label if paths are identical
                }
                else {
                    pathLabel = paths_1.normalize(strings_1.ltrim(resource.path.substr(baseResource.uri.path.length), paths_1.sep), true);
                }
                if (hasMultipleRoots) {
                    var rootName = (baseResource && baseResource.name) ? baseResource.name : paths_1.basename(baseResource.uri.fsPath);
                    pathLabel = pathLabel ? (rootName + ' • ' + pathLabel) : rootName; // always show root basename if there are multiple
                }
                return pathLabel;
            }
        }
        // return if the resource is neither file:// nor untitled:// and no baseResource was provided
        if (resource.scheme !== network_1.Schemas.file && resource.scheme !== network_1.Schemas.untitled) {
            return resource.with({ query: null, fragment: null }).toString(true);
        }
        // convert c:\something => C:\something
        if (hasDriveLetter(resource.fsPath)) {
            return paths_1.normalize(normalizeDriveLetter(resource.fsPath), true);
        }
        // normalize and tildify (macOS, Linux only)
        var res = paths_1.normalize(resource.fsPath, true);
        if (!platform_1.isWindows && userHomeProvider) {
            res = tildify(res, userHomeProvider.userHome);
        }
        return res;
    }
    exports.getPathLabel = getPathLabel;
    function getBaseLabel(resource) {
        if (!resource) {
            return undefined;
        }
        if (typeof resource === 'string') {
            resource = uri_1.URI.file(resource);
        }
        var base = paths_1.basename(resource.path) || (resource.scheme === network_1.Schemas.file ? resource.fsPath : resource.path) /* can be empty string if '/' is passed in */;
        // convert c: => C:
        if (hasDriveLetter(base)) {
            return normalizeDriveLetter(base);
        }
        return base;
    }
    exports.getBaseLabel = getBaseLabel;
    function hasDriveLetter(path) {
        return !!(platform_1.isWindows && path && path[1] === ':');
    }
    function normalizeDriveLetter(path) {
        if (hasDriveLetter(path)) {
            return path.charAt(0).toUpperCase() + path.slice(1);
        }
        return path;
    }
    exports.normalizeDriveLetter = normalizeDriveLetter;
    var normalizedUserHomeCached = Object.create(null);
    function tildify(path, userHome) {
        if (platform_1.isWindows || !path || !userHome) {
            return path; // unsupported
        }
        // Keep a normalized user home path as cache to prevent accumulated string creation
        var normalizedUserHome = normalizedUserHomeCached.original === userHome ? normalizedUserHomeCached.normalized : void 0;
        if (!normalizedUserHome) {
            normalizedUserHome = "" + strings_1.rtrim(userHome, paths_1.sep) + paths_1.sep;
            normalizedUserHomeCached = { original: userHome, normalized: normalizedUserHome };
        }
        // Linux: case sensitive, macOS: case insensitive
        if (platform_1.isLinux ? strings_1.startsWith(path, normalizedUserHome) : strings_1.startsWithIgnoreCase(path, normalizedUserHome)) {
            path = "~/" + path.substr(normalizedUserHome.length);
        }
        return path;
    }
    exports.tildify = tildify;
});

/**
 * Extracted from https://github.com/winjs/winjs
 * Version: 4.4.0(ec3258a9f3a36805a187848984e3bb938044178d)
 * Copyright (c) Microsoft Corporation.
 * All Rights Reserved.
 * Licensed under the MIT License.
 */
var __winjs_exports;

(function() {

var _modules = Object.create(null);//{};
_modules["WinJS/Core/_WinJS"] = {};

var _winjs = function(moduleId, deps, factory) {
    var exports = {};
    var exportsPassedIn = false;

    var depsValues = deps.map(function(dep) {
        if (dep === 'exports') {
            exportsPassedIn = true;
            return exports;
        }
        return _modules[dep];
    });

    var result = factory.apply({}, depsValues);

    _modules[moduleId] = exportsPassedIn ? exports : result;
};


_winjs("WinJS/Core/_Global", [], function () {
    "use strict";

    // Appease jshint
    /* global window, self, global */

    var globalObject =
        typeof window !== 'undefined' ? window :
        typeof self !== 'undefined' ? self :
        typeof global !== 'undefined' ? global :
        {};
    return globalObject;
});

_winjs("WinJS/Core/_BaseCoreUtils", ["WinJS/Core/_Global"], function baseCoreUtilsInit(_Global) {
    "use strict";

    var hasWinRT = !!_Global.Windows;

    function markSupportedForProcessing(func) {
        /// <signature helpKeyword="WinJS.Utilities.markSupportedForProcessing">
        /// <summary locid="WinJS.Utilities.markSupportedForProcessing">
        /// Marks a function as being compatible with declarative processing, such as WinJS.UI.processAll
        /// or WinJS.Binding.processAll.
        /// </summary>
        /// <param name="func" type="Function" locid="WinJS.Utilities.markSupportedForProcessing_p:func">
        /// The function to be marked as compatible with declarative processing.
        /// </param>
        /// <returns type="Function" locid="WinJS.Utilities.markSupportedForProcessing_returnValue">
        /// The input function.
        /// </returns>
        /// </signature>
        func.supportedForProcessing = true;
        return func;
    }

    var actualSetImmediate = null;

    return {
        hasWinRT: hasWinRT,
        markSupportedForProcessing: markSupportedForProcessing,
        _setImmediate: function (callback) {
            // BEGIN monaco change
            if (actualSetImmediate === null) {
                if (_Global.setImmediate) {
                    actualSetImmediate = _Global.setImmediate.bind(_Global);
                } else if (typeof process !== 'undefined' && typeof process.nextTick === 'function') {
                    actualSetImmediate = process.nextTick.bind(process);
                } else {
                    actualSetImmediate = _Global.setTimeout.bind(_Global);
                }
            }
            actualSetImmediate(callback);
            // END monaco change
        }
    };
});
_winjs("WinJS/Core/_WriteProfilerMark", ["WinJS/Core/_Global"], function profilerInit(_Global) {
    "use strict";

    return _Global.msWriteProfilerMark || function () { };
});
_winjs("WinJS/Core/_Base", ["WinJS/Core/_WinJS","WinJS/Core/_Global","WinJS/Core/_BaseCoreUtils","WinJS/Core/_WriteProfilerMark"], function baseInit(_WinJS, _Global, _BaseCoreUtils, _WriteProfilerMark) {
    "use strict";

    function initializeProperties(target, members, prefix) {
        var keys = Object.keys(members);
        var isArray = Array.isArray(target);
        var properties;
        var i, len;
        for (i = 0, len = keys.length; i < len; i++) {
            var key = keys[i];
            var enumerable = key.charCodeAt(0) !== /*_*/95;
            var member = members[key];
            if (member && typeof member === 'object') {
                if (member.value !== undefined || typeof member.get === 'function' || typeof member.set === 'function') {
                    if (member.enumerable === undefined) {
                        member.enumerable = enumerable;
                    }
                    if (prefix && member.setName && typeof member.setName === 'function') {
                        member.setName(prefix + "." + key);
                    }
                    properties = properties || {};
                    properties[key] = member;
                    continue;
                }
            }
            if (!enumerable) {
                properties = properties || {};
                properties[key] = { value: member, enumerable: enumerable, configurable: true, writable: true };
                continue;
            }
            if (isArray) {
                target.forEach(function (target) {
                    target[key] = member;
                });
            } else {
                target[key] = member;
            }
        }
        if (properties) {
            if (isArray) {
                target.forEach(function (target) {
                    Object.defineProperties(target, properties);
                });
            } else {
                Object.defineProperties(target, properties);
            }
        }
    }

    (function () {

        var _rootNamespace = _WinJS;
        if (!_rootNamespace.Namespace) {
            _rootNamespace.Namespace = Object.create(Object.prototype);
        }

        function createNamespace(parentNamespace, name) {
            var currentNamespace = parentNamespace || {};
            if (name) {
                var namespaceFragments = name.split(".");
                if (currentNamespace === _Global && namespaceFragments[0] === "WinJS") {
                    currentNamespace = _WinJS;
                    namespaceFragments.splice(0, 1);
                }
                for (var i = 0, len = namespaceFragments.length; i < len; i++) {
                    var namespaceName = namespaceFragments[i];
                    if (!currentNamespace[namespaceName]) {
                        Object.defineProperty(currentNamespace, namespaceName,
                            { value: {}, writable: false, enumerable: true, configurable: true }
                        );
                    }
                    currentNamespace = currentNamespace[namespaceName];
                }
            }
            return currentNamespace;
        }

        function defineWithParent(parentNamespace, name, members) {
            /// <signature helpKeyword="WinJS.Namespace.defineWithParent">
            /// <summary locid="WinJS.Namespace.defineWithParent">
            /// Defines a new namespace with the specified name under the specified parent namespace.
            /// </summary>
            /// <param name="parentNamespace" type="Object" locid="WinJS.Namespace.defineWithParent_p:parentNamespace">
            /// The parent namespace.
            /// </param>
            /// <param name="name" type="String" locid="WinJS.Namespace.defineWithParent_p:name">
            /// The name of the new namespace.
            /// </param>
            /// <param name="members" type="Object" locid="WinJS.Namespace.defineWithParent_p:members">
            /// The members of the new namespace.
            /// </param>
            /// <returns type="Object" locid="WinJS.Namespace.defineWithParent_returnValue">
            /// The newly-defined namespace.
            /// </returns>
            /// </signature>
            var currentNamespace = createNamespace(parentNamespace, name);

            if (members) {
                initializeProperties(currentNamespace, members, name || "<ANONYMOUS>");
            }

            return currentNamespace;
        }

        function define(name, members) {
            /// <signature helpKeyword="WinJS.Namespace.define">
            /// <summary locid="WinJS.Namespace.define">
            /// Defines a new namespace with the specified name.
            /// </summary>
            /// <param name="name" type="String" locid="WinJS.Namespace.define_p:name">
            /// The name of the namespace. This could be a dot-separated name for nested namespaces.
            /// </param>
            /// <param name="members" type="Object" locid="WinJS.Namespace.define_p:members">
            /// The members of the new namespace.
            /// </param>
            /// <returns type="Object" locid="WinJS.Namespace.define_returnValue">
            /// The newly-defined namespace.
            /// </returns>
            /// </signature>
            return defineWithParent(_Global, name, members);
        }

        var LazyStates = {
            uninitialized: 1,
            working: 2,
            initialized: 3,
        };

        function lazy(f) {
            var name;
            var state = LazyStates.uninitialized;
            var result;
            return {
                setName: function (value) {
                    name = value;
                },
                get: function () {
                    switch (state) {
                        case LazyStates.initialized:
                            return result;

                        case LazyStates.uninitialized:
                            state = LazyStates.working;
                            try {
                                _WriteProfilerMark("WinJS.Namespace._lazy:" + name + ",StartTM");
                                result = f();
                            } finally {
                                _WriteProfilerMark("WinJS.Namespace._lazy:" + name + ",StopTM");
                                state = LazyStates.uninitialized;
                            }
                            f = null;
                            state = LazyStates.initialized;
                            return result;

                        case LazyStates.working:
                            throw "Illegal: reentrancy on initialization";

                        default:
                            throw "Illegal";
                    }
                },
                set: function (value) {
                    switch (state) {
                        case LazyStates.working:
                            throw "Illegal: reentrancy on initialization";

                        default:
                            state = LazyStates.initialized;
                            result = value;
                            break;
                    }
                },
                enumerable: true,
                configurable: true,
            };
        }

        // helper for defining AMD module members
        function moduleDefine(exports, name, members) {
            var target = [exports];
            var publicNS = null;
            if (name) {
                publicNS = createNamespace(_Global, name);
                target.push(publicNS);
            }
            initializeProperties(target, members, name || "<ANONYMOUS>");
            return publicNS;
        }

        // Establish members of the "WinJS.Namespace" namespace
        Object.defineProperties(_rootNamespace.Namespace, {

            defineWithParent: { value: defineWithParent, writable: true, enumerable: true, configurable: true },

            define: { value: define, writable: true, enumerable: true, configurable: true },

            _lazy: { value: lazy, writable: true, enumerable: true, configurable: true },

            _moduleDefine: { value: moduleDefine, writable: true, enumerable: true, configurable: true }

        });

    })();

    (function () {

        function define(constructor, instanceMembers, staticMembers) {
            /// <signature helpKeyword="WinJS.Class.define">
            /// <summary locid="WinJS.Class.define">
            /// Defines a class using the given constructor and the specified instance members.
            /// </summary>
            /// <param name="constructor" type="Function" locid="WinJS.Class.define_p:constructor">
            /// A constructor function that is used to instantiate this class.
            /// </param>
            /// <param name="instanceMembers" type="Object" locid="WinJS.Class.define_p:instanceMembers">
            /// The set of instance fields, properties, and methods made available on the class.
            /// </param>
            /// <param name="staticMembers" type="Object" locid="WinJS.Class.define_p:staticMembers">
            /// The set of static fields, properties, and methods made available on the class.
            /// </param>
            /// <returns type="Function" locid="WinJS.Class.define_returnValue">
            /// The newly-defined class.
            /// </returns>
            /// </signature>
            constructor = constructor || function () { };
            _BaseCoreUtils.markSupportedForProcessing(constructor);
            if (instanceMembers) {
                initializeProperties(constructor.prototype, instanceMembers);
            }
            if (staticMembers) {
                initializeProperties(constructor, staticMembers);
            }
            return constructor;
        }

        function derive(baseClass, constructor, instanceMembers, staticMembers) {
            /// <signature helpKeyword="WinJS.Class.derive">
            /// <summary locid="WinJS.Class.derive">
            /// Creates a sub-class based on the supplied baseClass parameter, using prototypal inheritance.
            /// </summary>
            /// <param name="baseClass" type="Function" locid="WinJS.Class.derive_p:baseClass">
            /// The class to inherit from.
            /// </param>
            /// <param name="constructor" type="Function" locid="WinJS.Class.derive_p:constructor">
            /// A constructor function that is used to instantiate this class.
            /// </param>
            /// <param name="instanceMembers" type="Object" locid="WinJS.Class.derive_p:instanceMembers">
            /// The set of instance fields, properties, and methods to be made available on the class.
            /// </param>
            /// <param name="staticMembers" type="Object" locid="WinJS.Class.derive_p:staticMembers">
            /// The set of static fields, properties, and methods to be made available on the class.
            /// </param>
            /// <returns type="Function" locid="WinJS.Class.derive_returnValue">
            /// The newly-defined class.
            /// </returns>
            /// </signature>
            if (baseClass) {
                constructor = constructor || function () { };
                var basePrototype = baseClass.prototype;
                constructor.prototype = Object.create(basePrototype);
                _BaseCoreUtils.markSupportedForProcessing(constructor);
                Object.defineProperty(constructor.prototype, "constructor", { value: constructor, writable: true, configurable: true, enumerable: true });
                if (instanceMembers) {
                    initializeProperties(constructor.prototype, instanceMembers);
                }
                if (staticMembers) {
                    initializeProperties(constructor, staticMembers);
                }
                return constructor;
            } else {
                return define(constructor, instanceMembers, staticMembers);
            }
        }

        function mix(constructor) {
            /// <signature helpKeyword="WinJS.Class.mix">
            /// <summary locid="WinJS.Class.mix">
            /// Defines a class using the given constructor and the union of the set of instance members
            /// specified by all the mixin objects. The mixin parameter list is of variable length.
            /// </summary>
            /// <param name="constructor" locid="WinJS.Class.mix_p:constructor">
            /// A constructor function that is used to instantiate this class.
            /// </param>
            /// <returns type="Function" locid="WinJS.Class.mix_returnValue">
            /// The newly-defined class.
            /// </returns>
            /// </signature>
            constructor = constructor || function () { };
            var i, len;
            for (i = 1, len = arguments.length; i < len; i++) {
                initializeProperties(constructor.prototype, arguments[i]);
            }
            return constructor;
        }

        // Establish members of "WinJS.Class" namespace
        _WinJS.Namespace.define("WinJS.Class", {
            define: define,
            derive: derive,
            mix: mix
        });

    })();

    return {
        Namespace: _WinJS.Namespace,
        Class: _WinJS.Class
    };

});
_winjs("WinJS/Core/_ErrorFromName", ["WinJS/Core/_Base"], function errorsInit(_Base) {
    "use strict";

    var ErrorFromName = _Base.Class.derive(Error, function (name, message) {
        /// <signature helpKeyword="WinJS.ErrorFromName">
        /// <summary locid="WinJS.ErrorFromName">
        /// Creates an Error object with the specified name and message properties.
        /// </summary>
        /// <param name="name" type="String" locid="WinJS.ErrorFromName_p:name">The name of this error. The name is meant to be consumed programmatically and should not be localized.</param>
        /// <param name="message" type="String" optional="true" locid="WinJS.ErrorFromName_p:message">The message for this error. The message is meant to be consumed by humans and should be localized.</param>
        /// <returns type="Error" locid="WinJS.ErrorFromName_returnValue">Error instance with .name and .message properties populated</returns>
        /// </signature>
        this.name = name;
        this.message = message || name;
    }, {
        /* empty */
    }, {
        supportedForProcessing: false,
    });

    _Base.Namespace.define("WinJS", {
        // ErrorFromName establishes a simple pattern for returning error codes.
        //
        ErrorFromName: ErrorFromName
    });

    return ErrorFromName;

});


_winjs("WinJS/Core/_Events", ["exports","WinJS/Core/_Base"], function eventsInit(exports, _Base) {
    "use strict";


    function createEventProperty(name) {
        var eventPropStateName = "_on" + name + "state";

        return {
            get: function () {
                var state = this[eventPropStateName];
                return state && state.userHandler;
            },
            set: function (handler) {
                var state = this[eventPropStateName];
                if (handler) {
                    if (!state) {
                        state = { wrapper: function (evt) { return state.userHandler(evt); }, userHandler: handler };
                        Object.defineProperty(this, eventPropStateName, { value: state, enumerable: false, writable:true, configurable: true });
                        this.addEventListener(name, state.wrapper, false);
                    }
                    state.userHandler = handler;
                } else if (state) {
                    this.removeEventListener(name, state.wrapper, false);
                    this[eventPropStateName] = null;
                }
            },
            enumerable: true
        };
    }

    function createEventProperties() {
        /// <signature helpKeyword="WinJS.Utilities.createEventProperties">
        /// <summary locid="WinJS.Utilities.createEventProperties">
        /// Creates an object that has one property for each name passed to the function.
        /// </summary>
        /// <param name="events" locid="WinJS.Utilities.createEventProperties_p:events">
        /// A variable list of property names.
        /// </param>
        /// <returns type="Object" locid="WinJS.Utilities.createEventProperties_returnValue">
        /// The object with the specified properties. The names of the properties are prefixed with 'on'.
        /// </returns>
        /// </signature>
        var props = {};
        for (var i = 0, len = arguments.length; i < len; i++) {
            var name = arguments[i];
            props["on" + name] = createEventProperty(name);
        }
        return props;
    }

    var EventMixinEvent = _Base.Class.define(
        function EventMixinEvent_ctor(type, detail, target) {
            this.detail = detail;
            this.target = target;
            this.timeStamp = Date.now();
            this.type = type;
        },
        {
            bubbles: { value: false, writable: false },
            cancelable: { value: false, writable: false },
            currentTarget: {
                get: function () { return this.target; }
            },
            defaultPrevented: {
                get: function () { return this._preventDefaultCalled; }
            },
            trusted: { value: false, writable: false },
            eventPhase: { value: 0, writable: false },
            target: null,
            timeStamp: null,
            type: null,

            preventDefault: function () {
                this._preventDefaultCalled = true;
            },
            stopImmediatePropagation: function () {
                this._stopImmediatePropagationCalled = true;
            },
            stopPropagation: function () {
            }
        }, {
            supportedForProcessing: false,
        }
    );

    var eventMixin = {
        _listeners: null,

        addEventListener: function (type, listener, useCapture) {
            /// <signature helpKeyword="WinJS.Utilities.eventMixin.addEventListener">
            /// <summary locid="WinJS.Utilities.eventMixin.addEventListener">
            /// Adds an event listener to the control.
            /// </summary>
            /// <param name="type" locid="WinJS.Utilities.eventMixin.addEventListener_p:type">
            /// The type (name) of the event.
            /// </param>
            /// <param name="listener" locid="WinJS.Utilities.eventMixin.addEventListener_p:listener">
            /// The listener to invoke when the event is raised.
            /// </param>
            /// <param name="useCapture" locid="WinJS.Utilities.eventMixin.addEventListener_p:useCapture">
            /// if true initiates capture, otherwise false.
            /// </param>
            /// </signature>
            useCapture = useCapture || false;
            this._listeners = this._listeners || {};
            var eventListeners = (this._listeners[type] = this._listeners[type] || []);
            for (var i = 0, len = eventListeners.length; i < len; i++) {
                var l = eventListeners[i];
                if (l.useCapture === useCapture && l.listener === listener) {
                    return;
                }
            }
            eventListeners.push({ listener: listener, useCapture: useCapture });
        },
        dispatchEvent: function (type, details) {
            /// <signature helpKeyword="WinJS.Utilities.eventMixin.dispatchEvent">
            /// <summary locid="WinJS.Utilities.eventMixin.dispatchEvent">
            /// Raises an event of the specified type and with the specified additional properties.
            /// </summary>
            /// <param name="type" locid="WinJS.Utilities.eventMixin.dispatchEvent_p:type">
            /// The type (name) of the event.
            /// </param>
            /// <param name="details" locid="WinJS.Utilities.eventMixin.dispatchEvent_p:details">
            /// The set of additional properties to be attached to the event object when the event is raised.
            /// </param>
            /// <returns type="Boolean" locid="WinJS.Utilities.eventMixin.dispatchEvent_returnValue">
            /// true if preventDefault was called on the event.
            /// </returns>
            /// </signature>
            var listeners = this._listeners && this._listeners[type];
            if (listeners) {
                var eventValue = new EventMixinEvent(type, details, this);
                // Need to copy the array to protect against people unregistering while we are dispatching
                listeners = listeners.slice(0, listeners.length);
                for (var i = 0, len = listeners.length; i < len && !eventValue._stopImmediatePropagationCalled; i++) {
                    listeners[i].listener(eventValue);
                }
                return eventValue.defaultPrevented || false;
            }
            return false;
        },
        removeEventListener: function (type, listener, useCapture) {
            /// <signature helpKeyword="WinJS.Utilities.eventMixin.removeEventListener">
            /// <summary locid="WinJS.Utilities.eventMixin.removeEventListener">
            /// Removes an event listener from the control.
            /// </summary>
            /// <param name="type" locid="WinJS.Utilities.eventMixin.removeEventListener_p:type">
            /// The type (name) of the event.
            /// </param>
            /// <param name="listener" locid="WinJS.Utilities.eventMixin.removeEventListener_p:listener">
            /// The listener to remove.
            /// </param>
            /// <param name="useCapture" locid="WinJS.Utilities.eventMixin.removeEventListener_p:useCapture">
            /// Specifies whether to initiate capture.
            /// </param>
            /// </signature>
            useCapture = useCapture || false;
            var listeners = this._listeners && this._listeners[type];
            if (listeners) {
                for (var i = 0, len = listeners.length; i < len; i++) {
                    var l = listeners[i];
                    if (l.listener === listener && l.useCapture === useCapture) {
                        listeners.splice(i, 1);
                        if (listeners.length === 0) {
                            delete this._listeners[type];
                        }
                        // Only want to remove one element for each call to removeEventListener
                        break;
                    }
                }
            }
        }
    };

    _Base.Namespace._moduleDefine(exports, "WinJS.Utilities", {
        _createEventProperty: createEventProperty,
        createEventProperties: createEventProperties,
        eventMixin: eventMixin
    });

});


_winjs("WinJS/Core/_Trace", ["WinJS/Core/_Global"], function traceInit(_Global) {
    "use strict";

    function nop(v) {
        return v;
    }

    return {
        _traceAsyncOperationStarting: (_Global.Debug && _Global.Debug.msTraceAsyncOperationStarting && _Global.Debug.msTraceAsyncOperationStarting.bind(_Global.Debug)) || nop,
        _traceAsyncOperationCompleted: (_Global.Debug && _Global.Debug.msTraceAsyncOperationCompleted && _Global.Debug.msTraceAsyncOperationCompleted.bind(_Global.Debug)) || nop,
        _traceAsyncCallbackStarting: (_Global.Debug && _Global.Debug.msTraceAsyncCallbackStarting && _Global.Debug.msTraceAsyncCallbackStarting.bind(_Global.Debug)) || nop,
        _traceAsyncCallbackCompleted: (_Global.Debug && _Global.Debug.msTraceAsyncCallbackCompleted && _Global.Debug.msTraceAsyncCallbackCompleted.bind(_Global.Debug)) || nop
    };
});
_winjs("WinJS/Promise/_StateMachine", ["WinJS/Core/_Global","WinJS/Core/_BaseCoreUtils","WinJS/Core/_Base","WinJS/Core/_ErrorFromName","WinJS/Core/_Events","WinJS/Core/_Trace"], function promiseStateMachineInit(_Global, _BaseCoreUtils, _Base, _ErrorFromName, _Events, _Trace) {
    "use strict";

    _Global.Debug && (_Global.Debug.setNonUserCodeExceptions = true);

    var ListenerType = _Base.Class.mix(_Base.Class.define(null, { /*empty*/ }, { supportedForProcessing: false }), _Events.eventMixin);
    var promiseEventListeners = new ListenerType();
    // make sure there is a listeners collection so that we can do a more trivial check below
    promiseEventListeners._listeners = {};
    var errorET = "error";
    var canceledName = "Canceled";
    var tagWithStack = false;
    var tag = {
        promise: 0x01,
        thenPromise: 0x02,
        errorPromise: 0x04,
        exceptionPromise: 0x08,
        completePromise: 0x10,
    };
    tag.all = tag.promise | tag.thenPromise | tag.errorPromise | tag.exceptionPromise | tag.completePromise;

    //
    // Global error counter, for each error which enters the system we increment this once and then
    // the error number travels with the error as it traverses the tree of potential handlers.
    //
    // When someone has registered to be told about errors (WinJS.Promise.callonerror) promises
    // which are in error will get tagged with a ._errorId field. This tagged field is the
    // contract by which nested promises with errors will be identified as chaining for the
    // purposes of the callonerror semantics. If a nested promise in error is encountered without
    // a ._errorId it will be assumed to be foreign and treated as an interop boundary and
    // a new error id will be minted.
    //
    var error_number = 1;

    //
    // The state machine has a interesting hiccup in it with regards to notification, in order
    // to flatten out notification and avoid recursion for synchronous completion we have an
    // explicit set of *_notify states which are responsible for notifying their entire tree
    // of children. They can do this because they know that immediate children are always
    // ThenPromise instances and we can therefore reach into their state to access the
    // _listeners collection.
    //
    // So, what happens is that a Promise will be fulfilled through the _completed or _error
    // messages at which point it will enter a *_notify state and be responsible for to move
    // its children into an (as appropriate) success or error state and also notify that child's
    // listeners of the state transition, until leaf notes are reached.
    //

    var state_created,              // -> working
        state_working,              // -> error | error_notify | success | success_notify | canceled | waiting
        state_waiting,              // -> error | error_notify | success | success_notify | waiting_canceled
        state_waiting_canceled,     // -> error | error_notify | success | success_notify | canceling
        state_canceled,             // -> error | error_notify | success | success_notify | canceling
        state_canceling,            // -> error_notify
        state_success_notify,       // -> success
        state_success,              // -> .
        state_error_notify,         // -> error
        state_error;                // -> .

    // Noop function, used in the various states to indicate that they don't support a given
    // message. Named with the somewhat cute name '_' because it reads really well in the states.

    function _() { }

    // Initial state
    //
    state_created = {
        name: "created",
        enter: function (promise) {
            promise._setState(state_working);
        },
        cancel: _,
        done: _,
        then: _,
        _completed: _,
        _error: _,
        _notify: _,
        _progress: _,
        _setCompleteValue: _,
        _setErrorValue: _
    };

    // Ready state, waiting for a message (completed/error/progress), able to be canceled
    //
    state_working = {
        name: "working",
        enter: _,
        cancel: function (promise) {
            promise._setState(state_canceled);
        },
        done: done,
        then: then,
        _completed: completed,
        _error: error,
        _notify: _,
        _progress: progress,
        _setCompleteValue: setCompleteValue,
        _setErrorValue: setErrorValue
    };

    // Waiting state, if a promise is completed with a value which is itself a promise
    // (has a then() method) it signs up to be informed when that child promise is
    // fulfilled at which point it will be fulfilled with that value.
    //
    state_waiting = {
        name: "waiting",
        enter: function (promise) {
            var waitedUpon = promise._value;
            // We can special case our own intermediate promises which are not in a
            //  terminal state by just pushing this promise as a listener without
            //  having to create new indirection functions
            if (waitedUpon instanceof ThenPromise &&
                waitedUpon._state !== state_error &&
                waitedUpon._state !== state_success) {
                pushListener(waitedUpon, { promise: promise });
            } else {
                var error = function (value) {
                    if (waitedUpon._errorId) {
                        promise._chainedError(value, waitedUpon);
                    } else {
                        // Because this is an interop boundary we want to indicate that this
                        //  error has been handled by the promise infrastructure before we
                        //  begin a new handling chain.
                        //
                        callonerror(promise, value, detailsForHandledError, waitedUpon, error);
                        promise._error(value);
                    }
                };
                error.handlesOnError = true;
                waitedUpon.then(
                    promise._completed.bind(promise),
                    error,
                    promise._progress.bind(promise)
                );
            }
        },
        cancel: function (promise) {
            promise._setState(state_waiting_canceled);
        },
        done: done,
        then: then,
        _completed: completed,
        _error: error,
        _notify: _,
        _progress: progress,
        _setCompleteValue: setCompleteValue,
        _setErrorValue: setErrorValue
    };

    // Waiting canceled state, when a promise has been in a waiting state and receives a
    // request to cancel its pending work it will forward that request to the child promise
    // and then waits to be informed of the result. This promise moves itself into the
    // canceling state but understands that the child promise may instead push it to a
    // different state.
    //
    state_waiting_canceled = {
        name: "waiting_canceled",
        enter: function (promise) {
            // Initiate a transition to canceling. Triggering a cancel on the promise
            // that we are waiting upon may result in a different state transition
            // before the state machine pump runs again.
            promise._setState(state_canceling);
            var waitedUpon = promise._value;
            if (waitedUpon.cancel) {
                waitedUpon.cancel();
            }
        },
        cancel: _,
        done: done,
        then: then,
        _completed: completed,
        _error: error,
        _notify: _,
        _progress: progress,
        _setCompleteValue: setCompleteValue,
        _setErrorValue: setErrorValue
    };

    // Canceled state, moves to the canceling state and then tells the promise to do
    // whatever it might need to do on cancelation.
    //
    state_canceled = {
        name: "canceled",
        enter: function (promise) {
            // Initiate a transition to canceling. The _cancelAction may change the state
            // before the state machine pump runs again.
            promise._setState(state_canceling);
            promise._cancelAction();
        },
        cancel: _,
        done: done,
        then: then,
        _completed: completed,
        _error: error,
        _notify: _,
        _progress: progress,
        _setCompleteValue: setCompleteValue,
        _setErrorValue: setErrorValue
    };

    // Canceling state, commits to the promise moving to an error state with an error
    // object whose 'name' and 'message' properties contain the string "Canceled"
    //
    state_canceling = {
        name: "canceling",
        enter: function (promise) {
            var error = new Error(canceledName);
            error.name = error.message;
            promise._value = error;
            promise._setState(state_error_notify);
        },
        cancel: _,
        done: _,
        then: _,
        _completed: _,
        _error: _,
        _notify: _,
        _progress: _,
        _setCompleteValue: _,
        _setErrorValue: _
    };

    // Success notify state, moves a promise to the success state and notifies all children
    //
    state_success_notify = {
        name: "complete_notify",
        enter: function (promise) {
            promise.done = CompletePromise.prototype.done;
            promise.then = CompletePromise.prototype.then;
            if (promise._listeners) {
                var queue = [promise];
                var p;
                while (queue.length) {
                    p = queue.shift();
                    p._state._notify(p, queue);
                }
            }
            promise._setState(state_success);
        },
        cancel: _,
        done: null, /*error to get here */
        then: null, /*error to get here */
        _completed: _,
        _error: _,
        _notify: notifySuccess,
        _progress: _,
        _setCompleteValue: _,
        _setErrorValue: _
    };

    // Success state, moves a promise to the success state and does NOT notify any children.
    // Some upstream promise is owning the notification pass.
    //
    state_success = {
        name: "success",
        enter: function (promise) {
            promise.done = CompletePromise.prototype.done;
            promise.then = CompletePromise.prototype.then;
            promise._cleanupAction();
        },
        cancel: _,
        done: null, /*error to get here */
        then: null, /*error to get here */
        _completed: _,
        _error: _,
        _notify: notifySuccess,
        _progress: _,
        _setCompleteValue: _,
        _setErrorValue: _
    };

    // Error notify state, moves a promise to the error state and notifies all children
    //
    state_error_notify = {
        name: "error_notify",
        enter: function (promise) {
            promise.done = ErrorPromise.prototype.done;
            promise.then = ErrorPromise.prototype.then;
            if (promise._listeners) {
                var queue = [promise];
                var p;
                while (queue.length) {
                    p = queue.shift();
                    p._state._notify(p, queue);
                }
            }
            promise._setState(state_error);
        },
        cancel: _,
        done: null, /*error to get here*/
        then: null, /*error to get here*/
        _completed: _,
        _error: _,
        _notify: notifyError,
        _progress: _,
        _setCompleteValue: _,
        _setErrorValue: _
    };

    // Error state, moves a promise to the error state and does NOT notify any children.
    // Some upstream promise is owning the notification pass.
    //
    state_error = {
        name: "error",
        enter: function (promise) {
            promise.done = ErrorPromise.prototype.done;
            promise.then = ErrorPromise.prototype.then;
            promise._cleanupAction();
        },
        cancel: _,
        done: null, /*error to get here*/
        then: null, /*error to get here*/
        _completed: _,
        _error: _,
        _notify: notifyError,
        _progress: _,
        _setCompleteValue: _,
        _setErrorValue: _
    };

    //
    // The statemachine implementation follows a very particular pattern, the states are specified
    // as static stateless bags of functions which are then indirected through the state machine
    // instance (a Promise). As such all of the functions on each state have the promise instance
    // passed to them explicitly as a parameter and the Promise instance members do a little
    // dance where they indirect through the state and insert themselves in the argument list.
    //
    // We could instead call directly through the promise states however then every caller
    // would have to remember to do things like pumping the state machine to catch state transitions.
    //

    var PromiseStateMachine = _Base.Class.define(null, {
        _listeners: null,
        _nextState: null,
        _state: null,
        _value: null,

        cancel: function () {
            /// <signature helpKeyword="WinJS.PromiseStateMachine.cancel">
            /// <summary locid="WinJS.PromiseStateMachine.cancel">
            /// Attempts to cancel the fulfillment of a promised value. If the promise hasn't
            /// already been fulfilled and cancellation is supported, the promise enters
            /// the error state with a value of Error("Canceled").
            /// </summary>
            /// </signature>
            this._state.cancel(this);
            this._run();
        },
        done: function Promise_done(onComplete, onError, onProgress) {
            /// <signature helpKeyword="WinJS.PromiseStateMachine.done">
            /// <summary locid="WinJS.PromiseStateMachine.done">
            /// Allows you to specify the work to be done on the fulfillment of the promised value,
            /// the error handling to be performed if the promise fails to fulfill
            /// a value, and the handling of progress notifications along the way.
            ///
            /// After the handlers have finished executing, this function throws any error that would have been returned
            /// from then() as a promise in the error state.
            /// </summary>
            /// <param name='onComplete' type='Function' locid="WinJS.PromiseStateMachine.done_p:onComplete">
            /// The function to be called if the promise is fulfilled successfully with a value.
            /// The fulfilled value is passed as the single argument. If the value is null,
            /// the fulfilled value is returned. The value returned
            /// from the function becomes the fulfilled value of the promise returned by
            /// then(). If an exception is thrown while executing the function, the promise returned
            /// by then() moves into the error state.
            /// </param>
            /// <param name='onError' type='Function' optional='true' locid="WinJS.PromiseStateMachine.done_p:onError">
            /// The function to be called if the promise is fulfilled with an error. The error
            /// is passed as the single argument. If it is null, the error is forwarded.
            /// The value returned from the function is the fulfilled value of the promise returned by then().
            /// </param>
            /// <param name='onProgress' type='Function' optional='true' locid="WinJS.PromiseStateMachine.done_p:onProgress">
            /// the function to be called if the promise reports progress. Data about the progress
            /// is passed as the single argument. Promises are not required to support
            /// progress.
            /// </param>
            /// </signature>
            this._state.done(this, onComplete, onError, onProgress);
        },
        then: function Promise_then(onComplete, onError, onProgress) {
            /// <signature helpKeyword="WinJS.PromiseStateMachine.then">
            /// <summary locid="WinJS.PromiseStateMachine.then">
            /// Allows you to specify the work to be done on the fulfillment of the promised value,
            /// the error handling to be performed if the promise fails to fulfill
            /// a value, and the handling of progress notifications along the way.
            /// </summary>
            /// <param name='onComplete' type='Function' locid="WinJS.PromiseStateMachine.then_p:onComplete">
            /// The function to be called if the promise is fulfilled successfully with a value.
            /// The value is passed as the single argument. If the value is null, the value is returned.
            /// The value returned from the function becomes the fulfilled value of the promise returned by
            /// then(). If an exception is thrown while this function is being executed, the promise returned
            /// by then() moves into the error state.
            /// </param>
            /// <param name='onError' type='Function' optional='true' locid="WinJS.PromiseStateMachine.then_p:onError">
            /// The function to be called if the promise is fulfilled with an error. The error
            /// is passed as the single argument. If it is null, the error is forwarded.
            /// The value returned from the function becomes the fulfilled value of the promise returned by then().
            /// </param>
            /// <param name='onProgress' type='Function' optional='true' locid="WinJS.PromiseStateMachine.then_p:onProgress">
            /// The function to be called if the promise reports progress. Data about the progress
            /// is passed as the single argument. Promises are not required to support
            /// progress.
            /// </param>
            /// <returns type="WinJS.Promise" locid="WinJS.PromiseStateMachine.then_returnValue">
            /// The promise whose value is the result of executing the complete or
            /// error function.
            /// </returns>
            /// </signature>
            // BEGIN monaco change
            if (this.then !== Promise_then) {
                this.then(onComplete, onError, onProgress);
                return;
            }
            // END monaco change
            return this._state.then(this, onComplete, onError, onProgress);
        },

        _chainedError: function (value, context) {
            var result = this._state._error(this, value, detailsForChainedError, context);
            this._run();
            return result;
        },
        _completed: function (value) {
            var result = this._state._completed(this, value);
            this._run();
            return result;
        },
        _error: function (value) {
            var result = this._state._error(this, value, detailsForError);
            this._run();
            return result;
        },
        _progress: function (value) {
            this._state._progress(this, value);
        },
        _setState: function (state) {
            this._nextState = state;
        },
        _setCompleteValue: function (value) {
            this._state._setCompleteValue(this, value);
            this._run();
        },
        _setChainedErrorValue: function (value, context) {
            var result = this._state._setErrorValue(this, value, detailsForChainedError, context);
            this._run();
            return result;
        },
        _setExceptionValue: function (value) {
            var result = this._state._setErrorValue(this, value, detailsForException);
            this._run();
            return result;
        },
        _run: function () {
            while (this._nextState) {
                this._state = this._nextState;
                this._nextState = null;
                this._state.enter(this);
            }
        }
    }, {
        supportedForProcessing: false
    });

    //
    // Implementations of shared state machine code.
    //

    function completed(promise, value) {
        var targetState;
        if (value && typeof value === "object" && typeof value.then === "function") {
            targetState = state_waiting;
        } else {
            targetState = state_success_notify;
        }
        promise._value = value;
        promise._setState(targetState);
    }
    function createErrorDetails(exception, error, promise, id, parent, handler) {
        return {
            exception: exception,
            error: error,
            promise: promise,
            handler: handler,
            id: id,
            parent: parent
        };
    }
    function detailsForHandledError(promise, errorValue, context, handler) {
        var exception = context._isException;
        var errorId = context._errorId;
        return createErrorDetails(
            exception ? errorValue : null,
            exception ? null : errorValue,
            promise,
            errorId,
            context,
            handler
        );
    }
    function detailsForChainedError(promise, errorValue, context) {
        var exception = context._isException;
        var errorId = context._errorId;
        setErrorInfo(promise, errorId, exception);
        return createErrorDetails(
            exception ? errorValue : null,
            exception ? null : errorValue,
            promise,
            errorId,
            context
        );
    }
    function detailsForError(promise, errorValue) {
        var errorId = ++error_number;
        setErrorInfo(promise, errorId);
        return createErrorDetails(
            null,
            errorValue,
            promise,
            errorId
        );
    }
    function detailsForException(promise, exceptionValue) {
        var errorId = ++error_number;
        setErrorInfo(promise, errorId, true);
        return createErrorDetails(
            exceptionValue,
            null,
            promise,
            errorId
        );
    }
    function done(promise, onComplete, onError, onProgress) {
        var asyncOpID = _Trace._traceAsyncOperationStarting("WinJS.Promise.done");
        pushListener(promise, { c: onComplete, e: onError, p: onProgress, asyncOpID: asyncOpID });
    }
    function error(promise, value, onerrorDetails, context) {
        promise._value = value;
        callonerror(promise, value, onerrorDetails, context);
        promise._setState(state_error_notify);
    }
    function notifySuccess(promise, queue) {
        var value = promise._value;
        var listeners = promise._listeners;
        if (!listeners) {
            return;
        }
        promise._listeners = null;
        var i, len;
        for (i = 0, len = Array.isArray(listeners) ? listeners.length : 1; i < len; i++) {
            var listener = len === 1 ? listeners : listeners[i];
            var onComplete = listener.c;
            var target = listener.promise;

            _Trace._traceAsyncOperationCompleted(listener.asyncOpID, _Global.Debug && _Global.Debug.MS_ASYNC_OP_STATUS_SUCCESS);

            if (target) {
                _Trace._traceAsyncCallbackStarting(listener.asyncOpID);
                try {
                    target._setCompleteValue(onComplete ? onComplete(value) : value);
                } catch (ex) {
                    target._setExceptionValue(ex);
                } finally {
                    _Trace._traceAsyncCallbackCompleted();
                }
                if (target._state !== state_waiting && target._listeners) {
                    queue.push(target);
                }
            } else {
                CompletePromise.prototype.done.call(promise, onComplete);
            }
        }
    }
    function notifyError(promise, queue) {
        var value = promise._value;
        var listeners = promise._listeners;
        if (!listeners) {
            return;
        }
        promise._listeners = null;
        var i, len;
        for (i = 0, len = Array.isArray(listeners) ? listeners.length : 1; i < len; i++) {
            var listener = len === 1 ? listeners : listeners[i];
            var onError = listener.e;
            var target = listener.promise;

            var errorID = _Global.Debug && (value && value.name === canceledName ? _Global.Debug.MS_ASYNC_OP_STATUS_CANCELED : _Global.Debug.MS_ASYNC_OP_STATUS_ERROR);
            _Trace._traceAsyncOperationCompleted(listener.asyncOpID, errorID);

            if (target) {
                var asyncCallbackStarted = false;
                try {
                    if (onError) {
                        _Trace._traceAsyncCallbackStarting(listener.asyncOpID);
                        asyncCallbackStarted = true;
                        if (!onError.handlesOnError) {
                            callonerror(target, value, detailsForHandledError, promise, onError);
                        }
                        target._setCompleteValue(onError(value));
                    } else {
                        target._setChainedErrorValue(value, promise);
                    }
                } catch (ex) {
                    target._setExceptionValue(ex);
                } finally {
                    if (asyncCallbackStarted) {
                        _Trace._traceAsyncCallbackCompleted();
                    }
                }
                if (target._state !== state_waiting && target._listeners) {
                    queue.push(target);
                }
            } else {
                ErrorPromise.prototype.done.call(promise, null, onError);
            }
        }
    }
    function callonerror(promise, value, onerrorDetailsGenerator, context, handler) {
        if (promiseEventListeners._listeners[errorET]) {
            if (value instanceof Error && value.message === canceledName) {
                return;
            }
            promiseEventListeners.dispatchEvent(errorET, onerrorDetailsGenerator(promise, value, context, handler));
        }
    }
    function progress(promise, value) {
        var listeners = promise._listeners;
        if (listeners) {
            var i, len;
            for (i = 0, len = Array.isArray(listeners) ? listeners.length : 1; i < len; i++) {
                var listener = len === 1 ? listeners : listeners[i];
                var onProgress = listener.p;
                if (onProgress) {
                    try { onProgress(value); } catch (ex) { }
                }
                if (!(listener.c || listener.e) && listener.promise) {
                    listener.promise._progress(value);
                }
            }
        }
    }
    function pushListener(promise, listener) {
        var listeners = promise._listeners;
        if (listeners) {
            // We may have either a single listener (which will never be wrapped in an array)
            // or 2+ listeners (which will be wrapped). Since we are now adding one more listener
            // we may have to wrap the single listener before adding the second.
            listeners = Array.isArray(listeners) ? listeners : [listeners];
            listeners.push(listener);
        } else {
            listeners = listener;
        }
        promise._listeners = listeners;
    }
    // The difference beween setCompleteValue()/setErrorValue() and complete()/error() is that setXXXValue() moves
    // a promise directly to the success/error state without starting another notification pass (because one
    // is already ongoing).
    function setErrorInfo(promise, errorId, isException) {
        promise._isException = isException || false;
        promise._errorId = errorId;
    }
    function setErrorValue(promise, value, onerrorDetails, context) {
        promise._value = value;
        callonerror(promise, value, onerrorDetails, context);
        promise._setState(state_error);
    }
    function setCompleteValue(promise, value) {
        var targetState;
        if (value && typeof value === "object" && typeof value.then === "function") {
            targetState = state_waiting;
        } else {
            targetState = state_success;
        }
        promise._value = value;
        promise._setState(targetState);
    }
    function then(promise, onComplete, onError, onProgress) {
        var result = new ThenPromise(promise);
        var asyncOpID = _Trace._traceAsyncOperationStarting("WinJS.Promise.then");
        pushListener(promise, { promise: result, c: onComplete, e: onError, p: onProgress, asyncOpID: asyncOpID });
        return result;
    }

    //
    // Internal implementation detail promise, ThenPromise is created when a promise needs
    // to be returned from a then() method.
    //
    var ThenPromise = _Base.Class.derive(PromiseStateMachine,
        function (creator) {

            if (tagWithStack && (tagWithStack === true || (tagWithStack & tag.thenPromise))) {
                this._stack = Promise._getStack();
            }

            this._creator = creator;
            this._setState(state_created);
            this._run();
        }, {
            _creator: null,

            _cancelAction: function () { if (this._creator) { this._creator.cancel(); } },
            _cleanupAction: function () { this._creator = null; }
        }, {
            supportedForProcessing: false
        }
    );

    //
    // Slim promise implementations for already completed promises, these are created
    // under the hood on synchronous completion paths as well as by WinJS.Promise.wrap
    // and WinJS.Promise.wrapError.
    //

    var ErrorPromise = _Base.Class.define(
        function ErrorPromise_ctor(value) {

            if (tagWithStack && (tagWithStack === true || (tagWithStack & tag.errorPromise))) {
                this._stack = Promise._getStack();
            }

            this._value = value;
            callonerror(this, value, detailsForError);
        }, {
            cancel: function () {
                /// <signature helpKeyword="WinJS.PromiseStateMachine.cancel">
                /// <summary locid="WinJS.PromiseStateMachine.cancel">
                /// Attempts to cancel the fulfillment of a promised value. If the promise hasn't
                /// already been fulfilled and cancellation is supported, the promise enters
                /// the error state with a value of Error("Canceled").
                /// </summary>
                /// </signature>
            },
            done: function ErrorPromise_done(unused, onError) {
                /// <signature helpKeyword="WinJS.PromiseStateMachine.done">
                /// <summary locid="WinJS.PromiseStateMachine.done">
                /// Allows you to specify the work to be done on the fulfillment of the promised value,
                /// the error handling to be performed if the promise fails to fulfill
                /// a value, and the handling of progress notifications along the way.
                ///
                /// After the handlers have finished executing, this function throws any error that would have been returned
                /// from then() as a promise in the error state.
                /// </summary>
                /// <param name='onComplete' type='Function' locid="WinJS.PromiseStateMachine.done_p:onComplete">
                /// The function to be called if the promise is fulfilled successfully with a value.
                /// The fulfilled value is passed as the single argument. If the value is null,
                /// the fulfilled value is returned. The value returned
                /// from the function becomes the fulfilled value of the promise returned by
                /// then(). If an exception is thrown while executing the function, the promise returned
                /// by then() moves into the error state.
                /// </param>
                /// <param name='onError' type='Function' optional='true' locid="WinJS.PromiseStateMachine.done_p:onError">
                /// The function to be called if the promise is fulfilled with an error. The error
                /// is passed as the single argument. If it is null, the error is forwarded.
                /// The value returned from the function is the fulfilled value of the promise returned by then().
                /// </param>
                /// <param name='onProgress' type='Function' optional='true' locid="WinJS.PromiseStateMachine.done_p:onProgress">
                /// the function to be called if the promise reports progress. Data about the progress
                /// is passed as the single argument. Promises are not required to support
                /// progress.
                /// </param>
                /// </signature>
                var value = this._value;
                if (onError) {
                    try {
                        if (!onError.handlesOnError) {
                            callonerror(null, value, detailsForHandledError, this, onError);
                        }
                        var result = onError(value);
                        if (result && typeof result === "object" && typeof result.done === "function") {
                            // If a promise is returned we need to wait on it.
                            result.done();
                        }
                        return;
                    } catch (ex) {
                        value = ex;
                    }
                }
                if (value instanceof Error && value.message === canceledName) {
                    // suppress cancel
                    return;
                }
                // force the exception to be thrown asyncronously to avoid any try/catch blocks
                //
                Promise._doneHandler(value);
            },
            then: function ErrorPromise_then(unused, onError) {
                /// <signature helpKeyword="WinJS.PromiseStateMachine.then">
                /// <summary locid="WinJS.PromiseStateMachine.then">
                /// Allows you to specify the work to be done on the fulfillment of the promised value,
                /// the error handling to be performed if the promise fails to fulfill
                /// a value, and the handling of progress notifications along the way.
                /// </summary>
                /// <param name='onComplete' type='Function' locid="WinJS.PromiseStateMachine.then_p:onComplete">
                /// The function to be called if the promise is fulfilled successfully with a value.
                /// The value is passed as the single argument. If the value is null, the value is returned.
                /// The value returned from the function becomes the fulfilled value of the promise returned by
                /// then(). If an exception is thrown while this function is being executed, the promise returned
                /// by then() moves into the error state.
                /// </param>
                /// <param name='onError' type='Function' optional='true' locid="WinJS.PromiseStateMachine.then_p:onError">
                /// The function to be called if the promise is fulfilled with an error. The error
                /// is passed as the single argument. If it is null, the error is forwarded.
                /// The value returned from the function becomes the fulfilled value of the promise returned by then().
                /// </param>
                /// <param name='onProgress' type='Function' optional='true' locid="WinJS.PromiseStateMachine.then_p:onProgress">
                /// The function to be called if the promise reports progress. Data about the progress
                /// is passed as the single argument. Promises are not required to support
                /// progress.
                /// </param>
                /// <returns type="WinJS.Promise" locid="WinJS.PromiseStateMachine.then_returnValue">
                /// The promise whose value is the result of executing the complete or
                /// error function.
                /// </returns>
                /// </signature>

                // If the promise is already in a error state and no error handler is provided
                // we optimize by simply returning the promise instead of creating a new one.
                //
                if (!onError) { return this; }
                var result;
                var value = this._value;
                try {
                    if (!onError.handlesOnError) {
                        callonerror(null, value, detailsForHandledError, this, onError);
                    }
                    result = new CompletePromise(onError(value));
                } catch (ex) {
                    // If the value throw from the error handler is the same as the value
                    // provided to the error handler then there is no need for a new promise.
                    //
                    if (ex === value) {
                        result = this;
                    } else {
                        result = new ExceptionPromise(ex);
                    }
                }
                return result;
            }
        }, {
            supportedForProcessing: false
        }
    );

    var ExceptionPromise = _Base.Class.derive(ErrorPromise,
        function ExceptionPromise_ctor(value) {

            if (tagWithStack && (tagWithStack === true || (tagWithStack & tag.exceptionPromise))) {
                this._stack = Promise._getStack();
            }

            this._value = value;
            callonerror(this, value, detailsForException);
        }, {
            /* empty */
        }, {
            supportedForProcessing: false
        }
    );

    var CompletePromise = _Base.Class.define(
        function CompletePromise_ctor(value) {

            if (tagWithStack && (tagWithStack === true || (tagWithStack & tag.completePromise))) {
                this._stack = Promise._getStack();
            }

            if (value && typeof value === "object" && typeof value.then === "function") {
                var result = new ThenPromise(null);
                result._setCompleteValue(value);
                return result;
            }
            this._value = value;
        }, {
            cancel: function () {
                /// <signature helpKeyword="WinJS.PromiseStateMachine.cancel">
                /// <summary locid="WinJS.PromiseStateMachine.cancel">
                /// Attempts to cancel the fulfillment of a promised value. If the promise hasn't
                /// already been fulfilled and cancellation is supported, the promise enters
                /// the error state with a value of Error("Canceled").
                /// </summary>
                /// </signature>
            },
            done: function CompletePromise_done(onComplete) {
                /// <signature helpKeyword="WinJS.PromiseStateMachine.done">
                /// <summary locid="WinJS.PromiseStateMachine.done">
                /// Allows you to specify the work to be done on the fulfillment of the promised value,
                /// the error handling to be performed if the promise fails to fulfill
                /// a value, and the handling of progress notifications along the way.
                ///
                /// After the handlers have finished executing, this function throws any error that would have been returned
                /// from then() as a promise in the error state.
                /// </summary>
                /// <param name='onComplete' type='Function' locid="WinJS.PromiseStateMachine.done_p:onComplete">
                /// The function to be called if the promise is fulfilled successfully with a value.
                /// The fulfilled value is passed as the single argument. If the value is null,
                /// the fulfilled value is returned. The value returned
                /// from the function becomes the fulfilled value of the promise returned by
                /// then(). If an exception is thrown while executing the function, the promise returned
                /// by then() moves into the error state.
                /// </param>
                /// <param name='onError' type='Function' optional='true' locid="WinJS.PromiseStateMachine.done_p:onError">
                /// The function to be called if the promise is fulfilled with an error. The error
                /// is passed as the single argument. If it is null, the error is forwarded.
                /// The value returned from the function is the fulfilled value of the promise returned by then().
                /// </param>
                /// <param name='onProgress' type='Function' optional='true' locid="WinJS.PromiseStateMachine.done_p:onProgress">
                /// the function to be called if the promise reports progress. Data about the progress
                /// is passed as the single argument. Promises are not required to support
                /// progress.
                /// </param>
                /// </signature>
                if (!onComplete) { return; }
                try {
                    var result = onComplete(this._value);
                    if (result && typeof result === "object" && typeof result.done === "function") {
                        result.done();
                    }
                } catch (ex) {
                    // force the exception to be thrown asynchronously to avoid any try/catch blocks
                    Promise._doneHandler(ex);
                }
            },
            then: function CompletePromise_then(onComplete) {
                /// <signature helpKeyword="WinJS.PromiseStateMachine.then">
                /// <summary locid="WinJS.PromiseStateMachine.then">
                /// Allows you to specify the work to be done on the fulfillment of the promised value,
                /// the error handling to be performed if the promise fails to fulfill
                /// a value, and the handling of progress notifications along the way.
                /// </summary>
                /// <param name='onComplete' type='Function' locid="WinJS.PromiseStateMachine.then_p:onComplete">
                /// The function to be called if the promise is fulfilled successfully with a value.
                /// The value is passed as the single argument. If the value is null, the value is returned.
                /// The value returned from the function becomes the fulfilled value of the promise returned by
                /// then(). If an exception is thrown while this function is being executed, the promise returned
                /// by then() moves into the error state.
                /// </param>
                /// <param name='onError' type='Function' optional='true' locid="WinJS.PromiseStateMachine.then_p:onError">
                /// The function to be called if the promise is fulfilled with an error. The error
                /// is passed as the single argument. If it is null, the error is forwarded.
                /// The value returned from the function becomes the fulfilled value of the promise returned by then().
                /// </param>
                /// <param name='onProgress' type='Function' optional='true' locid="WinJS.PromiseStateMachine.then_p:onProgress">
                /// The function to be called if the promise reports progress. Data about the progress
                /// is passed as the single argument. Promises are not required to support
                /// progress.
                /// </param>
                /// <returns type="WinJS.Promise" locid="WinJS.PromiseStateMachine.then_returnValue">
                /// The promise whose value is the result of executing the complete or
                /// error function.
                /// </returns>
                /// </signature>
                try {
                    // If the value returned from the completion handler is the same as the value
                    // provided to the completion handler then there is no need for a new promise.
                    //
                    var newValue = onComplete ? onComplete(this._value) : this._value;
                    return newValue === this._value ? this : new CompletePromise(newValue);
                } catch (ex) {
                    return new ExceptionPromise(ex);
                }
            }
        }, {
            supportedForProcessing: false
        }
    );

    //
    // Promise is the user-creatable WinJS.Promise object.
    //

    function timeout(timeoutMS) {
        var id;
        return new Promise(
            function (c) {
                if (timeoutMS) {
                    id = _Global.setTimeout(c, timeoutMS);
                } else {
                    _BaseCoreUtils._setImmediate(c);
                }
            },
            function () {
                if (id) {
                    _Global.clearTimeout(id);
                }
            }
        );
    }

    function timeoutWithPromise(timeout, promise) {
        var cancelPromise = function () { promise.cancel(); };
        var cancelTimeout = function () { timeout.cancel(); };
        timeout.then(cancelPromise);
        promise.then(cancelTimeout, cancelTimeout);
        return promise;
    }

    var staticCanceledPromise;

    var Promise = _Base.Class.derive(PromiseStateMachine,
        function Promise_ctor(init, oncancel) {
            /// <signature helpKeyword="WinJS.Promise">
            /// <summary locid="WinJS.Promise">
            /// A promise provides a mechanism to schedule work to be done on a value that
            /// has not yet been computed. It is a convenient abstraction for managing
            /// interactions with asynchronous APIs.
            /// </summary>
            /// <param name="init" type="Function" locid="WinJS.Promise_p:init">
            /// The function that is called during construction of the  promise. The function
            /// is given three arguments (complete, error, progress). Inside this function
            /// you should add event listeners for the notifications supported by this value.
            /// </param>
            /// <param name="oncancel" optional="true" locid="WinJS.Promise_p:oncancel">
            /// The function to call if a consumer of this promise wants
            /// to cancel its undone work. Promises are not required to
            /// support cancellation.
            /// </param>
            /// </signature>

            if (tagWithStack && (tagWithStack === true || (tagWithStack & tag.promise))) {
                this._stack = Promise._getStack();
            }

            this._oncancel = oncancel;
            this._setState(state_created);
            this._run();

            try {
                var complete = this._completed.bind(this);
                var error = this._error.bind(this);
                var progress = this._progress.bind(this);
                init(complete, error, progress);
            } catch (ex) {
                this._setExceptionValue(ex);
            }
        }, {
            _oncancel: null,

            _cancelAction: function () {
                // BEGIN monaco change
                try {
                    if (this._oncancel) {
                        this._oncancel();
                    } else {
                        throw new Error('Promise did not implement oncancel');
                    }
                } catch (ex) {
                    // Access fields to get them created
                    var msg = ex.message;
                    var stack = ex.stack;
                    promiseEventListeners.dispatchEvent('error', ex);
                }
                // END monaco change
            },
            _cleanupAction: function () { this._oncancel = null; }
        }, {

            addEventListener: function Promise_addEventListener(eventType, listener, capture) {
                /// <signature helpKeyword="WinJS.Promise.addEventListener">
                /// <summary locid="WinJS.Promise.addEventListener">
                /// Adds an event listener to the control.
                /// </summary>
                /// <param name="eventType" locid="WinJS.Promise.addEventListener_p:eventType">
                /// The type (name) of the event.
                /// </param>
                /// <param name="listener" locid="WinJS.Promise.addEventListener_p:listener">
                /// The listener to invoke when the event is raised.
                /// </param>
                /// <param name="capture" locid="WinJS.Promise.addEventListener_p:capture">
                /// Specifies whether or not to initiate capture.
                /// </param>
                /// </signature>
                promiseEventListeners.addEventListener(eventType, listener, capture);
            },
            any: function Promise_any(values) {
                /// <signature helpKeyword="WinJS.Promise.any">
                /// <summary locid="WinJS.Promise.any">
                /// Returns a promise that is fulfilled when one of the input promises
                /// has been fulfilled.
                /// </summary>
                /// <param name="values" type="Array" locid="WinJS.Promise.any_p:values">
                /// An array that contains promise objects or objects whose property
                /// values include promise objects.
                /// </param>
                /// <returns type="WinJS.Promise" locid="WinJS.Promise.any_returnValue">
                /// A promise that on fulfillment yields the value of the input (complete or error).
                /// </returns>
                /// </signature>
                return new Promise(
                    function (complete, error) {
                        var keys = Object.keys(values);
                        if (keys.length === 0) {
                            complete();
                        }
                        var canceled = 0;
                        keys.forEach(function (key) {
                            Promise.as(values[key]).then(
                                function () { complete({ key: key, value: values[key] }); },
                                function (e) {
                                    if (e instanceof Error && e.name === canceledName) {
                                        if ((++canceled) === keys.length) {
                                            complete(Promise.cancel);
                                        }
                                        return;
                                    }
                                    error({ key: key, value: values[key] });
                                }
                            );
                        });
                    },
                    function () {
                        var keys = Object.keys(values);
                        keys.forEach(function (key) {
                            var promise = Promise.as(values[key]);
                            if (typeof promise.cancel === "function") {
                                promise.cancel();
                            }
                        });
                    }
                );
            },
            as: function Promise_as(value) {
                /// <signature helpKeyword="WinJS.Promise.as">
                /// <summary locid="WinJS.Promise.as">
                /// Returns a promise. If the object is already a promise it is returned;
                /// otherwise the object is wrapped in a promise.
                /// </summary>
                /// <param name="value" locid="WinJS.Promise.as_p:value">
                /// The value to be treated as a promise.
                /// </param>
                /// <returns type="WinJS.Promise" locid="WinJS.Promise.as_returnValue">
                /// A promise.
                /// </returns>
                /// </signature>
                if (value && typeof value === "object" && typeof value.then === "function") {
                    return value;
                }
                return new CompletePromise(value);
            },
            /// <field type="WinJS.Promise" helpKeyword="WinJS.Promise.cancel" locid="WinJS.Promise.cancel">
            /// Canceled promise value, can be returned from a promise completion handler
            /// to indicate cancelation of the promise chain.
            /// </field>
            cancel: {
                get: function () {
                    return (staticCanceledPromise = staticCanceledPromise || new ErrorPromise(new _ErrorFromName(canceledName)));
                }
            },
            dispatchEvent: function Promise_dispatchEvent(eventType, details) {
                /// <signature helpKeyword="WinJS.Promise.dispatchEvent">
                /// <summary locid="WinJS.Promise.dispatchEvent">
                /// Raises an event of the specified type and properties.
                /// </summary>
                /// <param name="eventType" locid="WinJS.Promise.dispatchEvent_p:eventType">
                /// The type (name) of the event.
                /// </param>
                /// <param name="details" locid="WinJS.Promise.dispatchEvent_p:details">
                /// The set of additional properties to be attached to the event object.
                /// </param>
                /// <returns type="Boolean" locid="WinJS.Promise.dispatchEvent_returnValue">
                /// Specifies whether preventDefault was called on the event.
                /// </returns>
                /// </signature>
                return promiseEventListeners.dispatchEvent(eventType, details);
            },
            is: function Promise_is(value) {
                /// <signature helpKeyword="WinJS.Promise.is">
                /// <summary locid="WinJS.Promise.is">
                /// Determines whether a value fulfills the promise contract.
                /// </summary>
                /// <param name="value" locid="WinJS.Promise.is_p:value">
                /// A value that may be a promise.
                /// </param>
                /// <returns type="Boolean" locid="WinJS.Promise.is_returnValue">
                /// true if the specified value is a promise, otherwise false.
                /// </returns>
                /// </signature>
                return value && typeof value === "object" && typeof value.then === "function";
            },
            join: function Promise_join(values) {
                /// <signature helpKeyword="WinJS.Promise.join">
                /// <summary locid="WinJS.Promise.join">
                /// Creates a promise that is fulfilled when all the values are fulfilled.
                /// </summary>
                /// <param name="values" type="Object" locid="WinJS.Promise.join_p:values">
                /// An object whose fields contain values, some of which may be promises.
                /// </param>
                /// <returns type="WinJS.Promise" locid="WinJS.Promise.join_returnValue">
                /// A promise whose value is an object with the same field names as those of the object in the values parameter, where
                /// each field value is the fulfilled value of a promise.
                /// </returns>
                /// </signature>
                return new Promise(
                    function (complete, error, progress) {
                        var keys = Object.keys(values);
                        var errors = Array.isArray(values) ? [] : {};
                        var results = Array.isArray(values) ? [] : {};
                        var undefineds = 0;
                        var pending = keys.length;
                        var argDone = function (key) {
                            if ((--pending) === 0) {
                                var errorCount = Object.keys(errors).length;
                                if (errorCount === 0) {
                                    complete(results);
                                } else {
                                    var canceledCount = 0;
                                    keys.forEach(function (key) {
                                        var e = errors[key];
                                        if (e instanceof Error && e.name === canceledName) {
                                            canceledCount++;
                                        }
                                    });
                                    if (canceledCount === errorCount) {
                                        complete(Promise.cancel);
                                    } else {
                                        error(errors);
                                    }
                                }
                            } else {
                                progress({ Key: key, Done: true });
                            }
                        };
                        keys.forEach(function (key) {
                            var value = values[key];
                            if (value === undefined) {
                                undefineds++;
                            } else {
                                Promise.then(value,
                                    function (value) { results[key] = value; argDone(key); },
                                    function (value) { errors[key] = value; argDone(key); }
                                );
                            }
                        });
                        pending -= undefineds;
                        if (pending === 0) {
                            complete(results);
                            return;
                        }
                    },
                    function () {
                        Object.keys(values).forEach(function (key) {
                            var promise = Promise.as(values[key]);
                            if (typeof promise.cancel === "function") {
                                promise.cancel();
                            }
                        });
                    }
                );
            },
            removeEventListener: function Promise_removeEventListener(eventType, listener, capture) {
                /// <signature helpKeyword="WinJS.Promise.removeEventListener">
                /// <summary locid="WinJS.Promise.removeEventListener">
                /// Removes an event listener from the control.
                /// </summary>
                /// <param name='eventType' locid="WinJS.Promise.removeEventListener_eventType">
                /// The type (name) of the event.
                /// </param>
                /// <param name='listener' locid="WinJS.Promise.removeEventListener_listener">
                /// The listener to remove.
                /// </param>
                /// <param name='capture' locid="WinJS.Promise.removeEventListener_capture">
                /// Specifies whether or not to initiate capture.
                /// </param>
                /// </signature>
                promiseEventListeners.removeEventListener(eventType, listener, capture);
            },
            supportedForProcessing: false,
            then: function Promise_then(value, onComplete, onError, onProgress) {
                /// <signature helpKeyword="WinJS.Promise.then">
                /// <summary locid="WinJS.Promise.then">
                /// A static version of the promise instance method then().
                /// </summary>
                /// <param name="value" locid="WinJS.Promise.then_p:value">
                /// the value to be treated as a promise.
                /// </param>
                /// <param name="onComplete" type="Function" locid="WinJS.Promise.then_p:complete">
                /// The function to be called if the promise is fulfilled with a value.
                /// If it is null, the promise simply
                /// returns the value. The value is passed as the single argument.
                /// </param>
                /// <param name="onError" type="Function" optional="true" locid="WinJS.Promise.then_p:error">
                /// The function to be called if the promise is fulfilled with an error. The error
                /// is passed as the single argument.
                /// </param>
                /// <param name="onProgress" type="Function" optional="true" locid="WinJS.Promise.then_p:progress">
                /// The function to be called if the promise reports progress. Data about the progress
                /// is passed as the single argument. Promises are not required to support
                /// progress.
                /// </param>
                /// <returns type="WinJS.Promise" locid="WinJS.Promise.then_returnValue">
                /// A promise whose value is the result of executing the provided complete function.
                /// </returns>
                /// </signature>
                return Promise.as(value).then(onComplete, onError, onProgress);
            },
            thenEach: function Promise_thenEach(values, onComplete, onError, onProgress) {
                /// <signature helpKeyword="WinJS.Promise.thenEach">
                /// <summary locid="WinJS.Promise.thenEach">
                /// Performs an operation on all the input promises and returns a promise
                /// that has the shape of the input and contains the result of the operation
                /// that has been performed on each input.
                /// </summary>
                /// <param name="values" locid="WinJS.Promise.thenEach_p:values">
                /// A set of values (which could be either an array or an object) of which some or all are promises.
                /// </param>
                /// <param name="onComplete" type="Function" locid="WinJS.Promise.thenEach_p:complete">
                /// The function to be called if the promise is fulfilled with a value.
                /// If the value is null, the promise returns the value.
                /// The value is passed as the single argument.
                /// </param>
                /// <param name="onError" type="Function" optional="true" locid="WinJS.Promise.thenEach_p:error">
                /// The function to be called if the promise is fulfilled with an error. The error
                /// is passed as the single argument.
                /// </param>
                /// <param name="onProgress" type="Function" optional="true" locid="WinJS.Promise.thenEach_p:progress">
                /// The function to be called if the promise reports progress. Data about the progress
                /// is passed as the single argument. Promises are not required to support
                /// progress.
                /// </param>
                /// <returns type="WinJS.Promise" locid="WinJS.Promise.thenEach_returnValue">
                /// A promise that is the result of calling Promise.join on the values parameter.
                /// </returns>
                /// </signature>
                var result = Array.isArray(values) ? [] : {};
                Object.keys(values).forEach(function (key) {
                    result[key] = Promise.as(values[key]).then(onComplete, onError, onProgress);
                });
                return Promise.join(result);
            },
            timeout: function Promise_timeout(time, promise) {
                /// <signature helpKeyword="WinJS.Promise.timeout">
                /// <summary locid="WinJS.Promise.timeout">
                /// Creates a promise that is fulfilled after a timeout.
                /// </summary>
                /// <param name="timeout" type="Number" optional="true" locid="WinJS.Promise.timeout_p:timeout">
                /// The timeout period in milliseconds. If this value is zero or not specified
                /// setImmediate is called, otherwise setTimeout is called.
                /// </param>
                /// <param name="promise" type="Promise" optional="true" locid="WinJS.Promise.timeout_p:promise">
                /// A promise that will be canceled if it doesn't complete before the
                /// timeout has expired.
                /// </param>
                /// <returns type="WinJS.Promise" locid="WinJS.Promise.timeout_returnValue">
                /// A promise that is completed asynchronously after the specified timeout.
                /// </returns>
                /// </signature>
                var to = timeout(time);
                return promise ? timeoutWithPromise(to, promise) : to;
            },
            wrap: function Promise_wrap(value) {
                /// <signature helpKeyword="WinJS.Promise.wrap">
                /// <summary locid="WinJS.Promise.wrap">
                /// Wraps a non-promise value in a promise. You can use this function if you need
                /// to pass a value to a function that requires a promise.
                /// </summary>
                /// <param name="value" locid="WinJS.Promise.wrap_p:value">
                /// Some non-promise value to be wrapped in a promise.
                /// </param>
                /// <returns type="WinJS.Promise" locid="WinJS.Promise.wrap_returnValue">
                /// A promise that is successfully fulfilled with the specified value
                /// </returns>
                /// </signature>
                return new CompletePromise(value);
            },
            wrapError: function Promise_wrapError(error) {
                /// <signature helpKeyword="WinJS.Promise.wrapError">
                /// <summary locid="WinJS.Promise.wrapError">
                /// Wraps a non-promise error value in a promise. You can use this function if you need
                /// to pass an error to a function that requires a promise.
                /// </summary>
                /// <param name="error" locid="WinJS.Promise.wrapError_p:error">
                /// A non-promise error value to be wrapped in a promise.
                /// </param>
                /// <returns type="WinJS.Promise" locid="WinJS.Promise.wrapError_returnValue">
                /// A promise that is in an error state with the specified value.
                /// </returns>
                /// </signature>
                return new ErrorPromise(error);
            },

            _veryExpensiveTagWithStack: {
                get: function () { return tagWithStack; },
                set: function (value) { tagWithStack = value; }
            },
            _veryExpensiveTagWithStack_tag: tag,
            _getStack: function () {
                if (_Global.Debug && _Global.Debug.debuggerEnabled) {
                    try { throw new Error(); } catch (e) { return e.stack; }
                }
            },

            _cancelBlocker: function Promise__cancelBlocker(input, oncancel) {
                //
                // Returns a promise which on cancelation will still result in downstream cancelation while
                //  protecting the promise 'input' from being  canceled which has the effect of allowing
                //  'input' to be shared amoung various consumers.
                //
                if (!Promise.is(input)) {
                    return Promise.wrap(input);
                }
                var complete;
                var error;
                var output = new Promise(
                    function (c, e) {
                        complete = c;
                        error = e;
                    },
                    function () {
                        complete = null;
                        error = null;
                        oncancel && oncancel();
                    }
                );
                input.then(
                    function (v) { complete && complete(v); },
                    function (e) { error && error(e); }
                );
                return output;
            },

        }
    );
    Object.defineProperties(Promise, _Events.createEventProperties(errorET));

    Promise._doneHandler = function (value) {
        _BaseCoreUtils._setImmediate(function Promise_done_rethrow() {
            throw value;
        });
    };

    return {
        PromiseStateMachine: PromiseStateMachine,
        Promise: Promise,
        state_created: state_created
    };
});

_winjs("WinJS/Promise", ["WinJS/Core/_Base","WinJS/Promise/_StateMachine"], function promiseInit( _Base, _StateMachine) {
    "use strict";

    _Base.Namespace.define("WinJS", {
        Promise: _StateMachine.Promise
    });

    return _StateMachine.Promise;
});

__winjs_exports = _modules["WinJS/Core/_WinJS"];
__winjs_exports.TPromise = __winjs_exports.Promise;
__winjs_exports.PPromise = __winjs_exports.Promise;

// ESM-comment-begin
if (typeof exports === 'undefined' && typeof define === 'function' && define.amd) {
    define("vs/base/common/winjs.base", [], __winjs_exports);
} else {
    module.exports = __winjs_exports;
}
// ESM-comment-end

})();

// ESM-uncomment-begin
// export var Promise = __winjs_exports.Promise;
// export var TPromise = __winjs_exports.TPromise;
// export var PPromise = __winjs_exports.PPromise;
// ESM-uncomment-end

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[11/*vs/base/common/errors*/], __M([0/*require*/,1/*exports*/,53/*vs/base/common/winjs.base*/]), function (require, exports, winjs_base_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    // ------ BEGIN Hook up error listeners to winjs promises
    var outstandingPromiseErrors = {};
    function promiseErrorHandler(e) {
        //
        // e.detail looks like: { exception, error, promise, handler, id, parent }
        //
        var details = e.detail;
        var id = details.id;
        // If the error has a parent promise then this is not the origination of the
        //  error so we check if it has a handler, and if so we mark that the error
        //  was handled by removing it from outstandingPromiseErrors
        //
        if (details.parent) {
            if (details.handler && outstandingPromiseErrors) {
                delete outstandingPromiseErrors[id];
            }
            return;
        }
        // Indicate that this error was originated and needs to be handled
        outstandingPromiseErrors[id] = details;
        // The first time the queue fills up this iteration, schedule a timeout to
        // check if any errors are still unhandled.
        if (Object.keys(outstandingPromiseErrors).length === 1) {
            setTimeout(function () {
                var errors = outstandingPromiseErrors;
                outstandingPromiseErrors = {};
                Object.keys(errors).forEach(function (errorId) {
                    var error = errors[errorId];
                    if (error.exception) {
                        onUnexpectedError(error.exception);
                    }
                    else if (error.error) {
                        onUnexpectedError(error.error);
                    }
                    console.log('WARNING: Promise with no error callback:' + error.id);
                    console.log(error);
                    if (error.exception) {
                        console.log(error.exception.stack);
                    }
                });
            }, 0);
        }
    }
    winjs_base_1.TPromise.addEventListener('error', promiseErrorHandler);
    // Avoid circular dependency on EventEmitter by implementing a subset of the interface.
    var ErrorHandler = /** @class */ (function () {
        function ErrorHandler() {
            this.listeners = [];
            this.unexpectedErrorHandler = function (e) {
                setTimeout(function () {
                    if (e.stack) {
                        throw new Error(e.message + '\n\n' + e.stack);
                    }
                    throw e;
                }, 0);
            };
        }
        ErrorHandler.prototype.emit = function (e) {
            this.listeners.forEach(function (listener) {
                listener(e);
            });
        };
        ErrorHandler.prototype.onUnexpectedError = function (e) {
            this.unexpectedErrorHandler(e);
            this.emit(e);
        };
        // For external errors, we don't want the listeners to be called
        ErrorHandler.prototype.onUnexpectedExternalError = function (e) {
            this.unexpectedErrorHandler(e);
        };
        return ErrorHandler;
    }());
    exports.ErrorHandler = ErrorHandler;
    exports.errorHandler = new ErrorHandler();
    function onUnexpectedError(e) {
        // ignore errors from cancelled promises
        if (!isPromiseCanceledError(e)) {
            exports.errorHandler.onUnexpectedError(e);
        }
        return undefined;
    }
    exports.onUnexpectedError = onUnexpectedError;
    function onUnexpectedExternalError(e) {
        // ignore errors from cancelled promises
        if (!isPromiseCanceledError(e)) {
            exports.errorHandler.onUnexpectedExternalError(e);
        }
        return undefined;
    }
    exports.onUnexpectedExternalError = onUnexpectedExternalError;
    function transformErrorForSerialization(error) {
        if (error instanceof Error) {
            var name_1 = error.name, message = error.message;
            var stack = error.stacktrace || error.stack;
            return {
                $isError: true,
                name: name_1,
                message: message,
                stack: stack
            };
        }
        // return as is
        return error;
    }
    exports.transformErrorForSerialization = transformErrorForSerialization;
    var canceledName = 'Canceled';
    /**
     * Checks if the given error is a promise in canceled state
     */
    function isPromiseCanceledError(error) {
        return error instanceof Error && error.name === canceledName && error.message === canceledName;
    }
    exports.isPromiseCanceledError = isPromiseCanceledError;
    /**
     * Returns an error that signals cancellation.
     */
    function canceled() {
        var error = new Error(canceledName);
        error.name = error.message;
        return error;
    }
    exports.canceled = canceled;
    function illegalArgument(name) {
        if (name) {
            return new Error("Illegal argument: " + name);
        }
        else {
            return new Error('Illegal argument');
        }
    }
    exports.illegalArgument = illegalArgument;
    function illegalState(name) {
        if (name) {
            return new Error("Illegal state: " + name);
        }
        else {
            return new Error('Illegal state');
        }
    }
    exports.illegalState = illegalState;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[6/*vs/base/common/event*/], __M([0/*require*/,1/*exports*/,11/*vs/base/common/errors*/,414/*vs/base/common/functional*/,2/*vs/base/common/lifecycle*/,160/*vs/base/common/linkedList*/]), function (require, exports, errors_1, functional_1, lifecycle_1, linkedList_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Event;
    (function (Event) {
        var _disposable = { dispose: function () { } };
        Event.None = function () { return _disposable; };
    })(Event = exports.Event || (exports.Event = {}));
    /**
     * The Emitter can be used to expose an Event to the public
     * to fire it from the insides.
     * Sample:
        class Document {
    
            private _onDidChange = new Emitter<(value:string)=>any>();
    
            public onDidChange = this._onDidChange.event;
    
            // getter-style
            // get onDidChange(): Event<(value:string)=>any> {
            // 	return this._onDidChange.event;
            // }
    
            private _doIt() {
                //...
                this._onDidChange.fire(value);
            }
        }
     */
    var Emitter = /** @class */ (function () {
        function Emitter(_options) {
            if (_options === void 0) { _options = null; }
            this._options = _options;
            this._event = null;
            this._disposed = false;
            this._deliveryQueue = null;
            this._listeners = null;
        }
        Object.defineProperty(Emitter.prototype, "event", {
            /**
             * For the public to allow to subscribe
             * to events from this Emitter
             */
            get: function () {
                var _this = this;
                if (!this._event) {
                    this._event = function (listener, thisArgs, disposables) {
                        if (!_this._listeners) {
                            _this._listeners = new linkedList_1.LinkedList();
                        }
                        var firstListener = _this._listeners.isEmpty();
                        if (firstListener && _this._options && _this._options.onFirstListenerAdd) {
                            _this._options.onFirstListenerAdd(_this);
                        }
                        var remove = _this._listeners.push(!thisArgs ? listener : [listener, thisArgs]);
                        if (firstListener && _this._options && _this._options.onFirstListenerDidAdd) {
                            _this._options.onFirstListenerDidAdd(_this);
                        }
                        if (_this._options && _this._options.onListenerDidAdd) {
                            _this._options.onListenerDidAdd(_this, listener, thisArgs);
                        }
                        var result;
                        result = {
                            dispose: function () {
                                result.dispose = Emitter._noop;
                                if (!_this._disposed) {
                                    remove();
                                    if (_this._options && _this._options.onLastListenerRemove) {
                                        var hasListeners = (_this._listeners && !_this._listeners.isEmpty());
                                        if (!hasListeners) {
                                            _this._options.onLastListenerRemove(_this);
                                        }
                                    }
                                }
                            }
                        };
                        if (Array.isArray(disposables)) {
                            disposables.push(result);
                        }
                        return result;
                    };
                }
                return this._event;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * To be kept private to fire an event to
         * subscribers
         */
        Emitter.prototype.fire = function (event) {
            if (this._listeners) {
                // put all [listener,event]-pairs into delivery queue
                // then emit all event. an inner/nested event might be
                // the driver of this
                if (!this._deliveryQueue) {
                    this._deliveryQueue = [];
                }
                for (var iter = this._listeners.iterator(), e = iter.next(); !e.done; e = iter.next()) {
                    this._deliveryQueue.push([e.value, event]);
                }
                while (this._deliveryQueue.length > 0) {
                    var _a = this._deliveryQueue.shift(), listener = _a[0], event_1 = _a[1];
                    try {
                        if (typeof listener === 'function') {
                            listener.call(undefined, event_1);
                        }
                        else {
                            listener[0].call(listener[1], event_1);
                        }
                    }
                    catch (e) {
                        errors_1.onUnexpectedError(e);
                    }
                }
            }
        };
        Emitter.prototype.dispose = function () {
            if (this._listeners) {
                this._listeners = null;
            }
            if (this._deliveryQueue) {
                this._deliveryQueue.length = 0;
            }
            this._disposed = true;
        };
        Emitter._noop = function () { };
        return Emitter;
    }());
    exports.Emitter = Emitter;
    var EventMultiplexer = /** @class */ (function () {
        function EventMultiplexer() {
            var _this = this;
            this.hasListeners = false;
            this.events = [];
            this.emitter = new Emitter({
                onFirstListenerAdd: function () { return _this.onFirstListenerAdd(); },
                onLastListenerRemove: function () { return _this.onLastListenerRemove(); }
            });
        }
        Object.defineProperty(EventMultiplexer.prototype, "event", {
            get: function () {
                return this.emitter.event;
            },
            enumerable: true,
            configurable: true
        });
        EventMultiplexer.prototype.add = function (event) {
            var _this = this;
            var e = { event: event, listener: null };
            this.events.push(e);
            if (this.hasListeners) {
                this.hook(e);
            }
            var dispose = function () {
                if (_this.hasListeners) {
                    _this.unhook(e);
                }
                var idx = _this.events.indexOf(e);
                _this.events.splice(idx, 1);
            };
            return lifecycle_1.toDisposable(functional_1.once(dispose));
        };
        EventMultiplexer.prototype.onFirstListenerAdd = function () {
            var _this = this;
            this.hasListeners = true;
            this.events.forEach(function (e) { return _this.hook(e); });
        };
        EventMultiplexer.prototype.onLastListenerRemove = function () {
            var _this = this;
            this.hasListeners = false;
            this.events.forEach(function (e) { return _this.unhook(e); });
        };
        EventMultiplexer.prototype.hook = function (e) {
            var _this = this;
            e.listener = e.event(function (r) { return _this.emitter.fire(r); });
        };
        EventMultiplexer.prototype.unhook = function (e) {
            if (e.listener) {
                e.listener.dispose();
            }
            e.listener = null;
        };
        EventMultiplexer.prototype.dispose = function () {
            this.emitter.dispose();
        };
        return EventMultiplexer;
    }());
    exports.EventMultiplexer = EventMultiplexer;
    function once(event) {
        return function (listener, thisArgs, disposables) {
            if (thisArgs === void 0) { thisArgs = null; }
            // we need this, in case the event fires during the listener call
            var didFire = false;
            var result = event(function (e) {
                if (didFire) {
                    return;
                }
                else if (result) {
                    result.dispose();
                }
                else {
                    didFire = true;
                }
                return listener.call(thisArgs, e);
            }, null, disposables);
            if (didFire) {
                result.dispose();
            }
            return result;
        };
    }
    exports.once = once;
    function anyEvent() {
        var events = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            events[_i] = arguments[_i];
        }
        return function (listener, thisArgs, disposables) {
            if (thisArgs === void 0) { thisArgs = null; }
            return lifecycle_1.combinedDisposable(events.map(function (event) { return event(function (e) { return listener.call(thisArgs, e); }, null, disposables); }));
        };
    }
    exports.anyEvent = anyEvent;
    function debounceEvent(event, merger, delay, leading) {
        if (delay === void 0) { delay = 100; }
        if (leading === void 0) { leading = false; }
        var subscription;
        var output = undefined;
        var handle = undefined;
        var numDebouncedCalls = 0;
        var emitter = new Emitter({
            onFirstListenerAdd: function () {
                subscription = event(function (cur) {
                    numDebouncedCalls++;
                    output = merger(output, cur);
                    if (leading && !handle) {
                        emitter.fire(output);
                    }
                    clearTimeout(handle);
                    handle = setTimeout(function () {
                        var _output = output;
                        output = undefined;
                        handle = undefined;
                        if (!leading || numDebouncedCalls > 1) {
                            emitter.fire(_output);
                        }
                        numDebouncedCalls = 0;
                    }, delay);
                });
            },
            onLastListenerRemove: function () {
                subscription.dispose();
            }
        });
        return emitter.event;
    }
    exports.debounceEvent = debounceEvent;
    /**
     * The EventDelayer is useful in situations in which you want
     * to delay firing your events during some code.
     * You can wrap that code and be sure that the event will not
     * be fired during that wrap.
     *
     * ```
     * const emitter: Emitter;
     * const delayer = new EventDelayer();
     * const delayedEvent = delayer.wrapEvent(emitter.event);
     *
     * delayedEvent(console.log);
     *
     * delayer.bufferEvents(() => {
     *   emitter.fire(); // event will not be fired yet
     * });
     *
     * // event will only be fired at this point
     * ```
     */
    var EventBufferer = /** @class */ (function () {
        function EventBufferer() {
            this.buffers = [];
        }
        EventBufferer.prototype.wrapEvent = function (event) {
            var _this = this;
            return function (listener, thisArgs, disposables) {
                return event(function (i) {
                    var buffer = _this.buffers[_this.buffers.length - 1];
                    if (buffer) {
                        buffer.push(function () { return listener.call(thisArgs, i); });
                    }
                    else {
                        listener.call(thisArgs, i);
                    }
                }, void 0, disposables);
            };
        };
        EventBufferer.prototype.bufferEvents = function (fn) {
            var buffer = [];
            this.buffers.push(buffer);
            var r = fn();
            this.buffers.pop();
            buffer.forEach(function (flush) { return flush(); });
            return r;
        };
        return EventBufferer;
    }());
    exports.EventBufferer = EventBufferer;
    function mapEvent(event, map) {
        return function (listener, thisArgs, disposables) {
            if (thisArgs === void 0) { thisArgs = null; }
            return event(function (i) { return listener.call(thisArgs, map(i)); }, null, disposables);
        };
    }
    exports.mapEvent = mapEvent;
    function filterEvent(event, filter) {
        return function (listener, thisArgs, disposables) {
            if (thisArgs === void 0) { thisArgs = null; }
            return event(function (e) { return filter(e) && listener.call(thisArgs, e); }, null, disposables);
        };
    }
    exports.filterEvent = filterEvent;
    var ChainableEvent = /** @class */ (function () {
        function ChainableEvent(_event) {
            this._event = _event;
        }
        Object.defineProperty(ChainableEvent.prototype, "event", {
            get: function () { return this._event; },
            enumerable: true,
            configurable: true
        });
        ChainableEvent.prototype.map = function (fn) {
            return new ChainableEvent(mapEvent(this._event, fn));
        };
        ChainableEvent.prototype.filter = function (fn) {
            return new ChainableEvent(filterEvent(this._event, fn));
        };
        ChainableEvent.prototype.on = function (listener, thisArgs, disposables) {
            return this._event(listener, thisArgs, disposables);
        };
        return ChainableEvent;
    }());
    function chain(event) {
        return new ChainableEvent(event);
    }
    exports.chain = chain;
    var Relay = /** @class */ (function () {
        function Relay() {
            var _this = this;
            this.listening = false;
            this.inputEvent = Event.None;
            this.inputEventListener = lifecycle_1.Disposable.None;
            this.emitter = new Emitter({
                onFirstListenerDidAdd: function () {
                    _this.listening = true;
                    _this.inputEventListener = _this.inputEvent(_this.emitter.fire, _this.emitter);
                },
                onLastListenerRemove: function () {
                    _this.listening = false;
                    _this.inputEventListener.dispose();
                }
            });
            this.event = this.emitter.event;
        }
        Object.defineProperty(Relay.prototype, "input", {
            set: function (event) {
                this.inputEvent = event;
                if (this.listening) {
                    this.inputEventListener.dispose();
                    this.inputEventListener = event(this.emitter.fire, this.emitter);
                }
            },
            enumerable: true,
            configurable: true
        });
        Relay.prototype.dispose = function () {
            this.inputEventListener.dispose();
            this.emitter.dispose();
        };
        return Relay;
    }());
    exports.Relay = Relay;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[29/*vs/base/browser/browser*/], __M([0/*require*/,1/*exports*/,6/*vs/base/common/event*/]), function (require, exports, event_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var WindowManager = /** @class */ (function () {
        function WindowManager() {
            // --- Zoom Level
            this._zoomLevel = 0;
            this._lastZoomLevelChangeTime = 0;
            this._onDidChangeZoomLevel = new event_1.Emitter();
            this.onDidChangeZoomLevel = this._onDidChangeZoomLevel.event;
            // --- Accessibility
            this._accessibilitySupport = 0 /* Unknown */;
            this._onDidChangeAccessibilitySupport = new event_1.Emitter();
            this.onDidChangeAccessibilitySupport = this._onDidChangeAccessibilitySupport.event;
        }
        WindowManager.prototype.getZoomLevel = function () {
            return this._zoomLevel;
        };
        WindowManager.prototype.getTimeSinceLastZoomLevelChanged = function () {
            return Date.now() - this._lastZoomLevelChangeTime;
        };
        // --- Pixel Ratio
        WindowManager.prototype.getPixelRatio = function () {
            var ctx = document.createElement('canvas').getContext('2d');
            var dpr = window.devicePixelRatio || 1;
            var bsr = ctx.webkitBackingStorePixelRatio ||
                ctx.mozBackingStorePixelRatio ||
                ctx.msBackingStorePixelRatio ||
                ctx.oBackingStorePixelRatio ||
                ctx.backingStorePixelRatio || 1;
            return dpr / bsr;
        };
        WindowManager.prototype.getAccessibilitySupport = function () {
            return this._accessibilitySupport;
        };
        WindowManager.INSTANCE = new WindowManager();
        return WindowManager;
    }());
    function getZoomLevel() {
        return WindowManager.INSTANCE.getZoomLevel();
    }
    exports.getZoomLevel = getZoomLevel;
    /** Returns the time (in ms) since the zoom level was changed */
    function getTimeSinceLastZoomLevelChanged() {
        return WindowManager.INSTANCE.getTimeSinceLastZoomLevelChanged();
    }
    exports.getTimeSinceLastZoomLevelChanged = getTimeSinceLastZoomLevelChanged;
    function onDidChangeZoomLevel(callback) {
        return WindowManager.INSTANCE.onDidChangeZoomLevel(callback);
    }
    exports.onDidChangeZoomLevel = onDidChangeZoomLevel;
    function getPixelRatio() {
        return WindowManager.INSTANCE.getPixelRatio();
    }
    exports.getPixelRatio = getPixelRatio;
    function getAccessibilitySupport() {
        return WindowManager.INSTANCE.getAccessibilitySupport();
    }
    exports.getAccessibilitySupport = getAccessibilitySupport;
    function onDidChangeAccessibilitySupport(callback) {
        return WindowManager.INSTANCE.onDidChangeAccessibilitySupport(callback);
    }
    exports.onDidChangeAccessibilitySupport = onDidChangeAccessibilitySupport;
    var userAgent = navigator.userAgent;
    exports.isIE = (userAgent.indexOf('Trident') >= 0);
    exports.isEdge = (userAgent.indexOf('Edge/') >= 0);
    exports.isEdgeOrIE = exports.isIE || exports.isEdge;
    exports.isFirefox = (userAgent.indexOf('Firefox') >= 0);
    exports.isWebKit = (userAgent.indexOf('AppleWebKit') >= 0);
    exports.isChrome = (userAgent.indexOf('Chrome') >= 0);
    exports.isSafari = (userAgent.indexOf('Chrome') === -1) && (userAgent.indexOf('Safari') >= 0);
    exports.isIPad = (userAgent.indexOf('iPad') >= 0);
    exports.isEdgeWebView = exports.isEdge && (userAgent.indexOf('WebView/') >= 0);
    function hasClipboardSupport() {
        if (exports.isIE) {
            return false;
        }
        if (exports.isEdge) {
            var index = userAgent.indexOf('Edge/');
            var version = parseInt(userAgent.substring(index + 5, userAgent.indexOf('.', index)), 10);
            if (!version || (version >= 12 && version <= 16)) {
                return false;
            }
        }
        return true;
    }
    exports.hasClipboardSupport = hasClipboardSupport;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[72/*vs/base/browser/event*/], __M([0/*require*/,1/*exports*/,6/*vs/base/common/event*/]), function (require, exports, event_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.domEvent = function (element, type, useCapture) {
        var fn = function (e) { return emitter.fire(e); };
        var emitter = new event_1.Emitter({
            onFirstListenerAdd: function () {
                element.addEventListener(type, fn, useCapture);
            },
            onLastListenerRemove: function () {
                element.removeEventListener(type, fn, useCapture);
            }
        });
        return emitter.event;
    };
    function stop(event) {
        return event_1.mapEvent(event, function (e) {
            e.preventDefault();
            e.stopPropagation();
            return e;
        });
    }
    exports.stop = stop;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[52/*vs/base/browser/keyboardEvent*/], __M([0/*require*/,1/*exports*/,29/*vs/base/browser/browser*/,36/*vs/base/common/keyCodes*/,17/*vs/base/common/platform*/]), function (require, exports, browser, keyCodes_1, platform) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var KEY_CODE_MAP = new Array(230);
    var INVERSE_KEY_CODE_MAP = new Array(112 /* MAX_VALUE */);
    (function () {
        for (var i = 0; i < INVERSE_KEY_CODE_MAP.length; i++) {
            INVERSE_KEY_CODE_MAP[i] = -1;
        }
        function define(code, keyCode) {
            KEY_CODE_MAP[code] = keyCode;
            INVERSE_KEY_CODE_MAP[keyCode] = code;
        }
        define(3, 7 /* PauseBreak */); // VK_CANCEL 0x03 Control-break processing
        define(8, 1 /* Backspace */);
        define(9, 2 /* Tab */);
        define(13, 3 /* Enter */);
        define(16, 4 /* Shift */);
        define(17, 5 /* Ctrl */);
        define(18, 6 /* Alt */);
        define(19, 7 /* PauseBreak */);
        define(20, 8 /* CapsLock */);
        define(27, 9 /* Escape */);
        define(32, 10 /* Space */);
        define(33, 11 /* PageUp */);
        define(34, 12 /* PageDown */);
        define(35, 13 /* End */);
        define(36, 14 /* Home */);
        define(37, 15 /* LeftArrow */);
        define(38, 16 /* UpArrow */);
        define(39, 17 /* RightArrow */);
        define(40, 18 /* DownArrow */);
        define(45, 19 /* Insert */);
        define(46, 20 /* Delete */);
        define(48, 21 /* KEY_0 */);
        define(49, 22 /* KEY_1 */);
        define(50, 23 /* KEY_2 */);
        define(51, 24 /* KEY_3 */);
        define(52, 25 /* KEY_4 */);
        define(53, 26 /* KEY_5 */);
        define(54, 27 /* KEY_6 */);
        define(55, 28 /* KEY_7 */);
        define(56, 29 /* KEY_8 */);
        define(57, 30 /* KEY_9 */);
        define(65, 31 /* KEY_A */);
        define(66, 32 /* KEY_B */);
        define(67, 33 /* KEY_C */);
        define(68, 34 /* KEY_D */);
        define(69, 35 /* KEY_E */);
        define(70, 36 /* KEY_F */);
        define(71, 37 /* KEY_G */);
        define(72, 38 /* KEY_H */);
        define(73, 39 /* KEY_I */);
        define(74, 40 /* KEY_J */);
        define(75, 41 /* KEY_K */);
        define(76, 42 /* KEY_L */);
        define(77, 43 /* KEY_M */);
        define(78, 44 /* KEY_N */);
        define(79, 45 /* KEY_O */);
        define(80, 46 /* KEY_P */);
        define(81, 47 /* KEY_Q */);
        define(82, 48 /* KEY_R */);
        define(83, 49 /* KEY_S */);
        define(84, 50 /* KEY_T */);
        define(85, 51 /* KEY_U */);
        define(86, 52 /* KEY_V */);
        define(87, 53 /* KEY_W */);
        define(88, 54 /* KEY_X */);
        define(89, 55 /* KEY_Y */);
        define(90, 56 /* KEY_Z */);
        define(93, 58 /* ContextMenu */);
        define(96, 93 /* NUMPAD_0 */);
        define(97, 94 /* NUMPAD_1 */);
        define(98, 95 /* NUMPAD_2 */);
        define(99, 96 /* NUMPAD_3 */);
        define(100, 97 /* NUMPAD_4 */);
        define(101, 98 /* NUMPAD_5 */);
        define(102, 99 /* NUMPAD_6 */);
        define(103, 100 /* NUMPAD_7 */);
        define(104, 101 /* NUMPAD_8 */);
        define(105, 102 /* NUMPAD_9 */);
        define(106, 103 /* NUMPAD_MULTIPLY */);
        define(107, 104 /* NUMPAD_ADD */);
        define(108, 105 /* NUMPAD_SEPARATOR */);
        define(109, 106 /* NUMPAD_SUBTRACT */);
        define(110, 107 /* NUMPAD_DECIMAL */);
        define(111, 108 /* NUMPAD_DIVIDE */);
        define(112, 59 /* F1 */);
        define(113, 60 /* F2 */);
        define(114, 61 /* F3 */);
        define(115, 62 /* F4 */);
        define(116, 63 /* F5 */);
        define(117, 64 /* F6 */);
        define(118, 65 /* F7 */);
        define(119, 66 /* F8 */);
        define(120, 67 /* F9 */);
        define(121, 68 /* F10 */);
        define(122, 69 /* F11 */);
        define(123, 70 /* F12 */);
        define(124, 71 /* F13 */);
        define(125, 72 /* F14 */);
        define(126, 73 /* F15 */);
        define(127, 74 /* F16 */);
        define(128, 75 /* F17 */);
        define(129, 76 /* F18 */);
        define(130, 77 /* F19 */);
        define(144, 78 /* NumLock */);
        define(145, 79 /* ScrollLock */);
        define(186, 80 /* US_SEMICOLON */);
        define(187, 81 /* US_EQUAL */);
        define(188, 82 /* US_COMMA */);
        define(189, 83 /* US_MINUS */);
        define(190, 84 /* US_DOT */);
        define(191, 85 /* US_SLASH */);
        define(192, 86 /* US_BACKTICK */);
        define(193, 110 /* ABNT_C1 */);
        define(194, 111 /* ABNT_C2 */);
        define(219, 87 /* US_OPEN_SQUARE_BRACKET */);
        define(220, 88 /* US_BACKSLASH */);
        define(221, 89 /* US_CLOSE_SQUARE_BRACKET */);
        define(222, 90 /* US_QUOTE */);
        define(223, 91 /* OEM_8 */);
        define(226, 92 /* OEM_102 */);
        /**
         * https://lists.w3.org/Archives/Public/www-dom/2010JulSep/att-0182/keyCode-spec.html
         * If an Input Method Editor is processing key input and the event is keydown, return 229.
         */
        define(229, 109 /* KEY_IN_COMPOSITION */);
        if (browser.isIE) {
            define(91, 57 /* Meta */);
        }
        else if (browser.isFirefox) {
            define(59, 80 /* US_SEMICOLON */);
            define(107, 81 /* US_EQUAL */);
            define(109, 83 /* US_MINUS */);
            if (platform.isMacintosh) {
                define(224, 57 /* Meta */);
            }
        }
        else if (browser.isWebKit) {
            define(91, 57 /* Meta */);
            if (platform.isMacintosh) {
                // the two meta keys in the Mac have different key codes (91 and 93)
                define(93, 57 /* Meta */);
            }
            else {
                define(92, 57 /* Meta */);
            }
        }
    })();
    function extractKeyCode(e) {
        if (e.charCode) {
            // "keypress" events mostly
            var char = String.fromCharCode(e.charCode).toUpperCase();
            return keyCodes_1.KeyCodeUtils.fromString(char);
        }
        return KEY_CODE_MAP[e.keyCode] || 0 /* Unknown */;
    }
    var ctrlKeyMod = (platform.isMacintosh ? 256 /* WinCtrl */ : 2048 /* CtrlCmd */);
    var altKeyMod = 512 /* Alt */;
    var shiftKeyMod = 1024 /* Shift */;
    var metaKeyMod = (platform.isMacintosh ? 2048 /* CtrlCmd */ : 256 /* WinCtrl */);
    var StandardKeyboardEvent = /** @class */ (function () {
        function StandardKeyboardEvent(source) {
            var e = source;
            this.browserEvent = e;
            this.target = e.target;
            this.ctrlKey = e.ctrlKey;
            this.shiftKey = e.shiftKey;
            this.altKey = e.altKey;
            this.metaKey = e.metaKey;
            this.keyCode = extractKeyCode(e);
            this.code = e.code;
            // console.info(e.type + ": keyCode: " + e.keyCode + ", which: " + e.which + ", charCode: " + e.charCode + ", detail: " + e.detail + " ====> " + this.keyCode + ' -- ' + KeyCode[this.keyCode]);
            this.ctrlKey = this.ctrlKey || this.keyCode === 5 /* Ctrl */;
            this.altKey = this.altKey || this.keyCode === 6 /* Alt */;
            this.shiftKey = this.shiftKey || this.keyCode === 4 /* Shift */;
            this.metaKey = this.metaKey || this.keyCode === 57 /* Meta */;
            this._asKeybinding = this._computeKeybinding();
            this._asRuntimeKeybinding = this._computeRuntimeKeybinding();
            // console.log(`code: ${e.code}, keyCode: ${e.keyCode}, key: ${e.key}`);
        }
        StandardKeyboardEvent.prototype.preventDefault = function () {
            if (this.browserEvent && this.browserEvent.preventDefault) {
                this.browserEvent.preventDefault();
            }
        };
        StandardKeyboardEvent.prototype.stopPropagation = function () {
            if (this.browserEvent && this.browserEvent.stopPropagation) {
                this.browserEvent.stopPropagation();
            }
        };
        StandardKeyboardEvent.prototype.toKeybinding = function () {
            return this._asRuntimeKeybinding;
        };
        StandardKeyboardEvent.prototype.equals = function (other) {
            return this._asKeybinding === other;
        };
        StandardKeyboardEvent.prototype._computeKeybinding = function () {
            var key = 0 /* Unknown */;
            if (this.keyCode !== 5 /* Ctrl */ && this.keyCode !== 4 /* Shift */ && this.keyCode !== 6 /* Alt */ && this.keyCode !== 57 /* Meta */) {
                key = this.keyCode;
            }
            var result = 0;
            if (this.ctrlKey) {
                result |= ctrlKeyMod;
            }
            if (this.altKey) {
                result |= altKeyMod;
            }
            if (this.shiftKey) {
                result |= shiftKeyMod;
            }
            if (this.metaKey) {
                result |= metaKeyMod;
            }
            result |= key;
            return result;
        };
        StandardKeyboardEvent.prototype._computeRuntimeKeybinding = function () {
            var key = 0 /* Unknown */;
            if (this.keyCode !== 5 /* Ctrl */ && this.keyCode !== 4 /* Shift */ && this.keyCode !== 6 /* Alt */ && this.keyCode !== 57 /* Meta */) {
                key = this.keyCode;
            }
            return new keyCodes_1.SimpleKeybinding(this.ctrlKey, this.shiftKey, this.altKey, this.metaKey, key);
        };
        return StandardKeyboardEvent;
    }());
    exports.StandardKeyboardEvent = StandardKeyboardEvent;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[40/*vs/base/browser/mouseEvent*/], __M([0/*require*/,1/*exports*/,29/*vs/base/browser/browser*/,164/*vs/base/browser/iframe*/,17/*vs/base/common/platform*/]), function (require, exports, browser, iframe_1, platform) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var StandardMouseEvent = /** @class */ (function () {
        function StandardMouseEvent(e) {
            this.timestamp = Date.now();
            this.browserEvent = e;
            this.leftButton = e.button === 0;
            this.middleButton = e.button === 1;
            this.rightButton = e.button === 2;
            this.target = e.target;
            this.detail = e.detail || 1;
            if (e.type === 'dblclick') {
                this.detail = 2;
            }
            this.ctrlKey = e.ctrlKey;
            this.shiftKey = e.shiftKey;
            this.altKey = e.altKey;
            this.metaKey = e.metaKey;
            if (typeof e.pageX === 'number') {
                this.posx = e.pageX;
                this.posy = e.pageY;
            }
            else {
                // Probably hit by MSGestureEvent
                this.posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
                this.posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
            }
            // Find the position of the iframe this code is executing in relative to the iframe where the event was captured.
            var iframeOffsets = iframe_1.IframeUtils.getPositionOfChildWindowRelativeToAncestorWindow(self, e.view);
            this.posx -= iframeOffsets.left;
            this.posy -= iframeOffsets.top;
        }
        StandardMouseEvent.prototype.preventDefault = function () {
            if (this.browserEvent.preventDefault) {
                this.browserEvent.preventDefault();
            }
        };
        StandardMouseEvent.prototype.stopPropagation = function () {
            if (this.browserEvent.stopPropagation) {
                this.browserEvent.stopPropagation();
            }
        };
        return StandardMouseEvent;
    }());
    exports.StandardMouseEvent = StandardMouseEvent;
    var DragMouseEvent = /** @class */ (function (_super) {
        __extends(DragMouseEvent, _super);
        function DragMouseEvent(e) {
            var _this = _super.call(this, e) || this;
            _this.dataTransfer = e.dataTransfer;
            return _this;
        }
        return DragMouseEvent;
    }(StandardMouseEvent));
    exports.DragMouseEvent = DragMouseEvent;
    var StandardMouseWheelEvent = /** @class */ (function () {
        function StandardMouseWheelEvent(e, deltaX, deltaY) {
            if (deltaX === void 0) { deltaX = 0; }
            if (deltaY === void 0) { deltaY = 0; }
            this.browserEvent = e || null;
            this.target = e ? (e.target || e.targetNode || e.srcElement) : null;
            this.deltaY = deltaY;
            this.deltaX = deltaX;
            if (e) {
                var e1 = e;
                var e2 = e;
                // vertical delta scroll
                if (typeof e1.wheelDeltaY !== 'undefined') {
                    this.deltaY = e1.wheelDeltaY / 120;
                }
                else if (typeof e2.VERTICAL_AXIS !== 'undefined' && e2.axis === e2.VERTICAL_AXIS) {
                    this.deltaY = -e2.detail / 3;
                }
                // horizontal delta scroll
                if (typeof e1.wheelDeltaX !== 'undefined') {
                    if (browser.isSafari && platform.isWindows) {
                        this.deltaX = -(e1.wheelDeltaX / 120);
                    }
                    else {
                        this.deltaX = e1.wheelDeltaX / 120;
                    }
                }
                else if (typeof e2.HORIZONTAL_AXIS !== 'undefined' && e2.axis === e2.HORIZONTAL_AXIS) {
                    this.deltaX = -e.detail / 3;
                }
                // Assume a vertical scroll if nothing else worked
                if (this.deltaY === 0 && this.deltaX === 0 && e.wheelDelta) {
                    this.deltaY = e.wheelDelta / 120;
                }
            }
        }
        StandardMouseWheelEvent.prototype.preventDefault = function () {
            if (this.browserEvent) {
                if (this.browserEvent.preventDefault) {
                    this.browserEvent.preventDefault();
                }
            }
        };
        StandardMouseWheelEvent.prototype.stopPropagation = function () {
            if (this.browserEvent) {
                if (this.browserEvent.stopPropagation) {
                    this.browserEvent.stopPropagation();
                }
            }
        };
        return StandardMouseWheelEvent;
    }());
    exports.StandardMouseWheelEvent = StandardMouseWheelEvent;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[56/*vs/base/common/actions*/], __M([0/*require*/,1/*exports*/,2/*vs/base/common/lifecycle*/,6/*vs/base/common/event*/]), function (require, exports, lifecycle_1, event_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Action = /** @class */ (function () {
        function Action(id, label, cssClass, enabled, actionCallback) {
            if (label === void 0) { label = ''; }
            if (cssClass === void 0) { cssClass = ''; }
            if (enabled === void 0) { enabled = true; }
            this._onDidChange = new event_1.Emitter();
            this.onDidChange = this._onDidChange.event;
            this._id = id;
            this._label = label;
            this._cssClass = cssClass;
            this._enabled = enabled;
            this._actionCallback = actionCallback;
        }
        Object.defineProperty(Action.prototype, "id", {
            get: function () {
                return this._id;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Action.prototype, "label", {
            get: function () {
                return this._label;
            },
            set: function (value) {
                this._setLabel(value);
            },
            enumerable: true,
            configurable: true
        });
        Action.prototype._setLabel = function (value) {
            if (this._label !== value) {
                this._label = value;
                this._onDidChange.fire({ label: value });
            }
        };
        Object.defineProperty(Action.prototype, "tooltip", {
            get: function () {
                return this._tooltip;
            },
            set: function (value) {
                this._setTooltip(value);
            },
            enumerable: true,
            configurable: true
        });
        Action.prototype._setTooltip = function (value) {
            if (this._tooltip !== value) {
                this._tooltip = value;
                this._onDidChange.fire({ tooltip: value });
            }
        };
        Object.defineProperty(Action.prototype, "class", {
            get: function () {
                return this._cssClass;
            },
            set: function (value) {
                this._setClass(value);
            },
            enumerable: true,
            configurable: true
        });
        Action.prototype._setClass = function (value) {
            if (this._cssClass !== value) {
                this._cssClass = value;
                this._onDidChange.fire({ class: value });
            }
        };
        Object.defineProperty(Action.prototype, "enabled", {
            get: function () {
                return this._enabled;
            },
            set: function (value) {
                this._setEnabled(value);
            },
            enumerable: true,
            configurable: true
        });
        Action.prototype._setEnabled = function (value) {
            if (this._enabled !== value) {
                this._enabled = value;
                this._onDidChange.fire({ enabled: value });
            }
        };
        Object.defineProperty(Action.prototype, "checked", {
            get: function () {
                return this._checked;
            },
            set: function (value) {
                this._setChecked(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Action.prototype, "radio", {
            get: function () {
                return this._radio;
            },
            set: function (value) {
                this._setRadio(value);
            },
            enumerable: true,
            configurable: true
        });
        Action.prototype._setChecked = function (value) {
            if (this._checked !== value) {
                this._checked = value;
                this._onDidChange.fire({ checked: value });
            }
        };
        Action.prototype._setRadio = function (value) {
            if (this._radio !== value) {
                this._radio = value;
                this._onDidChange.fire({ radio: value });
            }
        };
        Action.prototype.run = function (event, _data) {
            if (this._actionCallback) {
                return this._actionCallback(event);
            }
            return Promise.resolve(true);
        };
        Action.prototype.dispose = function () {
            this._onDidChange.dispose();
        };
        return Action;
    }());
    exports.Action = Action;
    var ActionRunner = /** @class */ (function (_super) {
        __extends(ActionRunner, _super);
        function ActionRunner() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._onDidBeforeRun = _this._register(new event_1.Emitter());
            _this.onDidBeforeRun = _this._onDidBeforeRun.event;
            _this._onDidRun = _this._register(new event_1.Emitter());
            _this.onDidRun = _this._onDidRun.event;
            return _this;
        }
        ActionRunner.prototype.run = function (action, context) {
            var _this = this;
            if (!action.enabled) {
                return Promise.resolve(null);
            }
            this._onDidBeforeRun.fire({ action: action });
            return this.runAction(action, context).then(function (result) {
                _this._onDidRun.fire({ action: action, result: result });
            }, function (error) {
                _this._onDidRun.fire({ action: action, error: error });
            });
        };
        ActionRunner.prototype.runAction = function (action, context) {
            var res = context ? action.run(context) : action.run();
            return Promise.resolve(res);
        };
        return ActionRunner;
    }(lifecycle_1.Disposable));
    exports.ActionRunner = ActionRunner;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[24/*vs/base/common/cancellation*/], __M([0/*require*/,1/*exports*/,6/*vs/base/common/event*/]), function (require, exports, event_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var shortcutEvent = Object.freeze(function (callback, context) {
        var handle = setTimeout(callback.bind(context), 0);
        return { dispose: function () { clearTimeout(handle); } };
    });
    var CancellationToken;
    (function (CancellationToken) {
        function isCancellationToken(thing) {
            if (thing === CancellationToken.None || thing === CancellationToken.Cancelled) {
                return true;
            }
            if (thing instanceof MutableToken) {
                return true;
            }
            if (!thing || typeof thing !== 'object') {
                return false;
            }
            return typeof thing.isCancellationRequested === 'boolean'
                && typeof thing.onCancellationRequested === 'function';
        }
        CancellationToken.isCancellationToken = isCancellationToken;
        CancellationToken.None = Object.freeze({
            isCancellationRequested: false,
            onCancellationRequested: event_1.Event.None
        });
        CancellationToken.Cancelled = Object.freeze({
            isCancellationRequested: true,
            onCancellationRequested: shortcutEvent
        });
    })(CancellationToken = exports.CancellationToken || (exports.CancellationToken = {}));
    var MutableToken = /** @class */ (function () {
        function MutableToken() {
            this._isCancelled = false;
            this._emitter = null;
        }
        MutableToken.prototype.cancel = function () {
            if (!this._isCancelled) {
                this._isCancelled = true;
                if (this._emitter) {
                    this._emitter.fire(undefined);
                    this.dispose();
                }
            }
        };
        Object.defineProperty(MutableToken.prototype, "isCancellationRequested", {
            get: function () {
                return this._isCancelled;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(MutableToken.prototype, "onCancellationRequested", {
            get: function () {
                if (this._isCancelled) {
                    return shortcutEvent;
                }
                if (!this._emitter) {
                    this._emitter = new event_1.Emitter();
                }
                return this._emitter.event;
            },
            enumerable: true,
            configurable: true
        });
        MutableToken.prototype.dispose = function () {
            if (this._emitter) {
                this._emitter.dispose();
                this._emitter = null;
            }
        };
        return MutableToken;
    }());
    var CancellationTokenSource = /** @class */ (function () {
        function CancellationTokenSource() {
        }
        Object.defineProperty(CancellationTokenSource.prototype, "token", {
            get: function () {
                if (!this._token) {
                    // be lazy and create the token only when
                    // actually needed
                    this._token = new MutableToken();
                }
                return this._token;
            },
            enumerable: true,
            configurable: true
        });
        CancellationTokenSource.prototype.cancel = function () {
            if (!this._token) {
                // save an object by returning the default
                // cancelled token when cancellation happens
                // before someone asks for the token
                this._token = CancellationToken.Cancelled;
            }
            else if (this._token instanceof MutableToken) {
                // actually cancel
                this._token.cancel();
            }
        };
        CancellationTokenSource.prototype.dispose = function () {
            if (!this._token) {
                // ensure to initialize with an empty token if we had none
                this._token = CancellationToken.None;
            }
            else if (this._token instanceof MutableToken) {
                // actually dispose
                this._token.dispose();
            }
        };
        return CancellationTokenSource;
    }());
    exports.CancellationTokenSource = CancellationTokenSource;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[16/*vs/base/common/async*/], __M([0/*require*/,1/*exports*/,24/*vs/base/common/cancellation*/,11/*vs/base/common/errors*/,2/*vs/base/common/lifecycle*/,53/*vs/base/common/winjs.base*/]), function (require, exports, cancellation_1, errors, lifecycle_1, winjs_base_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function isThenable(obj) {
        return obj && typeof obj.then === 'function';
    }
    exports.isThenable = isThenable;
    function createCancelablePromise(callback) {
        var source = new cancellation_1.CancellationTokenSource();
        var thenable = callback(source.token);
        var promise = new Promise(function (resolve, reject) {
            source.token.onCancellationRequested(function () {
                reject(errors.canceled());
            });
            Promise.resolve(thenable).then(function (value) {
                source.dispose();
                resolve(value);
            }, function (err) {
                source.dispose();
                reject(err);
            });
        });
        return new /** @class */ (function () {
            function class_1() {
            }
            class_1.prototype.cancel = function () {
                source.cancel();
            };
            class_1.prototype.then = function (resolve, reject) {
                return promise.then(resolve, reject);
            };
            class_1.prototype.catch = function (reject) {
                return this.then(undefined, reject);
            };
            return class_1;
        }());
    }
    exports.createCancelablePromise = createCancelablePromise;
    /**
     * A helper to delay execution of a task that is being requested often.
     *
     * Following the throttler, now imagine the mail man wants to optimize the number of
     * trips proactively. The trip itself can be long, so he decides not to make the trip
     * as soon as a letter is submitted. Instead he waits a while, in case more
     * letters are submitted. After said waiting period, if no letters were submitted, he
     * decides to make the trip. Imagine that N more letters were submitted after the first
     * one, all within a short period of time between each other. Even though N+1
     * submissions occurred, only 1 delivery was made.
     *
     * The delayer offers this behavior via the trigger() method, into which both the task
     * to be executed and the waiting period (delay) must be passed in as arguments. Following
     * the example:
     *
     * 		const delayer = new Delayer(WAITING_PERIOD);
     * 		const letters = [];
     *
     * 		function letterReceived(l) {
     * 			letters.push(l);
     * 			delayer.trigger(() => { return makeTheTrip(); });
     * 		}
     */
    var Delayer = /** @class */ (function () {
        function Delayer(defaultDelay) {
            this.defaultDelay = defaultDelay;
            this.timeout = null;
            this.completionPromise = null;
            this.doResolve = null;
            this.task = null;
        }
        Delayer.prototype.trigger = function (task, delay) {
            var _this = this;
            if (delay === void 0) { delay = this.defaultDelay; }
            this.task = task;
            this.cancelTimeout();
            if (!this.completionPromise) {
                this.completionPromise = new winjs_base_1.TPromise(function (c, e) {
                    _this.doResolve = c;
                    _this.doReject = e;
                }).then(function () {
                    _this.completionPromise = null;
                    _this.doResolve = null;
                    var task = _this.task;
                    _this.task = null;
                    return task();
                });
            }
            this.timeout = setTimeout(function () {
                _this.timeout = null;
                _this.doResolve(null);
            }, delay);
            return this.completionPromise;
        };
        Delayer.prototype.cancel = function () {
            this.cancelTimeout();
            if (this.completionPromise) {
                this.doReject(errors.canceled());
                this.completionPromise = null;
            }
        };
        Delayer.prototype.cancelTimeout = function () {
            if (this.timeout !== null) {
                clearTimeout(this.timeout);
                this.timeout = null;
            }
        };
        Delayer.prototype.dispose = function () {
            this.cancelTimeout();
        };
        return Delayer;
    }());
    exports.Delayer = Delayer;
    function timeout(millis, token) {
        if (!token) {
            return createCancelablePromise(function (token) { return timeout(millis, token); });
        }
        return new Promise(function (resolve, reject) {
            var handle = setTimeout(resolve, millis);
            token.onCancellationRequested(function () {
                clearTimeout(handle);
                reject(errors.canceled());
            });
        });
    }
    exports.timeout = timeout;
    /**
     * Returns a new promise that joins the provided promise. Upon completion of
     * the provided promise the provided function will always be called. This
     * method is comparable to a try-finally code block.
     * @param promise a promise
     * @param callback a function that will be call in the success and error case.
     */
    function always(promise, callback) {
        function safeCallback() {
            try {
                callback();
            }
            catch (err) {
                errors.onUnexpectedError(err);
            }
        }
        promise.then(function (_) { return safeCallback(); }, function (_) { return safeCallback(); });
        return Promise.resolve(promise);
    }
    exports.always = always;
    function first(promiseFactories, shouldStop, defaultValue) {
        if (shouldStop === void 0) { shouldStop = function (t) { return !!t; }; }
        if (defaultValue === void 0) { defaultValue = null; }
        var index = 0;
        var len = promiseFactories.length;
        var loop = function () {
            if (index >= len) {
                return Promise.resolve(defaultValue);
            }
            var factory = promiseFactories[index++];
            var promise = Promise.resolve(factory());
            return promise.then(function (result) {
                if (shouldStop(result)) {
                    return Promise.resolve(result);
                }
                return loop();
            });
        };
        return loop();
    }
    exports.first = first;
    var TimeoutTimer = /** @class */ (function (_super) {
        __extends(TimeoutTimer, _super);
        function TimeoutTimer(runner, timeout) {
            var _this = _super.call(this) || this;
            _this._token = -1;
            if (typeof runner === 'function' && typeof timeout === 'number') {
                _this.setIfNotSet(runner, timeout);
            }
            return _this;
        }
        TimeoutTimer.prototype.dispose = function () {
            this.cancel();
            _super.prototype.dispose.call(this);
        };
        TimeoutTimer.prototype.cancel = function () {
            if (this._token !== -1) {
                clearTimeout(this._token);
                this._token = -1;
            }
        };
        TimeoutTimer.prototype.cancelAndSet = function (runner, timeout) {
            var _this = this;
            this.cancel();
            this._token = setTimeout(function () {
                _this._token = -1;
                runner();
            }, timeout);
        };
        TimeoutTimer.prototype.setIfNotSet = function (runner, timeout) {
            var _this = this;
            if (this._token !== -1) {
                // timer is already set
                return;
            }
            this._token = setTimeout(function () {
                _this._token = -1;
                runner();
            }, timeout);
        };
        return TimeoutTimer;
    }(lifecycle_1.Disposable));
    exports.TimeoutTimer = TimeoutTimer;
    var IntervalTimer = /** @class */ (function (_super) {
        __extends(IntervalTimer, _super);
        function IntervalTimer() {
            var _this = _super.call(this) || this;
            _this._token = -1;
            return _this;
        }
        IntervalTimer.prototype.dispose = function () {
            this.cancel();
            _super.prototype.dispose.call(this);
        };
        IntervalTimer.prototype.cancel = function () {
            if (this._token !== -1) {
                clearInterval(this._token);
                this._token = -1;
            }
        };
        IntervalTimer.prototype.cancelAndSet = function (runner, interval) {
            this.cancel();
            this._token = setInterval(function () {
                runner();
            }, interval);
        };
        return IntervalTimer;
    }(lifecycle_1.Disposable));
    exports.IntervalTimer = IntervalTimer;
    var RunOnceScheduler = /** @class */ (function () {
        function RunOnceScheduler(runner, timeout) {
            this.timeoutToken = -1;
            this.runner = runner;
            this.timeout = timeout;
            this.timeoutHandler = this.onTimeout.bind(this);
        }
        /**
         * Dispose RunOnceScheduler
         */
        RunOnceScheduler.prototype.dispose = function () {
            this.cancel();
            this.runner = null;
        };
        /**
         * Cancel current scheduled runner (if any).
         */
        RunOnceScheduler.prototype.cancel = function () {
            if (this.isScheduled()) {
                clearTimeout(this.timeoutToken);
                this.timeoutToken = -1;
            }
        };
        /**
         * Cancel previous runner (if any) & schedule a new runner.
         */
        RunOnceScheduler.prototype.schedule = function (delay) {
            if (delay === void 0) { delay = this.timeout; }
            this.cancel();
            this.timeoutToken = setTimeout(this.timeoutHandler, delay);
        };
        /**
         * Returns true if scheduled.
         */
        RunOnceScheduler.prototype.isScheduled = function () {
            return this.timeoutToken !== -1;
        };
        RunOnceScheduler.prototype.onTimeout = function () {
            this.timeoutToken = -1;
            if (this.runner) {
                this.doRun();
            }
        };
        RunOnceScheduler.prototype.doRun = function () {
            if (this.runner) {
                this.runner();
            }
        };
        return RunOnceScheduler;
    }());
    exports.RunOnceScheduler = RunOnceScheduler;
    (function () {
        if (typeof requestIdleCallback !== 'function' || typeof cancelIdleCallback !== 'function') {
            var dummyIdle_1 = Object.freeze({
                didTimeout: true,
                timeRemaining: function () { return 15; }
            });
            exports.runWhenIdle = function (runner, timeout) {
                if (timeout === void 0) { timeout = 0; }
                var handle = setTimeout(function () { return runner(dummyIdle_1); }, timeout);
                var disposed = false;
                return {
                    dispose: function () {
                        if (disposed) {
                            return;
                        }
                        disposed = true;
                        clearTimeout(handle);
                    }
                };
            };
        }
        else {
            exports.runWhenIdle = function (runner, timeout) {
                var handle = requestIdleCallback(runner, typeof timeout === 'number' ? { timeout: timeout } : undefined);
                var disposed = false;
                return {
                    dispose: function () {
                        if (disposed) {
                            return;
                        }
                        disposed = true;
                        cancelIdleCallback(handle);
                    }
                };
            };
        }
    })();
    /**
     * An implementation of the "idle-until-urgent"-strategy as introduced
     * here: https://philipwalton.com/articles/idle-until-urgent/
     */
    var IdleValue = /** @class */ (function () {
        function IdleValue(executor) {
            var _this = this;
            this._executor = function () {
                try {
                    _this._value = executor();
                }
                catch (err) {
                    _this._error = err;
                }
                finally {
                    _this._didRun = true;
                }
            };
            this._handle = exports.runWhenIdle(function () { return _this._executor(); });
        }
        IdleValue.prototype.dispose = function () {
            this._handle.dispose();
        };
        IdleValue.prototype.getValue = function () {
            if (!this._didRun) {
                this._handle.dispose();
                this._executor();
            }
            if (this._error) {
                throw this._error;
            }
            return this._value;
        };
        return IdleValue;
    }());
    exports.IdleValue = IdleValue;
});
//#endregion

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[7/*vs/base/browser/dom*/], __M([0/*require*/,1/*exports*/,29/*vs/base/browser/browser*/,72/*vs/base/browser/event*/,52/*vs/base/browser/keyboardEvent*/,40/*vs/base/browser/mouseEvent*/,16/*vs/base/common/async*/,11/*vs/base/common/errors*/,6/*vs/base/common/event*/,2/*vs/base/common/lifecycle*/,17/*vs/base/common/platform*/]), function (require, exports, browser, event_1, keyboardEvent_1, mouseEvent_1, async_1, errors_1, event_2, lifecycle_1, platform) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function clearNode(node) {
        while (node.firstChild) {
            node.removeChild(node.firstChild);
        }
    }
    exports.clearNode = clearNode;
    function removeNode(node) {
        if (node.parentNode) {
            node.parentNode.removeChild(node);
        }
    }
    exports.removeNode = removeNode;
    function isInDOM(node) {
        while (node) {
            if (node === document.body) {
                return true;
            }
            node = node.parentNode;
        }
        return false;
    }
    exports.isInDOM = isInDOM;
    var _manualClassList = new /** @class */ (function () {
        function class_1() {
        }
        class_1.prototype._findClassName = function (node, className) {
            var classes = node.className;
            if (!classes) {
                this._lastStart = -1;
                return;
            }
            className = className.trim();
            var classesLen = classes.length, classLen = className.length;
            if (classLen === 0) {
                this._lastStart = -1;
                return;
            }
            if (classesLen < classLen) {
                this._lastStart = -1;
                return;
            }
            if (classes === className) {
                this._lastStart = 0;
                this._lastEnd = classesLen;
                return;
            }
            var idx = -1, idxEnd;
            while ((idx = classes.indexOf(className, idx + 1)) >= 0) {
                idxEnd = idx + classLen;
                // a class that is followed by another class
                if ((idx === 0 || classes.charCodeAt(idx - 1) === 32 /* Space */) && classes.charCodeAt(idxEnd) === 32 /* Space */) {
                    this._lastStart = idx;
                    this._lastEnd = idxEnd + 1;
                    return;
                }
                // last class
                if (idx > 0 && classes.charCodeAt(idx - 1) === 32 /* Space */ && idxEnd === classesLen) {
                    this._lastStart = idx - 1;
                    this._lastEnd = idxEnd;
                    return;
                }
                // equal - duplicate of cmp above
                if (idx === 0 && idxEnd === classesLen) {
                    this._lastStart = 0;
                    this._lastEnd = idxEnd;
                    return;
                }
            }
            this._lastStart = -1;
        };
        class_1.prototype.hasClass = function (node, className) {
            this._findClassName(node, className);
            return this._lastStart !== -1;
        };
        class_1.prototype.addClasses = function (node) {
            var _this = this;
            var classNames = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                classNames[_i - 1] = arguments[_i];
            }
            classNames.forEach(function (nameValue) { return nameValue.split(' ').forEach(function (name) { return _this.addClass(node, name); }); });
        };
        class_1.prototype.addClass = function (node, className) {
            if (!node.className) { // doesn't have it for sure
                node.className = className;
            }
            else {
                this._findClassName(node, className); // see if it's already there
                if (this._lastStart === -1) {
                    node.className = node.className + ' ' + className;
                }
            }
        };
        class_1.prototype.removeClass = function (node, className) {
            this._findClassName(node, className);
            if (this._lastStart === -1) {
                return; // Prevent styles invalidation if not necessary
            }
            else {
                node.className = node.className.substring(0, this._lastStart) + node.className.substring(this._lastEnd);
            }
        };
        class_1.prototype.removeClasses = function (node) {
            var _this = this;
            var classNames = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                classNames[_i - 1] = arguments[_i];
            }
            classNames.forEach(function (nameValue) { return nameValue.split(' ').forEach(function (name) { return _this.removeClass(node, name); }); });
        };
        class_1.prototype.toggleClass = function (node, className, shouldHaveIt) {
            this._findClassName(node, className);
            if (this._lastStart !== -1 && (shouldHaveIt === void 0 || !shouldHaveIt)) {
                this.removeClass(node, className);
            }
            if (this._lastStart === -1 && (shouldHaveIt === void 0 || shouldHaveIt)) {
                this.addClass(node, className);
            }
        };
        return class_1;
    }());
    var _nativeClassList = new /** @class */ (function () {
        function class_2() {
        }
        class_2.prototype.hasClass = function (node, className) {
            return Boolean(className) && node.classList && node.classList.contains(className);
        };
        class_2.prototype.addClasses = function (node) {
            var _this = this;
            var classNames = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                classNames[_i - 1] = arguments[_i];
            }
            classNames.forEach(function (nameValue) { return nameValue.split(' ').forEach(function (name) { return _this.addClass(node, name); }); });
        };
        class_2.prototype.addClass = function (node, className) {
            if (className && node.classList) {
                node.classList.add(className);
            }
        };
        class_2.prototype.removeClass = function (node, className) {
            if (className && node.classList) {
                node.classList.remove(className);
            }
        };
        class_2.prototype.removeClasses = function (node) {
            var _this = this;
            var classNames = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                classNames[_i - 1] = arguments[_i];
            }
            classNames.forEach(function (nameValue) { return nameValue.split(' ').forEach(function (name) { return _this.removeClass(node, name); }); });
        };
        class_2.prototype.toggleClass = function (node, className, shouldHaveIt) {
            if (node.classList) {
                node.classList.toggle(className, shouldHaveIt);
            }
        };
        return class_2;
    }());
    // In IE11 there is only partial support for `classList` which makes us keep our
    // custom implementation. Otherwise use the native implementation, see: http://caniuse.com/#search=classlist
    var _classList = browser.isIE ? _manualClassList : _nativeClassList;
    exports.hasClass = _classList.hasClass.bind(_classList);
    exports.addClass = _classList.addClass.bind(_classList);
    exports.addClasses = _classList.addClasses.bind(_classList);
    exports.removeClass = _classList.removeClass.bind(_classList);
    exports.removeClasses = _classList.removeClasses.bind(_classList);
    exports.toggleClass = _classList.toggleClass.bind(_classList);
    var DomListener = /** @class */ (function () {
        function DomListener(node, type, handler, useCapture) {
            this._node = node;
            this._type = type;
            this._handler = handler;
            this._useCapture = (useCapture || false);
            this._node.addEventListener(this._type, this._handler, this._useCapture);
        }
        DomListener.prototype.dispose = function () {
            if (!this._handler) {
                // Already disposed
                return;
            }
            this._node.removeEventListener(this._type, this._handler, this._useCapture);
            // Prevent leakers from holding on to the dom or handler func
            this._node = null;
            this._handler = null;
        };
        return DomListener;
    }());
    function addDisposableListener(node, type, handler, useCapture) {
        return new DomListener(node, type, handler, useCapture);
    }
    exports.addDisposableListener = addDisposableListener;
    function _wrapAsStandardMouseEvent(handler) {
        return function (e) {
            return handler(new mouseEvent_1.StandardMouseEvent(e));
        };
    }
    function _wrapAsStandardKeyboardEvent(handler) {
        return function (e) {
            return handler(new keyboardEvent_1.StandardKeyboardEvent(e));
        };
    }
    exports.addStandardDisposableListener = function addStandardDisposableListener(node, type, handler, useCapture) {
        var wrapHandler = handler;
        if (type === 'click' || type === 'mousedown') {
            wrapHandler = _wrapAsStandardMouseEvent(handler);
        }
        else if (type === 'keydown' || type === 'keypress' || type === 'keyup') {
            wrapHandler = _wrapAsStandardKeyboardEvent(handler);
        }
        return addDisposableListener(node, type, wrapHandler, useCapture);
    };
    function addDisposableNonBubblingMouseOutListener(node, handler) {
        return addDisposableListener(node, 'mouseout', function (e) {
            // Mouse out bubbles, so this is an attempt to ignore faux mouse outs coming from children elements
            var toElement = (e.relatedTarget || e.toElement);
            while (toElement && toElement !== node) {
                toElement = toElement.parentNode;
            }
            if (toElement === node) {
                return;
            }
            handler(e);
        });
    }
    exports.addDisposableNonBubblingMouseOutListener = addDisposableNonBubblingMouseOutListener;
    var _animationFrame = null;
    function doRequestAnimationFrame(callback) {
        if (!_animationFrame) {
            var emulatedRequestAnimationFrame = function (callback) {
                return setTimeout(function () { return callback(new Date().getTime()); }, 0);
            };
            _animationFrame = (self.requestAnimationFrame
                || self.msRequestAnimationFrame
                || self.webkitRequestAnimationFrame
                || self.mozRequestAnimationFrame
                || self.oRequestAnimationFrame
                || emulatedRequestAnimationFrame);
        }
        return _animationFrame.call(self, callback);
    }
    var AnimationFrameQueueItem = /** @class */ (function () {
        function AnimationFrameQueueItem(runner, priority) {
            if (priority === void 0) { priority = 0; }
            this._runner = runner;
            this.priority = priority;
            this._canceled = false;
        }
        AnimationFrameQueueItem.prototype.dispose = function () {
            this._canceled = true;
        };
        AnimationFrameQueueItem.prototype.execute = function () {
            if (this._canceled) {
                return;
            }
            try {
                this._runner();
            }
            catch (e) {
                errors_1.onUnexpectedError(e);
            }
        };
        // Sort by priority (largest to lowest)
        AnimationFrameQueueItem.sort = function (a, b) {
            return b.priority - a.priority;
        };
        return AnimationFrameQueueItem;
    }());
    (function () {
        /**
         * The runners scheduled at the next animation frame
         */
        var NEXT_QUEUE = [];
        /**
         * The runners scheduled at the current animation frame
         */
        var CURRENT_QUEUE = null;
        /**
         * A flag to keep track if the native requestAnimationFrame was already called
         */
        var animFrameRequested = false;
        /**
         * A flag to indicate if currently handling a native requestAnimationFrame callback
         */
        var inAnimationFrameRunner = false;
        var animationFrameRunner = function () {
            animFrameRequested = false;
            CURRENT_QUEUE = NEXT_QUEUE;
            NEXT_QUEUE = [];
            inAnimationFrameRunner = true;
            while (CURRENT_QUEUE.length > 0) {
                CURRENT_QUEUE.sort(AnimationFrameQueueItem.sort);
                var top_1 = CURRENT_QUEUE.shift();
                top_1.execute();
            }
            inAnimationFrameRunner = false;
        };
        exports.scheduleAtNextAnimationFrame = function (runner, priority) {
            if (priority === void 0) { priority = 0; }
            var item = new AnimationFrameQueueItem(runner, priority);
            NEXT_QUEUE.push(item);
            if (!animFrameRequested) {
                animFrameRequested = true;
                doRequestAnimationFrame(animationFrameRunner);
            }
            return item;
        };
        exports.runAtThisOrScheduleAtNextAnimationFrame = function (runner, priority) {
            if (inAnimationFrameRunner) {
                var item = new AnimationFrameQueueItem(runner, priority);
                CURRENT_QUEUE.push(item);
                return item;
            }
            else {
                return exports.scheduleAtNextAnimationFrame(runner, priority);
            }
        };
    })();
    var MINIMUM_TIME_MS = 16;
    var DEFAULT_EVENT_MERGER = function (lastEvent, currentEvent) {
        return currentEvent;
    };
    var TimeoutThrottledDomListener = /** @class */ (function (_super) {
        __extends(TimeoutThrottledDomListener, _super);
        function TimeoutThrottledDomListener(node, type, handler, eventMerger, minimumTimeMs) {
            if (eventMerger === void 0) { eventMerger = DEFAULT_EVENT_MERGER; }
            if (minimumTimeMs === void 0) { minimumTimeMs = MINIMUM_TIME_MS; }
            var _this = _super.call(this) || this;
            var lastEvent = null;
            var lastHandlerTime = 0;
            var timeout = _this._register(new async_1.TimeoutTimer());
            var invokeHandler = function () {
                lastHandlerTime = (new Date()).getTime();
                handler(lastEvent);
                lastEvent = null;
            };
            _this._register(addDisposableListener(node, type, function (e) {
                lastEvent = eventMerger(lastEvent, e);
                var elapsedTime = (new Date()).getTime() - lastHandlerTime;
                if (elapsedTime >= minimumTimeMs) {
                    timeout.cancel();
                    invokeHandler();
                }
                else {
                    timeout.setIfNotSet(invokeHandler, minimumTimeMs - elapsedTime);
                }
            }));
            return _this;
        }
        return TimeoutThrottledDomListener;
    }(lifecycle_1.Disposable));
    function addDisposableThrottledListener(node, type, handler, eventMerger, minimumTimeMs) {
        return new TimeoutThrottledDomListener(node, type, handler, eventMerger, minimumTimeMs);
    }
    exports.addDisposableThrottledListener = addDisposableThrottledListener;
    function getComputedStyle(el) {
        return document.defaultView.getComputedStyle(el, null);
    }
    exports.getComputedStyle = getComputedStyle;
    // Adapted from WinJS
    // Converts a CSS positioning string for the specified element to pixels.
    var convertToPixels = (function () {
        return function (element, value) {
            return parseFloat(value) || 0;
        };
    })();
    function getDimension(element, cssPropertyName, jsPropertyName) {
        var computedStyle = getComputedStyle(element);
        var value = '0';
        if (computedStyle) {
            if (computedStyle.getPropertyValue) {
                value = computedStyle.getPropertyValue(cssPropertyName);
            }
            else {
                // IE8
                value = computedStyle.getAttribute(jsPropertyName);
            }
        }
        return convertToPixels(element, value);
    }
    function getClientArea(element) {
        // Try with DOM clientWidth / clientHeight
        if (element !== document.body) {
            return new Dimension(element.clientWidth, element.clientHeight);
        }
        // Try innerWidth / innerHeight
        if (window.innerWidth && window.innerHeight) {
            return new Dimension(window.innerWidth, window.innerHeight);
        }
        // Try with document.body.clientWidth / document.body.clientHeight
        if (document.body && document.body.clientWidth && document.body.clientHeight) {
            return new Dimension(document.body.clientWidth, document.body.clientHeight);
        }
        // Try with document.documentElement.clientWidth / document.documentElement.clientHeight
        if (document.documentElement && document.documentElement.clientWidth && document.documentElement.clientHeight) {
            return new Dimension(document.documentElement.clientWidth, document.documentElement.clientHeight);
        }
        throw new Error('Unable to figure out browser width and height');
    }
    exports.getClientArea = getClientArea;
    var sizeUtils = {
        getBorderLeftWidth: function (element) {
            return getDimension(element, 'border-left-width', 'borderLeftWidth');
        },
        getBorderRightWidth: function (element) {
            return getDimension(element, 'border-right-width', 'borderRightWidth');
        },
        getBorderTopWidth: function (element) {
            return getDimension(element, 'border-top-width', 'borderTopWidth');
        },
        getBorderBottomWidth: function (element) {
            return getDimension(element, 'border-bottom-width', 'borderBottomWidth');
        },
        getPaddingLeft: function (element) {
            return getDimension(element, 'padding-left', 'paddingLeft');
        },
        getPaddingRight: function (element) {
            return getDimension(element, 'padding-right', 'paddingRight');
        },
        getPaddingTop: function (element) {
            return getDimension(element, 'padding-top', 'paddingTop');
        },
        getPaddingBottom: function (element) {
            return getDimension(element, 'padding-bottom', 'paddingBottom');
        },
        getMarginLeft: function (element) {
            return getDimension(element, 'margin-left', 'marginLeft');
        },
        getMarginTop: function (element) {
            return getDimension(element, 'margin-top', 'marginTop');
        },
        getMarginRight: function (element) {
            return getDimension(element, 'margin-right', 'marginRight');
        },
        getMarginBottom: function (element) {
            return getDimension(element, 'margin-bottom', 'marginBottom');
        },
        __commaSentinel: false
    };
    // ----------------------------------------------------------------------------------------
    // Position & Dimension
    var Dimension = /** @class */ (function () {
        function Dimension(width, height) {
            this.width = width;
            this.height = height;
        }
        return Dimension;
    }());
    exports.Dimension = Dimension;
    function getTopLeftOffset(element) {
        // Adapted from WinJS.Utilities.getPosition
        // and added borders to the mix
        var offsetParent = element.offsetParent, top = element.offsetTop, left = element.offsetLeft;
        while ((element = element.parentNode) !== null && element !== document.body && element !== document.documentElement) {
            top -= element.scrollTop;
            var c = getComputedStyle(element);
            if (c) {
                left -= c.direction !== 'rtl' ? element.scrollLeft : -element.scrollLeft;
            }
            if (element === offsetParent) {
                left += sizeUtils.getBorderLeftWidth(element);
                top += sizeUtils.getBorderTopWidth(element);
                top += element.offsetTop;
                left += element.offsetLeft;
                offsetParent = element.offsetParent;
            }
        }
        return {
            left: left,
            top: top
        };
    }
    exports.getTopLeftOffset = getTopLeftOffset;
    /**
     * Returns the position of a dom node relative to the entire page.
     */
    function getDomNodePagePosition(domNode) {
        var bb = domNode.getBoundingClientRect();
        return {
            left: bb.left + exports.StandardWindow.scrollX,
            top: bb.top + exports.StandardWindow.scrollY,
            width: bb.width,
            height: bb.height
        };
    }
    exports.getDomNodePagePosition = getDomNodePagePosition;
    exports.StandardWindow = new /** @class */ (function () {
        function class_3() {
        }
        Object.defineProperty(class_3.prototype, "scrollX", {
            get: function () {
                if (typeof window.scrollX === 'number') {
                    // modern browsers
                    return window.scrollX;
                }
                else {
                    return document.body.scrollLeft + document.documentElement.scrollLeft;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(class_3.prototype, "scrollY", {
            get: function () {
                if (typeof window.scrollY === 'number') {
                    // modern browsers
                    return window.scrollY;
                }
                else {
                    return document.body.scrollTop + document.documentElement.scrollTop;
                }
            },
            enumerable: true,
            configurable: true
        });
        return class_3;
    }());
    // Adapted from WinJS
    // Gets the width of the element, including margins.
    function getTotalWidth(element) {
        var margin = sizeUtils.getMarginLeft(element) + sizeUtils.getMarginRight(element);
        return element.offsetWidth + margin;
    }
    exports.getTotalWidth = getTotalWidth;
    function getContentWidth(element) {
        var border = sizeUtils.getBorderLeftWidth(element) + sizeUtils.getBorderRightWidth(element);
        var padding = sizeUtils.getPaddingLeft(element) + sizeUtils.getPaddingRight(element);
        return element.offsetWidth - border - padding;
    }
    exports.getContentWidth = getContentWidth;
    // Adapted from WinJS
    // Gets the height of the content of the specified element. The content height does not include borders or padding.
    function getContentHeight(element) {
        var border = sizeUtils.getBorderTopWidth(element) + sizeUtils.getBorderBottomWidth(element);
        var padding = sizeUtils.getPaddingTop(element) + sizeUtils.getPaddingBottom(element);
        return element.offsetHeight - border - padding;
    }
    exports.getContentHeight = getContentHeight;
    // Adapted from WinJS
    // Gets the height of the element, including its margins.
    function getTotalHeight(element) {
        var margin = sizeUtils.getMarginTop(element) + sizeUtils.getMarginBottom(element);
        return element.offsetHeight + margin;
    }
    exports.getTotalHeight = getTotalHeight;
    // ----------------------------------------------------------------------------------------
    function isAncestor(testChild, testAncestor) {
        while (testChild) {
            if (testChild === testAncestor) {
                return true;
            }
            testChild = testChild.parentNode;
        }
        return false;
    }
    exports.isAncestor = isAncestor;
    function findParentWithClass(node, clazz, stopAtClazzOrNode) {
        while (node) {
            if (exports.hasClass(node, clazz)) {
                return node;
            }
            if (stopAtClazzOrNode) {
                if (typeof stopAtClazzOrNode === 'string') {
                    if (exports.hasClass(node, stopAtClazzOrNode)) {
                        return null;
                    }
                }
                else {
                    if (node === stopAtClazzOrNode) {
                        return null;
                    }
                }
            }
            node = node.parentNode;
        }
        return null;
    }
    exports.findParentWithClass = findParentWithClass;
    function createStyleSheet(container) {
        if (container === void 0) { container = document.getElementsByTagName('head')[0]; }
        var style = document.createElement('style');
        style.type = 'text/css';
        style.media = 'screen';
        container.appendChild(style);
        return style;
    }
    exports.createStyleSheet = createStyleSheet;
    var _sharedStyleSheet = null;
    function getSharedStyleSheet() {
        if (!_sharedStyleSheet) {
            _sharedStyleSheet = createStyleSheet();
        }
        return _sharedStyleSheet;
    }
    function getDynamicStyleSheetRules(style) {
        if (style && style.sheet && style.sheet.rules) {
            // Chrome, IE
            return style.sheet.rules;
        }
        if (style && style.sheet && style.sheet.cssRules) {
            // FF
            return style.sheet.cssRules;
        }
        return [];
    }
    function createCSSRule(selector, cssText, style) {
        if (style === void 0) { style = getSharedStyleSheet(); }
        if (!style || !cssText) {
            return;
        }
        style.sheet.insertRule(selector + '{' + cssText + '}', 0);
    }
    exports.createCSSRule = createCSSRule;
    function removeCSSRulesContainingSelector(ruleName, style) {
        if (style === void 0) { style = getSharedStyleSheet(); }
        if (!style) {
            return;
        }
        var rules = getDynamicStyleSheetRules(style);
        var toDelete = [];
        for (var i = 0; i < rules.length; i++) {
            var rule = rules[i];
            if (rule.selectorText.indexOf(ruleName) !== -1) {
                toDelete.push(i);
            }
        }
        for (var i = toDelete.length - 1; i >= 0; i--) {
            style.sheet.deleteRule(toDelete[i]);
        }
    }
    exports.removeCSSRulesContainingSelector = removeCSSRulesContainingSelector;
    function isHTMLElement(o) {
        if (typeof HTMLElement === 'object') {
            return o instanceof HTMLElement;
        }
        return o && typeof o === 'object' && o.nodeType === 1 && typeof o.nodeName === 'string';
    }
    exports.isHTMLElement = isHTMLElement;
    exports.EventType = {
        // Mouse
        CLICK: 'click',
        DBLCLICK: 'dblclick',
        MOUSE_UP: 'mouseup',
        MOUSE_DOWN: 'mousedown',
        MOUSE_OVER: 'mouseover',
        MOUSE_MOVE: 'mousemove',
        MOUSE_OUT: 'mouseout',
        MOUSE_ENTER: 'mouseenter',
        MOUSE_LEAVE: 'mouseleave',
        CONTEXT_MENU: 'contextmenu',
        WHEEL: 'wheel',
        // Keyboard
        KEY_DOWN: 'keydown',
        KEY_PRESS: 'keypress',
        KEY_UP: 'keyup',
        // HTML Document
        LOAD: 'load',
        UNLOAD: 'unload',
        ABORT: 'abort',
        ERROR: 'error',
        RESIZE: 'resize',
        SCROLL: 'scroll',
        // Form
        SELECT: 'select',
        CHANGE: 'change',
        SUBMIT: 'submit',
        RESET: 'reset',
        FOCUS: 'focus',
        FOCUS_IN: 'focusin',
        FOCUS_OUT: 'focusout',
        BLUR: 'blur',
        INPUT: 'input',
        // Local Storage
        STORAGE: 'storage',
        // Drag
        DRAG_START: 'dragstart',
        DRAG: 'drag',
        DRAG_ENTER: 'dragenter',
        DRAG_LEAVE: 'dragleave',
        DRAG_OVER: 'dragover',
        DROP: 'drop',
        DRAG_END: 'dragend',
        // Animation
        ANIMATION_START: browser.isWebKit ? 'webkitAnimationStart' : 'animationstart',
        ANIMATION_END: browser.isWebKit ? 'webkitAnimationEnd' : 'animationend',
        ANIMATION_ITERATION: browser.isWebKit ? 'webkitAnimationIteration' : 'animationiteration'
    };
    exports.EventHelper = {
        stop: function (e, cancelBubble) {
            if (e.preventDefault) {
                e.preventDefault();
            }
            else {
                // IE8
                e.returnValue = false;
            }
            if (cancelBubble) {
                if (e.stopPropagation) {
                    e.stopPropagation();
                }
                else {
                    // IE8
                    e.cancelBubble = true;
                }
            }
        }
    };
    function saveParentsScrollTop(node) {
        var r = [];
        for (var i = 0; node && node.nodeType === node.ELEMENT_NODE; i++) {
            r[i] = node.scrollTop;
            node = node.parentNode;
        }
        return r;
    }
    exports.saveParentsScrollTop = saveParentsScrollTop;
    function restoreParentsScrollTop(node, state) {
        for (var i = 0; node && node.nodeType === node.ELEMENT_NODE; i++) {
            if (node.scrollTop !== state[i]) {
                node.scrollTop = state[i];
            }
            node = node.parentNode;
        }
    }
    exports.restoreParentsScrollTop = restoreParentsScrollTop;
    var FocusTracker = /** @class */ (function () {
        function FocusTracker(element) {
            var _this = this;
            this._onDidFocus = new event_2.Emitter();
            this.onDidFocus = this._onDidFocus.event;
            this._onDidBlur = new event_2.Emitter();
            this.onDidBlur = this._onDidBlur.event;
            this.disposables = [];
            var hasFocus = isAncestor(document.activeElement, element);
            var loosingFocus = false;
            var onFocus = function () {
                loosingFocus = false;
                if (!hasFocus) {
                    hasFocus = true;
                    _this._onDidFocus.fire();
                }
            };
            var onBlur = function () {
                if (hasFocus) {
                    loosingFocus = true;
                    window.setTimeout(function () {
                        if (loosingFocus) {
                            loosingFocus = false;
                            hasFocus = false;
                            _this._onDidBlur.fire();
                        }
                    }, 0);
                }
            };
            event_1.domEvent(element, exports.EventType.FOCUS, true)(onFocus, null, this.disposables);
            event_1.domEvent(element, exports.EventType.BLUR, true)(onBlur, null, this.disposables);
        }
        FocusTracker.prototype.dispose = function () {
            this.disposables = lifecycle_1.dispose(this.disposables);
            this._onDidFocus.dispose();
            this._onDidBlur.dispose();
        };
        return FocusTracker;
    }());
    function trackFocus(element) {
        return new FocusTracker(element);
    }
    exports.trackFocus = trackFocus;
    function append(parent) {
        var children = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            children[_i - 1] = arguments[_i];
        }
        children.forEach(function (child) { return parent.appendChild(child); });
        return children[children.length - 1];
    }
    exports.append = append;
    var SELECTOR_REGEX = /([\w\-]+)?(#([\w\-]+))?((.([\w\-]+))*)/;
    function $(description, attrs) {
        var children = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            children[_i - 2] = arguments[_i];
        }
        var match = SELECTOR_REGEX.exec(description);
        if (!match) {
            throw new Error('Bad use of emmet');
        }
        var result = document.createElement(match[1] || 'div');
        if (match[3]) {
            result.id = match[3];
        }
        if (match[4]) {
            result.className = match[4].replace(/\./g, ' ').trim();
        }
        attrs = attrs || {};
        Object.keys(attrs).forEach(function (name) {
            var value = attrs[name];
            if (/^on\w+$/.test(name)) {
                result[name] = value;
            }
            else if (name === 'selected') {
                if (value) {
                    result.setAttribute(name, 'true');
                }
            }
            else {
                result.setAttribute(name, value);
            }
        });
        children
            .filter(function (child) { return !!child; })
            .forEach(function (child) {
            if (child instanceof Node) {
                result.appendChild(child);
            }
            else {
                result.appendChild(document.createTextNode(child));
            }
        });
        return result;
    }
    exports.$ = $;
    function show() {
        var elements = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            elements[_i] = arguments[_i];
        }
        for (var _a = 0, elements_1 = elements; _a < elements_1.length; _a++) {
            var element = elements_1[_a];
            element.style.display = '';
            element.removeAttribute('aria-hidden');
        }
    }
    exports.show = show;
    function hide() {
        var elements = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            elements[_i] = arguments[_i];
        }
        for (var _a = 0, elements_2 = elements; _a < elements_2.length; _a++) {
            var element = elements_2[_a];
            element.style.display = 'none';
            element.setAttribute('aria-hidden', 'true');
        }
    }
    exports.hide = hide;
    function findParentWithAttribute(node, attribute) {
        while (node) {
            if (node instanceof HTMLElement && node.hasAttribute(attribute)) {
                return node;
            }
            node = node.parentNode;
        }
        return null;
    }
    function removeTabIndexAndUpdateFocus(node) {
        if (!node || !node.hasAttribute('tabIndex')) {
            return;
        }
        // If we are the currently focused element and tabIndex is removed,
        // standard DOM behavior is to move focus to the <body> element. We
        // typically never want that, rather put focus to the closest element
        // in the hierarchy of the parent DOM nodes.
        if (document.activeElement === node) {
            var parentFocusable = findParentWithAttribute(node.parentElement, 'tabIndex');
            if (parentFocusable) {
                parentFocusable.focus();
            }
        }
        node.removeAttribute('tabindex');
    }
    exports.removeTabIndexAndUpdateFocus = removeTabIndexAndUpdateFocus;
    function getElementsByTagName(tag) {
        return Array.prototype.slice.call(document.getElementsByTagName(tag), 0);
    }
    exports.getElementsByTagName = getElementsByTagName;
    /**
     * Find a value usable for a dom node size such that the likelihood that it would be
     * displayed with constant screen pixels size is as high as possible.
     *
     * e.g. We would desire for the cursors to be 2px (CSS px) wide. Under a devicePixelRatio
     * of 1.25, the cursor will be 2.5 screen pixels wide. Depending on how the dom node aligns/"snaps"
     * with the screen pixels, it will sometimes be rendered with 2 screen pixels, and sometimes with 3 screen pixels.
     */
    function computeScreenAwareSize(cssPx) {
        var screenPx = window.devicePixelRatio * cssPx;
        return Math.max(1, Math.floor(screenPx)) / window.devicePixelRatio;
    }
    exports.computeScreenAwareSize = computeScreenAwareSize;
    /**
     * See https://github.com/Microsoft/monaco-editor/issues/601
     * To protect against malicious code in the linked site, particularly phishing attempts,
     * the window.opener should be set to null to prevent the linked site from having access
     * to change the location of the current page.
     * See https://mathiasbynens.github.io/rel-noopener/
     */
    function windowOpenNoOpener(url) {
        if (platform.isNative || browser.isEdgeWebView) {
            // In VSCode, window.open() always returns null...
            // The same is true for a WebView (see https://github.com/Microsoft/monaco-editor/issues/628)
            window.open(url);
        }
        else {
            var newTab = window.open();
            if (newTab) {
                newTab.opener = null;
                newTab.location.href = url;
            }
        }
    }
    exports.windowOpenNoOpener = windowOpenNoOpener;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[23/*vs/base/browser/fastDomNode*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/]), function (require, exports, dom) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var FastDomNode = /** @class */ (function () {
        function FastDomNode(domNode) {
            this.domNode = domNode;
            this._maxWidth = -1;
            this._width = -1;
            this._height = -1;
            this._top = -1;
            this._left = -1;
            this._bottom = -1;
            this._right = -1;
            this._fontFamily = '';
            this._fontWeight = '';
            this._fontSize = -1;
            this._lineHeight = -1;
            this._letterSpacing = -100;
            this._className = '';
            this._display = '';
            this._position = '';
            this._visibility = '';
            this._layerHint = false;
        }
        FastDomNode.prototype.setMaxWidth = function (maxWidth) {
            if (this._maxWidth === maxWidth) {
                return;
            }
            this._maxWidth = maxWidth;
            this.domNode.style.maxWidth = this._maxWidth + 'px';
        };
        FastDomNode.prototype.setWidth = function (width) {
            if (this._width === width) {
                return;
            }
            this._width = width;
            this.domNode.style.width = this._width + 'px';
        };
        FastDomNode.prototype.setHeight = function (height) {
            if (this._height === height) {
                return;
            }
            this._height = height;
            this.domNode.style.height = this._height + 'px';
        };
        FastDomNode.prototype.setTop = function (top) {
            if (this._top === top) {
                return;
            }
            this._top = top;
            this.domNode.style.top = this._top + 'px';
        };
        FastDomNode.prototype.unsetTop = function () {
            if (this._top === -1) {
                return;
            }
            this._top = -1;
            this.domNode.style.top = '';
        };
        FastDomNode.prototype.setLeft = function (left) {
            if (this._left === left) {
                return;
            }
            this._left = left;
            this.domNode.style.left = this._left + 'px';
        };
        FastDomNode.prototype.setBottom = function (bottom) {
            if (this._bottom === bottom) {
                return;
            }
            this._bottom = bottom;
            this.domNode.style.bottom = this._bottom + 'px';
        };
        FastDomNode.prototype.setRight = function (right) {
            if (this._right === right) {
                return;
            }
            this._right = right;
            this.domNode.style.right = this._right + 'px';
        };
        FastDomNode.prototype.setFontFamily = function (fontFamily) {
            if (this._fontFamily === fontFamily) {
                return;
            }
            this._fontFamily = fontFamily;
            this.domNode.style.fontFamily = this._fontFamily;
        };
        FastDomNode.prototype.setFontWeight = function (fontWeight) {
            if (this._fontWeight === fontWeight) {
                return;
            }
            this._fontWeight = fontWeight;
            this.domNode.style.fontWeight = this._fontWeight;
        };
        FastDomNode.prototype.setFontSize = function (fontSize) {
            if (this._fontSize === fontSize) {
                return;
            }
            this._fontSize = fontSize;
            this.domNode.style.fontSize = this._fontSize + 'px';
        };
        FastDomNode.prototype.setLineHeight = function (lineHeight) {
            if (this._lineHeight === lineHeight) {
                return;
            }
            this._lineHeight = lineHeight;
            this.domNode.style.lineHeight = this._lineHeight + 'px';
        };
        FastDomNode.prototype.setLetterSpacing = function (letterSpacing) {
            if (this._letterSpacing === letterSpacing) {
                return;
            }
            this._letterSpacing = letterSpacing;
            this.domNode.style.letterSpacing = this._letterSpacing + 'px';
        };
        FastDomNode.prototype.setClassName = function (className) {
            if (this._className === className) {
                return;
            }
            this._className = className;
            this.domNode.className = this._className;
        };
        FastDomNode.prototype.toggleClassName = function (className, shouldHaveIt) {
            dom.toggleClass(this.domNode, className, shouldHaveIt);
            this._className = this.domNode.className;
        };
        FastDomNode.prototype.setDisplay = function (display) {
            if (this._display === display) {
                return;
            }
            this._display = display;
            this.domNode.style.display = this._display;
        };
        FastDomNode.prototype.setPosition = function (position) {
            if (this._position === position) {
                return;
            }
            this._position = position;
            this.domNode.style.position = this._position;
        };
        FastDomNode.prototype.setVisibility = function (visibility) {
            if (this._visibility === visibility) {
                return;
            }
            this._visibility = visibility;
            this.domNode.style.visibility = this._visibility;
        };
        FastDomNode.prototype.setLayerHinting = function (layerHint) {
            if (this._layerHint === layerHint) {
                return;
            }
            this._layerHint = layerHint;
            this.domNode.style.willChange = this._layerHint ? 'transform' : 'auto';
        };
        FastDomNode.prototype.setAttribute = function (name, value) {
            this.domNode.setAttribute(name, value);
        };
        FastDomNode.prototype.removeAttribute = function (name) {
            this.domNode.removeAttribute(name);
        };
        FastDomNode.prototype.appendChild = function (child) {
            this.domNode.appendChild(child.domNode);
        };
        FastDomNode.prototype.removeChild = function (child) {
            this.domNode.removeChild(child.domNode);
        };
        return FastDomNode;
    }());
    exports.FastDomNode = FastDomNode;
    function createFastDomNode(domNode) {
        return new FastDomNode(domNode);
    }
    exports.createFastDomNode = createFastDomNode;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[73/*vs/base/browser/globalMouseMoveMonitor*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/,164/*vs/base/browser/iframe*/,40/*vs/base/browser/mouseEvent*/,2/*vs/base/common/lifecycle*/]), function (require, exports, dom, iframe_1, mouseEvent_1, lifecycle_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function standardMouseMoveMerger(lastEvent, currentEvent) {
        var ev = new mouseEvent_1.StandardMouseEvent(currentEvent);
        ev.preventDefault();
        return {
            leftButton: ev.leftButton,
            posx: ev.posx,
            posy: ev.posy
        };
    }
    exports.standardMouseMoveMerger = standardMouseMoveMerger;
    var GlobalMouseMoveMonitor = /** @class */ (function (_super) {
        __extends(GlobalMouseMoveMonitor, _super);
        function GlobalMouseMoveMonitor() {
            var _this = _super.call(this) || this;
            _this.hooks = [];
            _this.mouseMoveEventMerger = null;
            _this.mouseMoveCallback = null;
            _this.onStopCallback = null;
            return _this;
        }
        GlobalMouseMoveMonitor.prototype.dispose = function () {
            this.stopMonitoring(false);
            _super.prototype.dispose.call(this);
        };
        GlobalMouseMoveMonitor.prototype.stopMonitoring = function (invokeStopCallback) {
            if (!this.isMonitoring()) {
                // Not monitoring
                return;
            }
            // Unhook
            this.hooks = lifecycle_1.dispose(this.hooks);
            this.mouseMoveEventMerger = null;
            this.mouseMoveCallback = null;
            var onStopCallback = this.onStopCallback;
            this.onStopCallback = null;
            if (invokeStopCallback && onStopCallback) {
                onStopCallback();
            }
        };
        GlobalMouseMoveMonitor.prototype.isMonitoring = function () {
            return this.hooks.length > 0;
        };
        GlobalMouseMoveMonitor.prototype.startMonitoring = function (mouseMoveEventMerger, mouseMoveCallback, onStopCallback) {
            var _this = this;
            if (this.isMonitoring()) {
                // I am already hooked
                return;
            }
            this.mouseMoveEventMerger = mouseMoveEventMerger;
            this.mouseMoveCallback = mouseMoveCallback;
            this.onStopCallback = onStopCallback;
            var windowChain = iframe_1.IframeUtils.getSameOriginWindowChain();
            for (var i = 0; i < windowChain.length; i++) {
                this.hooks.push(dom.addDisposableThrottledListener(windowChain[i].window.document, 'mousemove', function (data) { return _this.mouseMoveCallback(data); }, function (lastEvent, currentEvent) { return _this.mouseMoveEventMerger(lastEvent, currentEvent); }));
                this.hooks.push(dom.addDisposableListener(windowChain[i].window.document, 'mouseup', function (e) { return _this.stopMonitoring(true); }));
            }
            if (iframe_1.IframeUtils.hasDifferentOriginAncestor()) {
                var lastSameOriginAncestor = windowChain[windowChain.length - 1];
                // We might miss a mouse up if it happens outside the iframe
                // This one is for Chrome
                this.hooks.push(dom.addDisposableListener(lastSameOriginAncestor.window.document, 'mouseout', function (browserEvent) {
                    var e = new mouseEvent_1.StandardMouseEvent(browserEvent);
                    if (e.target.tagName.toLowerCase() === 'html') {
                        _this.stopMonitoring(true);
                    }
                }));
                // This one is for FF
                this.hooks.push(dom.addDisposableListener(lastSameOriginAncestor.window.document, 'mouseover', function (browserEvent) {
                    var e = new mouseEvent_1.StandardMouseEvent(browserEvent);
                    if (e.target.tagName.toLowerCase() === 'html') {
                        _this.stopMonitoring(true);
                    }
                }));
                // This one is for IE
                this.hooks.push(dom.addDisposableListener(lastSameOriginAncestor.window.document.body, 'mouseleave', function (browserEvent) {
                    _this.stopMonitoring(true);
                }));
            }
        };
        return GlobalMouseMoveMonitor;
    }(lifecycle_1.Disposable));
    exports.GlobalMouseMoveMonitor = GlobalMouseMoveMonitor;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[133/*vs/base/browser/htmlContentRenderer*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/,110/*vs/base/common/idGenerator*/,8/*vs/base/common/strings*/,68/*vs/base/common/htmlContent*/,566/*vs/base/common/marked/marked*/,11/*vs/base/common/errors*/]), function (require, exports, DOM, idGenerator_1, strings_1, htmlContent_1, marked, errors_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function createElement(options) {
        var tagName = options.inline ? 'span' : 'div';
        var element = document.createElement(tagName);
        if (options.className) {
            element.className = options.className;
        }
        return element;
    }
    function renderText(text, options) {
        if (options === void 0) { options = {}; }
        var element = createElement(options);
        element.textContent = text;
        return element;
    }
    exports.renderText = renderText;
    function renderFormattedText(formattedText, options) {
        if (options === void 0) { options = {}; }
        var element = createElement(options);
        _renderFormattedText(element, parseFormattedText(formattedText), options.actionHandler);
        return element;
    }
    exports.renderFormattedText = renderFormattedText;
    /**
     * Create html nodes for the given content element.
     */
    function renderMarkdown(markdown, options) {
        if (options === void 0) { options = {}; }
        var element = createElement(options);
        // signal to code-block render that the
        // element has been created
        var signalInnerHTML;
        var withInnerHTML = new Promise(function (c) { return signalInnerHTML = c; });
        var renderer = new marked.Renderer();
        renderer.image = function (href, title, text) {
            var dimensions = [];
            if (href) {
                var splitted = href.split('|').map(function (s) { return s.trim(); });
                href = splitted[0];
                var parameters = splitted[1];
                if (parameters) {
                    var heightFromParams = /height=(\d+)/.exec(parameters);
                    var widthFromParams = /width=(\d+)/.exec(parameters);
                    var height = heightFromParams ? heightFromParams[1] : '';
                    var width = widthFromParams ? widthFromParams[1] : '';
                    var widthIsFinite = isFinite(parseInt(width));
                    var heightIsFinite = isFinite(parseInt(height));
                    if (widthIsFinite) {
                        dimensions.push("width=\"" + width + "\"");
                    }
                    if (heightIsFinite) {
                        dimensions.push("height=\"" + height + "\"");
                    }
                }
            }
            var attributes = [];
            if (href) {
                attributes.push("src=\"" + href + "\"");
            }
            if (text) {
                attributes.push("alt=\"" + text + "\"");
            }
            if (title) {
                attributes.push("title=\"" + title + "\"");
            }
            if (dimensions.length) {
                attributes = attributes.concat(dimensions);
            }
            return '<img ' + attributes.join(' ') + '>';
        };
        renderer.link = function (href, title, text) {
            // Remove markdown escapes. Workaround for https://github.com/chjj/marked/issues/829
            if (href === text) { // raw link case
                text = htmlContent_1.removeMarkdownEscapes(text);
            }
            title = htmlContent_1.removeMarkdownEscapes(title);
            href = htmlContent_1.removeMarkdownEscapes(href);
            if (!href
                || href.match(/^data:|javascript:/i)
                || (href.match(/^command:/i) && !markdown.isTrusted)
                || href.match(/^command:(\/\/\/)?_workbench\.downloadResource/i)) {
                // drop the link
                return text;
            }
            else {
                return "<a href=\"#\" data-href=\"" + href + "\" title=\"" + (title || href) + "\">" + text + "</a>";
            }
        };
        renderer.paragraph = function (text) {
            return "<p>" + text + "</p>";
        };
        if (options.codeBlockRenderer) {
            renderer.code = function (code, lang) {
                var value = options.codeBlockRenderer(lang, code);
                // when code-block rendering is async we return sync
                // but update the node with the real result later.
                var id = idGenerator_1.defaultGenerator.nextId();
                var promise = Promise.all([value, withInnerHTML]).then(function (values) {
                    var strValue = values[0];
                    var span = element.querySelector("div[data-code=\"" + id + "\"]");
                    if (span) {
                        span.innerHTML = strValue;
                    }
                }).catch(function (err) {
                    // ignore
                });
                if (options.codeBlockRenderCallback) {
                    promise.then(options.codeBlockRenderCallback);
                }
                return "<div class=\"code\" data-code=\"" + id + "\">" + strings_1.escape(code) + "</div>";
            };
        }
        if (options.actionHandler) {
            options.actionHandler.disposeables.push(DOM.addStandardDisposableListener(element, 'click', function (event) {
                var target = event.target;
                if (target.tagName !== 'A') {
                    target = target.parentElement;
                    if (!target || target.tagName !== 'A') {
                        return;
                    }
                }
                try {
                    var href = target.dataset['href'];
                    if (href) {
                        options.actionHandler.callback(href, event);
                    }
                }
                catch (err) {
                    errors_1.onUnexpectedError(err);
                }
                finally {
                    event.preventDefault();
                }
            }));
        }
        var markedOptions = {
            sanitize: true,
            renderer: renderer
        };
        element.innerHTML = marked.parse(markdown.value, markedOptions);
        signalInnerHTML();
        return element;
    }
    exports.renderMarkdown = renderMarkdown;
    // --- formatted string parsing
    var StringStream = /** @class */ (function () {
        function StringStream(source) {
            this.source = source;
            this.index = 0;
        }
        StringStream.prototype.eos = function () {
            return this.index >= this.source.length;
        };
        StringStream.prototype.next = function () {
            var next = this.peek();
            this.advance();
            return next;
        };
        StringStream.prototype.peek = function () {
            return this.source[this.index];
        };
        StringStream.prototype.advance = function () {
            this.index++;
        };
        return StringStream;
    }());
    function _renderFormattedText(element, treeNode, actionHandler) {
        var child;
        if (treeNode.type === 2 /* Text */) {
            child = document.createTextNode(treeNode.content || '');
        }
        else if (treeNode.type === 3 /* Bold */) {
            child = document.createElement('b');
        }
        else if (treeNode.type === 4 /* Italics */) {
            child = document.createElement('i');
        }
        else if (treeNode.type === 5 /* Action */ && actionHandler) {
            var a = document.createElement('a');
            a.href = '#';
            actionHandler.disposeables.push(DOM.addStandardDisposableListener(a, 'click', function (event) {
                actionHandler.callback(String(treeNode.index), event);
            }));
            child = a;
        }
        else if (treeNode.type === 7 /* NewLine */) {
            child = document.createElement('br');
        }
        else if (treeNode.type === 1 /* Root */) {
            child = element;
        }
        if (child && element !== child) {
            element.appendChild(child);
        }
        if (child && Array.isArray(treeNode.children)) {
            treeNode.children.forEach(function (nodeChild) {
                _renderFormattedText(child, nodeChild, actionHandler);
            });
        }
    }
    function parseFormattedText(content) {
        var root = {
            type: 1 /* Root */,
            children: []
        };
        var actionItemIndex = 0;
        var current = root;
        var stack = [];
        var stream = new StringStream(content);
        while (!stream.eos()) {
            var next = stream.next();
            var isEscapedFormatType = (next === '\\' && formatTagType(stream.peek()) !== 0 /* Invalid */);
            if (isEscapedFormatType) {
                next = stream.next(); // unread the backslash if it escapes a format tag type
            }
            if (!isEscapedFormatType && isFormatTag(next) && next === stream.peek()) {
                stream.advance();
                if (current.type === 2 /* Text */) {
                    current = stack.pop();
                }
                var type = formatTagType(next);
                if (current.type === type || (current.type === 5 /* Action */ && type === 6 /* ActionClose */)) {
                    current = stack.pop();
                }
                else {
                    var newCurrent = {
                        type: type,
                        children: []
                    };
                    if (type === 5 /* Action */) {
                        newCurrent.index = actionItemIndex;
                        actionItemIndex++;
                    }
                    current.children.push(newCurrent);
                    stack.push(current);
                    current = newCurrent;
                }
            }
            else if (next === '\n') {
                if (current.type === 2 /* Text */) {
                    current = stack.pop();
                }
                current.children.push({
                    type: 7 /* NewLine */
                });
            }
            else {
                if (current.type !== 2 /* Text */) {
                    var textCurrent = {
                        type: 2 /* Text */,
                        content: next
                    };
                    current.children.push(textCurrent);
                    stack.push(current);
                    current = textCurrent;
                }
                else {
                    current.content += next;
                }
            }
        }
        if (current.type === 2 /* Text */) {
            current = stack.pop();
        }
        if (stack.length) {
            // incorrectly formatted string literal
        }
        return root;
    }
    function isFormatTag(char) {
        return formatTagType(char) !== 0 /* Invalid */;
    }
    function formatTagType(char) {
        switch (char) {
            case '*':
                return 3 /* Bold */;
            case '_':
                return 4 /* Italics */;
            case '[':
                return 5 /* Action */;
            case ']':
                return 6 /* ActionClose */;
            default:
                return 0 /* Invalid */;
        }
    }
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
define(__m[75/*vs/base/browser/touch*/], __M([0/*require*/,1/*exports*/,22/*vs/base/common/arrays*/,2/*vs/base/common/lifecycle*/,7/*vs/base/browser/dom*/,128/*vs/base/common/decorators*/]), function (require, exports, arrays, lifecycle_1, DomUtils, decorators_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var EventType;
    (function (EventType) {
        EventType.Tap = '-monaco-gesturetap';
        EventType.Change = '-monaco-gesturechange';
        EventType.Start = '-monaco-gesturestart';
        EventType.End = '-monaco-gesturesend';
        EventType.Contextmenu = '-monaco-gesturecontextmenu';
    })(EventType = exports.EventType || (exports.EventType = {}));
    var Gesture = /** @class */ (function (_super) {
        __extends(Gesture, _super);
        function Gesture() {
            var _this = _super.call(this) || this;
            _this.activeTouches = {};
            _this.handle = null;
            _this.targets = [];
            _this._register(DomUtils.addDisposableListener(document, 'touchstart', function (e) { return _this.onTouchStart(e); }));
            _this._register(DomUtils.addDisposableListener(document, 'touchend', function (e) { return _this.onTouchEnd(e); }));
            _this._register(DomUtils.addDisposableListener(document, 'touchmove', function (e) { return _this.onTouchMove(e); }));
            return _this;
        }
        Gesture.addTarget = function (element) {
            if (!Gesture.isTouchDevice()) {
                return;
            }
            if (!Gesture.INSTANCE) {
                Gesture.INSTANCE = new Gesture();
            }
            Gesture.INSTANCE.targets.push(element);
        };
        Gesture.isTouchDevice = function () {
            return 'ontouchstart' in window || navigator.maxTouchPoints > 0 || window.navigator.msMaxTouchPoints > 0;
        };
        Gesture.prototype.dispose = function () {
            if (this.handle) {
                this.handle.dispose();
                this.handle = null;
            }
            _super.prototype.dispose.call(this);
        };
        Gesture.prototype.onTouchStart = function (e) {
            var timestamp = Date.now(); // use Date.now() because on FF e.timeStamp is not epoch based.
            if (this.handle) {
                this.handle.dispose();
                this.handle = null;
            }
            for (var i = 0, len = e.targetTouches.length; i < len; i++) {
                var touch = e.targetTouches.item(i);
                this.activeTouches[touch.identifier] = {
                    id: touch.identifier,
                    initialTarget: touch.target,
                    initialTimeStamp: timestamp,
                    initialPageX: touch.pageX,
                    initialPageY: touch.pageY,
                    rollingTimestamps: [timestamp],
                    rollingPageX: [touch.pageX],
                    rollingPageY: [touch.pageY]
                };
                var evt = this.newGestureEvent(EventType.Start, touch.target);
                evt.pageX = touch.pageX;
                evt.pageY = touch.pageY;
                this.dispatchEvent(evt);
            }
            if (this.dispatched) {
                e.preventDefault();
                e.stopPropagation();
                this.dispatched = false;
            }
        };
        Gesture.prototype.onTouchEnd = function (e) {
            var timestamp = Date.now(); // use Date.now() because on FF e.timeStamp is not epoch based.
            var activeTouchCount = Object.keys(this.activeTouches).length;
            var _loop_1 = function (i, len) {
                var touch = e.changedTouches.item(i);
                if (!this_1.activeTouches.hasOwnProperty(String(touch.identifier))) {
                    console.warn('move of an UNKNOWN touch', touch);
                    return "continue";
                }
                var data = this_1.activeTouches[touch.identifier], holdTime = Date.now() - data.initialTimeStamp;
                if (holdTime < Gesture.HOLD_DELAY
                    && Math.abs(data.initialPageX - arrays.tail(data.rollingPageX)) < 30
                    && Math.abs(data.initialPageY - arrays.tail(data.rollingPageY)) < 30) {
                    var evt = this_1.newGestureEvent(EventType.Tap, data.initialTarget);
                    evt.pageX = arrays.tail(data.rollingPageX);
                    evt.pageY = arrays.tail(data.rollingPageY);
                    this_1.dispatchEvent(evt);
                }
                else if (holdTime >= Gesture.HOLD_DELAY
                    && Math.abs(data.initialPageX - arrays.tail(data.rollingPageX)) < 30
                    && Math.abs(data.initialPageY - arrays.tail(data.rollingPageY)) < 30) {
                    var evt = this_1.newGestureEvent(EventType.Contextmenu, data.initialTarget);
                    evt.pageX = arrays.tail(data.rollingPageX);
                    evt.pageY = arrays.tail(data.rollingPageY);
                    this_1.dispatchEvent(evt);
                }
                else if (activeTouchCount === 1) {
                    var finalX = arrays.tail(data.rollingPageX);
                    var finalY = arrays.tail(data.rollingPageY);
                    var deltaT = arrays.tail(data.rollingTimestamps) - data.rollingTimestamps[0];
                    var deltaX = finalX - data.rollingPageX[0];
                    var deltaY = finalY - data.rollingPageY[0];
                    // We need to get all the dispatch targets on the start of the inertia event
                    var dispatchTo = this_1.targets.filter(function (t) { return data.initialTarget instanceof Node && t.contains(data.initialTarget); });
                    this_1.inertia(dispatchTo, timestamp, // time now
                    Math.abs(deltaX) / deltaT, // speed
                    deltaX > 0 ? 1 : -1, // x direction
                    finalX, // x now
                    Math.abs(deltaY) / deltaT, // y speed
                    deltaY > 0 ? 1 : -1, // y direction
                    finalY // y now
                    );
                }
                this_1.dispatchEvent(this_1.newGestureEvent(EventType.End, data.initialTarget));
                // forget about this touch
                delete this_1.activeTouches[touch.identifier];
            };
            var this_1 = this;
            for (var i = 0, len = e.changedTouches.length; i < len; i++) {
                _loop_1(i, len);
            }
            if (this.dispatched) {
                e.preventDefault();
                e.stopPropagation();
                this.dispatched = false;
            }
        };
        Gesture.prototype.newGestureEvent = function (type, intialTarget) {
            var event = document.createEvent('CustomEvent');
            event.initEvent(type, false, true);
            event.initialTarget = intialTarget;
            return event;
        };
        Gesture.prototype.dispatchEvent = function (event) {
            var _this = this;
            this.targets.forEach(function (target) {
                if (event.initialTarget instanceof Node && target.contains(event.initialTarget)) {
                    target.dispatchEvent(event);
                    _this.dispatched = true;
                }
            });
        };
        Gesture.prototype.inertia = function (dispatchTo, t1, vX, dirX, x, vY, dirY, y) {
            var _this = this;
            this.handle = DomUtils.scheduleAtNextAnimationFrame(function () {
                var now = Date.now();
                // velocity: old speed + accel_over_time
                var deltaT = now - t1, delta_pos_x = 0, delta_pos_y = 0, stopped = true;
                vX += Gesture.SCROLL_FRICTION * deltaT;
                vY += Gesture.SCROLL_FRICTION * deltaT;
                if (vX > 0) {
                    stopped = false;
                    delta_pos_x = dirX * vX * deltaT;
                }
                if (vY > 0) {
                    stopped = false;
                    delta_pos_y = dirY * vY * deltaT;
                }
                // dispatch translation event
                var evt = _this.newGestureEvent(EventType.Change);
                evt.translationX = delta_pos_x;
                evt.translationY = delta_pos_y;
                dispatchTo.forEach(function (d) { return d.dispatchEvent(evt); });
                if (!stopped) {
                    _this.inertia(dispatchTo, now, vX, dirX, x + delta_pos_x, vY, dirY, y + delta_pos_y);
                }
            });
        };
        Gesture.prototype.onTouchMove = function (e) {
            var timestamp = Date.now(); // use Date.now() because on FF e.timeStamp is not epoch based.
            for (var i = 0, len = e.changedTouches.length; i < len; i++) {
                var touch = e.changedTouches.item(i);
                if (!this.activeTouches.hasOwnProperty(String(touch.identifier))) {
                    console.warn('end of an UNKNOWN touch', touch);
                    continue;
                }
                var data = this.activeTouches[touch.identifier];
                var evt = this.newGestureEvent(EventType.Change, data.initialTarget);
                evt.translationX = touch.pageX - arrays.tail(data.rollingPageX);
                evt.translationY = touch.pageY - arrays.tail(data.rollingPageY);
                evt.pageX = touch.pageX;
                evt.pageY = touch.pageY;
                this.dispatchEvent(evt);
                // only keep a few data points, to average the final speed
                if (data.rollingPageX.length > 3) {
                    data.rollingPageX.shift();
                    data.rollingPageY.shift();
                    data.rollingTimestamps.shift();
                }
                data.rollingPageX.push(touch.pageX);
                data.rollingPageY.push(touch.pageY);
                data.rollingTimestamps.push(timestamp);
            }
            if (this.dispatched) {
                e.preventDefault();
                e.stopPropagation();
                this.dispatched = false;
            }
        };
        Gesture.SCROLL_FRICTION = -0.005;
        Gesture.HOLD_DELAY = 700;
        __decorate([
            decorators_1.memoize
        ], Gesture, "isTouchDevice", null);
        return Gesture;
    }(lifecycle_1.Disposable));
    exports.Gesture = Gesture;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[159/*vs/base/browser/ui/highlightedlabel/highlightedLabel*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/,27/*vs/base/common/objects*/,247/*vs/base/browser/ui/octiconLabel/octiconLabel*/]), function (require, exports, dom, objects, octiconLabel_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var HighlightedLabel = /** @class */ (function () {
        function HighlightedLabel(container, supportOcticons) {
            this.supportOcticons = supportOcticons;
            this.domNode = document.createElement('span');
            this.domNode.className = 'monaco-highlighted-label';
            this.didEverRender = false;
            container.appendChild(this.domNode);
        }
        Object.defineProperty(HighlightedLabel.prototype, "element", {
            get: function () {
                return this.domNode;
            },
            enumerable: true,
            configurable: true
        });
        HighlightedLabel.prototype.set = function (text, highlights, title, escapeNewLines) {
            if (highlights === void 0) { highlights = []; }
            if (title === void 0) { title = ''; }
            if (!text) {
                text = '';
            }
            if (escapeNewLines) {
                // adjusts highlights inplace
                text = HighlightedLabel.escapeNewLines(text, highlights);
            }
            if (this.didEverRender && this.text === text && this.title === title && objects.equals(this.highlights, highlights)) {
                return;
            }
            if (!Array.isArray(highlights)) {
                highlights = [];
            }
            this.text = text;
            this.title = title;
            this.highlights = highlights;
            this.render();
        };
        HighlightedLabel.prototype.render = function () {
            dom.clearNode(this.domNode);
            var htmlContent = [], highlight, pos = 0;
            for (var i = 0; i < this.highlights.length; i++) {
                highlight = this.highlights[i];
                if (highlight.end === highlight.start) {
                    continue;
                }
                if (pos < highlight.start) {
                    htmlContent.push('<span>');
                    var substring_1 = this.text.substring(pos, highlight.start);
                    htmlContent.push(this.supportOcticons ? octiconLabel_1.renderOcticons(substring_1) : substring_1);
                    htmlContent.push('</span>');
                    pos = highlight.end;
                }
                htmlContent.push('<span class="highlight">');
                var substring = this.text.substring(highlight.start, highlight.end);
                htmlContent.push(this.supportOcticons ? octiconLabel_1.renderOcticons(substring) : substring);
                htmlContent.push('</span>');
                pos = highlight.end;
            }
            if (pos < this.text.length) {
                htmlContent.push('<span>');
                var substring = this.text.substring(pos);
                htmlContent.push(this.supportOcticons ? octiconLabel_1.renderOcticons(substring) : substring);
                htmlContent.push('</span>');
            }
            this.domNode.innerHTML = htmlContent.join('');
            this.domNode.title = this.title;
            this.didEverRender = true;
        };
        HighlightedLabel.prototype.dispose = function () {
            this.text = null; // StrictNullOverride: nulling out ok in dispose
            this.highlights = null; // StrictNullOverride: nulling out ok in dispose
        };
        HighlightedLabel.escapeNewLines = function (text, highlights) {
            var total = 0;
            var extra = 0;
            return text.replace(/\r\n|\r|\n/, function (match, offset) {
                extra = match === '\r\n' ? -1 : 0;
                offset += total;
                for (var _i = 0, highlights_1 = highlights; _i < highlights_1.length; _i++) {
                    var highlight = highlights_1[_i];
                    if (highlight.end <= offset) {
                        continue;
                    }
                    if (highlight.start >= offset) {
                        highlight.start += extra;
                    }
                    if (highlight.end >= offset) {
                        highlight.end += extra;
                    }
                }
                total += extra;
                return '\u23CE';
            });
        };
        return HighlightedLabel;
    }());
    exports.HighlightedLabel = HighlightedLabel;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[369/*vs/base/browser/ui/list/rowCache*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/]), function (require, exports, dom_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function removeFromParent(element) {
        try {
            if (element.parentElement) {
                element.parentElement.removeChild(element);
            }
        }
        catch (e) {
            // this will throw if this happens due to a blur event, nasty business
        }
    }
    var RowCache = /** @class */ (function () {
        function RowCache(renderers) {
            this.renderers = renderers;
            this.cache = new Map();
        }
        /**
         * Returns a row either by creating a new one or reusing
         * a previously released row which shares the same templateId.
         */
        RowCache.prototype.alloc = function (templateId) {
            var result = this.getTemplateCache(templateId).pop();
            if (!result) {
                var domNode = dom_1.$('.monaco-list-row');
                var renderer = this.renderers.get(templateId);
                var templateData = renderer.renderTemplate(domNode);
                result = { domNode: domNode, templateId: templateId, templateData: templateData };
            }
            return result;
        };
        /**
         * Releases the row for eventual reuse.
         */
        RowCache.prototype.release = function (row) {
            if (!row) {
                return;
            }
            this.releaseRow(row);
        };
        RowCache.prototype.releaseRow = function (row) {
            var domNode = row.domNode, templateId = row.templateId;
            if (domNode) {
                dom_1.removeClass(domNode, 'scrolling');
                removeFromParent(domNode);
            }
            var cache = this.getTemplateCache(templateId);
            cache.push(row);
        };
        RowCache.prototype.getTemplateCache = function (templateId) {
            var result = this.cache.get(templateId);
            if (!result) {
                result = [];
                this.cache.set(templateId, result);
            }
            return result;
        };
        RowCache.prototype.garbageCollect = function () {
            var _this = this;
            if (!this.renderers) {
                return;
            }
            this.cache.forEach(function (cachedRows, templateId) {
                for (var _i = 0, cachedRows_1 = cachedRows; _i < cachedRows_1.length; _i++) {
                    var cachedRow = cachedRows_1[_i];
                    var renderer = _this.renderers.get(templateId);
                    renderer.disposeTemplate(cachedRow.templateData);
                    cachedRow.domNode = null;
                    cachedRow.templateData = null;
                }
            });
            this.cache.clear();
        };
        RowCache.prototype.dispose = function () {
            this.garbageCollect();
            this.cache.clear();
            this.renderers = null; // StrictNullOverride: nulling out ok in dispose
        };
        return RowCache;
    }());
    exports.RowCache = RowCache;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[411/*vs/base/browser/ui/scrollbar/scrollbarVisibilityController*/], __M([0/*require*/,1/*exports*/,16/*vs/base/common/async*/,2/*vs/base/common/lifecycle*/]), function (require, exports, async_1, lifecycle_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ScrollbarVisibilityController = /** @class */ (function (_super) {
        __extends(ScrollbarVisibilityController, _super);
        function ScrollbarVisibilityController(visibility, visibleClassName, invisibleClassName) {
            var _this = _super.call(this) || this;
            _this._visibility = visibility;
            _this._visibleClassName = visibleClassName;
            _this._invisibleClassName = invisibleClassName;
            _this._domNode = null;
            _this._isVisible = false;
            _this._isNeeded = false;
            _this._shouldBeVisible = false;
            _this._revealTimer = _this._register(new async_1.TimeoutTimer());
            return _this;
        }
        // ----------------- Hide / Reveal
        ScrollbarVisibilityController.prototype.applyVisibilitySetting = function (shouldBeVisible) {
            if (this._visibility === 2 /* Hidden */) {
                return false;
            }
            if (this._visibility === 3 /* Visible */) {
                return true;
            }
            return shouldBeVisible;
        };
        ScrollbarVisibilityController.prototype.setShouldBeVisible = function (rawShouldBeVisible) {
            var shouldBeVisible = this.applyVisibilitySetting(rawShouldBeVisible);
            if (this._shouldBeVisible !== shouldBeVisible) {
                this._shouldBeVisible = shouldBeVisible;
                this.ensureVisibility();
            }
        };
        ScrollbarVisibilityController.prototype.setIsNeeded = function (isNeeded) {
            if (this._isNeeded !== isNeeded) {
                this._isNeeded = isNeeded;
                this.ensureVisibility();
            }
        };
        ScrollbarVisibilityController.prototype.setDomNode = function (domNode) {
            this._domNode = domNode;
            this._domNode.setClassName(this._invisibleClassName);
            // Now that the flags & the dom node are in a consistent state, ensure the Hidden/Visible configuration
            this.setShouldBeVisible(false);
        };
        ScrollbarVisibilityController.prototype.ensureVisibility = function () {
            if (!this._isNeeded) {
                // Nothing to be rendered
                this._hide(false);
                return;
            }
            if (this._shouldBeVisible) {
                this._reveal();
            }
            else {
                this._hide(true);
            }
        };
        ScrollbarVisibilityController.prototype._reveal = function () {
            var _this = this;
            if (this._isVisible) {
                return;
            }
            this._isVisible = true;
            // The CSS animation doesn't play otherwise
            this._revealTimer.setIfNotSet(function () {
                if (_this._domNode) {
                    _this._domNode.setClassName(_this._visibleClassName);
                }
            }, 0);
        };
        ScrollbarVisibilityController.prototype._hide = function (withFadeAway) {
            this._revealTimer.cancel();
            if (!this._isVisible) {
                return;
            }
            this._isVisible = false;
            if (this._domNode) {
                this._domNode.setClassName(this._invisibleClassName + (withFadeAway ? ' fade' : ''));
            }
        };
        return ScrollbarVisibilityController;
    }(lifecycle_1.Disposable));
    exports.ScrollbarVisibilityController = ScrollbarVisibilityController;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[46/*vs/base/browser/ui/widget*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/,52/*vs/base/browser/keyboardEvent*/,40/*vs/base/browser/mouseEvent*/,2/*vs/base/common/lifecycle*/]), function (require, exports, dom, keyboardEvent_1, mouseEvent_1, lifecycle_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Widget = /** @class */ (function (_super) {
        __extends(Widget, _super);
        function Widget() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Widget.prototype.onclick = function (domNode, listener) {
            this._register(dom.addDisposableListener(domNode, dom.EventType.CLICK, function (e) { return listener(new mouseEvent_1.StandardMouseEvent(e)); }));
        };
        Widget.prototype.onmousedown = function (domNode, listener) {
            this._register(dom.addDisposableListener(domNode, dom.EventType.MOUSE_DOWN, function (e) { return listener(new mouseEvent_1.StandardMouseEvent(e)); }));
        };
        Widget.prototype.onmouseover = function (domNode, listener) {
            this._register(dom.addDisposableListener(domNode, dom.EventType.MOUSE_OVER, function (e) { return listener(new mouseEvent_1.StandardMouseEvent(e)); }));
        };
        Widget.prototype.onnonbubblingmouseout = function (domNode, listener) {
            this._register(dom.addDisposableNonBubblingMouseOutListener(domNode, function (e) { return listener(new mouseEvent_1.StandardMouseEvent(e)); }));
        };
        Widget.prototype.onkeydown = function (domNode, listener) {
            this._register(dom.addDisposableListener(domNode, dom.EventType.KEY_DOWN, function (e) { return listener(new keyboardEvent_1.StandardKeyboardEvent(e)); }));
        };
        Widget.prototype.onkeyup = function (domNode, listener) {
            this._register(dom.addDisposableListener(domNode, dom.EventType.KEY_UP, function (e) { return listener(new keyboardEvent_1.StandardKeyboardEvent(e)); }));
        };
        Widget.prototype.oninput = function (domNode, listener) {
            this._register(dom.addDisposableListener(domNode, dom.EventType.INPUT, listener));
        };
        Widget.prototype.onblur = function (domNode, listener) {
            this._register(dom.addDisposableListener(domNode, dom.EventType.BLUR, listener));
        };
        Widget.prototype.onfocus = function (domNode, listener) {
            this._register(dom.addDisposableListener(domNode, dom.EventType.FOCUS, listener));
        };
        Widget.prototype.onchange = function (domNode, listener) {
            this._register(dom.addDisposableListener(domNode, dom.EventType.CHANGE, listener));
        };
        return Widget;
    }(lifecycle_1.Disposable));
    exports.Widget = Widget;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[113/*vs/base/browser/ui/scrollbar/scrollbarArrow*/], __M([0/*require*/,1/*exports*/,73/*vs/base/browser/globalMouseMoveMonitor*/,46/*vs/base/browser/ui/widget*/,16/*vs/base/common/async*/]), function (require, exports, globalMouseMoveMonitor_1, widget_1, async_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * The arrow image size.
     */
    exports.ARROW_IMG_SIZE = 11;
    var ScrollbarArrow = /** @class */ (function (_super) {
        __extends(ScrollbarArrow, _super);
        function ScrollbarArrow(opts) {
            var _this = _super.call(this) || this;
            _this._onActivate = opts.onActivate;
            _this.bgDomNode = document.createElement('div');
            _this.bgDomNode.className = 'arrow-background';
            _this.bgDomNode.style.position = 'absolute';
            _this.bgDomNode.style.width = opts.bgWidth + 'px';
            _this.bgDomNode.style.height = opts.bgHeight + 'px';
            if (typeof opts.top !== 'undefined') {
                _this.bgDomNode.style.top = '0px';
            }
            if (typeof opts.left !== 'undefined') {
                _this.bgDomNode.style.left = '0px';
            }
            if (typeof opts.bottom !== 'undefined') {
                _this.bgDomNode.style.bottom = '0px';
            }
            if (typeof opts.right !== 'undefined') {
                _this.bgDomNode.style.right = '0px';
            }
            _this.domNode = document.createElement('div');
            _this.domNode.className = opts.className;
            _this.domNode.style.position = 'absolute';
            _this.domNode.style.width = exports.ARROW_IMG_SIZE + 'px';
            _this.domNode.style.height = exports.ARROW_IMG_SIZE + 'px';
            if (typeof opts.top !== 'undefined') {
                _this.domNode.style.top = opts.top + 'px';
            }
            if (typeof opts.left !== 'undefined') {
                _this.domNode.style.left = opts.left + 'px';
            }
            if (typeof opts.bottom !== 'undefined') {
                _this.domNode.style.bottom = opts.bottom + 'px';
            }
            if (typeof opts.right !== 'undefined') {
                _this.domNode.style.right = opts.right + 'px';
            }
            _this._mouseMoveMonitor = _this._register(new globalMouseMoveMonitor_1.GlobalMouseMoveMonitor());
            _this.onmousedown(_this.bgDomNode, function (e) { return _this._arrowMouseDown(e); });
            _this.onmousedown(_this.domNode, function (e) { return _this._arrowMouseDown(e); });
            _this._mousedownRepeatTimer = _this._register(new async_1.IntervalTimer());
            _this._mousedownScheduleRepeatTimer = _this._register(new async_1.TimeoutTimer());
            return _this;
        }
        ScrollbarArrow.prototype._arrowMouseDown = function (e) {
            var _this = this;
            var scheduleRepeater = function () {
                _this._mousedownRepeatTimer.cancelAndSet(function () { return _this._onActivate(); }, 1000 / 24);
            };
            this._onActivate();
            this._mousedownRepeatTimer.cancel();
            this._mousedownScheduleRepeatTimer.cancelAndSet(scheduleRepeater, 200);
            this._mouseMoveMonitor.startMonitoring(globalMouseMoveMonitor_1.standardMouseMoveMerger, function (mouseMoveData) {
                /* Intentional empty */
            }, function () {
                _this._mousedownRepeatTimer.cancel();
                _this._mousedownScheduleRepeatTimer.cancel();
            });
            e.preventDefault();
        };
        return ScrollbarArrow;
    }(widget_1.Widget));
    exports.ScrollbarArrow = ScrollbarArrow;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[166/*vs/base/browser/ui/scrollbar/abstractScrollbar*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/,23/*vs/base/browser/fastDomNode*/,73/*vs/base/browser/globalMouseMoveMonitor*/,113/*vs/base/browser/ui/scrollbar/scrollbarArrow*/,411/*vs/base/browser/ui/scrollbar/scrollbarVisibilityController*/,46/*vs/base/browser/ui/widget*/,17/*vs/base/common/platform*/]), function (require, exports, dom, fastDomNode_1, globalMouseMoveMonitor_1, scrollbarArrow_1, scrollbarVisibilityController_1, widget_1, platform) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * The orthogonal distance to the slider at which dragging "resets". This implements "snapping"
     */
    var MOUSE_DRAG_RESET_DISTANCE = 140;
    var AbstractScrollbar = /** @class */ (function (_super) {
        __extends(AbstractScrollbar, _super);
        function AbstractScrollbar(opts) {
            var _this = _super.call(this) || this;
            _this._lazyRender = opts.lazyRender;
            _this._host = opts.host;
            _this._scrollable = opts.scrollable;
            _this._scrollbarState = opts.scrollbarState;
            _this._visibilityController = _this._register(new scrollbarVisibilityController_1.ScrollbarVisibilityController(opts.visibility, 'visible scrollbar ' + opts.extraScrollbarClassName, 'invisible scrollbar ' + opts.extraScrollbarClassName));
            _this._mouseMoveMonitor = _this._register(new globalMouseMoveMonitor_1.GlobalMouseMoveMonitor());
            _this._shouldRender = true;
            _this.domNode = fastDomNode_1.createFastDomNode(document.createElement('div'));
            _this.domNode.setAttribute('role', 'presentation');
            _this.domNode.setAttribute('aria-hidden', 'true');
            _this._visibilityController.setDomNode(_this.domNode);
            _this.domNode.setPosition('absolute');
            _this.onmousedown(_this.domNode.domNode, function (e) { return _this._domNodeMouseDown(e); });
            return _this;
        }
        // ----------------- creation
        /**
         * Creates the dom node for an arrow & adds it to the container
         */
        AbstractScrollbar.prototype._createArrow = function (opts) {
            var arrow = this._register(new scrollbarArrow_1.ScrollbarArrow(opts));
            this.domNode.domNode.appendChild(arrow.bgDomNode);
            this.domNode.domNode.appendChild(arrow.domNode);
        };
        /**
         * Creates the slider dom node, adds it to the container & hooks up the events
         */
        AbstractScrollbar.prototype._createSlider = function (top, left, width, height) {
            var _this = this;
            this.slider = fastDomNode_1.createFastDomNode(document.createElement('div'));
            this.slider.setClassName('slider');
            this.slider.setPosition('absolute');
            this.slider.setTop(top);
            this.slider.setLeft(left);
            if (typeof width === 'number') {
                this.slider.setWidth(width);
            }
            if (typeof height === 'number') {
                this.slider.setHeight(height);
            }
            this.slider.setLayerHinting(true);
            this.domNode.domNode.appendChild(this.slider.domNode);
            this.onmousedown(this.slider.domNode, function (e) {
                if (e.leftButton) {
                    e.preventDefault();
                    _this._sliderMouseDown(e, function () { });
                }
            });
        };
        // ----------------- Update state
        AbstractScrollbar.prototype._onElementSize = function (visibleSize) {
            if (this._scrollbarState.setVisibleSize(visibleSize)) {
                this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded());
                this._shouldRender = true;
                if (!this._lazyRender) {
                    this.render();
                }
            }
            return this._shouldRender;
        };
        AbstractScrollbar.prototype._onElementScrollSize = function (elementScrollSize) {
            if (this._scrollbarState.setScrollSize(elementScrollSize)) {
                this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded());
                this._shouldRender = true;
                if (!this._lazyRender) {
                    this.render();
                }
            }
            return this._shouldRender;
        };
        AbstractScrollbar.prototype._onElementScrollPosition = function (elementScrollPosition) {
            if (this._scrollbarState.setScrollPosition(elementScrollPosition)) {
                this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded());
                this._shouldRender = true;
                if (!this._lazyRender) {
                    this.render();
                }
            }
            return this._shouldRender;
        };
        // ----------------- rendering
        AbstractScrollbar.prototype.beginReveal = function () {
            this._visibilityController.setShouldBeVisible(true);
        };
        AbstractScrollbar.prototype.beginHide = function () {
            this._visibilityController.setShouldBeVisible(false);
        };
        AbstractScrollbar.prototype.render = function () {
            if (!this._shouldRender) {
                return;
            }
            this._shouldRender = false;
            this._renderDomNode(this._scrollbarState.getRectangleLargeSize(), this._scrollbarState.getRectangleSmallSize());
            this._updateSlider(this._scrollbarState.getSliderSize(), this._scrollbarState.getArrowSize() + this._scrollbarState.getSliderPosition());
        };
        // ----------------- DOM events
        AbstractScrollbar.prototype._domNodeMouseDown = function (e) {
            if (e.target !== this.domNode.domNode) {
                return;
            }
            this._onMouseDown(e);
        };
        AbstractScrollbar.prototype.delegateMouseDown = function (e) {
            var domTop = this.domNode.domNode.getClientRects()[0].top;
            var sliderStart = domTop + this._scrollbarState.getSliderPosition();
            var sliderStop = domTop + this._scrollbarState.getSliderPosition() + this._scrollbarState.getSliderSize();
            var mousePos = this._sliderMousePosition(e);
            if (sliderStart <= mousePos && mousePos <= sliderStop) {
                // Act as if it was a mouse down on the slider
                if (e.leftButton) {
                    e.preventDefault();
                    this._sliderMouseDown(e, function () { });
                }
            }
            else {
                // Act as if it was a mouse down on the scrollbar
                this._onMouseDown(e);
            }
        };
        AbstractScrollbar.prototype._onMouseDown = function (e) {
            var offsetX;
            var offsetY;
            if (e.target === this.domNode.domNode && typeof e.browserEvent.offsetX === 'number' && typeof e.browserEvent.offsetY === 'number') {
                offsetX = e.browserEvent.offsetX;
                offsetY = e.browserEvent.offsetY;
            }
            else {
                var domNodePosition = dom.getDomNodePagePosition(this.domNode.domNode);
                offsetX = e.posx - domNodePosition.left;
                offsetY = e.posy - domNodePosition.top;
            }
            this._setDesiredScrollPositionNow(this._scrollbarState.getDesiredScrollPositionFromOffset(this._mouseDownRelativePosition(offsetX, offsetY)));
            if (e.leftButton) {
                e.preventDefault();
                this._sliderMouseDown(e, function () { });
            }
        };
        AbstractScrollbar.prototype._sliderMouseDown = function (e, onDragFinished) {
            var _this = this;
            var initialMousePosition = this._sliderMousePosition(e);
            var initialMouseOrthogonalPosition = this._sliderOrthogonalMousePosition(e);
            var initialScrollbarState = this._scrollbarState.clone();
            this.slider.toggleClassName('active', true);
            this._mouseMoveMonitor.startMonitoring(globalMouseMoveMonitor_1.standardMouseMoveMerger, function (mouseMoveData) {
                var mouseOrthogonalPosition = _this._sliderOrthogonalMousePosition(mouseMoveData);
                var mouseOrthogonalDelta = Math.abs(mouseOrthogonalPosition - initialMouseOrthogonalPosition);
                if (platform.isWindows && mouseOrthogonalDelta > MOUSE_DRAG_RESET_DISTANCE) {
                    // The mouse has wondered away from the scrollbar => reset dragging
                    _this._setDesiredScrollPositionNow(initialScrollbarState.getScrollPosition());
                    return;
                }
                var mousePosition = _this._sliderMousePosition(mouseMoveData);
                var mouseDelta = mousePosition - initialMousePosition;
                _this._setDesiredScrollPositionNow(initialScrollbarState.getDesiredScrollPositionFromDelta(mouseDelta));
            }, function () {
                _this.slider.toggleClassName('active', false);
                _this._host.onDragEnd();
                onDragFinished();
            });
            this._host.onDragStart();
        };
        AbstractScrollbar.prototype._setDesiredScrollPositionNow = function (_desiredScrollPosition) {
            var desiredScrollPosition = {};
            this.writeScrollPosition(desiredScrollPosition, _desiredScrollPosition);
            this._scrollable.setScrollPositionNow(desiredScrollPosition);
        };
        return AbstractScrollbar;
    }(widget_1.Widget));
    exports.AbstractScrollbar = AbstractScrollbar;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[420/*vs/base/browser/ui/scrollbar/horizontalScrollbar*/], __M([0/*require*/,1/*exports*/,40/*vs/base/browser/mouseEvent*/,166/*vs/base/browser/ui/scrollbar/abstractScrollbar*/,113/*vs/base/browser/ui/scrollbar/scrollbarArrow*/,149/*vs/base/browser/ui/scrollbar/scrollbarState*/]), function (require, exports, mouseEvent_1, abstractScrollbar_1, scrollbarArrow_1, scrollbarState_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var HorizontalScrollbar = /** @class */ (function (_super) {
        __extends(HorizontalScrollbar, _super);
        function HorizontalScrollbar(scrollable, options, host) {
            var _this = _super.call(this, {
                lazyRender: options.lazyRender,
                host: host,
                scrollbarState: new scrollbarState_1.ScrollbarState((options.horizontalHasArrows ? options.arrowSize : 0), (options.horizontal === 2 /* Hidden */ ? 0 : options.horizontalScrollbarSize), (options.vertical === 2 /* Hidden */ ? 0 : options.verticalScrollbarSize)),
                visibility: options.horizontal,
                extraScrollbarClassName: 'horizontal',
                scrollable: scrollable
            }) || this;
            if (options.horizontalHasArrows) {
                var arrowDelta = (options.arrowSize - scrollbarArrow_1.ARROW_IMG_SIZE) / 2;
                var scrollbarDelta = (options.horizontalScrollbarSize - scrollbarArrow_1.ARROW_IMG_SIZE) / 2;
                _this._createArrow({
                    className: 'left-arrow',
                    top: scrollbarDelta,
                    left: arrowDelta,
                    bottom: void 0,
                    right: void 0,
                    bgWidth: options.arrowSize,
                    bgHeight: options.horizontalScrollbarSize,
                    onActivate: function () { return _this._host.onMouseWheel(new mouseEvent_1.StandardMouseWheelEvent(null, 1, 0)); },
                });
                _this._createArrow({
                    className: 'right-arrow',
                    top: scrollbarDelta,
                    left: void 0,
                    bottom: void 0,
                    right: arrowDelta,
                    bgWidth: options.arrowSize,
                    bgHeight: options.horizontalScrollbarSize,
                    onActivate: function () { return _this._host.onMouseWheel(new mouseEvent_1.StandardMouseWheelEvent(null, -1, 0)); },
                });
            }
            _this._createSlider(Math.floor((options.horizontalScrollbarSize - options.horizontalSliderSize) / 2), 0, undefined, options.horizontalSliderSize);
            return _this;
        }
        HorizontalScrollbar.prototype._updateSlider = function (sliderSize, sliderPosition) {
            this.slider.setWidth(sliderSize);
            this.slider.setLeft(sliderPosition);
        };
        HorizontalScrollbar.prototype._renderDomNode = function (largeSize, smallSize) {
            this.domNode.setWidth(largeSize);
            this.domNode.setHeight(smallSize);
            this.domNode.setLeft(0);
            this.domNode.setBottom(0);
        };
        HorizontalScrollbar.prototype.onDidScroll = function (e) {
            this._shouldRender = this._onElementScrollSize(e.scrollWidth) || this._shouldRender;
            this._shouldRender = this._onElementScrollPosition(e.scrollLeft) || this._shouldRender;
            this._shouldRender = this._onElementSize(e.width) || this._shouldRender;
            return this._shouldRender;
        };
        HorizontalScrollbar.prototype._mouseDownRelativePosition = function (offsetX, offsetY) {
            return offsetX;
        };
        HorizontalScrollbar.prototype._sliderMousePosition = function (e) {
            return e.posx;
        };
        HorizontalScrollbar.prototype._sliderOrthogonalMousePosition = function (e) {
            return e.posy;
        };
        HorizontalScrollbar.prototype.writeScrollPosition = function (target, scrollPosition) {
            target.scrollLeft = scrollPosition;
        };
        return HorizontalScrollbar;
    }(abstractScrollbar_1.AbstractScrollbar));
    exports.HorizontalScrollbar = HorizontalScrollbar;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[422/*vs/base/browser/ui/scrollbar/verticalScrollbar*/], __M([0/*require*/,1/*exports*/,40/*vs/base/browser/mouseEvent*/,166/*vs/base/browser/ui/scrollbar/abstractScrollbar*/,113/*vs/base/browser/ui/scrollbar/scrollbarArrow*/,149/*vs/base/browser/ui/scrollbar/scrollbarState*/]), function (require, exports, mouseEvent_1, abstractScrollbar_1, scrollbarArrow_1, scrollbarState_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var VerticalScrollbar = /** @class */ (function (_super) {
        __extends(VerticalScrollbar, _super);
        function VerticalScrollbar(scrollable, options, host) {
            var _this = _super.call(this, {
                lazyRender: options.lazyRender,
                host: host,
                scrollbarState: new scrollbarState_1.ScrollbarState((options.verticalHasArrows ? options.arrowSize : 0), (options.vertical === 2 /* Hidden */ ? 0 : options.verticalScrollbarSize), 
                // give priority to vertical scroll bar over horizontal and let it scroll all the way to the bottom
                0),
                visibility: options.vertical,
                extraScrollbarClassName: 'vertical',
                scrollable: scrollable
            }) || this;
            if (options.verticalHasArrows) {
                var arrowDelta = (options.arrowSize - scrollbarArrow_1.ARROW_IMG_SIZE) / 2;
                var scrollbarDelta = (options.verticalScrollbarSize - scrollbarArrow_1.ARROW_IMG_SIZE) / 2;
                _this._createArrow({
                    className: 'up-arrow',
                    top: arrowDelta,
                    left: scrollbarDelta,
                    bottom: void 0,
                    right: void 0,
                    bgWidth: options.verticalScrollbarSize,
                    bgHeight: options.arrowSize,
                    onActivate: function () { return _this._host.onMouseWheel(new mouseEvent_1.StandardMouseWheelEvent(null, 0, 1)); },
                });
                _this._createArrow({
                    className: 'down-arrow',
                    top: void 0,
                    left: scrollbarDelta,
                    bottom: arrowDelta,
                    right: void 0,
                    bgWidth: options.verticalScrollbarSize,
                    bgHeight: options.arrowSize,
                    onActivate: function () { return _this._host.onMouseWheel(new mouseEvent_1.StandardMouseWheelEvent(null, 0, -1)); },
                });
            }
            _this._createSlider(0, Math.floor((options.verticalScrollbarSize - options.verticalSliderSize) / 2), options.verticalSliderSize, undefined);
            return _this;
        }
        VerticalScrollbar.prototype._updateSlider = function (sliderSize, sliderPosition) {
            this.slider.setHeight(sliderSize);
            this.slider.setTop(sliderPosition);
        };
        VerticalScrollbar.prototype._renderDomNode = function (largeSize, smallSize) {
            this.domNode.setWidth(smallSize);
            this.domNode.setHeight(largeSize);
            this.domNode.setRight(0);
            this.domNode.setTop(0);
        };
        VerticalScrollbar.prototype.onDidScroll = function (e) {
            this._shouldRender = this._onElementScrollSize(e.scrollHeight) || this._shouldRender;
            this._shouldRender = this._onElementScrollPosition(e.scrollTop) || this._shouldRender;
            this._shouldRender = this._onElementSize(e.height) || this._shouldRender;
            return this._shouldRender;
        };
        VerticalScrollbar.prototype._mouseDownRelativePosition = function (offsetX, offsetY) {
            return offsetY;
        };
        VerticalScrollbar.prototype._sliderMousePosition = function (e) {
            return e.posy;
        };
        VerticalScrollbar.prototype._sliderOrthogonalMousePosition = function (e) {
            return e.posx;
        };
        VerticalScrollbar.prototype.writeScrollPosition = function (target, scrollPosition) {
            target.scrollTop = scrollPosition;
        };
        return VerticalScrollbar;
    }(abstractScrollbar_1.AbstractScrollbar));
    exports.VerticalScrollbar = VerticalScrollbar;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[167/*vs/base/common/glob*/], __M([0/*require*/,1/*exports*/,22/*vs/base/common/arrays*/,8/*vs/base/common/strings*/,58/*vs/base/common/paths*/,65/*vs/base/common/map*/,16/*vs/base/common/async*/]), function (require, exports, arrays, strings, paths, map_1, async_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var GLOBSTAR = '**';
    var GLOB_SPLIT = '/';
    var PATH_REGEX = '[/\\\\]'; // any slash or backslash
    var NO_PATH_REGEX = '[^/\\\\]'; // any non-slash and non-backslash
    var ALL_FORWARD_SLASHES = /\//g;
    function starsToRegExp(starCount) {
        switch (starCount) {
            case 0:
                return '';
            case 1:
                return NO_PATH_REGEX + "*?"; // 1 star matches any number of characters except path separator (/ and \) - non greedy (?)
            default:
                // Matches:  (Path Sep OR Path Val followed by Path Sep OR Path Sep followed by Path Val) 0-many times
                // Group is non capturing because we don't need to capture at all (?:...)
                // Overall we use non-greedy matching because it could be that we match too much
                return "(?:" + PATH_REGEX + "|" + NO_PATH_REGEX + "+" + PATH_REGEX + "|" + PATH_REGEX + NO_PATH_REGEX + "+)*?";
        }
    }
    function splitGlobAware(pattern, splitChar) {
        if (!pattern) {
            return [];
        }
        var segments = [];
        var inBraces = false;
        var inBrackets = false;
        var char;
        var curVal = '';
        for (var i = 0; i < pattern.length; i++) {
            char = pattern[i];
            switch (char) {
                case splitChar:
                    if (!inBraces && !inBrackets) {
                        segments.push(curVal);
                        curVal = '';
                        continue;
                    }
                    break;
                case '{':
                    inBraces = true;
                    break;
                case '}':
                    inBraces = false;
                    break;
                case '[':
                    inBrackets = true;
                    break;
                case ']':
                    inBrackets = false;
                    break;
            }
            curVal += char;
        }
        // Tail
        if (curVal) {
            segments.push(curVal);
        }
        return segments;
    }
    exports.splitGlobAware = splitGlobAware;
    function parseRegExp(pattern) {
        if (!pattern) {
            return '';
        }
        var regEx = '';
        // Split up into segments for each slash found
        var segments = splitGlobAware(pattern, GLOB_SPLIT);
        // Special case where we only have globstars
        if (segments.every(function (s) { return s === GLOBSTAR; })) {
            regEx = '.*';
        }
        // Build regex over segments
        else {
            var previousSegmentWasGlobStar_1 = false;
            segments.forEach(function (segment, index) {
                // Globstar is special
                if (segment === GLOBSTAR) {
                    // if we have more than one globstar after another, just ignore it
                    if (!previousSegmentWasGlobStar_1) {
                        regEx += starsToRegExp(2);
                        previousSegmentWasGlobStar_1 = true;
                    }
                    return;
                }
                // States
                var inBraces = false;
                var braceVal = '';
                var inBrackets = false;
                var bracketVal = '';
                var char;
                for (var i = 0; i < segment.length; i++) {
                    char = segment[i];
                    // Support brace expansion
                    if (char !== '}' && inBraces) {
                        braceVal += char;
                        continue;
                    }
                    // Support brackets
                    if (inBrackets && (char !== ']' || !bracketVal) /* ] is literally only allowed as first character in brackets to match it */) {
                        var res = void 0;
                        // range operator
                        if (char === '-') {
                            res = char;
                        }
                        // negation operator (only valid on first index in bracket)
                        else if ((char === '^' || char === '!') && !bracketVal) {
                            res = '^';
                        }
                        // glob split matching is not allowed within character ranges
                        // see http://man7.org/linux/man-pages/man7/glob.7.html
                        else if (char === GLOB_SPLIT) {
                            res = '';
                        }
                        // anything else gets escaped
                        else {
                            res = strings.escapeRegExpCharacters(char);
                        }
                        bracketVal += res;
                        continue;
                    }
                    switch (char) {
                        case '{':
                            inBraces = true;
                            continue;
                        case '[':
                            inBrackets = true;
                            continue;
                        case '}':
                            var choices = splitGlobAware(braceVal, ',');
                            // Converts {foo,bar} => [foo|bar]
                            var braceRegExp = "(?:" + choices.map(function (c) { return parseRegExp(c); }).join('|') + ")";
                            regEx += braceRegExp;
                            inBraces = false;
                            braceVal = '';
                            break;
                        case ']':
                            regEx += ('[' + bracketVal + ']');
                            inBrackets = false;
                            bracketVal = '';
                            break;
                        case '?':
                            regEx += NO_PATH_REGEX; // 1 ? matches any single character except path separator (/ and \)
                            continue;
                        case '*':
                            regEx += starsToRegExp(1);
                            continue;
                        default:
                            regEx += strings.escapeRegExpCharacters(char);
                    }
                }
                // Tail: Add the slash we had split on if there is more to come and the remaining pattern is not a globstar
                // For example if pattern: some/**/*.js we want the "/" after some to be included in the RegEx to prevent
                // a folder called "something" to match as well.
                // However, if pattern: some/**, we tolerate that we also match on "something" because our globstar behaviour
                // is to match 0-N segments.
                if (index < segments.length - 1 && (segments[index + 1] !== GLOBSTAR || index + 2 < segments.length)) {
                    regEx += PATH_REGEX;
                }
                // reset state
                previousSegmentWasGlobStar_1 = false;
            });
        }
        return regEx;
    }
    // regexes to check for trival glob patterns that just check for String#endsWith
    var T1 = /^\*\*\/\*\.[\w\.-]+$/; // **/*.something
    var T2 = /^\*\*\/([\w\.-]+)\/?$/; // **/something
    var T3 = /^{\*\*\/[\*\.]?[\w\.-]+\/?(,\*\*\/[\*\.]?[\w\.-]+\/?)*}$/; // {**/*.something,**/*.else} or {**/package.json,**/project.json}
    var T3_2 = /^{\*\*\/[\*\.]?[\w\.-]+(\/(\*\*)?)?(,\*\*\/[\*\.]?[\w\.-]+(\/(\*\*)?)?)*}$/; // Like T3, with optional trailing /**
    var T4 = /^\*\*((\/[\w\.-]+)+)\/?$/; // **/something/else
    var T5 = /^([\w\.-]+(\/[\w\.-]+)*)\/?$/; // something/else
    var CACHE = new map_1.LRUCache(10000); // bounded to 10000 elements
    var FALSE = function () {
        return false;
    };
    var NULL = function () {
        return null;
    };
    function parsePattern(arg1, options) {
        if (!arg1) {
            return NULL;
        }
        // Handle IRelativePattern
        var pattern;
        if (typeof arg1 !== 'string') {
            pattern = arg1.pattern;
        }
        else {
            pattern = arg1;
        }
        // Whitespace trimming
        pattern = pattern.trim();
        // Check cache
        var patternKey = pattern + "_" + !!options.trimForExclusions;
        var parsedPattern = CACHE.get(patternKey);
        if (parsedPattern) {
            return wrapRelativePattern(parsedPattern, arg1);
        }
        // Check for Trivias
        var match;
        if (T1.test(pattern)) { // common pattern: **/*.txt just need endsWith check
            var base_1 = pattern.substr(4); // '**/*'.length === 4
            parsedPattern = function (path, basename) {
                return path && strings.endsWith(path, base_1) ? pattern : null;
            };
        }
        else if (match = T2.exec(trimForExclusions(pattern, options))) { // common pattern: **/some.txt just need basename check
            parsedPattern = trivia2(match[1], pattern);
        }
        else if ((options.trimForExclusions ? T3_2 : T3).test(pattern)) { // repetition of common patterns (see above) {**/*.txt,**/*.png}
            parsedPattern = trivia3(pattern, options);
        }
        else if (match = T4.exec(trimForExclusions(pattern, options))) { // common pattern: **/something/else just need endsWith check
            parsedPattern = trivia4and5(match[1].substr(1), pattern, true);
        }
        else if (match = T5.exec(trimForExclusions(pattern, options))) { // common pattern: something/else just need equals check
            parsedPattern = trivia4and5(match[1], pattern, false);
        }
        // Otherwise convert to pattern
        else {
            parsedPattern = toRegExp(pattern);
        }
        // Cache
        CACHE.set(patternKey, parsedPattern);
        return wrapRelativePattern(parsedPattern, arg1);
    }
    function wrapRelativePattern(parsedPattern, arg2) {
        if (typeof arg2 === 'string') {
            return parsedPattern;
        }
        return function (path, basename) {
            if (!paths.isEqualOrParent(path, arg2.base)) {
                return null;
            }
            return parsedPattern(arg2.pathToRelative(arg2.base, path), basename);
        };
    }
    function trimForExclusions(pattern, options) {
        return options.trimForExclusions && strings.endsWith(pattern, '/**') ? pattern.substr(0, pattern.length - 2) : pattern; // dropping **, tailing / is dropped later
    }
    // common pattern: **/some.txt just need basename check
    function trivia2(base, originalPattern) {
        var slashBase = "/" + base;
        var backslashBase = "\\" + base;
        var parsedPattern = function (path, basename) {
            if (!path) {
                return null;
            }
            if (basename) {
                return basename === base ? originalPattern : null;
            }
            return path === base || strings.endsWith(path, slashBase) || strings.endsWith(path, backslashBase) ? originalPattern : null;
        };
        var basenames = [base];
        parsedPattern.basenames = basenames;
        parsedPattern.patterns = [originalPattern];
        parsedPattern.allBasenames = basenames;
        return parsedPattern;
    }
    // repetition of common patterns (see above) {**/*.txt,**/*.png}
    function trivia3(pattern, options) {
        var parsedPatterns = aggregateBasenameMatches(pattern.slice(1, -1).split(',')
            .map(function (pattern) { return parsePattern(pattern, options); })
            .filter(function (pattern) { return pattern !== NULL; }), pattern);
        var n = parsedPatterns.length;
        if (!n) {
            return NULL;
        }
        if (n === 1) {
            return parsedPatterns[0];
        }
        var parsedPattern = function (path, basename) {
            for (var i = 0, n_1 = parsedPatterns.length; i < n_1; i++) {
                if (parsedPatterns[i](path, basename)) {
                    return pattern;
                }
            }
            return null;
        };
        var withBasenames = arrays.first(parsedPatterns, function (pattern) { return !!pattern.allBasenames; });
        if (withBasenames) {
            parsedPattern.allBasenames = withBasenames.allBasenames;
        }
        var allPaths = parsedPatterns.reduce(function (all, current) { return current.allPaths ? all.concat(current.allPaths) : all; }, []);
        if (allPaths.length) {
            parsedPattern.allPaths = allPaths;
        }
        return parsedPattern;
    }
    // common patterns: **/something/else just need endsWith check, something/else just needs and equals check
    function trivia4and5(path, pattern, matchPathEnds) {
        var nativePath = paths.nativeSep !== paths.sep ? path.replace(ALL_FORWARD_SLASHES, paths.nativeSep) : path;
        var nativePathEnd = paths.nativeSep + nativePath;
        var parsedPattern = matchPathEnds ? function (path, basename) {
            return path && (path === nativePath || strings.endsWith(path, nativePathEnd)) ? pattern : null;
        } : function (path, basename) {
            return path && path === nativePath ? pattern : null;
        };
        parsedPattern.allPaths = [(matchPathEnds ? '*/' : './') + path];
        return parsedPattern;
    }
    function toRegExp(pattern) {
        try {
            var regExp_1 = new RegExp("^" + parseRegExp(pattern) + "$");
            return function (path, basename) {
                regExp_1.lastIndex = 0; // reset RegExp to its initial state to reuse it!
                return path && regExp_1.test(path) ? pattern : null;
            };
        }
        catch (error) {
            return NULL;
        }
    }
    function match(arg1, path, hasSibling) {
        if (!arg1 || !path) {
            return false;
        }
        return parse(arg1)(path, undefined, hasSibling);
    }
    exports.match = match;
    function parse(arg1, options) {
        if (options === void 0) { options = {}; }
        if (!arg1) {
            return FALSE;
        }
        // Glob with String
        if (typeof arg1 === 'string' || isRelativePattern(arg1)) {
            var parsedPattern_1 = parsePattern(arg1, options);
            if (parsedPattern_1 === NULL) {
                return FALSE;
            }
            var resultPattern = function (path, basename) {
                return !!parsedPattern_1(path, basename);
            };
            if (parsedPattern_1.allBasenames) {
                resultPattern.allBasenames = parsedPattern_1.allBasenames;
            }
            if (parsedPattern_1.allPaths) {
                resultPattern.allPaths = parsedPattern_1.allPaths;
            }
            return resultPattern;
        }
        // Glob with Expression
        return parsedExpression(arg1, options);
    }
    exports.parse = parse;
    function isRelativePattern(obj) {
        var rp = obj;
        return rp && typeof rp.base === 'string' && typeof rp.pattern === 'string' && typeof rp.pathToRelative === 'function';
    }
    exports.isRelativePattern = isRelativePattern;
    function parsedExpression(expression, options) {
        var parsedPatterns = aggregateBasenameMatches(Object.getOwnPropertyNames(expression)
            .map(function (pattern) { return parseExpressionPattern(pattern, expression[pattern], options); })
            .filter(function (pattern) { return pattern !== NULL; }));
        var n = parsedPatterns.length;
        if (!n) {
            return NULL;
        }
        if (!parsedPatterns.some(function (parsedPattern) { return !!parsedPattern.requiresSiblings; })) {
            if (n === 1) {
                return parsedPatterns[0];
            }
            var resultExpression_1 = function (path, basename) {
                for (var i = 0, n_2 = parsedPatterns.length; i < n_2; i++) {
                    // Pattern matches path
                    var result = parsedPatterns[i](path, basename);
                    if (result) {
                        return result;
                    }
                }
                return null;
            };
            var withBasenames_1 = arrays.first(parsedPatterns, function (pattern) { return !!pattern.allBasenames; });
            if (withBasenames_1) {
                resultExpression_1.allBasenames = withBasenames_1.allBasenames;
            }
            var allPaths_1 = parsedPatterns.reduce(function (all, current) { return current.allPaths ? all.concat(current.allPaths) : all; }, []);
            if (allPaths_1.length) {
                resultExpression_1.allPaths = allPaths_1;
            }
            return resultExpression_1;
        }
        var resultExpression = function (path, basename, hasSibling) {
            var name = undefined;
            for (var i = 0, n_3 = parsedPatterns.length; i < n_3; i++) {
                // Pattern matches path
                var parsedPattern = parsedPatterns[i];
                if (parsedPattern.requiresSiblings && hasSibling) {
                    if (!basename) {
                        basename = paths.basename(path);
                    }
                    if (!name) {
                        name = basename.substr(0, basename.length - paths.extname(path).length);
                    }
                }
                var result = parsedPattern(path, basename, name, hasSibling);
                if (result) {
                    return result;
                }
            }
            return null;
        };
        var withBasenames = arrays.first(parsedPatterns, function (pattern) { return !!pattern.allBasenames; });
        if (withBasenames) {
            resultExpression.allBasenames = withBasenames.allBasenames;
        }
        var allPaths = parsedPatterns.reduce(function (all, current) { return current.allPaths ? all.concat(current.allPaths) : all; }, []);
        if (allPaths.length) {
            resultExpression.allPaths = allPaths;
        }
        return resultExpression;
    }
    function parseExpressionPattern(pattern, value, options) {
        if (value === false) {
            return NULL; // pattern is disabled
        }
        var parsedPattern = parsePattern(pattern, options);
        if (parsedPattern === NULL) {
            return NULL;
        }
        // Expression Pattern is <boolean>
        if (typeof value === 'boolean') {
            return parsedPattern;
        }
        // Expression Pattern is <SiblingClause>
        if (value) {
            var when_1 = value.when;
            if (typeof when_1 === 'string') {
                var result = function (path, basename, name, hasSibling) {
                    if (!hasSibling || !parsedPattern(path, basename)) {
                        return null;
                    }
                    var clausePattern = when_1.replace('$(basename)', name);
                    var matched = hasSibling(clausePattern);
                    return async_1.isThenable(matched) ?
                        matched.then(function (m) { return m ? pattern : null; }) :
                        matched ? pattern : null;
                };
                result.requiresSiblings = true;
                return result;
            }
        }
        // Expression is Anything
        return parsedPattern;
    }
    function aggregateBasenameMatches(parsedPatterns, result) {
        var basenamePatterns = parsedPatterns.filter(function (parsedPattern) { return !!parsedPattern.basenames; });
        if (basenamePatterns.length < 2) {
            return parsedPatterns;
        }
        var basenames = basenamePatterns.reduce(function (all, current) {
            var basenames = current.basenames;
            return basenames ? all.concat(basenames) : all;
        }, []);
        var patterns;
        if (result) {
            patterns = [];
            for (var i = 0, n = basenames.length; i < n; i++) {
                patterns.push(result);
            }
        }
        else {
            patterns = basenamePatterns.reduce(function (all, current) {
                var patterns = current.patterns;
                return patterns ? all.concat(patterns) : all;
            }, []);
        }
        var aggregate = function (path, basename) {
            if (!path) {
                return null;
            }
            if (!basename) {
                var i = void 0;
                for (i = path.length; i > 0; i--) {
                    var ch = path.charCodeAt(i - 1);
                    if (ch === 47 /* Slash */ || ch === 92 /* Backslash */) {
                        break;
                    }
                }
                basename = path.substr(i);
            }
            var index = basenames.indexOf(basename);
            return index !== -1 ? patterns[index] : null;
        };
        aggregate.basenames = basenames;
        aggregate.patterns = patterns;
        aggregate.allBasenames = basenames;
        var aggregatedPatterns = parsedPatterns.filter(function (parsedPattern) { return !parsedPattern.basenames; });
        aggregatedPatterns.push(aggregate);
        return aggregatedPatterns;
    }
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[424/*vs/base/common/mime*/], __M([0/*require*/,1/*exports*/,58/*vs/base/common/paths*/,8/*vs/base/common/strings*/,167/*vs/base/common/glob*/]), function (require, exports, paths, strings, glob_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.MIME_TEXT = 'text/plain';
    exports.MIME_UNKNOWN = 'application/unknown';
    var registeredAssociations = [];
    var nonUserRegisteredAssociations = [];
    var userRegisteredAssociations = [];
    /**
     * Associate a text mime to the registry.
     */
    function registerTextMime(association, warnOnOverwrite) {
        if (warnOnOverwrite === void 0) { warnOnOverwrite = false; }
        // Register
        var associationItem = toTextMimeAssociationItem(association);
        registeredAssociations.push(associationItem);
        if (!associationItem.userConfigured) {
            nonUserRegisteredAssociations.push(associationItem);
        }
        else {
            userRegisteredAssociations.push(associationItem);
        }
        // Check for conflicts unless this is a user configured association
        if (warnOnOverwrite && !associationItem.userConfigured) {
            registeredAssociations.forEach(function (a) {
                if (a.mime === associationItem.mime || a.userConfigured) {
                    return; // same mime or userConfigured is ok
                }
                if (associationItem.extension && a.extension === associationItem.extension) {
                    console.warn("Overwriting extension <<" + associationItem.extension + ">> to now point to mime <<" + associationItem.mime + ">>");
                }
                if (associationItem.filename && a.filename === associationItem.filename) {
                    console.warn("Overwriting filename <<" + associationItem.filename + ">> to now point to mime <<" + associationItem.mime + ">>");
                }
                if (associationItem.filepattern && a.filepattern === associationItem.filepattern) {
                    console.warn("Overwriting filepattern <<" + associationItem.filepattern + ">> to now point to mime <<" + associationItem.mime + ">>");
                }
                if (associationItem.firstline && a.firstline === associationItem.firstline) {
                    console.warn("Overwriting firstline <<" + associationItem.firstline + ">> to now point to mime <<" + associationItem.mime + ">>");
                }
            });
        }
    }
    exports.registerTextMime = registerTextMime;
    function toTextMimeAssociationItem(association) {
        return {
            id: association.id,
            mime: association.mime,
            filename: association.filename,
            extension: association.extension,
            filepattern: association.filepattern,
            firstline: association.firstline,
            userConfigured: association.userConfigured,
            filenameLowercase: association.filename ? association.filename.toLowerCase() : void 0,
            extensionLowercase: association.extension ? association.extension.toLowerCase() : void 0,
            filepatternLowercase: association.filepattern ? association.filepattern.toLowerCase() : void 0,
            filepatternOnPath: association.filepattern ? association.filepattern.indexOf(paths.sep) >= 0 : false
        };
    }
    /**
     * Given a file, return the best matching mime type for it
     */
    function guessMimeTypes(path, firstLine) {
        if (!path) {
            return [exports.MIME_UNKNOWN];
        }
        path = path.toLowerCase();
        var filename = paths.basename(path);
        // 1.) User configured mappings have highest priority
        var configuredMime = guessMimeTypeByPath(path, filename, userRegisteredAssociations);
        if (configuredMime) {
            return [configuredMime, exports.MIME_TEXT];
        }
        // 2.) Registered mappings have middle priority
        var registeredMime = guessMimeTypeByPath(path, filename, nonUserRegisteredAssociations);
        if (registeredMime) {
            return [registeredMime, exports.MIME_TEXT];
        }
        // 3.) Firstline has lowest priority
        if (firstLine) {
            var firstlineMime = guessMimeTypeByFirstline(firstLine);
            if (firstlineMime) {
                return [firstlineMime, exports.MIME_TEXT];
            }
        }
        return [exports.MIME_UNKNOWN];
    }
    exports.guessMimeTypes = guessMimeTypes;
    function guessMimeTypeByPath(path, filename, associations) {
        var filenameMatch = null;
        var patternMatch = null;
        var extensionMatch = null;
        // We want to prioritize associations based on the order they are registered so that the last registered
        // association wins over all other. This is for https://github.com/Microsoft/vscode/issues/20074
        for (var i = associations.length - 1; i >= 0; i--) {
            var association = associations[i];
            // First exact name match
            if (filename === association.filenameLowercase) {
                filenameMatch = association;
                break; // take it!
            }
            // Longest pattern match
            if (association.filepattern) {
                if (!patternMatch || association.filepattern.length > patternMatch.filepattern.length) {
                    var target = association.filepatternOnPath ? path : filename; // match on full path if pattern contains path separator
                    if (glob_1.match(association.filepatternLowercase, target)) {
                        patternMatch = association;
                    }
                }
            }
            // Longest extension match
            if (association.extension) {
                if (!extensionMatch || association.extension.length > extensionMatch.extension.length) {
                    if (strings.endsWith(filename, association.extensionLowercase)) {
                        extensionMatch = association;
                    }
                }
            }
        }
        // 1.) Exact name match has second highest prio
        if (filenameMatch) {
            return filenameMatch.mime;
        }
        // 2.) Match on pattern
        if (patternMatch) {
            return patternMatch.mime;
        }
        // 3.) Match on extension comes next
        if (extensionMatch) {
            return extensionMatch.mime;
        }
        return null;
    }
    function guessMimeTypeByFirstline(firstLine) {
        if (strings.startsWithUTF8BOM(firstLine)) {
            firstLine = firstLine.substr(1);
        }
        if (firstLine.length > 0) {
            for (var i = 0; i < registeredAssociations.length; ++i) {
                var association = registeredAssociations[i];
                if (!association.firstline) {
                    continue;
                }
                var matches = firstLine.match(association.firstline);
                if (matches && matches.length > 0) {
                    return association.mime;
                }
            }
        }
        return null;
    }
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[169/*vs/base/common/scrollable*/], __M([0/*require*/,1/*exports*/,6/*vs/base/common/event*/,2/*vs/base/common/lifecycle*/]), function (require, exports, event_1, lifecycle_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ScrollState = /** @class */ (function () {
        function ScrollState(width, scrollWidth, scrollLeft, height, scrollHeight, scrollTop) {
            width = width | 0;
            scrollWidth = scrollWidth | 0;
            scrollLeft = scrollLeft | 0;
            height = height | 0;
            scrollHeight = scrollHeight | 0;
            scrollTop = scrollTop | 0;
            if (width < 0) {
                width = 0;
            }
            if (scrollLeft + width > scrollWidth) {
                scrollLeft = scrollWidth - width;
            }
            if (scrollLeft < 0) {
                scrollLeft = 0;
            }
            if (height < 0) {
                height = 0;
            }
            if (scrollTop + height > scrollHeight) {
                scrollTop = scrollHeight - height;
            }
            if (scrollTop < 0) {
                scrollTop = 0;
            }
            this.width = width;
            this.scrollWidth = scrollWidth;
            this.scrollLeft = scrollLeft;
            this.height = height;
            this.scrollHeight = scrollHeight;
            this.scrollTop = scrollTop;
        }
        ScrollState.prototype.equals = function (other) {
            return (this.width === other.width
                && this.scrollWidth === other.scrollWidth
                && this.scrollLeft === other.scrollLeft
                && this.height === other.height
                && this.scrollHeight === other.scrollHeight
                && this.scrollTop === other.scrollTop);
        };
        ScrollState.prototype.withScrollDimensions = function (update) {
            return new ScrollState((typeof update.width !== 'undefined' ? update.width : this.width), (typeof update.scrollWidth !== 'undefined' ? update.scrollWidth : this.scrollWidth), this.scrollLeft, (typeof update.height !== 'undefined' ? update.height : this.height), (typeof update.scrollHeight !== 'undefined' ? update.scrollHeight : this.scrollHeight), this.scrollTop);
        };
        ScrollState.prototype.withScrollPosition = function (update) {
            return new ScrollState(this.width, this.scrollWidth, (typeof update.scrollLeft !== 'undefined' ? update.scrollLeft : this.scrollLeft), this.height, this.scrollHeight, (typeof update.scrollTop !== 'undefined' ? update.scrollTop : this.scrollTop));
        };
        ScrollState.prototype.createScrollEvent = function (previous) {
            var widthChanged = (this.width !== previous.width);
            var scrollWidthChanged = (this.scrollWidth !== previous.scrollWidth);
            var scrollLeftChanged = (this.scrollLeft !== previous.scrollLeft);
            var heightChanged = (this.height !== previous.height);
            var scrollHeightChanged = (this.scrollHeight !== previous.scrollHeight);
            var scrollTopChanged = (this.scrollTop !== previous.scrollTop);
            return {
                width: this.width,
                scrollWidth: this.scrollWidth,
                scrollLeft: this.scrollLeft,
                height: this.height,
                scrollHeight: this.scrollHeight,
                scrollTop: this.scrollTop,
                widthChanged: widthChanged,
                scrollWidthChanged: scrollWidthChanged,
                scrollLeftChanged: scrollLeftChanged,
                heightChanged: heightChanged,
                scrollHeightChanged: scrollHeightChanged,
                scrollTopChanged: scrollTopChanged,
            };
        };
        return ScrollState;
    }());
    exports.ScrollState = ScrollState;
    var Scrollable = /** @class */ (function (_super) {
        __extends(Scrollable, _super);
        function Scrollable(smoothScrollDuration, scheduleAtNextAnimationFrame) {
            var _this = _super.call(this) || this;
            _this._onScroll = _this._register(new event_1.Emitter());
            _this.onScroll = _this._onScroll.event;
            _this._smoothScrollDuration = smoothScrollDuration;
            _this._scheduleAtNextAnimationFrame = scheduleAtNextAnimationFrame;
            _this._state = new ScrollState(0, 0, 0, 0, 0, 0);
            _this._smoothScrolling = null;
            return _this;
        }
        Scrollable.prototype.dispose = function () {
            if (this._smoothScrolling) {
                this._smoothScrolling.dispose();
                this._smoothScrolling = null;
            }
            _super.prototype.dispose.call(this);
        };
        Scrollable.prototype.setSmoothScrollDuration = function (smoothScrollDuration) {
            this._smoothScrollDuration = smoothScrollDuration;
        };
        Scrollable.prototype.validateScrollPosition = function (scrollPosition) {
            return this._state.withScrollPosition(scrollPosition);
        };
        Scrollable.prototype.getScrollDimensions = function () {
            return this._state;
        };
        Scrollable.prototype.setScrollDimensions = function (dimensions) {
            var newState = this._state.withScrollDimensions(dimensions);
            this._setState(newState);
            // Validate outstanding animated scroll position target
            if (this._smoothScrolling) {
                this._smoothScrolling.acceptScrollDimensions(this._state);
            }
        };
        /**
         * Returns the final scroll position that the instance will have once the smooth scroll animation concludes.
         * If no scroll animation is occurring, it will return the current scroll position instead.
         */
        Scrollable.prototype.getFutureScrollPosition = function () {
            if (this._smoothScrolling) {
                return this._smoothScrolling.to;
            }
            return this._state;
        };
        /**
         * Returns the current scroll position.
         * Note: This result might be an intermediate scroll position, as there might be an ongoing smooth scroll animation.
         */
        Scrollable.prototype.getCurrentScrollPosition = function () {
            return this._state;
        };
        Scrollable.prototype.setScrollPositionNow = function (update) {
            // no smooth scrolling requested
            var newState = this._state.withScrollPosition(update);
            // Terminate any outstanding smooth scrolling
            if (this._smoothScrolling) {
                this._smoothScrolling.dispose();
                this._smoothScrolling = null;
            }
            this._setState(newState);
        };
        Scrollable.prototype.setScrollPositionSmooth = function (update) {
            var _this = this;
            if (this._smoothScrollDuration === 0) {
                // Smooth scrolling not supported.
                return this.setScrollPositionNow(update);
            }
            if (this._smoothScrolling) {
                // Combine our pending scrollLeft/scrollTop with incoming scrollLeft/scrollTop
                update = {
                    scrollLeft: (typeof update.scrollLeft === 'undefined' ? this._smoothScrolling.to.scrollLeft : update.scrollLeft),
                    scrollTop: (typeof update.scrollTop === 'undefined' ? this._smoothScrolling.to.scrollTop : update.scrollTop)
                };
                // Validate `update`
                var validTarget = this._state.withScrollPosition(update);
                if (this._smoothScrolling.to.scrollLeft === validTarget.scrollLeft && this._smoothScrolling.to.scrollTop === validTarget.scrollTop) {
                    // No need to interrupt or extend the current animation since we're going to the same place
                    return;
                }
                var newSmoothScrolling = this._smoothScrolling.combine(this._state, validTarget, this._smoothScrollDuration);
                this._smoothScrolling.dispose();
                this._smoothScrolling = newSmoothScrolling;
            }
            else {
                // Validate `update`
                var validTarget = this._state.withScrollPosition(update);
                this._smoothScrolling = SmoothScrollingOperation.start(this._state, validTarget, this._smoothScrollDuration);
            }
            // Begin smooth scrolling animation
            this._smoothScrolling.animationFrameDisposable = this._scheduleAtNextAnimationFrame(function () {
                if (!_this._smoothScrolling) {
                    return;
                }
                _this._smoothScrolling.animationFrameDisposable = null;
                _this._performSmoothScrolling();
            });
        };
        Scrollable.prototype._performSmoothScrolling = function () {
            var _this = this;
            if (!this._smoothScrolling) {
                return;
            }
            var update = this._smoothScrolling.tick();
            var newState = this._state.withScrollPosition(update);
            this._setState(newState);
            if (update.isDone) {
                this._smoothScrolling.dispose();
                this._smoothScrolling = null;
                return;
            }
            // Continue smooth scrolling animation
            this._smoothScrolling.animationFrameDisposable = this._scheduleAtNextAnimationFrame(function () {
                if (!_this._smoothScrolling) {
                    return;
                }
                _this._smoothScrolling.animationFrameDisposable = null;
                _this._performSmoothScrolling();
            });
        };
        Scrollable.prototype._setState = function (newState) {
            var oldState = this._state;
            if (oldState.equals(newState)) {
                // no change
                return;
            }
            this._state = newState;
            this._onScroll.fire(this._state.createScrollEvent(oldState));
        };
        return Scrollable;
    }(lifecycle_1.Disposable));
    exports.Scrollable = Scrollable;
    var SmoothScrollingUpdate = /** @class */ (function () {
        function SmoothScrollingUpdate(scrollLeft, scrollTop, isDone) {
            this.scrollLeft = scrollLeft;
            this.scrollTop = scrollTop;
            this.isDone = isDone;
        }
        return SmoothScrollingUpdate;
    }());
    exports.SmoothScrollingUpdate = SmoothScrollingUpdate;
    function createEaseOutCubic(from, to) {
        var delta = to - from;
        return function (completion) {
            return from + delta * easeOutCubic(completion);
        };
    }
    function createComposed(a, b, cut) {
        return function (completion) {
            if (completion < cut) {
                return a(completion / cut);
            }
            return b((completion - cut) / (1 - cut));
        };
    }
    var SmoothScrollingOperation = /** @class */ (function () {
        function SmoothScrollingOperation(from, to, startTime, duration) {
            this.from = from;
            this.to = to;
            this.duration = duration;
            this._startTime = startTime;
            this.animationFrameDisposable = null;
            this._initAnimations();
        }
        SmoothScrollingOperation.prototype._initAnimations = function () {
            this.scrollLeft = this._initAnimation(this.from.scrollLeft, this.to.scrollLeft, this.to.width);
            this.scrollTop = this._initAnimation(this.from.scrollTop, this.to.scrollTop, this.to.height);
        };
        SmoothScrollingOperation.prototype._initAnimation = function (from, to, viewportSize) {
            var delta = Math.abs(from - to);
            if (delta > 2.5 * viewportSize) {
                var stop1 = void 0, stop2 = void 0;
                if (from < to) {
                    // scroll to 75% of the viewportSize
                    stop1 = from + 0.75 * viewportSize;
                    stop2 = to - 0.75 * viewportSize;
                }
                else {
                    stop1 = from - 0.75 * viewportSize;
                    stop2 = to + 0.75 * viewportSize;
                }
                return createComposed(createEaseOutCubic(from, stop1), createEaseOutCubic(stop2, to), 0.33);
            }
            return createEaseOutCubic(from, to);
        };
        SmoothScrollingOperation.prototype.dispose = function () {
            if (this.animationFrameDisposable !== null) {
                this.animationFrameDisposable.dispose();
                this.animationFrameDisposable = null;
            }
        };
        SmoothScrollingOperation.prototype.acceptScrollDimensions = function (state) {
            this.to = state.withScrollPosition(this.to);
            this._initAnimations();
        };
        SmoothScrollingOperation.prototype.tick = function () {
            return this._tick(Date.now());
        };
        SmoothScrollingOperation.prototype._tick = function (now) {
            var completion = (now - this._startTime) / this.duration;
            if (completion < 1) {
                var newScrollLeft = this.scrollLeft(completion);
                var newScrollTop = this.scrollTop(completion);
                return new SmoothScrollingUpdate(newScrollLeft, newScrollTop, false);
            }
            return new SmoothScrollingUpdate(this.to.scrollLeft, this.to.scrollTop, true);
        };
        SmoothScrollingOperation.prototype.combine = function (from, to, duration) {
            return SmoothScrollingOperation.start(from, to, duration);
        };
        SmoothScrollingOperation.start = function (from, to, duration) {
            // +10 / -10 : pretend the animation already started for a quicker response to a scroll request
            duration = duration + 10;
            var startTime = Date.now() - 10;
            return new SmoothScrollingOperation(from, to, startTime, duration);
        };
        return SmoothScrollingOperation;
    }());
    exports.SmoothScrollingOperation = SmoothScrollingOperation;
    function easeInCubic(t) {
        return Math.pow(t, 3);
    }
    function easeOutCubic(t) {
        return 1 - easeInCubic(1 - t);
    }
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[170/*vs/base/common/winjs.polyfill.promise*/], __M([0/*require*/,1/*exports*/,53/*vs/base/common/winjs.base*/,17/*vs/base/common/platform*/,16/*vs/base/common/async*/]), function (require, exports, winjs_base_1, platform, async_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function isWinJSPromise(candidate) {
        return async_1.isThenable(candidate) && typeof candidate.done === 'function';
    }
    /**
     * A polyfill for the native promises. The implementation is based on
     * WinJS promises but tries to gap differences between winjs promises
     * and native promises.
     */
    var PolyfillPromise = /** @class */ (function () {
        function PolyfillPromise(initOrPromise) {
            if (isWinJSPromise(initOrPromise)) {
                this._winjsPromise = initOrPromise;
            }
            else {
                this._winjsPromise = new winjs_base_1.Promise(function (resolve, reject) {
                    var initializing = true;
                    initOrPromise(function (value) {
                        if (!initializing) {
                            resolve(value);
                        }
                        else {
                            platform.setImmediate(function () { return resolve(value); });
                        }
                    }, function (err) {
                        if (!initializing) {
                            reject(err);
                        }
                        else {
                            platform.setImmediate(function () { return reject(err); });
                        }
                    });
                    initializing = false;
                });
            }
        }
        PolyfillPromise.all = function (thenables) {
            return new PolyfillPromise(winjs_base_1.Promise.join(thenables).then(null, function (values) {
                // WinJSPromise returns a sparse array whereas
                // native promises return the *first* error
                for (var key in values) {
                    if (values.hasOwnProperty(key)) {
                        return values[key];
                    }
                }
            }));
        };
        PolyfillPromise.race = function (thenables) {
            // WinJSPromise returns `{ key: <index/key>, value: <promise> }`
            // from the `any` call and Promise.race just wants the value
            return new PolyfillPromise(winjs_base_1.Promise.any(thenables).then(function (entry) { return entry.value; }, function (err) { return err.value; }));
        };
        PolyfillPromise.resolve = function (value) {
            return new PolyfillPromise(winjs_base_1.Promise.wrap(value));
        };
        PolyfillPromise.reject = function (value) {
            return new PolyfillPromise(winjs_base_1.Promise.wrapError(value));
        };
        PolyfillPromise.prototype.then = function (onFulfilled, onRejected) {
            var sync = true;
            // To support chaining, we need to return the value of the
            // onFulfilled and onRejected callback.
            // WinJSPromise supports a flat-map style #then, ie. the callbacks
            // passed to WinJSPromise#then can return a Promise.
            var promise = new PolyfillPromise(this._winjsPromise.then(onFulfilled && function (value) {
                if (!sync) {
                    return onFulfilled(value);
                }
                else {
                    return new winjs_base_1.Promise(function (resolve, reject) {
                        platform.setImmediate(function () {
                            var result;
                            try {
                                result = onFulfilled(value);
                            }
                            catch (err2) {
                                reject(err2);
                                return;
                            }
                            resolve(result);
                        });
                    });
                }
            }, onRejected && function (err) {
                if (!sync) {
                    return onRejected(err);
                }
                else {
                    return new winjs_base_1.Promise(function (resolve, reject) {
                        platform.setImmediate(function () {
                            var result;
                            try {
                                result = onRejected(err);
                            }
                            catch (err2) {
                                reject(err2);
                                return;
                            }
                            resolve(result);
                        });
                    });
                }
            }));
            sync = false;
            return promise;
        };
        PolyfillPromise.prototype.catch = function (onRejected) {
            return this.then(null, onRejected);
        };
        return PolyfillPromise;
    }());
    exports.PolyfillPromise = PolyfillPromise;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[148/*vs/base/common/worker/simpleWorker*/], __M([0/*require*/,1/*exports*/,11/*vs/base/common/errors*/,2/*vs/base/common/lifecycle*/,17/*vs/base/common/platform*/,170/*vs/base/common/winjs.polyfill.promise*/]), function (require, exports, errors_1, lifecycle_1, platform_1, winjs_polyfill_promise_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var global = self;
    // When missing, polyfill the native promise
    // with our winjs-based polyfill
    if (typeof global.Promise === 'undefined') {
        global.Promise = winjs_polyfill_promise_1.PolyfillPromise;
    }
    var INITIALIZE = '$initialize';
    var webWorkerWarningLogged = false;
    function logOnceWebWorkerWarning(err) {
        if (!platform_1.isWeb) {
            // running tests
            return;
        }
        if (!webWorkerWarningLogged) {
            webWorkerWarningLogged = true;
            console.warn('Could not create web worker(s). Falling back to loading web worker code in main thread, which might cause UI freezes. Please see https://github.com/Microsoft/monaco-editor#faq');
        }
        console.warn(err.message);
    }
    exports.logOnceWebWorkerWarning = logOnceWebWorkerWarning;
    var SimpleWorkerProtocol = /** @class */ (function () {
        function SimpleWorkerProtocol(handler) {
            this._workerId = -1;
            this._handler = handler;
            this._lastSentReq = 0;
            this._pendingReplies = Object.create(null);
        }
        SimpleWorkerProtocol.prototype.setWorkerId = function (workerId) {
            this._workerId = workerId;
        };
        SimpleWorkerProtocol.prototype.sendMessage = function (method, args) {
            var _this = this;
            var req = String(++this._lastSentReq);
            return new Promise(function (resolve, reject) {
                _this._pendingReplies[req] = {
                    resolve: resolve,
                    reject: reject
                };
                _this._send({
                    vsWorker: _this._workerId,
                    req: req,
                    method: method,
                    args: args
                });
            });
        };
        SimpleWorkerProtocol.prototype.handleMessage = function (serializedMessage) {
            var message;
            try {
                message = JSON.parse(serializedMessage);
            }
            catch (e) {
                // nothing
                return;
            }
            if (!message || !message.vsWorker) {
                return;
            }
            if (this._workerId !== -1 && message.vsWorker !== this._workerId) {
                return;
            }
            this._handleMessage(message);
        };
        SimpleWorkerProtocol.prototype._handleMessage = function (msg) {
            var _this = this;
            if (msg.seq) {
                var replyMessage = msg;
                if (!this._pendingReplies[replyMessage.seq]) {
                    console.warn('Got reply to unknown seq');
                    return;
                }
                var reply = this._pendingReplies[replyMessage.seq];
                delete this._pendingReplies[replyMessage.seq];
                if (replyMessage.err) {
                    var err = replyMessage.err;
                    if (replyMessage.err.$isError) {
                        err = new Error();
                        err.name = replyMessage.err.name;
                        err.message = replyMessage.err.message;
                        err.stack = replyMessage.err.stack;
                    }
                    reply.reject(err);
                    return;
                }
                reply.resolve(replyMessage.res);
                return;
            }
            var requestMessage = msg;
            var req = requestMessage.req;
            var result = this._handler.handleMessage(requestMessage.method, requestMessage.args);
            result.then(function (r) {
                _this._send({
                    vsWorker: _this._workerId,
                    seq: req,
                    res: r,
                    err: undefined
                });
            }, function (e) {
                if (e.detail instanceof Error) {
                    // Loading errors have a detail property that points to the actual error
                    e.detail = errors_1.transformErrorForSerialization(e.detail);
                }
                _this._send({
                    vsWorker: _this._workerId,
                    seq: req,
                    res: undefined,
                    err: errors_1.transformErrorForSerialization(e)
                });
            });
        };
        SimpleWorkerProtocol.prototype._send = function (msg) {
            var strMsg = JSON.stringify(msg);
            // console.log('SENDING: ' + strMsg);
            this._handler.sendMessage(strMsg);
        };
        return SimpleWorkerProtocol;
    }());
    /**
     * Main thread side
     */
    var SimpleWorkerClient = /** @class */ (function (_super) {
        __extends(SimpleWorkerClient, _super);
        function SimpleWorkerClient(workerFactory, moduleId) {
            var _this = _super.call(this) || this;
            var lazyProxyReject = null;
            _this._worker = _this._register(workerFactory.create('vs/base/common/worker/simpleWorker', function (msg) {
                _this._protocol.handleMessage(msg);
            }, function (err) {
                // in Firefox, web workers fail lazily :(
                // we will reject the proxy
                if (lazyProxyReject) {
                    lazyProxyReject(err);
                }
            }));
            _this._protocol = new SimpleWorkerProtocol({
                sendMessage: function (msg) {
                    _this._worker.postMessage(msg);
                },
                handleMessage: function (method, args) {
                    // Intentionally not supporting worker -> main requests
                    return Promise.resolve(null);
                }
            });
            _this._protocol.setWorkerId(_this._worker.getId());
            // Gather loader configuration
            var loaderConfiguration = null;
            if (typeof self.require !== 'undefined' && typeof self.require.getConfig === 'function') {
                // Get the configuration from the Monaco AMD Loader
                loaderConfiguration = self.require.getConfig();
            }
            else if (typeof self.requirejs !== 'undefined') {
                // Get the configuration from requirejs
                loaderConfiguration = self.requirejs.s.contexts._.config;
            }
            // Send initialize message
            _this._onModuleLoaded = _this._protocol.sendMessage(INITIALIZE, [
                _this._worker.getId(),
                moduleId,
                loaderConfiguration
            ]);
            _this._lazyProxy = new Promise(function (resolve, reject) {
                lazyProxyReject = reject;
                _this._onModuleLoaded.then(function (availableMethods) {
                    var proxy = {};
                    for (var i = 0; i < availableMethods.length; i++) {
                        proxy[availableMethods[i]] = createProxyMethod(availableMethods[i], proxyMethodRequest);
                    }
                    resolve(proxy);
                }, function (e) {
                    reject(e);
                    _this._onError('Worker failed to load ' + moduleId, e);
                });
            });
            // Create proxy to loaded code
            var proxyMethodRequest = function (method, args) {
                return _this._request(method, args);
            };
            var createProxyMethod = function (method, proxyMethodRequest) {
                return function () {
                    var args = Array.prototype.slice.call(arguments, 0);
                    return proxyMethodRequest(method, args);
                };
            };
            return _this;
        }
        SimpleWorkerClient.prototype.getProxyObject = function () {
            return this._lazyProxy;
        };
        SimpleWorkerClient.prototype._request = function (method, args) {
            var _this = this;
            return new Promise(function (resolve, reject) {
                _this._onModuleLoaded.then(function () {
                    _this._protocol.sendMessage(method, args).then(resolve, reject);
                }, reject);
            });
        };
        SimpleWorkerClient.prototype._onError = function (message, error) {
            console.error(message);
            console.info(error);
        };
        return SimpleWorkerClient;
    }(lifecycle_1.Disposable));
    exports.SimpleWorkerClient = SimpleWorkerClient;
    /**
     * Worker side
     */
    var SimpleWorkerServer = /** @class */ (function () {
        function SimpleWorkerServer(postSerializedMessage, requestHandler) {
            var _this = this;
            this._requestHandler = requestHandler;
            this._protocol = new SimpleWorkerProtocol({
                sendMessage: function (msg) {
                    postSerializedMessage(msg);
                },
                handleMessage: function (method, args) { return _this._handleMessage(method, args); }
            });
        }
        SimpleWorkerServer.prototype.onmessage = function (msg) {
            this._protocol.handleMessage(msg);
        };
        SimpleWorkerServer.prototype._handleMessage = function (method, args) {
            if (method === INITIALIZE) {
                return this.initialize(args[0], args[1], args[2]);
            }
            if (!this._requestHandler || typeof this._requestHandler[method] !== 'function') {
                return Promise.reject(new Error('Missing requestHandler or method: ' + method));
            }
            try {
                return Promise.resolve(this._requestHandler[method].apply(this._requestHandler, args));
            }
            catch (e) {
                return Promise.reject(e);
            }
        };
        SimpleWorkerServer.prototype.initialize = function (workerId, moduleId, loaderConfig) {
            var _this = this;
            this._protocol.setWorkerId(workerId);
            if (this._requestHandler) {
                // static request handler
                var methods = [];
                for (var prop in this._requestHandler) {
                    if (typeof this._requestHandler[prop] === 'function') {
                        methods.push(prop);
                    }
                }
                return Promise.resolve(methods);
            }
            if (loaderConfig) {
                // Remove 'baseUrl', handling it is beyond scope for now
                if (typeof loaderConfig.baseUrl !== 'undefined') {
                    delete loaderConfig['baseUrl'];
                }
                if (typeof loaderConfig.paths !== 'undefined') {
                    if (typeof loaderConfig.paths.vs !== 'undefined') {
                        delete loaderConfig.paths['vs'];
                    }
                }
                // Since this is in a web worker, enable catching errors
                loaderConfig.catchError = true;
                self.require.config(loaderConfig);
            }
            return new Promise(function (resolve, reject) {
                // Use the global require to be sure to get the global config
                self.require([moduleId], function () {
                    var result = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        result[_i] = arguments[_i];
                    }
                    var handlerModule = result[0];
                    _this._requestHandler = handlerModule.create();
                    if (!_this._requestHandler) {
                        reject(new Error("No RequestHandler!"));
                        return;
                    }
                    var methods = [];
                    for (var prop in _this._requestHandler) {
                        if (typeof _this._requestHandler[prop] === 'function') {
                            methods.push(prop);
                        }
                    }
                    resolve(methods);
                }, reject);
            });
        };
        return SimpleWorkerServer;
    }());
    exports.SimpleWorkerServer = SimpleWorkerServer;
    /**
     * Called on the worker side
     */
    function create(postMessage) {
        return new SimpleWorkerServer(postMessage, null);
    }
    exports.create = create;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[437/*vs/base/parts/quickopen/browser/quickOpenViewer*/], __M([0/*require*/,1/*exports*/,53/*vs/base/common/winjs.base*/,32/*vs/base/common/types*/]), function (require, exports, winjs_base_1, types_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var DataSource = /** @class */ (function () {
        function DataSource(arg) {
            this.modelProvider = types_1.isFunction(arg.getModel) ? arg : { getModel: function () { return arg; } };
        }
        DataSource.prototype.getId = function (tree, element) {
            if (!element) {
                return null;
            }
            var model = this.modelProvider.getModel();
            return model === element ? '__root__' : model.dataSource.getId(element);
        };
        DataSource.prototype.hasChildren = function (tree, element) {
            var model = this.modelProvider.getModel();
            return model && model === element && model.entries.length > 0;
        };
        DataSource.prototype.getChildren = function (tree, element) {
            var model = this.modelProvider.getModel();
            return winjs_base_1.TPromise.as(model === element ? model.entries : []);
        };
        DataSource.prototype.getParent = function (tree, element) {
            return winjs_base_1.TPromise.as(null);
        };
        return DataSource;
    }());
    exports.DataSource = DataSource;
    var AccessibilityProvider = /** @class */ (function () {
        function AccessibilityProvider(modelProvider) {
            this.modelProvider = modelProvider;
        }
        AccessibilityProvider.prototype.getAriaLabel = function (tree, element) {
            var model = this.modelProvider.getModel();
            return model.accessibilityProvider && model.accessibilityProvider.getAriaLabel(element);
        };
        AccessibilityProvider.prototype.getPosInSet = function (tree, element) {
            var model = this.modelProvider.getModel();
            var i = 0;
            if (model.filter) {
                for (var _i = 0, _a = model.entries; _i < _a.length; _i++) {
                    var entry = _a[_i];
                    if (model.filter.isVisible(entry)) {
                        i++;
                    }
                    if (entry === element) {
                        break;
                    }
                }
            }
            else {
                i = model.entries.indexOf(element) + 1;
            }
            return String(i);
        };
        AccessibilityProvider.prototype.getSetSize = function () {
            var model = this.modelProvider.getModel();
            var n = 0;
            if (model.filter) {
                for (var _i = 0, _a = model.entries; _i < _a.length; _i++) {
                    var entry = _a[_i];
                    if (model.filter.isVisible(entry)) {
                        n++;
                    }
                }
            }
            else {
                n = model.entries.length;
            }
            return String(n);
        };
        return AccessibilityProvider;
    }());
    exports.AccessibilityProvider = AccessibilityProvider;
    var Filter = /** @class */ (function () {
        function Filter(modelProvider) {
            this.modelProvider = modelProvider;
        }
        Filter.prototype.isVisible = function (tree, element) {
            var model = this.modelProvider.getModel();
            if (!model.filter) {
                return true;
            }
            return model.filter.isVisible(element);
        };
        return Filter;
    }());
    exports.Filter = Filter;
    var Renderer = /** @class */ (function () {
        function Renderer(modelProvider, styles) {
            this.modelProvider = modelProvider;
            this.styles = styles;
        }
        Renderer.prototype.updateStyles = function (styles) {
            this.styles = styles;
        };
        Renderer.prototype.getHeight = function (tree, element) {
            var model = this.modelProvider.getModel();
            return model.renderer.getHeight(element);
        };
        Renderer.prototype.getTemplateId = function (tree, element) {
            var model = this.modelProvider.getModel();
            return model.renderer.getTemplateId(element);
        };
        Renderer.prototype.renderTemplate = function (tree, templateId, container) {
            var model = this.modelProvider.getModel();
            return model.renderer.renderTemplate(templateId, container, this.styles);
        };
        Renderer.prototype.renderElement = function (tree, element, templateId, templateData) {
            var model = this.modelProvider.getModel();
            model.renderer.renderElement(element, templateId, templateData, this.styles);
        };
        Renderer.prototype.disposeTemplate = function (tree, templateId, templateData) {
            var model = this.modelProvider.getModel();
            model.renderer.disposeTemplate(templateId, templateData);
        };
        return Renderer;
    }());
    exports.Renderer = Renderer;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[440/*vs/base/parts/tree/browser/tree*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ContextMenuEvent = /** @class */ (function () {
        function ContextMenuEvent(posx, posy, target) {
            this._posx = posx;
            this._posy = posy;
            this._target = target;
        }
        ContextMenuEvent.prototype.preventDefault = function () {
            // no-op
        };
        ContextMenuEvent.prototype.stopPropagation = function () {
            // no-op
        };
        Object.defineProperty(ContextMenuEvent.prototype, "target", {
            get: function () {
                return this._target;
            },
            enumerable: true,
            configurable: true
        });
        return ContextMenuEvent;
    }());
    exports.ContextMenuEvent = ContextMenuEvent;
    var MouseContextMenuEvent = /** @class */ (function (_super) {
        __extends(MouseContextMenuEvent, _super);
        function MouseContextMenuEvent(originalEvent) {
            var _this = _super.call(this, originalEvent.posx, originalEvent.posy, originalEvent.target) || this;
            _this.originalEvent = originalEvent;
            return _this;
        }
        MouseContextMenuEvent.prototype.preventDefault = function () {
            this.originalEvent.preventDefault();
        };
        MouseContextMenuEvent.prototype.stopPropagation = function () {
            this.originalEvent.stopPropagation();
        };
        return MouseContextMenuEvent;
    }(ContextMenuEvent));
    exports.MouseContextMenuEvent = MouseContextMenuEvent;
    var KeyboardContextMenuEvent = /** @class */ (function (_super) {
        __extends(KeyboardContextMenuEvent, _super);
        function KeyboardContextMenuEvent(posx, posy, originalEvent) {
            var _this = _super.call(this, posx, posy, originalEvent.target) || this;
            _this.originalEvent = originalEvent;
            return _this;
        }
        KeyboardContextMenuEvent.prototype.preventDefault = function () {
            this.originalEvent.preventDefault();
        };
        KeyboardContextMenuEvent.prototype.stopPropagation = function () {
            this.originalEvent.stopPropagation();
        };
        return KeyboardContextMenuEvent;
    }(ContextMenuEvent));
    exports.KeyboardContextMenuEvent = KeyboardContextMenuEvent;
});

define(__m[88/*vs/base/parts/tree/browser/treeDefaults*/], __M([0/*require*/,1/*exports*/,17/*vs/base/common/platform*/,11/*vs/base/common/errors*/,7/*vs/base/browser/dom*/,36/*vs/base/common/keyCodes*/]), function (require, exports, platform, errors, dom, keyCodes_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var KeybindingDispatcher = /** @class */ (function () {
        function KeybindingDispatcher() {
            this._arr = [];
        }
        KeybindingDispatcher.prototype.set = function (keybinding, callback) {
            this._arr.push({
                keybinding: keyCodes_1.createKeybinding(keybinding, platform.OS),
                callback: callback
            });
        };
        KeybindingDispatcher.prototype.dispatch = function (keybinding) {
            // Loop from the last to the first to handle overwrites
            for (var i = this._arr.length - 1; i >= 0; i--) {
                var item = this._arr[i];
                if (keybinding.equals(item.keybinding)) {
                    return item.callback;
                }
            }
            return null;
        };
        return KeybindingDispatcher;
    }());
    exports.KeybindingDispatcher = KeybindingDispatcher;
    var DefaultController = /** @class */ (function () {
        function DefaultController(options) {
            if (options === void 0) { options = { clickBehavior: 0 /* ON_MOUSE_DOWN */, keyboardSupport: true, openMode: 0 /* SINGLE_CLICK */ }; }
            var _this = this;
            this.options = options;
            this.downKeyBindingDispatcher = new KeybindingDispatcher();
            this.upKeyBindingDispatcher = new KeybindingDispatcher();
            if (typeof options.keyboardSupport !== 'boolean' || options.keyboardSupport) {
                this.downKeyBindingDispatcher.set(16 /* UpArrow */, function (t, e) { return _this.onUp(t, e); });
                this.downKeyBindingDispatcher.set(18 /* DownArrow */, function (t, e) { return _this.onDown(t, e); });
                this.downKeyBindingDispatcher.set(15 /* LeftArrow */, function (t, e) { return _this.onLeft(t, e); });
                this.downKeyBindingDispatcher.set(17 /* RightArrow */, function (t, e) { return _this.onRight(t, e); });
                if (platform.isMacintosh) {
                    this.downKeyBindingDispatcher.set(2048 /* CtrlCmd */ | 16 /* UpArrow */, function (t, e) { return _this.onLeft(t, e); });
                    this.downKeyBindingDispatcher.set(256 /* WinCtrl */ | 44 /* KEY_N */, function (t, e) { return _this.onDown(t, e); });
                    this.downKeyBindingDispatcher.set(256 /* WinCtrl */ | 46 /* KEY_P */, function (t, e) { return _this.onUp(t, e); });
                }
                this.downKeyBindingDispatcher.set(11 /* PageUp */, function (t, e) { return _this.onPageUp(t, e); });
                this.downKeyBindingDispatcher.set(12 /* PageDown */, function (t, e) { return _this.onPageDown(t, e); });
                this.downKeyBindingDispatcher.set(14 /* Home */, function (t, e) { return _this.onHome(t, e); });
                this.downKeyBindingDispatcher.set(13 /* End */, function (t, e) { return _this.onEnd(t, e); });
                this.downKeyBindingDispatcher.set(10 /* Space */, function (t, e) { return _this.onSpace(t, e); });
                this.downKeyBindingDispatcher.set(9 /* Escape */, function (t, e) { return _this.onEscape(t, e); });
                this.upKeyBindingDispatcher.set(3 /* Enter */, this.onEnter.bind(this));
                this.upKeyBindingDispatcher.set(2048 /* CtrlCmd */ | 3 /* Enter */, this.onEnter.bind(this));
            }
        }
        DefaultController.prototype.onMouseDown = function (tree, element, event, origin) {
            if (origin === void 0) { origin = 'mouse'; }
            if (this.options.clickBehavior === 0 /* ON_MOUSE_DOWN */ && (event.leftButton || event.middleButton)) {
                if (event.target) {
                    if (event.target.tagName && event.target.tagName.toLowerCase() === 'input') {
                        return false; // Ignore event if target is a form input field (avoids browser specific issues)
                    }
                    if (dom.findParentWithClass(event.target, 'scrollbar', 'monaco-tree')) {
                        return false;
                    }
                    if (dom.findParentWithClass(event.target, 'monaco-action-bar', 'row')) { // TODO@Joao not very nice way of checking for the action bar (implicit knowledge)
                        return false; // Ignore event if target is over an action bar of the row
                    }
                }
                // Propagate to onLeftClick now
                return this.onLeftClick(tree, element, event, origin);
            }
            return false;
        };
        DefaultController.prototype.onClick = function (tree, element, event) {
            var isMac = platform.isMacintosh;
            // A Ctrl click on the Mac is a context menu event
            if (isMac && event.ctrlKey) {
                event.preventDefault();
                event.stopPropagation();
                return false;
            }
            if (event.target && event.target.tagName && event.target.tagName.toLowerCase() === 'input') {
                return false; // Ignore event if target is a form input field (avoids browser specific issues)
            }
            if (this.options.clickBehavior === 0 /* ON_MOUSE_DOWN */ && (event.leftButton || event.middleButton)) {
                return false; // Already handled by onMouseDown
            }
            return this.onLeftClick(tree, element, event);
        };
        DefaultController.prototype.onLeftClick = function (tree, element, eventish, origin) {
            if (origin === void 0) { origin = 'mouse'; }
            var event = eventish;
            var payload = { origin: origin, originalEvent: eventish, didClickOnTwistie: this.isClickOnTwistie(event) };
            if (tree.getInput() === element) {
                tree.clearFocus(payload);
                tree.clearSelection(payload);
            }
            else {
                var isSingleMouseDown = eventish && event.browserEvent && event.browserEvent.type === 'mousedown' && event.browserEvent.detail === 1;
                if (!isSingleMouseDown) {
                    eventish.preventDefault(); // we cannot preventDefault onMouseDown with single click because this would break DND otherwise
                }
                eventish.stopPropagation();
                tree.domFocus();
                tree.setSelection([element], payload);
                tree.setFocus(element, payload);
                if (this.shouldToggleExpansion(element, event, origin)) {
                    if (tree.isExpanded(element)) {
                        tree.collapse(element).then(null, errors.onUnexpectedError);
                    }
                    else {
                        tree.expand(element).then(null, errors.onUnexpectedError);
                    }
                }
            }
            return true;
        };
        DefaultController.prototype.shouldToggleExpansion = function (element, event, origin) {
            var isDoubleClick = (origin === 'mouse' && event.detail === 2);
            return this.openOnSingleClick || isDoubleClick || this.isClickOnTwistie(event);
        };
        DefaultController.prototype.setOpenMode = function (openMode) {
            this.options.openMode = openMode;
        };
        Object.defineProperty(DefaultController.prototype, "openOnSingleClick", {
            get: function () {
                return this.options.openMode === 0 /* SINGLE_CLICK */;
            },
            enumerable: true,
            configurable: true
        });
        DefaultController.prototype.isClickOnTwistie = function (event) {
            var element = event.target;
            if (!dom.hasClass(element, 'content')) {
                return false;
            }
            var twistieStyle = window.getComputedStyle(element, ':before');
            if (twistieStyle.backgroundImage === 'none' || twistieStyle.display === 'none') {
                return false;
            }
            var twistieWidth = parseInt(twistieStyle.width) + parseInt(twistieStyle.paddingRight);
            return event.browserEvent.offsetX <= twistieWidth;
        };
        DefaultController.prototype.onContextMenu = function (tree, element, event) {
            if (event.target && event.target.tagName && event.target.tagName.toLowerCase() === 'input') {
                return false; // allow context menu on input fields
            }
            // Prevent native context menu from showing up
            if (event) {
                event.preventDefault();
                event.stopPropagation();
            }
            return false;
        };
        DefaultController.prototype.onTap = function (tree, element, event) {
            var target = event.initialTarget;
            if (target && target.tagName && target.tagName.toLowerCase() === 'input') {
                return false; // Ignore event if target is a form input field (avoids browser specific issues)
            }
            return this.onLeftClick(tree, element, event, 'touch');
        };
        DefaultController.prototype.onKeyDown = function (tree, event) {
            return this.onKey(this.downKeyBindingDispatcher, tree, event);
        };
        DefaultController.prototype.onKeyUp = function (tree, event) {
            return this.onKey(this.upKeyBindingDispatcher, tree, event);
        };
        DefaultController.prototype.onKey = function (bindings, tree, event) {
            var handler = bindings.dispatch(event.toKeybinding());
            if (handler) {
                // TODO: TS 3.1 upgrade. Why are we checking against void?
                if (handler(tree, event)) {
                    event.preventDefault();
                    event.stopPropagation();
                    return true;
                }
            }
            return false;
        };
        DefaultController.prototype.onUp = function (tree, event) {
            var payload = { origin: 'keyboard', originalEvent: event };
            if (tree.getHighlight()) {
                tree.clearHighlight(payload);
            }
            else {
                tree.focusPrevious(1, payload);
                tree.reveal(tree.getFocus()).then(null, errors.onUnexpectedError);
            }
            return true;
        };
        DefaultController.prototype.onPageUp = function (tree, event) {
            var payload = { origin: 'keyboard', originalEvent: event };
            if (tree.getHighlight()) {
                tree.clearHighlight(payload);
            }
            else {
                tree.focusPreviousPage(payload);
                tree.reveal(tree.getFocus()).then(null, errors.onUnexpectedError);
            }
            return true;
        };
        DefaultController.prototype.onDown = function (tree, event) {
            var payload = { origin: 'keyboard', originalEvent: event };
            if (tree.getHighlight()) {
                tree.clearHighlight(payload);
            }
            else {
                tree.focusNext(1, payload);
                tree.reveal(tree.getFocus()).then(null, errors.onUnexpectedError);
            }
            return true;
        };
        DefaultController.prototype.onPageDown = function (tree, event) {
            var payload = { origin: 'keyboard', originalEvent: event };
            if (tree.getHighlight()) {
                tree.clearHighlight(payload);
            }
            else {
                tree.focusNextPage(payload);
                tree.reveal(tree.getFocus()).then(null, errors.onUnexpectedError);
            }
            return true;
        };
        DefaultController.prototype.onHome = function (tree, event) {
            var payload = { origin: 'keyboard', originalEvent: event };
            if (tree.getHighlight()) {
                tree.clearHighlight(payload);
            }
            else {
                tree.focusFirst(payload);
                tree.reveal(tree.getFocus()).then(null, errors.onUnexpectedError);
            }
            return true;
        };
        DefaultController.prototype.onEnd = function (tree, event) {
            var payload = { origin: 'keyboard', originalEvent: event };
            if (tree.getHighlight()) {
                tree.clearHighlight(payload);
            }
            else {
                tree.focusLast(payload);
                tree.reveal(tree.getFocus()).then(null, errors.onUnexpectedError);
            }
            return true;
        };
        DefaultController.prototype.onLeft = function (tree, event) {
            var payload = { origin: 'keyboard', originalEvent: event };
            if (tree.getHighlight()) {
                tree.clearHighlight(payload);
            }
            else {
                var focus_1 = tree.getFocus();
                tree.collapse(focus_1).then(function (didCollapse) {
                    if (focus_1 && !didCollapse) {
                        tree.focusParent(payload);
                        return tree.reveal(tree.getFocus());
                    }
                    return undefined;
                }).then(null, errors.onUnexpectedError);
            }
            return true;
        };
        DefaultController.prototype.onRight = function (tree, event) {
            var payload = { origin: 'keyboard', originalEvent: event };
            if (tree.getHighlight()) {
                tree.clearHighlight(payload);
            }
            else {
                var focus_2 = tree.getFocus();
                tree.expand(focus_2).then(function (didExpand) {
                    if (focus_2 && !didExpand) {
                        tree.focusFirstChild(payload);
                        return tree.reveal(tree.getFocus());
                    }
                    return undefined;
                }).then(null, errors.onUnexpectedError);
            }
            return true;
        };
        DefaultController.prototype.onEnter = function (tree, event) {
            var payload = { origin: 'keyboard', originalEvent: event };
            if (tree.getHighlight()) {
                return false;
            }
            var focus = tree.getFocus();
            if (focus) {
                tree.setSelection([focus], payload);
            }
            return true;
        };
        DefaultController.prototype.onSpace = function (tree, event) {
            if (tree.getHighlight()) {
                return false;
            }
            var focus = tree.getFocus();
            if (focus) {
                tree.toggleExpansion(focus);
            }
            return true;
        };
        DefaultController.prototype.onEscape = function (tree, event) {
            var payload = { origin: 'keyboard', originalEvent: event };
            if (tree.getHighlight()) {
                tree.clearHighlight(payload);
                return true;
            }
            if (tree.getSelection().length) {
                tree.clearSelection(payload);
                return true;
            }
            if (tree.getFocus()) {
                tree.clearFocus(payload);
                return true;
            }
            return false;
        };
        return DefaultController;
    }());
    exports.DefaultController = DefaultController;
    var DefaultDragAndDrop = /** @class */ (function () {
        function DefaultDragAndDrop() {
        }
        DefaultDragAndDrop.prototype.getDragURI = function (tree, element) {
            return null;
        };
        DefaultDragAndDrop.prototype.onDragStart = function (tree, data, originalEvent) {
            return;
        };
        DefaultDragAndDrop.prototype.onDragOver = function (tree, data, targetElement, originalEvent) {
            return null;
        };
        DefaultDragAndDrop.prototype.drop = function (tree, data, targetElement, originalEvent) {
            return;
        };
        return DefaultDragAndDrop;
    }());
    exports.DefaultDragAndDrop = DefaultDragAndDrop;
    var DefaultFilter = /** @class */ (function () {
        function DefaultFilter() {
        }
        DefaultFilter.prototype.isVisible = function (tree, element) {
            return true;
        };
        return DefaultFilter;
    }());
    exports.DefaultFilter = DefaultFilter;
    var DefaultAccessibilityProvider = /** @class */ (function () {
        function DefaultAccessibilityProvider() {
        }
        DefaultAccessibilityProvider.prototype.getAriaLabel = function (tree, element) {
            return null;
        };
        return DefaultAccessibilityProvider;
    }());
    exports.DefaultAccessibilityProvider = DefaultAccessibilityProvider;
    var DefaultTreestyler = /** @class */ (function () {
        function DefaultTreestyler(styleElement, selectorSuffix) {
            this.styleElement = styleElement;
            this.selectorSuffix = selectorSuffix;
        }
        DefaultTreestyler.prototype.style = function (styles) {
            var suffix = this.selectorSuffix ? "." + this.selectorSuffix : '';
            var content = [];
            if (styles.listFocusBackground) {
                content.push(".monaco-tree" + suffix + ".focused .monaco-tree-rows > .monaco-tree-row.focused:not(.highlighted) { background-color: " + styles.listFocusBackground + "; }");
            }
            if (styles.listFocusForeground) {
                content.push(".monaco-tree" + suffix + ".focused .monaco-tree-rows > .monaco-tree-row.focused:not(.highlighted) { color: " + styles.listFocusForeground + "; }");
            }
            if (styles.listActiveSelectionBackground) {
                content.push(".monaco-tree" + suffix + ".focused .monaco-tree-rows > .monaco-tree-row.selected:not(.highlighted) { background-color: " + styles.listActiveSelectionBackground + "; }");
            }
            if (styles.listActiveSelectionForeground) {
                content.push(".monaco-tree" + suffix + ".focused .monaco-tree-rows > .monaco-tree-row.selected:not(.highlighted) { color: " + styles.listActiveSelectionForeground + "; }");
            }
            if (styles.listFocusAndSelectionBackground) {
                content.push("\n\t\t\t\t.monaco-tree-drag-image,\n\t\t\t\t.monaco-tree" + suffix + ".focused .monaco-tree-rows > .monaco-tree-row.focused.selected:not(.highlighted) { background-color: " + styles.listFocusAndSelectionBackground + "; }\n\t\t\t");
            }
            if (styles.listFocusAndSelectionForeground) {
                content.push("\n\t\t\t\t.monaco-tree-drag-image,\n\t\t\t\t.monaco-tree" + suffix + ".focused .monaco-tree-rows > .monaco-tree-row.focused.selected:not(.highlighted) { color: " + styles.listFocusAndSelectionForeground + "; }\n\t\t\t");
            }
            if (styles.listInactiveSelectionBackground) {
                content.push(".monaco-tree" + suffix + " .monaco-tree-rows > .monaco-tree-row.selected:not(.highlighted) { background-color: " + styles.listInactiveSelectionBackground + "; }");
            }
            if (styles.listInactiveSelectionForeground) {
                content.push(".monaco-tree" + suffix + " .monaco-tree-rows > .monaco-tree-row.selected:not(.highlighted) { color: " + styles.listInactiveSelectionForeground + "; }");
            }
            if (styles.listHoverBackground) {
                content.push(".monaco-tree" + suffix + " .monaco-tree-rows > .monaco-tree-row:hover:not(.highlighted):not(.selected):not(.focused) { background-color: " + styles.listHoverBackground + "; }");
            }
            if (styles.listHoverForeground) {
                content.push(".monaco-tree" + suffix + " .monaco-tree-rows > .monaco-tree-row:hover:not(.highlighted):not(.selected):not(.focused) { color: " + styles.listHoverForeground + "; }");
            }
            if (styles.listDropBackground) {
                content.push("\n\t\t\t\t.monaco-tree" + suffix + " .monaco-tree-wrapper.drop-target,\n\t\t\t\t.monaco-tree" + suffix + " .monaco-tree-rows > .monaco-tree-row.drop-target { background-color: " + styles.listDropBackground + " !important; color: inherit !important; }\n\t\t\t");
            }
            if (styles.listFocusOutline) {
                content.push("\n\t\t\t\t.monaco-tree-drag-image\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{ border: 1px solid " + styles.listFocusOutline + "; background: #000; }\n\t\t\t\t.monaco-tree" + suffix + " .monaco-tree-rows > .monaco-tree-row \t\t\t\t\t\t\t\t\t\t\t\t\t\t{ border: 1px solid transparent; }\n\t\t\t\t.monaco-tree" + suffix + ".focused .monaco-tree-rows > .monaco-tree-row.focused:not(.highlighted) \t\t\t\t\t\t{ border: 1px dotted " + styles.listFocusOutline + "; }\n\t\t\t\t.monaco-tree" + suffix + ".focused .monaco-tree-rows > .monaco-tree-row.selected:not(.highlighted) \t\t\t\t\t\t{ border: 1px solid " + styles.listFocusOutline + "; }\n\t\t\t\t.monaco-tree" + suffix + " .monaco-tree-rows > .monaco-tree-row.selected:not(.highlighted)  \t\t\t\t\t\t\t{ border: 1px solid " + styles.listFocusOutline + "; }\n\t\t\t\t.monaco-tree" + suffix + " .monaco-tree-rows > .monaco-tree-row:hover:not(.highlighted):not(.selected):not(.focused)  \t{ border: 1px dashed " + styles.listFocusOutline + "; }\n\t\t\t\t.monaco-tree" + suffix + " .monaco-tree-wrapper.drop-target,\n\t\t\t\t.monaco-tree" + suffix + " .monaco-tree-rows > .monaco-tree-row.drop-target\t\t\t\t\t\t\t\t\t\t\t\t{ border: 1px dashed " + styles.listFocusOutline + "; }\n\t\t\t");
            }
            var newStyles = content.join('\n');
            if (newStyles !== this.styleElement.innerHTML) {
                this.styleElement.innerHTML = newStyles;
            }
        };
        return DefaultTreestyler;
    }());
    exports.DefaultTreestyler = DefaultTreestyler;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[443/*vs/base/parts/tree/browser/treeDnd*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ElementsDragAndDropData = /** @class */ (function () {
        function ElementsDragAndDropData(elements) {
            this.elements = elements;
        }
        ElementsDragAndDropData.prototype.update = function (event) {
            // no-op
        };
        return ElementsDragAndDropData;
    }());
    exports.ElementsDragAndDropData = ElementsDragAndDropData;
    var ExternalElementsDragAndDropData = /** @class */ (function () {
        function ExternalElementsDragAndDropData(elements) {
            this.elements = elements;
        }
        ExternalElementsDragAndDropData.prototype.update = function (event) {
            // no-op
        };
        return ExternalElementsDragAndDropData;
    }());
    exports.ExternalElementsDragAndDropData = ExternalElementsDragAndDropData;
    var DesktopDragAndDropData = /** @class */ (function () {
        function DesktopDragAndDropData() {
            this.types = [];
            this.files = [];
        }
        DesktopDragAndDropData.prototype.update = function (event) {
            if (event.dataTransfer.types) {
                this.types = [];
                Array.prototype.push.apply(this.types, event.dataTransfer.types);
            }
            if (event.dataTransfer.files) {
                this.files = [];
                Array.prototype.push.apply(this.files, event.dataTransfer.files);
                this.files = this.files.filter(function (f) { return f.size || f.type; });
            }
        };
        return DesktopDragAndDropData;
    }());
    exports.DesktopDragAndDropData = DesktopDragAndDropData;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[444/*vs/base/parts/tree/browser/treeModel*/], __M([0/*require*/,1/*exports*/,135/*vs/base/common/assert*/,11/*vs/base/common/errors*/,2/*vs/base/common/lifecycle*/,53/*vs/base/common/winjs.base*/,6/*vs/base/common/event*/]), function (require, exports, Assert, errors_1, lifecycle_1, WinJS, event_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var LockData = /** @class */ (function () {
        function LockData(item) {
            this._onDispose = new event_1.Emitter();
            this.onDispose = this._onDispose.event;
            this._item = item;
        }
        Object.defineProperty(LockData.prototype, "item", {
            get: function () {
                return this._item;
            },
            enumerable: true,
            configurable: true
        });
        LockData.prototype.dispose = function () {
            if (this._onDispose) {
                this._onDispose.fire();
                this._onDispose.dispose();
                this._onDispose = null;
            }
        };
        return LockData;
    }());
    exports.LockData = LockData;
    var Lock = /** @class */ (function () {
        function Lock() {
            this.locks = Object.create({});
        }
        Lock.prototype.isLocked = function (item) {
            return !!this.locks[item.id];
        };
        Lock.prototype.run = function (item, fn) {
            var _this = this;
            var lock = this.getLock(item);
            if (lock) {
                return new WinJS.TPromise(function (c, e) {
                    event_1.once(lock.onDispose)(function () {
                        return _this.run(item, fn).then(c, e);
                    });
                });
            }
            var result;
            return new WinJS.TPromise(function (c, e) {
                if (item.isDisposed()) {
                    return e(new Error('Item is disposed.'));
                }
                var lock = _this.locks[item.id] = new LockData(item);
                result = fn().then(function (r) {
                    delete _this.locks[item.id];
                    lock.dispose();
                    return r;
                }).then(c, e);
                return result;
            });
        };
        Lock.prototype.getLock = function (item) {
            var key;
            for (key in this.locks) {
                var lock = this.locks[key];
                if (item.intersects(lock.item)) {
                    return lock;
                }
            }
            return null;
        };
        return Lock;
    }());
    exports.Lock = Lock;
    var ItemRegistry = /** @class */ (function () {
        function ItemRegistry() {
            this._isDisposed = false;
            this._onDidRevealItem = new event_1.EventMultiplexer();
            this.onDidRevealItem = this._onDidRevealItem.event;
            this._onExpandItem = new event_1.EventMultiplexer();
            this.onExpandItem = this._onExpandItem.event;
            this._onDidExpandItem = new event_1.EventMultiplexer();
            this.onDidExpandItem = this._onDidExpandItem.event;
            this._onCollapseItem = new event_1.EventMultiplexer();
            this.onCollapseItem = this._onCollapseItem.event;
            this._onDidCollapseItem = new event_1.EventMultiplexer();
            this.onDidCollapseItem = this._onDidCollapseItem.event;
            this._onDidAddTraitItem = new event_1.EventMultiplexer();
            this.onDidAddTraitItem = this._onDidAddTraitItem.event;
            this._onDidRemoveTraitItem = new event_1.EventMultiplexer();
            this.onDidRemoveTraitItem = this._onDidRemoveTraitItem.event;
            this._onDidRefreshItem = new event_1.EventMultiplexer();
            this.onDidRefreshItem = this._onDidRefreshItem.event;
            this._onRefreshItemChildren = new event_1.EventMultiplexer();
            this.onRefreshItemChildren = this._onRefreshItemChildren.event;
            this._onDidRefreshItemChildren = new event_1.EventMultiplexer();
            this.onDidRefreshItemChildren = this._onDidRefreshItemChildren.event;
            this._onDidDisposeItem = new event_1.EventMultiplexer();
            this.onDidDisposeItem = this._onDidDisposeItem.event;
            this.items = {};
        }
        ItemRegistry.prototype.register = function (item) {
            Assert.ok(!this.isRegistered(item.id), 'item already registered: ' + item.id);
            var disposable = lifecycle_1.combinedDisposable([
                this._onDidRevealItem.add(item.onDidReveal),
                this._onExpandItem.add(item.onExpand),
                this._onDidExpandItem.add(item.onDidExpand),
                this._onCollapseItem.add(item.onCollapse),
                this._onDidCollapseItem.add(item.onDidCollapse),
                this._onDidAddTraitItem.add(item.onDidAddTrait),
                this._onDidRemoveTraitItem.add(item.onDidRemoveTrait),
                this._onDidRefreshItem.add(item.onDidRefresh),
                this._onRefreshItemChildren.add(item.onRefreshChildren),
                this._onDidRefreshItemChildren.add(item.onDidRefreshChildren),
                this._onDidDisposeItem.add(item.onDidDispose)
            ]);
            this.items[item.id] = { item: item, disposable: disposable };
        };
        ItemRegistry.prototype.deregister = function (item) {
            Assert.ok(this.isRegistered(item.id), 'item not registered: ' + item.id);
            this.items[item.id].disposable.dispose();
            delete this.items[item.id];
        };
        ItemRegistry.prototype.isRegistered = function (id) {
            return this.items.hasOwnProperty(id);
        };
        ItemRegistry.prototype.getItem = function (id) {
            var result = this.items[id];
            return result ? result.item : null;
        };
        ItemRegistry.prototype.dispose = function () {
            this.items = null;
            this._onDidRevealItem.dispose();
            this._onExpandItem.dispose();
            this._onDidExpandItem.dispose();
            this._onCollapseItem.dispose();
            this._onDidCollapseItem.dispose();
            this._onDidAddTraitItem.dispose();
            this._onDidRemoveTraitItem.dispose();
            this._onDidRefreshItem.dispose();
            this._onRefreshItemChildren.dispose();
            this._onDidRefreshItemChildren.dispose();
            this._isDisposed = true;
        };
        ItemRegistry.prototype.isDisposed = function () {
            return this._isDisposed;
        };
        return ItemRegistry;
    }());
    exports.ItemRegistry = ItemRegistry;
    var Item = /** @class */ (function () {
        function Item(id, registry, context, lock, element) {
            this._onDidCreate = new event_1.Emitter();
            this._onDidReveal = new event_1.Emitter();
            this.onDidReveal = this._onDidReveal.event;
            this._onExpand = new event_1.Emitter();
            this.onExpand = this._onExpand.event;
            this._onDidExpand = new event_1.Emitter();
            this.onDidExpand = this._onDidExpand.event;
            this._onCollapse = new event_1.Emitter();
            this.onCollapse = this._onCollapse.event;
            this._onDidCollapse = new event_1.Emitter();
            this.onDidCollapse = this._onDidCollapse.event;
            this._onDidAddTrait = new event_1.Emitter();
            this.onDidAddTrait = this._onDidAddTrait.event;
            this._onDidRemoveTrait = new event_1.Emitter();
            this.onDidRemoveTrait = this._onDidRemoveTrait.event;
            this._onDidRefresh = new event_1.Emitter();
            this.onDidRefresh = this._onDidRefresh.event;
            this._onRefreshChildren = new event_1.Emitter();
            this.onRefreshChildren = this._onRefreshChildren.event;
            this._onDidRefreshChildren = new event_1.Emitter();
            this.onDidRefreshChildren = this._onDidRefreshChildren.event;
            this._onDidDispose = new event_1.Emitter();
            this.onDidDispose = this._onDidDispose.event;
            this.registry = registry;
            this.context = context;
            this.lock = lock;
            this.element = element;
            this.id = id;
            this.registry.register(this);
            this.doesHaveChildren = this.context.dataSource.hasChildren(this.context.tree, this.element);
            this.needsChildrenRefresh = true;
            this.parent = null;
            this.previous = null;
            this.next = null;
            this.firstChild = null;
            this.lastChild = null;
            this.traits = {};
            this.depth = 0;
            this.expanded = this.context.dataSource.shouldAutoexpand && this.context.dataSource.shouldAutoexpand(this.context.tree, element);
            this._onDidCreate.fire(this);
            this.visible = this._isVisible();
            this.height = this._getHeight();
            this._isDisposed = false;
        }
        Item.prototype.getElement = function () {
            return this.element;
        };
        Item.prototype.hasChildren = function () {
            return this.doesHaveChildren;
        };
        Item.prototype.getDepth = function () {
            return this.depth;
        };
        Item.prototype.isVisible = function () {
            return this.visible;
        };
        Item.prototype.setVisible = function (value) {
            this.visible = value;
        };
        Item.prototype.isExpanded = function () {
            return this.expanded;
        };
        /* protected */ Item.prototype._setExpanded = function (value) {
            this.expanded = value;
        };
        Item.prototype.reveal = function (relativeTop) {
            if (relativeTop === void 0) { relativeTop = null; }
            var eventData = { item: this, relativeTop: relativeTop };
            this._onDidReveal.fire(eventData);
        };
        Item.prototype.expand = function () {
            var _this = this;
            if (this.isExpanded() || !this.doesHaveChildren || this.lock.isLocked(this)) {
                return WinJS.TPromise.as(false);
            }
            var result = this.lock.run(this, function () {
                if (_this.isExpanded() || !_this.doesHaveChildren) {
                    return WinJS.TPromise.as(false);
                }
                var eventData = { item: _this };
                var result;
                _this._onExpand.fire(eventData);
                if (_this.needsChildrenRefresh) {
                    result = _this.refreshChildren(false, true, true);
                }
                else {
                    result = WinJS.TPromise.as(null);
                }
                return result.then(function () {
                    _this._setExpanded(true);
                    _this._onDidExpand.fire(eventData);
                    return true;
                });
            });
            return result.then(function (r) {
                if (_this.isDisposed()) {
                    return false;
                }
                // Auto expand single child folders
                if (_this.context.options.autoExpandSingleChildren && r && _this.firstChild !== null && _this.firstChild === _this.lastChild && _this.firstChild.isVisible()) {
                    return _this.firstChild.expand().then(function () { return true; });
                }
                return r;
            });
        };
        Item.prototype.collapse = function (recursive) {
            var _this = this;
            if (recursive === void 0) { recursive = false; }
            if (recursive) {
                var collapseChildrenPromise = WinJS.TPromise.as(null);
                this.forEachChild(function (child) {
                    collapseChildrenPromise = collapseChildrenPromise.then(function () { return child.collapse(true); });
                });
                return collapseChildrenPromise.then(function () {
                    return _this.collapse(false);
                });
            }
            else {
                if (!this.isExpanded() || this.lock.isLocked(this)) {
                    return WinJS.TPromise.as(false);
                }
                return this.lock.run(this, function () {
                    var eventData = { item: _this };
                    _this._onCollapse.fire(eventData);
                    _this._setExpanded(false);
                    _this._onDidCollapse.fire(eventData);
                    return WinJS.TPromise.as(true);
                });
            }
        };
        Item.prototype.addTrait = function (trait) {
            var eventData = { item: this, trait: trait };
            this.traits[trait] = true;
            this._onDidAddTrait.fire(eventData);
        };
        Item.prototype.removeTrait = function (trait) {
            var eventData = { item: this, trait: trait };
            delete this.traits[trait];
            this._onDidRemoveTrait.fire(eventData);
        };
        Item.prototype.hasTrait = function (trait) {
            return this.traits[trait] || false;
        };
        Item.prototype.getAllTraits = function () {
            var result = [];
            var trait;
            for (trait in this.traits) {
                if (this.traits.hasOwnProperty(trait) && this.traits[trait]) {
                    result.push(trait);
                }
            }
            return result;
        };
        Item.prototype.getHeight = function () {
            return this.height;
        };
        Item.prototype.refreshChildren = function (recursive, safe, force) {
            var _this = this;
            if (safe === void 0) { safe = false; }
            if (force === void 0) { force = false; }
            if (!force && !this.isExpanded()) {
                var setNeedsChildrenRefresh_1 = function (item) {
                    item.needsChildrenRefresh = true;
                    item.forEachChild(setNeedsChildrenRefresh_1);
                };
                setNeedsChildrenRefresh_1(this);
                return WinJS.TPromise.as(this);
            }
            this.needsChildrenRefresh = false;
            var doRefresh = function () {
                var eventData = { item: _this, isNested: safe };
                _this._onRefreshChildren.fire(eventData);
                var childrenPromise;
                if (_this.doesHaveChildren) {
                    childrenPromise = _this.context.dataSource.getChildren(_this.context.tree, _this.element);
                }
                else {
                    childrenPromise = WinJS.TPromise.as([]);
                }
                var result = childrenPromise.then(function (elements) {
                    if (_this.isDisposed() || _this.registry.isDisposed()) {
                        return WinJS.TPromise.as(null);
                    }
                    if (!Array.isArray(elements)) {
                        return WinJS.TPromise.wrapError(new Error('Please return an array of children.'));
                    }
                    elements = !elements ? [] : elements.slice(0);
                    elements = _this.sort(elements);
                    var staleItems = {};
                    while (_this.firstChild !== null) {
                        staleItems[_this.firstChild.id] = _this.firstChild;
                        _this.removeChild(_this.firstChild);
                    }
                    for (var i = 0, len = elements.length; i < len; i++) {
                        var element = elements[i];
                        var id = _this.context.dataSource.getId(_this.context.tree, element);
                        var item = staleItems[id] || new Item(id, _this.registry, _this.context, _this.lock, element);
                        item.element = element;
                        if (recursive) {
                            item.needsChildrenRefresh = recursive;
                        }
                        delete staleItems[id];
                        _this.addChild(item);
                    }
                    for (var staleItemId in staleItems) {
                        if (staleItems.hasOwnProperty(staleItemId)) {
                            staleItems[staleItemId].dispose();
                        }
                    }
                    if (recursive) {
                        return WinJS.Promise.join(_this.mapEachChild(function (child) {
                            return child.doRefresh(recursive, true);
                        }));
                    }
                    else {
                        return WinJS.Promise.join(_this.mapEachChild(function (child) {
                            if (child.isExpanded() && child.needsChildrenRefresh) {
                                return child.doRefresh(recursive, true);
                            }
                            else {
                                child.updateVisibility();
                                return WinJS.TPromise.as(null);
                            }
                        }));
                    }
                });
                return result
                    .then(null, errors_1.onUnexpectedError)
                    .then(function () { return _this._onDidRefreshChildren.fire(eventData); });
            };
            return safe ? doRefresh() : this.lock.run(this, doRefresh);
        };
        Item.prototype.doRefresh = function (recursive, safe) {
            if (safe === void 0) { safe = false; }
            this.doesHaveChildren = this.context.dataSource.hasChildren(this.context.tree, this.element);
            this.height = this._getHeight();
            this.updateVisibility();
            this._onDidRefresh.fire(this);
            return this.refreshChildren(recursive, safe);
        };
        Item.prototype.updateVisibility = function () {
            this.setVisible(this._isVisible());
        };
        Item.prototype.refresh = function (recursive) {
            return this.doRefresh(recursive);
        };
        Item.prototype.getNavigator = function () {
            return new TreeNavigator(this);
        };
        Item.prototype.intersects = function (other) {
            return this.isAncestorOf(other) || other.isAncestorOf(this);
        };
        Item.prototype.isAncestorOf = function (item) {
            while (item) {
                if (item.id === this.id) {
                    return true;
                }
                item = item.parent;
            }
            return false;
        };
        Item.prototype.addChild = function (item, afterItem) {
            if (afterItem === void 0) { afterItem = this.lastChild; }
            var isEmpty = this.firstChild === null;
            var atHead = afterItem === null;
            var atTail = afterItem === this.lastChild;
            if (isEmpty) {
                this.firstChild = this.lastChild = item;
                item.next = item.previous = null;
            }
            else if (atHead) {
                this.firstChild.previous = item;
                item.next = this.firstChild;
                item.previous = null;
                this.firstChild = item;
            }
            else if (atTail) {
                this.lastChild.next = item;
                item.next = null;
                item.previous = this.lastChild;
                this.lastChild = item;
            }
            else {
                item.previous = afterItem;
                item.next = afterItem.next;
                afterItem.next.previous = item;
                afterItem.next = item;
            }
            item.parent = this;
            item.depth = this.depth + 1;
        };
        Item.prototype.removeChild = function (item) {
            var isFirstChild = this.firstChild === item;
            var isLastChild = this.lastChild === item;
            if (isFirstChild && isLastChild) {
                this.firstChild = this.lastChild = null;
            }
            else if (isFirstChild) {
                item.next.previous = null;
                this.firstChild = item.next;
            }
            else if (isLastChild) {
                item.previous.next = null;
                this.lastChild = item.previous;
            }
            else {
                item.next.previous = item.previous;
                item.previous.next = item.next;
            }
            item.parent = null;
            item.depth = null;
        };
        Item.prototype.forEachChild = function (fn) {
            var child = this.firstChild, next;
            while (child) {
                next = child.next;
                fn(child);
                child = next;
            }
        };
        Item.prototype.mapEachChild = function (fn) {
            var result = [];
            this.forEachChild(function (child) {
                result.push(fn(child));
            });
            return result;
        };
        Item.prototype.sort = function (elements) {
            var _this = this;
            if (this.context.sorter) {
                return elements.sort(function (element, otherElement) {
                    return _this.context.sorter.compare(_this.context.tree, element, otherElement);
                });
            }
            return elements;
        };
        /* protected */ Item.prototype._getHeight = function () {
            return this.context.renderer.getHeight(this.context.tree, this.element);
        };
        /* protected */ Item.prototype._isVisible = function () {
            return this.context.filter.isVisible(this.context.tree, this.element);
        };
        Item.prototype.isDisposed = function () {
            return this._isDisposed;
        };
        Item.prototype.dispose = function () {
            this.forEachChild(function (child) { return child.dispose(); });
            this.parent = null;
            this.previous = null;
            this.next = null;
            this.firstChild = null;
            this.lastChild = null;
            this._onDidDispose.fire(this);
            this.registry.deregister(this);
            this._onDidCreate.dispose();
            this._onDidReveal.dispose();
            this._onExpand.dispose();
            this._onDidExpand.dispose();
            this._onCollapse.dispose();
            this._onDidCollapse.dispose();
            this._onDidAddTrait.dispose();
            this._onDidRemoveTrait.dispose();
            this._onDidRefresh.dispose();
            this._onRefreshChildren.dispose();
            this._onDidRefreshChildren.dispose();
            this._onDidDispose.dispose();
            this._isDisposed = true;
        };
        return Item;
    }());
    exports.Item = Item;
    var RootItem = /** @class */ (function (_super) {
        __extends(RootItem, _super);
        function RootItem(id, registry, context, lock, element) {
            return _super.call(this, id, registry, context, lock, element) || this;
        }
        RootItem.prototype.isVisible = function () {
            return false;
        };
        RootItem.prototype.setVisible = function (value) {
            // no-op
        };
        RootItem.prototype.isExpanded = function () {
            return true;
        };
        /* protected */ RootItem.prototype._setExpanded = function (value) {
            // no-op
        };
        /* protected */ RootItem.prototype._getHeight = function () {
            return 0;
        };
        /* protected */ RootItem.prototype._isVisible = function () {
            return false;
        };
        return RootItem;
    }(Item));
    var TreeNavigator = /** @class */ (function () {
        function TreeNavigator(item, subTreeOnly) {
            if (subTreeOnly === void 0) { subTreeOnly = true; }
            this.item = item;
            this.start = subTreeOnly ? item : null;
        }
        TreeNavigator.lastDescendantOf = function (item) {
            if (!item) {
                return null;
            }
            if (item instanceof RootItem) {
                return TreeNavigator.lastDescendantOf(item.lastChild);
            }
            if (!item.isVisible()) {
                return TreeNavigator.lastDescendantOf(item.previous);
            }
            if (!item.isExpanded() || item.lastChild === null) {
                return item;
            }
            return TreeNavigator.lastDescendantOf(item.lastChild);
        };
        TreeNavigator.prototype.current = function () {
            return this.item || null;
        };
        TreeNavigator.prototype.next = function () {
            if (this.item) {
                do {
                    if ((this.item instanceof RootItem || (this.item.isVisible() && this.item.isExpanded())) && this.item.firstChild) {
                        this.item = this.item.firstChild;
                    }
                    else if (this.item === this.start) {
                        this.item = null;
                    }
                    else {
                        // select next brother, next uncle, next great-uncle, etc...
                        while (this.item && this.item !== this.start && !this.item.next) {
                            this.item = this.item.parent;
                        }
                        if (this.item === this.start) {
                            this.item = null;
                        }
                        this.item = !this.item ? null : this.item.next;
                    }
                } while (this.item && !this.item.isVisible());
            }
            return this.item || null;
        };
        TreeNavigator.prototype.previous = function () {
            if (this.item) {
                do {
                    var previous = TreeNavigator.lastDescendantOf(this.item.previous);
                    if (previous) {
                        this.item = previous;
                    }
                    else if (this.item.parent && this.item.parent !== this.start && this.item.parent.isVisible()) {
                        this.item = this.item.parent;
                    }
                    else {
                        this.item = null;
                    }
                } while (this.item && !this.item.isVisible());
            }
            return this.item || null;
        };
        TreeNavigator.prototype.parent = function () {
            if (this.item) {
                var parent = this.item.parent;
                if (parent && parent !== this.start && parent.isVisible()) {
                    this.item = parent;
                }
                else {
                    this.item = null;
                }
            }
            return this.item || null;
        };
        TreeNavigator.prototype.first = function () {
            this.item = this.start;
            this.next();
            return this.item || null;
        };
        TreeNavigator.prototype.last = function () {
            return TreeNavigator.lastDescendantOf(this.start);
        };
        return TreeNavigator;
    }());
    exports.TreeNavigator = TreeNavigator;
    var TreeModel = /** @class */ (function () {
        function TreeModel(context) {
            this._onSetInput = new event_1.Emitter();
            this.onSetInput = this._onSetInput.event;
            this._onDidSetInput = new event_1.Emitter();
            this.onDidSetInput = this._onDidSetInput.event;
            this._onRefresh = new event_1.Emitter();
            this.onRefresh = this._onRefresh.event;
            this._onDidRefresh = new event_1.Emitter();
            this.onDidRefresh = this._onDidRefresh.event;
            this._onDidHighlight = new event_1.Emitter();
            this.onDidHighlight = this._onDidHighlight.event;
            this._onDidSelect = new event_1.Emitter();
            this.onDidSelect = this._onDidSelect.event;
            this._onDidFocus = new event_1.Emitter();
            this.onDidFocus = this._onDidFocus.event;
            this._onDidRevealItem = new event_1.Relay();
            this.onDidRevealItem = this._onDidRevealItem.event;
            this._onExpandItem = new event_1.Relay();
            this.onExpandItem = this._onExpandItem.event;
            this._onDidExpandItem = new event_1.Relay();
            this.onDidExpandItem = this._onDidExpandItem.event;
            this._onCollapseItem = new event_1.Relay();
            this.onCollapseItem = this._onCollapseItem.event;
            this._onDidCollapseItem = new event_1.Relay();
            this.onDidCollapseItem = this._onDidCollapseItem.event;
            this._onDidAddTraitItem = new event_1.Relay();
            this.onDidAddTraitItem = this._onDidAddTraitItem.event;
            this._onDidRemoveTraitItem = new event_1.Relay();
            this.onDidRemoveTraitItem = this._onDidRemoveTraitItem.event;
            this._onDidRefreshItem = new event_1.Relay();
            this.onDidRefreshItem = this._onDidRefreshItem.event;
            this._onRefreshItemChildren = new event_1.Relay();
            this.onRefreshItemChildren = this._onRefreshItemChildren.event;
            this._onDidRefreshItemChildren = new event_1.Relay();
            this.onDidRefreshItemChildren = this._onDidRefreshItemChildren.event;
            this._onDidDisposeItem = new event_1.Relay();
            this.context = context;
            this.input = null;
            this.traitsToItems = {};
        }
        TreeModel.prototype.setInput = function (element) {
            var _this = this;
            var eventData = { item: this.input };
            this._onSetInput.fire(eventData);
            this.setSelection([]);
            this.setFocus();
            this.setHighlight();
            this.lock = new Lock();
            if (this.input) {
                this.input.dispose();
            }
            if (this.registry) {
                this.registry.dispose();
                this.registryDisposable.dispose();
            }
            this.registry = new ItemRegistry();
            this._onDidRevealItem.input = this.registry.onDidRevealItem;
            this._onExpandItem.input = this.registry.onExpandItem;
            this._onDidExpandItem.input = this.registry.onDidExpandItem;
            this._onCollapseItem.input = this.registry.onCollapseItem;
            this._onDidCollapseItem.input = this.registry.onDidCollapseItem;
            this._onDidAddTraitItem.input = this.registry.onDidAddTraitItem;
            this._onDidRemoveTraitItem.input = this.registry.onDidRemoveTraitItem;
            this._onDidRefreshItem.input = this.registry.onDidRefreshItem;
            this._onRefreshItemChildren.input = this.registry.onRefreshItemChildren;
            this._onDidRefreshItemChildren.input = this.registry.onDidRefreshItemChildren;
            this._onDidDisposeItem.input = this.registry.onDidDisposeItem;
            this.registryDisposable = this.registry
                .onDidDisposeItem(function (item) { return item.getAllTraits().forEach(function (trait) { return delete _this.traitsToItems[trait][item.id]; }); });
            var id = this.context.dataSource.getId(this.context.tree, element);
            this.input = new RootItem(id, this.registry, this.context, this.lock, element);
            eventData = { item: this.input };
            this._onDidSetInput.fire(eventData);
            return this.refresh(this.input);
        };
        TreeModel.prototype.getInput = function () {
            return this.input ? this.input.getElement() : null;
        };
        TreeModel.prototype.refresh = function (element, recursive) {
            var _this = this;
            if (element === void 0) { element = null; }
            if (recursive === void 0) { recursive = true; }
            var item = this.getItem(element);
            if (!item) {
                return WinJS.TPromise.as(null);
            }
            var eventData = { item: item, recursive: recursive };
            this._onRefresh.fire(eventData);
            return item.refresh(recursive).then(function () {
                _this._onDidRefresh.fire(eventData);
            });
        };
        TreeModel.prototype.expand = function (element) {
            var item = this.getItem(element);
            if (!item) {
                return WinJS.TPromise.as(false);
            }
            return item.expand();
        };
        TreeModel.prototype.collapse = function (element, recursive) {
            if (recursive === void 0) { recursive = false; }
            var item = this.getItem(element);
            if (!item) {
                return WinJS.TPromise.as(false);
            }
            return item.collapse(recursive);
        };
        TreeModel.prototype.toggleExpansion = function (element, recursive) {
            if (recursive === void 0) { recursive = false; }
            return this.isExpanded(element) ? this.collapse(element, recursive) : this.expand(element);
        };
        TreeModel.prototype.isExpanded = function (element) {
            var item = this.getItem(element);
            if (!item) {
                return false;
            }
            return item.isExpanded();
        };
        TreeModel.prototype.reveal = function (element, relativeTop) {
            var _this = this;
            if (relativeTop === void 0) { relativeTop = null; }
            return this.resolveUnknownParentChain(element).then(function (chain) {
                var result = WinJS.TPromise.as(null);
                chain.forEach(function (e) {
                    result = result.then(function () { return _this.expand(e); });
                });
                return result;
            }).then(function () {
                var item = _this.getItem(element);
                if (item) {
                    return item.reveal(relativeTop);
                }
            });
        };
        TreeModel.prototype.resolveUnknownParentChain = function (element) {
            var _this = this;
            return this.context.dataSource.getParent(this.context.tree, element).then(function (parent) {
                if (!parent) {
                    return WinJS.TPromise.as([]);
                }
                return _this.resolveUnknownParentChain(parent).then(function (result) {
                    result.push(parent);
                    return result;
                });
            });
        };
        TreeModel.prototype.setHighlight = function (element, eventPayload) {
            this.setTraits('highlighted', element ? [element] : []);
            var eventData = { highlight: this.getHighlight(), payload: eventPayload };
            this._onDidHighlight.fire(eventData);
        };
        TreeModel.prototype.getHighlight = function (includeHidden) {
            var result = this.getElementsWithTrait('highlighted', includeHidden);
            return result.length === 0 ? null : result[0];
        };
        TreeModel.prototype.setSelection = function (elements, eventPayload) {
            this.setTraits('selected', elements);
            var eventData = { selection: this.getSelection(), payload: eventPayload };
            this._onDidSelect.fire(eventData);
        };
        TreeModel.prototype.getSelection = function (includeHidden) {
            return this.getElementsWithTrait('selected', includeHidden);
        };
        TreeModel.prototype.setFocus = function (element, eventPayload) {
            this.setTraits('focused', element ? [element] : []);
            var eventData = { focus: this.getFocus(), payload: eventPayload };
            this._onDidFocus.fire(eventData);
        };
        TreeModel.prototype.getFocus = function (includeHidden) {
            var result = this.getElementsWithTrait('focused', includeHidden);
            return result.length === 0 ? null : result[0];
        };
        TreeModel.prototype.focusNext = function (count, eventPayload) {
            if (count === void 0) { count = 1; }
            var item = this.getFocus() || this.input;
            var nextItem;
            var nav = this.getNavigator(item, false);
            for (var i = 0; i < count; i++) {
                nextItem = nav.next();
                if (!nextItem) {
                    break;
                }
                item = nextItem;
            }
            this.setFocus(item, eventPayload);
        };
        TreeModel.prototype.focusPrevious = function (count, eventPayload) {
            if (count === void 0) { count = 1; }
            var item = this.getFocus() || this.input;
            var previousItem;
            var nav = this.getNavigator(item, false);
            for (var i = 0; i < count; i++) {
                previousItem = nav.previous();
                if (!previousItem) {
                    break;
                }
                item = previousItem;
            }
            this.setFocus(item, eventPayload);
        };
        TreeModel.prototype.focusParent = function (eventPayload) {
            var item = this.getFocus() || this.input;
            var nav = this.getNavigator(item, false);
            var parent = nav.parent();
            if (parent) {
                this.setFocus(parent, eventPayload);
            }
        };
        TreeModel.prototype.focusFirstChild = function (eventPayload) {
            var item = this.getItem(this.getFocus() || this.input);
            var nav = this.getNavigator(item, false);
            var next = nav.next();
            var parent = nav.parent();
            if (parent === item) {
                this.setFocus(next, eventPayload);
            }
        };
        TreeModel.prototype.focusFirst = function (eventPayload, from) {
            this.focusNth(0, eventPayload, from);
        };
        TreeModel.prototype.focusNth = function (index, eventPayload, from) {
            var navItem = this.getParent(from);
            var nav = this.getNavigator(navItem);
            var item = nav.first();
            for (var i = 0; i < index; i++) {
                item = nav.next();
            }
            if (item) {
                this.setFocus(item, eventPayload);
            }
        };
        TreeModel.prototype.focusLast = function (eventPayload, from) {
            var navItem = this.getParent(from);
            var item;
            if (from) {
                item = navItem.lastChild;
            }
            else {
                var nav = this.getNavigator(navItem);
                item = nav.last();
            }
            if (item) {
                this.setFocus(item, eventPayload);
            }
        };
        TreeModel.prototype.getParent = function (from) {
            if (from) {
                var fromItem = this.getItem(from);
                if (fromItem && fromItem.parent) {
                    return fromItem.parent;
                }
            }
            return this.getItem(this.input);
        };
        TreeModel.prototype.getNavigator = function (element, subTreeOnly) {
            if (element === void 0) { element = null; }
            if (subTreeOnly === void 0) { subTreeOnly = true; }
            return new TreeNavigator(this.getItem(element), subTreeOnly);
        };
        TreeModel.prototype.getItem = function (element) {
            if (element === void 0) { element = null; }
            if (element === null) {
                return this.input;
            }
            else if (element instanceof Item) {
                return element;
            }
            else if (typeof element === 'string') {
                return this.registry.getItem(element);
            }
            else {
                return this.registry.getItem(this.context.dataSource.getId(this.context.tree, element));
            }
        };
        TreeModel.prototype.removeTraits = function (trait, elements) {
            var items = this.traitsToItems[trait] || {};
            var item;
            var id;
            if (elements.length === 0) {
                for (id in items) {
                    if (items.hasOwnProperty(id)) {
                        item = items[id];
                        item.removeTrait(trait);
                    }
                }
                delete this.traitsToItems[trait];
            }
            else {
                for (var i = 0, len = elements.length; i < len; i++) {
                    item = this.getItem(elements[i]);
                    if (item) {
                        item.removeTrait(trait);
                        delete items[item.id];
                    }
                }
            }
        };
        TreeModel.prototype.setTraits = function (trait, elements) {
            if (elements.length === 0) {
                this.removeTraits(trait, elements);
            }
            else {
                var items = {};
                var item;
                for (var i = 0, len = elements.length; i < len; i++) {
                    item = this.getItem(elements[i]);
                    if (item) {
                        items[item.id] = item;
                    }
                }
                var traitItems = this.traitsToItems[trait] || {};
                var itemsToRemoveTrait = [];
                var id;
                for (id in traitItems) {
                    if (traitItems.hasOwnProperty(id)) {
                        if (items.hasOwnProperty(id)) {
                            delete items[id];
                        }
                        else {
                            itemsToRemoveTrait.push(traitItems[id]);
                        }
                    }
                }
                for (var i = 0, len = itemsToRemoveTrait.length; i < len; i++) {
                    item = itemsToRemoveTrait[i];
                    item.removeTrait(trait);
                    delete traitItems[item.id];
                }
                for (id in items) {
                    if (items.hasOwnProperty(id)) {
                        item = items[id];
                        item.addTrait(trait);
                        traitItems[id] = item;
                    }
                }
                this.traitsToItems[trait] = traitItems;
            }
        };
        TreeModel.prototype.getElementsWithTrait = function (trait, includeHidden) {
            var elements = [];
            var items = this.traitsToItems[trait] || {};
            var id;
            for (id in items) {
                if (items.hasOwnProperty(id) && (items[id].isVisible() || includeHidden)) {
                    elements.push(items[id].getElement());
                }
            }
            return elements;
        };
        TreeModel.prototype.dispose = function () {
            if (this.registry) {
                this.registry.dispose();
                this.registry = null;
            }
            this._onSetInput.dispose();
            this._onDidSetInput.dispose();
            this._onRefresh.dispose();
            this._onDidRefresh.dispose();
            this._onDidHighlight.dispose();
            this._onDidSelect.dispose();
            this._onDidFocus.dispose();
            this._onDidRevealItem.dispose();
            this._onExpandItem.dispose();
            this._onDidExpandItem.dispose();
            this._onCollapseItem.dispose();
            this._onDidCollapseItem.dispose();
            this._onDidAddTraitItem.dispose();
            this._onDidRemoveTraitItem.dispose();
            this._onDidRefreshItem.dispose();
            this._onRefreshItemChildren.dispose();
            this._onDidRefreshItemChildren.dispose();
            this._onDidDisposeItem.dispose();
        };
        return TreeModel;
    }());
    exports.TreeModel = TreeModel;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[445/*vs/base/parts/tree/browser/treeViewModel*/], __M([0/*require*/,1/*exports*/,87/*vs/base/common/iterator*/]), function (require, exports, iterator_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var HeightMap = /** @class */ (function () {
        function HeightMap() {
            this.heightMap = [];
            this.indexes = {};
        }
        HeightMap.prototype.getContentHeight = function () {
            var last = this.heightMap[this.heightMap.length - 1];
            return !last ? 0 : last.top + last.height;
        };
        HeightMap.prototype.onInsertItems = function (iterator, afterItemId) {
            if (afterItemId === void 0) { afterItemId = null; }
            var item;
            var viewItem;
            var i, j;
            var totalSize;
            var sizeDiff = 0;
            if (afterItemId === null) {
                i = 0;
                totalSize = 0;
            }
            else {
                i = this.indexes[afterItemId] + 1;
                viewItem = this.heightMap[i - 1];
                if (!viewItem) {
                    console.error('view item doesnt exist');
                    return undefined;
                }
                totalSize = viewItem.top + viewItem.height;
            }
            var boundSplice = this.heightMap.splice.bind(this.heightMap, i, 0);
            var itemsToInsert = [];
            while (item = iterator.next()) {
                viewItem = this.createViewItem(item);
                viewItem.top = totalSize + sizeDiff;
                this.indexes[item.id] = i++;
                itemsToInsert.push(viewItem);
                sizeDiff += viewItem.height;
            }
            boundSplice.apply(this.heightMap, itemsToInsert);
            for (j = i; j < this.heightMap.length; j++) {
                viewItem = this.heightMap[j];
                viewItem.top += sizeDiff;
                this.indexes[viewItem.model.id] = j;
            }
            for (j = itemsToInsert.length - 1; j >= 0; j--) {
                this.onInsertItem(itemsToInsert[j]);
            }
            for (j = this.heightMap.length - 1; j >= i; j--) {
                this.onRefreshItem(this.heightMap[j]);
            }
            return sizeDiff;
        };
        HeightMap.prototype.onInsertItem = function (item) {
            // noop
        };
        // Contiguous items
        HeightMap.prototype.onRemoveItems = function (iterator) {
            var itemId;
            var viewItem;
            var startIndex = null;
            var i;
            var sizeDiff = 0;
            while (itemId = iterator.next()) {
                i = this.indexes[itemId];
                viewItem = this.heightMap[i];
                if (!viewItem) {
                    console.error('view item doesnt exist');
                    return;
                }
                sizeDiff -= viewItem.height;
                delete this.indexes[itemId];
                this.onRemoveItem(viewItem);
                if (startIndex === null) {
                    startIndex = i;
                }
            }
            if (sizeDiff === 0) {
                return;
            }
            this.heightMap.splice(startIndex, i - startIndex + 1);
            for (i = startIndex; i < this.heightMap.length; i++) {
                viewItem = this.heightMap[i];
                viewItem.top += sizeDiff;
                this.indexes[viewItem.model.id] = i;
                this.onRefreshItem(viewItem);
            }
        };
        HeightMap.prototype.onRemoveItem = function (item) {
            // noop
        };
        HeightMap.prototype.onRefreshItemSet = function (items) {
            var _this = this;
            var sortedItems = items.sort(function (a, b) { return _this.indexes[a.id] - _this.indexes[b.id]; });
            this.onRefreshItems(new iterator_1.ArrayIterator(sortedItems));
        };
        // Ordered, but not necessarily contiguous items
        HeightMap.prototype.onRefreshItems = function (iterator) {
            var item;
            var viewItem;
            var newHeight;
            var i, j = null;
            var cummDiff = 0;
            while (item = iterator.next()) {
                i = this.indexes[item.id];
                for (; cummDiff !== 0 && j !== null && j < i; j++) {
                    viewItem = this.heightMap[j];
                    viewItem.top += cummDiff;
                    this.onRefreshItem(viewItem);
                }
                viewItem = this.heightMap[i];
                newHeight = item.getHeight();
                viewItem.top += cummDiff;
                cummDiff += newHeight - viewItem.height;
                viewItem.height = newHeight;
                this.onRefreshItem(viewItem, true);
                j = i + 1;
            }
            if (cummDiff !== 0 && j !== null) {
                for (; j < this.heightMap.length; j++) {
                    viewItem = this.heightMap[j];
                    viewItem.top += cummDiff;
                    this.onRefreshItem(viewItem);
                }
            }
        };
        HeightMap.prototype.onRefreshItem = function (item, needsRender) {
            if (needsRender === void 0) { needsRender = false; }
            // noop
        };
        HeightMap.prototype.indexAt = function (position) {
            var left = 0;
            var right = this.heightMap.length;
            var center;
            var item;
            // Binary search
            while (left < right) {
                center = Math.floor((left + right) / 2);
                item = this.heightMap[center];
                if (position < item.top) {
                    right = center;
                }
                else if (position >= item.top + item.height) {
                    if (left === center) {
                        break;
                    }
                    left = center;
                }
                else {
                    return center;
                }
            }
            return this.heightMap.length;
        };
        HeightMap.prototype.indexAfter = function (position) {
            return Math.min(this.indexAt(position) + 1, this.heightMap.length);
        };
        HeightMap.prototype.itemAtIndex = function (index) {
            return this.heightMap[index];
        };
        HeightMap.prototype.itemAfter = function (item) {
            return this.heightMap[this.indexes[item.model.id] + 1] || null;
        };
        HeightMap.prototype.createViewItem = function (item) {
            throw new Error('not implemented');
        };
        HeightMap.prototype.dispose = function () {
            this.heightMap = null;
            this.indexes = null;
        };
        return HeightMap;
    }());
    exports.HeightMap = HeightMap;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[454/*vs/base/worker/defaultWorkerFactory*/], __M([0/*require*/,1/*exports*/,17/*vs/base/common/platform*/,148/*vs/base/common/worker/simpleWorker*/]), function (require, exports, platform_1, simpleWorker_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function getWorker(workerId, label) {
        // Option for hosts to overwrite the worker script (used in the standalone editor)
        if (platform_1.globals.MonacoEnvironment) {
            if (typeof platform_1.globals.MonacoEnvironment.getWorker === 'function') {
                return platform_1.globals.MonacoEnvironment.getWorker(workerId, label);
            }
            if (typeof platform_1.globals.MonacoEnvironment.getWorkerUrl === 'function') {
                return new Worker(platform_1.globals.MonacoEnvironment.getWorkerUrl(workerId, label));
            }
        }
        // ESM-comment-begin
        if (typeof require === 'function') {
            return new Worker(require.toUrl('./' + workerId) + '#' + label);
        }
        // ESM-comment-end
        throw new Error("You must define a function MonacoEnvironment.getWorkerUrl or MonacoEnvironment.getWorker");
    }
    /**
     * A worker that uses HTML5 web workers so that is has
     * its own global scope and its own thread.
     */
    var WebWorker = /** @class */ (function () {
        function WebWorker(moduleId, id, label, onMessageCallback, onErrorCallback) {
            this.id = id;
            this.worker = getWorker('workerMain.js', label);
            this.postMessage(moduleId);
            this.worker.onmessage = function (ev) {
                onMessageCallback(ev.data);
            };
            if (typeof this.worker.addEventListener === 'function') {
                this.worker.addEventListener('error', onErrorCallback);
            }
        }
        WebWorker.prototype.getId = function () {
            return this.id;
        };
        WebWorker.prototype.postMessage = function (msg) {
            if (this.worker) {
                this.worker.postMessage(msg);
            }
        };
        WebWorker.prototype.dispose = function () {
            if (this.worker) {
                this.worker.terminate();
            }
            this.worker = null;
        };
        return WebWorker;
    }());
    var DefaultWorkerFactory = /** @class */ (function () {
        function DefaultWorkerFactory(label) {
            this._label = label;
            this._webWorkerFailedBeforeError = false;
        }
        DefaultWorkerFactory.prototype.create = function (moduleId, onMessageCallback, onErrorCallback) {
            var _this = this;
            var workerId = (++DefaultWorkerFactory.LAST_WORKER_ID);
            if (this._webWorkerFailedBeforeError) {
                throw this._webWorkerFailedBeforeError;
            }
            return new WebWorker(moduleId, workerId, this._label || 'anonymous' + workerId, onMessageCallback, function (err) {
                simpleWorker_1.logOnceWebWorkerWarning(err);
                _this._webWorkerFailedBeforeError = err;
                onErrorCallback(err);
            });
        };
        DefaultWorkerFactory.LAST_WORKER_ID = 0;
        return DefaultWorkerFactory;
    }());
    exports.DefaultWorkerFactory = DefaultWorkerFactory;
});

define(__m[463/*vs/css!vs/base/browser/ui/actionbar/actionbar*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[469/*vs/css!vs/base/browser/ui/aria/aria*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[486/*vs/css!vs/base/browser/ui/checkbox/checkbox*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[487/*vs/base/browser/ui/checkbox/checkbox*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/,46/*vs/base/browser/ui/widget*/,28/*vs/base/common/color*/,6/*vs/base/common/event*/,27/*vs/base/common/objects*/,486/*vs/css!vs/base/browser/ui/checkbox/checkbox*/]), function (require, exports, DOM, widget_1, color_1, event_1, objects) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var defaultOpts = {
        inputActiveOptionBorder: color_1.Color.fromHex('#007ACC')
    };
    var Checkbox = /** @class */ (function (_super) {
        __extends(Checkbox, _super);
        function Checkbox(opts) {
            var _this = _super.call(this) || this;
            _this._onChange = _this._register(new event_1.Emitter());
            _this._onKeyDown = _this._register(new event_1.Emitter());
            _this._opts = objects.deepClone(opts);
            objects.mixin(_this._opts, defaultOpts, false);
            _this._checked = _this._opts.isChecked;
            _this.domNode = document.createElement('div');
            _this.domNode.title = _this._opts.title;
            _this.domNode.className = 'monaco-custom-checkbox ' + _this._opts.actionClassName + ' ' + (_this._checked ? 'checked' : 'unchecked');
            _this.domNode.tabIndex = 0;
            _this.domNode.setAttribute('role', 'checkbox');
            _this.domNode.setAttribute('aria-checked', String(_this._checked));
            _this.domNode.setAttribute('aria-label', _this._opts.title);
            _this.applyStyles();
            _this.onclick(_this.domNode, function (ev) {
                _this.checked = !_this._checked;
                _this._onChange.fire(false);
                ev.preventDefault();
            });
            _this.onkeydown(_this.domNode, function (keyboardEvent) {
                if (keyboardEvent.keyCode === 10 /* Space */ || keyboardEvent.keyCode === 3 /* Enter */) {
                    _this.checked = !_this._checked;
                    _this._onChange.fire(true);
                    keyboardEvent.preventDefault();
                    return;
                }
                _this._onKeyDown.fire(keyboardEvent);
            });
            return _this;
        }
        Object.defineProperty(Checkbox.prototype, "onChange", {
            get: function () { return this._onChange.event; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Checkbox.prototype, "onKeyDown", {
            get: function () { return this._onKeyDown.event; },
            enumerable: true,
            configurable: true
        });
        Checkbox.prototype.focus = function () {
            this.domNode.focus();
        };
        Object.defineProperty(Checkbox.prototype, "checked", {
            get: function () {
                return this._checked;
            },
            set: function (newIsChecked) {
                this._checked = newIsChecked;
                this.domNode.setAttribute('aria-checked', String(this._checked));
                if (this._checked) {
                    this.domNode.classList.add('checked');
                }
                else {
                    this.domNode.classList.remove('checked');
                }
                this.applyStyles();
            },
            enumerable: true,
            configurable: true
        });
        Checkbox.prototype.width = function () {
            return 2 /*marginleft*/ + 2 /*border*/ + 2 /*padding*/ + 16 /* icon width */;
        };
        Checkbox.prototype.style = function (styles) {
            if (styles.inputActiveOptionBorder) {
                this._opts.inputActiveOptionBorder = styles.inputActiveOptionBorder;
            }
            this.applyStyles();
        };
        Checkbox.prototype.applyStyles = function () {
            if (this.domNode) {
                this.domNode.style.borderColor = this._checked && this._opts.inputActiveOptionBorder ? this._opts.inputActiveOptionBorder.toString() : 'transparent';
            }
        };
        Checkbox.prototype.enable = function () {
            this.domNode.tabIndex = 0;
            this.domNode.setAttribute('aria-disabled', String(false));
        };
        Checkbox.prototype.disable = function () {
            DOM.removeTabIndexAndUpdateFocus(this.domNode);
            this.domNode.setAttribute('aria-disabled', String(true));
        };
        return Checkbox;
    }(widget_1.Widget));
    exports.Checkbox = Checkbox;
});

define(__m[505/*vs/css!vs/base/browser/ui/contextview/contextview*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[508/*vs/base/browser/ui/contextview/contextview*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/,2/*vs/base/common/lifecycle*/,115/*vs/base/common/range*/,505/*vs/css!vs/base/browser/ui/contextview/contextview*/]), function (require, exports, DOM, lifecycle_1, range_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * Lays out a one dimensional view next to an anchor in a viewport.
     *
     * @returns The view offset within the viewport.
     */
    function layout(viewportSize, viewSize, anchor) {
        var anchorEnd = anchor.offset + anchor.size;
        if (anchor.position === 0 /* Before */) {
            if (viewSize <= viewportSize - anchorEnd) {
                return anchorEnd; // happy case, lay it out after the anchor
            }
            if (viewSize <= anchor.offset) {
                return anchor.offset - viewSize; // ok case, lay it out before the anchor
            }
            return Math.max(viewportSize - viewSize, 0); // sad case, lay it over the anchor
        }
        else {
            if (viewSize <= anchor.offset) {
                return anchor.offset - viewSize; // happy case, lay it out before the anchor
            }
            if (viewSize <= viewportSize - anchorEnd) {
                return anchorEnd; // ok case, lay it out after the anchor
            }
            return 0; // sad case, lay it over the anchor
        }
    }
    exports.layout = layout;
    var ContextView = /** @class */ (function (_super) {
        __extends(ContextView, _super);
        function ContextView(container) {
            var _this = _super.call(this) || this;
            _this.view = DOM.$('.context-view');
            DOM.hide(_this.view);
            _this.setContainer(container);
            _this._register(lifecycle_1.toDisposable(function () { return _this.setContainer(null); }));
            return _this;
        }
        ContextView.prototype.setContainer = function (container) {
            var _this = this;
            if (this.container) {
                this.toDisposeOnSetContainer = lifecycle_1.dispose(this.toDisposeOnSetContainer);
                this.container.removeChild(this.view);
                this.container = null;
            }
            if (container) {
                this.container = container;
                this.container.appendChild(this.view);
                var toDisposeOnSetContainer_1 = [];
                ContextView.BUBBLE_UP_EVENTS.forEach(function (event) {
                    toDisposeOnSetContainer_1.push(DOM.addStandardDisposableListener(_this.container, event, function (e) {
                        _this.onDOMEvent(e, document.activeElement, false);
                    }));
                });
                ContextView.BUBBLE_DOWN_EVENTS.forEach(function (event) {
                    toDisposeOnSetContainer_1.push(DOM.addStandardDisposableListener(_this.container, event, function (e) {
                        _this.onDOMEvent(e, document.activeElement, true);
                    }, true));
                });
                this.toDisposeOnSetContainer = lifecycle_1.combinedDisposable(toDisposeOnSetContainer_1);
            }
        };
        ContextView.prototype.show = function (delegate) {
            if (this.isVisible()) {
                this.hide();
            }
            // Show static box
            DOM.clearNode(this.view);
            this.view.className = 'context-view';
            this.view.style.top = '0px';
            this.view.style.left = '0px';
            DOM.show(this.view);
            // Render content
            this.toDisposeOnClean = delegate.render(this.view);
            // Set active delegate
            this.delegate = delegate;
            // Layout
            this.doLayout();
            // Focus
            if (this.delegate.focus) {
                this.delegate.focus();
            }
        };
        ContextView.prototype.layout = function () {
            if (!this.isVisible()) {
                return;
            }
            if (this.delegate.canRelayout === false) {
                this.hide();
                return;
            }
            if (this.delegate.layout) {
                this.delegate.layout();
            }
            this.doLayout();
        };
        ContextView.prototype.doLayout = function () {
            // Check that we still have a delegate - this.delegate.layout may have hidden
            if (!this.isVisible()) {
                return;
            }
            // Get anchor
            var anchor = this.delegate.getAnchor();
            // Compute around
            var around;
            // Get the element's position and size (to anchor the view)
            if (DOM.isHTMLElement(anchor)) {
                var elementPosition = DOM.getDomNodePagePosition(anchor);
                around = {
                    top: elementPosition.top,
                    left: elementPosition.left,
                    width: elementPosition.width,
                    height: elementPosition.height
                };
            }
            else {
                var realAnchor = anchor;
                around = {
                    top: realAnchor.y,
                    left: realAnchor.x,
                    width: realAnchor.width || 1,
                    height: realAnchor.height || 2
                };
            }
            var viewSizeWidth = DOM.getTotalWidth(this.view);
            var viewSizeHeight = DOM.getTotalHeight(this.view);
            var anchorPosition = this.delegate.anchorPosition || 0 /* BELOW */;
            var anchorAlignment = this.delegate.anchorAlignment || 0 /* LEFT */;
            var verticalAnchor = { offset: around.top - window.pageYOffset, size: around.height, position: anchorPosition === 0 /* BELOW */ ? 0 /* Before */ : 1 /* After */ };
            var horizontalAnchor;
            if (anchorAlignment === 0 /* LEFT */) {
                horizontalAnchor = { offset: around.left, size: 0, position: 0 /* Before */ };
            }
            else {
                horizontalAnchor = { offset: around.left + around.width, size: 0, position: 1 /* After */ };
            }
            var top = layout(window.innerHeight, viewSizeHeight, verticalAnchor) + window.pageYOffset;
            // if view intersects vertically with anchor, shift it horizontally
            if (range_1.Range.intersects({ start: top, end: top + viewSizeHeight }, { start: verticalAnchor.offset, end: verticalAnchor.offset + verticalAnchor.size })) {
                horizontalAnchor.size = around.width;
            }
            var left = layout(window.innerWidth, viewSizeWidth, horizontalAnchor);
            DOM.removeClasses(this.view, 'top', 'bottom', 'left', 'right');
            DOM.addClass(this.view, anchorPosition === 0 /* BELOW */ ? 'bottom' : 'top');
            DOM.addClass(this.view, anchorAlignment === 0 /* LEFT */ ? 'left' : 'right');
            var containerPosition = DOM.getDomNodePagePosition(this.container);
            this.view.style.top = top - containerPosition.top + "px";
            this.view.style.left = left - containerPosition.left + "px";
            this.view.style.width = 'initial';
        };
        ContextView.prototype.hide = function (data) {
            if (this.delegate && this.delegate.onHide) {
                this.delegate.onHide(data);
            }
            this.delegate = null;
            if (this.toDisposeOnClean) {
                this.toDisposeOnClean.dispose();
                this.toDisposeOnClean = null;
            }
            DOM.hide(this.view);
        };
        ContextView.prototype.isVisible = function () {
            return !!this.delegate;
        };
        ContextView.prototype.onDOMEvent = function (e, element, onCapture) {
            if (this.delegate) {
                if (this.delegate.onDOMEvent) {
                    this.delegate.onDOMEvent(e, document.activeElement);
                }
                else if (onCapture && !DOM.isAncestor(e.target, this.container)) {
                    this.hide();
                }
            }
        };
        ContextView.prototype.dispose = function () {
            this.hide();
            _super.prototype.dispose.call(this);
        };
        ContextView.BUBBLE_UP_EVENTS = ['click', 'keydown', 'focus', 'blur'];
        ContextView.BUBBLE_DOWN_EVENTS = ['click'];
        return ContextView;
    }(lifecycle_1.Disposable));
    exports.ContextView = ContextView;
});

define(__m[528/*vs/css!vs/base/browser/ui/countBadge/countBadge*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[549/*vs/base/browser/ui/countBadge/countBadge*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/,8/*vs/base/common/strings*/,28/*vs/base/common/color*/,27/*vs/base/common/objects*/,528/*vs/css!vs/base/browser/ui/countBadge/countBadge*/]), function (require, exports, dom_1, strings_1, color_1, objects_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var defaultOpts = {
        badgeBackground: color_1.Color.fromHex('#4D4D4D'),
        badgeForeground: color_1.Color.fromHex('#FFFFFF')
    };
    var CountBadge = /** @class */ (function () {
        function CountBadge(container, options) {
            this.options = options || Object.create(null);
            objects_1.mixin(this.options, defaultOpts, false);
            this.badgeBackground = this.options.badgeBackground;
            this.badgeForeground = this.options.badgeForeground;
            this.badgeBorder = this.options.badgeBorder;
            this.element = dom_1.append(container, dom_1.$('.monaco-count-badge'));
            this.countFormat = this.options.countFormat || '{0}';
            this.titleFormat = this.options.titleFormat || '';
            this.setCount(this.options.count || 0);
        }
        CountBadge.prototype.setCount = function (count) {
            this.count = count;
            this.render();
        };
        CountBadge.prototype.setTitleFormat = function (titleFormat) {
            this.titleFormat = titleFormat;
            this.render();
        };
        CountBadge.prototype.render = function () {
            this.element.textContent = strings_1.format(this.countFormat, this.count);
            this.element.title = strings_1.format(this.titleFormat, this.count);
            this.applyStyles();
        };
        CountBadge.prototype.style = function (styles) {
            this.badgeBackground = styles.badgeBackground;
            this.badgeForeground = styles.badgeForeground;
            this.badgeBorder = styles.badgeBorder;
            this.applyStyles();
        };
        CountBadge.prototype.applyStyles = function () {
            if (this.element) {
                var background = this.badgeBackground ? this.badgeBackground.toString() : null;
                var foreground = this.badgeForeground ? this.badgeForeground.toString() : null;
                var border = this.badgeBorder ? this.badgeBorder.toString() : null;
                this.element.style.backgroundColor = background;
                this.element.style.color = foreground;
                this.element.style.borderWidth = border ? '1px' : null;
                this.element.style.borderStyle = border ? 'solid' : null;
                this.element.style.borderColor = border;
            }
        };
        return CountBadge;
    }());
    exports.CountBadge = CountBadge;
});

define(__m[557/*vs/css!vs/base/browser/ui/findinput/findInput*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[563/*vs/css!vs/base/browser/ui/findinput/findInputCheckboxes*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[204/*vs/css!vs/base/browser/ui/iconLabel/iconlabel*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[118/*vs/base/browser/ui/iconLabel/iconLabel*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/,159/*vs/base/browser/ui/highlightedlabel/highlightedLabel*/,2/*vs/base/common/lifecycle*/,204/*vs/css!vs/base/browser/ui/iconLabel/iconlabel*/]), function (require, exports, dom, highlightedLabel_1, lifecycle_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var FastLabelNode = /** @class */ (function () {
        function FastLabelNode(_element) {
            this._element = _element;
        }
        Object.defineProperty(FastLabelNode.prototype, "element", {
            get: function () {
                return this._element;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FastLabelNode.prototype, "textContent", {
            set: function (content) {
                if (this.disposed || content === this._textContent) {
                    return;
                }
                this._textContent = content;
                this._element.textContent = content;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FastLabelNode.prototype, "className", {
            set: function (className) {
                if (this.disposed || className === this._className) {
                    return;
                }
                this._className = className;
                this._element.className = className;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FastLabelNode.prototype, "title", {
            set: function (title) {
                if (this.disposed || title === this._title) {
                    return;
                }
                this._title = title;
                if (this._title) {
                    this._element.title = title;
                }
                else {
                    this._element.removeAttribute('title');
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FastLabelNode.prototype, "empty", {
            set: function (empty) {
                if (this.disposed || empty === this._empty) {
                    return;
                }
                this._empty = empty;
                this._element.style.marginLeft = empty ? '0' : null;
            },
            enumerable: true,
            configurable: true
        });
        FastLabelNode.prototype.dispose = function () {
            this.disposed = true;
        };
        return FastLabelNode;
    }());
    var IconLabel = /** @class */ (function (_super) {
        __extends(IconLabel, _super);
        function IconLabel(container, options) {
            var _this = _super.call(this) || this;
            _this.domNode = _this._register(new FastLabelNode(dom.append(container, dom.$('.monaco-icon-label'))));
            _this.labelDescriptionContainer = _this._register(new FastLabelNode(dom.append(_this.domNode.element, dom.$('.monaco-icon-label-description-container'))));
            if (options && options.supportHighlights) {
                _this.labelNode = _this._register(new highlightedLabel_1.HighlightedLabel(dom.append(_this.labelDescriptionContainer.element, dom.$('a.label-name')), !options.donotSupportOcticons));
            }
            else {
                _this.labelNode = _this._register(new FastLabelNode(dom.append(_this.labelDescriptionContainer.element, dom.$('a.label-name'))));
            }
            if (options && options.supportDescriptionHighlights) {
                _this.descriptionNodeFactory = function () { return _this._register(new highlightedLabel_1.HighlightedLabel(dom.append(_this.labelDescriptionContainer.element, dom.$('span.label-description')), !options.donotSupportOcticons)); };
            }
            else {
                _this.descriptionNodeFactory = function () { return _this._register(new FastLabelNode(dom.append(_this.labelDescriptionContainer.element, dom.$('span.label-description')))); };
            }
            return _this;
        }
        IconLabel.prototype.setValue = function (label, description, options) {
            var classes = ['monaco-icon-label'];
            if (options) {
                if (options.extraClasses) {
                    classes.push.apply(classes, options.extraClasses);
                }
                if (options.italic) {
                    classes.push('italic');
                }
            }
            this.domNode.className = classes.join(' ');
            this.domNode.title = options && options.title ? options.title : '';
            if (this.labelNode instanceof highlightedLabel_1.HighlightedLabel) {
                this.labelNode.set(label || '', options ? options.matches : void 0, options && options.title ? options.title : void 0, options && options.labelEscapeNewLines);
            }
            else {
                this.labelNode.textContent = label || '';
            }
            if (description || this.descriptionNode) {
                if (!this.descriptionNode) {
                    this.descriptionNode = this.descriptionNodeFactory(); // description node is created lazily on demand
                }
                if (this.descriptionNode instanceof highlightedLabel_1.HighlightedLabel) {
                    this.descriptionNode.set(description || '', options ? options.descriptionMatches : void 0);
                    if (options && options.descriptionTitle) {
                        this.descriptionNode.element.title = options.descriptionTitle;
                    }
                    else {
                        this.descriptionNode.element.removeAttribute('title');
                    }
                }
                else {
                    this.descriptionNode.textContent = description || '';
                    this.descriptionNode.title = options && options.descriptionTitle ? options.descriptionTitle : '';
                    this.descriptionNode.empty = !description;
                }
            }
        };
        return IconLabel;
    }(lifecycle_1.Disposable));
    exports.IconLabel = IconLabel;
});

define(__m[206/*vs/css!vs/base/browser/ui/inputbox/inputBox*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[210/*vs/css!vs/base/browser/ui/keybindingLabel/keybindingLabel*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[211/*vs/css!vs/base/browser/ui/list/list*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[212/*vs/css!vs/base/browser/ui/menu/menu*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[216/*vs/css!vs/base/browser/ui/progressbar/progressbar*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[219/*vs/base/browser/ui/progressbar/progressbar*/], __M([0/*require*/,1/*exports*/,2/*vs/base/common/lifecycle*/,28/*vs/base/common/color*/,27/*vs/base/common/objects*/,7/*vs/base/browser/dom*/,16/*vs/base/common/async*/,216/*vs/css!vs/base/browser/ui/progressbar/progressbar*/]), function (require, exports, lifecycle_1, color_1, objects_1, dom_1, async_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var css_done = 'done';
    var css_active = 'active';
    var css_infinite = 'infinite';
    var css_discrete = 'discrete';
    var css_progress_container = 'monaco-progress-container';
    var css_progress_bit = 'progress-bit';
    var defaultOpts = {
        progressBarBackground: color_1.Color.fromHex('#0E70C0')
    };
    /**
     * A progress bar with support for infinite or discrete progress.
     */
    var ProgressBar = /** @class */ (function (_super) {
        __extends(ProgressBar, _super);
        function ProgressBar(container, options) {
            var _this = _super.call(this) || this;
            _this.options = options || Object.create(null);
            objects_1.mixin(_this.options, defaultOpts, false);
            _this.workedVal = 0;
            _this.progressBarBackground = _this.options.progressBarBackground;
            _this._register(_this.showDelayedScheduler = new async_1.RunOnceScheduler(function () { return dom_1.show(_this.element); }, 0));
            _this.create(container);
            return _this;
        }
        ProgressBar.prototype.create = function (container) {
            this.element = document.createElement('div');
            dom_1.addClass(this.element, css_progress_container);
            container.appendChild(this.element);
            this.bit = document.createElement('div');
            dom_1.addClass(this.bit, css_progress_bit);
            this.element.appendChild(this.bit);
            this.applyStyles();
        };
        ProgressBar.prototype.off = function () {
            this.bit.style.width = 'inherit';
            this.bit.style.opacity = '1';
            dom_1.removeClasses(this.element, css_active, css_infinite, css_discrete);
            this.workedVal = 0;
            this.totalWork = undefined;
        };
        /**
         * Stops the progressbar from showing any progress instantly without fading out.
         */
        ProgressBar.prototype.stop = function () {
            return this.doDone(false);
        };
        ProgressBar.prototype.doDone = function (delayed) {
            var _this = this;
            dom_1.addClass(this.element, css_done);
            // let it grow to 100% width and hide afterwards
            if (!dom_1.hasClass(this.element, css_infinite)) {
                this.bit.style.width = 'inherit';
                if (delayed) {
                    setTimeout(function () { return _this.off(); }, 200);
                }
                else {
                    this.off();
                }
            }
            // let it fade out and hide afterwards
            else {
                this.bit.style.opacity = '0';
                if (delayed) {
                    setTimeout(function () { return _this.off(); }, 200);
                }
                else {
                    this.off();
                }
            }
            return this;
        };
        ProgressBar.prototype.hide = function () {
            dom_1.hide(this.element);
            this.showDelayedScheduler.cancel();
        };
        ProgressBar.prototype.style = function (styles) {
            this.progressBarBackground = styles.progressBarBackground;
            this.applyStyles();
        };
        ProgressBar.prototype.applyStyles = function () {
            if (this.bit) {
                var background = this.progressBarBackground ? this.progressBarBackground.toString() : null;
                this.bit.style.backgroundColor = background;
            }
        };
        return ProgressBar;
    }(lifecycle_1.Disposable));
    exports.ProgressBar = ProgressBar;
});

define(__m[220/*vs/css!vs/base/browser/ui/sash/sash*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[102/*vs/base/browser/ui/sash/sash*/], __M([0/*require*/,1/*exports*/,2/*vs/base/common/lifecycle*/,29/*vs/base/browser/browser*/,17/*vs/base/common/platform*/,32/*vs/base/common/types*/,75/*vs/base/browser/touch*/,40/*vs/base/browser/mouseEvent*/,6/*vs/base/common/event*/,7/*vs/base/browser/dom*/,72/*vs/base/browser/event*/,220/*vs/css!vs/base/browser/ui/sash/sash*/]), function (require, exports, lifecycle_1, browser_1, platform_1, types, touch_1, mouseEvent_1, event_1, dom_1, event_2) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var DEBUG = false;
    var Sash = /** @class */ (function (_super) {
        __extends(Sash, _super);
        function Sash(container, layoutProvider, options) {
            if (options === void 0) { options = {}; }
            var _this = _super.call(this) || this;
            _this._state = 3 /* Enabled */;
            _this._onDidEnablementChange = _this._register(new event_1.Emitter());
            _this.onDidEnablementChange = _this._onDidEnablementChange.event;
            _this._onDidStart = _this._register(new event_1.Emitter());
            _this.onDidStart = _this._onDidStart.event;
            _this._onDidChange = _this._register(new event_1.Emitter());
            _this.onDidChange = _this._onDidChange.event;
            _this._onDidReset = _this._register(new event_1.Emitter());
            _this.onDidReset = _this._onDidReset.event;
            _this._onDidEnd = _this._register(new event_1.Emitter());
            _this.onDidEnd = _this._onDidEnd.event;
            _this.linkedSash = undefined;
            _this.orthogonalStartSashDisposables = [];
            _this.orthogonalEndSashDisposables = [];
            _this.el = dom_1.append(container, dom_1.$('.monaco-sash'));
            if (platform_1.isMacintosh) {
                dom_1.addClass(_this.el, 'mac');
            }
            _this._register(event_2.domEvent(_this.el, 'mousedown')(_this.onMouseDown, _this));
            _this._register(event_2.domEvent(_this.el, 'dblclick')(_this.onMouseDoubleClick, _this));
            touch_1.Gesture.addTarget(_this.el);
            _this._register(event_2.domEvent(_this.el, touch_1.EventType.Start)(_this.onTouchStart, _this));
            if (browser_1.isIPad) {
                // see also http://ux.stackexchange.com/questions/39023/what-is-the-optimum-button-size-of-touch-screen-applications
                dom_1.addClass(_this.el, 'touch');
            }
            _this.setOrientation(options.orientation || 0 /* VERTICAL */);
            _this.hidden = false;
            _this.layoutProvider = layoutProvider;
            _this.orthogonalStartSash = options.orthogonalStartSash;
            _this.orthogonalEndSash = options.orthogonalEndSash;
            dom_1.toggleClass(_this.el, 'debug', DEBUG);
            return _this;
        }
        Object.defineProperty(Sash.prototype, "state", {
            get: function () { return this._state; },
            set: function (state) {
                if (this._state === state) {
                    return;
                }
                dom_1.toggleClass(this.el, 'disabled', state === 0 /* Disabled */);
                dom_1.toggleClass(this.el, 'minimum', state === 1 /* Minimum */);
                dom_1.toggleClass(this.el, 'maximum', state === 2 /* Maximum */);
                this._state = state;
                this._onDidEnablementChange.fire(state);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Sash.prototype, "orthogonalStartSash", {
            get: function () { return this._orthogonalStartSash; },
            set: function (sash) {
                this.orthogonalStartSashDisposables = lifecycle_1.dispose(this.orthogonalStartSashDisposables);
                if (sash) {
                    sash.onDidEnablementChange(this.onOrthogonalStartSashEnablementChange, this, this.orthogonalStartSashDisposables);
                    this.onOrthogonalStartSashEnablementChange(sash.state);
                }
                else {
                    this.onOrthogonalStartSashEnablementChange(0 /* Disabled */);
                }
                this._orthogonalStartSash = sash;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Sash.prototype, "orthogonalEndSash", {
            get: function () { return this._orthogonalEndSash; },
            set: function (sash) {
                this.orthogonalEndSashDisposables = lifecycle_1.dispose(this.orthogonalEndSashDisposables);
                if (sash) {
                    sash.onDidEnablementChange(this.onOrthogonalEndSashEnablementChange, this, this.orthogonalEndSashDisposables);
                    this.onOrthogonalEndSashEnablementChange(sash.state);
                }
                else {
                    this.onOrthogonalEndSashEnablementChange(0 /* Disabled */);
                }
                this._orthogonalEndSash = sash;
            },
            enumerable: true,
            configurable: true
        });
        Sash.prototype.setOrientation = function (orientation) {
            this.orientation = orientation;
            if (this.orientation === 1 /* HORIZONTAL */) {
                dom_1.addClass(this.el, 'horizontal');
                dom_1.removeClass(this.el, 'vertical');
            }
            else {
                dom_1.removeClass(this.el, 'horizontal');
                dom_1.addClass(this.el, 'vertical');
            }
            if (this.layoutProvider) {
                this.layout();
            }
        };
        Sash.prototype.onMouseDown = function (e) {
            var _this = this;
            dom_1.EventHelper.stop(e, false);
            var isMultisashResize = false;
            if (this.linkedSash && !e.__linkedSashEvent) {
                e.__linkedSashEvent = true;
                this.linkedSash.onMouseDown(e);
            }
            if (!e.__orthogonalSashEvent) {
                var orthogonalSash = void 0;
                if (this.orientation === 0 /* VERTICAL */) {
                    if (e.offsetY <= 4) {
                        orthogonalSash = this.orthogonalStartSash;
                    }
                    else if (e.offsetY >= this.el.clientHeight - 4) {
                        orthogonalSash = this.orthogonalEndSash;
                    }
                }
                else {
                    if (e.offsetX <= 4) {
                        orthogonalSash = this.orthogonalStartSash;
                    }
                    else if (e.offsetX >= this.el.clientWidth - 4) {
                        orthogonalSash = this.orthogonalEndSash;
                    }
                }
                if (orthogonalSash) {
                    isMultisashResize = true;
                    e.__orthogonalSashEvent = true;
                    orthogonalSash.onMouseDown(e);
                }
            }
            if (!this.state) {
                return;
            }
            var iframes = dom_1.getElementsByTagName('iframe');
            for (var _i = 0, iframes_1 = iframes; _i < iframes_1.length; _i++) {
                var iframe = iframes_1[_i];
                iframe.style.pointerEvents = 'none'; // disable mouse events on iframes as long as we drag the sash
            }
            var mouseDownEvent = new mouseEvent_1.StandardMouseEvent(e);
            var startX = mouseDownEvent.posx;
            var startY = mouseDownEvent.posy;
            var altKey = mouseDownEvent.altKey;
            var startEvent = { startX: startX, currentX: startX, startY: startY, currentY: startY, altKey: altKey };
            dom_1.addClass(this.el, 'active');
            this._onDidStart.fire(startEvent);
            // fix https://github.com/Microsoft/vscode/issues/21675
            var style = dom_1.createStyleSheet(this.el);
            var updateStyle = function () {
                var cursor = '';
                if (isMultisashResize) {
                    cursor = 'all-scroll';
                }
                else if (_this.orientation === 1 /* HORIZONTAL */) {
                    if (_this.state === 1 /* Minimum */) {
                        cursor = 's-resize';
                    }
                    else if (_this.state === 2 /* Maximum */) {
                        cursor = 'n-resize';
                    }
                    else {
                        cursor = platform_1.isMacintosh ? 'row-resize' : 'ns-resize';
                    }
                }
                else {
                    if (_this.state === 1 /* Minimum */) {
                        cursor = 'e-resize';
                    }
                    else if (_this.state === 2 /* Maximum */) {
                        cursor = 'w-resize';
                    }
                    else {
                        cursor = platform_1.isMacintosh ? 'col-resize' : 'ew-resize';
                    }
                }
                style.innerHTML = "* { cursor: " + cursor + " !important; }";
            };
            var disposables = [];
            updateStyle();
            if (!isMultisashResize) {
                this.onDidEnablementChange(updateStyle, null, disposables);
            }
            var onMouseMove = function (e) {
                dom_1.EventHelper.stop(e, false);
                var mouseMoveEvent = new mouseEvent_1.StandardMouseEvent(e);
                var event = { startX: startX, currentX: mouseMoveEvent.posx, startY: startY, currentY: mouseMoveEvent.posy, altKey: altKey };
                _this._onDidChange.fire(event);
            };
            var onMouseUp = function (e) {
                dom_1.EventHelper.stop(e, false);
                _this.el.removeChild(style);
                dom_1.removeClass(_this.el, 'active');
                _this._onDidEnd.fire();
                lifecycle_1.dispose(disposables);
                var iframes = dom_1.getElementsByTagName('iframe');
                for (var _i = 0, iframes_2 = iframes; _i < iframes_2.length; _i++) {
                    var iframe = iframes_2[_i];
                    iframe.style.pointerEvents = 'auto';
                }
            };
            event_2.domEvent(window, 'mousemove')(onMouseMove, null, disposables);
            event_2.domEvent(window, 'mouseup')(onMouseUp, null, disposables);
        };
        Sash.prototype.onMouseDoubleClick = function (event) {
            this._onDidReset.fire();
        };
        Sash.prototype.onTouchStart = function (event) {
            var _this = this;
            dom_1.EventHelper.stop(event);
            var listeners = [];
            var startX = event.pageX;
            var startY = event.pageY;
            var altKey = event.altKey;
            this._onDidStart.fire({
                startX: startX,
                currentX: startX,
                startY: startY,
                currentY: startY,
                altKey: altKey
            });
            listeners.push(dom_1.addDisposableListener(this.el, touch_1.EventType.Change, function (event) {
                if (types.isNumber(event.pageX) && types.isNumber(event.pageY)) {
                    _this._onDidChange.fire({
                        startX: startX,
                        currentX: event.pageX,
                        startY: startY,
                        currentY: event.pageY,
                        altKey: altKey
                    });
                }
            }));
            listeners.push(dom_1.addDisposableListener(this.el, touch_1.EventType.End, function (event) {
                _this._onDidEnd.fire();
                lifecycle_1.dispose(listeners);
            }));
        };
        Sash.prototype.layout = function () {
            var size = browser_1.isIPad ? 20 : 4;
            if (this.orientation === 0 /* VERTICAL */) {
                var verticalProvider = this.layoutProvider;
                this.el.style.left = verticalProvider.getVerticalSashLeft(this) - (size / 2) + 'px';
                if (verticalProvider.getVerticalSashTop) {
                    this.el.style.top = verticalProvider.getVerticalSashTop(this) + 'px';
                }
                if (verticalProvider.getVerticalSashHeight) {
                    this.el.style.height = verticalProvider.getVerticalSashHeight(this) + 'px';
                }
            }
            else {
                var horizontalProvider = this.layoutProvider;
                this.el.style.top = horizontalProvider.getHorizontalSashTop(this) - (size / 2) + 'px';
                if (horizontalProvider.getHorizontalSashLeft) {
                    this.el.style.left = horizontalProvider.getHorizontalSashLeft(this) + 'px';
                }
                if (horizontalProvider.getHorizontalSashWidth) {
                    this.el.style.width = horizontalProvider.getHorizontalSashWidth(this) + 'px';
                }
            }
        };
        Sash.prototype.hide = function () {
            this.hidden = true;
            this.el.style.display = 'none';
            this.el.setAttribute('aria-hidden', 'true');
        };
        Sash.prototype.onOrthogonalStartSashEnablementChange = function (state) {
            dom_1.toggleClass(this.el, 'orthogonal-start', state !== 0 /* Disabled */);
        };
        Sash.prototype.onOrthogonalEndSashEnablementChange = function (state) {
            dom_1.toggleClass(this.el, 'orthogonal-end', state !== 0 /* Disabled */);
        };
        Sash.prototype.dispose = function () {
            _super.prototype.dispose.call(this);
            this.orthogonalStartSashDisposables = lifecycle_1.dispose(this.orthogonalStartSashDisposables);
            this.orthogonalEndSashDisposables = lifecycle_1.dispose(this.orthogonalEndSashDisposables);
            if (this.el && this.el.parentElement) {
                this.el.parentElement.removeChild(this.el);
            }
            this.el = null; // StrictNullOverride: nulling out ok in dispose
        };
        return Sash;
    }(lifecycle_1.Disposable));
    exports.Sash = Sash;
});

define(__m[224/*vs/css!vs/base/browser/ui/scrollbar/media/scrollbars*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[55/*vs/base/browser/ui/scrollbar/scrollableElement*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/,23/*vs/base/browser/fastDomNode*/,40/*vs/base/browser/mouseEvent*/,420/*vs/base/browser/ui/scrollbar/horizontalScrollbar*/,422/*vs/base/browser/ui/scrollbar/verticalScrollbar*/,46/*vs/base/browser/ui/widget*/,16/*vs/base/common/async*/,6/*vs/base/common/event*/,2/*vs/base/common/lifecycle*/,17/*vs/base/common/platform*/,169/*vs/base/common/scrollable*/,224/*vs/css!vs/base/browser/ui/scrollbar/media/scrollbars*/]), function (require, exports, dom, fastDomNode_1, mouseEvent_1, horizontalScrollbar_1, verticalScrollbar_1, widget_1, async_1, event_1, lifecycle_1, platform, scrollable_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var HIDE_TIMEOUT = 500;
    var SCROLL_WHEEL_SENSITIVITY = 50;
    var SCROLL_WHEEL_SMOOTH_SCROLL_ENABLED = true;
    var MouseWheelClassifierItem = /** @class */ (function () {
        function MouseWheelClassifierItem(timestamp, deltaX, deltaY) {
            this.timestamp = timestamp;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.score = 0;
        }
        return MouseWheelClassifierItem;
    }());
    var MouseWheelClassifier = /** @class */ (function () {
        function MouseWheelClassifier() {
            this._capacity = 5;
            this._memory = [];
            this._front = -1;
            this._rear = -1;
        }
        MouseWheelClassifier.prototype.isPhysicalMouseWheel = function () {
            if (this._front === -1 && this._rear === -1) {
                // no elements
                return false;
            }
            // 0.5 * last + 0.25 * before last + 0.125 * before before last + ...
            var remainingInfluence = 1;
            var score = 0;
            var iteration = 1;
            var index = this._rear;
            do {
                var influence = (index === this._front ? remainingInfluence : Math.pow(2, -iteration));
                remainingInfluence -= influence;
                score += this._memory[index].score * influence;
                if (index === this._front) {
                    break;
                }
                index = (this._capacity + index - 1) % this._capacity;
                iteration++;
            } while (true);
            return (score <= 0.5);
        };
        MouseWheelClassifier.prototype.accept = function (timestamp, deltaX, deltaY) {
            var item = new MouseWheelClassifierItem(timestamp, deltaX, deltaY);
            item.score = this._computeScore(item);
            if (this._front === -1 && this._rear === -1) {
                this._memory[0] = item;
                this._front = 0;
                this._rear = 0;
            }
            else {
                this._rear = (this._rear + 1) % this._capacity;
                if (this._rear === this._front) {
                    // Drop oldest
                    this._front = (this._front + 1) % this._capacity;
                }
                this._memory[this._rear] = item;
            }
        };
        /**
         * A score between 0 and 1 for `item`.
         *  - a score towards 0 indicates that the source appears to be a physical mouse wheel
         *  - a score towards 1 indicates that the source appears to be a touchpad or magic mouse, etc.
         */
        MouseWheelClassifier.prototype._computeScore = function (item) {
            if (Math.abs(item.deltaX) > 0 && Math.abs(item.deltaY) > 0) {
                // both axes exercised => definitely not a physical mouse wheel
                return 1;
            }
            var score = 0.5;
            var prev = (this._front === -1 && this._rear === -1 ? null : this._memory[this._rear]);
            if (prev) {
                // const deltaT = item.timestamp - prev.timestamp;
                // if (deltaT < 1000 / 30) {
                // 	// sooner than X times per second => indicator that this is not a physical mouse wheel
                // 	score += 0.25;
                // }
                // if (item.deltaX === prev.deltaX && item.deltaY === prev.deltaY) {
                // 	// equal amplitude => indicator that this is a physical mouse wheel
                // 	score -= 0.25;
                // }
            }
            if (Math.abs(item.deltaX - Math.round(item.deltaX)) > 0 || Math.abs(item.deltaY - Math.round(item.deltaY)) > 0) {
                // non-integer deltas => indicator that this is not a physical mouse wheel
                score += 0.25;
            }
            return Math.min(Math.max(score, 0), 1);
        };
        MouseWheelClassifier.INSTANCE = new MouseWheelClassifier();
        return MouseWheelClassifier;
    }());
    exports.MouseWheelClassifier = MouseWheelClassifier;
    var AbstractScrollableElement = /** @class */ (function (_super) {
        __extends(AbstractScrollableElement, _super);
        function AbstractScrollableElement(element, options, scrollable) {
            var _this = _super.call(this) || this;
            _this._onScroll = _this._register(new event_1.Emitter());
            _this.onScroll = _this._onScroll.event;
            element.style.overflow = 'hidden';
            _this._options = resolveOptions(options);
            _this._scrollable = scrollable;
            _this._register(_this._scrollable.onScroll(function (e) {
                _this._onDidScroll(e);
                _this._onScroll.fire(e);
            }));
            var scrollbarHost = {
                onMouseWheel: function (mouseWheelEvent) { return _this._onMouseWheel(mouseWheelEvent); },
                onDragStart: function () { return _this._onDragStart(); },
                onDragEnd: function () { return _this._onDragEnd(); },
            };
            _this._verticalScrollbar = _this._register(new verticalScrollbar_1.VerticalScrollbar(_this._scrollable, _this._options, scrollbarHost));
            _this._horizontalScrollbar = _this._register(new horizontalScrollbar_1.HorizontalScrollbar(_this._scrollable, _this._options, scrollbarHost));
            _this._domNode = document.createElement('div');
            _this._domNode.className = 'monaco-scrollable-element ' + _this._options.className;
            _this._domNode.setAttribute('role', 'presentation');
            _this._domNode.style.position = 'relative';
            _this._domNode.style.overflow = 'hidden';
            _this._domNode.appendChild(element);
            _this._domNode.appendChild(_this._horizontalScrollbar.domNode.domNode);
            _this._domNode.appendChild(_this._verticalScrollbar.domNode.domNode);
            if (_this._options.useShadows) {
                _this._leftShadowDomNode = fastDomNode_1.createFastDomNode(document.createElement('div'));
                _this._leftShadowDomNode.setClassName('shadow');
                _this._domNode.appendChild(_this._leftShadowDomNode.domNode);
                _this._topShadowDomNode = fastDomNode_1.createFastDomNode(document.createElement('div'));
                _this._topShadowDomNode.setClassName('shadow');
                _this._domNode.appendChild(_this._topShadowDomNode.domNode);
                _this._topLeftShadowDomNode = fastDomNode_1.createFastDomNode(document.createElement('div'));
                _this._topLeftShadowDomNode.setClassName('shadow top-left-corner');
                _this._domNode.appendChild(_this._topLeftShadowDomNode.domNode);
            }
            _this._listenOnDomNode = _this._options.listenOnDomNode || _this._domNode;
            _this._mouseWheelToDispose = [];
            _this._setListeningToMouseWheel(_this._options.handleMouseWheel);
            _this.onmouseover(_this._listenOnDomNode, function (e) { return _this._onMouseOver(e); });
            _this.onnonbubblingmouseout(_this._listenOnDomNode, function (e) { return _this._onMouseOut(e); });
            _this._hideTimeout = _this._register(new async_1.TimeoutTimer());
            _this._isDragging = false;
            _this._mouseIsOver = false;
            _this._shouldRender = true;
            _this._revealOnScroll = true;
            return _this;
        }
        AbstractScrollableElement.prototype.dispose = function () {
            this._mouseWheelToDispose = lifecycle_1.dispose(this._mouseWheelToDispose);
            _super.prototype.dispose.call(this);
        };
        /**
         * Get the generated 'scrollable' dom node
         */
        AbstractScrollableElement.prototype.getDomNode = function () {
            return this._domNode;
        };
        AbstractScrollableElement.prototype.getOverviewRulerLayoutInfo = function () {
            return {
                parent: this._domNode,
                insertBefore: this._verticalScrollbar.domNode.domNode,
            };
        };
        /**
         * Delegate a mouse down event to the vertical scrollbar.
         * This is to help with clicking somewhere else and having the scrollbar react.
         */
        AbstractScrollableElement.prototype.delegateVerticalScrollbarMouseDown = function (browserEvent) {
            this._verticalScrollbar.delegateMouseDown(browserEvent);
        };
        AbstractScrollableElement.prototype.getScrollDimensions = function () {
            return this._scrollable.getScrollDimensions();
        };
        AbstractScrollableElement.prototype.setScrollDimensions = function (dimensions) {
            this._scrollable.setScrollDimensions(dimensions);
        };
        /**
         * Update the class name of the scrollable element.
         */
        AbstractScrollableElement.prototype.updateClassName = function (newClassName) {
            this._options.className = newClassName;
            // Defaults are different on Macs
            if (platform.isMacintosh) {
                this._options.className += ' mac';
            }
            this._domNode.className = 'monaco-scrollable-element ' + this._options.className;
        };
        /**
         * Update configuration options for the scrollbar.
         * Really this is Editor.IEditorScrollbarOptions, but base shouldn't
         * depend on Editor.
         */
        AbstractScrollableElement.prototype.updateOptions = function (newOptions) {
            var massagedOptions = resolveOptions(newOptions);
            this._options.handleMouseWheel = massagedOptions.handleMouseWheel;
            this._options.mouseWheelScrollSensitivity = massagedOptions.mouseWheelScrollSensitivity;
            this._setListeningToMouseWheel(this._options.handleMouseWheel);
            if (!this._options.lazyRender) {
                this._render();
            }
        };
        // -------------------- mouse wheel scrolling --------------------
        AbstractScrollableElement.prototype._setListeningToMouseWheel = function (shouldListen) {
            var _this = this;
            var isListening = (this._mouseWheelToDispose.length > 0);
            if (isListening === shouldListen) {
                // No change
                return;
            }
            // Stop listening (if necessary)
            this._mouseWheelToDispose = lifecycle_1.dispose(this._mouseWheelToDispose);
            // Start listening (if necessary)
            if (shouldListen) {
                var onMouseWheel = function (browserEvent) {
                    var e = new mouseEvent_1.StandardMouseWheelEvent(browserEvent);
                    _this._onMouseWheel(e);
                };
                this._mouseWheelToDispose.push(dom.addDisposableListener(this._listenOnDomNode, 'mousewheel', onMouseWheel));
                this._mouseWheelToDispose.push(dom.addDisposableListener(this._listenOnDomNode, 'DOMMouseScroll', onMouseWheel));
            }
        };
        AbstractScrollableElement.prototype._onMouseWheel = function (e) {
            var _a;
            var classifier = MouseWheelClassifier.INSTANCE;
            if (SCROLL_WHEEL_SMOOTH_SCROLL_ENABLED) {
                classifier.accept(Date.now(), e.deltaX, e.deltaY);
            }
            // console.log(`${Date.now()}, ${e.deltaY}, ${e.deltaX}`);
            if (e.deltaY || e.deltaX) {
                var deltaY = e.deltaY * this._options.mouseWheelScrollSensitivity;
                var deltaX = e.deltaX * this._options.mouseWheelScrollSensitivity;
                if (this._options.flipAxes) {
                    _a = [deltaX, deltaY], deltaY = _a[0], deltaX = _a[1];
                }
                // Convert vertical scrolling to horizontal if shift is held, this
                // is handled at a higher level on Mac
                var shiftConvert = !platform.isMacintosh && e.browserEvent && e.browserEvent.shiftKey;
                if ((this._options.scrollYToX || shiftConvert) && !deltaX) {
                    deltaX = deltaY;
                    deltaY = 0;
                }
                var futureScrollPosition = this._scrollable.getFutureScrollPosition();
                var desiredScrollPosition = {};
                if (deltaY) {
                    var desiredScrollTop = futureScrollPosition.scrollTop - SCROLL_WHEEL_SENSITIVITY * deltaY;
                    this._verticalScrollbar.writeScrollPosition(desiredScrollPosition, desiredScrollTop);
                }
                if (deltaX) {
                    var desiredScrollLeft = futureScrollPosition.scrollLeft - SCROLL_WHEEL_SENSITIVITY * deltaX;
                    this._horizontalScrollbar.writeScrollPosition(desiredScrollPosition, desiredScrollLeft);
                }
                // Check that we are scrolling towards a location which is valid
                desiredScrollPosition = this._scrollable.validateScrollPosition(desiredScrollPosition);
                if (futureScrollPosition.scrollLeft !== desiredScrollPosition.scrollLeft || futureScrollPosition.scrollTop !== desiredScrollPosition.scrollTop) {
                    var canPerformSmoothScroll = (SCROLL_WHEEL_SMOOTH_SCROLL_ENABLED
                        && this._options.mouseWheelSmoothScroll
                        && classifier.isPhysicalMouseWheel());
                    if (canPerformSmoothScroll) {
                        this._scrollable.setScrollPositionSmooth(desiredScrollPosition);
                    }
                    else {
                        this._scrollable.setScrollPositionNow(desiredScrollPosition);
                    }
                    this._shouldRender = true;
                }
            }
            if (this._options.alwaysConsumeMouseWheel || this._shouldRender) {
                e.preventDefault();
                e.stopPropagation();
            }
        };
        AbstractScrollableElement.prototype._onDidScroll = function (e) {
            this._shouldRender = this._horizontalScrollbar.onDidScroll(e) || this._shouldRender;
            this._shouldRender = this._verticalScrollbar.onDidScroll(e) || this._shouldRender;
            if (this._options.useShadows) {
                this._shouldRender = true;
            }
            if (this._revealOnScroll) {
                this._reveal();
            }
            if (!this._options.lazyRender) {
                this._render();
            }
        };
        /**
         * Render / mutate the DOM now.
         * Should be used together with the ctor option `lazyRender`.
         */
        AbstractScrollableElement.prototype.renderNow = function () {
            if (!this._options.lazyRender) {
                throw new Error('Please use `lazyRender` together with `renderNow`!');
            }
            this._render();
        };
        AbstractScrollableElement.prototype._render = function () {
            if (!this._shouldRender) {
                return;
            }
            this._shouldRender = false;
            this._horizontalScrollbar.render();
            this._verticalScrollbar.render();
            if (this._options.useShadows) {
                var scrollState = this._scrollable.getCurrentScrollPosition();
                var enableTop = scrollState.scrollTop > 0;
                var enableLeft = scrollState.scrollLeft > 0;
                this._leftShadowDomNode.setClassName('shadow' + (enableLeft ? ' left' : ''));
                this._topShadowDomNode.setClassName('shadow' + (enableTop ? ' top' : ''));
                this._topLeftShadowDomNode.setClassName('shadow top-left-corner' + (enableTop ? ' top' : '') + (enableLeft ? ' left' : ''));
            }
        };
        // -------------------- fade in / fade out --------------------
        AbstractScrollableElement.prototype._onDragStart = function () {
            this._isDragging = true;
            this._reveal();
        };
        AbstractScrollableElement.prototype._onDragEnd = function () {
            this._isDragging = false;
            this._hide();
        };
        AbstractScrollableElement.prototype._onMouseOut = function (e) {
            this._mouseIsOver = false;
            this._hide();
        };
        AbstractScrollableElement.prototype._onMouseOver = function (e) {
            this._mouseIsOver = true;
            this._reveal();
        };
        AbstractScrollableElement.prototype._reveal = function () {
            this._verticalScrollbar.beginReveal();
            this._horizontalScrollbar.beginReveal();
            this._scheduleHide();
        };
        AbstractScrollableElement.prototype._hide = function () {
            if (!this._mouseIsOver && !this._isDragging) {
                this._verticalScrollbar.beginHide();
                this._horizontalScrollbar.beginHide();
            }
        };
        AbstractScrollableElement.prototype._scheduleHide = function () {
            var _this = this;
            if (!this._mouseIsOver && !this._isDragging) {
                this._hideTimeout.cancelAndSet(function () { return _this._hide(); }, HIDE_TIMEOUT);
            }
        };
        return AbstractScrollableElement;
    }(widget_1.Widget));
    exports.AbstractScrollableElement = AbstractScrollableElement;
    var ScrollableElement = /** @class */ (function (_super) {
        __extends(ScrollableElement, _super);
        function ScrollableElement(element, options) {
            var _this = this;
            options = options || {};
            options.mouseWheelSmoothScroll = false;
            var scrollable = new scrollable_1.Scrollable(0, function (callback) { return dom.scheduleAtNextAnimationFrame(callback); });
            _this = _super.call(this, element, options, scrollable) || this;
            _this._register(scrollable);
            return _this;
        }
        ScrollableElement.prototype.setScrollPosition = function (update) {
            this._scrollable.setScrollPositionNow(update);
        };
        ScrollableElement.prototype.getScrollPosition = function () {
            return this._scrollable.getCurrentScrollPosition();
        };
        return ScrollableElement;
    }(AbstractScrollableElement));
    exports.ScrollableElement = ScrollableElement;
    var SmoothScrollableElement = /** @class */ (function (_super) {
        __extends(SmoothScrollableElement, _super);
        function SmoothScrollableElement(element, options, scrollable) {
            return _super.call(this, element, options, scrollable) || this;
        }
        return SmoothScrollableElement;
    }(AbstractScrollableElement));
    exports.SmoothScrollableElement = SmoothScrollableElement;
    var DomScrollableElement = /** @class */ (function (_super) {
        __extends(DomScrollableElement, _super);
        function DomScrollableElement(element, options) {
            var _this = _super.call(this, element, options) || this;
            _this._element = element;
            _this.onScroll(function (e) {
                if (e.scrollTopChanged) {
                    _this._element.scrollTop = e.scrollTop;
                }
                if (e.scrollLeftChanged) {
                    _this._element.scrollLeft = e.scrollLeft;
                }
            });
            _this.scanDomNode();
            return _this;
        }
        DomScrollableElement.prototype.scanDomNode = function () {
            // widh, scrollLeft, scrollWidth, height, scrollTop, scrollHeight
            this.setScrollDimensions({
                width: this._element.clientWidth,
                scrollWidth: this._element.scrollWidth,
                height: this._element.clientHeight,
                scrollHeight: this._element.scrollHeight
            });
            this.setScrollPosition({
                scrollLeft: this._element.scrollLeft,
                scrollTop: this._element.scrollTop,
            });
        };
        return DomScrollableElement;
    }(ScrollableElement));
    exports.DomScrollableElement = DomScrollableElement;
    function resolveOptions(opts) {
        var result = {
            lazyRender: (typeof opts.lazyRender !== 'undefined' ? opts.lazyRender : false),
            className: (typeof opts.className !== 'undefined' ? opts.className : ''),
            useShadows: (typeof opts.useShadows !== 'undefined' ? opts.useShadows : true),
            handleMouseWheel: (typeof opts.handleMouseWheel !== 'undefined' ? opts.handleMouseWheel : true),
            flipAxes: (typeof opts.flipAxes !== 'undefined' ? opts.flipAxes : false),
            alwaysConsumeMouseWheel: (typeof opts.alwaysConsumeMouseWheel !== 'undefined' ? opts.alwaysConsumeMouseWheel : false),
            scrollYToX: (typeof opts.scrollYToX !== 'undefined' ? opts.scrollYToX : false),
            mouseWheelScrollSensitivity: (typeof opts.mouseWheelScrollSensitivity !== 'undefined' ? opts.mouseWheelScrollSensitivity : 1),
            mouseWheelSmoothScroll: (typeof opts.mouseWheelSmoothScroll !== 'undefined' ? opts.mouseWheelSmoothScroll : true),
            arrowSize: (typeof opts.arrowSize !== 'undefined' ? opts.arrowSize : 11),
            listenOnDomNode: (typeof opts.listenOnDomNode !== 'undefined' ? opts.listenOnDomNode : null),
            horizontal: (typeof opts.horizontal !== 'undefined' ? opts.horizontal : 1 /* Auto */),
            horizontalScrollbarSize: (typeof opts.horizontalScrollbarSize !== 'undefined' ? opts.horizontalScrollbarSize : 10),
            horizontalSliderSize: (typeof opts.horizontalSliderSize !== 'undefined' ? opts.horizontalSliderSize : 0),
            horizontalHasArrows: (typeof opts.horizontalHasArrows !== 'undefined' ? opts.horizontalHasArrows : false),
            vertical: (typeof opts.vertical !== 'undefined' ? opts.vertical : 1 /* Auto */),
            verticalScrollbarSize: (typeof opts.verticalScrollbarSize !== 'undefined' ? opts.verticalScrollbarSize : 10),
            verticalHasArrows: (typeof opts.verticalHasArrows !== 'undefined' ? opts.verticalHasArrows : false),
            verticalSliderSize: (typeof opts.verticalSliderSize !== 'undefined' ? opts.verticalSliderSize : 0)
        };
        result.horizontalSliderSize = (typeof opts.horizontalSliderSize !== 'undefined' ? opts.horizontalSliderSize : result.horizontalScrollbarSize);
        result.verticalSliderSize = (typeof opts.verticalSliderSize !== 'undefined' ? opts.verticalSliderSize : result.verticalScrollbarSize);
        // Defaults are different on Macs
        if (platform.isMacintosh) {
            result.className += ' mac';
        }
        return result;
    }
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/






define(__m[231/*vs/base/browser/ui/list/listView*/], __M([0/*require*/,1/*exports*/,27/*vs/base/common/objects*/,2/*vs/base/common/lifecycle*/,75/*vs/base/browser/touch*/,7/*vs/base/browser/dom*/,6/*vs/base/common/event*/,72/*vs/base/browser/event*/,55/*vs/base/browser/ui/scrollbar/scrollableElement*/,466/*vs/base/browser/ui/list/rangeMap*/,369/*vs/base/browser/ui/list/rowCache*/,17/*vs/base/common/platform*/,29/*vs/base/browser/browser*/,128/*vs/base/common/decorators*/,40/*vs/base/browser/mouseEvent*/,115/*vs/base/common/range*/]), function (require, exports, objects_1, lifecycle_1, touch_1, DOM, event_1, event_2, scrollableElement_1, rangeMap_1, rowCache_1, platform_1, browser, decorators_1, mouseEvent_1, range_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function canUseTranslate3d() {
        if (browser.isFirefox) {
            return false;
        }
        if (browser.getZoomLevel() !== 0) {
            return false;
        }
        return true;
    }
    var DefaultOptions = {
        useShadows: true,
        verticalScrollMode: 1 /* Auto */,
        setRowLineHeight: true
    };
    var ListView = /** @class */ (function () {
        function ListView(container, virtualDelegate, renderers, options) {
            if (options === void 0) { options = DefaultOptions; }
            this.virtualDelegate = virtualDelegate;
            this.renderers = new Map();
            this.didRequestScrollableElementUpdate = false;
            this.splicing = false;
            this.items = [];
            this.itemId = 0;
            this.rangeMap = new rangeMap_1.RangeMap();
            for (var _i = 0, renderers_1 = renderers; _i < renderers_1.length; _i++) {
                var renderer = renderers_1[_i];
                this.renderers.set(renderer.templateId, renderer);
            }
            this.cache = new rowCache_1.RowCache(this.renderers);
            this.lastRenderTop = 0;
            this.lastRenderHeight = 0;
            this._domNode = document.createElement('div');
            this._domNode.className = 'monaco-list';
            this.rowsContainer = document.createElement('div');
            this.rowsContainer.className = 'monaco-list-rows';
            touch_1.Gesture.addTarget(this.rowsContainer);
            this.scrollableElement = new scrollableElement_1.ScrollableElement(this.rowsContainer, {
                alwaysConsumeMouseWheel: true,
                horizontal: 2 /* Hidden */,
                vertical: objects_1.getOrDefault(options, function (o) { return o.verticalScrollMode; }, DefaultOptions.verticalScrollMode),
                useShadows: objects_1.getOrDefault(options, function (o) { return o.useShadows; }, DefaultOptions.useShadows)
            });
            this._domNode.appendChild(this.scrollableElement.getDomNode());
            container.appendChild(this._domNode);
            this.disposables = [this.rangeMap, this.gesture, this.scrollableElement, this.cache];
            this.scrollableElement.onScroll(this.onScroll, this, this.disposables);
            event_2.domEvent(this.rowsContainer, touch_1.EventType.Change)(this.onTouchChange, this, this.disposables);
            // Prevent the monaco-scrollable-element from scrolling
            // https://github.com/Microsoft/vscode/issues/44181
            event_2.domEvent(this.scrollableElement.getDomNode(), 'scroll')(function (e) { return e.target.scrollTop = 0; }, null, this.disposables);
            var onDragOver = event_1.mapEvent(event_2.domEvent(this.rowsContainer, 'dragover'), function (e) { return new mouseEvent_1.DragMouseEvent(e); });
            onDragOver(this.onDragOver, this, this.disposables);
            this.setRowLineHeight = objects_1.getOrDefault(options, function (o) { return o.setRowLineHeight; }, DefaultOptions.setRowLineHeight);
            this.layout();
        }
        Object.defineProperty(ListView.prototype, "domNode", {
            get: function () {
                return this._domNode;
            },
            enumerable: true,
            configurable: true
        });
        ListView.prototype.splice = function (start, deleteCount, elements) {
            if (elements === void 0) { elements = []; }
            if (this.splicing) {
                throw new Error('Can\'t run recursive splices.');
            }
            this.splicing = true;
            try {
                return this._splice(start, deleteCount, elements);
            }
            finally {
                this.splicing = false;
            }
        };
        ListView.prototype._splice = function (start, deleteCount, elements) {
            var _this = this;
            if (elements === void 0) { elements = []; }
            var _a;
            var previousRenderRange = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight);
            var deleteRange = { start: start, end: start + deleteCount };
            var removeRange = range_1.Range.intersect(previousRenderRange, deleteRange);
            for (var i = removeRange.start; i < removeRange.end; i++) {
                this.removeItemFromDOM(i);
            }
            var previousRestRange = { start: start + deleteCount, end: this.items.length };
            var previousRenderedRestRange = range_1.Range.intersect(previousRestRange, previousRenderRange);
            var previousUnrenderedRestRanges = range_1.Range.relativeComplement(previousRestRange, previousRenderRange);
            var inserted = elements.map(function (element) { return ({
                id: String(_this.itemId++),
                element: element,
                size: _this.virtualDelegate.getHeight(element),
                templateId: _this.virtualDelegate.getTemplateId(element),
                row: null
            }); });
            var deleted;
            // TODO@joao: improve this optimization to catch even more cases
            if (start === 0 && deleteCount >= this.items.length) {
                this.rangeMap = new rangeMap_1.RangeMap();
                this.rangeMap.splice(0, 0, inserted);
                this.items = inserted;
                deleted = [];
            }
            else {
                this.rangeMap.splice(start, deleteCount, inserted);
                deleted = (_a = this.items).splice.apply(_a, [start, deleteCount].concat(inserted));
            }
            var delta = elements.length - deleteCount;
            var renderRange = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight);
            var renderedRestRange = rangeMap_1.shift(previousRenderedRestRange, delta);
            var updateRange = range_1.Range.intersect(renderRange, renderedRestRange);
            for (var i = updateRange.start; i < updateRange.end; i++) {
                this.updateItemInDOM(this.items[i], i);
            }
            var removeRanges = range_1.Range.relativeComplement(renderedRestRange, renderRange);
            for (var r = 0; r < removeRanges.length; r++) {
                var removeRange_1 = removeRanges[r];
                for (var i = removeRange_1.start; i < removeRange_1.end; i++) {
                    this.removeItemFromDOM(i);
                }
            }
            var unrenderedRestRanges = previousUnrenderedRestRanges.map(function (r) { return rangeMap_1.shift(r, delta); });
            var elementsRange = { start: start, end: start + elements.length };
            var insertRanges = [elementsRange].concat(unrenderedRestRanges).map(function (r) { return range_1.Range.intersect(renderRange, r); });
            var beforeElement = this.getNextToLastElement(insertRanges);
            for (var r = 0; r < insertRanges.length; r++) {
                var insertRange = insertRanges[r];
                for (var i = insertRange.start; i < insertRange.end; i++) {
                    this.insertItemInDOM(i, beforeElement);
                }
            }
            this.scrollHeight = this.getContentHeight();
            this.rowsContainer.style.height = this.scrollHeight + "px";
            if (!this.didRequestScrollableElementUpdate) {
                DOM.scheduleAtNextAnimationFrame(function () {
                    _this.scrollableElement.setScrollDimensions({ scrollHeight: _this.scrollHeight });
                    _this.didRequestScrollableElementUpdate = false;
                });
                this.didRequestScrollableElementUpdate = true;
            }
            return deleted.map(function (i) { return i.element; });
        };
        Object.defineProperty(ListView.prototype, "length", {
            get: function () {
                return this.items.length;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ListView.prototype, "renderHeight", {
            get: function () {
                var scrollDimensions = this.scrollableElement.getScrollDimensions();
                return scrollDimensions.height;
            },
            enumerable: true,
            configurable: true
        });
        ListView.prototype.element = function (index) {
            return this.items[index].element;
        };
        ListView.prototype.domElement = function (index) {
            var row = this.items[index].row;
            return row && row.domNode;
        };
        ListView.prototype.elementHeight = function (index) {
            return this.items[index].size;
        };
        ListView.prototype.elementTop = function (index) {
            return this.rangeMap.positionAt(index);
        };
        ListView.prototype.indexAt = function (position) {
            return this.rangeMap.indexAt(position);
        };
        ListView.prototype.indexAfter = function (position) {
            return this.rangeMap.indexAfter(position);
        };
        ListView.prototype.layout = function (height) {
            this.scrollableElement.setScrollDimensions({
                height: height || DOM.getContentHeight(this._domNode)
            });
        };
        // Render
        ListView.prototype.render = function (renderTop, renderHeight) {
            var previousRenderRange = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight);
            var renderRange = this.getRenderRange(renderTop, renderHeight);
            var rangesToInsert = range_1.Range.relativeComplement(renderRange, previousRenderRange);
            var rangesToRemove = range_1.Range.relativeComplement(previousRenderRange, renderRange);
            var beforeElement = this.getNextToLastElement(rangesToInsert);
            for (var _i = 0, rangesToInsert_1 = rangesToInsert; _i < rangesToInsert_1.length; _i++) {
                var range = rangesToInsert_1[_i];
                for (var i = range.start; i < range.end; i++) {
                    this.insertItemInDOM(i, beforeElement);
                }
            }
            for (var _a = 0, rangesToRemove_1 = rangesToRemove; _a < rangesToRemove_1.length; _a++) {
                var range = rangesToRemove_1[_a];
                for (var i = range.start; i < range.end; i++) {
                    this.removeItemFromDOM(i);
                }
            }
            if (canUseTranslate3d() && !platform_1.isWindows /* Windows: translate3d breaks subpixel-antialias (ClearType) unless a background is defined */) {
                var transform = "translate3d(0px, -" + renderTop + "px, 0px)";
                this.rowsContainer.style.transform = transform;
                this.rowsContainer.style.webkitTransform = transform;
            }
            else {
                this.rowsContainer.style.top = "-" + renderTop + "px";
            }
            this.lastRenderTop = renderTop;
            this.lastRenderHeight = renderHeight;
        };
        // DOM operations
        ListView.prototype.insertItemInDOM = function (index, beforeElement) {
            var item = this.items[index];
            if (!item.row) {
                item.row = this.cache.alloc(item.templateId);
            }
            if (!item.row.domNode.parentElement) {
                if (beforeElement) {
                    this.rowsContainer.insertBefore(item.row.domNode, beforeElement);
                }
                else {
                    this.rowsContainer.appendChild(item.row.domNode);
                }
            }
            item.row.domNode.style.height = item.size + "px";
            if (this.setRowLineHeight) {
                item.row.domNode.style.lineHeight = item.size + "px";
            }
            this.updateItemInDOM(item, index);
            var renderer = this.renderers.get(item.templateId);
            renderer.renderElement(item.element, index, item.row.templateData);
        };
        ListView.prototype.updateItemInDOM = function (item, index) {
            item.row.domNode.style.top = this.elementTop(index) + "px";
            item.row.domNode.setAttribute('data-index', "" + index);
            item.row.domNode.setAttribute('data-last-element', index === this.length - 1 ? 'true' : 'false');
            item.row.domNode.setAttribute('aria-setsize', "" + this.length);
            item.row.domNode.setAttribute('aria-posinset', "" + (index + 1));
        };
        ListView.prototype.removeItemFromDOM = function (index) {
            var item = this.items[index];
            var renderer = this.renderers.get(item.templateId);
            if (renderer.disposeElement) {
                renderer.disposeElement(item.element, index, item.row.templateData);
            }
            this.cache.release(item.row);
            item.row = null;
        };
        ListView.prototype.getContentHeight = function () {
            return this.rangeMap.size;
        };
        ListView.prototype.getScrollTop = function () {
            var scrollPosition = this.scrollableElement.getScrollPosition();
            return scrollPosition.scrollTop;
        };
        ListView.prototype.setScrollTop = function (scrollTop) {
            this.scrollableElement.setScrollPosition({ scrollTop: scrollTop });
        };
        Object.defineProperty(ListView.prototype, "scrollTop", {
            get: function () {
                return this.getScrollTop();
            },
            set: function (scrollTop) {
                this.setScrollTop(scrollTop);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ListView.prototype, "onMouseClick", {
            // Events
            get: function () {
                var _this = this;
                return event_1.filterEvent(event_1.mapEvent(event_2.domEvent(this.domNode, 'click'), function (e) { return _this.toMouseEvent(e); }), function (e) { return e.index >= 0; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ListView.prototype, "onMouseDblClick", {
            get: function () {
                var _this = this;
                return event_1.filterEvent(event_1.mapEvent(event_2.domEvent(this.domNode, 'dblclick'), function (e) { return _this.toMouseEvent(e); }), function (e) { return e.index >= 0; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ListView.prototype, "onMouseDown", {
            get: function () {
                var _this = this;
                return event_1.filterEvent(event_1.mapEvent(event_2.domEvent(this.domNode, 'mousedown'), function (e) { return _this.toMouseEvent(e); }), function (e) { return e.index >= 0; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ListView.prototype, "onContextMenu", {
            get: function () {
                var _this = this;
                return event_1.filterEvent(event_1.mapEvent(event_2.domEvent(this.domNode, 'contextmenu'), function (e) { return _this.toMouseEvent(e); }), function (e) { return e.index >= 0; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ListView.prototype, "onTouchStart", {
            get: function () {
                var _this = this;
                return event_1.filterEvent(event_1.mapEvent(event_2.domEvent(this.domNode, 'touchstart'), function (e) { return _this.toTouchEvent(e); }), function (e) { return e.index >= 0; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ListView.prototype, "onTap", {
            get: function () {
                var _this = this;
                return event_1.filterEvent(event_1.mapEvent(event_2.domEvent(this.rowsContainer, touch_1.EventType.Tap), function (e) { return _this.toGestureEvent(e); }), function (e) { return e.index >= 0; });
            },
            enumerable: true,
            configurable: true
        });
        ListView.prototype.toMouseEvent = function (browserEvent) {
            var index = this.getItemIndexFromEventTarget(browserEvent.target);
            var item = index < 0 ? undefined : this.items[index];
            var element = item && item.element;
            return { browserEvent: browserEvent, index: index, element: element };
        };
        ListView.prototype.toTouchEvent = function (browserEvent) {
            var index = this.getItemIndexFromEventTarget(browserEvent.target);
            var item = index < 0 ? undefined : this.items[index];
            var element = item && item.element;
            return { browserEvent: browserEvent, index: index, element: element };
        };
        ListView.prototype.toGestureEvent = function (browserEvent) {
            var index = this.getItemIndexFromEventTarget(browserEvent.initialTarget);
            var item = index < 0 ? undefined : this.items[index];
            var element = item && item.element;
            return { browserEvent: browserEvent, index: index, element: element };
        };
        ListView.prototype.onScroll = function (e) {
            try {
                this.render(e.scrollTop, e.height);
            }
            catch (err) {
                console.log('Got bad scroll event:', e);
                throw err;
            }
        };
        ListView.prototype.onTouchChange = function (event) {
            event.preventDefault();
            event.stopPropagation();
            this.scrollTop -= event.translationY;
        };
        ListView.prototype.onDragOver = function (event) {
            this.setupDragAndDropScrollInterval();
            this.dragAndDropMouseY = event.posy;
        };
        ListView.prototype.setupDragAndDropScrollInterval = function () {
            var _this = this;
            var viewTop = DOM.getTopLeftOffset(this._domNode).top;
            if (!this.dragAndDropScrollInterval) {
                this.dragAndDropScrollInterval = window.setInterval(function () {
                    if (_this.dragAndDropMouseY === undefined) {
                        return;
                    }
                    var diff = _this.dragAndDropMouseY - viewTop;
                    var scrollDiff = 0;
                    var upperLimit = _this.renderHeight - 35;
                    if (diff < 35) {
                        scrollDiff = Math.max(-14, 0.2 * (diff - 35));
                    }
                    else if (diff > upperLimit) {
                        scrollDiff = Math.min(14, 0.2 * (diff - upperLimit));
                    }
                    _this.scrollTop += scrollDiff;
                }, 10);
                this.cancelDragAndDropScrollTimeout();
                this.dragAndDropScrollTimeout = window.setTimeout(function () {
                    _this.cancelDragAndDropScrollInterval();
                    _this.dragAndDropScrollTimeout = null;
                }, 1000);
            }
        };
        ListView.prototype.cancelDragAndDropScrollInterval = function () {
            if (this.dragAndDropScrollInterval) {
                window.clearInterval(this.dragAndDropScrollInterval);
                this.dragAndDropScrollInterval = null;
            }
            this.cancelDragAndDropScrollTimeout();
        };
        ListView.prototype.cancelDragAndDropScrollTimeout = function () {
            if (this.dragAndDropScrollTimeout) {
                window.clearTimeout(this.dragAndDropScrollTimeout);
                this.dragAndDropScrollTimeout = null;
            }
        };
        // Util
        ListView.prototype.getItemIndexFromEventTarget = function (target) {
            while (target instanceof HTMLElement && target !== this.rowsContainer) {
                var element = target;
                var rawIndex = element.getAttribute('data-index');
                if (rawIndex) {
                    var index = Number(rawIndex);
                    if (!isNaN(index)) {
                        return index;
                    }
                }
                target = element.parentElement;
            }
            return -1;
        };
        ListView.prototype.getRenderRange = function (renderTop, renderHeight) {
            return {
                start: this.rangeMap.indexAt(renderTop),
                end: this.rangeMap.indexAfter(renderTop + renderHeight - 1)
            };
        };
        ListView.prototype.getNextToLastElement = function (ranges) {
            var lastRange = ranges[ranges.length - 1];
            if (!lastRange) {
                return null;
            }
            var nextToLastItem = this.items[lastRange.end];
            if (!nextToLastItem) {
                return null;
            }
            if (!nextToLastItem.row) {
                return null;
            }
            return nextToLastItem.row.domNode;
        };
        // Dispose
        ListView.prototype.dispose = function () {
            if (this.items) {
                for (var _i = 0, _a = this.items; _i < _a.length; _i++) {
                    var item = _a[_i];
                    if (item.row) {
                        var renderer = this.renderers.get(item.row.templateId);
                        renderer.disposeTemplate(item.row.templateData);
                        item.row = null;
                    }
                }
                this.items = null;
            }
            if (this._domNode && this._domNode.parentElement) {
                this._domNode.parentNode.removeChild(this._domNode);
                this._domNode = null;
            }
            this.disposables = lifecycle_1.dispose(this.disposables);
        };
        __decorate([
            decorators_1.memoize
        ], ListView.prototype, "onMouseClick", null);
        __decorate([
            decorators_1.memoize
        ], ListView.prototype, "onMouseDblClick", null);
        __decorate([
            decorators_1.memoize
        ], ListView.prototype, "onMouseDown", null);
        __decorate([
            decorators_1.memoize
        ], ListView.prototype, "onContextMenu", null);
        __decorate([
            decorators_1.memoize
        ], ListView.prototype, "onTouchStart", null);
        __decorate([
            decorators_1.memoize
        ], ListView.prototype, "onTap", null);
        return ListView;
    }());
    exports.ListView = ListView;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[235/*vs/base/parts/tree/browser/treeView*/], __M([0/*require*/,1/*exports*/,17/*vs/base/common/platform*/,29/*vs/base/browser/browser*/,2/*vs/base/common/lifecycle*/,7/*vs/base/browser/dom*/,130/*vs/base/common/diff/diff*/,75/*vs/base/browser/touch*/,8/*vs/base/common/strings*/,40/*vs/base/browser/mouseEvent*/,52/*vs/base/browser/keyboardEvent*/,443/*vs/base/parts/tree/browser/treeDnd*/,87/*vs/base/common/iterator*/,55/*vs/base/browser/ui/scrollbar/scrollableElement*/,445/*vs/base/parts/tree/browser/treeViewModel*/,440/*vs/base/parts/tree/browser/tree*/,6/*vs/base/common/event*/,423/*vs/base/browser/dnd*/,88/*vs/base/parts/tree/browser/treeDefaults*/,16/*vs/base/common/async*/]), function (require, exports, Platform, Browser, Lifecycle, DOM, Diff, Touch, strings, Mouse, Keyboard, dnd, iterator_1, scrollableElement_1, treeViewModel_1, _, event_1, dnd_1, treeDefaults_1, async_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function removeFromParent(element) {
        try {
            element.parentElement.removeChild(element);
        }
        catch (e) {
            // this will throw if this happens due to a blur event, nasty business
        }
    }
    var RowCache = /** @class */ (function () {
        function RowCache(context) {
            this.context = context;
            this._cache = { '': [] };
        }
        RowCache.prototype.alloc = function (templateId) {
            var result = this.cache(templateId).pop();
            if (!result) {
                var content = document.createElement('div');
                content.className = 'content';
                var row = document.createElement('div');
                row.appendChild(content);
                var templateData = null;
                try {
                    templateData = this.context.renderer.renderTemplate(this.context.tree, templateId, content);
                }
                catch (err) {
                    console.error('Tree usage error: exception while rendering template');
                    console.error(err);
                }
                result = {
                    element: row,
                    templateId: templateId,
                    templateData: templateData
                };
            }
            return result;
        };
        RowCache.prototype.release = function (templateId, row) {
            removeFromParent(row.element);
            this.cache(templateId).push(row);
        };
        RowCache.prototype.cache = function (templateId) {
            return this._cache[templateId] || (this._cache[templateId] = []);
        };
        RowCache.prototype.garbageCollect = function () {
            var _this = this;
            if (this._cache) {
                Object.keys(this._cache).forEach(function (templateId) {
                    _this._cache[templateId].forEach(function (cachedRow) {
                        _this.context.renderer.disposeTemplate(_this.context.tree, templateId, cachedRow.templateData);
                        cachedRow.element = null;
                        cachedRow.templateData = null;
                    });
                    delete _this._cache[templateId];
                });
            }
        };
        RowCache.prototype.dispose = function () {
            this.garbageCollect();
            this._cache = null;
            this.context = null;
        };
        return RowCache;
    }());
    exports.RowCache = RowCache;
    var ViewItem = /** @class */ (function () {
        function ViewItem(context, model) {
            var _this = this;
            this.width = 0;
            this.context = context;
            this.model = model;
            this.id = this.model.id;
            this.row = null;
            this.top = 0;
            this.height = model.getHeight();
            this._styles = {};
            model.getAllTraits().forEach(function (t) { return _this._styles[t] = true; });
            if (model.isExpanded()) {
                this.addClass('expanded');
            }
        }
        Object.defineProperty(ViewItem.prototype, "expanded", {
            set: function (value) {
                value ? this.addClass('expanded') : this.removeClass('expanded');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ViewItem.prototype, "loading", {
            set: function (value) {
                value ? this.addClass('loading') : this.removeClass('loading');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ViewItem.prototype, "draggable", {
            get: function () {
                return this._draggable;
            },
            set: function (value) {
                this._draggable = value;
                this.render(true);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ViewItem.prototype, "dropTarget", {
            set: function (value) {
                value ? this.addClass('drop-target') : this.removeClass('drop-target');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ViewItem.prototype, "element", {
            get: function () {
                return this.row && this.row.element;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ViewItem.prototype, "templateId", {
            get: function () {
                return this._templateId || (this._templateId = (this.context.renderer.getTemplateId && this.context.renderer.getTemplateId(this.context.tree, this.model.getElement())));
            },
            enumerable: true,
            configurable: true
        });
        ViewItem.prototype.addClass = function (name) {
            this._styles[name] = true;
            this.render(true);
        };
        ViewItem.prototype.removeClass = function (name) {
            delete this._styles[name]; // is this slow?
            this.render(true);
        };
        ViewItem.prototype.render = function (skipUserRender) {
            var _this = this;
            if (skipUserRender === void 0) { skipUserRender = false; }
            if (!this.model || !this.element) {
                return;
            }
            var classes = ['monaco-tree-row'];
            classes.push.apply(classes, Object.keys(this._styles));
            if (this.model.hasChildren()) {
                classes.push('has-children');
            }
            this.element.className = classes.join(' ');
            this.element.draggable = this.draggable;
            this.element.style.height = this.height + 'px';
            // ARIA
            this.element.setAttribute('role', 'treeitem');
            var accessibility = this.context.accessibilityProvider;
            var ariaLabel = accessibility.getAriaLabel(this.context.tree, this.model.getElement());
            if (ariaLabel) {
                this.element.setAttribute('aria-label', ariaLabel);
            }
            if (accessibility.getPosInSet && accessibility.getSetSize) {
                this.element.setAttribute('aria-setsize', accessibility.getSetSize());
                this.element.setAttribute('aria-posinset', accessibility.getPosInSet(this.context.tree, this.model.getElement()));
            }
            if (this.model.hasTrait('focused')) {
                var base64Id = strings.safeBtoa(this.model.id);
                this.element.setAttribute('aria-selected', 'true');
                this.element.setAttribute('id', base64Id);
            }
            else {
                this.element.setAttribute('aria-selected', 'false');
                this.element.removeAttribute('id');
            }
            if (this.model.hasChildren()) {
                this.element.setAttribute('aria-expanded', String(!!this._styles['expanded']));
            }
            else {
                this.element.removeAttribute('aria-expanded');
            }
            this.element.setAttribute('aria-level', String(this.model.getDepth()));
            if (this.context.options.paddingOnRow) {
                this.element.style.paddingLeft = this.context.options.twistiePixels + ((this.model.getDepth() - 1) * this.context.options.indentPixels) + 'px';
            }
            else {
                this.element.style.paddingLeft = ((this.model.getDepth() - 1) * this.context.options.indentPixels) + 'px';
                this.row.element.firstElementChild.style.paddingLeft = this.context.options.twistiePixels + 'px';
            }
            var uri = this.context.dnd.getDragURI(this.context.tree, this.model.getElement());
            if (uri !== this.uri) {
                if (this.unbindDragStart) {
                    this.unbindDragStart.dispose();
                    this.unbindDragStart = null;
                }
                if (uri) {
                    this.uri = uri;
                    this.draggable = true;
                    this.unbindDragStart = DOM.addDisposableListener(this.element, 'dragstart', function (e) {
                        _this.onDragStart(e);
                    });
                }
                else {
                    this.uri = null;
                }
            }
            if (!skipUserRender && this.element) {
                var style = window.getComputedStyle(this.element);
                var paddingLeft = parseFloat(style.paddingLeft);
                if (this.context.horizontalScrolling) {
                    this.element.style.width = 'fit-content';
                }
                try {
                    this.context.renderer.renderElement(this.context.tree, this.model.getElement(), this.templateId, this.row.templateData);
                }
                catch (err) {
                    console.error('Tree usage error: exception while rendering element');
                    console.error(err);
                }
                if (this.context.horizontalScrolling) {
                    this.width = DOM.getContentWidth(this.element) + paddingLeft;
                    this.element.style.width = '';
                }
            }
        };
        ViewItem.prototype.insertInDOM = function (container, afterElement) {
            if (!this.row) {
                this.row = this.context.cache.alloc(this.templateId);
                // used in reverse lookup from HTMLElement to Item
                this.element[TreeView.BINDING] = this;
            }
            if (this.element.parentElement) {
                return;
            }
            if (afterElement === null) {
                container.appendChild(this.element);
            }
            else {
                try {
                    container.insertBefore(this.element, afterElement);
                }
                catch (e) {
                    console.warn('Failed to locate previous tree element');
                    container.appendChild(this.element);
                }
            }
            this.render();
        };
        ViewItem.prototype.removeFromDOM = function () {
            if (!this.row) {
                return;
            }
            if (this.unbindDragStart) {
                this.unbindDragStart.dispose();
                this.unbindDragStart = null;
            }
            this.uri = null;
            this.element[TreeView.BINDING] = null;
            this.context.cache.release(this.templateId, this.row);
            this.row = null;
        };
        ViewItem.prototype.dispose = function () {
            this.row = null;
            this.model = null;
        };
        return ViewItem;
    }());
    exports.ViewItem = ViewItem;
    var RootViewItem = /** @class */ (function (_super) {
        __extends(RootViewItem, _super);
        function RootViewItem(context, model, wrapper) {
            var _this = _super.call(this, context, model) || this;
            _this.row = {
                element: wrapper,
                templateData: null,
                templateId: null
            };
            return _this;
        }
        RootViewItem.prototype.render = function () {
            if (!this.model || !this.element) {
                return;
            }
            var classes = ['monaco-tree-wrapper'];
            classes.push.apply(classes, Object.keys(this._styles));
            if (this.model.hasChildren()) {
                classes.push('has-children');
            }
            this.element.className = classes.join(' ');
        };
        RootViewItem.prototype.insertInDOM = function (container, afterElement) {
            // noop
        };
        RootViewItem.prototype.removeFromDOM = function () {
            // noop
        };
        return RootViewItem;
    }(ViewItem));
    function reactionEquals(one, other) {
        if (!one && !other) {
            return true;
        }
        else if (!one || !other) {
            return false;
        }
        else if (one.accept !== other.accept) {
            return false;
        }
        else if (one.bubble !== other.bubble) {
            return false;
        }
        else if (one.effect !== other.effect) {
            return false;
        }
        else {
            return true;
        }
    }
    var TreeView = /** @class */ (function (_super) {
        __extends(TreeView, _super);
        function TreeView(context, container) {
            var _this = _super.call(this) || this;
            _this.lastClickTimeStamp = 0;
            _this.contentWidthUpdateDelayer = new async_1.Delayer(50);
            _this.isRefreshing = false;
            _this.refreshingPreviousChildrenIds = {};
            _this.currentDropDisposable = Lifecycle.Disposable.None;
            _this._onDOMFocus = new event_1.Emitter();
            _this._onDOMBlur = new event_1.Emitter();
            _this._onDidScroll = new event_1.Emitter();
            TreeView.counter++;
            _this.instance = TreeView.counter;
            var horizontalScrollMode = typeof context.options.horizontalScrollMode === 'undefined' ? 2 /* Hidden */ : context.options.horizontalScrollMode;
            _this.horizontalScrolling = horizontalScrollMode !== 2 /* Hidden */;
            _this.context = {
                dataSource: context.dataSource,
                renderer: context.renderer,
                controller: context.controller,
                dnd: context.dnd,
                filter: context.filter,
                sorter: context.sorter,
                tree: context.tree,
                accessibilityProvider: context.accessibilityProvider,
                options: context.options,
                cache: new RowCache(context),
                horizontalScrolling: _this.horizontalScrolling
            };
            _this.modelListeners = [];
            _this.viewListeners = [];
            _this.model = null;
            _this.items = {};
            _this.domNode = document.createElement('div');
            _this.domNode.className = "monaco-tree no-focused-item monaco-tree-instance-" + _this.instance;
            // to allow direct tabbing into the tree instead of first focusing the tree
            _this.domNode.tabIndex = context.options.preventRootFocus ? -1 : 0;
            _this.styleElement = DOM.createStyleSheet(_this.domNode);
            _this.treeStyler = context.styler;
            if (!_this.treeStyler) {
                _this.treeStyler = new treeDefaults_1.DefaultTreestyler(_this.styleElement, "monaco-tree-instance-" + _this.instance);
            }
            // ARIA
            _this.domNode.setAttribute('role', 'tree');
            if (_this.context.options.ariaLabel) {
                _this.domNode.setAttribute('aria-label', _this.context.options.ariaLabel);
            }
            if (_this.context.options.alwaysFocused) {
                DOM.addClass(_this.domNode, 'focused');
            }
            if (!_this.context.options.paddingOnRow) {
                DOM.addClass(_this.domNode, 'no-row-padding');
            }
            _this.wrapper = document.createElement('div');
            _this.wrapper.className = 'monaco-tree-wrapper';
            _this.scrollableElement = new scrollableElement_1.ScrollableElement(_this.wrapper, {
                alwaysConsumeMouseWheel: true,
                horizontal: horizontalScrollMode,
                vertical: (typeof context.options.verticalScrollMode !== 'undefined' ? context.options.verticalScrollMode : 1 /* Auto */),
                useShadows: context.options.useShadows
            });
            _this.scrollableElement.onScroll(function (e) {
                _this.render(e.scrollTop, e.height, e.scrollLeft, e.width, e.scrollWidth);
                _this._onDidScroll.fire();
            });
            if (Browser.isIE) {
                _this.wrapper.style.msTouchAction = 'none';
                _this.wrapper.style.msContentZooming = 'none';
            }
            else {
                Touch.Gesture.addTarget(_this.wrapper);
            }
            _this.rowsContainer = document.createElement('div');
            _this.rowsContainer.className = 'monaco-tree-rows';
            if (context.options.showTwistie) {
                _this.rowsContainer.className += ' show-twisties';
            }
            var focusTracker = DOM.trackFocus(_this.domNode);
            _this.viewListeners.push(focusTracker.onDidFocus(function () { return _this.onFocus(); }));
            _this.viewListeners.push(focusTracker.onDidBlur(function () { return _this.onBlur(); }));
            _this.viewListeners.push(focusTracker);
            _this.viewListeners.push(DOM.addDisposableListener(_this.domNode, 'keydown', function (e) { return _this.onKeyDown(e); }));
            _this.viewListeners.push(DOM.addDisposableListener(_this.domNode, 'keyup', function (e) { return _this.onKeyUp(e); }));
            _this.viewListeners.push(DOM.addDisposableListener(_this.domNode, 'mousedown', function (e) { return _this.onMouseDown(e); }));
            _this.viewListeners.push(DOM.addDisposableListener(_this.domNode, 'mouseup', function (e) { return _this.onMouseUp(e); }));
            _this.viewListeners.push(DOM.addDisposableListener(_this.wrapper, 'auxclick', function (e) {
                if (e && e.button === 1) {
                    _this.onMouseMiddleClick(e);
                }
            }));
            _this.viewListeners.push(DOM.addDisposableListener(_this.wrapper, 'click', function (e) { return _this.onClick(e); }));
            _this.viewListeners.push(DOM.addDisposableListener(_this.domNode, 'contextmenu', function (e) { return _this.onContextMenu(e); }));
            _this.viewListeners.push(DOM.addDisposableListener(_this.wrapper, Touch.EventType.Tap, function (e) { return _this.onTap(e); }));
            _this.viewListeners.push(DOM.addDisposableListener(_this.wrapper, Touch.EventType.Change, function (e) { return _this.onTouchChange(e); }));
            if (Browser.isIE) {
                _this.viewListeners.push(DOM.addDisposableListener(_this.wrapper, 'MSPointerDown', function (e) { return _this.onMsPointerDown(e); }));
                _this.viewListeners.push(DOM.addDisposableListener(_this.wrapper, 'MSGestureTap', function (e) { return _this.onMsGestureTap(e); }));
                // these events come too fast, we throttle them
                _this.viewListeners.push(DOM.addDisposableThrottledListener(_this.wrapper, 'MSGestureChange', function (e) { return _this.onThrottledMsGestureChange(e); }, function (lastEvent, event) {
                    event.stopPropagation();
                    event.preventDefault();
                    var result = { translationY: event.translationY, translationX: event.translationX };
                    if (lastEvent) {
                        result.translationY += lastEvent.translationY;
                        result.translationX += lastEvent.translationX;
                    }
                    return result;
                }));
            }
            _this.viewListeners.push(DOM.addDisposableListener(window, 'dragover', function (e) { return _this.onDragOver(e); }));
            _this.viewListeners.push(DOM.addDisposableListener(_this.wrapper, 'drop', function (e) { return _this.onDrop(e); }));
            _this.viewListeners.push(DOM.addDisposableListener(window, 'dragend', function (e) { return _this.onDragEnd(e); }));
            _this.viewListeners.push(DOM.addDisposableListener(window, 'dragleave', function (e) { return _this.onDragOver(e); }));
            _this.wrapper.appendChild(_this.rowsContainer);
            _this.domNode.appendChild(_this.scrollableElement.getDomNode());
            container.appendChild(_this.domNode);
            _this.lastRenderTop = 0;
            _this.lastRenderHeight = 0;
            _this.didJustPressContextMenuKey = false;
            _this.currentDropTarget = null;
            _this.currentDropTargets = [];
            _this.shouldInvalidateDropReaction = false;
            _this.dragAndDropScrollInterval = null;
            _this.dragAndDropScrollTimeout = null;
            _this.onHiddenScrollTop = null;
            _this.onRowsChanged();
            _this.layout();
            _this.setupMSGesture();
            _this.applyStyles(context.options);
            return _this;
        }
        Object.defineProperty(TreeView.prototype, "onDOMFocus", {
            get: function () { return this._onDOMFocus.event; },
            enumerable: true,
            configurable: true
        });
        TreeView.prototype.applyStyles = function (styles) {
            this.treeStyler.style(styles);
        };
        TreeView.prototype.createViewItem = function (item) {
            return new ViewItem(this.context, item);
        };
        TreeView.prototype.getHTMLElement = function () {
            return this.domNode;
        };
        TreeView.prototype.focus = function () {
            this.domNode.focus();
        };
        TreeView.prototype.isFocused = function () {
            return document.activeElement === this.domNode;
        };
        TreeView.prototype.blur = function () {
            this.domNode.blur();
        };
        TreeView.prototype.setupMSGesture = function () {
            var _this = this;
            if (window.MSGesture) {
                this.msGesture = new MSGesture();
                setTimeout(function () { return _this.msGesture.target = _this.wrapper; }, 100); // TODO@joh, TODO@IETeam
            }
        };
        TreeView.prototype.isTreeVisible = function () {
            return this.onHiddenScrollTop === null;
        };
        TreeView.prototype.layout = function (height, width) {
            if (!this.isTreeVisible()) {
                return;
            }
            this.viewHeight = height || DOM.getContentHeight(this.wrapper); // render
            this.scrollHeight = this.getContentHeight();
            if (this.horizontalScrolling) {
                this.viewWidth = width || DOM.getContentWidth(this.wrapper);
            }
        };
        TreeView.prototype.render = function (scrollTop, viewHeight, scrollLeft, viewWidth, scrollWidth) {
            var i;
            var stop;
            var renderTop = scrollTop;
            var renderBottom = scrollTop + viewHeight;
            var thisRenderBottom = this.lastRenderTop + this.lastRenderHeight;
            // when view scrolls down, start rendering from the renderBottom
            for (i = this.indexAfter(renderBottom) - 1, stop = this.indexAt(Math.max(thisRenderBottom, renderTop)); i >= stop; i--) {
                this.insertItemInDOM(this.itemAtIndex(i));
            }
            // when view scrolls up, start rendering from either this.renderTop or renderBottom
            for (i = Math.min(this.indexAt(this.lastRenderTop), this.indexAfter(renderBottom)) - 1, stop = this.indexAt(renderTop); i >= stop; i--) {
                this.insertItemInDOM(this.itemAtIndex(i));
            }
            // when view scrolls down, start unrendering from renderTop
            for (i = this.indexAt(this.lastRenderTop), stop = Math.min(this.indexAt(renderTop), this.indexAfter(thisRenderBottom)); i < stop; i++) {
                this.removeItemFromDOM(this.itemAtIndex(i));
            }
            // when view scrolls up, start unrendering from either renderBottom this.renderTop
            for (i = Math.max(this.indexAfter(renderBottom), this.indexAt(this.lastRenderTop)), stop = this.indexAfter(thisRenderBottom); i < stop; i++) {
                this.removeItemFromDOM(this.itemAtIndex(i));
            }
            var topItem = this.itemAtIndex(this.indexAt(renderTop));
            if (topItem) {
                this.rowsContainer.style.top = (topItem.top - renderTop) + 'px';
            }
            if (this.horizontalScrolling) {
                this.rowsContainer.style.left = -scrollLeft + 'px';
                this.rowsContainer.style.width = Math.max(scrollWidth, viewWidth) + "px";
            }
            this.lastRenderTop = renderTop;
            this.lastRenderHeight = renderBottom - renderTop;
        };
        TreeView.prototype.setModel = function (newModel) {
            this.releaseModel();
            this.model = newModel;
            this.model.onRefresh(this.onRefreshing, this, this.modelListeners);
            this.model.onDidRefresh(this.onRefreshed, this, this.modelListeners);
            this.model.onSetInput(this.onClearingInput, this, this.modelListeners);
            this.model.onDidSetInput(this.onSetInput, this, this.modelListeners);
            this.model.onDidFocus(this.onModelFocusChange, this, this.modelListeners);
            this.model.onRefreshItemChildren(this.onItemChildrenRefreshing, this, this.modelListeners);
            this.model.onDidRefreshItemChildren(this.onItemChildrenRefreshed, this, this.modelListeners);
            this.model.onDidRefreshItem(this.onItemRefresh, this, this.modelListeners);
            this.model.onExpandItem(this.onItemExpanding, this, this.modelListeners);
            this.model.onDidExpandItem(this.onItemExpanded, this, this.modelListeners);
            this.model.onCollapseItem(this.onItemCollapsing, this, this.modelListeners);
            this.model.onDidRevealItem(this.onItemReveal, this, this.modelListeners);
            this.model.onDidAddTraitItem(this.onItemAddTrait, this, this.modelListeners);
            this.model.onDidRemoveTraitItem(this.onItemRemoveTrait, this, this.modelListeners);
        };
        TreeView.prototype.onRefreshing = function () {
            this.isRefreshing = true;
        };
        TreeView.prototype.onRefreshed = function () {
            this.isRefreshing = false;
            this.onRowsChanged();
        };
        TreeView.prototype.onRowsChanged = function (scrollTop) {
            if (scrollTop === void 0) { scrollTop = this.scrollTop; }
            if (this.isRefreshing) {
                return;
            }
            this.scrollTop = scrollTop;
            this.updateScrollWidth();
        };
        TreeView.prototype.updateScrollWidth = function () {
            var _this = this;
            if (!this.horizontalScrolling) {
                return;
            }
            this.contentWidthUpdateDelayer.trigger(function () {
                var keys = Object.keys(_this.items);
                var scrollWidth = 0;
                for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
                    var key = keys_1[_i];
                    scrollWidth = Math.max(scrollWidth, _this.items[key].width);
                }
                _this.scrollWidth = scrollWidth + 10 /* scrollbar */;
            });
        };
        TreeView.prototype.focusNextPage = function (eventPayload) {
            var _this = this;
            var lastPageIndex = this.indexAt(this.scrollTop + this.viewHeight);
            lastPageIndex = lastPageIndex === 0 ? 0 : lastPageIndex - 1;
            var lastPageElement = this.itemAtIndex(lastPageIndex).model.getElement();
            var currentlyFocusedElement = this.model.getFocus();
            if (currentlyFocusedElement !== lastPageElement) {
                this.model.setFocus(lastPageElement, eventPayload);
            }
            else {
                var previousScrollTop = this.scrollTop;
                this.scrollTop += this.viewHeight;
                if (this.scrollTop !== previousScrollTop) {
                    // Let the scroll event listener run
                    setTimeout(function () {
                        _this.focusNextPage(eventPayload);
                    }, 0);
                }
            }
        };
        TreeView.prototype.focusPreviousPage = function (eventPayload) {
            var _this = this;
            var firstPageIndex;
            if (this.scrollTop === 0) {
                firstPageIndex = this.indexAt(this.scrollTop);
            }
            else {
                firstPageIndex = this.indexAfter(this.scrollTop - 1);
            }
            var firstPageElement = this.itemAtIndex(firstPageIndex).model.getElement();
            var currentlyFocusedElement = this.model.getFocus();
            if (currentlyFocusedElement !== firstPageElement) {
                this.model.setFocus(firstPageElement, eventPayload);
            }
            else {
                var previousScrollTop = this.scrollTop;
                this.scrollTop -= this.viewHeight;
                if (this.scrollTop !== previousScrollTop) {
                    // Let the scroll event listener run
                    setTimeout(function () {
                        _this.focusPreviousPage(eventPayload);
                    }, 0);
                }
            }
        };
        Object.defineProperty(TreeView.prototype, "viewHeight", {
            get: function () {
                var scrollDimensions = this.scrollableElement.getScrollDimensions();
                return scrollDimensions.height;
            },
            set: function (height) {
                this.scrollableElement.setScrollDimensions({ height: height });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TreeView.prototype, "scrollHeight", {
            set: function (scrollHeight) {
                this.scrollableElement.setScrollDimensions({ scrollHeight: scrollHeight });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TreeView.prototype, "viewWidth", {
            get: function () {
                var scrollDimensions = this.scrollableElement.getScrollDimensions();
                return scrollDimensions.width;
            },
            set: function (viewWidth) {
                this.scrollableElement.setScrollDimensions({ width: viewWidth });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TreeView.prototype, "scrollWidth", {
            set: function (scrollWidth) {
                this.scrollableElement.setScrollDimensions({ scrollWidth: scrollWidth });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TreeView.prototype, "scrollTop", {
            get: function () {
                var scrollPosition = this.scrollableElement.getScrollPosition();
                return scrollPosition.scrollTop;
            },
            set: function (scrollTop) {
                this.scrollableElement.setScrollDimensions({
                    scrollHeight: this.getContentHeight()
                });
                this.scrollableElement.setScrollPosition({
                    scrollTop: scrollTop
                });
            },
            enumerable: true,
            configurable: true
        });
        // Events
        TreeView.prototype.onClearingInput = function (e) {
            var item = e.item;
            if (item) {
                this.onRemoveItems(new iterator_1.MappedIterator(item.getNavigator(), function (item) { return item && item.id; }));
                this.onRowsChanged();
            }
        };
        TreeView.prototype.onSetInput = function (e) {
            this.context.cache.garbageCollect();
            this.inputItem = new RootViewItem(this.context, e.item, this.wrapper);
        };
        TreeView.prototype.onItemChildrenRefreshing = function (e) {
            var item = e.item;
            var viewItem = this.items[item.id];
            if (viewItem && this.context.options.showLoading) {
                viewItem.loadingTimer = setTimeout(function () {
                    viewItem.loadingTimer = 0;
                    viewItem.loading = true;
                }, TreeView.LOADING_DECORATION_DELAY);
            }
            if (!e.isNested) {
                var childrenIds = [];
                var navigator = item.getNavigator();
                var childItem;
                while (childItem = navigator.next()) {
                    childrenIds.push(childItem.id);
                }
                this.refreshingPreviousChildrenIds[item.id] = childrenIds;
            }
        };
        TreeView.prototype.onItemChildrenRefreshed = function (e) {
            var _this = this;
            var item = e.item;
            var viewItem = this.items[item.id];
            if (viewItem) {
                if (viewItem.loadingTimer) {
                    clearTimeout(viewItem.loadingTimer);
                    viewItem.loadingTimer = 0;
                }
                viewItem.loading = false;
            }
            if (!e.isNested) {
                var previousChildrenIds = this.refreshingPreviousChildrenIds[item.id];
                var afterModelItems = [];
                var navigator = item.getNavigator();
                var childItem;
                while (childItem = navigator.next()) {
                    afterModelItems.push(childItem);
                }
                var skipDiff = Math.abs(previousChildrenIds.length - afterModelItems.length) > 1000;
                var diff = void 0;
                var doToInsertItemsAlreadyExist = void 0;
                if (!skipDiff) {
                    var lcs = new Diff.LcsDiff({
                        getLength: function () { return previousChildrenIds.length; },
                        getElementAtIndex: function (i) { return previousChildrenIds[i]; }
                    }, {
                        getLength: function () { return afterModelItems.length; },
                        getElementAtIndex: function (i) { return afterModelItems[i].id; }
                    }, null);
                    diff = lcs.ComputeDiff(false);
                    // this means that the result of the diff algorithm would result
                    // in inserting items that were already registered. this can only
                    // happen if the data provider returns bad ids OR if the sorting
                    // of the elements has changed
                    doToInsertItemsAlreadyExist = diff.some(function (d) {
                        if (d.modifiedLength > 0) {
                            for (var i = d.modifiedStart, len = d.modifiedStart + d.modifiedLength; i < len; i++) {
                                if (_this.items.hasOwnProperty(afterModelItems[i].id)) {
                                    return true;
                                }
                            }
                        }
                        return false;
                    });
                }
                // 50 is an optimization number, at some point we're better off
                // just replacing everything
                if (!skipDiff && !doToInsertItemsAlreadyExist && diff.length < 50) {
                    for (var i = 0, len = diff.length; i < len; i++) {
                        var diffChange = diff[i];
                        if (diffChange.originalLength > 0) {
                            this.onRemoveItems(new iterator_1.ArrayIterator(previousChildrenIds, diffChange.originalStart, diffChange.originalStart + diffChange.originalLength));
                        }
                        if (diffChange.modifiedLength > 0) {
                            var beforeItem = afterModelItems[diffChange.modifiedStart - 1] || item;
                            beforeItem = beforeItem.getDepth() > 0 ? beforeItem : null;
                            this.onInsertItems(new iterator_1.ArrayIterator(afterModelItems, diffChange.modifiedStart, diffChange.modifiedStart + diffChange.modifiedLength), beforeItem ? beforeItem.id : null);
                        }
                    }
                }
                else if (skipDiff || diff.length) {
                    this.onRemoveItems(new iterator_1.ArrayIterator(previousChildrenIds));
                    this.onInsertItems(new iterator_1.ArrayIterator(afterModelItems), item.getDepth() > 0 ? item.id : null);
                }
                if (skipDiff || diff.length) {
                    this.onRowsChanged();
                }
            }
        };
        TreeView.prototype.onItemRefresh = function (item) {
            this.onItemsRefresh([item]);
        };
        TreeView.prototype.onItemsRefresh = function (items) {
            var _this = this;
            this.onRefreshItemSet(items.filter(function (item) { return _this.items.hasOwnProperty(item.id); }));
            this.onRowsChanged();
        };
        TreeView.prototype.onItemExpanding = function (e) {
            var viewItem = this.items[e.item.id];
            if (viewItem) {
                viewItem.expanded = true;
            }
        };
        TreeView.prototype.onItemExpanded = function (e) {
            var item = e.item;
            var viewItem = this.items[item.id];
            if (viewItem) {
                viewItem.expanded = true;
                var height = this.onInsertItems(item.getNavigator(), item.id);
                var scrollTop = this.scrollTop;
                if (viewItem.top + viewItem.height <= this.scrollTop) {
                    scrollTop += height;
                }
                this.onRowsChanged(scrollTop);
            }
        };
        TreeView.prototype.onItemCollapsing = function (e) {
            var item = e.item;
            var viewItem = this.items[item.id];
            if (viewItem) {
                viewItem.expanded = false;
                this.onRemoveItems(new iterator_1.MappedIterator(item.getNavigator(), function (item) { return item && item.id; }));
                this.onRowsChanged();
            }
        };
        TreeView.prototype.onItemReveal = function (e) {
            var item = e.item;
            var relativeTop = e.relativeTop;
            var viewItem = this.items[item.id];
            if (viewItem) {
                if (relativeTop !== null) {
                    relativeTop = relativeTop < 0 ? 0 : relativeTop;
                    relativeTop = relativeTop > 1 ? 1 : relativeTop;
                    // y = mx + b
                    var m = viewItem.height - this.viewHeight;
                    this.scrollTop = m * relativeTop + viewItem.top;
                }
                else {
                    var viewItemBottom = viewItem.top + viewItem.height;
                    var wrapperBottom = this.scrollTop + this.viewHeight;
                    if (viewItem.top < this.scrollTop) {
                        this.scrollTop = viewItem.top;
                    }
                    else if (viewItemBottom >= wrapperBottom) {
                        this.scrollTop = viewItemBottom - this.viewHeight;
                    }
                }
            }
        };
        TreeView.prototype.onItemAddTrait = function (e) {
            var item = e.item;
            var trait = e.trait;
            var viewItem = this.items[item.id];
            if (viewItem) {
                viewItem.addClass(trait);
            }
            if (trait === 'highlighted') {
                DOM.addClass(this.domNode, trait);
                // Ugly Firefox fix: input fields can't be selected if parent nodes are draggable
                if (viewItem) {
                    this.highlightedItemWasDraggable = !!viewItem.draggable;
                    if (viewItem.draggable) {
                        viewItem.draggable = false;
                    }
                }
            }
        };
        TreeView.prototype.onItemRemoveTrait = function (e) {
            var item = e.item;
            var trait = e.trait;
            var viewItem = this.items[item.id];
            if (viewItem) {
                viewItem.removeClass(trait);
            }
            if (trait === 'highlighted') {
                DOM.removeClass(this.domNode, trait);
                // Ugly Firefox fix: input fields can't be selected if parent nodes are draggable
                if (this.highlightedItemWasDraggable) {
                    viewItem.draggable = true;
                }
                this.highlightedItemWasDraggable = false;
            }
        };
        TreeView.prototype.onModelFocusChange = function () {
            var focus = this.model && this.model.getFocus();
            DOM.toggleClass(this.domNode, 'no-focused-item', !focus);
            // ARIA
            if (focus) {
                this.domNode.setAttribute('aria-activedescendant', strings.safeBtoa(this.context.dataSource.getId(this.context.tree, focus)));
            }
            else {
                this.domNode.removeAttribute('aria-activedescendant');
            }
        };
        // HeightMap "events"
        TreeView.prototype.onInsertItem = function (item) {
            var _this = this;
            item.onDragStart = function (e) { _this.onDragStart(item, e); };
            item.needsRender = true;
            this.refreshViewItem(item);
            this.items[item.id] = item;
        };
        TreeView.prototype.onRefreshItem = function (item, needsRender) {
            if (needsRender === void 0) { needsRender = false; }
            item.needsRender = item.needsRender || needsRender;
            this.refreshViewItem(item);
        };
        TreeView.prototype.onRemoveItem = function (item) {
            this.removeItemFromDOM(item);
            item.dispose();
            delete this.items[item.id];
        };
        // ViewItem refresh
        TreeView.prototype.refreshViewItem = function (item) {
            item.render();
            if (this.shouldBeRendered(item)) {
                this.insertItemInDOM(item);
            }
            else {
                this.removeItemFromDOM(item);
            }
        };
        // DOM Events
        TreeView.prototype.onClick = function (e) {
            if (this.lastPointerType && this.lastPointerType !== 'mouse') {
                return;
            }
            var event = new Mouse.StandardMouseEvent(e);
            var item = this.getItemAround(event.target);
            if (!item) {
                return;
            }
            if (Browser.isIE && Date.now() - this.lastClickTimeStamp < 300) {
                // IE10+ doesn't set the detail property correctly. While IE10 simply
                // counts the number of clicks, IE11 reports always 1. To align with
                // other browser, we set the value to 2 if clicks events come in a 300ms
                // sequence.
                event.detail = 2;
            }
            this.lastClickTimeStamp = Date.now();
            this.context.controller.onClick(this.context.tree, item.model.getElement(), event);
        };
        TreeView.prototype.onMouseMiddleClick = function (e) {
            if (!this.context.controller.onMouseMiddleClick) {
                return;
            }
            var event = new Mouse.StandardMouseEvent(e);
            var item = this.getItemAround(event.target);
            if (!item) {
                return;
            }
            this.context.controller.onMouseMiddleClick(this.context.tree, item.model.getElement(), event);
        };
        TreeView.prototype.onMouseDown = function (e) {
            this.didJustPressContextMenuKey = false;
            if (!this.context.controller.onMouseDown) {
                return;
            }
            if (this.lastPointerType && this.lastPointerType !== 'mouse') {
                return;
            }
            var event = new Mouse.StandardMouseEvent(e);
            if (event.ctrlKey && Platform.isNative && Platform.isMacintosh) {
                return;
            }
            var item = this.getItemAround(event.target);
            if (!item) {
                return;
            }
            this.context.controller.onMouseDown(this.context.tree, item.model.getElement(), event);
        };
        TreeView.prototype.onMouseUp = function (e) {
            if (!this.context.controller.onMouseUp) {
                return;
            }
            if (this.lastPointerType && this.lastPointerType !== 'mouse') {
                return;
            }
            var event = new Mouse.StandardMouseEvent(e);
            if (event.ctrlKey && Platform.isNative && Platform.isMacintosh) {
                return;
            }
            var item = this.getItemAround(event.target);
            if (!item) {
                return;
            }
            this.context.controller.onMouseUp(this.context.tree, item.model.getElement(), event);
        };
        TreeView.prototype.onTap = function (e) {
            var item = this.getItemAround(e.initialTarget);
            if (!item) {
                return;
            }
            this.context.controller.onTap(this.context.tree, item.model.getElement(), e);
        };
        TreeView.prototype.onTouchChange = function (event) {
            event.preventDefault();
            event.stopPropagation();
            this.scrollTop -= event.translationY;
        };
        TreeView.prototype.onContextMenu = function (event) {
            var resultEvent;
            var element;
            if (event instanceof KeyboardEvent || this.didJustPressContextMenuKey) {
                this.didJustPressContextMenuKey = false;
                var keyboardEvent = new Keyboard.StandardKeyboardEvent(event);
                element = this.model.getFocus();
                var position;
                if (!element) {
                    element = this.model.getInput();
                    position = DOM.getDomNodePagePosition(this.inputItem.element);
                }
                else {
                    var id = this.context.dataSource.getId(this.context.tree, element);
                    var viewItem = this.items[id];
                    position = DOM.getDomNodePagePosition(viewItem.element);
                }
                resultEvent = new _.KeyboardContextMenuEvent(position.left + position.width, position.top, keyboardEvent);
            }
            else {
                var mouseEvent = new Mouse.StandardMouseEvent(event);
                var item = this.getItemAround(mouseEvent.target);
                if (!item) {
                    return;
                }
                element = item.model.getElement();
                resultEvent = new _.MouseContextMenuEvent(mouseEvent);
            }
            this.context.controller.onContextMenu(this.context.tree, element, resultEvent);
        };
        TreeView.prototype.onKeyDown = function (e) {
            var event = new Keyboard.StandardKeyboardEvent(e);
            this.didJustPressContextMenuKey = event.keyCode === 58 /* ContextMenu */ || (event.shiftKey && event.keyCode === 68 /* F10 */);
            if (event.target && event.target.tagName && event.target.tagName.toLowerCase() === 'input') {
                return; // Ignore event if target is a form input field (avoids browser specific issues)
            }
            if (this.didJustPressContextMenuKey) {
                event.preventDefault();
                event.stopPropagation();
            }
            this.context.controller.onKeyDown(this.context.tree, event);
        };
        TreeView.prototype.onKeyUp = function (e) {
            if (this.didJustPressContextMenuKey) {
                this.onContextMenu(e);
            }
            this.didJustPressContextMenuKey = false;
            this.context.controller.onKeyUp(this.context.tree, new Keyboard.StandardKeyboardEvent(e));
        };
        TreeView.prototype.onDragStart = function (item, e) {
            if (this.model.getHighlight()) {
                return;
            }
            var element = item.model.getElement();
            var selection = this.model.getSelection();
            var elements;
            if (selection.indexOf(element) > -1) {
                elements = selection;
            }
            else {
                elements = [element];
            }
            e.dataTransfer.effectAllowed = 'copyMove';
            e.dataTransfer.setData(dnd_1.DataTransfers.RESOURCES, JSON.stringify([item.uri]));
            if (e.dataTransfer.setDragImage) {
                var label = void 0;
                if (this.context.dnd.getDragLabel) {
                    label = this.context.dnd.getDragLabel(this.context.tree, elements);
                }
                else {
                    label = String(elements.length);
                }
                var dragImage_1 = document.createElement('div');
                dragImage_1.className = 'monaco-tree-drag-image';
                dragImage_1.textContent = label;
                document.body.appendChild(dragImage_1);
                e.dataTransfer.setDragImage(dragImage_1, -10, -10);
                setTimeout(function () { return document.body.removeChild(dragImage_1); }, 0);
            }
            this.currentDragAndDropData = new dnd.ElementsDragAndDropData(elements);
            TreeView.currentExternalDragAndDropData = new dnd.ExternalElementsDragAndDropData(elements);
            this.context.dnd.onDragStart(this.context.tree, this.currentDragAndDropData, new Mouse.DragMouseEvent(e));
        };
        TreeView.prototype.setupDragAndDropScrollInterval = function () {
            var _this = this;
            var viewTop = DOM.getTopLeftOffset(this.wrapper).top;
            if (!this.dragAndDropScrollInterval) {
                this.dragAndDropScrollInterval = window.setInterval(function () {
                    if (_this.dragAndDropMouseY === undefined) {
                        return;
                    }
                    var diff = _this.dragAndDropMouseY - viewTop;
                    var scrollDiff = 0;
                    var upperLimit = _this.viewHeight - 35;
                    if (diff < 35) {
                        scrollDiff = Math.max(-14, 0.2 * (diff - 35));
                    }
                    else if (diff > upperLimit) {
                        scrollDiff = Math.min(14, 0.2 * (diff - upperLimit));
                    }
                    _this.scrollTop += scrollDiff;
                }, 10);
                this.cancelDragAndDropScrollTimeout();
                this.dragAndDropScrollTimeout = window.setTimeout(function () {
                    _this.cancelDragAndDropScrollInterval();
                    _this.dragAndDropScrollTimeout = null;
                }, 1000);
            }
        };
        TreeView.prototype.cancelDragAndDropScrollInterval = function () {
            if (this.dragAndDropScrollInterval) {
                window.clearInterval(this.dragAndDropScrollInterval);
                this.dragAndDropScrollInterval = null;
            }
            this.cancelDragAndDropScrollTimeout();
        };
        TreeView.prototype.cancelDragAndDropScrollTimeout = function () {
            if (this.dragAndDropScrollTimeout) {
                window.clearTimeout(this.dragAndDropScrollTimeout);
                this.dragAndDropScrollTimeout = null;
            }
        };
        TreeView.prototype.onDragOver = function (e) {
            var _this = this;
            var event = new Mouse.DragMouseEvent(e);
            var viewItem = this.getItemAround(event.target);
            if (!viewItem || (event.posx === 0 && event.posy === 0 && event.browserEvent.type === DOM.EventType.DRAG_LEAVE)) {
                // dragging outside of tree
                if (this.currentDropTarget) {
                    // clear previously hovered element feedback
                    this.currentDropTargets.forEach(function (i) { return i.dropTarget = false; });
                    this.currentDropTargets = [];
                    this.currentDropDisposable.dispose();
                }
                this.cancelDragAndDropScrollInterval();
                this.currentDropTarget = null;
                this.currentDropElement = null;
                this.dragAndDropMouseY = null;
                return false;
            }
            // dragging inside the tree
            this.setupDragAndDropScrollInterval();
            this.dragAndDropMouseY = event.posy;
            if (!this.currentDragAndDropData) {
                // just started dragging
                if (TreeView.currentExternalDragAndDropData) {
                    this.currentDragAndDropData = TreeView.currentExternalDragAndDropData;
                }
                else {
                    if (!event.dataTransfer.types) {
                        return false;
                    }
                    this.currentDragAndDropData = new dnd.DesktopDragAndDropData();
                }
            }
            this.currentDragAndDropData.update(event);
            var element;
            var item = viewItem.model;
            var reaction;
            // check the bubble up behavior
            do {
                element = item ? item.getElement() : this.model.getInput();
                reaction = this.context.dnd.onDragOver(this.context.tree, this.currentDragAndDropData, element, event);
                if (!reaction || reaction.bubble !== 1 /* BUBBLE_UP */) {
                    break;
                }
                item = item && item.parent;
            } while (item);
            if (!item) {
                this.currentDropElement = null;
                return false;
            }
            var canDrop = reaction && reaction.accept;
            if (canDrop) {
                this.currentDropElement = item.getElement();
                event.preventDefault();
                event.dataTransfer.dropEffect = reaction.effect === 0 /* COPY */ ? 'copy' : 'move';
            }
            else {
                this.currentDropElement = null;
            }
            // item is the model item where drop() should be called
            // can be null
            var currentDropTarget = item.id === this.inputItem.id ? this.inputItem : this.items[item.id];
            if (this.shouldInvalidateDropReaction || this.currentDropTarget !== currentDropTarget || !reactionEquals(this.currentDropElementReaction, reaction)) {
                this.shouldInvalidateDropReaction = false;
                if (this.currentDropTarget) {
                    this.currentDropTargets.forEach(function (i) { return i.dropTarget = false; });
                    this.currentDropTargets = [];
                    this.currentDropDisposable.dispose();
                }
                this.currentDropTarget = currentDropTarget;
                this.currentDropElementReaction = reaction;
                if (canDrop) {
                    // setup hover feedback for drop target
                    if (this.currentDropTarget) {
                        this.currentDropTarget.dropTarget = true;
                        this.currentDropTargets.push(this.currentDropTarget);
                    }
                    if (reaction.bubble === 0 /* BUBBLE_DOWN */) {
                        var nav = item.getNavigator();
                        var child;
                        while (child = nav.next()) {
                            viewItem = this.items[child.id];
                            if (viewItem) {
                                viewItem.dropTarget = true;
                                this.currentDropTargets.push(viewItem);
                            }
                        }
                    }
                    if (reaction.autoExpand) {
                        var timeoutPromise_1 = async_1.timeout(500);
                        this.currentDropDisposable = Lifecycle.toDisposable(function () { return timeoutPromise_1.cancel(); });
                        timeoutPromise_1
                            .then(function () { return _this.context.tree.expand(_this.currentDropElement); })
                            .then(function () { return _this.shouldInvalidateDropReaction = true; });
                    }
                }
            }
            return true;
        };
        TreeView.prototype.onDrop = function (e) {
            if (this.currentDropElement) {
                var event = new Mouse.DragMouseEvent(e);
                event.preventDefault();
                this.currentDragAndDropData.update(event);
                this.context.dnd.drop(this.context.tree, this.currentDragAndDropData, this.currentDropElement, event);
                this.onDragEnd(e);
            }
            this.cancelDragAndDropScrollInterval();
        };
        TreeView.prototype.onDragEnd = function (e) {
            if (this.currentDropTarget) {
                this.currentDropTargets.forEach(function (i) { return i.dropTarget = false; });
                this.currentDropTargets = [];
            }
            this.currentDropDisposable.dispose();
            this.cancelDragAndDropScrollInterval();
            this.currentDragAndDropData = null;
            TreeView.currentExternalDragAndDropData = null;
            this.currentDropElement = null;
            this.currentDropTarget = null;
            this.dragAndDropMouseY = null;
        };
        TreeView.prototype.onFocus = function () {
            if (!this.context.options.alwaysFocused) {
                DOM.addClass(this.domNode, 'focused');
            }
            this._onDOMFocus.fire();
        };
        TreeView.prototype.onBlur = function () {
            if (!this.context.options.alwaysFocused) {
                DOM.removeClass(this.domNode, 'focused');
            }
            this.domNode.removeAttribute('aria-activedescendant'); // ARIA
            this._onDOMBlur.fire();
        };
        // MS specific DOM Events
        TreeView.prototype.onMsPointerDown = function (event) {
            if (!this.msGesture) {
                return;
            }
            // Circumvent IE11 breaking change in e.pointerType & TypeScript's stale definitions
            var pointerType = event.pointerType;
            if (pointerType === (event.MSPOINTER_TYPE_MOUSE || 'mouse')) {
                this.lastPointerType = 'mouse';
                return;
            }
            else if (pointerType === (event.MSPOINTER_TYPE_TOUCH || 'touch')) {
                this.lastPointerType = 'touch';
            }
            else {
                return;
            }
            event.stopPropagation();
            event.preventDefault();
            this.msGesture.addPointer(event.pointerId);
        };
        TreeView.prototype.onThrottledMsGestureChange = function (event) {
            this.scrollTop -= event.translationY;
        };
        TreeView.prototype.onMsGestureTap = function (event) {
            event.initialTarget = document.elementFromPoint(event.clientX, event.clientY);
            this.onTap(event);
        };
        // DOM changes
        TreeView.prototype.insertItemInDOM = function (item) {
            var elementAfter = null;
            var itemAfter = this.itemAfter(item);
            if (itemAfter && itemAfter.element) {
                elementAfter = itemAfter.element;
            }
            item.insertInDOM(this.rowsContainer, elementAfter);
        };
        TreeView.prototype.removeItemFromDOM = function (item) {
            if (!item) {
                return;
            }
            item.removeFromDOM();
        };
        // Helpers
        TreeView.prototype.shouldBeRendered = function (item) {
            return item.top < this.lastRenderTop + this.lastRenderHeight && item.top + item.height > this.lastRenderTop;
        };
        TreeView.prototype.getItemAround = function (element) {
            var candidate = this.inputItem;
            do {
                if (element[TreeView.BINDING]) {
                    candidate = element[TreeView.BINDING];
                }
                if (element === this.wrapper || element === this.domNode) {
                    return candidate;
                }
                if (element === this.scrollableElement.getDomNode() || element === document.body) {
                    return null;
                }
            } while (element = element.parentElement);
            return undefined;
        };
        // Cleanup
        TreeView.prototype.releaseModel = function () {
            if (this.model) {
                this.modelListeners = Lifecycle.dispose(this.modelListeners);
                this.model = null;
            }
        };
        TreeView.prototype.dispose = function () {
            var _this = this;
            // TODO@joao: improve
            this.scrollableElement.dispose();
            this.releaseModel();
            this.modelListeners = null;
            this.viewListeners = Lifecycle.dispose(this.viewListeners);
            this._onDOMFocus.dispose();
            this._onDOMBlur.dispose();
            if (this.domNode.parentNode) {
                this.domNode.parentNode.removeChild(this.domNode);
            }
            this.domNode = null;
            if (this.items) {
                Object.keys(this.items).forEach(function (key) { return _this.items[key].removeFromDOM(); });
                this.items = null;
            }
            if (this.context.cache) {
                this.context.cache.dispose();
                this.context.cache = null;
            }
            _super.prototype.dispose.call(this);
        };
        TreeView.BINDING = 'monaco-tree-row';
        TreeView.LOADING_DECORATION_DELAY = 800;
        TreeView.counter = 0;
        TreeView.currentExternalDragAndDropData = null;
        return TreeView;
    }(treeViewModel_1.HeightMap));
    exports.TreeView = TreeView;
});

define(__m[238/*vs/css!vs/base/parts/quickopen/browser/quickopen*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[244/*vs/css!vs/base/parts/tree/browser/tree*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[161/*vs/base/parts/tree/browser/treeImpl*/], __M([0/*require*/,1/*exports*/,88/*vs/base/parts/tree/browser/treeDefaults*/,444/*vs/base/parts/tree/browser/treeModel*/,235/*vs/base/parts/tree/browser/treeView*/,6/*vs/base/common/event*/,28/*vs/base/common/color*/,27/*vs/base/common/objects*/,244/*vs/css!vs/base/parts/tree/browser/tree*/]), function (require, exports, TreeDefaults, Model, View, event_1, color_1, objects_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var TreeContext = /** @class */ (function () {
        function TreeContext(tree, configuration, options) {
            if (options === void 0) { options = {}; }
            this.tree = tree;
            this.configuration = configuration;
            this.options = options;
            if (!configuration.dataSource) {
                throw new Error('You must provide a Data Source to the tree.');
            }
            this.dataSource = configuration.dataSource;
            this.renderer = configuration.renderer;
            this.controller = configuration.controller || new TreeDefaults.DefaultController({ clickBehavior: 1 /* ON_MOUSE_UP */, keyboardSupport: typeof options.keyboardSupport !== 'boolean' || options.keyboardSupport });
            this.dnd = configuration.dnd || new TreeDefaults.DefaultDragAndDrop();
            this.filter = configuration.filter || new TreeDefaults.DefaultFilter();
            this.sorter = configuration.sorter || null;
            this.accessibilityProvider = configuration.accessibilityProvider || new TreeDefaults.DefaultAccessibilityProvider();
            this.styler = configuration.styler || null;
        }
        return TreeContext;
    }());
    exports.TreeContext = TreeContext;
    var defaultStyles = {
        listFocusBackground: color_1.Color.fromHex('#073655'),
        listActiveSelectionBackground: color_1.Color.fromHex('#0E639C'),
        listActiveSelectionForeground: color_1.Color.fromHex('#FFFFFF'),
        listFocusAndSelectionBackground: color_1.Color.fromHex('#094771'),
        listFocusAndSelectionForeground: color_1.Color.fromHex('#FFFFFF'),
        listInactiveSelectionBackground: color_1.Color.fromHex('#3F3F46'),
        listHoverBackground: color_1.Color.fromHex('#2A2D2E'),
        listDropBackground: color_1.Color.fromHex('#383B3D')
    };
    var Tree = /** @class */ (function () {
        function Tree(container, configuration, options) {
            if (options === void 0) { options = {}; }
            this._onDidChangeFocus = new event_1.Relay();
            this.onDidChangeFocus = this._onDidChangeFocus.event;
            this._onDidChangeSelection = new event_1.Relay();
            this.onDidChangeSelection = this._onDidChangeSelection.event;
            this._onHighlightChange = new event_1.Relay();
            this._onDidExpandItem = new event_1.Relay();
            this._onDidCollapseItem = new event_1.Relay();
            this._onDispose = new event_1.Emitter();
            this.onDidDispose = this._onDispose.event;
            this.container = container;
            objects_1.mixin(options, defaultStyles, false);
            options.twistiePixels = typeof options.twistiePixels === 'number' ? options.twistiePixels : 32;
            options.showTwistie = options.showTwistie === false ? false : true;
            options.indentPixels = typeof options.indentPixels === 'number' ? options.indentPixels : 12;
            options.alwaysFocused = options.alwaysFocused === true ? true : false;
            options.useShadows = options.useShadows === false ? false : true;
            options.paddingOnRow = options.paddingOnRow === false ? false : true;
            options.showLoading = options.showLoading === false ? false : true;
            this.context = new TreeContext(this, configuration, options);
            this.model = new Model.TreeModel(this.context);
            this.view = new View.TreeView(this.context, this.container);
            this.view.setModel(this.model);
            this._onDidChangeFocus.input = this.model.onDidFocus;
            this._onDidChangeSelection.input = this.model.onDidSelect;
            this._onHighlightChange.input = this.model.onDidHighlight;
            this._onDidExpandItem.input = this.model.onDidExpandItem;
            this._onDidCollapseItem.input = this.model.onDidCollapseItem;
        }
        Tree.prototype.style = function (styles) {
            this.view.applyStyles(styles);
        };
        Object.defineProperty(Tree.prototype, "onDidFocus", {
            get: function () {
                return this.view && this.view.onDOMFocus;
            },
            enumerable: true,
            configurable: true
        });
        Tree.prototype.getHTMLElement = function () {
            return this.view.getHTMLElement();
        };
        Tree.prototype.layout = function (height, width) {
            this.view.layout(height, width);
        };
        Tree.prototype.domFocus = function () {
            this.view.focus();
        };
        Tree.prototype.isDOMFocused = function () {
            return this.view.isFocused();
        };
        Tree.prototype.domBlur = function () {
            this.view.blur();
        };
        Tree.prototype.setInput = function (element) {
            return this.model.setInput(element);
        };
        Tree.prototype.getInput = function () {
            return this.model.getInput();
        };
        Tree.prototype.refresh = function (element, recursive) {
            if (element === void 0) { element = null; }
            if (recursive === void 0) { recursive = true; }
            return this.model.refresh(element, recursive);
        };
        Tree.prototype.expand = function (element) {
            return this.model.expand(element);
        };
        Tree.prototype.collapse = function (element, recursive) {
            if (recursive === void 0) { recursive = false; }
            return this.model.collapse(element, recursive);
        };
        Tree.prototype.toggleExpansion = function (element, recursive) {
            if (recursive === void 0) { recursive = false; }
            return this.model.toggleExpansion(element, recursive);
        };
        Tree.prototype.isExpanded = function (element) {
            return this.model.isExpanded(element);
        };
        Tree.prototype.reveal = function (element, relativeTop) {
            if (relativeTop === void 0) { relativeTop = null; }
            return this.model.reveal(element, relativeTop);
        };
        Tree.prototype.getHighlight = function () {
            return this.model.getHighlight();
        };
        Tree.prototype.clearHighlight = function (eventPayload) {
            this.model.setHighlight(null, eventPayload);
        };
        Tree.prototype.setSelection = function (elements, eventPayload) {
            this.model.setSelection(elements, eventPayload);
        };
        Tree.prototype.getSelection = function () {
            return this.model.getSelection();
        };
        Tree.prototype.clearSelection = function (eventPayload) {
            this.model.setSelection([], eventPayload);
        };
        Tree.prototype.setFocus = function (element, eventPayload) {
            this.model.setFocus(element, eventPayload);
        };
        Tree.prototype.getFocus = function () {
            return this.model.getFocus();
        };
        Tree.prototype.focusNext = function (count, eventPayload) {
            this.model.focusNext(count, eventPayload);
        };
        Tree.prototype.focusPrevious = function (count, eventPayload) {
            this.model.focusPrevious(count, eventPayload);
        };
        Tree.prototype.focusParent = function (eventPayload) {
            this.model.focusParent(eventPayload);
        };
        Tree.prototype.focusFirstChild = function (eventPayload) {
            this.model.focusFirstChild(eventPayload);
        };
        Tree.prototype.focusFirst = function (eventPayload, from) {
            this.model.focusFirst(eventPayload, from);
        };
        Tree.prototype.focusNth = function (index, eventPayload) {
            this.model.focusNth(index, eventPayload);
        };
        Tree.prototype.focusLast = function (eventPayload, from) {
            this.model.focusLast(eventPayload, from);
        };
        Tree.prototype.focusNextPage = function (eventPayload) {
            this.view.focusNextPage(eventPayload);
        };
        Tree.prototype.focusPreviousPage = function (eventPayload) {
            this.view.focusPreviousPage(eventPayload);
        };
        Tree.prototype.clearFocus = function (eventPayload) {
            this.model.setFocus(null, eventPayload);
        };
        Tree.prototype.dispose = function () {
            this._onDispose.fire();
            if (this.model !== null) {
                this.model.dispose();
                this.model = null;
            }
            if (this.view !== null) {
                this.view.dispose();
                this.view = null;
            }
            this._onDidChangeFocus.dispose();
            this._onDidChangeSelection.dispose();
            this._onHighlightChange.dispose();
            this._onDidExpandItem.dispose();
            this._onDidCollapseItem.dispose();
            this._onDispose.dispose();
        };
        return Tree;
    }());
    exports.Tree = Tree;
});

define(__m[250/*vs/css!vs/editor/browser/controller/textAreaHandler*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[251/*vs/css!vs/editor/browser/viewParts/currentLineHighlight/currentLineHighlight*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[252/*vs/css!vs/editor/browser/viewParts/currentLineMarginHighlight/currentLineMarginHighlight*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[259/*vs/css!vs/editor/browser/viewParts/decorations/decorations*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[260/*vs/css!vs/editor/browser/viewParts/glyphMargin/glyphMargin*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[262/*vs/css!vs/editor/browser/viewParts/indentGuides/indentGuides*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[265/*vs/css!vs/editor/browser/viewParts/lineNumbers/lineNumbers*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[266/*vs/css!vs/editor/browser/viewParts/lines/viewLines*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[267/*vs/css!vs/editor/browser/viewParts/linesDecorations/linesDecorations*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[269/*vs/css!vs/editor/browser/viewParts/marginDecorations/marginDecorations*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[272/*vs/css!vs/editor/browser/viewParts/minimap/minimap*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[274/*vs/css!vs/editor/browser/viewParts/overlayWidgets/overlayWidgets*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[281/*vs/css!vs/editor/browser/viewParts/rulers/rulers*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[284/*vs/css!vs/editor/browser/viewParts/scrollDecoration/scrollDecoration*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[286/*vs/css!vs/editor/browser/viewParts/selections/selections*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[295/*vs/css!vs/editor/browser/viewParts/viewCursors/viewCursors*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[296/*vs/css!vs/editor/browser/widget/media/diffEditor*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[331/*vs/css!vs/editor/browser/widget/media/diffReview*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[355/*vs/css!vs/editor/browser/widget/media/editor*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[358/*vs/css!vs/editor/browser/widget/media/tokens*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[359/*vs/css!vs/editor/contrib/bracketMatching/bracketMatching*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[360/*vs/css!vs/editor/contrib/clipboard/clipboard*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[361/*vs/css!vs/editor/contrib/codeAction/lightBulbWidget*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[362/*vs/css!vs/editor/contrib/codelens/codelensWidget*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[363/*vs/css!vs/editor/contrib/colorPicker/colorPicker*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[365/*vs/css!vs/editor/contrib/dnd/dnd*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[366/*vs/css!vs/editor/contrib/find/findWidget*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[367/*vs/css!vs/editor/contrib/folding/folding*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[163/*vs/css!vs/editor/contrib/goToDefinition/goToDefinitionMouse*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[370/*vs/css!vs/editor/contrib/gotoError/gotoErrorWidget*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[371/*vs/css!vs/editor/contrib/hover/hover*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[373/*vs/css!vs/editor/contrib/links/links*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[374/*vs/css!vs/editor/contrib/message/messageController*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[375/*vs/css!vs/editor/contrib/parameterHints/parameterHints*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[376/*vs/css!vs/editor/contrib/referenceSearch/media/peekViewWidget*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[377/*vs/css!vs/editor/contrib/referenceSearch/media/referencesWidget*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[381/*vs/css!vs/editor/contrib/rename/renameInputField*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[382/*vs/css!vs/editor/contrib/snippet/snippetSession*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[383/*vs/css!vs/editor/contrib/suggest/media/suggest*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[384/*vs/css!vs/editor/contrib/zoneWidget/zoneWidget*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[386/*vs/css!vs/editor/standalone/browser/accessibilityHelp/accessibilityHelp*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[388/*vs/css!vs/editor/standalone/browser/iPadShowKeyboard/iPadShowKeyboard*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[396/*vs/css!vs/editor/standalone/browser/inspectTokens/inspectTokens*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[399/*vs/css!vs/editor/standalone/browser/quickOpen/editorQuickOpen*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[400/*vs/css!vs/editor/standalone/browser/quickOpen/gotoLine*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[401/*vs/css!vs/editor/standalone/browser/quickOpen/quickOutline*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[403/*vs/css!vs/editor/standalone/browser/standalone-tokens*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
define(__m[404/*vs/css!vs/platform/contextview/browser/contextMenuHandler*/], __M([9/*vs/css!vs/editor/editor.main*/]), {});
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[407/*vs/editor/browser/config/charWidthReader*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CharWidthRequest = /** @class */ (function () {
        function CharWidthRequest(chr, type) {
            this.chr = chr;
            this.type = type;
            this.width = 0;
        }
        CharWidthRequest.prototype.fulfill = function (width) {
            this.width = width;
        };
        return CharWidthRequest;
    }());
    exports.CharWidthRequest = CharWidthRequest;
    var DomCharWidthReader = /** @class */ (function () {
        function DomCharWidthReader(bareFontInfo, requests) {
            this._bareFontInfo = bareFontInfo;
            this._requests = requests;
            this._container = null;
            this._testElements = null;
        }
        DomCharWidthReader.prototype.read = function () {
            // Create a test container with all these test elements
            this._createDomElements();
            // Add the container to the DOM
            document.body.appendChild(this._container);
            // Read character widths
            this._readFromDomElements();
            // Remove the container from the DOM
            document.body.removeChild(this._container);
            this._container = null;
            this._testElements = null;
        };
        DomCharWidthReader.prototype._createDomElements = function () {
            var container = document.createElement('div');
            container.style.position = 'absolute';
            container.style.top = '-50000px';
            container.style.width = '50000px';
            var regularDomNode = document.createElement('div');
            regularDomNode.style.fontFamily = this._bareFontInfo.getMassagedFontFamily();
            regularDomNode.style.fontWeight = this._bareFontInfo.fontWeight;
            regularDomNode.style.fontSize = this._bareFontInfo.fontSize + 'px';
            regularDomNode.style.lineHeight = this._bareFontInfo.lineHeight + 'px';
            regularDomNode.style.letterSpacing = this._bareFontInfo.letterSpacing + 'px';
            container.appendChild(regularDomNode);
            var boldDomNode = document.createElement('div');
            boldDomNode.style.fontFamily = this._bareFontInfo.getMassagedFontFamily();
            boldDomNode.style.fontWeight = 'bold';
            boldDomNode.style.fontSize = this._bareFontInfo.fontSize + 'px';
            boldDomNode.style.lineHeight = this._bareFontInfo.lineHeight + 'px';
            boldDomNode.style.letterSpacing = this._bareFontInfo.letterSpacing + 'px';
            container.appendChild(boldDomNode);
            var italicDomNode = document.createElement('div');
            italicDomNode.style.fontFamily = this._bareFontInfo.getMassagedFontFamily();
            italicDomNode.style.fontWeight = this._bareFontInfo.fontWeight;
            italicDomNode.style.fontSize = this._bareFontInfo.fontSize + 'px';
            italicDomNode.style.lineHeight = this._bareFontInfo.lineHeight + 'px';
            italicDomNode.style.letterSpacing = this._bareFontInfo.letterSpacing + 'px';
            italicDomNode.style.fontStyle = 'italic';
            container.appendChild(italicDomNode);
            var testElements = [];
            for (var i = 0, len = this._requests.length; i < len; i++) {
                var request = this._requests[i];
                var parent_1 = void 0;
                if (request.type === 0 /* Regular */) {
                    parent_1 = regularDomNode;
                }
                if (request.type === 2 /* Bold */) {
                    parent_1 = boldDomNode;
                }
                if (request.type === 1 /* Italic */) {
                    parent_1 = italicDomNode;
                }
                parent_1.appendChild(document.createElement('br'));
                var testElement = document.createElement('span');
                DomCharWidthReader._render(testElement, request);
                parent_1.appendChild(testElement);
                testElements[i] = testElement;
            }
            this._container = container;
            this._testElements = testElements;
        };
        DomCharWidthReader._render = function (testElement, request) {
            if (request.chr === ' ') {
                var htmlString = '&nbsp;';
                // Repeat character 256 (2^8) times
                for (var i = 0; i < 8; i++) {
                    htmlString += htmlString;
                }
                testElement.innerHTML = htmlString;
            }
            else {
                var testString = request.chr;
                // Repeat character 256 (2^8) times
                for (var i = 0; i < 8; i++) {
                    testString += testString;
                }
                testElement.textContent = testString;
            }
        };
        DomCharWidthReader.prototype._readFromDomElements = function () {
            for (var i = 0, len = this._requests.length; i < len; i++) {
                var request = this._requests[i];
                var testElement = this._testElements[i];
                request.fulfill(testElement.offsetWidth / 256);
            }
        };
        return DomCharWidthReader;
    }());
    function readCharWidths(bareFontInfo, requests) {
        var reader = new DomCharWidthReader(bareFontInfo, requests);
        reader.read();
    }
    exports.readCharWidths = readCharWidths;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[409/*vs/editor/browser/config/elementSizeObserver*/], __M([0/*require*/,1/*exports*/,2/*vs/base/common/lifecycle*/]), function (require, exports, lifecycle_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ElementSizeObserver = /** @class */ (function (_super) {
        __extends(ElementSizeObserver, _super);
        function ElementSizeObserver(referenceDomElement, changeCallback) {
            var _this = _super.call(this) || this;
            _this.referenceDomElement = referenceDomElement;
            _this.changeCallback = changeCallback;
            _this.measureReferenceDomElementToken = -1;
            _this.width = -1;
            _this.height = -1;
            _this.measureReferenceDomElement(false);
            return _this;
        }
        ElementSizeObserver.prototype.dispose = function () {
            this.stopObserving();
            _super.prototype.dispose.call(this);
        };
        ElementSizeObserver.prototype.getWidth = function () {
            return this.width;
        };
        ElementSizeObserver.prototype.getHeight = function () {
            return this.height;
        };
        ElementSizeObserver.prototype.startObserving = function () {
            var _this = this;
            if (this.measureReferenceDomElementToken === -1) {
                this.measureReferenceDomElementToken = setInterval(function () { return _this.measureReferenceDomElement(true); }, 100);
            }
        };
        ElementSizeObserver.prototype.stopObserving = function () {
            if (this.measureReferenceDomElementToken !== -1) {
                clearInterval(this.measureReferenceDomElementToken);
                this.measureReferenceDomElementToken = -1;
            }
        };
        ElementSizeObserver.prototype.observe = function (dimension) {
            this.measureReferenceDomElement(true, dimension);
        };
        ElementSizeObserver.prototype.measureReferenceDomElement = function (callChangeCallback, dimension) {
            var observedWidth = 0;
            var observedHeight = 0;
            if (dimension) {
                observedWidth = dimension.width;
                observedHeight = dimension.height;
            }
            else if (this.referenceDomElement) {
                observedWidth = this.referenceDomElement.clientWidth;
                observedHeight = this.referenceDomElement.clientHeight;
            }
            observedWidth = Math.max(5, observedWidth);
            observedHeight = Math.max(5, observedHeight);
            if (this.width !== observedWidth || this.height !== observedHeight) {
                this.width = observedWidth;
                this.height = observedHeight;
                if (callChangeCallback) {
                    this.changeCallback();
                }
            }
        };
        return ElementSizeObserver;
    }(lifecycle_1.Disposable));
    exports.ElementSizeObserver = ElementSizeObserver;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[66/*vs/editor/browser/core/editorState*/], __M([0/*require*/,1/*exports*/,8/*vs/base/common/strings*/]), function (require, exports, strings) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var EditorState = /** @class */ (function () {
        function EditorState(editor, flags) {
            this.flags = flags;
            if ((this.flags & 1 /* Value */) !== 0) {
                var model = editor.getModel();
                this.modelVersionId = model ? strings.format('{0}#{1}', model.uri.toString(), model.getVersionId()) : null;
            }
            if ((this.flags & 4 /* Position */) !== 0) {
                this.position = editor.getPosition();
            }
            if ((this.flags & 2 /* Selection */) !== 0) {
                this.selection = editor.getSelection();
            }
            if ((this.flags & 8 /* Scroll */) !== 0) {
                this.scrollLeft = editor.getScrollLeft();
                this.scrollTop = editor.getScrollTop();
            }
        }
        EditorState.prototype._equals = function (other) {
            if (!(other instanceof EditorState)) {
                return false;
            }
            var state = other;
            if (this.modelVersionId !== state.modelVersionId) {
                return false;
            }
            if (this.scrollLeft !== state.scrollLeft || this.scrollTop !== state.scrollTop) {
                return false;
            }
            if (!this.position && state.position || this.position && !state.position || this.position && state.position && !this.position.equals(state.position)) {
                return false;
            }
            if (!this.selection && state.selection || this.selection && !state.selection || this.selection && state.selection && !this.selection.equalsRange(state.selection)) {
                return false;
            }
            return true;
        };
        EditorState.prototype.validate = function (editor) {
            return this._equals(new EditorState(editor, this.flags));
        };
        return EditorState;
    }());
    exports.EditorState = EditorState;
    var StableEditorScrollState = /** @class */ (function () {
        function StableEditorScrollState(_visiblePosition, _visiblePositionScrollDelta) {
            this._visiblePosition = _visiblePosition;
            this._visiblePositionScrollDelta = _visiblePositionScrollDelta;
        }
        StableEditorScrollState.capture = function (editor) {
            var visiblePosition = null;
            var visiblePositionScrollDelta = 0;
            if (editor.getScrollTop() !== 0) {
                var visibleRanges = editor.getVisibleRanges();
                if (visibleRanges.length > 0) {
                    visiblePosition = visibleRanges[0].getStartPosition();
                    var visiblePositionScrollTop = editor.getTopForPosition(visiblePosition.lineNumber, visiblePosition.column);
                    visiblePositionScrollDelta = editor.getScrollTop() - visiblePositionScrollTop;
                }
            }
            return new StableEditorScrollState(visiblePosition, visiblePositionScrollDelta);
        };
        StableEditorScrollState.prototype.restore = function (editor) {
            if (this._visiblePosition) {
                var visiblePositionScrollTop = editor.getTopForPosition(this._visiblePosition.lineNumber, this._visiblePosition.column);
                editor.setScrollTop(visiblePositionScrollTop + this._visiblePositionScrollDelta);
            }
        };
        return StableEditorScrollState;
    }());
    exports.StableEditorScrollState = StableEditorScrollState;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[134/*vs/editor/browser/editorDom*/], __M([0/*require*/,1/*exports*/,7/*vs/base/browser/dom*/,73/*vs/base/browser/globalMouseMoveMonitor*/,40/*vs/base/browser/mouseEvent*/,2/*vs/base/common/lifecycle*/]), function (require, exports, dom, globalMouseMoveMonitor_1, mouseEvent_1, lifecycle_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * Coordinates relative to the whole document (e.g. mouse event's pageX and pageY)
     */
    var PageCoordinates = /** @class */ (function () {
        function PageCoordinates(x, y) {
            this.x = x;
            this.y = y;
        }
        PageCoordinates.prototype.toClientCoordinates = function () {
            return new ClientCoordinates(this.x - dom.StandardWindow.scrollX, this.y - dom.StandardWindow.scrollY);
        };
        return PageCoordinates;
    }());
    exports.PageCoordinates = PageCoordinates;
    /**
     * Coordinates within the application's client area (i.e. origin is document's scroll position).
     *
     * For example, clicking in the top-left corner of the client area will
     * always result in a mouse event with a client.x value of 0, regardless
     * of whether the page is scrolled horizontally.
     */
    var ClientCoordinates = /** @class */ (function () {
        function ClientCoordinates(clientX, clientY) {
            this.clientX = clientX;
            this.clientY = clientY;
        }
        ClientCoordinates.prototype.toPageCoordinates = function () {
            return new PageCoordinates(this.clientX + dom.StandardWindow.scrollX, this.clientY + dom.StandardWindow.scrollY);
        };
        return ClientCoordinates;
    }());
    exports.ClientCoordinates = ClientCoordinates;
    /**
     * The position of the editor in the page.
     */
    var EditorPagePosition = /** @class */ (function () {
        function EditorPagePosition(x, y, width, height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
        return EditorPagePosition;
    }());
    exports.EditorPagePosition = EditorPagePosition;
    function createEditorPagePosition(editorViewDomNode) {
        var editorPos = dom.getDomNodePagePosition(editorViewDomNode);
        return new EditorPagePosition(editorPos.left, editorPos.top, editorPos.width, editorPos.height);
    }
    exports.createEditorPagePosition = createEditorPagePosition;
    var EditorMouseEvent = /** @class */ (function (_super) {
        __extends(EditorMouseEvent, _super);
        function EditorMouseEvent(e, editorViewDomNode) {
            var _this = _super.call(this, e) || this;
            _this.pos = new PageCoordinates(_this.posx, _this.posy);
            _this.editorPos = createEditorPagePosition(editorViewDomNode);
            return _this;
        }
        return EditorMouseEvent;
    }(mouseEvent_1.StandardMouseEvent));
    exports.EditorMouseEvent = EditorMouseEvent;
    var EditorMouseEventFactory = /** @class */ (function () {
        function EditorMouseEventFactory(editorViewDomNode) {
            this._editorViewDomNode = editorViewDomNode;
        }
        EditorMouseEventFactory.prototype._create = function (e) {
            return new EditorMouseEvent(e, this._editorViewDomNode);
        };
        EditorMouseEventFactory.prototype.onContextMenu = function (target, callback) {
            var _this = this;
            return dom.addDisposableListener(target, 'contextmenu', function (e) {
                callback(_this._create(e));
            });
        };
        EditorMouseEventFactory.prototype.onMouseUp = function (target, callback) {
            var _this = this;
            return dom.addDisposableListener(target, 'mouseup', function (e) {
                callback(_this._create(e));
            });
        };
        EditorMouseEventFactory.prototype.onMouseDown = function (target, callback) {
            var _this = this;
            return dom.addDisposableListener(target, 'mousedown', function (e) {
                callback(_this._create(e));
            });
        };
        EditorMouseEventFactory.prototype.onMouseLeave = function (target, callback) {
            var _this = this;
            return dom.addDisposableNonBubblingMouseOutListener(target, function (e) {
                callback(_this._create(e));
            });
        };
        EditorMouseEventFactory.prototype.onMouseMoveThrottled = function (target, callback, merger, minimumTimeMs) {
            var _this = this;
            var myMerger = function (lastEvent, currentEvent) {
                return merger(lastEvent, _this._create(currentEvent));
            };
            return dom.addDisposableThrottledListener(target, 'mousemove', callback, myMerger, minimumTimeMs);
        };
        return EditorMouseEventFactory;
    }());
    exports.EditorMouseEventFactory = EditorMouseEventFactory;
    var GlobalEditorMouseMoveMonitor = /** @class */ (function (_super) {
        __extends(GlobalEditorMouseMoveMonitor, _super);
        function GlobalEditorMouseMoveMonitor(editorViewDomNode) {
            var _this = _super.call(this) || this;
            _this._editorViewDomNode = editorViewDomNode;
            _this._globalMouseMoveMonitor = _this._register(new globalMouseMoveMonitor_1.GlobalMouseMoveMonitor());
            _this._keydownListener = null;
            return _this;
        }
        GlobalEditorMouseMoveMonitor.prototype.startMonitoring = function (merger, mouseMoveCallback, onStopCallback) {
            var _this = this;
            // Add a <<capture>> keydown event listener that will cancel the monitoring
            // if something other than a modifier key is pressed
            this._keydownListener = dom.addStandardDisposableListener(document, 'keydown', function (e) {
                var kb = e.toKeybinding();
                if (kb.isModifierKey()) {
                    // Allow modifier keys
                    return;
                }
                _this._globalMouseMoveMonitor.stopMonitoring(true);
            }, true);
            var myMerger = function (lastEvent, currentEvent) {
                return merger(lastEvent, new EditorMouseEvent(currentEvent, _this._editorViewDomNode));
            };
            this._globalMouseMoveMonitor.startMonitoring(myMerger, mouseMoveCallback, function () {
                _this._keydownListener.dispose();
                onStopCallback();
            });
        };
        return GlobalEditorMouseMoveMonitor;
    }(lifecycle_1.Disposable));
    exports.GlobalEditorMouseMoveMonitor = GlobalEditorMouseMoveMonitor;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/













define(__m[415/*vs/editor/browser/services/abstractCodeEditorService*/], __M([0/*require*/,1/*exports*/,6/*vs/base/common/event*/,2/*vs/base/common/lifecycle*/]), function (require, exports, event_1, lifecycle_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var AbstractCodeEditorService = /** @class */ (function (_super) {
        __extends(AbstractCodeEditorService, _super);
        function AbstractCodeEditorService() {
            var _this = _super.call(this) || this;
            _this._onCodeEditorAdd = _this._register(new event_1.Emitter());
            _this.onCodeEditorAdd = _this._onCodeEditorAdd.event;
            _this._onCodeEditorRemove = _this._register(new event_1.Emitter());
            _this._onDiffEditorAdd = _this._register(new event_1.Emitter());
            _this._onDiffEditorRemove = _this._register(new event_1.Emitter());
            _this._codeEditors = Object.create(null);
            _this._diffEditors = Object.create(null);
            return _this;
        }
        AbstractCodeEditorService.prototype.addCodeEditor = function (editor) {
            this._codeEditors[editor.getId()] = editor;
            this._onCodeEditorAdd.fire(editor);
        };
        AbstractCodeEditorService.prototype.removeCodeEditor = function (editor) {
            if (delete this._codeEditors[editor.getId()]) {
                this._onCodeEditorRemove.fire(editor);
            }
        };
        AbstractCodeEditorService.prototype.listCodeEditors = function () {
            var _this = this;
            return Object.keys(this._codeEditors).map(function (id) { return _this._codeEditors[id]; });
        };
        AbstractCodeEditorService.prototype.addDiffEditor = function (editor) {
            this._diffEditors[editor.getId()] = editor;
            this._onDiffEditorAdd.fire(editor);
        };
        AbstractCodeEditorService.prototype.removeDiffEditor = function (editor) {
            if (delete this._diffEditors[editor.getId()]) {
                this._onDiffEditorRemove.fire(editor);
            }
        };
        AbstractCodeEditorService.prototype.listDiffEditors = function () {
            var _this = this;
            return Object.keys(this._diffEditors).map(function (id) { return _this._diffEditors[id]; });
        };
        AbstractCodeEditorService.prototype.getFocusedCodeEditor = function () {
            var editorWithWidgetFocus = null;
            var editors = this.listCodeEditors();
            for (var i = 0; i < editors.length; i++) {
                var editor = editors[i];
                if (editor.hasTextFocus()) {
                    // bingo!
                    return editor;
                }
                if (editor.hasWidgetFocus()) {
                    editorWithWidgetFocus = editor;
                }
            }
            return editorWithWidgetFocus;
        };
        return AbstractCodeEditorService;
    }(lifecycle_1.Disposable));
    exports.AbstractCodeEditorService = AbstractCodeEditorService;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[97/*vs/editor/common/config/editorZoom*/], __M([0/*require*/,1/*exports*/,6/*vs/base/common/event*/]), function (require, exports, event_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.EditorZoom = new /** @class */ (function () {
        function class_1() {
            this._zoomLevel = 0;
            this._onDidChangeZoomLevel = new event_1.Emitter();
            this.onDidChangeZoomLevel = this._onDidChangeZoomLevel.event;
        }
        class_1.prototype.getZoomLevel = function () {
            return this._zoomLevel;
        };
        class_1.prototype.setZoomLevel = function (zoomLevel) {
            zoomLevel = Math.min(Math.max(-5, zoomLevel), 20);
            if (this._zoomLevel === zoomLevel) {
                return;
            }
            this._zoomLevel = zoomLevel;
            this._onDidChangeZoomLevel.fire(this._zoomLevel);
        };
        return class_1;
    }());
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[12/*vs/editor/common/core/position*/], __M([0/*require*/,1/*exports*/]), function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * A position in the editor.
     */
    var Position = /** @class */ (function () {
        function Position(lineNumber, column) {
            this.lineNumber = lineNumber;
            this.column = column;
        }
        /**
         * Create a new postion from this position.
         *
         * @param newLineNumber new line number
         * @param newColumn new column
         */
        Position.prototype.with = function (newLineNumber, newColumn) {
            if (newLineNumber === void 0) { newLineNumber = this.lineNumber; }
            if (newColumn === void 0) { newColumn = this.column; }
            if (newLineNumber === this.lineNumber && newColumn === this.column) {
                return this;
            }
            else {
                return new Position(newLineNumber, newColumn);
            }
        };
        /**
         * Derive a new position from this position.
         *
         * @param deltaLineNumber line number delta
         * @param deltaColumn column delta
         */
        Position.prototype.delta = function (deltaLineNumber, deltaColumn) {
            if (deltaLineNumber === void 0) { deltaLineNumber = 0; }
            if (deltaColumn === void 0) { deltaColumn = 0; }
            return this.with(this.lineNumber + deltaLineNumber, this.column + deltaColumn);
        };
        /**
         * Test if this position equals other position
         */
        Position.prototype.equals = function (other) {
            return Position.equals(this, other);
        };
        /**
         * Test if position `a` equals position `b`
         */
        Position.equals = function (a, b) {
            if (!a && !b) {
                return true;
            }
            return (!!a &&
                !!b &&
                a.lineNumber === b.lineNumber &&
                a.column === b.column);
        };
        /**
         * Test if this position is before other position.
         * If the two positions are equal, the result will be false.
         */
        Position.prototype.isBefore = function (other) {
            return Position.isBefore(this, other);
        };
        /**
         * Test if position `a` is before position `b`.
         * If the two positions are equal, the result will be false.
         */
        Position.isBefore = function (a, b) {
            if (a.lineNumber < b.lineNumber) {
                return true;
            }
            if (b.lineNumber < a.lineNumber) {
                return false;
            }
            return a.column < b.column;
        };
        /**
         * Test if this position is before other position.
         * If the two positions are equal, the result will be true.
         */
        Position.prototype.isBeforeOrEqual = function (other) {
            return Position.isBeforeOrEqual(this, other);
        };
        /**
         * Test if position `a` is before position `b`.
         * If the two positions are equal, the result will be true.
         */
        Position.isBeforeOrEqual = function (a, b) {
            if (a.lineNumber < b.lineNumber) {
                return true;
            }
            if (b.lineNumber < a.lineNumber) {
                return false;
            }
            return a.column <= b.column;
        };
        /**
         * A function that compares positions, useful for sorting
         */
        Position.compare = function (a, b) {
            var aLineNumber = a.lineNumber | 0;
            var bLineNumber = b.lineNumber | 0;
            if (aLineNumber === bLineNumber) {
                var aColumn = a.column | 0;
                var bColumn = b.column | 0;
                return aColumn - bColumn;
            }
            return aLineNumber - bLineNumber;
        };
        /**
         * Clone this position.
         */
        Position.prototype.clone = function () {
            return new Position(this.lineNumber, this.column);
        };
        /**
         * Convert to a human-readable representation.
         */
        Position.prototype.toString = function () {
            return '(' + this.lineNumber + ',' + this.column + ')';
        };
        // ---
        /**
         * Create a `Position` from an `IPosition`.
         */
        Position.lift = function (pos) {
            return new Position(pos.lineNumber, pos.column);
        };
        /**
         * Test if `obj` is an `IPosition`.
         */
        Position.isIPosition = function (obj) {
            return (obj
                && (typeof obj.lineNumber === 'number')
                && (typeof obj.column === 'number'));
        };
        return Position;
    }());
    exports.Position = Position;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[3/*vs/editor/common/core/range*/], __M([0/*require*/,1/*exports*/,12/*vs/editor/common/core/position*/]), function (require, exports, position_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * A range in the editor. (startLineNumber,startColumn) is <= (endLineNumber,endColumn)
     */
    var Range = /** @class */ (function () {
        function Range(startLineNumber, startColumn, endLineNumber, endColumn) {
            if ((startLineNumber > endLineNumber) || (startLineNumber === endLineNumber && startColumn > endColumn)) {
                this.startLineNumber = endLineNumber;
                this.startColumn = endColumn;
                this.endLineNumber = startLineNumber;
                this.endColumn = startColumn;
            }
            else {
                this.startLineNumber = startLineNumber;
                this.startColumn = startColumn;
                this.endLineNumber = endLineNumber;
                this.endColumn = endColumn;
            }
        }
        /**
         * Test if this range is empty.
         */
        Range.prototype.isEmpty = function () {
            return Range.isEmpty(this);
        };
        /**
         * Test if `range` is empty.
         */
        Range.isEmpty = function (range) {
            return (range.startLineNumber === range.endLineNumber && range.startColumn === range.endColumn);
        };
        /**
         * Test if position is in this range. If the position is at the edges, will return true.
         */
        Range.prototype.containsPosition = function (position) {
            return Range.containsPosition(this, position);
        };
        /**
         * Test if `position` is in `range`. If the position is at the edges, will return true.
         */
        Range.containsPosition = function (range, position) {
            if (position.lineNumber < range.startLineNumber || position.lineNumber > range.endLineNumber) {
                return false;
            }
            if (position.lineNumber === range.startLineNumber && position.column < range.startColumn) {
                return false;
            }
            if (position.lineNumber === range.endLineNumber && position.column > range.endColumn) {
                return false;
            }
            return true;
        };
        /**
         * Test if range is in this range. If the range is equal to this range, will return true.
         */
        Range.prototype.containsRange = function (range) {
            return Range.containsRange(this, range);
        };
        /**
         * Test if `otherRange` is in `range`. If the ranges are equal, will return true.
         */
        Range.containsRange = function (range, otherRange) {
            if (otherRange.startLineNumber < range.startLineNumber || otherRange.endLineNumber < range.startLineNumber) {
                return false;
            }
            if (otherRange.startLineNumber > range.endLineNumber || otherRange.endLineNumber > range.endLineNumber) {
                return false;
            }
            if (otherRange.startLineNumber === range.startLineNumber && otherRange.startColumn < range.startColumn) {
                return false;
            }
            if (otherRange.endLineNumber === range.endLineNumber && otherRange.endColumn > range.endColumn) {
                return false;
            }
            return true;
        };
        /**
         * A reunion of the two ranges.
         * The smallest position will be used as the start point, and the largest one as the end point.
         */
        Range.prototype.plusRange = function (range) {
            return Range.plusRange(this, range);
        };
        /**
         * A reunion of the two ranges.
         * The smallest position will be used as the start point, and the largest one as the end point.
         */
        Range.plusRange = function (a, b) {
            var startLineNumber;
            var startColumn;
            var endLineNumber;
            var endColumn;
            if (b.startLineNumber < a.startLineNumber) {
                startLineNumber = b.startLineNumber;
                startColumn = b.startColumn;
            }
            else if (b.startLineNumber === a.startLineNumber) {
                startLineNumber = b.startLineNumber;
                startColumn = Math.min(b.startColumn, a.startColumn);
            }
            else {
                startLineNumber = a.startLineNumber;
                startColumn = a.startColumn;
            }
            if (b.endLineNumber > a.endLineNumber) {
                endLineNumber = b.endLineNumber;
                endColumn = b.endColumn;
            }
            else if (b.endLineNumber === a.endLineNumber) {
                endLineNumber = b.endLineNumber;
                endColumn = Math.max(b.endColumn, a.endColumn);
            }
            else {
                endLineNumber = a.endLineNumber;
                endColumn = a.endColumn;
            }
            return new Range(startLineNumber, startColumn, endLineNumber, endColumn);
        };
        /**
         * A intersection of the two ranges.
         */
        Range.prototype.intersectRanges = function (range) {
            return Range.intersectRanges(this, range);
        };
        /**
         * A intersection of the two ranges.
         */
        Range.intersectRanges = function (a, b) {
            var resultStartLineNumber = a.startLineNumber;
            var resultStartColumn = a.startColumn;
            var resultEndLineNumber = a.endLineNumber;
            var resultEndColumn = a.endColumn;
            var otherStartLineNumber = b.startLineNumber;
            var otherStartColumn = b.startColumn;
            var otherEndLineNumber = b.endLineNumber;
            var otherEndColumn = b.endColumn;
            if (resultStartLineNumber < otherStartLineNumber) {
                resultStartLineNumber = otherStartLineNumber;
                resultStartColumn = otherStartColumn;
            }
            else if (resultStartLineNumber === otherStartLineNumber) {
                resultStartColumn = Math.max(resultStartColumn, otherStartColumn);
            }
            if (resultEndLineNumber > otherEndLineNumber) {
                resultEndLineNumber = otherEndLineNumber;
                resultEndColumn = otherEndColumn;
            }
            else if (resultEndLineNumber === otherEndLineNumber) {
                resultEndColumn = Math.min(resultEndColumn, otherEndColumn);
            }
            // Check if selection is now empty
            if (resultStartLineNumber > resultEndLineNumber) {
                return null;
            }
            if (resultStartLineNumber === resultEndLineNumber && resultStartColumn > resultEndColumn) {
                return null;
            }
            return new Range(resultStartLineNumber, resultStartColumn, resultEndLineNumber, resultEndColumn);
        };
        /**
         * Test if this range equals other.
         */
        Range.prototype.equalsRange = function (other) {
            return Range.equalsRange(this, other);
        };
        /**
         * Test if range `a` equals `b`.
         */
        Range.equalsRange = function (a, b) {
            return (!!a &&
                !!b &&
                a.startLineNumber === b.startLineNumber &&
                a.startColumn === b.startColumn &&
                a.endLineNumber === b.endLineNumber &&
                a.endColumn === b.endColumn);
        };
        /**
         * Return the end position (which will be after or equal to the start position)
         */
        Range.prototype.getEndPosition = function () {
            return new position_1.Position(this.endLineNumber, this.endColumn);
        };
        /**
         * Return the start position (which will be before or equal to the end position)
         */
        Range.prototype.getStartPosition = function () {
            return new position_1.Position(this.startLineNumber, this.startColumn);
        };
        /**
         * Transform to a user presentable string representation.
         */
        Range.prototype.toString = function () {
            return '[' + this.startLineNumber + ',' + this.startColumn + ' -> ' + this.endLineNumber + ',' + this.endColumn + ']';
        };
        /**
         * Create a new range using this range's start position, and using endLineNumber and endColumn as the end position.
         */
        Range.prototype.setEndPosition = function (endLineNumber, endColumn) {
            return new Range(this.startLineNumber, this.startColumn, endLineNumber, endColumn);
        };
        /**
         * Create a new range using this range's end position, and using startLineNumber and startColumn as the start position.
         */
        Range.prototype.setStartPosition = function (startLineNumber, startColumn) {
            return new Range(startLineNumber, startColumn, this.endLineNumber, this.endColumn);
        };
        /**
         * Create a new empty range using this range's start position.
         */
        Range.prototype.collapseToStart = function () {
            return Range.collapseToStart(this);
        };
        /**
         * Create a new empty range using this range's start position.
         */
        Range.collapseToStart = function (range) {
            return new Range(range.startLineNumber, range.startColumn, range.startLineNumber, range.startColumn);
        };
        // ---
        Range.fromPositions = function (start, end) {
            if (end === void 0) { end = start; }
            return new Range(start.lineNumber, start.column, end.lineNumber, end.column);
        };
        Range.lift = function (range) {
            if (!range) {
                return null;
            }
            return new Range(range.startLineNumber, range.startColumn, range.endLineNumber, range.endColumn);
        };
        /**
         * Test if `obj` is an `IRange`.
         */
        Range.isIRange = function (obj) {
            return (obj
                && (typeof obj.startLineNumber === 'number')
                && (typeof obj.startColumn === 'number')
                && (typeof obj.endLineNumber === 'number')
                && (typeof obj.endColumn === 'number'));
        };
        /**
         * Test if the two ranges are touching in any way.
         */
        Range.areIntersectingOrTouching = function (a, b) {
            // Check if `a` is before `b`
            if (a.endLineNumber < b.startLineNumber || (a.endLineNumber === b.startLineNumber && a.endColumn < b.startColumn)) {
                return false;
            }
            // Check if `b` is before `a`
            if (b.endLineNumber < a.startLineNumber || (b.endLineNumber === a.startLineNumber && b.endColumn < a.startColumn)) {
                return false;
            }
            // These ranges must intersect
            return true;
        };
        /**
         * Test if the two ranges are intersecting. If the ranges are touching it returns true.
         */
        Range.areIntersecting = function (a, b) {
            // Check if `a` is before `b`
            if (a.endLineNumber < b.startLineNumber || (a.endLineNumber === b.startLineNumber && a.endColumn <= b.startColumn)) {
                return false;
            }
            // Check if `b` is before `a`
            if (b.endLineNumber < a.startLineNumber || (b.endLineNumber === a.startLineNumber && b.endColumn <= a.startColumn)) {
                return false;
            }
            // These ranges must intersect
            return true;
        };
        /**
         * A function that compares ranges, useful for sorting ranges
         * It will first compare ranges on the startPosition and then on the endPosition
         */
        Range.compareRangesUsingStarts = function (a, b) {
            if (a && b) {
                var aStartLineNumber = a.startLineNumber | 0;
                var bStartLineNumber = b.startLineNumber | 0;
                if (aStartLineNumber === bStartLineNumber) {
                    var aStartColumn = a.startColumn | 0;
                    var bStartColumn = b.startColumn | 0;
                    if (aStartColumn === bStartColumn) {
                        var aEndLineNumber = a.endLineNumber | 0;
                        var bEndLineNumber = b.endLineNumber | 0;
                        if (aEndLineNumber === bEndLineNumber) {
                            var aEndColumn = a.endColumn | 0;
                            var bEndColumn = b.endColumn | 0;
                            return aEndColumn - bEndColumn;
                        }
                        return aEndLineNumber - bEndLineNumber;
                    }
                    return aStartColumn - bStartColumn;
                }
                return aStartLineNumber - bStartLineNumber;
            }
            var aExists = (a ? 1 : 0);
            var bExists = (b ? 1 : 0);
            return aExists - bExists;
        };
        /**
         * A function that compares ranges, useful for sorting ranges
         * It will first compare ranges on the endPosition and then on the startPosition
         */
        Range.compareRangesUsingEnds = function (a, b) {
            if (a.endLineNumber === b.endLineNumber) {
                if (a.endColumn === b.endColumn) {
                    if (a.startLineNumber === b.startLineNumber) {
                        return a.startColumn - b.startColumn;
                    }
                    return a.startLineNumber - b.startLineNumber;
                }
                return a.endColumn - b.endColumn;
            }
            return a.endLineNumber - b.endLineNumber;
        };
        /**
         * Test if the range spans multiple lines.
         */
        Range.spansMultipleLines = function (range) {
            return range.endLineNumber > range.startLineNumber;
        };
        return Range;
    }());
    exports.Range = Range;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[173/*vs/editor/browser/controller/textAreaState*/], __M([0/*require*/,1/*exports*/,8/*vs/base/common/strings*/,12/*vs/editor/common/core/position*/,3/*vs/editor/common/core/range*/]), function (require, exports, strings, position_1, range_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var TextAreaState = /** @class */ (function () {
        function TextAreaState(value, selectionStart, selectionEnd, selectionStartPosition, selectionEndPosition) {
            this.value = value;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
            this.selectionStartPosition = selectionStartPosition;
            this.selectionEndPosition = selectionEndPosition;
        }
        TextAreaState.prototype.toString = function () {
            return '[ <' + this.value + '>, selectionStart: ' + this.selectionStart + ', selectionEnd: ' + this.selectionEnd + ']';
        };
        TextAreaState.readFromTextArea = function (textArea) {
            return new TextAreaState(textArea.getValue(), textArea.getSelectionStart(), textArea.getSelectionEnd(), null, null);
        };
        TextAreaState.prototype.collapseSelection = function () {
            return new TextAreaState(this.value, this.value.length, this.value.length, null, null);
        };
        TextAreaState.prototype.writeToTextArea = function (reason, textArea, select) {
            // console.log(Date.now() + ': writeToTextArea ' + reason + ': ' + this.toString());
            textArea.setValue(reason, this.value);
            if (select) {
                textArea.setSelectionRange(reason, this.selectionStart, this.selectionEnd);
            }
        };
        TextAreaState.prototype.deduceEditorPosition = function (offset) {
            if (offset <= this.selectionStart) {
                var str = this.value.substring(offset, this.selectionStart);
                return this._finishDeduceEditorPosition(this.selectionStartPosition, str, -1);
            }
            if (offset >= this.selectionEnd) {
                var str = this.value.substring(this.selectionEnd, offset);
                return this._finishDeduceEditorPosition(this.selectionEndPosition, str, 1);
            }
            var str1 = this.value.substring(this.selectionStart, offset);
            if (str1.indexOf(String.fromCharCode(8230)) === -1) {
                return this._finishDeduceEditorPosition(this.selectionStartPosition, str1, 1);
            }
            var str2 = this.value.substring(offset, this.selectionEnd);
            return this._finishDeduceEditorPosition(this.selectionEndPosition, str2, -1);
        };
        TextAreaState.prototype._finishDeduceEditorPosition = function (anchor, deltaText, signum) {
            var lineFeedCnt = 0;
            var lastLineFeedIndex = -1;
            while ((lastLineFeedIndex = deltaText.indexOf('\n', lastLineFeedIndex + 1)) !== -1) {
                lineFeedCnt++;
            }
            return [anchor, signum * deltaText.length, lineFeedCnt];
        };
        TextAreaState.selectedText = function (text) {
            return new TextAreaState(text, 0, text.length, null, null);
        };
        TextAreaState.deduceInput = function (previousState, currentState, couldBeEmojiInput, couldBeTypingAtOffset0) {
            if (!previousState) {
                // This is the EMPTY state
                return {
                    text: '',
                    replaceCharCnt: 0
                };
            }
            // console.log('------------------------deduceInput');
            // console.log('PREVIOUS STATE: ' + previousState.toString());
            // console.log('CURRENT STATE: ' + currentState.toString());
            var previousValue = previousState.value;
            var previousSelectionStart = previousState.selectionStart;
            var previousSelectionEnd = previousState.selectionEnd;
            var currentValue = currentState.value;
            var currentSelectionStart = currentState.selectionStart;
            var currentSelectionEnd = currentState.selectionEnd;
            if (couldBeTypingAtOffset0 && previousValue.length > 0 && previousSelectionStart === previousSelectionEnd && currentSelectionStart === currentSelectionEnd) {
                // See https://github.com/Microsoft/vscode/issues/42251
                // where typing always happens at offset 0 in the textarea
                // when using a custom title area in OSX and moving the window
                if (!strings.startsWith(currentValue, previousValue) && strings.endsWith(currentValue, previousValue)) {
                    // Looks like something was typed at offset 0
                    // ==> pretend we placed the cursor at offset 0 to begin with...
                    previousSelectionStart = 0;
                    previousSelectionEnd = 0;
                }
            }
            // Strip the previous suffix from the value (without interfering with the current selection)
            var previousSuffix = previousValue.substring(previousSelectionEnd);
            var currentSuffix = currentValue.substring(currentSelectionEnd);
            var suffixLength = strings.commonSuffixLength(previousSuffix, currentSuffix);
            currentValue = currentValue.substring(0, currentValue.length - suffixLength);
            previousValue = previousValue.substring(0, previousValue.length - suffixLength);
            var previousPrefix = previousValue.substring(0, previousSelectionStart);
            var currentPrefix = currentValue.substring(0, currentSelectionStart);
            var prefixLength = strings.commonPrefixLength(previousPrefix, currentPrefix);
            currentValue = currentValue.substring(prefixLength);
            previousValue = previousValue.substring(prefixLength);
            currentSelectionStart -= prefixLength;
            previousSelectionStart -= prefixLength;
            currentSelectionEnd -= prefixLength;
            previousSelectionEnd -= prefixLength;
            // console.log('AFTER DIFFING PREVIOUS STATE: <' + previousValue + '>, selectionStart: ' + previousSelectionStart + ', selectionEnd: ' + previousSelectionEnd);
            // console.log('AFTER DIFFING CURRENT STATE: <' + currentValue + '>, selectionStart: ' + currentSelectionStart + ', selectionEnd: ' + currentSelectionEnd);
            if (couldBeEmojiInput && currentSelectionStart === currentSelectionEnd && previousValue.length > 0) {
                // on OSX, emojis from the emoji picker are inserted at random locations
                // the only hints we can use is that the selection is immediately after the inserted emoji
                // and that none of the old text has been deleted
                var potentialEmojiInput = null;
                if (currentSelectionStart === currentValue.length) {
                    // emoji potentially inserted "somewhere" after the previous selection => it should appear at the end of `currentValue`
                    if (strings.startsWith(currentValue, previousValue)) {
                        // only if all of the old text is accounted for
                        potentialEmojiInput = currentValue.substring(previousValue.length);
                    }
                }
                else {
                    // emoji potentially inserted "somewhere" before the previous selection => it should appear at the start of `currentValue`
                    if (strings.endsWith(currentValue, previousValue)) {
                        // only if all of the old text is accounted for
                        potentialEmojiInput = currentValue.substring(0, currentValue.length - previousValue.length);
                    }
                }
                if (potentialEmojiInput !== null && potentialEmojiInput.length > 0) {
                    // now we check that this is indeed an emoji
                    // emojis can grow quite long, so a length check is of no help
                    // e.g. 1F3F4 E0067 E0062 E0065 E006E E0067 E007F  ; fully-qualified     # 🏴󠁧󠁢󠁥󠁮󠁧󠁿 England
                    // Oftentimes, emojis use Variation Selector-16 (U+FE0F), so that is a good hint
                    // http://emojipedia.org/variation-selector-16/
                    // > An invisible codepoint which specifies that the preceding character
                    // > should be displayed with emoji presentation. Only required if the
                    // > preceding character defaults to text presentation.
                    if (/\uFE0F/.test(potentialEmojiInput) || strings.containsEmoji(potentialEmojiInput)) {
                        return {
                            text: potentialEmojiInput,
                            replaceCharCnt: 0
                        };
                    }
                }
            }
            if (currentSelectionStart === currentSelectionEnd) {
                // composition accept case (noticed in FF + Japanese)
                // [blahblah] => blahblah|
                if (previousValue === currentValue
                    && previousSelectionStart === 0
                    && previousSelectionEnd === previousValue.length
                    && currentSelectionStart === currentValue.length
                    && currentValue.indexOf('\n') === -1) {
                    if (strings.containsFullWidthCharacter(currentValue)) {
                        return {
                            text: '',
                            replaceCharCnt: 0
                        };
                    }
                }
                // no current selection
                var replacePreviousCharacters_1 = (previousPrefix.length - prefixLength);
                // console.log('REMOVE PREVIOUS: ' + (previousPrefix.length - prefixLength) + ' chars');
                return {
                    text: currentValue,
                    replaceCharCnt: replacePreviousCharacters_1
                };
            }
            // there is a current selection => composition case
            var replacePreviousCharacters = previousSelectionEnd - previousSelectionStart;
            return {
                text: currentValue,
                replaceCharCnt: replacePreviousCharacters
            };
        };
        TextAreaState.EMPTY = new TextAreaState('', 0, 0, null, null);
        return TextAreaState;
    }());
    exports.TextAreaState = TextAreaState;
    var PagedScreenReaderStrategy = /** @class */ (function () {
        function PagedScreenReaderStrategy() {
        }
        PagedScreenReaderStrategy._getPageOfLine = function (lineNumber) {
            return Math.floor((lineNumber - 1) / PagedScreenReaderStrategy._LINES_PER_PAGE);
        };
        PagedScreenReaderStrategy._getRangeForPage = function (page) {
            var offset = page * PagedScreenReaderStrategy._LINES_PER_PAGE;
            var startLineNumber = offset + 1;
            var endLineNumber = offset + PagedScreenReaderStrategy._LINES_PER_PAGE;
            return new range_1.Range(startLineNumber, 1, endLineNumber + 1, 1);
        };
        PagedScreenReaderStrategy.fromEditorSelection = function (previousState, model, selection, trimLongText) {
            var selectionStartPage = PagedScreenReaderStrategy._getPageOfLine(selection.startLineNumber);
            var selectionStartPageRange = PagedScreenReaderStrategy._getRangeForPage(selectionStartPage);
            var selectionEndPage = PagedScreenReaderStrategy._getPageOfLine(selection.endLineNumber);
            var selectionEndPageRange = PagedScreenReaderStrategy._getRangeForPage(selectionEndPage);
            var pretextRange = selectionStartPageRange.intersectRanges(new range_1.Range(1, 1, selection.startLineNumber, selection.startColumn));
            var pretext = model.getValueInRange(pretextRange, 1 /* LF */);
            var lastLine = model.getLineCount();
            var lastLineMaxColumn = model.getLineMaxColumn(lastLine);
            var posttextRange = selectionEndPageRange.intersectRanges(new range_1.Range(selection.endLineNumber, selection.endColumn, lastLine, lastLineMaxColumn));
            var posttext = model.getValueInRange(posttextRange, 1 /* LF */);
            var text;
            if (selectionStartPage === selectionEndPage || selectionStartPage + 1 === selectionEndPage) {
                // take full selection
                text = model.getValueInRange(selection, 1 /* LF */);
            }
            else {
                var selectionRange1 = selectionStartPageRange.intersectRanges(selection);
                var selectionRange2 = selectionEndPageRange.intersectRanges(selection);
                text = (model.getValueInRange(selectionRange1, 1 /* LF */)
                    + String.fromCharCode(8230)
                    + model.getValueInRange(selectionRange2, 1 /* LF */));
            }
            // Chromium handles very poorly text even of a few thousand chars
            // Cut text to avoid stalling the entire UI
            if (trimLongText) {
                var LIMIT_CHARS = 500;
                if (pretext.length > LIMIT_CHARS) {
                    pretext = pretext.substring(pretext.length - LIMIT_CHARS, pretext.length);
                }
                if (posttext.length > LIMIT_CHARS) {
                    posttext = posttext.substring(0, LIMIT_CHARS);
                }
                if (text.length > 2 * LIMIT_CHARS) {
                    text = text.substring(0, LIMIT_CHARS) + String.fromCharCode(8230) + text.substring(text.length - LIMIT_CHARS, text.length);
                }
            }
            return new TextAreaState(pretext + text + posttext, pretext.length, pretext.length + text.length, new position_1.Position(selection.startLineNumber, selection.startColumn), new position_1.Position(selection.endLineNumber, selection.endColumn));
        };
        PagedScreenReaderStrategy._LINES_PER_PAGE = 10;
        return PagedScreenReaderStrategy;
    }());
    exports.PagedScreenReaderStrategy = PagedScreenReaderStrategy;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define(__m[194/*vs/editor/browser/widget/diffNavigator*/], __M([0/*require*/,1/*exports*/,135/*vs/base/common/assert*/,6/*vs/base/common/event*/,2/*vs/base/common/lifecycle*/,27/*vs/base/common/objects*/,3/*vs/editor/common/core/range*/]), function (require, exports, assert, event_1, lifecycle_1, objects, range_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var defaultOptions = {
        followsCaret: true,
        ignoreCharChanges: true,
        alwaysRevealFirst: true
    };
    /**
     * Create a new diff navigator for the provided diff editor.
     */
    var DiffNavigator = /** @class */ (function () {
        function DiffNavigator(editor, options) {
            if (options === void 0) { options = {}; }
            var _this = this;
            this._onDidUpdate = new event_1.Emitter();
            this._editor = editor;
            this._options = objects.mixin(options, defaultOptions, false);
            this.disposed = false;
            this._disposables = [];
            this.nextIdx = -1;
            this.ranges = [];
            this.ignoreSelectionChange = false;
            this.revealFirst = Boolean(this._options.alwaysRevealFirst);
            // hook up to diff editor for diff, disposal, and caret move
            this._disposables.push(this._editor.onDidDispose(function () { return _this.dispose(); }));
            this._disposables.push(this._editor.onDidUpdateDiff(function () { return _this._onDiffUpdated(); }));
            if (this._options.followsCaret) {
                this._disposables.push(this._editor.getModifiedEditor().onDidChangeCursorPosition(function (e) {
                    if (_this.ignoreSelectionChange) {
                        return;
                    }
                    _this.nextIdx = -1;
                }));
            }
            if (this._options.alwaysRevealFirst) {
                this._disposables.push(this._editor.getModifiedEditor().onDidChangeModel(function (e) {
                    _this.revealF