# generated by datamodel-codegen:
#   filename:  https://orchestrator.fleetai.com/openapi.json
#   timestamp: 2025-08-03T22:47:20+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field, conint


class CDPDescribeResponse(BaseModel):
    success: bool = Field(..., title="Success")
    url: str = Field(..., title="Url")
    devtools_url: str = Field(..., title="Devtools Url")


class ChromeStartRequest(BaseModel):
    start_page: Optional[str] = Field("about:blank", title="Start Page")
    resolution: Optional[str] = Field("1920x1080", title="Resolution")


class ChromeStartResponse(BaseModel):
    success: bool = Field(..., title="Success")
    message: str = Field(..., title="Message")


class ChromeStatusResponse(BaseModel):
    running: bool = Field(..., title="Running")
    message: str = Field(..., title="Message")


class Environment(BaseModel):
    env_key: str = Field(..., title="Env Key")
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(..., title="Description")
    default_version: Optional[str] = Field(..., title="Default Version")
    versions: Dict[str, str] = Field(..., title="Versions")


class Instance(BaseModel):
    instance_id: str = Field(..., title="Instance Id")
    env_key: str = Field(..., title="Env Key")
    version: str = Field(..., title="Version")
    status: str = Field(..., title="Status")
    subdomain: str = Field(..., title="Subdomain")
    created_at: str = Field(..., title="Created At")
    updated_at: str = Field(..., title="Updated At")
    terminated_at: Optional[str] = Field(None, title="Terminated At")
    team_id: str = Field(..., title="Team Id")
    region: str = Field(..., title="Region")
    env_variables: Optional[Dict[str, Any]] = Field(None, title="Env Variables")
    run_id: Optional[str] = Field(None, title="Run Id")


class InstanceRequest(BaseModel):
    env_key: str = Field(..., title="Env Key")
    env_version: Optional[str] = Field(None, title="Env Version")
    data_key: Optional[str] = Field(None, title="Data Key")
    data_version: Optional[str] = Field(None, title="Data Version")
    region: Optional[str] = Field("us-west-1", title="Region")
    seed: Optional[int] = Field(None, title="Seed")
    timestamp: Optional[int] = Field(None, title="Timestamp")
    p_error: Optional[float] = Field(None, title="P Error")
    avg_latency: Optional[float] = Field(None, title="Avg Latency")
    run_id: Optional[str] = Field(None, title="Run Id")
    task_id: Optional[str] = Field(None, title="Task Id")
    force_pull: Optional[bool] = Field(None, title="Force Pull")
    env_variables: Optional[Dict[str, Any]] = Field(None, title="Env Variables")
    image_type: Optional[str] = Field(None, title="Image Type")
    created_from: Optional[str] = Field(None, title="Created From")
    ttl_seconds: Optional[int] = Field(None, title="TTL Seconds")
    heartbeat_interval: Optional[int] = Field(None, title="Heartbeat Interval")


class InstanceStatus(Enum):
    pending = "pending"
    running = "running"
    stopped = "stopped"
    error = "error"


class ManagerURLs(BaseModel):
    api: str = Field(..., title="Api")
    docs: str = Field(..., title="Docs")
    reset: str = Field(..., title="Reset")
    diff: str = Field(..., title="Diff")
    snapshot: str = Field(..., title="Snapshot")
    execute_verifier_function: str = Field(..., title="Execute Verifier Function")
    execute_verifier_function_with_upload: str = Field(
        ..., title="Execute Verifier Function With Upload"
    )


class QueryRequest(BaseModel):
    query: str = Field(..., title="Query")
    args: Optional[List] = Field(None, title="Args")
    read_only: Optional[bool] = Field(True, title="Read Only")


class QueryResponse(BaseModel):
    success: bool = Field(..., title="Success")
    columns: Optional[List[str]] = Field(None, title="Columns")
    rows: Optional[List[List]] = Field(None, title="Rows")
    rows_affected: Optional[int] = Field(None, title="Rows Affected")
    last_insert_id: Optional[int] = Field(None, title="Last Insert Id")
    error: Optional[str] = Field(None, title="Error")
    message: str = Field(..., title="Message")


class RecreateResponse(BaseModel):
    success: bool = Field(..., title="Success")
    instance_id: str = Field(..., title="Instance Id")
    env_key: str = Field(..., title="Env Key")
    version: str = Field(..., title="Version")
    recreated_at: str = Field(..., title="Recreated At")


class ResourceMode(Enum):
    ro = "ro"
    rw = "rw"


class ResourceType(Enum):
    sqlite = "sqlite"
    cdp = "cdp"


class RestoreRequest(BaseModel):
    backup_id: Optional[str] = Field(None, title="Backup Id")


class RestoreResponse(BaseModel):
    success: bool = Field(..., title="Success")
    backup_id: str = Field(..., title="Backup Id")
    source_instance_id: str = Field(..., title="Source Instance Id")
    target_instance_id: str = Field(..., title="Target Instance Id")
    restored_at: str = Field(..., title="Restored At")


class SnapshotResponse(BaseModel):
    success: bool = Field(..., title="Success")
    backup_id: str = Field(..., title="Backup Id")
    instance_id: str = Field(..., title="Instance Id")
    s3_key: str = Field(..., title="S3 Key")
    created_at: str = Field(..., title="Created At")


class TableSchema(BaseModel):
    name: str = Field(..., title="Name")
    sql: str = Field(..., title="Sql")
    columns: List[Dict[str, Any]] = Field(..., title="Columns")


class TaskRequest(BaseModel):
    key: str = Field(..., title="Key")
    prompt: str = Field(..., title="Prompt")
    environment_id: str = Field(..., title="Environment Id")
    verifier_id: Optional[str] = Field(None, title="Verifier Id")
    version: Optional[str] = Field(None, title="Version")
    env_variables: Optional[Dict[str, Any]] = Field(None, title="Env Variables")
    metadata: Optional[Dict[str, Any]] = Field(None, title="Metadata")
    writer_metadata: Optional[Dict[str, Any]] = Field(
        None, title="Writer Metadata", description="Metadata filled by task writer"
    )
    output_json_schema: Optional[Dict[str, Any]] = Field(
        None, title="Output Json Schema"
    )


class TaskUpdateRequest(BaseModel):
    prompt: Optional[str] = Field(None, title="Prompt")
    verifier_code: Optional[str] = Field(None, title="Verifier Code")
    metadata: Optional[Dict[str, Any]] = Field(None, title="Metadata")
    writer_metadata: Optional[Dict[str, Any]] = Field(
        None, title="Writer Metadata", description="Metadata filled by task writer"
    )
    qa_metadata: Optional[Dict[str, Any]] = Field(
        None, title="QA Metadata", description="Metadata filled by QA reviewer"
    )


class VerifierData(BaseModel):
    verifier_id: str = Field(..., title="Verifier Id")
    key: str = Field(..., title="Key")
    version: int = Field(..., title="Version")
    sha256: str = Field(..., title="Sha256")
    code: str = Field(..., title="Code")
    comment: Optional[str] = Field(None, title="Comment")
    created_at: str = Field(..., title="Created At")


class TaskResponse(BaseModel):
    key: str = Field(..., title="Key")
    prompt: str = Field(..., title="Prompt")
    team_id: str = Field(..., title="Team Id")
    environment_id: str = Field(..., title="Environment Id")
    created_at: str = Field(..., title="Created At")
    verifier_id: Optional[str] = Field(None, title="Verifier Id")
    verifier_func: Optional[str] = Field(None, title="Verifier Func")
    version: Optional[str] = Field(None, title="Version")
    data_id: Optional[str] = Field(None, title="Data Id")
    data_version: Optional[str] = Field(None, title="Data Version")
    env_variables: Optional[Dict[str, Any]] = Field(None, title="Env Variables")
    verifier: Optional[VerifierData] = Field(None, title="Verifier")
    metadata: Optional[Dict[str, Any]] = Field(None, title="Metadata")
    writer_metadata: Optional[Dict[str, Any]] = Field(None, title="Writer Metadata")
    qa_metadata: Optional[Dict[str, Any]] = Field(None, title="QA Metadata")
    output_json_schema: Optional[Dict[str, Any]] = Field(
        None, title="Output Json Schema"
    )


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title="Location")
    msg: str = Field(..., title="Message")
    type: str = Field(..., title="Error Type")


class VerifiersCheckResponse(BaseModel):
    key: Optional[str] = Field(
        None, description="Key of the verifier artifact", title="Key"
    )
    version: Optional[int] = Field(
        None, description="Version of the verifier artifact", title="Version"
    )
    display_src: Optional[str] = Field(
        None, description="Display source code of the verifier", title="Display Src"
    )
    created_at: Optional[str] = Field(
        None, description="Creation timestamp", title="Created At"
    )
    comment: Optional[str] = Field(
        None, description="Comment about the verifier", title="Comment"
    )
    success: bool = Field(
        ..., description="Whether the verification was successful", title="Success"
    )


class VerifiersExecuteRequest(BaseModel):
    key: Optional[str] = Field(
        None, description="Key of the verifier artifact", title="Key"
    )
    sha256: Optional[str] = Field(
        None,
        description="SHA256 hash of the function (auto-generated if bundle is provided)",
        title="Sha256",
    )
    bundle: Optional[str] = Field(
        None, description="Base64 encoded bundle data", title="Bundle"
    )
    args: Optional[str] = Field(
        None, description="Base64 encoded cloudpickled args", title="Args"
    )
    args_array: Optional[List] = Field(
        None,
        description="Array of argument values to pass to the function",
        title="Args Array",
    )
    function_name: Optional[str] = Field(
        "verify", description="Name of the function to execute", title="Function Name"
    )
    timeout: Optional[conint(ge=1, le=300)] = Field(
        60, description="Execution timeout in seconds", title="Timeout"
    )
    region: Optional[str] = Field(
        None, description="AWS region for execution", title="Region"
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None, description="Additional metadata", title="Metadata"
    )
    comment: Optional[str] = Field(
        None, description="Comment about the function", title="Comment"
    )
    display_src: Optional[str] = Field(
        None, description="Display source code", title="Display Src"
    )


class VerifiersExecuteResponse(BaseModel):
    key: Optional[str] = Field(
        None, description="Key of the verifier artifact", title="Key"
    )
    version: Optional[int] = Field(
        None, description="Version of the verifier artifact", title="Version"
    )
    display_src: Optional[str] = Field(
        None, description="Display source code of the verifier", title="Display Src"
    )
    created_at: Optional[str] = Field(
        None, description="Creation timestamp", title="Created At"
    )
    comment: Optional[str] = Field(
        None, description="Comment about the verifier", title="Comment"
    )
    success: bool = Field(
        ..., description="Whether the verification was successful", title="Success"
    )
    result: Optional[Any] = Field(
        None, description="The return value of the function", title="Result"
    )
    verifier_id: Optional[str] = Field(
        None, description="ID of the verifier", title="Verifier Id"
    )
    execution_id: Optional[str] = Field(
        None, description="ID of the execution record", title="Execution Id"
    )
    error: Optional[Dict[str, Any]] = Field(
        None, description="Error details if verification failed", title="Error"
    )
    execution_time_ms: int = Field(
        ..., description="Execution time in milliseconds", title="Execution Time Ms"
    )
    bundle_cache_hit: Optional[bool] = Field(
        False,
        description="Whether the bundle was already cached",
        title="Bundle Cache Hit",
    )
    stdout: Optional[str] = Field(
        None, description="Captured stdout from execution", title="Stdout"
    )


class DescribeResponse(BaseModel):
    success: bool = Field(..., title="Success")
    resource_name: str = Field(..., title="Resource Name")
    tables: Optional[List[TableSchema]] = Field(None, title="Tables")
    error: Optional[str] = Field(None, title="Error")
    message: str = Field(..., title="Message")


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title="Detail")


class InstanceURLs(BaseModel):
    root: str = Field(..., title="Root")
    app: List[str] = Field(..., title="App")
    api: Optional[str] = Field(None, title="Api")
    health: Optional[str] = Field(None, title="Health")
    api_docs: Optional[str] = Field(None, title="Api Docs")
    manager: ManagerURLs


class Resource(BaseModel):
    name: str = Field(..., title="Name")
    type: ResourceType
    mode: ResourceMode
    label: Optional[str] = Field(None, title="Label")


class ResourcesResponse(BaseModel):
    resources: List[Resource] = Field(..., title="Resources")


class TaskListResponse(BaseModel):
    tasks: List[TaskResponse] = Field(..., title="Tasks")
    total: int = Field(..., title="Total")


class InstanceResponse(BaseModel):
    instance_id: str = Field(..., title="Instance Id")
    env_key: str = Field(..., title="Env Key")
    version: str = Field(..., title="Version")
    status: str = Field(..., title="Status")
    subdomain: str = Field(..., title="Subdomain")
    created_at: str = Field(..., title="Created At")
    updated_at: str = Field(..., title="Updated At")
    terminated_at: Optional[str] = Field(None, title="Terminated At")
    team_id: str = Field(..., title="Team Id")
    region: str = Field(..., title="Region")
    env_variables: Optional[Dict[str, Any]] = Field(None, title="Env Variables")
    data_key: Optional[str] = Field(None, title="Data Key")
    data_version: Optional[str] = Field(None, title="Data Version")
    urls: Optional[InstanceURLs] = Field(None, title="Urls")
    health: Optional[bool] = Field(None, title="Health")
    run_id: Optional[str] = Field(None, title="Run Id")
    profile_id: Optional[str] = Field(None, title="Profile Id")
    heartbeat_interval: Optional[int] = Field(None, title="Heartbeat Interval")
    heartbeat_region: Optional[str] = Field(None, title="Heartbeat Region")


class Run(BaseModel):
    run_id: str = Field(..., title="Run Id")
    running_count: int = Field(..., title="Running Count")
    total_count: int = Field(..., title="Total Count")
    first_created_at: str = Field(..., title="First Created At")
    last_created_at: str = Field(..., title="Last Created At")
    profile_id: Optional[str] = Field(None, title="Profile Id")


class HeartbeatResponse(BaseModel):
    """Response from bumping an instance heartbeat."""
    
    success: bool = Field(..., description="Whether the heartbeat was successfully updated")
    instance_id: str = Field(..., description="The instance ID")
    last_heartbeat: Optional[str] = Field(
        None,
        description="ISO 8601 UTC timestamp of the heartbeat (None if not enabled)",
    )
    deadline_timestamp: Optional[float] = Field(
        None,
        description="Unix timestamp when next heartbeat is due (None if not enabled)",
    )
    interval_seconds: Optional[int] = Field(
        None, description="Heartbeat interval in seconds (None if not enabled)"
    )


class AccountResponse(BaseModel):
    team_id: str = Field(..., title="Team Id")
    team_name: str = Field(..., title="Team Name")
    instance_limit: int = Field(..., title="Instance Limit")
    instance_count: int = Field(..., title="Instance Count")
    profile_id: Optional[str] = Field(None, title="Profile Id")
    profile_name: Optional[str] = Field(None, title="Profile Name")


# Jobs and Sessions models


class JobCreateRequest(BaseModel):
    """Request payload for creating a new job.

    The name field supports placeholders:
    - {id}: Replaced with a full UUID
    - {sid}: Replaced with the first 8 characters of a UUID (short ID)
    - {i}: Replaced with auto-incrementing number (must be a suffix, e.g., "job-{i}")
    """

    name: Optional[str] = Field(None, title="Name", max_length=255)
    models: List[str] = Field(..., title="Models", min_length=1)
    pass_k: int = Field(1, title="Pass K", ge=1)
    env_key: Optional[str] = Field(None, title="Env Key")
    project_key: Optional[str] = Field(None, title="Project Key")
    task_keys: Optional[List[str]] = Field(None, title="Task Keys", min_length=1)
    excluded_task_keys: Optional[List[str]] = Field(None, title="Excluded Task Keys")
    max_steps: Optional[int] = Field(None, title="Max Steps", ge=1)
    max_duration_minutes: int = Field(60, title="Max Duration Minutes", ge=1)
    max_concurrent_per_model: int = Field(30, title="Max Concurrent Per Model", ge=1)
    mode: Optional[str] = Field(None, title="Mode")
    system_prompt: Optional[str] = Field(None, title="System Prompt")
    model_prompts: Optional[Dict[str, str]] = Field(None, title="Model Prompts")
    byok_keys: Optional[Dict[str, str]] = Field(None, title="BYOK Keys")
    byok_ttl_minutes: Optional[int] = Field(None, title="BYOK TTL Minutes", ge=1)
    harness: Optional[str] = Field(None, title="Harness")


class JobResponse(BaseModel):
    """Response for a single job."""

    id: str = Field(..., title="Id")
    name: Optional[str] = Field(None, title="Name")
    created_at: Optional[str] = Field(None, title="Created At")
    status: Optional[str] = Field(None, title="Status")


class JobListResponse(BaseModel):
    """Response for listing jobs."""

    jobs: List[JobResponse] = Field(..., title="Jobs")
    total: int = Field(..., title="Total")


class JobCreateResponse(BaseModel):
    """Response from creating a job."""

    job_id: str = Field(..., title="Job Id")
    workflow_job_id: Optional[str] = Field(None, title="Workflow Job Id")
    status: str = Field(..., title="Status")
    name: Optional[str] = Field(None, title="Name")


class VerifierExecutionResult(BaseModel):
    """Verifier execution result for a session."""

    success: bool = Field(..., title="Success")
    score: Optional[float] = Field(None, title="Score")
    stdout: Optional[str] = Field(None, title="Stdout")
    execution_time_ms: int = Field(..., title="Execution Time Ms")
    result: Optional[Any] = Field(None, title="Result")


class SessionInfo(BaseModel):
    """Session information within a job."""

    session_id: str = Field(..., title="Session Id")
    instance: Optional[Instance] = Field(None, title="Instance")
    model: str = Field(..., title="Model")
    status: str = Field(..., title="Status")
    created_at: str = Field(..., title="Created At")
    started_at: Optional[str] = Field(None, title="Started At")
    ended_at: Optional[str] = Field(None, title="Ended At")
    step_count: int = Field(..., title="Step Count")
    verifier_execution: Optional[VerifierExecutionResult] = Field(
        None, title="Verifier Execution"
    )


class TaskInfo(BaseModel):
    """Task information for session transcript."""

    key: str = Field(..., title="Key")
    prompt: str = Field(..., title="Prompt")
    env_id: str = Field(..., title="Env Id")
    env_variables: Optional[Dict[str, Any]] = Field(None, title="Env Variables")
    created_at: Optional[str] = Field(None, title="Created At")
    version: Optional[str] = Field(None, title="Version")
    verifier_func: Optional[str] = Field(None, title="Verifier Func")
    verifier_id: Optional[str] = Field(None, title="Verifier Id")
    metadata: Optional[Dict[str, Any]] = Field(None, title="Metadata")
    writer_metadata: Optional[Dict[str, Any]] = Field(None, title="Writer Metadata")
    qa_metadata: Optional[Dict[str, Any]] = Field(None, title="QA Metadata")


class TaskSessionGroup(BaseModel):
    """Sessions grouped by task."""

    task_id: Optional[str] = Field(None, title="Task Id")
    task: Optional[TaskInfo] = Field(None, title="Task")
    total_sessions: int = Field(..., title="Total Sessions")
    passed_sessions: int = Field(..., title="Passed Sessions")
    pass_rate: float = Field(..., title="Pass Rate")
    average_score: Optional[float] = Field(None, title="Average Score")
    sessions: List[SessionInfo] = Field(..., title="Sessions")


class JobSessionsResponse(BaseModel):
    """Response for listing sessions for a job."""

    job_id: str = Field(..., title="Job Id")
    total_sessions: int = Field(..., title="Total Sessions")
    tasks: List[TaskSessionGroup] = Field(..., title="Tasks")


class TranscriptMessage(BaseModel):
    """A message in the session transcript."""

    role: str = Field(..., title="Role")
    content: Any = Field(..., title="Content")
    tool_calls: Optional[List[Any]] = Field(None, title="Tool Calls")
    tool_call_id: Optional[str] = Field(None, title="Tool Call Id")


class SessionTranscriptResponse(BaseModel):
    """Response for a session transcript."""

    task: Optional[TaskInfo] = Field(None, title="Task")
    instance: Optional[Instance] = Field(None, title="Instance")
    verifier_execution: Optional[VerifierExecutionResult] = Field(
        None, title="Verifier Execution"
    )
    transcript: List[TranscriptMessage] = Field(..., title="Transcript")


# Eval Job models (for local CLI runs with remote logging)


class EvalJobCreateRequest(BaseModel):
    """Request to create an eval job for local CLI runs."""

    project_key: Optional[str] = Field(None, title="Project Key")
    task_keys: Optional[List[str]] = Field(None, title="Task Keys")
    model: str = Field(..., title="Model")
    agent: str = Field(..., title="Agent")
    source: str = Field("local_cli", title="Source")
    metadata: Optional[Dict[str, Any]] = Field(None, title="Metadata")


class EvalJobCreateResponse(BaseModel):
    """Response from creating an eval job."""

    job_id: str = Field(..., title="Job Id")
    status: str = Field(..., title="Status")


class EvalEvent(BaseModel):
    """A single eval event."""

    type: str = Field(..., title="Event Type")
    timestamp: str = Field(..., title="Timestamp")
    task_key: Optional[str] = Field(None, title="Task Key")
    session_id: Optional[str] = Field(None, title="Session Id")
    data: Dict[str, Any] = Field(default_factory=dict, title="Data")
    duration_ms: Optional[int] = Field(None, title="Duration Ms")


class EvalEventsRequest(BaseModel):
    """Request to upload eval events."""

    job_id: str = Field(..., title="Job Id")
    events: List[EvalEvent] = Field(..., title="Events")


class EvalEventsResponse(BaseModel):
    """Response from uploading eval events."""

    received: int = Field(..., title="Received Count")
    status: str = Field(..., title="Status")


# Session Ingest models


class SessionStatus(str, Enum):
    """Status of a session."""

    pending = "pending"
    running = "running"
    completed = "completed"
    failed = "failed"
    cancelled = "cancelled"


class SessionIngestMessage(BaseModel):
    """A message to ingest into a session."""

    role: str = Field(..., title="Role", description="Message role (user, assistant, tool, etc.)")
    content: Optional[Any] = Field(None, title="Content", description="Message content (string or structured)")
    thinking: Optional[str] = Field(None, title="Thinking", description="Model reasoning/thinking trace")
    tool_calls: Optional[List[Dict[str, Any]]] = Field(None, title="Tool Calls")
    tool_call_id: Optional[str] = Field(None, title="Tool Call Id")
    timestamp: Optional[str] = Field(None, title="Timestamp")
    tokens: Optional[int] = Field(None, title="Tokens")
    metadata: Optional[Dict[str, Any]] = Field(None, title="Metadata")


class SessionIngestRequest(BaseModel):
    """Request to ingest session data.

    Can be used to:
    - Create a new session (omit session_id)
    - Append to an existing session (provide session_id)
    """

    messages: List[SessionIngestMessage] = Field(..., title="Messages", min_length=1)
    session_id: Optional[str] = Field(None, title="Session Id", description="Existing session ID to append to")
    team_id: Optional[str] = Field(None, title="Team Id")
    model: Optional[str] = Field(None, title="Model", description="Model identifier (e.g., anthropic/claude-sonnet-4)")
    task_key: Optional[str] = Field(None, title="Task Key")
    job_id: Optional[str] = Field(None, title="Job Id")
    instance_id: Optional[str] = Field(None, title="Instance Id")
    status: Optional[SessionStatus] = Field(None, title="Status")
    metadata: Optional[Dict[str, Any]] = Field(None, title="Metadata")
    started_at: Optional[str] = Field(None, title="Started At")
    ended_at: Optional[str] = Field(None, title="Ended At")
    verifier_execution_id: Optional[str] = Field(None, title="Verifier Execution Id", description="ID of the verifier execution record")


class SessionIngestResponse(BaseModel):
    """Response from ingesting session data."""

    success: bool = Field(..., title="Success")
    session_id: str = Field(..., title="Session Id")
    message_count: int = Field(..., title="Message Count", description="Total messages in session")
    created_new_session: bool = Field(..., title="Created New Session", description="True if a new session was created")


class TraceJobRequest(BaseModel):
    """Request to create a new trace job."""

    name: Optional[str] = Field(None, title="Name", description="Name of the job (generated server-side if not provided)")


class TraceJobResponse(BaseModel):
    """Response from creating a trace job."""

    job_id: str = Field(..., title="Job Id")
    name: str = Field(..., title="Name")
    status: str = Field(..., title="Status")
