# generated by datamodel-codegen:
#   filename:  http://0.0.0.0:8000/openapi.json
#   timestamp: 2025-07-20T02:00:30+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union, Tuple

from pydantic import BaseModel, Field, conint

class ToolLogEntry(BaseModel):
    id: int
    timestamp: str
    tool_name: str
    action: str
    parameters: Dict[str, Any]
    result: Optional[Dict[str, Any]] = None
    success: bool = True
    error: Optional[str] = None
    duration_ms: Optional[int] = None
    session_id: Optional[str] = None
    user_agent: Optional[str] = None


class ActionLogEntry(BaseModel):
    id: int
    timestamp: str
    action_type: str
    payload: str
    sql: Optional[str] = None
    args: Optional[str] = None
    path: Optional[str] = None


class EnvironmentSnapshot(BaseModel):
    env_key: str
    instance_id: str
    timestamp: str
    session_id: str
    tool_logs: List[ToolLogEntry]
    action_logs: List[ActionLogEntry]
    page_url: str
    viewport_size: Tuple[int, int]
    metadata: Dict[str, Any] = {}


class SnapshotValidation(BaseModel):
    success: bool
    page_match: bool
    action_log_match: bool
    discrepancies: List[str] = []
    message: str


class ToolLogResponse(BaseModel):
    success: bool
    log_id: Optional[int] = None
    message: str


class ToolSessionStartRequest(BaseModel):
    session_id: str
    metadata: Optional[Dict[str, Any]] = None


class ToolSessionStartResponse(BaseModel):
    success: bool
    session_id: str
    message: str


class ToolLogQueryRequest(BaseModel):
    tool_name: Optional[str] = None
    action: Optional[str] = None
    session_id: Optional[str] = None
    start_time: Optional[str] = None
    end_time: Optional[str] = None
    limit: Optional[int] = 10000
    offset: int = 0

class Environment(BaseModel):
    env_key: str = Field(..., title="Env Key")
    name: str = Field(..., title="Name")
    description: Optional[str] = Field(..., title="Description")
    default_version: Optional[str] = Field(..., title="Default Version")
    versions: Dict[str, str] = Field(..., title="Versions")


class Instance(BaseModel):
    instance_id: str = Field(..., title="Instance Id")
    env_key: str = Field(..., title="Env Key")
    version: str = Field(..., title="Version")
    status: str = Field(..., title="Status")
    subdomain: str = Field(..., title="Subdomain")
    created_at: str = Field(..., title="Created At")
    updated_at: str = Field(..., title="Updated At")
    terminated_at: Optional[str] = Field(None, title="Terminated At")
    team_id: str = Field(..., title="Team Id")
    region: str = Field(..., title="Region")


class InstanceRequest(BaseModel):
    env_key: str = Field(..., title="Env Key")
    version: Optional[str] = Field(None, title="Version")
    region: Optional[str] = Field("us-east-2", title="Region")
    seed: Optional[int] = Field(None, title="Seed")
    timestamp: Optional[int] = Field(None, title="Timestamp")
    p_error: Optional[float] = Field(None, title="P Error")
    avg_latency: Optional[float] = Field(None, title="Avg Latency")
    run_id: Optional[str] = Field(None, title="Run Id")
    task_id: Optional[str] = Field(None, title="Task Id")


class InstanceStatus(Enum):
    pending = "pending"
    running = "running"
    stopped = "stopped"
    error = "error"


class ManagerURLs(BaseModel):
    api: str = Field(..., title="Api")
    docs: str = Field(..., title="Docs")
    reset: str = Field(..., title="Reset")
    diff: str = Field(..., title="Diff")
    snapshot: str = Field(..., title="Snapshot")
    execute_verifier_function: str = Field(..., title="Execute Verifier Function")
    execute_verifier_function_with_upload: str = Field(
        ..., title="Execute Verifier Function With Upload"
    )


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title="Location")
    msg: str = Field(..., title="Message")
    type: str = Field(..., title="Error Type")


class VerifiersCheckResponse(BaseModel):
    key: Optional[str] = Field(
        None, description="Verifier artifact key", title="Key"
    )
    version: Optional[int] = Field(
        None, description="Version of the verifier artifact", title="Version"
    )
    display_src: Optional[str] = Field(
        None, description="Display source code of the verifier", title="Display Src"
    )
    created_at: Optional[str] = Field(
        None, description="Creation timestamp", title="Created At"
    )
    created_by: Optional[str] = Field(
        None, description="Creator of the verifier", title="Created By"
    )
    comment: Optional[str] = Field(
        None, description="Comment about the verifier", title="Comment"
    )
    success: bool = Field(
        ..., description="Whether the verification was successful", title="Success"
    )


class VerifiersExecuteRequest(BaseModel):
    sha256: str = Field(..., description="SHA256 hash of the function", title="SHA256")
    key: Optional[str] = Field(None, description="Verifier key", title="Key")
    bundle: Optional[str] = Field(None, description="Base64 encoded bundle data", title="Bundle")
    args: Optional[str] = Field(None, description="Base64 encoded arguments", title="Args")
    function_name: Optional[str] = Field(
        "verify", description="Name of the function to execute", title="Function Name"
    )
    timeout: Optional[conint(ge=1, le=300)] = Field(
        60, description="Execution timeout in seconds", title="Timeout"
    )
    region: Optional[str] = Field(
        None, description="AWS region for execution", title="Region"
    )


class VerifiersExecuteResponse(BaseModel):
    key: Optional[str] = Field(
        None, description="Key of the verifier artifact", title="Key"
    )
    version: Optional[int] = Field(
        None, description="Version of the verifier artifact", title="Version"
    )
    display_src: Optional[str] = Field(
        None, description="Display source code of the verifier", title="Display Src"
    )
    created_at: Optional[str] = Field(
        None, description="Creation timestamp", title="Created At"
    )
    comment: Optional[str] = Field(
        None, description="Comment about the verifier", title="Comment"
    )
    success: bool = Field(
        ..., description="Whether the verification was successful", title="Success"
    )
    result: Any = Field(
        ..., description="The return value of the function", title="Result"
    )
    error: Optional[Dict[str, Any]] = Field(
        None, description="Error details if verification failed", title="Error"
    )
    execution_time_ms: int = Field(
        ..., description="Execution time in milliseconds", title="Execution Time Ms"
    )
    bundle_cache_hit: bool = Field(
        False,
        description="Whether the bundle was already cached",
        title="Bundle Cache Hit",
    )


class VerificationResponse(BaseModel):
    success: bool = Field(
        ..., description="Whether the verification was successful", title="Success"
    )
    result: Optional[Any] = Field(
        None, description="The return value of the function", title="Result"
    )
    error: Optional[Dict[str, Any]] = Field(
        None, description="Error details if verification failed", title="Error"
    )
    execution_time_ms: int = Field(
        ..., description="Execution time in milliseconds", title="Execution Time Ms"
    )
    bundle_cache_hit: Optional[bool] = Field(
        False,
        description="Whether the bundle was already cached",
        title="Bundle Cache Hit",
    )
    meta: Optional[Dict[str, Any]] = Field(
        None, description="Metadata about the execution", title="Meta"
    )


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title="Detail")


class InstanceURLs(BaseModel):
    root: str = Field(..., title="Root")
    app: str = Field(..., title="App")
    api: Optional[str] = Field(None, title="Api")
    health: Optional[str] = Field(None, title="Health")
    api_docs: Optional[str] = Field(None, title="Api Docs")
    manager: ManagerURLs


class InstanceResponse(BaseModel):
    instance_id: str = Field(..., title="Instance Id")
    env_key: str = Field(..., title="Env Key")
    version: str = Field(..., title="Version")
    status: str = Field(..., title="Status")
    subdomain: str = Field(..., title="Subdomain")
    created_at: str = Field(..., title="Created At")
    updated_at: str = Field(..., title="Updated At")
    terminated_at: Optional[str] = Field(None, title="Terminated At")
    team_id: str = Field(..., title="Team Id")
    region: str = Field(..., title="Region")
    urls: InstanceURLs
    health: Optional[bool] = Field(None, title="Health")


class InstanceRecord(BaseModel):
    instance_id: str
    env_key: str
    version: str
    status: str
    subdomain: str
    created_at: str
    updated_at: str
    terminated_at: Optional[str] = None
    team_id: str
    region: str
