# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fooocusapi_client.models.async_job_stage import AsyncJobStage
from fooocusapi_client.models.job_result import JobResult
from fooocusapi_client.models.job_status import JobStatus
from fooocusapi_client.models.job_step_preview import JobStepPreview
from fooocusapi_client.models.task_type import TaskType
from typing import Optional, Set
from typing_extensions import Self

class AsyncJobResponse(BaseModel):
    """
    AsyncJobResponse
    """ # noqa: E501
    job_id: StrictStr = Field(description="Job ID")
    job_type: TaskType = Field(description="Job type")
    job_stage: AsyncJobStage = Field(description="Job running stage")
    job_progress: StrictInt = Field(description="Job running progress, 100 is for finished.")
    job_status: Optional[JobStatus] = None
    job_step_preview: Optional[JobStepPreview] = None
    job_result: Optional[JobResult] = None
    __properties: ClassVar[List[str]] = ["job_id", "job_type", "job_stage", "job_progress", "job_status", "job_step_preview", "job_result"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AsyncJobResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of job_status
        if self.job_status:
            _dict['job_status'] = self.job_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of job_step_preview
        if self.job_step_preview:
            _dict['job_step_preview'] = self.job_step_preview.to_dict()
        # override the default output from pydantic by calling `to_dict()` of job_result
        if self.job_result:
            _dict['job_result'] = self.job_result.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AsyncJobResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "job_id": obj.get("job_id"),
            "job_type": obj.get("job_type"),
            "job_stage": obj.get("job_stage"),
            "job_progress": obj.get("job_progress"),
            "job_status": JobStatus.from_dict(obj["job_status"]) if obj.get("job_status") is not None else None,
            "job_step_preview": JobStepPreview.from_dict(obj["job_step_preview"]) if obj.get("job_step_preview") is not None else None,
            "job_result": JobResult.from_dict(obj["job_result"]) if obj.get("job_result") is not None else None
        })
        return _obj


