# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from fooocusapi_client.models.img_inpaint_or_outpaint_request_json_advanced_params import ImgInpaintOrOutpaintRequestJsonAdvancedParams
from fooocusapi_client.models.img_inpaint_or_outpaint_request_json_image_prompts_inner import ImgInpaintOrOutpaintRequestJsonImagePromptsInner
from fooocusapi_client.models.inpaint_additional_prompt1 import InpaintAdditionalPrompt1
from fooocusapi_client.models.input_mask import InputMask
from fooocusapi_client.models.lora import Lora
from fooocusapi_client.models.outpaint_distance_bottom import OutpaintDistanceBottom
from fooocusapi_client.models.outpaint_distance_left import OutpaintDistanceLeft
from fooocusapi_client.models.outpaint_distance_right import OutpaintDistanceRight
from fooocusapi_client.models.outpaint_distance_top import OutpaintDistanceTop
from fooocusapi_client.models.outpaint_expansion import OutpaintExpansion
from fooocusapi_client.models.perfomance_selection import PerfomanceSelection
from fooocusapi_client.models.webhook_url import WebhookUrl
from typing import Optional, Set
from typing_extensions import Self

class ImgInpaintOrOutpaintRequestJson(BaseModel):
    """
    ImgInpaintOrOutpaintRequestJson
    """ # noqa: E501
    prompt: Optional[StrictStr] = ''
    negative_prompt: Optional[StrictStr] = ''
    style_selections: Optional[List[StrictStr]] = None
    performance_selection: Optional[PerfomanceSelection] = None
    aspect_ratios_selection: Optional[StrictStr] = '1152*896'
    image_number: Optional[Annotated[int, Field(le=32, strict=True, ge=1)]] = Field(default=1, description="Image number")
    image_seed: Optional[StrictInt] = Field(default=-1, description="Seed to generate image, -1 for random")
    sharpness: Optional[Union[Annotated[float, Field(le=30.0, strict=True, ge=0.0)], Annotated[int, Field(le=30, strict=True, ge=0)]]] = 2.0
    guidance_scale: Optional[Union[Annotated[float, Field(le=30.0, strict=True, ge=1.0)], Annotated[int, Field(le=30, strict=True, ge=1)]]] = 4.0
    base_model_name: Optional[StrictStr] = 'juggernautXL_version6Rundiffusion.safetensors'
    refiner_model_name: Optional[StrictStr] = 'None'
    refiner_switch: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=0.1)], Annotated[int, Field(le=1, strict=True, ge=1)]]] = Field(default=0.5, description="Refiner Switch At")
    loras: Optional[List[Lora]] = None
    advanced_params: Optional[ImgInpaintOrOutpaintRequestJsonAdvancedParams] = None
    require_base64: Optional[StrictBool] = Field(default=False, description="Return base64 data of generated image")
    async_process: Optional[StrictBool] = Field(default=False, description="Set to true will run async and return job info for retrieve generataion result later")
    webhook_url: Optional[WebhookUrl] = None
    input_image: StrictStr = Field(description="Init image for inpaint or outpaint as base64")
    input_mask: Optional[InputMask] = None
    inpaint_additional_prompt: Optional[InpaintAdditionalPrompt1] = None
    outpaint_selections: Optional[List[OutpaintExpansion]] = None
    outpaint_distance_left: Optional[OutpaintDistanceLeft] = None
    outpaint_distance_right: Optional[OutpaintDistanceRight] = None
    outpaint_distance_top: Optional[OutpaintDistanceTop] = None
    outpaint_distance_bottom: Optional[OutpaintDistanceBottom] = None
    image_prompts: Optional[List[ImgInpaintOrOutpaintRequestJsonImagePromptsInner]] = None
    __properties: ClassVar[List[str]] = ["prompt", "negative_prompt", "style_selections", "performance_selection", "aspect_ratios_selection", "image_number", "image_seed", "sharpness", "guidance_scale", "base_model_name", "refiner_model_name", "refiner_switch", "loras", "advanced_params", "require_base64", "async_process", "webhook_url", "input_image", "input_mask", "inpaint_additional_prompt", "outpaint_selections", "outpaint_distance_left", "outpaint_distance_right", "outpaint_distance_top", "outpaint_distance_bottom", "image_prompts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImgInpaintOrOutpaintRequestJson from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in loras (list)
        _items = []
        if self.loras:
            for _item in self.loras:
                if _item:
                    _items.append(_item.to_dict())
            _dict['loras'] = _items
        # override the default output from pydantic by calling `to_dict()` of advanced_params
        if self.advanced_params:
            _dict['advanced_params'] = self.advanced_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of webhook_url
        if self.webhook_url:
            _dict['webhook_url'] = self.webhook_url.to_dict()
        # override the default output from pydantic by calling `to_dict()` of input_mask
        if self.input_mask:
            _dict['input_mask'] = self.input_mask.to_dict()
        # override the default output from pydantic by calling `to_dict()` of inpaint_additional_prompt
        if self.inpaint_additional_prompt:
            _dict['inpaint_additional_prompt'] = self.inpaint_additional_prompt.to_dict()
        # override the default output from pydantic by calling `to_dict()` of outpaint_distance_left
        if self.outpaint_distance_left:
            _dict['outpaint_distance_left'] = self.outpaint_distance_left.to_dict()
        # override the default output from pydantic by calling `to_dict()` of outpaint_distance_right
        if self.outpaint_distance_right:
            _dict['outpaint_distance_right'] = self.outpaint_distance_right.to_dict()
        # override the default output from pydantic by calling `to_dict()` of outpaint_distance_top
        if self.outpaint_distance_top:
            _dict['outpaint_distance_top'] = self.outpaint_distance_top.to_dict()
        # override the default output from pydantic by calling `to_dict()` of outpaint_distance_bottom
        if self.outpaint_distance_bottom:
            _dict['outpaint_distance_bottom'] = self.outpaint_distance_bottom.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in image_prompts (list)
        _items = []
        if self.image_prompts:
            for _item in self.image_prompts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['image_prompts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImgInpaintOrOutpaintRequestJson from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "prompt": obj.get("prompt") if obj.get("prompt") is not None else '',
            "negative_prompt": obj.get("negative_prompt") if obj.get("negative_prompt") is not None else '',
            "style_selections": obj.get("style_selections"),
            "performance_selection": obj.get("performance_selection"),
            "aspect_ratios_selection": obj.get("aspect_ratios_selection") if obj.get("aspect_ratios_selection") is not None else '1152*896',
            "image_number": obj.get("image_number") if obj.get("image_number") is not None else 1,
            "image_seed": obj.get("image_seed") if obj.get("image_seed") is not None else -1,
            "sharpness": obj.get("sharpness") if obj.get("sharpness") is not None else 2.0,
            "guidance_scale": obj.get("guidance_scale") if obj.get("guidance_scale") is not None else 4.0,
            "base_model_name": obj.get("base_model_name") if obj.get("base_model_name") is not None else 'juggernautXL_version6Rundiffusion.safetensors',
            "refiner_model_name": obj.get("refiner_model_name") if obj.get("refiner_model_name") is not None else 'None',
            "refiner_switch": obj.get("refiner_switch") if obj.get("refiner_switch") is not None else 0.5,
            "loras": [Lora.from_dict(_item) for _item in obj["loras"]] if obj.get("loras") is not None else None,
            "advanced_params": ImgInpaintOrOutpaintRequestJsonAdvancedParams.from_dict(obj["advanced_params"]) if obj.get("advanced_params") is not None else None,
            "require_base64": obj.get("require_base64") if obj.get("require_base64") is not None else False,
            "async_process": obj.get("async_process") if obj.get("async_process") is not None else False,
            "webhook_url": WebhookUrl.from_dict(obj["webhook_url"]) if obj.get("webhook_url") is not None else None,
            "input_image": obj.get("input_image"),
            "input_mask": InputMask.from_dict(obj["input_mask"]) if obj.get("input_mask") is not None else None,
            "inpaint_additional_prompt": InpaintAdditionalPrompt1.from_dict(obj["inpaint_additional_prompt"]) if obj.get("inpaint_additional_prompt") is not None else None,
            "outpaint_selections": obj.get("outpaint_selections"),
            "outpaint_distance_left": OutpaintDistanceLeft.from_dict(obj["outpaint_distance_left"]) if obj.get("outpaint_distance_left") is not None else None,
            "outpaint_distance_right": OutpaintDistanceRight.from_dict(obj["outpaint_distance_right"]) if obj.get("outpaint_distance_right") is not None else None,
            "outpaint_distance_top": OutpaintDistanceTop.from_dict(obj["outpaint_distance_top"]) if obj.get("outpaint_distance_top") is not None else None,
            "outpaint_distance_bottom": OutpaintDistanceBottom.from_dict(obj["outpaint_distance_bottom"]) if obj.get("outpaint_distance_bottom") is not None else None,
            "image_prompts": [ImgInpaintOrOutpaintRequestJsonImagePromptsInner.from_dict(_item) for _item in obj["image_prompts"]] if obj.get("image_prompts") is not None else None
        })
        return _obj


