/*
 * Decompiled with CFR 0.152.
 */
package kco.forceatlas2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kco.forceatlas2.ForceAtlas2LayoutData;
import kco.forceatlas2.ForceFactory;
import org.gephi.graph.api.Node;

public class Region {
    private double mass;
    private double massCenterX;
    private double massCenterY;
    private double massCenterZ;
    private double size;
    private List<Node> nodes;
    private List<Region> subregions = new ArrayList<Region>();
    private final boolean is3d;

    public Region(Node[] nodeArray, boolean bl) {
        this.nodes = new ArrayList<Node>();
        this.nodes.addAll(Arrays.asList(nodeArray));
        this.is3d = bl;
        this.updateMassAndGeometry();
    }

    public Region(ArrayList<Node> arrayList, boolean bl) {
        this.nodes = new ArrayList<Node>(arrayList);
        this.is3d = bl;
        this.updateMassAndGeometry();
    }

    void updateMassAndGeometry() {
        if (this.nodes.size() > 1) {
            this.mass = 0.0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (Node node : this.nodes) {
                ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
                this.mass += forceAtlas2LayoutData.getMass();
                d += (double)node.x() * forceAtlas2LayoutData.getMass();
                d2 += (double)node.y() * forceAtlas2LayoutData.getMass();
                d3 += this.is3d ? (double)node.z() * forceAtlas2LayoutData.getMass() : 0.0;
            }
            this.massCenterX = d / this.mass;
            this.massCenterY = d2 / this.mass;
            this.massCenterZ = this.is3d ? d3 / this.mass : 0.0;
            this.size = Double.MIN_VALUE;
            for (Node node : this.nodes) {
                double d4 = this.is3d ? ((double)node.z() - this.massCenterZ) * ((double)node.z() - this.massCenterZ) : 0.0;
                double d5 = Math.sqrt(((double)node.x() - this.massCenterX) * ((double)node.x() - this.massCenterX) + ((double)node.y() - this.massCenterY) * ((double)node.y() - this.massCenterY) + d4);
                this.size = Math.max(this.size, 2.0 * d5);
            }
        }
    }

    public void updateAllMassAndGeometry(boolean bl) {
        this.updateMassAndGeometry();
        if (bl && this.nodes.size() > 1) {
            for (Region region : this.subregions) {
                region.updateAllMassAndGeometry(bl);
            }
        }
    }

    private List<ArrayList<Node>> partitionZ(ArrayList<Node> arrayList) {
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        ArrayList arrayList3 = new ArrayList();
        for (Node node : arrayList) {
            ArrayList<Node> arrayList4 = (double)node.z() < this.massCenterZ ? arrayList2 : arrayList3;
            arrayList4.add(node);
        }
        return Arrays.asList(arrayList2, arrayList3);
    }

    private void addSubRegions(List<ArrayList<Node>> list) {
        for (ArrayList<Node> arrayList : list) {
            this.addSubRegions(arrayList);
        }
    }

    private void addSubRegions(ArrayList<Node> arrayList) {
        if (arrayList.size() > 0) {
            if (arrayList.size() < this.nodes.size()) {
                Region region = new Region(arrayList, this.is3d);
                this.subregions.add(region);
            } else {
                for (Node node : arrayList) {
                    ArrayList<Node> arrayList2 = new ArrayList<Node>();
                    arrayList2.add(node);
                    Region region = new Region(arrayList2, this.is3d);
                    this.subregions.add(region);
                }
            }
        }
    }

    public void buildSubRegions(boolean bl) {
        if (this.is3d) {
            this.buildSubRegions3D(bl);
        } else {
            this.buildSubRegions2D(bl);
        }
    }

    private void buildSubRegions2D(boolean bl) {
        if (this.nodes.size() > 1) {
            Object object32;
            ArrayList<Node> arrayList;
            Object object222;
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            for (Object object222 : this.nodes) {
                arrayList = (double)object222.x() < this.massCenterX ? arrayList2 : arrayList3;
                arrayList.add((Node)object222);
            }
            ArrayList arrayList4 = new ArrayList();
            object222 = new ArrayList();
            for (Object object32 : arrayList2) {
                Iterator<Region> iterator = (double)object32.y() < this.massCenterY ? arrayList4 : object222;
                ((ArrayList)((Object)iterator)).add((Region)object32);
            }
            arrayList = new ArrayList<Node>();
            object32 = new ArrayList();
            for (Node object4 : arrayList3) {
                Object object = (double)object4.y() < this.massCenterY ? object32 : arrayList;
                ((ArrayList)object).add(object4);
            }
            this.addSubRegions(arrayList4);
            this.addSubRegions((ArrayList<Node>)object222);
            this.addSubRegions(arrayList);
            this.addSubRegions((ArrayList<Node>)object32);
            if (bl) {
                for (Region region : this.subregions) {
                    region.buildSubRegions(bl);
                }
            }
        }
    }

    private void buildSubRegions3D(boolean bl) {
        if (this.nodes.size() > 1) {
            Object object32;
            ArrayList<Node> arrayList;
            Object object222;
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            for (Object object222 : this.nodes) {
                arrayList = (double)object222.x() < this.massCenterX ? arrayList2 : arrayList3;
                arrayList.add((Node)object222);
            }
            ArrayList arrayList4 = new ArrayList();
            object222 = new ArrayList();
            for (Object object32 : arrayList2) {
                Iterator<Region> iterator = (double)object32.y() < this.massCenterY ? arrayList4 : object222;
                ((ArrayList)((Object)iterator)).add((Region)object32);
            }
            arrayList = new ArrayList<Node>();
            object32 = new ArrayList();
            for (Node object4 : arrayList3) {
                Object object = (double)object4.y() < this.massCenterY ? object32 : arrayList;
                ((ArrayList)object).add(object4);
            }
            this.addSubRegions(this.partitionZ(arrayList4));
            this.addSubRegions(this.partitionZ((ArrayList<Node>)object222));
            this.addSubRegions(this.partitionZ(arrayList));
            this.addSubRegions(this.partitionZ((ArrayList<Node>)object32));
            if (bl) {
                for (Region region : this.subregions) {
                    region.buildSubRegions(bl);
                }
            }
        }
    }

    public void applyForce(Node node, ForceFactory.RepulsionForce repulsionForce, double d) {
        if (this.nodes.size() < 2) {
            Node node2 = this.nodes.get(0);
            repulsionForce.apply_BH(node, node2);
        } else {
            double d2 = Math.sqrt(((double)node.x() - this.massCenterX) * ((double)node.x() - this.massCenterX) + ((double)node.y() - this.massCenterY) * ((double)node.y() - this.massCenterY) + ((double)node.z() - this.massCenterZ) * ((double)node.z() - this.massCenterZ));
            if (d2 * d > this.size) {
                repulsionForce.apply(node, this);
            } else {
                for (Region region : this.subregions) {
                    region.applyForce(node, repulsionForce, d);
                }
            }
        }
    }

    public List<Region> getSubregions() {
        return this.subregions;
    }

    public double getMass() {
        return this.mass;
    }

    public double getMassCenterX() {
        return this.massCenterX;
    }

    public double getMassCenterY() {
        return this.massCenterY;
    }

    public double getMassCenterZ() {
        return this.massCenterZ;
    }
}

