DEFAULT_FORGE_CONFIG= """
[app]
name = "forge_kv"
version = "0.1.0"

path = "~/.forge/app"
executable = ""
logfile = "logs/app.log"
error_logfile = "logs/app_error.log"

# For the ABI connection between App and Forge under TCP mode.
sock_tcp = "tcp://127.0.0.1:27211"

# For the ABI connection between App and Forge under gRPC mode.
# sock_grpc = "tcp://127.0.0.1:27210"

# For configuring the backoff time (in milliseconds) if the ABI connection is cutoff.
sock_backoff = 500

[forge]
decimal = 16
proto_version = 1
path = "~/.forge/core"
# State db path
db = "data"
# index db path
index_db = "index"
keystore = "keystore"
logfile = "logs/forge.log"

sock_grpc = "tcp://127.0.0.1:27210"
consensus_engine = "tendermint"
storage_engine = "ipfs"
hash = "sha3"
encoding = "base64"
unlock_ttl = 300

max_validators = 64
max_candidates = 256
pub_sub_key = "ABTTOTHEMOON"

[forge.limit]
# max grace period is 10
grace_peroid = 10

[forge.account]
# for ethereum compatibility, use secp256k1
public_key_format = "ed25519"
# for ethereum compatibility, use keccak_256
public_key_hash_format = "sha3_256"
# for ethereum compatibility, use base16
address_format = "base58"

[forge.transaction]

max_asset_size = 65536
max_asset_per_transfer = 8
max_asset_per_exchange = 16

disabled_tx = ["SysUpgradeTx"]

[forge.web]
enabled = false

[forge.stake]

[forge.stake.timeout]
# for general stake, we do T+1
general = 86400
# for node stake, we do T+7
stake_for_node = 604800

[forge.rpc]
whitelist = "*"

[forge.release]
url = "http://releases.arcblock.io/forge"

[tendermint]
version = "0.29.1"
moniker = "forge"
path = "~/.forge/tendermint"

# relative paths to "path"
logfile = "logs/tendermint.log"

# socket to proxy app
sock_proxy_app = "tcp://127.0.0.1:27220"

# socket for tendermint json rpc
sock_rpc = "tcp://127.0.0.1:27221"

# socket for tendermint grpc (right now just use it for send tx and commit immediately)
sock_grpc = "tcp://127.0.0.1:27222"

# socket for tendermint p2p. Normally this shall be opened to the public network
sock_p2p = "tcp://0.0.0.0:26656"

# socket for performance metrics
sock_prof = ""

# persistent peers
persistent_peers = ""

# seed peers
seed_peers = ""

# timeout for commiting a new block
timeout_commit = "5s"

# create empty blocks in 5s interval
create_empty_blocks = true

# set if this node runs in a seed mode
seed_mode = false

log_level = "consensus:info,main:info,state:info,*:error"

max_num_inbound_peers = 40
max_num_outbound_peers = 10

upnp = false

[tendermint.genesis]
genesis_time = "2018-11-05T19:22:08.938749Z"
chain_id = "forge"
max_bytes = 22020096
max_gas = -1
app_hash = ""

# note that if you don't give this information we will use self as validator
[[tendermint.genesis.validators]]

[ipfs]
version = "0.4.18"
path = "~/.forge/ipfs"
logfile = "logs/ipfs.log"
storage_max = "10GB"
bootstrap = []

#ipfs_cluster_version = "0.7.0"
#ipfs_cluster_ctl_version = "0.7.0"

max_file_size.admin = "100M"
max_file_size.account = "1M"

[cache]
dc_dump_limit = 50
dump_log_write_threshold = 50_000
cache_mnesia_table_timeout = 15_000
path = "~/.forge/cache/mnesia_data_dir"

[geolix]
mmdb_url = "https://geolite.maxmind.com/download/geoip/database/GeoLite2-City.tar.gz"
mmdb_path = "~/.mmdb/GeoLite2-City.tar.gz"
"""
