
import requests

from pathlib import Path
import sys

import forloop_modules.flog as flog
import json

#Duplicate in ncrb due to circular imports, remove from here once auth not used in ncrb
if sys.platform == "darwin":  # MAC OS
    config_path = 'config/server_config_remote.ini'
else:
    config_path = 'config/server_config.ini'

with Path(config_path).open(mode='r') as f:
    rows = f.readlines()


SERVER = rows[0].split("=")[1].strip()
PORT = rows[1].split("=")[1].strip()
BASE_API = f'{SERVER}:{PORT}/api/v1'


#! Duplicate functions to those in ncrb (they are here due to circular imports)
def initialize_last_or_new_project_by_email(email: str):
    """Duplicate in ncrb due to circular imports, remove from here once auth not used in ncrb"""
    payload = {"email": email}

    url = f'{BASE_API}/initialize_last_or_new_project_by_email'

    response = requests.post(url, json = payload)
    flog.info(f'Response: {response.text}')

    return response

def initialize_last_or_new_pipeline(project_uid: str):
    """Duplicate in ncrb due to circular imports, remove from here once auth not used in ncrb"""   
    payload = {"project_uid": project_uid}

    url = f'{BASE_API}/initialize_last_or_new_pipeline?project_uid='+str(project_uid)

    response = requests.post(url, json = payload)
    flog.info(f'Response: {response.text}')

    return response

#####! Duplicate functions end #####


class ActiveEntityTracker:
    """The purpose of this structure is to contain information about last active entities of a given runtime - either from Execution core or from the GUI
    Examples of what it can store: last_active_df, last_active_project, last_active_pipeline etc.
    It is user specific but doesnt explicitly require user's auth details
    
    It doesnt necessarily have to be a singleton - Idea: one GUI can have one AET (activeentitytracker), 
    one exec core ~ one AET until it switches to a new job for a different user where it can be reinitialized
    
    """
    def __init__(self):
        self.project_uid: str = None #Todo: rename to active
        self.active_pipeline_uid: str = None
        self.active_script_uid: str = None
        
 
    
    def _initialize_project_and_pipeline_after_login(self, email: str):
        project_response = initialize_last_or_new_project_by_email(email)
        self.project_uid = json.loads(project_response.content.decode('utf-8'))["uid"]
        pipeline_response = initialize_last_or_new_pipeline(self.project_uid)
        self.active_pipeline_uid= json.loads(pipeline_response.content.decode('utf-8'))["uid"]
    
    
  
aet=ActiveEntityTracker()