"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from ..shared import connector as shared_connector
from ..shared import paymentadjustment as shared_paymentadjustment
from ..shared import paymentmetadata as shared_paymentmetadata
from ..shared import paymentstatus as shared_paymentstatus
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from enum import Enum
from marshmallow import fields
from sdk import utils



@dataclasses.dataclass
class PaymentRaw:
    pass

class PaymentScheme(str, Enum):
    VISA = 'visa'
    MASTERCARD = 'mastercard'
    AMEX = 'amex'
    DINERS = 'diners'
    DISCOVER = 'discover'
    JCB = 'jcb'
    UNIONPAY = 'unionpay'
    SEPA_DEBIT = 'sepa debit'
    SEPA_CREDIT = 'sepa credit'
    SEPA = 'sepa'
    APPLE_PAY = 'apple pay'
    GOOGLE_PAY = 'google pay'
    A2A = 'a2a'
    ACH_DEBIT = 'ach debit'
    ACH = 'ach'
    RTP = 'rtp'
    UNKNOWN = 'unknown'
    OTHER = 'other'

class PaymentType(str, Enum):
    PAY_IN = 'PAY-IN'
    PAYOUT = 'PAYOUT'
    TRANSFER = 'TRANSFER'
    OTHER = 'OTHER'


@dataclass_json(undefined=Undefined.EXCLUDE)

@dataclasses.dataclass
class Payment:
    account_id: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('accountID') }})
    adjustments: list[shared_paymentadjustment.PaymentAdjustment] = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('adjustments') }})
    asset: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('asset') }})
    created_at: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('createdAt'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse, 'mm_field': fields.DateTime(format='iso') }})
    id: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('id') }})
    initial_amount: int = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('initialAmount') }})
    metadata: shared_paymentmetadata.PaymentMetadata = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('metadata') }})
    provider: shared_connector.Connector = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('provider') }})
    raw: PaymentRaw = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('raw') }})
    reference: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('reference') }})
    scheme: PaymentScheme = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('scheme') }})
    status: shared_paymentstatus.PaymentStatus = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('status') }})
    type: PaymentType = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('type') }})
    

