"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

import requests
from dataclasses import dataclass, field


SERVERS = [
    'http://localhost',
    # local server
    'https://{organization}.sandbox.formance.cloud',
    # sandbox server
]
"""Contains the list of servers available to the SDK"""



@dataclass
class SDKConfiguration:
    client: requests.Session
    security_client: requests.Session
    server_url: str = ''
    server_idx: int = 0
    server_defaults: list[dict[str, str]] = field(default_factory=list)
    language: str = 'python'
    openapi_doc_version: str = 'v1.0.20230713'
    sdk_version: str = 'v1.0.20230713'
    gen_version: str = '2.64.0'

    def get_server_details(self) -> tuple[str, dict[str, str]]:
        if self.server_url:
            return self.server_url.removesuffix('/'), {}
        if self.server_idx is None:
            self.server_idx = 0

        return SERVERS[self.server_idx], self.server_defaults[self.server_idx]
