"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

import requests as requests_http
from .auth import Auth
from .ledger import Ledger
from .orchestration import Orchestration
from .payments import Payments
from .reconciliation import Reconciliation
from .sdkconfiguration import SDKConfiguration
from .search import Search
from .wallets import Wallets
from .webhooks import Webhooks
from sdk import utils
from sdk.models import errors, operations, shared
from typing import Dict, Optional

class SDK:
    r"""Formance Stack API: Open, modular foundation for unique payments flows

    # Introduction
    This API is documented in **OpenAPI format**.

    # Authentication
    Formance Stack offers one forms of authentication:
      - OAuth2
    OAuth2 - an open protocol to allow secure authorization in a simple
    and standard method from web, mobile and desktop applications.
    <SecurityDefinitions />
    """
    auth: Auth
    ledger: Ledger
    orchestration: Orchestration
    payments: Payments
    reconciliation: Reconciliation
    search: Search
    wallets: Wallets
    webhooks: Webhooks

    sdk_configuration: SDKConfiguration

    def __init__(self,
                 server_idx: int = None,
                 server_url: str = None,
                 url_params: Dict[str, str] = None,
                 client: requests_http.Session = None,
                 retry_config: utils.RetryConfig = None
                 ) -> None:
        """Instantiates the SDK configuring it with the provided parameters.
        
        :param server_idx: The index of the server to use for all operations
        :type server_idx: int
        :param server_url: The server URL to use for all operations
        :type server_url: str
        :param url_params: Parameters to optionally template the server URL with
        :type url_params: Dict[str, str]
        :param client: The requests.Session HTTP client to use for all operations
        :type client: requests_http.Session
        :param retry_config: The utils.RetryConfig to use globally
        :type retry_config: utils.RetryConfig
        """
        if client is None:
            client = requests_http.Session()
        
        security_client = client
        
        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)

        self.sdk_configuration = SDKConfiguration(client, security_client, server_url, server_idx, retry_config=retry_config)
       
        self._init_sdks()
    
    def _init_sdks(self):
        self.auth = Auth(self.sdk_configuration)
        self.ledger = Ledger(self.sdk_configuration)
        self.orchestration = Orchestration(self.sdk_configuration)
        self.payments = Payments(self.sdk_configuration)
        self.reconciliation = Reconciliation(self.sdk_configuration)
        self.search = Search(self.sdk_configuration)
        self.wallets = Wallets(self.sdk_configuration)
        self.webhooks = Webhooks(self.sdk_configuration)
    
    def get_versions(self) -> operations.GetVersionsResponse:
        r"""Show stack version information"""
        base_url = utils.template_url(*self.sdk_configuration.get_server_details())
        
        url = base_url + '/versions'
        headers = {}
        headers['Accept'] = 'application/json'
        headers['user-agent'] = self.sdk_configuration.user_agent
        
        client = self.sdk_configuration.client
        
        http_res = client.request('GET', url, headers=headers)
        content_type = http_res.headers.get('Content-Type')

        res = operations.GetVersionsResponse(status_code=http_res.status_code, content_type=content_type, raw_response=http_res)
        
        if http_res.status_code == 200:
            if utils.match_content_type(content_type, 'application/json'):
                out = utils.unmarshal_json(http_res.text, Optional[shared.GetVersionsResponse])
                res.get_versions_response = out
            else:
                raise errors.SDKError(f'unknown content-type received: {content_type}', http_res.status_code, http_res.text, http_res)
        elif http_res.status_code >= 400 and http_res.status_code < 500 or http_res.status_code >= 500 and http_res.status_code < 600:
            raise errors.SDKError('API error occurred', http_res.status_code, http_res.text, http_res)

        return res

    
    def get_api_auth_well_known_openid_configuration(self) -> operations.GetAPIAuthWellKnownOpenidConfigurationResponse:
        base_url = utils.template_url(*self.sdk_configuration.get_server_details())
        
        url = base_url + '/api/auth/.well-known/openid-configuration'
        headers = {}
        headers['Accept'] = '*/*'
        headers['user-agent'] = self.sdk_configuration.user_agent
        
        client = self.sdk_configuration.client
        
        http_res = client.request('GET', url, headers=headers)
        content_type = http_res.headers.get('Content-Type')

        res = operations.GetAPIAuthWellKnownOpenidConfigurationResponse(status_code=http_res.status_code, content_type=content_type, raw_response=http_res)
        
        if http_res.status_code == 200:
            pass
        elif http_res.status_code >= 400 and http_res.status_code < 500 or http_res.status_code >= 500 and http_res.status_code < 600:
            raise errors.SDKError('API error occurred', http_res.status_code, http_res.text, http_res)

        return res

    