"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
from dataclasses_json import Undefined, dataclass_json
from sdk import utils
from typing import Optional


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class AtlarConfig:
    access_key: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('accessKey') }})
    r"""The access key used by the connector for authorizing requests to the Atlar API.
    You can obtain it along with the associated secret from the Atlar dashboard.
    """
    name: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('name') }})
    secret: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('secret') }})
    r"""The secret used by the connector for authorizing requests to the Atlar API.
    You can obtain it along with the associated access key from the Atlar dashboard.
    """
    base_url: Optional[str] = dataclasses.field(default='https://api.atlar.com', metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('baseUrl'), 'exclude': lambda f: f is None }})
    r"""The base URL the client uses for making requests towards the Atlar API."""
    page_size: Optional[int] = dataclasses.field(default=25, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('pageSize'), 'exclude': lambda f: f is None }})
    r"""Number of items to fetch when querying paginated APIs."""
    polling_period: Optional[str] = dataclasses.field(default='120s', metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('pollingPeriod'), 'exclude': lambda f: f is None }})
    r"""The frequency at which the connector tries to fetch new Transaction objects from the Atlar API."""
    transfer_initiation_status_polling_period: Optional[str] = dataclasses.field(default='120s', metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('transferInitiationStatusPollingPeriod'), 'exclude': lambda f: f is None }})
    r"""The frequency at which the connector tries to fetch the status of payment initiations from the Atlar API."""
    

