"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    creditwalletrequest as shared_creditwalletrequest,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreditWalletRequestTypedDict(TypedDict):
    id: str
    credit_wallet_request: NotRequired[
        shared_creditwalletrequest.CreditWalletRequestTypedDict
    ]
    idempotency_key: NotRequired[str]
    r"""Use an idempotency key"""


class CreditWalletRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    credit_wallet_request: Annotated[
        Optional[shared_creditwalletrequest.CreditWalletRequest],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="Idempotency-Key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Use an idempotency key"""


class CreditWalletResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""


class CreditWalletResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
