"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    debitwalletrequest as shared_debitwalletrequest,
    debitwalletresponse as shared_debitwalletresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DebitWalletRequestTypedDict(TypedDict):
    id: str
    debit_wallet_request: NotRequired[
        shared_debitwalletrequest.DebitWalletRequestTypedDict
    ]
    idempotency_key: NotRequired[str]
    r"""Use an idempotency key"""


class DebitWalletRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    debit_wallet_request: Annotated[
        Optional[shared_debitwalletrequest.DebitWalletRequest],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="Idempotency-Key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Use an idempotency key"""


class DebitWalletResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    debit_wallet_response: NotRequired[
        shared_debitwalletresponse.DebitWalletResponseTypedDict
    ]
    r"""Wallet successfully debited as a pending hold"""


class DebitWalletResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    debit_wallet_response: Optional[shared_debitwalletresponse.DebitWalletResponse] = (
        None
    )
    r"""Wallet successfully debited as a pending hold"""
