"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import httpx
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateWalletRequestBodyTypedDict(TypedDict):
    metadata: Dict[str, str]
    r"""Custom metadata to attach to this wallet."""


class UpdateWalletRequestBody(BaseModel):
    metadata: Dict[str, str]
    r"""Custom metadata to attach to this wallet."""


class UpdateWalletRequestTypedDict(TypedDict):
    id: str
    idempotency_key: NotRequired[str]
    r"""Use an idempotency key"""
    request_body: NotRequired[UpdateWalletRequestBodyTypedDict]


class UpdateWalletRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="Idempotency-Key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Use an idempotency key"""

    request_body: Annotated[
        Optional[UpdateWalletRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class UpdateWalletResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""


class UpdateWalletResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
