"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from formance_sdk_python.models.shared import (
    v2aggregatebalancesresponse as shared_v2aggregatebalancesresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import httpx
import pydantic
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V2GetBalancesAggregatedRequestTypedDict(TypedDict):
    ledger: str
    r"""Name of the ledger."""
    request_body: NotRequired[Dict[str, Any]]
    pit: NotRequired[datetime]
    use_insertion_date: NotRequired[bool]
    r"""Use insertion date instead of effective date"""


class V2GetBalancesAggregatedRequest(BaseModel):
    ledger: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Name of the ledger."""

    request_body: Annotated[
        Optional[Dict[str, Any]],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None

    pit: Annotated[
        Optional[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    use_insertion_date: Annotated[
        Optional[bool],
        pydantic.Field(alias="useInsertionDate"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Use insertion date instead of effective date"""


class V2GetBalancesAggregatedResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    v2_aggregate_balances_response: NotRequired[
        shared_v2aggregatebalancesresponse.V2AggregateBalancesResponseTypedDict
    ]
    r"""OK"""


class V2GetBalancesAggregatedResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    v2_aggregate_balances_response: Optional[
        shared_v2aggregatebalancesresponse.V2AggregateBalancesResponse
    ] = None
    r"""OK"""
