"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v2posting import V2Posting, V2PostingTypedDict
from .v2volume import V2Volume, V2VolumeTypedDict
from datetime import datetime
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import validate_int
import pydantic
from pydantic.functional_validators import BeforeValidator
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V2ExpandedTransactionTypedDict(TypedDict):
    id: int
    metadata: Dict[str, str]
    postings: List[V2PostingTypedDict]
    reverted: bool
    timestamp: datetime
    post_commit_volumes: NotRequired[Dict[str, Dict[str, V2VolumeTypedDict]]]
    pre_commit_volumes: NotRequired[Dict[str, Dict[str, V2VolumeTypedDict]]]
    reference: NotRequired[str]


class V2ExpandedTransaction(BaseModel):
    id: Annotated[int, BeforeValidator(validate_int)]

    metadata: Dict[str, str]

    postings: List[V2Posting]

    reverted: bool

    timestamp: datetime

    post_commit_volumes: Annotated[
        Optional[Dict[str, Dict[str, V2Volume]]],
        pydantic.Field(alias="postCommitVolumes"),
    ] = None

    pre_commit_volumes: Annotated[
        Optional[Dict[str, Dict[str, V2Volume]]],
        pydantic.Field(alias="preCommitVolumes"),
    ] = None

    reference: Optional[str] = None
