"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .posting import Posting, PostingTypedDict
from .walletsvolume import WalletsVolume, WalletsVolumeTypedDict
from datetime import datetime
from formance_sdk_python.types import BaseModel
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class WalletsTransactionTypedDict(TypedDict):
    id: int
    metadata: Dict[str, str]
    r"""Metadata associated with the wallet."""
    postings: List[PostingTypedDict]
    timestamp: datetime
    ledger: NotRequired[str]
    post_commit_volumes: NotRequired[Dict[str, Dict[str, WalletsVolumeTypedDict]]]
    pre_commit_volumes: NotRequired[Dict[str, Dict[str, WalletsVolumeTypedDict]]]
    reference: NotRequired[str]


class WalletsTransaction(BaseModel):
    id: int

    metadata: Dict[str, str]
    r"""Metadata associated with the wallet."""

    postings: List[Posting]

    timestamp: datetime

    ledger: Optional[str] = None

    post_commit_volumes: Annotated[
        Optional[Dict[str, Dict[str, WalletsVolume]]],
        pydantic.Field(alias="postCommitVolumes"),
    ] = None

    pre_commit_volumes: Annotated[
        Optional[Dict[str, Dict[str, WalletsVolume]]],
        pydantic.Field(alias="preCommitVolumes"),
    ] = None

    reference: Optional[str] = None
