"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import validate_int
import pydantic
from pydantic.functional_validators import BeforeValidator
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ReconciliationTypedDict(TypedDict):
    created_at: datetime
    drift_balances: Dict[str, int]
    id: str
    ledger_balances: Dict[str, int]
    payments_balances: Dict[str, int]
    policy_id: str
    reconciled_at_ledger: datetime
    reconciled_at_payments: datetime
    status: str
    error: NotRequired[str]


class Reconciliation(BaseModel):
    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]

    drift_balances: Annotated[
        Dict[str, Annotated[int, BeforeValidator(validate_int)]],
        pydantic.Field(alias="driftBalances"),
    ]

    id: str

    ledger_balances: Annotated[
        Dict[str, Annotated[int, BeforeValidator(validate_int)]],
        pydantic.Field(alias="ledgerBalances"),
    ]

    payments_balances: Annotated[
        Dict[str, Annotated[int, BeforeValidator(validate_int)]],
        pydantic.Field(alias="paymentsBalances"),
    ]

    policy_id: Annotated[str, pydantic.Field(alias="policyID")]

    reconciled_at_ledger: Annotated[
        datetime, pydantic.Field(alias="reconciledAtLedger")
    ]

    reconciled_at_payments: Annotated[
        datetime, pydantic.Field(alias="reconciledAtPayments")
    ]

    status: str

    error: Optional[str] = None
