"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3bankaccountrelatedaccount import (
    V3BankAccountRelatedAccount,
    V3BankAccountRelatedAccountTypedDict,
)
from datetime import datetime
from formance_sdk_python.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3BankAccountTypedDict(TypedDict):
    created_at: datetime
    id: str
    name: str
    account_number: NotRequired[Nullable[str]]
    iban: NotRequired[Nullable[str]]
    metadata: NotRequired[Nullable[Dict[str, str]]]
    related_accounts: NotRequired[List[V3BankAccountRelatedAccountTypedDict]]
    swift_bic_code: NotRequired[Nullable[str]]


class V3BankAccount(BaseModel):
    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]

    id: str

    name: str

    account_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="accountNumber")
    ] = UNSET

    iban: OptionalNullable[str] = UNSET

    metadata: OptionalNullable[Dict[str, str]] = UNSET

    related_accounts: Annotated[
        Optional[List[V3BankAccountRelatedAccount]],
        pydantic.Field(alias="relatedAccounts"),
    ] = None

    swift_bic_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="swiftBicCode")
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accountNumber",
            "iban",
            "metadata",
            "relatedAccounts",
            "swiftBicCode",
        ]
        nullable_fields = ["accountNumber", "iban", "metadata", "swiftBicCode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
