"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from formance_sdk_python import utils
from formance_sdk_python.types import BaseModel
import pydantic
from typing_extensions import Annotated


class ErrorCode(str, Enum):
    VALIDATION = "VALIDATION"
    NOT_FOUND = "NOT_FOUND"
    INTERNAL = "INTERNAL"


class ErrorData(BaseModel):
    error_code: Annotated[ErrorCode, pydantic.Field(alias="errorCode")]

    error_message: Annotated[str, pydantic.Field(alias="errorMessage")]


class Error(Exception):
    r"""General error"""

    data: ErrorData

    def __init__(self, data: ErrorData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ErrorData)
