"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    mapping as shared_mapping,
    mappingresponse as shared_mappingresponse,
)
from formance_sdk_python.types import BaseModel, Nullable, UNSET_SENTINEL
from formance_sdk_python.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import httpx
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateMappingRequestTypedDict(TypedDict):
    mapping: Nullable[shared_mapping.MappingTypedDict]
    ledger: str
    r"""Name of the ledger."""


class UpdateMappingRequest(BaseModel):
    mapping: Annotated[
        Nullable[shared_mapping.Mapping],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    ledger: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Name of the ledger."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["Mapping"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateMappingResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    mapping_response: NotRequired[shared_mappingresponse.MappingResponseTypedDict]
    r"""OK"""


class UpdateMappingResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    mapping_response: Optional[shared_mappingresponse.MappingResponse] = None
    r"""OK"""
