"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    v2runworkflowresponse as shared_v2runworkflowresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import httpx
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V2RunWorkflowRequestTypedDict(TypedDict):
    workflow_id: str
    r"""The flow id"""
    request_body: NotRequired[Dict[str, str]]
    wait: NotRequired[bool]
    r"""Wait end of the workflow before return"""


class V2RunWorkflowRequest(BaseModel):
    workflow_id: Annotated[
        str,
        pydantic.Field(alias="workflowID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The flow id"""

    request_body: Annotated[
        Optional[Dict[str, str]],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None

    wait: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Wait end of the workflow before return"""


class V2RunWorkflowResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    v2_run_workflow_response: NotRequired[
        shared_v2runworkflowresponse.V2RunWorkflowResponseTypedDict
    ]
    r"""The workflow instance"""


class V2RunWorkflowResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    v2_run_workflow_response: Optional[
        shared_v2runworkflowresponse.V2RunWorkflowResponse
    ] = None
    r"""The workflow instance"""
