"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .orchestrationconnector import OrchestrationConnector
from .orchestrationpaymentadjustment import (
    OrchestrationPaymentAdjustment,
    OrchestrationPaymentAdjustmentTypedDict,
)
from .orchestrationpaymentmetadata import (
    OrchestrationPaymentMetadata,
    OrchestrationPaymentMetadataTypedDict,
)
from .orchestrationpaymentstatus import OrchestrationPaymentStatus
from datetime import datetime
from enum import Enum
from formance_sdk_python.types import BaseModel, Nullable, UNSET_SENTINEL
from formance_sdk_python.utils import validate_int
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import BeforeValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class OrchestrationPaymentRawTypedDict(TypedDict):
    pass


class OrchestrationPaymentRaw(BaseModel):
    pass


class OrchestrationPaymentScheme(str, Enum):
    VISA = "visa"
    MASTERCARD = "mastercard"
    AMEX = "amex"
    DINERS = "diners"
    DISCOVER = "discover"
    JCB = "jcb"
    UNIONPAY = "unionpay"
    SEPA_DEBIT = "sepa debit"
    SEPA_CREDIT = "sepa credit"
    SEPA = "sepa"
    APPLE_PAY = "apple pay"
    GOOGLE_PAY = "google pay"
    A2A = "a2a"
    ACH_DEBIT = "ach debit"
    ACH = "ach"
    RTP = "rtp"
    UNKNOWN = "unknown"
    OTHER = "other"


class OrchestrationPaymentType(str, Enum):
    PAY_IN = "PAY-IN"
    PAYOUT = "PAYOUT"
    TRANSFER = "TRANSFER"
    OTHER = "OTHER"


class OrchestrationPaymentTypedDict(TypedDict):
    adjustments: List[OrchestrationPaymentAdjustmentTypedDict]
    asset: str
    connector_id: str
    created_at: datetime
    destination_account_id: str
    id: str
    initial_amount: int
    metadata: Nullable[OrchestrationPaymentMetadataTypedDict]
    raw: Nullable[OrchestrationPaymentRawTypedDict]
    reference: str
    scheme: OrchestrationPaymentScheme
    source_account_id: str
    status: OrchestrationPaymentStatus
    type: OrchestrationPaymentType
    provider: NotRequired[OrchestrationConnector]


class OrchestrationPayment(BaseModel):
    adjustments: List[OrchestrationPaymentAdjustment]

    asset: str

    connector_id: Annotated[str, pydantic.Field(alias="connectorID")]

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]

    destination_account_id: Annotated[str, pydantic.Field(alias="destinationAccountID")]

    id: str

    initial_amount: Annotated[
        Annotated[int, BeforeValidator(validate_int)],
        pydantic.Field(alias="initialAmount"),
    ]

    metadata: Nullable[OrchestrationPaymentMetadata]

    raw: Nullable[OrchestrationPaymentRaw]

    reference: str

    scheme: OrchestrationPaymentScheme

    source_account_id: Annotated[str, pydantic.Field(alias="sourceAccountID")]

    status: OrchestrationPaymentStatus

    type: OrchestrationPaymentType

    provider: Optional[OrchestrationConnector] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["provider"]
        nullable_fields = ["metadata", "raw"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
