"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .monetary import Monetary, MonetaryTypedDict
from .subject import Subject, SubjectTypedDict
from datetime import datetime
from formance_sdk_python.types import BaseModel
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class DebitWalletRequestTypedDict(TypedDict):
    amount: MonetaryTypedDict
    metadata: Dict[str, str]
    r"""Metadata associated with the wallet."""
    balances: NotRequired[List[str]]
    description: NotRequired[str]
    destination: NotRequired[SubjectTypedDict]
    pending: NotRequired[bool]
    r"""Set to true to create a pending hold. If false, the wallet will be debited immediately."""
    timestamp: NotRequired[datetime]
    r"""cannot be used in conjunction with `pending` property"""


class DebitWalletRequest(BaseModel):
    amount: Monetary

    metadata: Dict[str, str]
    r"""Metadata associated with the wallet."""

    balances: Optional[List[str]] = None

    description: Optional[str] = None

    destination: Optional[Subject] = None

    pending: Optional[bool] = None
    r"""Set to true to create a pending hold. If false, the wallet will be debited immediately."""

    timestamp: Optional[datetime] = None
    r"""cannot be used in conjunction with `pending` property"""
