"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .transferinitiationadjusments import (
    TransferInitiationAdjusments,
    TransferInitiationAdjusmentsTypedDict,
)
from .transferinitiationpayments import (
    TransferInitiationPayments,
    TransferInitiationPaymentsTypedDict,
)
from .transferinitiationstatus import TransferInitiationStatus
from datetime import datetime
from enum import Enum
from formance_sdk_python.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from formance_sdk_python.utils import validate_int
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import BeforeValidator
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TransferInitiationType(str, Enum):
    TRANSFER = "TRANSFER"
    PAYOUT = "PAYOUT"


class TransferInitiationTypedDict(TypedDict):
    amount: int
    asset: str
    connector_id: str
    created_at: datetime
    description: str
    destination_account_id: str
    error: str
    id: str
    initial_amount: int
    reference: str
    scheduled_at: datetime
    source_account_id: str
    status: TransferInitiationStatus
    type: TransferInitiationType
    metadata: NotRequired[Nullable[Dict[str, str]]]
    related_adjustments: NotRequired[List[TransferInitiationAdjusmentsTypedDict]]
    related_payments: NotRequired[Nullable[List[TransferInitiationPaymentsTypedDict]]]


class TransferInitiation(BaseModel):
    amount: Annotated[int, BeforeValidator(validate_int)]

    asset: str

    connector_id: Annotated[str, pydantic.Field(alias="connectorID")]

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]

    description: str

    destination_account_id: Annotated[str, pydantic.Field(alias="destinationAccountID")]

    error: str

    id: str

    initial_amount: Annotated[
        Annotated[int, BeforeValidator(validate_int)],
        pydantic.Field(alias="initialAmount"),
    ]

    reference: str

    scheduled_at: Annotated[datetime, pydantic.Field(alias="scheduledAt")]

    source_account_id: Annotated[str, pydantic.Field(alias="sourceAccountID")]

    status: TransferInitiationStatus

    type: TransferInitiationType

    metadata: OptionalNullable[Dict[str, str]] = UNSET

    related_adjustments: Annotated[
        Optional[List[TransferInitiationAdjusments]],
        pydantic.Field(alias="relatedAdjustments"),
    ] = None

    related_payments: Annotated[
        OptionalNullable[List[TransferInitiationPayments]],
        pydantic.Field(alias="relatedPayments"),
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["metadata", "relatedAdjustments", "relatedPayments"]
        nullable_fields = ["metadata", "relatedPayments"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
