"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    gettransactionsresponse as shared_gettransactionsresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import FieldMetadata, QueryParamMetadata
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetTransactionsRequestTypedDict(TypedDict):
    cursor: NotRequired[str]
    r"""Parameter used in pagination requests.
    Set to the value of next for the next page of results.
    Set to the value of previous for the previous page of results.
    No other parameters can be set when the cursor is set.

    """
    page_size: NotRequired[int]
    r"""The maximum number of results to return per page"""
    wallet_id: NotRequired[str]
    r"""A wallet ID to filter on"""


class GetTransactionsRequest(BaseModel):
    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Parameter used in pagination requests.
    Set to the value of next for the next page of results.
    Set to the value of previous for the previous page of results.
    No other parameters can be set when the cursor is set.

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="pageSize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 15
    r"""The maximum number of results to return per page"""

    wallet_id: Annotated[
        Optional[str],
        pydantic.Field(alias="walletID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A wallet ID to filter on"""


class GetTransactionsResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    get_transactions_response: NotRequired[
        shared_gettransactionsresponse.GetTransactionsResponseTypedDict
    ]
    r"""OK"""


class GetTransactionsResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    get_transactions_response: Optional[
        shared_gettransactionsresponse.GetTransactionsResponse
    ] = None
    r"""OK"""
