"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .connector import Connector
from .paymentadjustment import PaymentAdjustment, PaymentAdjustmentTypedDict
from .paymentscheme import PaymentScheme
from .paymentstatus import PaymentStatus
from .paymenttype import PaymentType
from datetime import datetime
from formance_sdk_python.types import BaseModel, Nullable, UNSET_SENTINEL
from formance_sdk_python.utils import validate_int
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import BeforeValidator
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RawTypedDict(TypedDict):
    pass


class Raw(BaseModel):
    pass


class PaymentTypedDict(TypedDict):
    adjustments: List[PaymentAdjustmentTypedDict]
    amount: int
    asset: str
    connector_id: str
    created_at: datetime
    destination_account_id: str
    id: str
    initial_amount: int
    metadata: Nullable[Dict[str, str]]
    raw: Nullable[RawTypedDict]
    reference: str
    scheme: PaymentScheme
    source_account_id: str
    status: PaymentStatus
    type: PaymentType
    provider: NotRequired[Connector]


class Payment(BaseModel):
    adjustments: List[PaymentAdjustment]

    amount: Annotated[int, BeforeValidator(validate_int)]

    asset: str

    connector_id: Annotated[str, pydantic.Field(alias="connectorID")]

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]

    destination_account_id: Annotated[str, pydantic.Field(alias="destinationAccountID")]

    id: str

    initial_amount: Annotated[
        Annotated[int, BeforeValidator(validate_int)],
        pydantic.Field(alias="initialAmount"),
    ]

    metadata: Nullable[Dict[str, str]]

    raw: Nullable[Raw]

    reference: str

    scheme: PaymentScheme

    source_account_id: Annotated[str, pydantic.Field(alias="sourceAccountID")]

    status: PaymentStatus

    type: PaymentType

    provider: Optional[Connector] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["provider"]
        nullable_fields = ["metadata", "raw"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
