"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    createwalletrequest as shared_createwalletrequest,
    createwalletresponse as shared_createwalletresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import FieldMetadata, HeaderMetadata, RequestMetadata
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateWalletRequestTypedDict(TypedDict):
    create_wallet_request: NotRequired[
        shared_createwalletrequest.CreateWalletRequestTypedDict
    ]
    idempotency_key: NotRequired[str]
    r"""Use an idempotency key"""


class CreateWalletRequest(BaseModel):
    create_wallet_request: Annotated[
        Optional[shared_createwalletrequest.CreateWalletRequest],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="Idempotency-Key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Use an idempotency key"""


class CreateWalletResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    create_wallet_response: NotRequired[
        shared_createwalletresponse.CreateWalletResponseTypedDict
    ]
    r"""Wallet created"""


class CreateWalletResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    create_wallet_response: Optional[
        shared_createwalletresponse.CreateWalletResponse
    ] = None
    r"""Wallet created"""
