"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .bankaccountrelatedaccounts import (
    BankAccountRelatedAccounts,
    BankAccountRelatedAccountsTypedDict,
)
from datetime import datetime
from formance_sdk_python.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class BankAccountTypedDict(TypedDict):
    country: str
    created_at: datetime
    id: str
    name: str
    account_id: NotRequired[str]
    account_number: NotRequired[str]
    connector_id: NotRequired[str]
    iban: NotRequired[str]
    metadata: NotRequired[Nullable[Dict[str, str]]]
    provider: NotRequired[str]
    related_accounts: NotRequired[List[BankAccountRelatedAccountsTypedDict]]
    swift_bic_code: NotRequired[str]


class BankAccount(BaseModel):
    country: str

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]

    id: str

    name: str

    account_id: Annotated[Optional[str], pydantic.Field(alias="accountID")] = None

    account_number: Annotated[Optional[str], pydantic.Field(alias="accountNumber")] = (
        None
    )

    connector_id: Annotated[Optional[str], pydantic.Field(alias="connectorID")] = None

    iban: Optional[str] = None

    metadata: OptionalNullable[Dict[str, str]] = UNSET

    provider: Optional[str] = None

    related_accounts: Annotated[
        Optional[List[BankAccountRelatedAccounts]],
        pydantic.Field(alias="relatedAccounts"),
    ] = None

    swift_bic_code: Annotated[Optional[str], pydantic.Field(alias="swiftBicCode")] = (
        None
    )

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accountID",
            "accountNumber",
            "connectorID",
            "iban",
            "metadata",
            "provider",
            "relatedAccounts",
            "swiftBicCode",
        ]
        nullable_fields = ["metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
