"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    connector_enum as shared_connector_enum,
    taskscursor as shared_taskscursor,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListConnectorTasksV1RequestTypedDict(TypedDict):
    connector: shared_connector_enum.ConnectorEnum
    r"""The name of the connector."""
    connector_id: str
    r"""The connector ID."""
    cursor: NotRequired[str]
    r"""Parameter used in pagination requests. Maximum page size is set to 15.
    Set to the value of next for the next page of results.
    Set to the value of previous for the previous page of results.
    No other parameters can be set when this parameter is set.

    """
    page_size: NotRequired[int]
    r"""The maximum number of results to return per page.

    """


class ListConnectorTasksV1Request(BaseModel):
    connector: Annotated[
        shared_connector_enum.ConnectorEnum,
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The name of the connector."""

    connector_id: Annotated[
        str,
        pydantic.Field(alias="connectorId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The connector ID."""

    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Parameter used in pagination requests. Maximum page size is set to 15.
    Set to the value of next for the next page of results.
    Set to the value of previous for the previous page of results.
    No other parameters can be set when this parameter is set.

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="pageSize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 15
    r"""The maximum number of results to return per page.

    """


class ListConnectorTasksV1ResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    tasks_cursor: NotRequired[shared_taskscursor.TasksCursorTypedDict]
    r"""OK"""


class ListConnectorTasksV1Response(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    tasks_cursor: Optional[shared_taskscursor.TasksCursor] = None
    r"""OK"""
