"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    readclientresponse as shared_readclientresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import FieldMetadata, PathParamMetadata
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ReadClientRequestTypedDict(TypedDict):
    client_id: str
    r"""Client ID"""


class ReadClientRequest(BaseModel):
    client_id: Annotated[
        str,
        pydantic.Field(alias="clientId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Client ID"""


class ReadClientResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    read_client_response: NotRequired[
        shared_readclientresponse.ReadClientResponseTypedDict
    ]
    r"""Retrieved client"""


class ReadClientResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    read_client_response: Optional[shared_readclientresponse.ReadClientResponse] = None
    r"""Retrieved client"""
