"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import httpx
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V2AddMetadataToAccountRequestTypedDict(TypedDict):
    request_body: Dict[str, str]
    r"""metadata"""
    address: str
    r"""Exact address of the account. It must match the following regular expressions pattern:
    ```
    ^\w+(:\w+)*$
    ```

    """
    ledger: str
    r"""Name of the ledger."""
    idempotency_key: NotRequired[str]
    r"""Use an idempotency key"""
    dry_run: NotRequired[bool]
    r"""Set the dry run mode. Dry run mode doesn't add the logs to the database or publish a message to the message broker."""


class V2AddMetadataToAccountRequest(BaseModel):
    request_body: Annotated[
        Dict[str, str],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""metadata"""

    address: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Exact address of the account. It must match the following regular expressions pattern:
    ```
    ^\w+(:\w+)*$
    ```

    """

    ledger: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Name of the ledger."""

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="Idempotency-Key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Use an idempotency key"""

    dry_run: Annotated[
        Optional[bool],
        pydantic.Field(alias="dryRun"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Set the dry run mode. Dry run mode doesn't add the logs to the database or publish a message to the message broker."""


class V2AddMetadataToAccountResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""


class V2AddMetadataToAccountResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
