"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accounttype import AccountType
from datetime import datetime
from formance_sdk_python.types import BaseModel, Nullable, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentsAccountRawTypedDict(TypedDict):
    pass


class PaymentsAccountRaw(BaseModel):
    pass


class PaymentsAccountTypedDict(TypedDict):
    account_name: str
    connector_id: str
    created_at: datetime
    default_asset: str
    default_currency: str
    id: str
    metadata: Nullable[Dict[str, str]]
    raw: Nullable[PaymentsAccountRawTypedDict]
    reference: str
    type: AccountType
    pools: NotRequired[List[str]]
    provider: NotRequired[str]


class PaymentsAccount(BaseModel):
    account_name: Annotated[str, pydantic.Field(alias="accountName")]

    connector_id: Annotated[str, pydantic.Field(alias="connectorID")]

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]

    default_asset: Annotated[str, pydantic.Field(alias="defaultAsset")]

    default_currency: Annotated[
        str,
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.",
            alias="defaultCurrency",
        ),
    ]

    id: str

    metadata: Nullable[Dict[str, str]]

    raw: Nullable[PaymentsAccountRaw]

    reference: str

    type: AccountType

    pools: Optional[List[str]] = None

    provider: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["pools", "provider"]
        nullable_fields = ["metadata", "raw"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
