"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    v2bulkelement as shared_v2bulkelement,
    v2bulkresponse as shared_v2bulkresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import httpx
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V2CreateBulkRequestTypedDict(TypedDict):
    request_body: List[shared_v2bulkelement.V2BulkElementTypedDict]
    ledger: str
    r"""Name of the ledger."""
    atomic: NotRequired[bool]
    r"""Make bulk atomic"""
    continue_on_failure: NotRequired[bool]
    r"""Continue on failure"""
    parallel: NotRequired[bool]
    r"""Process bulk elements in parallel"""


class V2CreateBulkRequest(BaseModel):
    request_body: Annotated[
        List[shared_v2bulkelement.V2BulkElement],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    ledger: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Name of the ledger."""

    atomic: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Make bulk atomic"""

    continue_on_failure: Annotated[
        Optional[bool],
        pydantic.Field(alias="continueOnFailure"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Continue on failure"""

    parallel: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Process bulk elements in parallel"""


class V2CreateBulkResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    v2_bulk_response: NotRequired[shared_v2bulkresponse.V2BulkResponseTypedDict]
    r"""OK"""


class V2CreateBulkResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    v2_bulk_response: Optional[shared_v2bulkresponse.V2BulkResponse] = None
    r"""OK"""
