"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    listwalletsresponse as shared_listwalletsresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import FieldMetadata, QueryParamMetadata
import httpx
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListWalletsRequestTypedDict(TypedDict):
    cursor: NotRequired[str]
    r"""Parameter used in pagination requests.
    Set to the value of next for the next page of results.
    Set to the value of previous for the previous page of results.
    No other parameters can be set when the pagination token is set.

    """
    expand: NotRequired[str]
    metadata: NotRequired[Dict[str, str]]
    r"""Filter wallets by metadata key value pairs. Nested objects can be used as seen in the example below."""
    name: NotRequired[str]
    r"""Filter on wallet name"""
    page_size: NotRequired[int]
    r"""The maximum number of results to return per page"""


class ListWalletsRequest(BaseModel):
    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Parameter used in pagination requests.
    Set to the value of next for the next page of results.
    Set to the value of previous for the previous page of results.
    No other parameters can be set when the pagination token is set.

    """

    expand: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    metadata: Annotated[
        Optional[Dict[str, str]],
        FieldMetadata(query=QueryParamMetadata(style="deepObject", explode=True)),
    ] = None
    r"""Filter wallets by metadata key value pairs. Nested objects can be used as seen in the example below."""

    name: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter on wallet name"""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="pageSize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 15
    r"""The maximum number of results to return per page"""


class ListWalletsResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    list_wallets_response: NotRequired[
        shared_listwalletsresponse.ListWalletsResponseTypedDict
    ]
    r"""OK"""


class ListWalletsResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    list_wallets_response: Optional[shared_listwalletsresponse.ListWalletsResponse] = (
        None
    )
    r"""OK"""
