"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3paymentadjustment import V3PaymentAdjustment, V3PaymentAdjustmentTypedDict
from .v3paymentstatusenum import V3PaymentStatusEnum
from .v3paymenttypeenum import V3PaymentTypeEnum
from datetime import datetime
from formance_sdk_python.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from formance_sdk_python.utils import validate_int
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import BeforeValidator
from typing import Dict, List
from typing_extensions import Annotated, NotRequired, TypedDict


class V3PaymentTypedDict(TypedDict):
    amount: int
    asset: str
    connector_id: str
    created_at: datetime
    id: str
    initial_amount: int
    provider: str
    reference: str
    scheme: str
    status: V3PaymentStatusEnum
    type: V3PaymentTypeEnum
    adjustments: NotRequired[Nullable[List[V3PaymentAdjustmentTypedDict]]]
    destination_account_id: NotRequired[Nullable[str]]
    metadata: NotRequired[Nullable[Dict[str, str]]]
    source_account_id: NotRequired[Nullable[str]]


class V3Payment(BaseModel):
    amount: Annotated[int, BeforeValidator(validate_int)]

    asset: str

    connector_id: Annotated[str, pydantic.Field(alias="connectorID")]

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]

    id: str

    initial_amount: Annotated[
        Annotated[int, BeforeValidator(validate_int)],
        pydantic.Field(alias="initialAmount"),
    ]

    provider: str

    reference: str

    scheme: str

    status: V3PaymentStatusEnum

    type: V3PaymentTypeEnum

    adjustments: OptionalNullable[List[V3PaymentAdjustment]] = UNSET

    destination_account_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="destinationAccountID")
    ] = UNSET

    metadata: OptionalNullable[Dict[str, str]] = UNSET

    source_account_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="sourceAccountID")
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "adjustments",
            "destinationAccountID",
            "metadata",
            "sourceAccountID",
        ]
        nullable_fields = [
            "adjustments",
            "destinationAccountID",
            "metadata",
            "sourceAccountID",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
