"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from formance_sdk_python import utils
from formance_sdk_python.types import BaseModel
import pydantic
from typing_extensions import Annotated


class V2ErrorErrorCode(str, Enum):
    VALIDATION = "VALIDATION"
    NOT_FOUND = "NOT_FOUND"
    INTERNAL = "INTERNAL"


class V2ErrorData(BaseModel):
    error_code: Annotated[V2ErrorErrorCode, pydantic.Field(alias="errorCode")]

    error_message: Annotated[str, pydantic.Field(alias="errorMessage")]


class V2Error(Exception):
    r"""General error"""

    data: V2ErrorData

    def __init__(self, data: V2ErrorData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, V2ErrorData)
