"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    bankaccountresponse as shared_bankaccountresponse,
    forwardbankaccountrequest as shared_forwardbankaccountrequest,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ForwardBankAccountRequestTypedDict(TypedDict):
    forward_bank_account_request: (
        shared_forwardbankaccountrequest.ForwardBankAccountRequestTypedDict
    )
    bank_account_id: str
    r"""The bank account ID."""


class ForwardBankAccountRequest(BaseModel):
    forward_bank_account_request: Annotated[
        shared_forwardbankaccountrequest.ForwardBankAccountRequest,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    bank_account_id: Annotated[
        str,
        pydantic.Field(alias="bankAccountId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The bank account ID."""


class ForwardBankAccountResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    bank_account_response: NotRequired[
        shared_bankaccountresponse.BankAccountResponseTypedDict
    ]
    r"""OK"""


class ForwardBankAccountResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    bank_account_response: Optional[shared_bankaccountresponse.BankAccountResponse] = (
        None
    )
    r"""OK"""
