"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AtlarConfigTypedDict(TypedDict):
    access_key: str
    r"""The access key used by the connector for authorizing requests to the Atlar API.
    You can obtain it along with the associated secret from the Atlar dashboard.

    """
    name: str
    secret: str
    r"""The secret used by the connector for authorizing requests to the Atlar API.
    You can obtain it along with the associated access key from the Atlar dashboard.

    """
    base_url: NotRequired[str]
    r"""The base URL the client uses for making requests towards the Atlar API.

    """
    page_size: NotRequired[int]
    r"""Number of items to fetch when querying paginated APIs.

    """
    polling_period: NotRequired[str]
    r"""The frequency at which the connector tries to fetch new Transaction objects from the Atlar API.

    """
    provider: NotRequired[str]
    transfer_initiation_status_polling_period: NotRequired[str]
    r"""The frequency at which the connector tries to fetch the status of payment initiations from the Atlar API.

    """


class AtlarConfig(BaseModel):
    access_key: Annotated[str, pydantic.Field(alias="accessKey")]
    r"""The access key used by the connector for authorizing requests to the Atlar API.
    You can obtain it along with the associated secret from the Atlar dashboard.

    """

    name: str

    secret: str
    r"""The secret used by the connector for authorizing requests to the Atlar API.
    You can obtain it along with the associated access key from the Atlar dashboard.

    """

    base_url: Annotated[Optional[str], pydantic.Field(alias="baseUrl")] = (
        "https://api.atlar.com"
    )
    r"""The base URL the client uses for making requests towards the Atlar API.

    """

    page_size: Annotated[Optional[int], pydantic.Field(alias="pageSize")] = 25
    r"""Number of items to fetch when querying paginated APIs.

    """

    polling_period: Annotated[Optional[str], pydantic.Field(alias="pollingPeriod")] = (
        "120s"
    )
    r"""The frequency at which the connector tries to fetch new Transaction objects from the Atlar API.

    """

    provider: Optional[str] = "Atlar"

    transfer_initiation_status_polling_period: Annotated[
        Optional[str], pydantic.Field(alias="transferInitiationStatusPollingPeriod")
    ] = "120s"
    r"""The frequency at which the connector tries to fetch the status of payment initiations from the Atlar API.

    """
