"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .paymentscheme import PaymentScheme
from .paymentstatus import PaymentStatus
from .paymenttype import PaymentType
from datetime import datetime
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import validate_int
import pydantic
from pydantic.functional_validators import BeforeValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentRequestTypedDict(TypedDict):
    amount: int
    asset: str
    connector_id: str
    created_at: datetime
    reference: str
    scheme: PaymentScheme
    status: PaymentStatus
    type: PaymentType
    destination_account_id: NotRequired[str]
    source_account_id: NotRequired[str]


class PaymentRequest(BaseModel):
    amount: Annotated[int, BeforeValidator(validate_int)]

    asset: str

    connector_id: Annotated[str, pydantic.Field(alias="connectorID")]

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]

    reference: str

    scheme: PaymentScheme

    status: PaymentStatus

    type: PaymentType

    destination_account_id: Annotated[
        Optional[str], pydantic.Field(alias="destinationAccountID")
    ] = None

    source_account_id: Annotated[
        Optional[str], pydantic.Field(alias="sourceAccountID")
    ] = None
